/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/cloudquotas/v1/resources.proto

// Protobuf Java Version: 3.25.8
package com.google.api.cloudquotas.v1;

/**
 *
 *
 * <pre>
 * QuotaInfo represents information about a particular quota for a given
 * project, folder or organization.
 * </pre>
 *
 * Protobuf type {@code google.api.cloudquotas.v1.QuotaInfo}
 */
public final class QuotaInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.cloudquotas.v1.QuotaInfo)
    QuotaInfoOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use QuotaInfo.newBuilder() to construct.
  private QuotaInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private QuotaInfo() {
    name_ = "";
    quotaId_ = "";
    metric_ = "";
    service_ = "";
    refreshInterval_ = "";
    containerType_ = 0;
    dimensions_ = com.google.protobuf.LazyStringArrayList.emptyList();
    metricDisplayName_ = "";
    quotaDisplayName_ = "";
    metricUnit_ = "";
    dimensionsInfos_ = java.util.Collections.emptyList();
    serviceRequestQuotaUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new QuotaInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.cloudquotas.v1.ResourcesProto
        .internal_static_google_api_cloudquotas_v1_QuotaInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.cloudquotas.v1.ResourcesProto
        .internal_static_google_api_cloudquotas_v1_QuotaInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.cloudquotas.v1.QuotaInfo.class,
            com.google.api.cloudquotas.v1.QuotaInfo.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The enumeration of the types of a cloud resource container.
   * </pre>
   *
   * Protobuf enum {@code google.api.cloudquotas.v1.QuotaInfo.ContainerType}
   */
  public enum ContainerType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified container type.
     * </pre>
     *
     * <code>CONTAINER_TYPE_UNSPECIFIED = 0;</code>
     */
    CONTAINER_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * consumer project
     * </pre>
     *
     * <code>PROJECT = 1;</code>
     */
    PROJECT(1),
    /**
     *
     *
     * <pre>
     * folder
     * </pre>
     *
     * <code>FOLDER = 2;</code>
     */
    FOLDER(2),
    /**
     *
     *
     * <pre>
     * organization
     * </pre>
     *
     * <code>ORGANIZATION = 3;</code>
     */
    ORGANIZATION(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified container type.
     * </pre>
     *
     * <code>CONTAINER_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int CONTAINER_TYPE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * consumer project
     * </pre>
     *
     * <code>PROJECT = 1;</code>
     */
    public static final int PROJECT_VALUE = 1;

    /**
     *
     *
     * <pre>
     * folder
     * </pre>
     *
     * <code>FOLDER = 2;</code>
     */
    public static final int FOLDER_VALUE = 2;

    /**
     *
     *
     * <pre>
     * organization
     * </pre>
     *
     * <code>ORGANIZATION = 3;</code>
     */
    public static final int ORGANIZATION_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ContainerType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ContainerType forNumber(int value) {
      switch (value) {
        case 0:
          return CONTAINER_TYPE_UNSPECIFIED;
        case 1:
          return PROJECT;
        case 2:
          return FOLDER;
        case 3:
          return ORGANIZATION;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ContainerType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ContainerType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ContainerType>() {
          public ContainerType findValueByNumber(int number) {
            return ContainerType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.api.cloudquotas.v1.QuotaInfo.getDescriptor().getEnumTypes().get(0);
    }

    private static final ContainerType[] VALUES = values();

    public static ContainerType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ContainerType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.api.cloudquotas.v1.QuotaInfo.ContainerType)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Resource name of this QuotaInfo.
   * The ID component following "locations/" must be "global".
   * Example:
   * `projects/123/locations/global/services/compute.googleapis.com/quotaInfos/CpusPerProjectPerRegion`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Resource name of this QuotaInfo.
   * The ID component following "locations/" must be "global".
   * Example:
   * `projects/123/locations/global/services/compute.googleapis.com/quotaInfos/CpusPerProjectPerRegion`
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUOTA_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object quotaId_ = "";

  /**
   *
   *
   * <pre>
   * The id of the quota, which is unquie within the service.
   * Example: `CpusPerProjectPerRegion`
   * </pre>
   *
   * <code>string quota_id = 2;</code>
   *
   * @return The quotaId.
   */
  @java.lang.Override
  public java.lang.String getQuotaId() {
    java.lang.Object ref = quotaId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      quotaId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The id of the quota, which is unquie within the service.
   * Example: `CpusPerProjectPerRegion`
   * </pre>
   *
   * <code>string quota_id = 2;</code>
   *
   * @return The bytes for quotaId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQuotaIdBytes() {
    java.lang.Object ref = quotaId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      quotaId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METRIC_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object metric_ = "";

  /**
   *
   *
   * <pre>
   * The metric of the quota. It specifies the resources consumption the quota
   * is defined for.
   * Example: `compute.googleapis.com/cpus`
   * </pre>
   *
   * <code>string metric = 3;</code>
   *
   * @return The metric.
   */
  @java.lang.Override
  public java.lang.String getMetric() {
    java.lang.Object ref = metric_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      metric_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The metric of the quota. It specifies the resources consumption the quota
   * is defined for.
   * Example: `compute.googleapis.com/cpus`
   * </pre>
   *
   * <code>string metric = 3;</code>
   *
   * @return The bytes for metric.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMetricBytes() {
    java.lang.Object ref = metric_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      metric_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SERVICE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object service_ = "";

  /**
   *
   *
   * <pre>
   * The name of the service in which the quota is defined.
   * Example: `compute.googleapis.com`
   * </pre>
   *
   * <code>string service = 4;</code>
   *
   * @return The service.
   */
  @java.lang.Override
  public java.lang.String getService() {
    java.lang.Object ref = service_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      service_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The name of the service in which the quota is defined.
   * Example: `compute.googleapis.com`
   * </pre>
   *
   * <code>string service = 4;</code>
   *
   * @return The bytes for service.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceBytes() {
    java.lang.Object ref = service_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      service_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IS_PRECISE_FIELD_NUMBER = 5;
  private boolean isPrecise_ = false;

  /**
   *
   *
   * <pre>
   * Whether this is a precise quota. A precise quota is tracked with absolute
   * precision. In contrast, an imprecise quota is not tracked with precision.
   * </pre>
   *
   * <code>bool is_precise = 5;</code>
   *
   * @return The isPrecise.
   */
  @java.lang.Override
  public boolean getIsPrecise() {
    return isPrecise_;
  }

  public static final int REFRESH_INTERVAL_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object refreshInterval_ = "";

  /**
   *
   *
   * <pre>
   * The reset time interval for the quota. Refresh interval applies to rate
   * quota only.
   * Example: "minute" for per minute, "day" for per day, or "10 seconds" for
   * every 10 seconds.
   * </pre>
   *
   * <code>string refresh_interval = 6;</code>
   *
   * @return The refreshInterval.
   */
  @java.lang.Override
  public java.lang.String getRefreshInterval() {
    java.lang.Object ref = refreshInterval_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      refreshInterval_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The reset time interval for the quota. Refresh interval applies to rate
   * quota only.
   * Example: "minute" for per minute, "day" for per day, or "10 seconds" for
   * every 10 seconds.
   * </pre>
   *
   * <code>string refresh_interval = 6;</code>
   *
   * @return The bytes for refreshInterval.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRefreshIntervalBytes() {
    java.lang.Object ref = refreshInterval_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      refreshInterval_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTAINER_TYPE_FIELD_NUMBER = 7;
  private int containerType_ = 0;

  /**
   *
   *
   * <pre>
   * The container type of the QuotaInfo.
   * </pre>
   *
   * <code>.google.api.cloudquotas.v1.QuotaInfo.ContainerType container_type = 7;</code>
   *
   * @return The enum numeric value on the wire for containerType.
   */
  @java.lang.Override
  public int getContainerTypeValue() {
    return containerType_;
  }

  /**
   *
   *
   * <pre>
   * The container type of the QuotaInfo.
   * </pre>
   *
   * <code>.google.api.cloudquotas.v1.QuotaInfo.ContainerType container_type = 7;</code>
   *
   * @return The containerType.
   */
  @java.lang.Override
  public com.google.api.cloudquotas.v1.QuotaInfo.ContainerType getContainerType() {
    com.google.api.cloudquotas.v1.QuotaInfo.ContainerType result =
        com.google.api.cloudquotas.v1.QuotaInfo.ContainerType.forNumber(containerType_);
    return result == null
        ? com.google.api.cloudquotas.v1.QuotaInfo.ContainerType.UNRECOGNIZED
        : result;
  }

  public static final int DIMENSIONS_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList dimensions_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * The dimensions the quota is defined on.
   * </pre>
   *
   * <code>repeated string dimensions = 8;</code>
   *
   * @return A list containing the dimensions.
   */
  public com.google.protobuf.ProtocolStringList getDimensionsList() {
    return dimensions_;
  }

  /**
   *
   *
   * <pre>
   * The dimensions the quota is defined on.
   * </pre>
   *
   * <code>repeated string dimensions = 8;</code>
   *
   * @return The count of dimensions.
   */
  public int getDimensionsCount() {
    return dimensions_.size();
  }

  /**
   *
   *
   * <pre>
   * The dimensions the quota is defined on.
   * </pre>
   *
   * <code>repeated string dimensions = 8;</code>
   *
   * @param index The index of the element to return.
   * @return The dimensions at the given index.
   */
  public java.lang.String getDimensions(int index) {
    return dimensions_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The dimensions the quota is defined on.
   * </pre>
   *
   * <code>repeated string dimensions = 8;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the dimensions at the given index.
   */
  public com.google.protobuf.ByteString getDimensionsBytes(int index) {
    return dimensions_.getByteString(index);
  }

  public static final int METRIC_DISPLAY_NAME_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object metricDisplayName_ = "";

  /**
   *
   *
   * <pre>
   * The display name of the quota metric
   * </pre>
   *
   * <code>string metric_display_name = 9;</code>
   *
   * @return The metricDisplayName.
   */
  @java.lang.Override
  public java.lang.String getMetricDisplayName() {
    java.lang.Object ref = metricDisplayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      metricDisplayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The display name of the quota metric
   * </pre>
   *
   * <code>string metric_display_name = 9;</code>
   *
   * @return The bytes for metricDisplayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMetricDisplayNameBytes() {
    java.lang.Object ref = metricDisplayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      metricDisplayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUOTA_DISPLAY_NAME_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object quotaDisplayName_ = "";

  /**
   *
   *
   * <pre>
   * The display name of the quota.
   * </pre>
   *
   * <code>string quota_display_name = 10;</code>
   *
   * @return The quotaDisplayName.
   */
  @java.lang.Override
  public java.lang.String getQuotaDisplayName() {
    java.lang.Object ref = quotaDisplayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      quotaDisplayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The display name of the quota.
   * </pre>
   *
   * <code>string quota_display_name = 10;</code>
   *
   * @return The bytes for quotaDisplayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQuotaDisplayNameBytes() {
    java.lang.Object ref = quotaDisplayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      quotaDisplayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METRIC_UNIT_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object metricUnit_ = "";

  /**
   *
   *
   * <pre>
   * The unit in which the metric value is reported, e.g., "MByte".
   * </pre>
   *
   * <code>string metric_unit = 11;</code>
   *
   * @return The metricUnit.
   */
  @java.lang.Override
  public java.lang.String getMetricUnit() {
    java.lang.Object ref = metricUnit_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      metricUnit_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The unit in which the metric value is reported, e.g., "MByte".
   * </pre>
   *
   * <code>string metric_unit = 11;</code>
   *
   * @return The bytes for metricUnit.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMetricUnitBytes() {
    java.lang.Object ref = metricUnit_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      metricUnit_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUOTA_INCREASE_ELIGIBILITY_FIELD_NUMBER = 12;
  private com.google.api.cloudquotas.v1.QuotaIncreaseEligibility quotaIncreaseEligibility_;

  /**
   *
   *
   * <pre>
   * Whether it is eligible to request a higher quota value for this quota.
   * </pre>
   *
   * <code>.google.api.cloudquotas.v1.QuotaIncreaseEligibility quota_increase_eligibility = 12;
   * </code>
   *
   * @return Whether the quotaIncreaseEligibility field is set.
   */
  @java.lang.Override
  public boolean hasQuotaIncreaseEligibility() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Whether it is eligible to request a higher quota value for this quota.
   * </pre>
   *
   * <code>.google.api.cloudquotas.v1.QuotaIncreaseEligibility quota_increase_eligibility = 12;
   * </code>
   *
   * @return The quotaIncreaseEligibility.
   */
  @java.lang.Override
  public com.google.api.cloudquotas.v1.QuotaIncreaseEligibility getQuotaIncreaseEligibility() {
    return quotaIncreaseEligibility_ == null
        ? com.google.api.cloudquotas.v1.QuotaIncreaseEligibility.getDefaultInstance()
        : quotaIncreaseEligibility_;
  }

  /**
   *
   *
   * <pre>
   * Whether it is eligible to request a higher quota value for this quota.
   * </pre>
   *
   * <code>.google.api.cloudquotas.v1.QuotaIncreaseEligibility quota_increase_eligibility = 12;
   * </code>
   */
  @java.lang.Override
  public com.google.api.cloudquotas.v1.QuotaIncreaseEligibilityOrBuilder
      getQuotaIncreaseEligibilityOrBuilder() {
    return quotaIncreaseEligibility_ == null
        ? com.google.api.cloudquotas.v1.QuotaIncreaseEligibility.getDefaultInstance()
        : quotaIncreaseEligibility_;
  }

  public static final int IS_FIXED_FIELD_NUMBER = 13;
  private boolean isFixed_ = false;

  /**
   *
   *
   * <pre>
   * Whether the quota value is fixed or adjustable
   * </pre>
   *
   * <code>bool is_fixed = 13;</code>
   *
   * @return The isFixed.
   */
  @java.lang.Override
  public boolean getIsFixed() {
    return isFixed_;
  }

  public static final int DIMENSIONS_INFOS_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private java.util.List<com.google.api.cloudquotas.v1.DimensionsInfo> dimensionsInfos_;

  /**
   *
   *
   * <pre>
   * The collection of dimensions info ordered by their dimensions from more
   * specific ones to less specific ones.
   * </pre>
   *
   * <code>repeated .google.api.cloudquotas.v1.DimensionsInfo dimensions_infos = 14;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.api.cloudquotas.v1.DimensionsInfo> getDimensionsInfosList() {
    return dimensionsInfos_;
  }

  /**
   *
   *
   * <pre>
   * The collection of dimensions info ordered by their dimensions from more
   * specific ones to less specific ones.
   * </pre>
   *
   * <code>repeated .google.api.cloudquotas.v1.DimensionsInfo dimensions_infos = 14;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.api.cloudquotas.v1.DimensionsInfoOrBuilder>
      getDimensionsInfosOrBuilderList() {
    return dimensionsInfos_;
  }

  /**
   *
   *
   * <pre>
   * The collection of dimensions info ordered by their dimensions from more
   * specific ones to less specific ones.
   * </pre>
   *
   * <code>repeated .google.api.cloudquotas.v1.DimensionsInfo dimensions_infos = 14;</code>
   */
  @java.lang.Override
  public int getDimensionsInfosCount() {
    return dimensionsInfos_.size();
  }

  /**
   *
   *
   * <pre>
   * The collection of dimensions info ordered by their dimensions from more
   * specific ones to less specific ones.
   * </pre>
   *
   * <code>repeated .google.api.cloudquotas.v1.DimensionsInfo dimensions_infos = 14;</code>
   */
  @java.lang.Override
  public com.google.api.cloudquotas.v1.DimensionsInfo getDimensionsInfos(int index) {
    return dimensionsInfos_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The collection of dimensions info ordered by their dimensions from more
   * specific ones to less specific ones.
   * </pre>
   *
   * <code>repeated .google.api.cloudquotas.v1.DimensionsInfo dimensions_infos = 14;</code>
   */
  @java.lang.Override
  public com.google.api.cloudquotas.v1.DimensionsInfoOrBuilder getDimensionsInfosOrBuilder(
      int index) {
    return dimensionsInfos_.get(index);
  }

  public static final int IS_CONCURRENT_FIELD_NUMBER = 15;
  private boolean isConcurrent_ = false;

  /**
   *
   *
   * <pre>
   * Whether the quota is a concurrent quota. Concurrent quotas are enforced
   * on the total number of concurrent operations in flight at any given time.
   * </pre>
   *
   * <code>bool is_concurrent = 15;</code>
   *
   * @return The isConcurrent.
   */
  @java.lang.Override
  public boolean getIsConcurrent() {
    return isConcurrent_;
  }

  public static final int SERVICE_REQUEST_QUOTA_URI_FIELD_NUMBER = 17;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceRequestQuotaUri_ = "";

  /**
   *
   *
   * <pre>
   * URI to the page where users can request more quota for the cloud
   * service—for example,
   * https://console.cloud.google.com/iam-admin/quotas.
   * </pre>
   *
   * <code>string service_request_quota_uri = 17;</code>
   *
   * @return The serviceRequestQuotaUri.
   */
  @java.lang.Override
  public java.lang.String getServiceRequestQuotaUri() {
    java.lang.Object ref = serviceRequestQuotaUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceRequestQuotaUri_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * URI to the page where users can request more quota for the cloud
   * service—for example,
   * https://console.cloud.google.com/iam-admin/quotas.
   * </pre>
   *
   * <code>string service_request_quota_uri = 17;</code>
   *
   * @return The bytes for serviceRequestQuotaUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceRequestQuotaUriBytes() {
    java.lang.Object ref = serviceRequestQuotaUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceRequestQuotaUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(quotaId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, quotaId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metric_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, metric_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, service_);
    }
    if (isPrecise_ != false) {
      output.writeBool(5, isPrecise_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(refreshInterval_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, refreshInterval_);
    }
    if (containerType_
        != com.google.api.cloudquotas.v1.QuotaInfo.ContainerType.CONTAINER_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, containerType_);
    }
    for (int i = 0; i < dimensions_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, dimensions_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metricDisplayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, metricDisplayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(quotaDisplayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, quotaDisplayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metricUnit_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, metricUnit_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(12, getQuotaIncreaseEligibility());
    }
    if (isFixed_ != false) {
      output.writeBool(13, isFixed_);
    }
    for (int i = 0; i < dimensionsInfos_.size(); i++) {
      output.writeMessage(14, dimensionsInfos_.get(i));
    }
    if (isConcurrent_ != false) {
      output.writeBool(15, isConcurrent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceRequestQuotaUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 17, serviceRequestQuotaUri_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(quotaId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, quotaId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metric_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, metric_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(service_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, service_);
    }
    if (isPrecise_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, isPrecise_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(refreshInterval_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, refreshInterval_);
    }
    if (containerType_
        != com.google.api.cloudquotas.v1.QuotaInfo.ContainerType.CONTAINER_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, containerType_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < dimensions_.size(); i++) {
        dataSize += computeStringSizeNoTag(dimensions_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getDimensionsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metricDisplayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, metricDisplayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(quotaDisplayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, quotaDisplayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metricUnit_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, metricUnit_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              12, getQuotaIncreaseEligibility());
    }
    if (isFixed_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(13, isFixed_);
    }
    for (int i = 0; i < dimensionsInfos_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, dimensionsInfos_.get(i));
    }
    if (isConcurrent_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(15, isConcurrent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serviceRequestQuotaUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(17, serviceRequestQuotaUri_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.cloudquotas.v1.QuotaInfo)) {
      return super.equals(obj);
    }
    com.google.api.cloudquotas.v1.QuotaInfo other = (com.google.api.cloudquotas.v1.QuotaInfo) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getQuotaId().equals(other.getQuotaId())) return false;
    if (!getMetric().equals(other.getMetric())) return false;
    if (!getService().equals(other.getService())) return false;
    if (getIsPrecise() != other.getIsPrecise()) return false;
    if (!getRefreshInterval().equals(other.getRefreshInterval())) return false;
    if (containerType_ != other.containerType_) return false;
    if (!getDimensionsList().equals(other.getDimensionsList())) return false;
    if (!getMetricDisplayName().equals(other.getMetricDisplayName())) return false;
    if (!getQuotaDisplayName().equals(other.getQuotaDisplayName())) return false;
    if (!getMetricUnit().equals(other.getMetricUnit())) return false;
    if (hasQuotaIncreaseEligibility() != other.hasQuotaIncreaseEligibility()) return false;
    if (hasQuotaIncreaseEligibility()) {
      if (!getQuotaIncreaseEligibility().equals(other.getQuotaIncreaseEligibility())) return false;
    }
    if (getIsFixed() != other.getIsFixed()) return false;
    if (!getDimensionsInfosList().equals(other.getDimensionsInfosList())) return false;
    if (getIsConcurrent() != other.getIsConcurrent()) return false;
    if (!getServiceRequestQuotaUri().equals(other.getServiceRequestQuotaUri())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + QUOTA_ID_FIELD_NUMBER;
    hash = (53 * hash) + getQuotaId().hashCode();
    hash = (37 * hash) + METRIC_FIELD_NUMBER;
    hash = (53 * hash) + getMetric().hashCode();
    hash = (37 * hash) + SERVICE_FIELD_NUMBER;
    hash = (53 * hash) + getService().hashCode();
    hash = (37 * hash) + IS_PRECISE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsPrecise());
    hash = (37 * hash) + REFRESH_INTERVAL_FIELD_NUMBER;
    hash = (53 * hash) + getRefreshInterval().hashCode();
    hash = (37 * hash) + CONTAINER_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + containerType_;
    if (getDimensionsCount() > 0) {
      hash = (37 * hash) + DIMENSIONS_FIELD_NUMBER;
      hash = (53 * hash) + getDimensionsList().hashCode();
    }
    hash = (37 * hash) + METRIC_DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getMetricDisplayName().hashCode();
    hash = (37 * hash) + QUOTA_DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getQuotaDisplayName().hashCode();
    hash = (37 * hash) + METRIC_UNIT_FIELD_NUMBER;
    hash = (53 * hash) + getMetricUnit().hashCode();
    if (hasQuotaIncreaseEligibility()) {
      hash = (37 * hash) + QUOTA_INCREASE_ELIGIBILITY_FIELD_NUMBER;
      hash = (53 * hash) + getQuotaIncreaseEligibility().hashCode();
    }
    hash = (37 * hash) + IS_FIXED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsFixed());
    if (getDimensionsInfosCount() > 0) {
      hash = (37 * hash) + DIMENSIONS_INFOS_FIELD_NUMBER;
      hash = (53 * hash) + getDimensionsInfosList().hashCode();
    }
    hash = (37 * hash) + IS_CONCURRENT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsConcurrent());
    hash = (37 * hash) + SERVICE_REQUEST_QUOTA_URI_FIELD_NUMBER;
    hash = (53 * hash) + getServiceRequestQuotaUri().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.cloudquotas.v1.QuotaInfo parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.cloudquotas.v1.QuotaInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.cloudquotas.v1.QuotaInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.cloudquotas.v1.QuotaInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.cloudquotas.v1.QuotaInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.cloudquotas.v1.QuotaInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.cloudquotas.v1.QuotaInfo parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.cloudquotas.v1.QuotaInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.cloudquotas.v1.QuotaInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.cloudquotas.v1.QuotaInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.cloudquotas.v1.QuotaInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.cloudquotas.v1.QuotaInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.api.cloudquotas.v1.QuotaInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * QuotaInfo represents information about a particular quota for a given
   * project, folder or organization.
   * </pre>
   *
   * Protobuf type {@code google.api.cloudquotas.v1.QuotaInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.cloudquotas.v1.QuotaInfo)
      com.google.api.cloudquotas.v1.QuotaInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.cloudquotas.v1.ResourcesProto
          .internal_static_google_api_cloudquotas_v1_QuotaInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.cloudquotas.v1.ResourcesProto
          .internal_static_google_api_cloudquotas_v1_QuotaInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.cloudquotas.v1.QuotaInfo.class,
              com.google.api.cloudquotas.v1.QuotaInfo.Builder.class);
    }

    // Construct using com.google.api.cloudquotas.v1.QuotaInfo.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getQuotaIncreaseEligibilityFieldBuilder();
        getDimensionsInfosFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      quotaId_ = "";
      metric_ = "";
      service_ = "";
      isPrecise_ = false;
      refreshInterval_ = "";
      containerType_ = 0;
      dimensions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      metricDisplayName_ = "";
      quotaDisplayName_ = "";
      metricUnit_ = "";
      quotaIncreaseEligibility_ = null;
      if (quotaIncreaseEligibilityBuilder_ != null) {
        quotaIncreaseEligibilityBuilder_.dispose();
        quotaIncreaseEligibilityBuilder_ = null;
      }
      isFixed_ = false;
      if (dimensionsInfosBuilder_ == null) {
        dimensionsInfos_ = java.util.Collections.emptyList();
      } else {
        dimensionsInfos_ = null;
        dimensionsInfosBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00002000);
      isConcurrent_ = false;
      serviceRequestQuotaUri_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.cloudquotas.v1.ResourcesProto
          .internal_static_google_api_cloudquotas_v1_QuotaInfo_descriptor;
    }

    @java.lang.Override
    public com.google.api.cloudquotas.v1.QuotaInfo getDefaultInstanceForType() {
      return com.google.api.cloudquotas.v1.QuotaInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.cloudquotas.v1.QuotaInfo build() {
      com.google.api.cloudquotas.v1.QuotaInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.cloudquotas.v1.QuotaInfo buildPartial() {
      com.google.api.cloudquotas.v1.QuotaInfo result =
          new com.google.api.cloudquotas.v1.QuotaInfo(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.api.cloudquotas.v1.QuotaInfo result) {
      if (dimensionsInfosBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)) {
          dimensionsInfos_ = java.util.Collections.unmodifiableList(dimensionsInfos_);
          bitField0_ = (bitField0_ & ~0x00002000);
        }
        result.dimensionsInfos_ = dimensionsInfos_;
      } else {
        result.dimensionsInfos_ = dimensionsInfosBuilder_.build();
      }
    }

    private void buildPartial0(com.google.api.cloudquotas.v1.QuotaInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.quotaId_ = quotaId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.metric_ = metric_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.service_ = service_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.isPrecise_ = isPrecise_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.refreshInterval_ = refreshInterval_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.containerType_ = containerType_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        dimensions_.makeImmutable();
        result.dimensions_ = dimensions_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.metricDisplayName_ = metricDisplayName_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.quotaDisplayName_ = quotaDisplayName_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.metricUnit_ = metricUnit_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.quotaIncreaseEligibility_ =
            quotaIncreaseEligibilityBuilder_ == null
                ? quotaIncreaseEligibility_
                : quotaIncreaseEligibilityBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.isFixed_ = isFixed_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.isConcurrent_ = isConcurrent_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.serviceRequestQuotaUri_ = serviceRequestQuotaUri_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.cloudquotas.v1.QuotaInfo) {
        return mergeFrom((com.google.api.cloudquotas.v1.QuotaInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.cloudquotas.v1.QuotaInfo other) {
      if (other == com.google.api.cloudquotas.v1.QuotaInfo.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getQuotaId().isEmpty()) {
        quotaId_ = other.quotaId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getMetric().isEmpty()) {
        metric_ = other.metric_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getService().isEmpty()) {
        service_ = other.service_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.getIsPrecise() != false) {
        setIsPrecise(other.getIsPrecise());
      }
      if (!other.getRefreshInterval().isEmpty()) {
        refreshInterval_ = other.refreshInterval_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.containerType_ != 0) {
        setContainerTypeValue(other.getContainerTypeValue());
      }
      if (!other.dimensions_.isEmpty()) {
        if (dimensions_.isEmpty()) {
          dimensions_ = other.dimensions_;
          bitField0_ |= 0x00000080;
        } else {
          ensureDimensionsIsMutable();
          dimensions_.addAll(other.dimensions_);
        }
        onChanged();
      }
      if (!other.getMetricDisplayName().isEmpty()) {
        metricDisplayName_ = other.metricDisplayName_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (!other.getQuotaDisplayName().isEmpty()) {
        quotaDisplayName_ = other.quotaDisplayName_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (!other.getMetricUnit().isEmpty()) {
        metricUnit_ = other.metricUnit_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.hasQuotaIncreaseEligibility()) {
        mergeQuotaIncreaseEligibility(other.getQuotaIncreaseEligibility());
      }
      if (other.getIsFixed() != false) {
        setIsFixed(other.getIsFixed());
      }
      if (dimensionsInfosBuilder_ == null) {
        if (!other.dimensionsInfos_.isEmpty()) {
          if (dimensionsInfos_.isEmpty()) {
            dimensionsInfos_ = other.dimensionsInfos_;
            bitField0_ = (bitField0_ & ~0x00002000);
          } else {
            ensureDimensionsInfosIsMutable();
            dimensionsInfos_.addAll(other.dimensionsInfos_);
          }
          onChanged();
        }
      } else {
        if (!other.dimensionsInfos_.isEmpty()) {
          if (dimensionsInfosBuilder_.isEmpty()) {
            dimensionsInfosBuilder_.dispose();
            dimensionsInfosBuilder_ = null;
            dimensionsInfos_ = other.dimensionsInfos_;
            bitField0_ = (bitField0_ & ~0x00002000);
            dimensionsInfosBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDimensionsInfosFieldBuilder()
                    : null;
          } else {
            dimensionsInfosBuilder_.addAllMessages(other.dimensionsInfos_);
          }
        }
      }
      if (other.getIsConcurrent() != false) {
        setIsConcurrent(other.getIsConcurrent());
      }
      if (!other.getServiceRequestQuotaUri().isEmpty()) {
        serviceRequestQuotaUri_ = other.serviceRequestQuotaUri_;
        bitField0_ |= 0x00008000;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                quotaId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                metric_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                service_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                isPrecise_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                refreshInterval_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 56:
              {
                containerType_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 66:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureDimensionsIsMutable();
                dimensions_.add(s);
                break;
              } // case 66
            case 74:
              {
                metricDisplayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                quotaDisplayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                metricUnit_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(
                    getQuotaIncreaseEligibilityFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 104:
              {
                isFixed_ = input.readBool();
                bitField0_ |= 0x00001000;
                break;
              } // case 104
            case 114:
              {
                com.google.api.cloudquotas.v1.DimensionsInfo m =
                    input.readMessage(
                        com.google.api.cloudquotas.v1.DimensionsInfo.parser(), extensionRegistry);
                if (dimensionsInfosBuilder_ == null) {
                  ensureDimensionsInfosIsMutable();
                  dimensionsInfos_.add(m);
                } else {
                  dimensionsInfosBuilder_.addMessage(m);
                }
                break;
              } // case 114
            case 120:
              {
                isConcurrent_ = input.readBool();
                bitField0_ |= 0x00004000;
                break;
              } // case 120
            case 138:
              {
                serviceRequestQuotaUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00008000;
                break;
              } // case 138
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Resource name of this QuotaInfo.
     * The ID component following "locations/" must be "global".
     * Example:
     * `projects/123/locations/global/services/compute.googleapis.com/quotaInfos/CpusPerProjectPerRegion`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Resource name of this QuotaInfo.
     * The ID component following "locations/" must be "global".
     * Example:
     * `projects/123/locations/global/services/compute.googleapis.com/quotaInfos/CpusPerProjectPerRegion`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Resource name of this QuotaInfo.
     * The ID component following "locations/" must be "global".
     * Example:
     * `projects/123/locations/global/services/compute.googleapis.com/quotaInfos/CpusPerProjectPerRegion`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Resource name of this QuotaInfo.
     * The ID component following "locations/" must be "global".
     * Example:
     * `projects/123/locations/global/services/compute.googleapis.com/quotaInfos/CpusPerProjectPerRegion`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Resource name of this QuotaInfo.
     * The ID component following "locations/" must be "global".
     * Example:
     * `projects/123/locations/global/services/compute.googleapis.com/quotaInfos/CpusPerProjectPerRegion`
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object quotaId_ = "";

    /**
     *
     *
     * <pre>
     * The id of the quota, which is unquie within the service.
     * Example: `CpusPerProjectPerRegion`
     * </pre>
     *
     * <code>string quota_id = 2;</code>
     *
     * @return The quotaId.
     */
    public java.lang.String getQuotaId() {
      java.lang.Object ref = quotaId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        quotaId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The id of the quota, which is unquie within the service.
     * Example: `CpusPerProjectPerRegion`
     * </pre>
     *
     * <code>string quota_id = 2;</code>
     *
     * @return The bytes for quotaId.
     */
    public com.google.protobuf.ByteString getQuotaIdBytes() {
      java.lang.Object ref = quotaId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        quotaId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The id of the quota, which is unquie within the service.
     * Example: `CpusPerProjectPerRegion`
     * </pre>
     *
     * <code>string quota_id = 2;</code>
     *
     * @param value The quotaId to set.
     * @return This builder for chaining.
     */
    public Builder setQuotaId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      quotaId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The id of the quota, which is unquie within the service.
     * Example: `CpusPerProjectPerRegion`
     * </pre>
     *
     * <code>string quota_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQuotaId() {
      quotaId_ = getDefaultInstance().getQuotaId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The id of the quota, which is unquie within the service.
     * Example: `CpusPerProjectPerRegion`
     * </pre>
     *
     * <code>string quota_id = 2;</code>
     *
     * @param value The bytes for quotaId to set.
     * @return This builder for chaining.
     */
    public Builder setQuotaIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      quotaId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object metric_ = "";

    /**
     *
     *
     * <pre>
     * The metric of the quota. It specifies the resources consumption the quota
     * is defined for.
     * Example: `compute.googleapis.com/cpus`
     * </pre>
     *
     * <code>string metric = 3;</code>
     *
     * @return The metric.
     */
    public java.lang.String getMetric() {
      java.lang.Object ref = metric_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metric_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The metric of the quota. It specifies the resources consumption the quota
     * is defined for.
     * Example: `compute.googleapis.com/cpus`
     * </pre>
     *
     * <code>string metric = 3;</code>
     *
     * @return The bytes for metric.
     */
    public com.google.protobuf.ByteString getMetricBytes() {
      java.lang.Object ref = metric_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metric_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The metric of the quota. It specifies the resources consumption the quota
     * is defined for.
     * Example: `compute.googleapis.com/cpus`
     * </pre>
     *
     * <code>string metric = 3;</code>
     *
     * @param value The metric to set.
     * @return This builder for chaining.
     */
    public Builder setMetric(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      metric_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The metric of the quota. It specifies the resources consumption the quota
     * is defined for.
     * Example: `compute.googleapis.com/cpus`
     * </pre>
     *
     * <code>string metric = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetric() {
      metric_ = getDefaultInstance().getMetric();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The metric of the quota. It specifies the resources consumption the quota
     * is defined for.
     * Example: `compute.googleapis.com/cpus`
     * </pre>
     *
     * <code>string metric = 3;</code>
     *
     * @param value The bytes for metric to set.
     * @return This builder for chaining.
     */
    public Builder setMetricBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      metric_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object service_ = "";

    /**
     *
     *
     * <pre>
     * The name of the service in which the quota is defined.
     * Example: `compute.googleapis.com`
     * </pre>
     *
     * <code>string service = 4;</code>
     *
     * @return The service.
     */
    public java.lang.String getService() {
      java.lang.Object ref = service_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        service_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the service in which the quota is defined.
     * Example: `compute.googleapis.com`
     * </pre>
     *
     * <code>string service = 4;</code>
     *
     * @return The bytes for service.
     */
    public com.google.protobuf.ByteString getServiceBytes() {
      java.lang.Object ref = service_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        service_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the service in which the quota is defined.
     * Example: `compute.googleapis.com`
     * </pre>
     *
     * <code>string service = 4;</code>
     *
     * @param value The service to set.
     * @return This builder for chaining.
     */
    public Builder setService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      service_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of the service in which the quota is defined.
     * Example: `compute.googleapis.com`
     * </pre>
     *
     * <code>string service = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearService() {
      service_ = getDefaultInstance().getService();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of the service in which the quota is defined.
     * Example: `compute.googleapis.com`
     * </pre>
     *
     * <code>string service = 4;</code>
     *
     * @param value The bytes for service to set.
     * @return This builder for chaining.
     */
    public Builder setServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      service_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private boolean isPrecise_;

    /**
     *
     *
     * <pre>
     * Whether this is a precise quota. A precise quota is tracked with absolute
     * precision. In contrast, an imprecise quota is not tracked with precision.
     * </pre>
     *
     * <code>bool is_precise = 5;</code>
     *
     * @return The isPrecise.
     */
    @java.lang.Override
    public boolean getIsPrecise() {
      return isPrecise_;
    }

    /**
     *
     *
     * <pre>
     * Whether this is a precise quota. A precise quota is tracked with absolute
     * precision. In contrast, an imprecise quota is not tracked with precision.
     * </pre>
     *
     * <code>bool is_precise = 5;</code>
     *
     * @param value The isPrecise to set.
     * @return This builder for chaining.
     */
    public Builder setIsPrecise(boolean value) {

      isPrecise_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether this is a precise quota. A precise quota is tracked with absolute
     * precision. In contrast, an imprecise quota is not tracked with precision.
     * </pre>
     *
     * <code>bool is_precise = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsPrecise() {
      bitField0_ = (bitField0_ & ~0x00000010);
      isPrecise_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object refreshInterval_ = "";

    /**
     *
     *
     * <pre>
     * The reset time interval for the quota. Refresh interval applies to rate
     * quota only.
     * Example: "minute" for per minute, "day" for per day, or "10 seconds" for
     * every 10 seconds.
     * </pre>
     *
     * <code>string refresh_interval = 6;</code>
     *
     * @return The refreshInterval.
     */
    public java.lang.String getRefreshInterval() {
      java.lang.Object ref = refreshInterval_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        refreshInterval_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The reset time interval for the quota. Refresh interval applies to rate
     * quota only.
     * Example: "minute" for per minute, "day" for per day, or "10 seconds" for
     * every 10 seconds.
     * </pre>
     *
     * <code>string refresh_interval = 6;</code>
     *
     * @return The bytes for refreshInterval.
     */
    public com.google.protobuf.ByteString getRefreshIntervalBytes() {
      java.lang.Object ref = refreshInterval_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        refreshInterval_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The reset time interval for the quota. Refresh interval applies to rate
     * quota only.
     * Example: "minute" for per minute, "day" for per day, or "10 seconds" for
     * every 10 seconds.
     * </pre>
     *
     * <code>string refresh_interval = 6;</code>
     *
     * @param value The refreshInterval to set.
     * @return This builder for chaining.
     */
    public Builder setRefreshInterval(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      refreshInterval_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The reset time interval for the quota. Refresh interval applies to rate
     * quota only.
     * Example: "minute" for per minute, "day" for per day, or "10 seconds" for
     * every 10 seconds.
     * </pre>
     *
     * <code>string refresh_interval = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRefreshInterval() {
      refreshInterval_ = getDefaultInstance().getRefreshInterval();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The reset time interval for the quota. Refresh interval applies to rate
     * quota only.
     * Example: "minute" for per minute, "day" for per day, or "10 seconds" for
     * every 10 seconds.
     * </pre>
     *
     * <code>string refresh_interval = 6;</code>
     *
     * @param value The bytes for refreshInterval to set.
     * @return This builder for chaining.
     */
    public Builder setRefreshIntervalBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      refreshInterval_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private int containerType_ = 0;

    /**
     *
     *
     * <pre>
     * The container type of the QuotaInfo.
     * </pre>
     *
     * <code>.google.api.cloudquotas.v1.QuotaInfo.ContainerType container_type = 7;</code>
     *
     * @return The enum numeric value on the wire for containerType.
     */
    @java.lang.Override
    public int getContainerTypeValue() {
      return containerType_;
    }

    /**
     *
     *
     * <pre>
     * The container type of the QuotaInfo.
     * </pre>
     *
     * <code>.google.api.cloudquotas.v1.QuotaInfo.ContainerType container_type = 7;</code>
     *
     * @param value The enum numeric value on the wire for containerType to set.
     * @return This builder for chaining.
     */
    public Builder setContainerTypeValue(int value) {
      containerType_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The container type of the QuotaInfo.
     * </pre>
     *
     * <code>.google.api.cloudquotas.v1.QuotaInfo.ContainerType container_type = 7;</code>
     *
     * @return The containerType.
     */
    @java.lang.Override
    public com.google.api.cloudquotas.v1.QuotaInfo.ContainerType getContainerType() {
      com.google.api.cloudquotas.v1.QuotaInfo.ContainerType result =
          com.google.api.cloudquotas.v1.QuotaInfo.ContainerType.forNumber(containerType_);
      return result == null
          ? com.google.api.cloudquotas.v1.QuotaInfo.ContainerType.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * The container type of the QuotaInfo.
     * </pre>
     *
     * <code>.google.api.cloudquotas.v1.QuotaInfo.ContainerType container_type = 7;</code>
     *
     * @param value The containerType to set.
     * @return This builder for chaining.
     */
    public Builder setContainerType(com.google.api.cloudquotas.v1.QuotaInfo.ContainerType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      containerType_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The container type of the QuotaInfo.
     * </pre>
     *
     * <code>.google.api.cloudquotas.v1.QuotaInfo.ContainerType container_type = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContainerType() {
      bitField0_ = (bitField0_ & ~0x00000040);
      containerType_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList dimensions_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureDimensionsIsMutable() {
      if (!dimensions_.isModifiable()) {
        dimensions_ = new com.google.protobuf.LazyStringArrayList(dimensions_);
      }
      bitField0_ |= 0x00000080;
    }

    /**
     *
     *
     * <pre>
     * The dimensions the quota is defined on.
     * </pre>
     *
     * <code>repeated string dimensions = 8;</code>
     *
     * @return A list containing the dimensions.
     */
    public com.google.protobuf.ProtocolStringList getDimensionsList() {
      dimensions_.makeImmutable();
      return dimensions_;
    }

    /**
     *
     *
     * <pre>
     * The dimensions the quota is defined on.
     * </pre>
     *
     * <code>repeated string dimensions = 8;</code>
     *
     * @return The count of dimensions.
     */
    public int getDimensionsCount() {
      return dimensions_.size();
    }

    /**
     *
     *
     * <pre>
     * The dimensions the quota is defined on.
     * </pre>
     *
     * <code>repeated string dimensions = 8;</code>
     *
     * @param index The index of the element to return.
     * @return The dimensions at the given index.
     */
    public java.lang.String getDimensions(int index) {
      return dimensions_.get(index);
    }

    /**
     *
     *
     * <pre>
     * The dimensions the quota is defined on.
     * </pre>
     *
     * <code>repeated string dimensions = 8;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the dimensions at the given index.
     */
    public com.google.protobuf.ByteString getDimensionsBytes(int index) {
      return dimensions_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * The dimensions the quota is defined on.
     * </pre>
     *
     * <code>repeated string dimensions = 8;</code>
     *
     * @param index The index to set the value at.
     * @param value The dimensions to set.
     * @return This builder for chaining.
     */
    public Builder setDimensions(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDimensionsIsMutable();
      dimensions_.set(index, value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The dimensions the quota is defined on.
     * </pre>
     *
     * <code>repeated string dimensions = 8;</code>
     *
     * @param value The dimensions to add.
     * @return This builder for chaining.
     */
    public Builder addDimensions(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDimensionsIsMutable();
      dimensions_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The dimensions the quota is defined on.
     * </pre>
     *
     * <code>repeated string dimensions = 8;</code>
     *
     * @param values The dimensions to add.
     * @return This builder for chaining.
     */
    public Builder addAllDimensions(java.lang.Iterable<java.lang.String> values) {
      ensureDimensionsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dimensions_);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The dimensions the quota is defined on.
     * </pre>
     *
     * <code>repeated string dimensions = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDimensions() {
      dimensions_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The dimensions the quota is defined on.
     * </pre>
     *
     * <code>repeated string dimensions = 8;</code>
     *
     * @param value The bytes of the dimensions to add.
     * @return This builder for chaining.
     */
    public Builder addDimensionsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureDimensionsIsMutable();
      dimensions_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object metricDisplayName_ = "";

    /**
     *
     *
     * <pre>
     * The display name of the quota metric
     * </pre>
     *
     * <code>string metric_display_name = 9;</code>
     *
     * @return The metricDisplayName.
     */
    public java.lang.String getMetricDisplayName() {
      java.lang.Object ref = metricDisplayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metricDisplayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The display name of the quota metric
     * </pre>
     *
     * <code>string metric_display_name = 9;</code>
     *
     * @return The bytes for metricDisplayName.
     */
    public com.google.protobuf.ByteString getMetricDisplayNameBytes() {
      java.lang.Object ref = metricDisplayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metricDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The display name of the quota metric
     * </pre>
     *
     * <code>string metric_display_name = 9;</code>
     *
     * @param value The metricDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setMetricDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      metricDisplayName_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The display name of the quota metric
     * </pre>
     *
     * <code>string metric_display_name = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetricDisplayName() {
      metricDisplayName_ = getDefaultInstance().getMetricDisplayName();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The display name of the quota metric
     * </pre>
     *
     * <code>string metric_display_name = 9;</code>
     *
     * @param value The bytes for metricDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setMetricDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      metricDisplayName_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object quotaDisplayName_ = "";

    /**
     *
     *
     * <pre>
     * The display name of the quota.
     * </pre>
     *
     * <code>string quota_display_name = 10;</code>
     *
     * @return The quotaDisplayName.
     */
    public java.lang.String getQuotaDisplayName() {
      java.lang.Object ref = quotaDisplayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        quotaDisplayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The display name of the quota.
     * </pre>
     *
     * <code>string quota_display_name = 10;</code>
     *
     * @return The bytes for quotaDisplayName.
     */
    public com.google.protobuf.ByteString getQuotaDisplayNameBytes() {
      java.lang.Object ref = quotaDisplayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        quotaDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The display name of the quota.
     * </pre>
     *
     * <code>string quota_display_name = 10;</code>
     *
     * @param value The quotaDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setQuotaDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      quotaDisplayName_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The display name of the quota.
     * </pre>
     *
     * <code>string quota_display_name = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQuotaDisplayName() {
      quotaDisplayName_ = getDefaultInstance().getQuotaDisplayName();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The display name of the quota.
     * </pre>
     *
     * <code>string quota_display_name = 10;</code>
     *
     * @param value The bytes for quotaDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setQuotaDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      quotaDisplayName_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object metricUnit_ = "";

    /**
     *
     *
     * <pre>
     * The unit in which the metric value is reported, e.g., "MByte".
     * </pre>
     *
     * <code>string metric_unit = 11;</code>
     *
     * @return The metricUnit.
     */
    public java.lang.String getMetricUnit() {
      java.lang.Object ref = metricUnit_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metricUnit_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The unit in which the metric value is reported, e.g., "MByte".
     * </pre>
     *
     * <code>string metric_unit = 11;</code>
     *
     * @return The bytes for metricUnit.
     */
    public com.google.protobuf.ByteString getMetricUnitBytes() {
      java.lang.Object ref = metricUnit_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metricUnit_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The unit in which the metric value is reported, e.g., "MByte".
     * </pre>
     *
     * <code>string metric_unit = 11;</code>
     *
     * @param value The metricUnit to set.
     * @return This builder for chaining.
     */
    public Builder setMetricUnit(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      metricUnit_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The unit in which the metric value is reported, e.g., "MByte".
     * </pre>
     *
     * <code>string metric_unit = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetricUnit() {
      metricUnit_ = getDefaultInstance().getMetricUnit();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The unit in which the metric value is reported, e.g., "MByte".
     * </pre>
     *
     * <code>string metric_unit = 11;</code>
     *
     * @param value The bytes for metricUnit to set.
     * @return This builder for chaining.
     */
    public Builder setMetricUnitBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      metricUnit_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private com.google.api.cloudquotas.v1.QuotaIncreaseEligibility quotaIncreaseEligibility_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.cloudquotas.v1.QuotaIncreaseEligibility,
            com.google.api.cloudquotas.v1.QuotaIncreaseEligibility.Builder,
            com.google.api.cloudquotas.v1.QuotaIncreaseEligibilityOrBuilder>
        quotaIncreaseEligibilityBuilder_;

    /**
     *
     *
     * <pre>
     * Whether it is eligible to request a higher quota value for this quota.
     * </pre>
     *
     * <code>.google.api.cloudquotas.v1.QuotaIncreaseEligibility quota_increase_eligibility = 12;
     * </code>
     *
     * @return Whether the quotaIncreaseEligibility field is set.
     */
    public boolean hasQuotaIncreaseEligibility() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * Whether it is eligible to request a higher quota value for this quota.
     * </pre>
     *
     * <code>.google.api.cloudquotas.v1.QuotaIncreaseEligibility quota_increase_eligibility = 12;
     * </code>
     *
     * @return The quotaIncreaseEligibility.
     */
    public com.google.api.cloudquotas.v1.QuotaIncreaseEligibility getQuotaIncreaseEligibility() {
      if (quotaIncreaseEligibilityBuilder_ == null) {
        return quotaIncreaseEligibility_ == null
            ? com.google.api.cloudquotas.v1.QuotaIncreaseEligibility.getDefaultInstance()
            : quotaIncreaseEligibility_;
      } else {
        return quotaIncreaseEligibilityBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Whether it is eligible to request a higher quota value for this quota.
     * </pre>
     *
     * <code>.google.api.cloudquotas.v1.QuotaIncreaseEligibility quota_increase_eligibility = 12;
     * </code>
     */
    public Builder setQuotaIncreaseEligibility(
        com.google.api.cloudquotas.v1.QuotaIncreaseEligibility value) {
      if (quotaIncreaseEligibilityBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        quotaIncreaseEligibility_ = value;
      } else {
        quotaIncreaseEligibilityBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether it is eligible to request a higher quota value for this quota.
     * </pre>
     *
     * <code>.google.api.cloudquotas.v1.QuotaIncreaseEligibility quota_increase_eligibility = 12;
     * </code>
     */
    public Builder setQuotaIncreaseEligibility(
        com.google.api.cloudquotas.v1.QuotaIncreaseEligibility.Builder builderForValue) {
      if (quotaIncreaseEligibilityBuilder_ == null) {
        quotaIncreaseEligibility_ = builderForValue.build();
      } else {
        quotaIncreaseEligibilityBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether it is eligible to request a higher quota value for this quota.
     * </pre>
     *
     * <code>.google.api.cloudquotas.v1.QuotaIncreaseEligibility quota_increase_eligibility = 12;
     * </code>
     */
    public Builder mergeQuotaIncreaseEligibility(
        com.google.api.cloudquotas.v1.QuotaIncreaseEligibility value) {
      if (quotaIncreaseEligibilityBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && quotaIncreaseEligibility_ != null
            && quotaIncreaseEligibility_
                != com.google.api.cloudquotas.v1.QuotaIncreaseEligibility.getDefaultInstance()) {
          getQuotaIncreaseEligibilityBuilder().mergeFrom(value);
        } else {
          quotaIncreaseEligibility_ = value;
        }
      } else {
        quotaIncreaseEligibilityBuilder_.mergeFrom(value);
      }
      if (quotaIncreaseEligibility_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether it is eligible to request a higher quota value for this quota.
     * </pre>
     *
     * <code>.google.api.cloudquotas.v1.QuotaIncreaseEligibility quota_increase_eligibility = 12;
     * </code>
     */
    public Builder clearQuotaIncreaseEligibility() {
      bitField0_ = (bitField0_ & ~0x00000800);
      quotaIncreaseEligibility_ = null;
      if (quotaIncreaseEligibilityBuilder_ != null) {
        quotaIncreaseEligibilityBuilder_.dispose();
        quotaIncreaseEligibilityBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether it is eligible to request a higher quota value for this quota.
     * </pre>
     *
     * <code>.google.api.cloudquotas.v1.QuotaIncreaseEligibility quota_increase_eligibility = 12;
     * </code>
     */
    public com.google.api.cloudquotas.v1.QuotaIncreaseEligibility.Builder
        getQuotaIncreaseEligibilityBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getQuotaIncreaseEligibilityFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Whether it is eligible to request a higher quota value for this quota.
     * </pre>
     *
     * <code>.google.api.cloudquotas.v1.QuotaIncreaseEligibility quota_increase_eligibility = 12;
     * </code>
     */
    public com.google.api.cloudquotas.v1.QuotaIncreaseEligibilityOrBuilder
        getQuotaIncreaseEligibilityOrBuilder() {
      if (quotaIncreaseEligibilityBuilder_ != null) {
        return quotaIncreaseEligibilityBuilder_.getMessageOrBuilder();
      } else {
        return quotaIncreaseEligibility_ == null
            ? com.google.api.cloudquotas.v1.QuotaIncreaseEligibility.getDefaultInstance()
            : quotaIncreaseEligibility_;
      }
    }

    /**
     *
     *
     * <pre>
     * Whether it is eligible to request a higher quota value for this quota.
     * </pre>
     *
     * <code>.google.api.cloudquotas.v1.QuotaIncreaseEligibility quota_increase_eligibility = 12;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.cloudquotas.v1.QuotaIncreaseEligibility,
            com.google.api.cloudquotas.v1.QuotaIncreaseEligibility.Builder,
            com.google.api.cloudquotas.v1.QuotaIncreaseEligibilityOrBuilder>
        getQuotaIncreaseEligibilityFieldBuilder() {
      if (quotaIncreaseEligibilityBuilder_ == null) {
        quotaIncreaseEligibilityBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.cloudquotas.v1.QuotaIncreaseEligibility,
                com.google.api.cloudquotas.v1.QuotaIncreaseEligibility.Builder,
                com.google.api.cloudquotas.v1.QuotaIncreaseEligibilityOrBuilder>(
                getQuotaIncreaseEligibility(), getParentForChildren(), isClean());
        quotaIncreaseEligibility_ = null;
      }
      return quotaIncreaseEligibilityBuilder_;
    }

    private boolean isFixed_;

    /**
     *
     *
     * <pre>
     * Whether the quota value is fixed or adjustable
     * </pre>
     *
     * <code>bool is_fixed = 13;</code>
     *
     * @return The isFixed.
     */
    @java.lang.Override
    public boolean getIsFixed() {
      return isFixed_;
    }

    /**
     *
     *
     * <pre>
     * Whether the quota value is fixed or adjustable
     * </pre>
     *
     * <code>bool is_fixed = 13;</code>
     *
     * @param value The isFixed to set.
     * @return This builder for chaining.
     */
    public Builder setIsFixed(boolean value) {

      isFixed_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether the quota value is fixed or adjustable
     * </pre>
     *
     * <code>bool is_fixed = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsFixed() {
      bitField0_ = (bitField0_ & ~0x00001000);
      isFixed_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.api.cloudquotas.v1.DimensionsInfo> dimensionsInfos_ =
        java.util.Collections.emptyList();

    private void ensureDimensionsInfosIsMutable() {
      if (!((bitField0_ & 0x00002000) != 0)) {
        dimensionsInfos_ =
            new java.util.ArrayList<com.google.api.cloudquotas.v1.DimensionsInfo>(dimensionsInfos_);
        bitField0_ |= 0x00002000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.cloudquotas.v1.DimensionsInfo,
            com.google.api.cloudquotas.v1.DimensionsInfo.Builder,
            com.google.api.cloudquotas.v1.DimensionsInfoOrBuilder>
        dimensionsInfosBuilder_;

    /**
     *
     *
     * <pre>
     * The collection of dimensions info ordered by their dimensions from more
     * specific ones to less specific ones.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1.DimensionsInfo dimensions_infos = 14;</code>
     */
    public java.util.List<com.google.api.cloudquotas.v1.DimensionsInfo> getDimensionsInfosList() {
      if (dimensionsInfosBuilder_ == null) {
        return java.util.Collections.unmodifiableList(dimensionsInfos_);
      } else {
        return dimensionsInfosBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * The collection of dimensions info ordered by their dimensions from more
     * specific ones to less specific ones.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1.DimensionsInfo dimensions_infos = 14;</code>
     */
    public int getDimensionsInfosCount() {
      if (dimensionsInfosBuilder_ == null) {
        return dimensionsInfos_.size();
      } else {
        return dimensionsInfosBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * The collection of dimensions info ordered by their dimensions from more
     * specific ones to less specific ones.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1.DimensionsInfo dimensions_infos = 14;</code>
     */
    public com.google.api.cloudquotas.v1.DimensionsInfo getDimensionsInfos(int index) {
      if (dimensionsInfosBuilder_ == null) {
        return dimensionsInfos_.get(index);
      } else {
        return dimensionsInfosBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The collection of dimensions info ordered by their dimensions from more
     * specific ones to less specific ones.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1.DimensionsInfo dimensions_infos = 14;</code>
     */
    public Builder setDimensionsInfos(
        int index, com.google.api.cloudquotas.v1.DimensionsInfo value) {
      if (dimensionsInfosBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDimensionsInfosIsMutable();
        dimensionsInfos_.set(index, value);
        onChanged();
      } else {
        dimensionsInfosBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The collection of dimensions info ordered by their dimensions from more
     * specific ones to less specific ones.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1.DimensionsInfo dimensions_infos = 14;</code>
     */
    public Builder setDimensionsInfos(
        int index, com.google.api.cloudquotas.v1.DimensionsInfo.Builder builderForValue) {
      if (dimensionsInfosBuilder_ == null) {
        ensureDimensionsInfosIsMutable();
        dimensionsInfos_.set(index, builderForValue.build());
        onChanged();
      } else {
        dimensionsInfosBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The collection of dimensions info ordered by their dimensions from more
     * specific ones to less specific ones.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1.DimensionsInfo dimensions_infos = 14;</code>
     */
    public Builder addDimensionsInfos(com.google.api.cloudquotas.v1.DimensionsInfo value) {
      if (dimensionsInfosBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDimensionsInfosIsMutable();
        dimensionsInfos_.add(value);
        onChanged();
      } else {
        dimensionsInfosBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The collection of dimensions info ordered by their dimensions from more
     * specific ones to less specific ones.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1.DimensionsInfo dimensions_infos = 14;</code>
     */
    public Builder addDimensionsInfos(
        int index, com.google.api.cloudquotas.v1.DimensionsInfo value) {
      if (dimensionsInfosBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDimensionsInfosIsMutable();
        dimensionsInfos_.add(index, value);
        onChanged();
      } else {
        dimensionsInfosBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The collection of dimensions info ordered by their dimensions from more
     * specific ones to less specific ones.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1.DimensionsInfo dimensions_infos = 14;</code>
     */
    public Builder addDimensionsInfos(
        com.google.api.cloudquotas.v1.DimensionsInfo.Builder builderForValue) {
      if (dimensionsInfosBuilder_ == null) {
        ensureDimensionsInfosIsMutable();
        dimensionsInfos_.add(builderForValue.build());
        onChanged();
      } else {
        dimensionsInfosBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The collection of dimensions info ordered by their dimensions from more
     * specific ones to less specific ones.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1.DimensionsInfo dimensions_infos = 14;</code>
     */
    public Builder addDimensionsInfos(
        int index, com.google.api.cloudquotas.v1.DimensionsInfo.Builder builderForValue) {
      if (dimensionsInfosBuilder_ == null) {
        ensureDimensionsInfosIsMutable();
        dimensionsInfos_.add(index, builderForValue.build());
        onChanged();
      } else {
        dimensionsInfosBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The collection of dimensions info ordered by their dimensions from more
     * specific ones to less specific ones.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1.DimensionsInfo dimensions_infos = 14;</code>
     */
    public Builder addAllDimensionsInfos(
        java.lang.Iterable<? extends com.google.api.cloudquotas.v1.DimensionsInfo> values) {
      if (dimensionsInfosBuilder_ == null) {
        ensureDimensionsInfosIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dimensionsInfos_);
        onChanged();
      } else {
        dimensionsInfosBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The collection of dimensions info ordered by their dimensions from more
     * specific ones to less specific ones.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1.DimensionsInfo dimensions_infos = 14;</code>
     */
    public Builder clearDimensionsInfos() {
      if (dimensionsInfosBuilder_ == null) {
        dimensionsInfos_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00002000);
        onChanged();
      } else {
        dimensionsInfosBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The collection of dimensions info ordered by their dimensions from more
     * specific ones to less specific ones.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1.DimensionsInfo dimensions_infos = 14;</code>
     */
    public Builder removeDimensionsInfos(int index) {
      if (dimensionsInfosBuilder_ == null) {
        ensureDimensionsInfosIsMutable();
        dimensionsInfos_.remove(index);
        onChanged();
      } else {
        dimensionsInfosBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The collection of dimensions info ordered by their dimensions from more
     * specific ones to less specific ones.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1.DimensionsInfo dimensions_infos = 14;</code>
     */
    public com.google.api.cloudquotas.v1.DimensionsInfo.Builder getDimensionsInfosBuilder(
        int index) {
      return getDimensionsInfosFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * The collection of dimensions info ordered by their dimensions from more
     * specific ones to less specific ones.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1.DimensionsInfo dimensions_infos = 14;</code>
     */
    public com.google.api.cloudquotas.v1.DimensionsInfoOrBuilder getDimensionsInfosOrBuilder(
        int index) {
      if (dimensionsInfosBuilder_ == null) {
        return dimensionsInfos_.get(index);
      } else {
        return dimensionsInfosBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The collection of dimensions info ordered by their dimensions from more
     * specific ones to less specific ones.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1.DimensionsInfo dimensions_infos = 14;</code>
     */
    public java.util.List<? extends com.google.api.cloudquotas.v1.DimensionsInfoOrBuilder>
        getDimensionsInfosOrBuilderList() {
      if (dimensionsInfosBuilder_ != null) {
        return dimensionsInfosBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(dimensionsInfos_);
      }
    }

    /**
     *
     *
     * <pre>
     * The collection of dimensions info ordered by their dimensions from more
     * specific ones to less specific ones.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1.DimensionsInfo dimensions_infos = 14;</code>
     */
    public com.google.api.cloudquotas.v1.DimensionsInfo.Builder addDimensionsInfosBuilder() {
      return getDimensionsInfosFieldBuilder()
          .addBuilder(com.google.api.cloudquotas.v1.DimensionsInfo.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The collection of dimensions info ordered by their dimensions from more
     * specific ones to less specific ones.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1.DimensionsInfo dimensions_infos = 14;</code>
     */
    public com.google.api.cloudquotas.v1.DimensionsInfo.Builder addDimensionsInfosBuilder(
        int index) {
      return getDimensionsInfosFieldBuilder()
          .addBuilder(index, com.google.api.cloudquotas.v1.DimensionsInfo.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The collection of dimensions info ordered by their dimensions from more
     * specific ones to less specific ones.
     * </pre>
     *
     * <code>repeated .google.api.cloudquotas.v1.DimensionsInfo dimensions_infos = 14;</code>
     */
    public java.util.List<com.google.api.cloudquotas.v1.DimensionsInfo.Builder>
        getDimensionsInfosBuilderList() {
      return getDimensionsInfosFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.cloudquotas.v1.DimensionsInfo,
            com.google.api.cloudquotas.v1.DimensionsInfo.Builder,
            com.google.api.cloudquotas.v1.DimensionsInfoOrBuilder>
        getDimensionsInfosFieldBuilder() {
      if (dimensionsInfosBuilder_ == null) {
        dimensionsInfosBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.api.cloudquotas.v1.DimensionsInfo,
                com.google.api.cloudquotas.v1.DimensionsInfo.Builder,
                com.google.api.cloudquotas.v1.DimensionsInfoOrBuilder>(
                dimensionsInfos_,
                ((bitField0_ & 0x00002000) != 0),
                getParentForChildren(),
                isClean());
        dimensionsInfos_ = null;
      }
      return dimensionsInfosBuilder_;
    }

    private boolean isConcurrent_;

    /**
     *
     *
     * <pre>
     * Whether the quota is a concurrent quota. Concurrent quotas are enforced
     * on the total number of concurrent operations in flight at any given time.
     * </pre>
     *
     * <code>bool is_concurrent = 15;</code>
     *
     * @return The isConcurrent.
     */
    @java.lang.Override
    public boolean getIsConcurrent() {
      return isConcurrent_;
    }

    /**
     *
     *
     * <pre>
     * Whether the quota is a concurrent quota. Concurrent quotas are enforced
     * on the total number of concurrent operations in flight at any given time.
     * </pre>
     *
     * <code>bool is_concurrent = 15;</code>
     *
     * @param value The isConcurrent to set.
     * @return This builder for chaining.
     */
    public Builder setIsConcurrent(boolean value) {

      isConcurrent_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether the quota is a concurrent quota. Concurrent quotas are enforced
     * on the total number of concurrent operations in flight at any given time.
     * </pre>
     *
     * <code>bool is_concurrent = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsConcurrent() {
      bitField0_ = (bitField0_ & ~0x00004000);
      isConcurrent_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object serviceRequestQuotaUri_ = "";

    /**
     *
     *
     * <pre>
     * URI to the page where users can request more quota for the cloud
     * service—for example,
     * https://console.cloud.google.com/iam-admin/quotas.
     * </pre>
     *
     * <code>string service_request_quota_uri = 17;</code>
     *
     * @return The serviceRequestQuotaUri.
     */
    public java.lang.String getServiceRequestQuotaUri() {
      java.lang.Object ref = serviceRequestQuotaUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceRequestQuotaUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * URI to the page where users can request more quota for the cloud
     * service—for example,
     * https://console.cloud.google.com/iam-admin/quotas.
     * </pre>
     *
     * <code>string service_request_quota_uri = 17;</code>
     *
     * @return The bytes for serviceRequestQuotaUri.
     */
    public com.google.protobuf.ByteString getServiceRequestQuotaUriBytes() {
      java.lang.Object ref = serviceRequestQuotaUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceRequestQuotaUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * URI to the page where users can request more quota for the cloud
     * service—for example,
     * https://console.cloud.google.com/iam-admin/quotas.
     * </pre>
     *
     * <code>string service_request_quota_uri = 17;</code>
     *
     * @param value The serviceRequestQuotaUri to set.
     * @return This builder for chaining.
     */
    public Builder setServiceRequestQuotaUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceRequestQuotaUri_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * URI to the page where users can request more quota for the cloud
     * service—for example,
     * https://console.cloud.google.com/iam-admin/quotas.
     * </pre>
     *
     * <code>string service_request_quota_uri = 17;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceRequestQuotaUri() {
      serviceRequestQuotaUri_ = getDefaultInstance().getServiceRequestQuotaUri();
      bitField0_ = (bitField0_ & ~0x00008000);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * URI to the page where users can request more quota for the cloud
     * service—for example,
     * https://console.cloud.google.com/iam-admin/quotas.
     * </pre>
     *
     * <code>string service_request_quota_uri = 17;</code>
     *
     * @param value The bytes for serviceRequestQuotaUri to set.
     * @return This builder for chaining.
     */
    public Builder setServiceRequestQuotaUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceRequestQuotaUri_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.cloudquotas.v1.QuotaInfo)
  }

  // @@protoc_insertion_point(class_scope:google.api.cloudquotas.v1.QuotaInfo)
  private static final com.google.api.cloudquotas.v1.QuotaInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.cloudquotas.v1.QuotaInfo();
  }

  public static com.google.api.cloudquotas.v1.QuotaInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<QuotaInfo> PARSER =
      new com.google.protobuf.AbstractParser<QuotaInfo>() {
        @java.lang.Override
        public QuotaInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<QuotaInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<QuotaInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.cloudquotas.v1.QuotaInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
