/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/cloudquotas/v1/resources.proto

// Protobuf Java Version: 3.25.8
package com.google.api.cloudquotas.v1;

/**
 *
 *
 * <pre>
 * The detailed quota information such as effective quota value for a
 * combination of dimensions.
 * </pre>
 *
 * Protobuf type {@code google.api.cloudquotas.v1.DimensionsInfo}
 */
public final class DimensionsInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.api.cloudquotas.v1.DimensionsInfo)
    DimensionsInfoOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use DimensionsInfo.newBuilder() to construct.
  private DimensionsInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DimensionsInfo() {
    applicableLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DimensionsInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.api.cloudquotas.v1.ResourcesProto
        .internal_static_google_api_cloudquotas_v1_DimensionsInfo_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 1:
        return internalGetDimensions();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.cloudquotas.v1.ResourcesProto
        .internal_static_google_api_cloudquotas_v1_DimensionsInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.cloudquotas.v1.DimensionsInfo.class,
            com.google.api.cloudquotas.v1.DimensionsInfo.Builder.class);
  }

  private int bitField0_;
  public static final int DIMENSIONS_FIELD_NUMBER = 1;

  private static final class DimensionsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.api.cloudquotas.v1.ResourcesProto
                .internal_static_google_api_cloudquotas_v1_DimensionsInfo_DimensionsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> dimensions_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetDimensions() {
    if (dimensions_ == null) {
      return com.google.protobuf.MapField.emptyMapField(DimensionsDefaultEntryHolder.defaultEntry);
    }
    return dimensions_;
  }

  public int getDimensionsCount() {
    return internalGetDimensions().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * The map of dimensions for this dimensions info. The key of a map entry
   * is "region", "zone" or the name of a service specific dimension, and the
   * value of a map entry is the value of the dimension.  If a dimension does
   * not appear in the map of dimensions, the dimensions info applies to all
   * the dimension values except for those that have another DimenisonInfo
   * instance configured for the specific value.
   * Example: {"provider" : "Foo Inc"} where "provider" is a service specific
   * dimension of a quota.
   * </pre>
   *
   * <code>map&lt;string, string&gt; dimensions = 1;</code>
   */
  @java.lang.Override
  public boolean containsDimensions(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetDimensions().getMap().containsKey(key);
  }

  /** Use {@link #getDimensionsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getDimensions() {
    return getDimensionsMap();
  }

  /**
   *
   *
   * <pre>
   * The map of dimensions for this dimensions info. The key of a map entry
   * is "region", "zone" or the name of a service specific dimension, and the
   * value of a map entry is the value of the dimension.  If a dimension does
   * not appear in the map of dimensions, the dimensions info applies to all
   * the dimension values except for those that have another DimenisonInfo
   * instance configured for the specific value.
   * Example: {"provider" : "Foo Inc"} where "provider" is a service specific
   * dimension of a quota.
   * </pre>
   *
   * <code>map&lt;string, string&gt; dimensions = 1;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getDimensionsMap() {
    return internalGetDimensions().getMap();
  }

  /**
   *
   *
   * <pre>
   * The map of dimensions for this dimensions info. The key of a map entry
   * is "region", "zone" or the name of a service specific dimension, and the
   * value of a map entry is the value of the dimension.  If a dimension does
   * not appear in the map of dimensions, the dimensions info applies to all
   * the dimension values except for those that have another DimenisonInfo
   * instance configured for the specific value.
   * Example: {"provider" : "Foo Inc"} where "provider" is a service specific
   * dimension of a quota.
   * </pre>
   *
   * <code>map&lt;string, string&gt; dimensions = 1;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getDimensionsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetDimensions().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * The map of dimensions for this dimensions info. The key of a map entry
   * is "region", "zone" or the name of a service specific dimension, and the
   * value of a map entry is the value of the dimension.  If a dimension does
   * not appear in the map of dimensions, the dimensions info applies to all
   * the dimension values except for those that have another DimenisonInfo
   * instance configured for the specific value.
   * Example: {"provider" : "Foo Inc"} where "provider" is a service specific
   * dimension of a quota.
   * </pre>
   *
   * <code>map&lt;string, string&gt; dimensions = 1;</code>
   */
  @java.lang.Override
  public java.lang.String getDimensionsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetDimensions().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int DETAILS_FIELD_NUMBER = 2;
  private com.google.api.cloudquotas.v1.QuotaDetails details_;

  /**
   *
   *
   * <pre>
   * Quota details for the specified dimensions.
   * </pre>
   *
   * <code>.google.api.cloudquotas.v1.QuotaDetails details = 2;</code>
   *
   * @return Whether the details field is set.
   */
  @java.lang.Override
  public boolean hasDetails() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Quota details for the specified dimensions.
   * </pre>
   *
   * <code>.google.api.cloudquotas.v1.QuotaDetails details = 2;</code>
   *
   * @return The details.
   */
  @java.lang.Override
  public com.google.api.cloudquotas.v1.QuotaDetails getDetails() {
    return details_ == null
        ? com.google.api.cloudquotas.v1.QuotaDetails.getDefaultInstance()
        : details_;
  }

  /**
   *
   *
   * <pre>
   * Quota details for the specified dimensions.
   * </pre>
   *
   * <code>.google.api.cloudquotas.v1.QuotaDetails details = 2;</code>
   */
  @java.lang.Override
  public com.google.api.cloudquotas.v1.QuotaDetailsOrBuilder getDetailsOrBuilder() {
    return details_ == null
        ? com.google.api.cloudquotas.v1.QuotaDetails.getDefaultInstance()
        : details_;
  }

  public static final int APPLICABLE_LOCATIONS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList applicableLocations_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * The applicable regions or zones of this dimensions info. The field will be
   * set to ['global'] for quotas that are not per region or per zone.
   * Otherwise, it will be set to the list of locations this dimension info is
   * applicable to.
   * </pre>
   *
   * <code>repeated string applicable_locations = 3;</code>
   *
   * @return A list containing the applicableLocations.
   */
  public com.google.protobuf.ProtocolStringList getApplicableLocationsList() {
    return applicableLocations_;
  }

  /**
   *
   *
   * <pre>
   * The applicable regions or zones of this dimensions info. The field will be
   * set to ['global'] for quotas that are not per region or per zone.
   * Otherwise, it will be set to the list of locations this dimension info is
   * applicable to.
   * </pre>
   *
   * <code>repeated string applicable_locations = 3;</code>
   *
   * @return The count of applicableLocations.
   */
  public int getApplicableLocationsCount() {
    return applicableLocations_.size();
  }

  /**
   *
   *
   * <pre>
   * The applicable regions or zones of this dimensions info. The field will be
   * set to ['global'] for quotas that are not per region or per zone.
   * Otherwise, it will be set to the list of locations this dimension info is
   * applicable to.
   * </pre>
   *
   * <code>repeated string applicable_locations = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The applicableLocations at the given index.
   */
  public java.lang.String getApplicableLocations(int index) {
    return applicableLocations_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The applicable regions or zones of this dimensions info. The field will be
   * set to ['global'] for quotas that are not per region or per zone.
   * Otherwise, it will be set to the list of locations this dimension info is
   * applicable to.
   * </pre>
   *
   * <code>repeated string applicable_locations = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the applicableLocations at the given index.
   */
  public com.google.protobuf.ByteString getApplicableLocationsBytes(int index) {
    return applicableLocations_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetDimensions(), DimensionsDefaultEntryHolder.defaultEntry, 1);
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getDetails());
    }
    for (int i = 0; i < applicableLocations_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, applicableLocations_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetDimensions().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> dimensions__ =
          DimensionsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, dimensions__);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDetails());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < applicableLocations_.size(); i++) {
        dataSize += computeStringSizeNoTag(applicableLocations_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getApplicableLocationsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.api.cloudquotas.v1.DimensionsInfo)) {
      return super.equals(obj);
    }
    com.google.api.cloudquotas.v1.DimensionsInfo other =
        (com.google.api.cloudquotas.v1.DimensionsInfo) obj;

    if (!internalGetDimensions().equals(other.internalGetDimensions())) return false;
    if (hasDetails() != other.hasDetails()) return false;
    if (hasDetails()) {
      if (!getDetails().equals(other.getDetails())) return false;
    }
    if (!getApplicableLocationsList().equals(other.getApplicableLocationsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (!internalGetDimensions().getMap().isEmpty()) {
      hash = (37 * hash) + DIMENSIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetDimensions().hashCode();
    }
    if (hasDetails()) {
      hash = (37 * hash) + DETAILS_FIELD_NUMBER;
      hash = (53 * hash) + getDetails().hashCode();
    }
    if (getApplicableLocationsCount() > 0) {
      hash = (37 * hash) + APPLICABLE_LOCATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getApplicableLocationsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.cloudquotas.v1.DimensionsInfo parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.cloudquotas.v1.DimensionsInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.cloudquotas.v1.DimensionsInfo parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.cloudquotas.v1.DimensionsInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.cloudquotas.v1.DimensionsInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.api.cloudquotas.v1.DimensionsInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.api.cloudquotas.v1.DimensionsInfo parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.cloudquotas.v1.DimensionsInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.cloudquotas.v1.DimensionsInfo parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.api.cloudquotas.v1.DimensionsInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.api.cloudquotas.v1.DimensionsInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.api.cloudquotas.v1.DimensionsInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.api.cloudquotas.v1.DimensionsInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The detailed quota information such as effective quota value for a
   * combination of dimensions.
   * </pre>
   *
   * Protobuf type {@code google.api.cloudquotas.v1.DimensionsInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.api.cloudquotas.v1.DimensionsInfo)
      com.google.api.cloudquotas.v1.DimensionsInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.api.cloudquotas.v1.ResourcesProto
          .internal_static_google_api_cloudquotas_v1_DimensionsInfo_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 1:
          return internalGetDimensions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 1:
          return internalGetMutableDimensions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.cloudquotas.v1.ResourcesProto
          .internal_static_google_api_cloudquotas_v1_DimensionsInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.cloudquotas.v1.DimensionsInfo.class,
              com.google.api.cloudquotas.v1.DimensionsInfo.Builder.class);
    }

    // Construct using com.google.api.cloudquotas.v1.DimensionsInfo.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDetailsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      internalGetMutableDimensions().clear();
      details_ = null;
      if (detailsBuilder_ != null) {
        detailsBuilder_.dispose();
        detailsBuilder_ = null;
      }
      applicableLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.api.cloudquotas.v1.ResourcesProto
          .internal_static_google_api_cloudquotas_v1_DimensionsInfo_descriptor;
    }

    @java.lang.Override
    public com.google.api.cloudquotas.v1.DimensionsInfo getDefaultInstanceForType() {
      return com.google.api.cloudquotas.v1.DimensionsInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.cloudquotas.v1.DimensionsInfo build() {
      com.google.api.cloudquotas.v1.DimensionsInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.cloudquotas.v1.DimensionsInfo buildPartial() {
      com.google.api.cloudquotas.v1.DimensionsInfo result =
          new com.google.api.cloudquotas.v1.DimensionsInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.api.cloudquotas.v1.DimensionsInfo result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.dimensions_ = internalGetDimensions();
        result.dimensions_.makeImmutable();
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.details_ = detailsBuilder_ == null ? details_ : detailsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        applicableLocations_.makeImmutable();
        result.applicableLocations_ = applicableLocations_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.cloudquotas.v1.DimensionsInfo) {
        return mergeFrom((com.google.api.cloudquotas.v1.DimensionsInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.cloudquotas.v1.DimensionsInfo other) {
      if (other == com.google.api.cloudquotas.v1.DimensionsInfo.getDefaultInstance()) return this;
      internalGetMutableDimensions().mergeFrom(other.internalGetDimensions());
      bitField0_ |= 0x00000001;
      if (other.hasDetails()) {
        mergeDetails(other.getDetails());
      }
      if (!other.applicableLocations_.isEmpty()) {
        if (applicableLocations_.isEmpty()) {
          applicableLocations_ = other.applicableLocations_;
          bitField0_ |= 0x00000004;
        } else {
          ensureApplicableLocationsIsMutable();
          applicableLocations_.addAll(other.applicableLocations_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> dimensions__ =
                    input.readMessage(
                        DimensionsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableDimensions()
                    .getMutableMap()
                    .put(dimensions__.getKey(), dimensions__.getValue());
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getDetailsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureApplicableLocationsIsMutable();
                applicableLocations_.add(s);
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> dimensions_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetDimensions() {
      if (dimensions_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            DimensionsDefaultEntryHolder.defaultEntry);
      }
      return dimensions_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableDimensions() {
      if (dimensions_ == null) {
        dimensions_ =
            com.google.protobuf.MapField.newMapField(DimensionsDefaultEntryHolder.defaultEntry);
      }
      if (!dimensions_.isMutable()) {
        dimensions_ = dimensions_.copy();
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return dimensions_;
    }

    public int getDimensionsCount() {
      return internalGetDimensions().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * The map of dimensions for this dimensions info. The key of a map entry
     * is "region", "zone" or the name of a service specific dimension, and the
     * value of a map entry is the value of the dimension.  If a dimension does
     * not appear in the map of dimensions, the dimensions info applies to all
     * the dimension values except for those that have another DimenisonInfo
     * instance configured for the specific value.
     * Example: {"provider" : "Foo Inc"} where "provider" is a service specific
     * dimension of a quota.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 1;</code>
     */
    @java.lang.Override
    public boolean containsDimensions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetDimensions().getMap().containsKey(key);
    }

    /** Use {@link #getDimensionsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getDimensions() {
      return getDimensionsMap();
    }

    /**
     *
     *
     * <pre>
     * The map of dimensions for this dimensions info. The key of a map entry
     * is "region", "zone" or the name of a service specific dimension, and the
     * value of a map entry is the value of the dimension.  If a dimension does
     * not appear in the map of dimensions, the dimensions info applies to all
     * the dimension values except for those that have another DimenisonInfo
     * instance configured for the specific value.
     * Example: {"provider" : "Foo Inc"} where "provider" is a service specific
     * dimension of a quota.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 1;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getDimensionsMap() {
      return internalGetDimensions().getMap();
    }

    /**
     *
     *
     * <pre>
     * The map of dimensions for this dimensions info. The key of a map entry
     * is "region", "zone" or the name of a service specific dimension, and the
     * value of a map entry is the value of the dimension.  If a dimension does
     * not appear in the map of dimensions, the dimensions info applies to all
     * the dimension values except for those that have another DimenisonInfo
     * instance configured for the specific value.
     * Example: {"provider" : "Foo Inc"} where "provider" is a service specific
     * dimension of a quota.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 1;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getDimensionsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetDimensions().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * The map of dimensions for this dimensions info. The key of a map entry
     * is "region", "zone" or the name of a service specific dimension, and the
     * value of a map entry is the value of the dimension.  If a dimension does
     * not appear in the map of dimensions, the dimensions info applies to all
     * the dimension values except for those that have another DimenisonInfo
     * instance configured for the specific value.
     * Example: {"provider" : "Foo Inc"} where "provider" is a service specific
     * dimension of a quota.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 1;</code>
     */
    @java.lang.Override
    public java.lang.String getDimensionsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetDimensions().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearDimensions() {
      bitField0_ = (bitField0_ & ~0x00000001);
      internalGetMutableDimensions().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The map of dimensions for this dimensions info. The key of a map entry
     * is "region", "zone" or the name of a service specific dimension, and the
     * value of a map entry is the value of the dimension.  If a dimension does
     * not appear in the map of dimensions, the dimensions info applies to all
     * the dimension values except for those that have another DimenisonInfo
     * instance configured for the specific value.
     * Example: {"provider" : "Foo Inc"} where "provider" is a service specific
     * dimension of a quota.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 1;</code>
     */
    public Builder removeDimensions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableDimensions().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableDimensions() {
      bitField0_ |= 0x00000001;
      return internalGetMutableDimensions().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * The map of dimensions for this dimensions info. The key of a map entry
     * is "region", "zone" or the name of a service specific dimension, and the
     * value of a map entry is the value of the dimension.  If a dimension does
     * not appear in the map of dimensions, the dimensions info applies to all
     * the dimension values except for those that have another DimenisonInfo
     * instance configured for the specific value.
     * Example: {"provider" : "Foo Inc"} where "provider" is a service specific
     * dimension of a quota.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 1;</code>
     */
    public Builder putDimensions(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableDimensions().getMutableMap().put(key, value);
      bitField0_ |= 0x00000001;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The map of dimensions for this dimensions info. The key of a map entry
     * is "region", "zone" or the name of a service specific dimension, and the
     * value of a map entry is the value of the dimension.  If a dimension does
     * not appear in the map of dimensions, the dimensions info applies to all
     * the dimension values except for those that have another DimenisonInfo
     * instance configured for the specific value.
     * Example: {"provider" : "Foo Inc"} where "provider" is a service specific
     * dimension of a quota.
     * </pre>
     *
     * <code>map&lt;string, string&gt; dimensions = 1;</code>
     */
    public Builder putAllDimensions(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableDimensions().getMutableMap().putAll(values);
      bitField0_ |= 0x00000001;
      return this;
    }

    private com.google.api.cloudquotas.v1.QuotaDetails details_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.cloudquotas.v1.QuotaDetails,
            com.google.api.cloudquotas.v1.QuotaDetails.Builder,
            com.google.api.cloudquotas.v1.QuotaDetailsOrBuilder>
        detailsBuilder_;

    /**
     *
     *
     * <pre>
     * Quota details for the specified dimensions.
     * </pre>
     *
     * <code>.google.api.cloudquotas.v1.QuotaDetails details = 2;</code>
     *
     * @return Whether the details field is set.
     */
    public boolean hasDetails() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Quota details for the specified dimensions.
     * </pre>
     *
     * <code>.google.api.cloudquotas.v1.QuotaDetails details = 2;</code>
     *
     * @return The details.
     */
    public com.google.api.cloudquotas.v1.QuotaDetails getDetails() {
      if (detailsBuilder_ == null) {
        return details_ == null
            ? com.google.api.cloudquotas.v1.QuotaDetails.getDefaultInstance()
            : details_;
      } else {
        return detailsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Quota details for the specified dimensions.
     * </pre>
     *
     * <code>.google.api.cloudquotas.v1.QuotaDetails details = 2;</code>
     */
    public Builder setDetails(com.google.api.cloudquotas.v1.QuotaDetails value) {
      if (detailsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        details_ = value;
      } else {
        detailsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Quota details for the specified dimensions.
     * </pre>
     *
     * <code>.google.api.cloudquotas.v1.QuotaDetails details = 2;</code>
     */
    public Builder setDetails(com.google.api.cloudquotas.v1.QuotaDetails.Builder builderForValue) {
      if (detailsBuilder_ == null) {
        details_ = builderForValue.build();
      } else {
        detailsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Quota details for the specified dimensions.
     * </pre>
     *
     * <code>.google.api.cloudquotas.v1.QuotaDetails details = 2;</code>
     */
    public Builder mergeDetails(com.google.api.cloudquotas.v1.QuotaDetails value) {
      if (detailsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && details_ != null
            && details_ != com.google.api.cloudquotas.v1.QuotaDetails.getDefaultInstance()) {
          getDetailsBuilder().mergeFrom(value);
        } else {
          details_ = value;
        }
      } else {
        detailsBuilder_.mergeFrom(value);
      }
      if (details_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Quota details for the specified dimensions.
     * </pre>
     *
     * <code>.google.api.cloudquotas.v1.QuotaDetails details = 2;</code>
     */
    public Builder clearDetails() {
      bitField0_ = (bitField0_ & ~0x00000002);
      details_ = null;
      if (detailsBuilder_ != null) {
        detailsBuilder_.dispose();
        detailsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Quota details for the specified dimensions.
     * </pre>
     *
     * <code>.google.api.cloudquotas.v1.QuotaDetails details = 2;</code>
     */
    public com.google.api.cloudquotas.v1.QuotaDetails.Builder getDetailsBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getDetailsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Quota details for the specified dimensions.
     * </pre>
     *
     * <code>.google.api.cloudquotas.v1.QuotaDetails details = 2;</code>
     */
    public com.google.api.cloudquotas.v1.QuotaDetailsOrBuilder getDetailsOrBuilder() {
      if (detailsBuilder_ != null) {
        return detailsBuilder_.getMessageOrBuilder();
      } else {
        return details_ == null
            ? com.google.api.cloudquotas.v1.QuotaDetails.getDefaultInstance()
            : details_;
      }
    }

    /**
     *
     *
     * <pre>
     * Quota details for the specified dimensions.
     * </pre>
     *
     * <code>.google.api.cloudquotas.v1.QuotaDetails details = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.api.cloudquotas.v1.QuotaDetails,
            com.google.api.cloudquotas.v1.QuotaDetails.Builder,
            com.google.api.cloudquotas.v1.QuotaDetailsOrBuilder>
        getDetailsFieldBuilder() {
      if (detailsBuilder_ == null) {
        detailsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.api.cloudquotas.v1.QuotaDetails,
                com.google.api.cloudquotas.v1.QuotaDetails.Builder,
                com.google.api.cloudquotas.v1.QuotaDetailsOrBuilder>(
                getDetails(), getParentForChildren(), isClean());
        details_ = null;
      }
      return detailsBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList applicableLocations_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureApplicableLocationsIsMutable() {
      if (!applicableLocations_.isModifiable()) {
        applicableLocations_ = new com.google.protobuf.LazyStringArrayList(applicableLocations_);
      }
      bitField0_ |= 0x00000004;
    }

    /**
     *
     *
     * <pre>
     * The applicable regions or zones of this dimensions info. The field will be
     * set to ['global'] for quotas that are not per region or per zone.
     * Otherwise, it will be set to the list of locations this dimension info is
     * applicable to.
     * </pre>
     *
     * <code>repeated string applicable_locations = 3;</code>
     *
     * @return A list containing the applicableLocations.
     */
    public com.google.protobuf.ProtocolStringList getApplicableLocationsList() {
      applicableLocations_.makeImmutable();
      return applicableLocations_;
    }

    /**
     *
     *
     * <pre>
     * The applicable regions or zones of this dimensions info. The field will be
     * set to ['global'] for quotas that are not per region or per zone.
     * Otherwise, it will be set to the list of locations this dimension info is
     * applicable to.
     * </pre>
     *
     * <code>repeated string applicable_locations = 3;</code>
     *
     * @return The count of applicableLocations.
     */
    public int getApplicableLocationsCount() {
      return applicableLocations_.size();
    }

    /**
     *
     *
     * <pre>
     * The applicable regions or zones of this dimensions info. The field will be
     * set to ['global'] for quotas that are not per region or per zone.
     * Otherwise, it will be set to the list of locations this dimension info is
     * applicable to.
     * </pre>
     *
     * <code>repeated string applicable_locations = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The applicableLocations at the given index.
     */
    public java.lang.String getApplicableLocations(int index) {
      return applicableLocations_.get(index);
    }

    /**
     *
     *
     * <pre>
     * The applicable regions or zones of this dimensions info. The field will be
     * set to ['global'] for quotas that are not per region or per zone.
     * Otherwise, it will be set to the list of locations this dimension info is
     * applicable to.
     * </pre>
     *
     * <code>repeated string applicable_locations = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the applicableLocations at the given index.
     */
    public com.google.protobuf.ByteString getApplicableLocationsBytes(int index) {
      return applicableLocations_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * The applicable regions or zones of this dimensions info. The field will be
     * set to ['global'] for quotas that are not per region or per zone.
     * Otherwise, it will be set to the list of locations this dimension info is
     * applicable to.
     * </pre>
     *
     * <code>repeated string applicable_locations = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The applicableLocations to set.
     * @return This builder for chaining.
     */
    public Builder setApplicableLocations(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureApplicableLocationsIsMutable();
      applicableLocations_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The applicable regions or zones of this dimensions info. The field will be
     * set to ['global'] for quotas that are not per region or per zone.
     * Otherwise, it will be set to the list of locations this dimension info is
     * applicable to.
     * </pre>
     *
     * <code>repeated string applicable_locations = 3;</code>
     *
     * @param value The applicableLocations to add.
     * @return This builder for chaining.
     */
    public Builder addApplicableLocations(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureApplicableLocationsIsMutable();
      applicableLocations_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The applicable regions or zones of this dimensions info. The field will be
     * set to ['global'] for quotas that are not per region or per zone.
     * Otherwise, it will be set to the list of locations this dimension info is
     * applicable to.
     * </pre>
     *
     * <code>repeated string applicable_locations = 3;</code>
     *
     * @param values The applicableLocations to add.
     * @return This builder for chaining.
     */
    public Builder addAllApplicableLocations(java.lang.Iterable<java.lang.String> values) {
      ensureApplicableLocationsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, applicableLocations_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The applicable regions or zones of this dimensions info. The field will be
     * set to ['global'] for quotas that are not per region or per zone.
     * Otherwise, it will be set to the list of locations this dimension info is
     * applicable to.
     * </pre>
     *
     * <code>repeated string applicable_locations = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearApplicableLocations() {
      applicableLocations_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The applicable regions or zones of this dimensions info. The field will be
     * set to ['global'] for quotas that are not per region or per zone.
     * Otherwise, it will be set to the list of locations this dimension info is
     * applicable to.
     * </pre>
     *
     * <code>repeated string applicable_locations = 3;</code>
     *
     * @param value The bytes of the applicableLocations to add.
     * @return This builder for chaining.
     */
    public Builder addApplicableLocationsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureApplicableLocationsIsMutable();
      applicableLocations_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.api.cloudquotas.v1.DimensionsInfo)
  }

  // @@protoc_insertion_point(class_scope:google.api.cloudquotas.v1.DimensionsInfo)
  private static final com.google.api.cloudquotas.v1.DimensionsInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.api.cloudquotas.v1.DimensionsInfo();
  }

  public static com.google.api.cloudquotas.v1.DimensionsInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DimensionsInfo> PARSER =
      new com.google.protobuf.AbstractParser<DimensionsInfo>() {
        @java.lang.Override
        public DimensionsInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DimensionsInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DimensionsInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.cloudquotas.v1.DimensionsInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
