/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudcontrolspartner.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomerName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_CUSTOMER = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/customers/{customer}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String location;
    private final String customer;

    @Deprecated
    protected CustomerName() {
        this.organization = null;
        this.location = null;
        this.customer = null;
    }

    private CustomerName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCustomer() {
        return this.customer;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomerName of(String organization, String location, String customer) {
        return CustomerName.newBuilder().setOrganization(organization).setLocation(location).setCustomer(customer).build();
    }

    public static String format(String organization, String location, String customer) {
        return CustomerName.newBuilder().setOrganization(organization).setLocation(location).setCustomer(customer).build().toString();
    }

    public static CustomerName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION_LOCATION_CUSTOMER.validatedMatch(formattedString, "CustomerName.parse: formattedString not in valid format");
        return CustomerName.of((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("customer"));
    }

    public static List<CustomerName> parseList(List<String> formattedStrings) {
        ArrayList<CustomerName> list = new ArrayList<CustomerName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomerName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomerName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomerName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_CUSTOMER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomerName customerName = this;
            synchronized (customerName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.customer != null) {
                        fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_LOCATION_CUSTOMER.instantiate(new String[]{"organization", this.organization, "location", this.location, "customer", this.customer});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CustomerName that = (CustomerName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.customer, that.customer);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.customer);
    }

    public static class Builder {
        private String organization;
        private String location;
        private String customer;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCustomer() {
            return this.customer;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        private Builder(CustomerName customerName) {
            this.organization = customerName.organization;
            this.location = customerName.location;
            this.customer = customerName.customer;
        }

        public CustomerName build() {
            return new CustomerName(this);
        }
    }
}

