/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.chronicle.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WatchlistName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_INSTANCE_WATCHLIST = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/instances/{instance}/watchlists/{watchlist}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String instance;
    private final String watchlist;

    @Deprecated
    protected WatchlistName() {
        this.project = null;
        this.location = null;
        this.instance = null;
        this.watchlist = null;
    }

    private WatchlistName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.watchlist = (String)Preconditions.checkNotNull((Object)builder.getWatchlist());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getWatchlist() {
        return this.watchlist;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static WatchlistName of(String project, String location, String instance, String watchlist) {
        return WatchlistName.newBuilder().setProject(project).setLocation(location).setInstance(instance).setWatchlist(watchlist).build();
    }

    public static String format(String project, String location, String instance, String watchlist) {
        return WatchlistName.newBuilder().setProject(project).setLocation(location).setInstance(instance).setWatchlist(watchlist).build().toString();
    }

    public static WatchlistName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_INSTANCE_WATCHLIST.validatedMatch(formattedString, "WatchlistName.parse: formattedString not in valid format");
        return WatchlistName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("instance"), (String)matchMap.get("watchlist"));
    }

    public static List<WatchlistName> parseList(List<String> formattedStrings) {
        ArrayList<WatchlistName> list = new ArrayList<WatchlistName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(WatchlistName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<WatchlistName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (WatchlistName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_INSTANCE_WATCHLIST.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            WatchlistName watchlistName = this;
            synchronized (watchlistName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    }
                    if (this.watchlist != null) {
                        fieldMapBuilder.put((Object)"watchlist", (Object)this.watchlist);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_INSTANCE_WATCHLIST.instantiate(new String[]{"project", this.project, "location", this.location, "instance", this.instance, "watchlist", this.watchlist});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            WatchlistName that = (WatchlistName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.instance, that.instance) && Objects.equals(this.watchlist, that.watchlist);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.instance);
        h *= 1000003;
        return h ^= Objects.hashCode(this.watchlist);
    }

    public static class Builder {
        private String project;
        private String location;
        private String instance;
        private String watchlist;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getWatchlist() {
            return this.watchlist;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setWatchlist(String watchlist) {
            this.watchlist = watchlist;
            return this;
        }

        private Builder(WatchlistName watchlistName) {
            this.project = watchlistName.project;
            this.location = watchlistName.location;
            this.instance = watchlistName.instance;
            this.watchlist = watchlistName.watchlist;
        }

        public WatchlistName build() {
            return new WatchlistName(this);
        }
    }
}

