/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.chronicle.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReferenceListName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_INSTANCE_REFERENCE_LIST = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/instances/{instance}/referenceLists/{reference_list}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String instance;
    private final String referenceList;

    @Deprecated
    protected ReferenceListName() {
        this.project = null;
        this.location = null;
        this.instance = null;
        this.referenceList = null;
    }

    private ReferenceListName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.referenceList = (String)Preconditions.checkNotNull((Object)builder.getReferenceList());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getReferenceList() {
        return this.referenceList;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ReferenceListName of(String project, String location, String instance, String referenceList) {
        return ReferenceListName.newBuilder().setProject(project).setLocation(location).setInstance(instance).setReferenceList(referenceList).build();
    }

    public static String format(String project, String location, String instance, String referenceList) {
        return ReferenceListName.newBuilder().setProject(project).setLocation(location).setInstance(instance).setReferenceList(referenceList).build().toString();
    }

    public static ReferenceListName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_INSTANCE_REFERENCE_LIST.validatedMatch(formattedString, "ReferenceListName.parse: formattedString not in valid format");
        return ReferenceListName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("instance"), (String)matchMap.get("reference_list"));
    }

    public static List<ReferenceListName> parseList(List<String> formattedStrings) {
        ArrayList<ReferenceListName> list = new ArrayList<ReferenceListName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ReferenceListName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ReferenceListName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ReferenceListName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_INSTANCE_REFERENCE_LIST.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ReferenceListName referenceListName = this;
            synchronized (referenceListName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    }
                    if (this.referenceList != null) {
                        fieldMapBuilder.put((Object)"reference_list", (Object)this.referenceList);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_INSTANCE_REFERENCE_LIST.instantiate(new String[]{"project", this.project, "location", this.location, "instance", this.instance, "reference_list", this.referenceList});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ReferenceListName that = (ReferenceListName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.instance, that.instance) && Objects.equals(this.referenceList, that.referenceList);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.instance);
        h *= 1000003;
        return h ^= Objects.hashCode(this.referenceList);
    }

    public static class Builder {
        private String project;
        private String location;
        private String instance;
        private String referenceList;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getReferenceList() {
            return this.referenceList;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setReferenceList(String referenceList) {
            this.referenceList = referenceList;
            return this;
        }

        private Builder(ReferenceListName referenceListName) {
            this.project = referenceListName.project;
            this.location = referenceListName.location;
            this.instance = referenceListName.instance;
            this.referenceList = referenceListName.referenceList;
        }

        public ReferenceListName build() {
            return new ReferenceListName(this);
        }
    }
}

