/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.chronicle.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RuleName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_INSTANCE_RULE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/instances/{instance}/rules/{rule}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String instance;
    private final String rule;

    @Deprecated
    protected RuleName() {
        this.project = null;
        this.location = null;
        this.instance = null;
        this.rule = null;
    }

    private RuleName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.rule = (String)Preconditions.checkNotNull((Object)builder.getRule());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getRule() {
        return this.rule;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RuleName of(String project, String location, String instance, String rule) {
        return RuleName.newBuilder().setProject(project).setLocation(location).setInstance(instance).setRule(rule).build();
    }

    public static String format(String project, String location, String instance, String rule) {
        return RuleName.newBuilder().setProject(project).setLocation(location).setInstance(instance).setRule(rule).build().toString();
    }

    public static RuleName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_INSTANCE_RULE.validatedMatch(formattedString, "RuleName.parse: formattedString not in valid format");
        return RuleName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("instance"), (String)matchMap.get("rule"));
    }

    public static List<RuleName> parseList(List<String> formattedStrings) {
        ArrayList<RuleName> list = new ArrayList<RuleName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RuleName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RuleName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RuleName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_INSTANCE_RULE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RuleName ruleName = this;
            synchronized (ruleName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    }
                    if (this.rule != null) {
                        fieldMapBuilder.put((Object)"rule", (Object)this.rule);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_INSTANCE_RULE.instantiate(new String[]{"project", this.project, "location", this.location, "instance", this.instance, "rule", this.rule});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            RuleName that = (RuleName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.instance, that.instance) && Objects.equals(this.rule, that.rule);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.instance);
        h *= 1000003;
        return h ^= Objects.hashCode(this.rule);
    }

    public static class Builder {
        private String project;
        private String location;
        private String instance;
        private String rule;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getRule() {
            return this.rule;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setRule(String rule) {
            this.rule = rule;
            return this;
        }

        private Builder(RuleName ruleName) {
            this.project = ruleName.project;
            this.location = ruleName.location;
            this.instance = ruleName.instance;
            this.rule = ruleName.rule;
        }

        public RuleName build() {
            return new RuleName(this);
        }
    }
}

