/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.chronicle.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataAccessLabelName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_INSTANCE_DATA_ACCESS_LABEL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/instances/{instance}/dataAccessLabels/{data_access_label}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String instance;
    private final String dataAccessLabel;

    @Deprecated
    protected DataAccessLabelName() {
        this.project = null;
        this.location = null;
        this.instance = null;
        this.dataAccessLabel = null;
    }

    private DataAccessLabelName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.instance = (String)Preconditions.checkNotNull((Object)builder.getInstance());
        this.dataAccessLabel = (String)Preconditions.checkNotNull((Object)builder.getDataAccessLabel());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getInstance() {
        return this.instance;
    }

    public String getDataAccessLabel() {
        return this.dataAccessLabel;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DataAccessLabelName of(String project, String location, String instance, String dataAccessLabel) {
        return DataAccessLabelName.newBuilder().setProject(project).setLocation(location).setInstance(instance).setDataAccessLabel(dataAccessLabel).build();
    }

    public static String format(String project, String location, String instance, String dataAccessLabel) {
        return DataAccessLabelName.newBuilder().setProject(project).setLocation(location).setInstance(instance).setDataAccessLabel(dataAccessLabel).build().toString();
    }

    public static DataAccessLabelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_INSTANCE_DATA_ACCESS_LABEL.validatedMatch(formattedString, "DataAccessLabelName.parse: formattedString not in valid format");
        return DataAccessLabelName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("instance"), (String)matchMap.get("data_access_label"));
    }

    public static List<DataAccessLabelName> parseList(List<String> formattedStrings) {
        ArrayList<DataAccessLabelName> list = new ArrayList<DataAccessLabelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DataAccessLabelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DataAccessLabelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DataAccessLabelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_INSTANCE_DATA_ACCESS_LABEL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DataAccessLabelName dataAccessLabelName = this;
            synchronized (dataAccessLabelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.instance != null) {
                        fieldMapBuilder.put((Object)"instance", (Object)this.instance);
                    }
                    if (this.dataAccessLabel != null) {
                        fieldMapBuilder.put((Object)"data_access_label", (Object)this.dataAccessLabel);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_INSTANCE_DATA_ACCESS_LABEL.instantiate(new String[]{"project", this.project, "location", this.location, "instance", this.instance, "data_access_label", this.dataAccessLabel});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DataAccessLabelName that = (DataAccessLabelName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.instance, that.instance) && Objects.equals(this.dataAccessLabel, that.dataAccessLabel);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.instance);
        h *= 1000003;
        return h ^= Objects.hashCode(this.dataAccessLabel);
    }

    public static class Builder {
        private String project;
        private String location;
        private String instance;
        private String dataAccessLabel;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getInstance() {
            return this.instance;
        }

        public String getDataAccessLabel() {
            return this.dataAccessLabel;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setInstance(String instance) {
            this.instance = instance;
            return this;
        }

        public Builder setDataAccessLabel(String dataAccessLabel) {
            this.dataAccessLabel = dataAccessLabel;
            return this;
        }

        private Builder(DataAccessLabelName dataAccessLabelName) {
            this.project = dataAccessLabelName.project;
            this.location = dataAccessLabelName.location;
            this.instance = dataAccessLabelName.instance;
            this.dataAccessLabel = dataAccessLabelName.dataAccessLabel;
        }

        public DataAccessLabelName build() {
            return new DataAccessLabelName(this);
        }
    }
}

