/*
 * Decompiled with CFR 0.152.
 */
package com.google.chat.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AttachmentName
implements ResourceName {
    private static final PathTemplate SPACE_MESSAGE_ATTACHMENT = PathTemplate.createWithoutUrlEncoding((String)"spaces/{space}/messages/{message}/attachments/{attachment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String space;
    private final String message;
    private final String attachment;

    @Deprecated
    protected AttachmentName() {
        this.space = null;
        this.message = null;
        this.attachment = null;
    }

    private AttachmentName(Builder builder) {
        this.space = (String)Preconditions.checkNotNull((Object)builder.getSpace());
        this.message = (String)Preconditions.checkNotNull((Object)builder.getMessage());
        this.attachment = (String)Preconditions.checkNotNull((Object)builder.getAttachment());
    }

    public String getSpace() {
        return this.space;
    }

    public String getMessage() {
        return this.message;
    }

    public String getAttachment() {
        return this.attachment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AttachmentName of(String space, String message, String attachment) {
        return AttachmentName.newBuilder().setSpace(space).setMessage(message).setAttachment(attachment).build();
    }

    public static String format(String space, String message, String attachment) {
        return AttachmentName.newBuilder().setSpace(space).setMessage(message).setAttachment(attachment).build().toString();
    }

    public static AttachmentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = SPACE_MESSAGE_ATTACHMENT.validatedMatch(formattedString, "AttachmentName.parse: formattedString not in valid format");
        return AttachmentName.of((String)matchMap.get("space"), (String)matchMap.get("message"), (String)matchMap.get("attachment"));
    }

    public static List<AttachmentName> parseList(List<String> formattedStrings) {
        ArrayList<AttachmentName> list = new ArrayList<AttachmentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AttachmentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AttachmentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AttachmentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return SPACE_MESSAGE_ATTACHMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AttachmentName attachmentName = this;
            synchronized (attachmentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.space != null) {
                        fieldMapBuilder.put((Object)"space", (Object)this.space);
                    }
                    if (this.message != null) {
                        fieldMapBuilder.put((Object)"message", (Object)this.message);
                    }
                    if (this.attachment != null) {
                        fieldMapBuilder.put((Object)"attachment", (Object)this.attachment);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return SPACE_MESSAGE_ATTACHMENT.instantiate(new String[]{"space", this.space, "message", this.message, "attachment", this.attachment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AttachmentName that = (AttachmentName)o;
            return Objects.equals(this.space, that.space) && Objects.equals(this.message, that.message) && Objects.equals(this.attachment, that.attachment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.space);
        h *= 1000003;
        h ^= Objects.hashCode(this.message);
        h *= 1000003;
        return h ^= Objects.hashCode(this.attachment);
    }

    public static class Builder {
        private String space;
        private String message;
        private String attachment;

        protected Builder() {
        }

        public String getSpace() {
            return this.space;
        }

        public String getMessage() {
            return this.message;
        }

        public String getAttachment() {
            return this.attachment;
        }

        public Builder setSpace(String space) {
            this.space = space;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setAttachment(String attachment) {
            this.attachment = attachment;
            return this;
        }

        private Builder(AttachmentName attachmentName) {
            this.space = attachmentName.space;
            this.message = attachmentName.message;
            this.attachment = attachmentName.attachment;
        }

        public AttachmentName build() {
            return new AttachmentName(this);
        }
    }
}

