/*
 * Decompiled with CFR 0.152.
 */
package com.google.chat.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomEmojiName
implements ResourceName {
    private static final PathTemplate CUSTOM_EMOJI = PathTemplate.createWithoutUrlEncoding((String)"customEmojis/{custom_emoji}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customEmoji;

    @Deprecated
    protected CustomEmojiName() {
        this.customEmoji = null;
    }

    private CustomEmojiName(Builder builder) {
        this.customEmoji = (String)Preconditions.checkNotNull((Object)builder.getCustomEmoji());
    }

    public String getCustomEmoji() {
        return this.customEmoji;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomEmojiName of(String customEmoji) {
        return CustomEmojiName.newBuilder().setCustomEmoji(customEmoji).build();
    }

    public static String format(String customEmoji) {
        return CustomEmojiName.newBuilder().setCustomEmoji(customEmoji).build().toString();
    }

    public static CustomEmojiName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOM_EMOJI.validatedMatch(formattedString, "CustomEmojiName.parse: formattedString not in valid format");
        return CustomEmojiName.of((String)matchMap.get("custom_emoji"));
    }

    public static List<CustomEmojiName> parseList(List<String> formattedStrings) {
        ArrayList<CustomEmojiName> list = new ArrayList<CustomEmojiName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomEmojiName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomEmojiName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomEmojiName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOM_EMOJI.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomEmojiName customEmojiName = this;
            synchronized (customEmojiName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customEmoji != null) {
                        fieldMapBuilder.put((Object)"custom_emoji", (Object)this.customEmoji);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOM_EMOJI.instantiate(new String[]{"custom_emoji", this.customEmoji});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CustomEmojiName that = (CustomEmojiName)o;
            return Objects.equals(this.customEmoji, that.customEmoji);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.customEmoji);
    }

    public static class Builder {
        private String customEmoji;

        protected Builder() {
        }

        public String getCustomEmoji() {
            return this.customEmoji;
        }

        public Builder setCustomEmoji(String customEmoji) {
            this.customEmoji = customEmoji;
            return this;
        }

        private Builder(CustomEmojiName customEmojiName) {
            this.customEmoji = customEmojiName.customEmoji;
        }

        public CustomEmojiName build() {
            return new CustomEmojiName(this);
        }
    }
}

