/*
 * Decompiled with CFR 0.152.
 */
package com.google.chat.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReactionName
implements ResourceName {
    private static final PathTemplate SPACE_MESSAGE_REACTION = PathTemplate.createWithoutUrlEncoding((String)"spaces/{space}/messages/{message}/reactions/{reaction}");
    private volatile Map<String, String> fieldValuesMap;
    private final String space;
    private final String message;
    private final String reaction;

    @Deprecated
    protected ReactionName() {
        this.space = null;
        this.message = null;
        this.reaction = null;
    }

    private ReactionName(Builder builder) {
        this.space = (String)Preconditions.checkNotNull((Object)builder.getSpace());
        this.message = (String)Preconditions.checkNotNull((Object)builder.getMessage());
        this.reaction = (String)Preconditions.checkNotNull((Object)builder.getReaction());
    }

    public String getSpace() {
        return this.space;
    }

    public String getMessage() {
        return this.message;
    }

    public String getReaction() {
        return this.reaction;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ReactionName of(String space, String message, String reaction) {
        return ReactionName.newBuilder().setSpace(space).setMessage(message).setReaction(reaction).build();
    }

    public static String format(String space, String message, String reaction) {
        return ReactionName.newBuilder().setSpace(space).setMessage(message).setReaction(reaction).build().toString();
    }

    public static ReactionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = SPACE_MESSAGE_REACTION.validatedMatch(formattedString, "ReactionName.parse: formattedString not in valid format");
        return ReactionName.of((String)matchMap.get("space"), (String)matchMap.get("message"), (String)matchMap.get("reaction"));
    }

    public static List<ReactionName> parseList(List<String> formattedStrings) {
        ArrayList<ReactionName> list = new ArrayList<ReactionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ReactionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ReactionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ReactionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return SPACE_MESSAGE_REACTION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ReactionName reactionName = this;
            synchronized (reactionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.space != null) {
                        fieldMapBuilder.put((Object)"space", (Object)this.space);
                    }
                    if (this.message != null) {
                        fieldMapBuilder.put((Object)"message", (Object)this.message);
                    }
                    if (this.reaction != null) {
                        fieldMapBuilder.put((Object)"reaction", (Object)this.reaction);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return SPACE_MESSAGE_REACTION.instantiate(new String[]{"space", this.space, "message", this.message, "reaction", this.reaction});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ReactionName that = (ReactionName)o;
            return Objects.equals(this.space, that.space) && Objects.equals(this.message, that.message) && Objects.equals(this.reaction, that.reaction);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.space);
        h *= 1000003;
        h ^= Objects.hashCode(this.message);
        h *= 1000003;
        return h ^= Objects.hashCode(this.reaction);
    }

    public static class Builder {
        private String space;
        private String message;
        private String reaction;

        protected Builder() {
        }

        public String getSpace() {
            return this.space;
        }

        public String getMessage() {
            return this.message;
        }

        public String getReaction() {
            return this.reaction;
        }

        public Builder setSpace(String space) {
            this.space = space;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setReaction(String reaction) {
            this.reaction = reaction;
            return this;
        }

        private Builder(ReactionName reactionName) {
            this.space = reactionName.space;
            this.message = reactionName.message;
            this.reaction = reactionName.reaction;
        }

        public ReactionName build() {
            return new ReactionName(this);
        }
    }
}

