/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/space_setup.proto

// Protobuf Java Version: 3.25.2
package com.google.chat.v1;

/** Protobuf type {@code google.chat.v1.SetUpSpaceRequest} */
public final class SetUpSpaceRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.chat.v1.SetUpSpaceRequest)
    SetUpSpaceRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SetUpSpaceRequest.newBuilder() to construct.
  private SetUpSpaceRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SetUpSpaceRequest() {
    requestId_ = "";
    memberships_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SetUpSpaceRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.chat.v1.SpaceSetupProto
        .internal_static_google_chat_v1_SetUpSpaceRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.chat.v1.SpaceSetupProto
        .internal_static_google_chat_v1_SetUpSpaceRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.chat.v1.SetUpSpaceRequest.class,
            com.google.chat.v1.SetUpSpaceRequest.Builder.class);
  }

  private int bitField0_;
  public static final int SPACE_FIELD_NUMBER = 1;
  private com.google.chat.v1.Space space_;
  /**
   *
   *
   * <pre>
   * Required. The `Space.spaceType` field is required.
   *
   * To create a space, set `Space.spaceType` to `SPACE` and set
   * `Space.displayName`. If you receive the error message `ALREADY_EXISTS` when
   * setting up a space, try a different `displayName`. An existing space
   * within the Google Workspace organization might already use this display
   * name.
   *
   * To create a group chat, set `Space.spaceType` to
   * `GROUP_CHAT`. Don't set `Space.displayName`.
   *
   * To create a 1:1 conversation between humans,
   * set `Space.spaceType` to `DIRECT_MESSAGE` and set
   * `Space.singleUserBotDm` to `false`. Don't set `Space.displayName` or
   * `Space.spaceDetails`.
   *
   * To create an 1:1 conversation between a human and the calling Chat app, set
   * `Space.spaceType` to `DIRECT_MESSAGE` and
   * `Space.singleUserBotDm` to `true`. Don't set `Space.displayName` or
   * `Space.spaceDetails`.
   *
   * If a `DIRECT_MESSAGE` space already exists, that space is returned instead
   * of creating a new space.
   * </pre>
   *
   * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return Whether the space field is set.
   */
  @java.lang.Override
  public boolean hasSpace() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The `Space.spaceType` field is required.
   *
   * To create a space, set `Space.spaceType` to `SPACE` and set
   * `Space.displayName`. If you receive the error message `ALREADY_EXISTS` when
   * setting up a space, try a different `displayName`. An existing space
   * within the Google Workspace organization might already use this display
   * name.
   *
   * To create a group chat, set `Space.spaceType` to
   * `GROUP_CHAT`. Don't set `Space.displayName`.
   *
   * To create a 1:1 conversation between humans,
   * set `Space.spaceType` to `DIRECT_MESSAGE` and set
   * `Space.singleUserBotDm` to `false`. Don't set `Space.displayName` or
   * `Space.spaceDetails`.
   *
   * To create an 1:1 conversation between a human and the calling Chat app, set
   * `Space.spaceType` to `DIRECT_MESSAGE` and
   * `Space.singleUserBotDm` to `true`. Don't set `Space.displayName` or
   * `Space.spaceDetails`.
   *
   * If a `DIRECT_MESSAGE` space already exists, that space is returned instead
   * of creating a new space.
   * </pre>
   *
   * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The space.
   */
  @java.lang.Override
  public com.google.chat.v1.Space getSpace() {
    return space_ == null ? com.google.chat.v1.Space.getDefaultInstance() : space_;
  }
  /**
   *
   *
   * <pre>
   * Required. The `Space.spaceType` field is required.
   *
   * To create a space, set `Space.spaceType` to `SPACE` and set
   * `Space.displayName`. If you receive the error message `ALREADY_EXISTS` when
   * setting up a space, try a different `displayName`. An existing space
   * within the Google Workspace organization might already use this display
   * name.
   *
   * To create a group chat, set `Space.spaceType` to
   * `GROUP_CHAT`. Don't set `Space.displayName`.
   *
   * To create a 1:1 conversation between humans,
   * set `Space.spaceType` to `DIRECT_MESSAGE` and set
   * `Space.singleUserBotDm` to `false`. Don't set `Space.displayName` or
   * `Space.spaceDetails`.
   *
   * To create an 1:1 conversation between a human and the calling Chat app, set
   * `Space.spaceType` to `DIRECT_MESSAGE` and
   * `Space.singleUserBotDm` to `true`. Don't set `Space.displayName` or
   * `Space.spaceDetails`.
   *
   * If a `DIRECT_MESSAGE` space already exists, that space is returned instead
   * of creating a new space.
   * </pre>
   *
   * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  @java.lang.Override
  public com.google.chat.v1.SpaceOrBuilder getSpaceOrBuilder() {
    return space_ == null ? com.google.chat.v1.Space.getDefaultInstance() : space_;
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A unique identifier for this request.
   * A random UUID is recommended.
   * Specifying an existing request ID returns the space created with that ID
   * instead of creating a new space.
   * Specifying an existing request ID from the same Chat app with a different
   * authenticated user returns an error.
   * </pre>
   *
   * <code>string request_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A unique identifier for this request.
   * A random UUID is recommended.
   * Specifying an existing request ID returns the space created with that ID
   * instead of creating a new space.
   * Specifying an existing request ID from the same Chat app with a different
   * authenticated user returns an error.
   * </pre>
   *
   * <code>string request_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MEMBERSHIPS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.chat.v1.Membership> memberships_;
  /**
   *
   *
   * <pre>
   * Optional. The Google Chat users to invite to join the space. Omit the
   * calling user, as they are added automatically.
   *
   * The set currently allows up to 20 memberships (in addition to the caller).
   *
   * The `Membership.member` field must contain a `user` with `name` populated
   * (format: `users/{user}`) and `type` set to `User.Type.HUMAN`. You can only
   * add human users when setting up a space (adding Chat apps is only supported
   * for direct message setup with the calling app). You can also add members
   * using the user's email as an alias for {user}. For example, the `user.name`
   * can be `users/example&#64;gmail.com`." To invite Gmail users or users from
   * external Google Workspace domains, user's email must be used for
   * `{user}`.
   *
   * Optional when setting `Space.spaceType` to `SPACE`.
   *
   * Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
   * least two memberships.
   *
   * Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
   * user, along with exactly one membership.
   *
   * Must be empty when creating a 1:1 conversation between a human and the
   * calling Chat app (when setting `Space.spaceType` to
   * `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.Membership memberships = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.chat.v1.Membership> getMembershipsList() {
    return memberships_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The Google Chat users to invite to join the space. Omit the
   * calling user, as they are added automatically.
   *
   * The set currently allows up to 20 memberships (in addition to the caller).
   *
   * The `Membership.member` field must contain a `user` with `name` populated
   * (format: `users/{user}`) and `type` set to `User.Type.HUMAN`. You can only
   * add human users when setting up a space (adding Chat apps is only supported
   * for direct message setup with the calling app). You can also add members
   * using the user's email as an alias for {user}. For example, the `user.name`
   * can be `users/example&#64;gmail.com`." To invite Gmail users or users from
   * external Google Workspace domains, user's email must be used for
   * `{user}`.
   *
   * Optional when setting `Space.spaceType` to `SPACE`.
   *
   * Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
   * least two memberships.
   *
   * Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
   * user, along with exactly one membership.
   *
   * Must be empty when creating a 1:1 conversation between a human and the
   * calling Chat app (when setting `Space.spaceType` to
   * `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.Membership memberships = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.chat.v1.MembershipOrBuilder>
      getMembershipsOrBuilderList() {
    return memberships_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The Google Chat users to invite to join the space. Omit the
   * calling user, as they are added automatically.
   *
   * The set currently allows up to 20 memberships (in addition to the caller).
   *
   * The `Membership.member` field must contain a `user` with `name` populated
   * (format: `users/{user}`) and `type` set to `User.Type.HUMAN`. You can only
   * add human users when setting up a space (adding Chat apps is only supported
   * for direct message setup with the calling app). You can also add members
   * using the user's email as an alias for {user}. For example, the `user.name`
   * can be `users/example&#64;gmail.com`." To invite Gmail users or users from
   * external Google Workspace domains, user's email must be used for
   * `{user}`.
   *
   * Optional when setting `Space.spaceType` to `SPACE`.
   *
   * Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
   * least two memberships.
   *
   * Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
   * user, along with exactly one membership.
   *
   * Must be empty when creating a 1:1 conversation between a human and the
   * calling Chat app (when setting `Space.spaceType` to
   * `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.Membership memberships = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getMembershipsCount() {
    return memberships_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The Google Chat users to invite to join the space. Omit the
   * calling user, as they are added automatically.
   *
   * The set currently allows up to 20 memberships (in addition to the caller).
   *
   * The `Membership.member` field must contain a `user` with `name` populated
   * (format: `users/{user}`) and `type` set to `User.Type.HUMAN`. You can only
   * add human users when setting up a space (adding Chat apps is only supported
   * for direct message setup with the calling app). You can also add members
   * using the user's email as an alias for {user}. For example, the `user.name`
   * can be `users/example&#64;gmail.com`." To invite Gmail users or users from
   * external Google Workspace domains, user's email must be used for
   * `{user}`.
   *
   * Optional when setting `Space.spaceType` to `SPACE`.
   *
   * Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
   * least two memberships.
   *
   * Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
   * user, along with exactly one membership.
   *
   * Must be empty when creating a 1:1 conversation between a human and the
   * calling Chat app (when setting `Space.spaceType` to
   * `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.Membership memberships = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.Membership getMemberships(int index) {
    return memberships_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. The Google Chat users to invite to join the space. Omit the
   * calling user, as they are added automatically.
   *
   * The set currently allows up to 20 memberships (in addition to the caller).
   *
   * The `Membership.member` field must contain a `user` with `name` populated
   * (format: `users/{user}`) and `type` set to `User.Type.HUMAN`. You can only
   * add human users when setting up a space (adding Chat apps is only supported
   * for direct message setup with the calling app). You can also add members
   * using the user's email as an alias for {user}. For example, the `user.name`
   * can be `users/example&#64;gmail.com`." To invite Gmail users or users from
   * external Google Workspace domains, user's email must be used for
   * `{user}`.
   *
   * Optional when setting `Space.spaceType` to `SPACE`.
   *
   * Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
   * least two memberships.
   *
   * Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
   * user, along with exactly one membership.
   *
   * Must be empty when creating a 1:1 conversation between a human and the
   * calling Chat app (when setting `Space.spaceType` to
   * `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
   * </pre>
   *
   * <code>
   * repeated .google.chat.v1.Membership memberships = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.MembershipOrBuilder getMembershipsOrBuilder(int index) {
    return memberships_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getSpace());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, requestId_);
    }
    for (int i = 0; i < memberships_.size(); i++) {
      output.writeMessage(4, memberships_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getSpace());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, requestId_);
    }
    for (int i = 0; i < memberships_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, memberships_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.chat.v1.SetUpSpaceRequest)) {
      return super.equals(obj);
    }
    com.google.chat.v1.SetUpSpaceRequest other = (com.google.chat.v1.SetUpSpaceRequest) obj;

    if (hasSpace() != other.hasSpace()) return false;
    if (hasSpace()) {
      if (!getSpace().equals(other.getSpace())) return false;
    }
    if (!getRequestId().equals(other.getRequestId())) return false;
    if (!getMembershipsList().equals(other.getMembershipsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasSpace()) {
      hash = (37 * hash) + SPACE_FIELD_NUMBER;
      hash = (53 * hash) + getSpace().hashCode();
    }
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequestId().hashCode();
    if (getMembershipsCount() > 0) {
      hash = (37 * hash) + MEMBERSHIPS_FIELD_NUMBER;
      hash = (53 * hash) + getMembershipsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.chat.v1.SetUpSpaceRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.SetUpSpaceRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.SetUpSpaceRequest parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.SetUpSpaceRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.SetUpSpaceRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.SetUpSpaceRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.SetUpSpaceRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.SetUpSpaceRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.SetUpSpaceRequest parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.SetUpSpaceRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.SetUpSpaceRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.SetUpSpaceRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.chat.v1.SetUpSpaceRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /** Protobuf type {@code google.chat.v1.SetUpSpaceRequest} */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.chat.v1.SetUpSpaceRequest)
      com.google.chat.v1.SetUpSpaceRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.SpaceSetupProto
          .internal_static_google_chat_v1_SetUpSpaceRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.SpaceSetupProto
          .internal_static_google_chat_v1_SetUpSpaceRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.SetUpSpaceRequest.class,
              com.google.chat.v1.SetUpSpaceRequest.Builder.class);
    }

    // Construct using com.google.chat.v1.SetUpSpaceRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSpaceFieldBuilder();
        getMembershipsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      space_ = null;
      if (spaceBuilder_ != null) {
        spaceBuilder_.dispose();
        spaceBuilder_ = null;
      }
      requestId_ = "";
      if (membershipsBuilder_ == null) {
        memberships_ = java.util.Collections.emptyList();
      } else {
        memberships_ = null;
        membershipsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.chat.v1.SpaceSetupProto
          .internal_static_google_chat_v1_SetUpSpaceRequest_descriptor;
    }

    @java.lang.Override
    public com.google.chat.v1.SetUpSpaceRequest getDefaultInstanceForType() {
      return com.google.chat.v1.SetUpSpaceRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.chat.v1.SetUpSpaceRequest build() {
      com.google.chat.v1.SetUpSpaceRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.chat.v1.SetUpSpaceRequest buildPartial() {
      com.google.chat.v1.SetUpSpaceRequest result = new com.google.chat.v1.SetUpSpaceRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.chat.v1.SetUpSpaceRequest result) {
      if (membershipsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          memberships_ = java.util.Collections.unmodifiableList(memberships_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.memberships_ = memberships_;
      } else {
        result.memberships_ = membershipsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.chat.v1.SetUpSpaceRequest result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.space_ = spaceBuilder_ == null ? space_ : spaceBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.requestId_ = requestId_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.chat.v1.SetUpSpaceRequest) {
        return mergeFrom((com.google.chat.v1.SetUpSpaceRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.chat.v1.SetUpSpaceRequest other) {
      if (other == com.google.chat.v1.SetUpSpaceRequest.getDefaultInstance()) return this;
      if (other.hasSpace()) {
        mergeSpace(other.getSpace());
      }
      if (!other.getRequestId().isEmpty()) {
        requestId_ = other.requestId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (membershipsBuilder_ == null) {
        if (!other.memberships_.isEmpty()) {
          if (memberships_.isEmpty()) {
            memberships_ = other.memberships_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureMembershipsIsMutable();
            memberships_.addAll(other.memberships_);
          }
          onChanged();
        }
      } else {
        if (!other.memberships_.isEmpty()) {
          if (membershipsBuilder_.isEmpty()) {
            membershipsBuilder_.dispose();
            membershipsBuilder_ = null;
            memberships_ = other.memberships_;
            bitField0_ = (bitField0_ & ~0x00000004);
            membershipsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMembershipsFieldBuilder()
                    : null;
          } else {
            membershipsBuilder_.addAllMessages(other.memberships_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getSpaceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                requestId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 34:
              {
                com.google.chat.v1.Membership m =
                    input.readMessage(com.google.chat.v1.Membership.parser(), extensionRegistry);
                if (membershipsBuilder_ == null) {
                  ensureMembershipsIsMutable();
                  memberships_.add(m);
                } else {
                  membershipsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.chat.v1.Space space_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.Space,
            com.google.chat.v1.Space.Builder,
            com.google.chat.v1.SpaceOrBuilder>
        spaceBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The `Space.spaceType` field is required.
     *
     * To create a space, set `Space.spaceType` to `SPACE` and set
     * `Space.displayName`. If you receive the error message `ALREADY_EXISTS` when
     * setting up a space, try a different `displayName`. An existing space
     * within the Google Workspace organization might already use this display
     * name.
     *
     * To create a group chat, set `Space.spaceType` to
     * `GROUP_CHAT`. Don't set `Space.displayName`.
     *
     * To create a 1:1 conversation between humans,
     * set `Space.spaceType` to `DIRECT_MESSAGE` and set
     * `Space.singleUserBotDm` to `false`. Don't set `Space.displayName` or
     * `Space.spaceDetails`.
     *
     * To create an 1:1 conversation between a human and the calling Chat app, set
     * `Space.spaceType` to `DIRECT_MESSAGE` and
     * `Space.singleUserBotDm` to `true`. Don't set `Space.displayName` or
     * `Space.spaceDetails`.
     *
     * If a `DIRECT_MESSAGE` space already exists, that space is returned instead
     * of creating a new space.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return Whether the space field is set.
     */
    public boolean hasSpace() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The `Space.spaceType` field is required.
     *
     * To create a space, set `Space.spaceType` to `SPACE` and set
     * `Space.displayName`. If you receive the error message `ALREADY_EXISTS` when
     * setting up a space, try a different `displayName`. An existing space
     * within the Google Workspace organization might already use this display
     * name.
     *
     * To create a group chat, set `Space.spaceType` to
     * `GROUP_CHAT`. Don't set `Space.displayName`.
     *
     * To create a 1:1 conversation between humans,
     * set `Space.spaceType` to `DIRECT_MESSAGE` and set
     * `Space.singleUserBotDm` to `false`. Don't set `Space.displayName` or
     * `Space.spaceDetails`.
     *
     * To create an 1:1 conversation between a human and the calling Chat app, set
     * `Space.spaceType` to `DIRECT_MESSAGE` and
     * `Space.singleUserBotDm` to `true`. Don't set `Space.displayName` or
     * `Space.spaceDetails`.
     *
     * If a `DIRECT_MESSAGE` space already exists, that space is returned instead
     * of creating a new space.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The space.
     */
    public com.google.chat.v1.Space getSpace() {
      if (spaceBuilder_ == null) {
        return space_ == null ? com.google.chat.v1.Space.getDefaultInstance() : space_;
      } else {
        return spaceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The `Space.spaceType` field is required.
     *
     * To create a space, set `Space.spaceType` to `SPACE` and set
     * `Space.displayName`. If you receive the error message `ALREADY_EXISTS` when
     * setting up a space, try a different `displayName`. An existing space
     * within the Google Workspace organization might already use this display
     * name.
     *
     * To create a group chat, set `Space.spaceType` to
     * `GROUP_CHAT`. Don't set `Space.displayName`.
     *
     * To create a 1:1 conversation between humans,
     * set `Space.spaceType` to `DIRECT_MESSAGE` and set
     * `Space.singleUserBotDm` to `false`. Don't set `Space.displayName` or
     * `Space.spaceDetails`.
     *
     * To create an 1:1 conversation between a human and the calling Chat app, set
     * `Space.spaceType` to `DIRECT_MESSAGE` and
     * `Space.singleUserBotDm` to `true`. Don't set `Space.displayName` or
     * `Space.spaceDetails`.
     *
     * If a `DIRECT_MESSAGE` space already exists, that space is returned instead
     * of creating a new space.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setSpace(com.google.chat.v1.Space value) {
      if (spaceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        space_ = value;
      } else {
        spaceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The `Space.spaceType` field is required.
     *
     * To create a space, set `Space.spaceType` to `SPACE` and set
     * `Space.displayName`. If you receive the error message `ALREADY_EXISTS` when
     * setting up a space, try a different `displayName`. An existing space
     * within the Google Workspace organization might already use this display
     * name.
     *
     * To create a group chat, set `Space.spaceType` to
     * `GROUP_CHAT`. Don't set `Space.displayName`.
     *
     * To create a 1:1 conversation between humans,
     * set `Space.spaceType` to `DIRECT_MESSAGE` and set
     * `Space.singleUserBotDm` to `false`. Don't set `Space.displayName` or
     * `Space.spaceDetails`.
     *
     * To create an 1:1 conversation between a human and the calling Chat app, set
     * `Space.spaceType` to `DIRECT_MESSAGE` and
     * `Space.singleUserBotDm` to `true`. Don't set `Space.displayName` or
     * `Space.spaceDetails`.
     *
     * If a `DIRECT_MESSAGE` space already exists, that space is returned instead
     * of creating a new space.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setSpace(com.google.chat.v1.Space.Builder builderForValue) {
      if (spaceBuilder_ == null) {
        space_ = builderForValue.build();
      } else {
        spaceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The `Space.spaceType` field is required.
     *
     * To create a space, set `Space.spaceType` to `SPACE` and set
     * `Space.displayName`. If you receive the error message `ALREADY_EXISTS` when
     * setting up a space, try a different `displayName`. An existing space
     * within the Google Workspace organization might already use this display
     * name.
     *
     * To create a group chat, set `Space.spaceType` to
     * `GROUP_CHAT`. Don't set `Space.displayName`.
     *
     * To create a 1:1 conversation between humans,
     * set `Space.spaceType` to `DIRECT_MESSAGE` and set
     * `Space.singleUserBotDm` to `false`. Don't set `Space.displayName` or
     * `Space.spaceDetails`.
     *
     * To create an 1:1 conversation between a human and the calling Chat app, set
     * `Space.spaceType` to `DIRECT_MESSAGE` and
     * `Space.singleUserBotDm` to `true`. Don't set `Space.displayName` or
     * `Space.spaceDetails`.
     *
     * If a `DIRECT_MESSAGE` space already exists, that space is returned instead
     * of creating a new space.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder mergeSpace(com.google.chat.v1.Space value) {
      if (spaceBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && space_ != null
            && space_ != com.google.chat.v1.Space.getDefaultInstance()) {
          getSpaceBuilder().mergeFrom(value);
        } else {
          space_ = value;
        }
      } else {
        spaceBuilder_.mergeFrom(value);
      }
      if (space_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The `Space.spaceType` field is required.
     *
     * To create a space, set `Space.spaceType` to `SPACE` and set
     * `Space.displayName`. If you receive the error message `ALREADY_EXISTS` when
     * setting up a space, try a different `displayName`. An existing space
     * within the Google Workspace organization might already use this display
     * name.
     *
     * To create a group chat, set `Space.spaceType` to
     * `GROUP_CHAT`. Don't set `Space.displayName`.
     *
     * To create a 1:1 conversation between humans,
     * set `Space.spaceType` to `DIRECT_MESSAGE` and set
     * `Space.singleUserBotDm` to `false`. Don't set `Space.displayName` or
     * `Space.spaceDetails`.
     *
     * To create an 1:1 conversation between a human and the calling Chat app, set
     * `Space.spaceType` to `DIRECT_MESSAGE` and
     * `Space.singleUserBotDm` to `true`. Don't set `Space.displayName` or
     * `Space.spaceDetails`.
     *
     * If a `DIRECT_MESSAGE` space already exists, that space is returned instead
     * of creating a new space.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder clearSpace() {
      bitField0_ = (bitField0_ & ~0x00000001);
      space_ = null;
      if (spaceBuilder_ != null) {
        spaceBuilder_.dispose();
        spaceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The `Space.spaceType` field is required.
     *
     * To create a space, set `Space.spaceType` to `SPACE` and set
     * `Space.displayName`. If you receive the error message `ALREADY_EXISTS` when
     * setting up a space, try a different `displayName`. An existing space
     * within the Google Workspace organization might already use this display
     * name.
     *
     * To create a group chat, set `Space.spaceType` to
     * `GROUP_CHAT`. Don't set `Space.displayName`.
     *
     * To create a 1:1 conversation between humans,
     * set `Space.spaceType` to `DIRECT_MESSAGE` and set
     * `Space.singleUserBotDm` to `false`. Don't set `Space.displayName` or
     * `Space.spaceDetails`.
     *
     * To create an 1:1 conversation between a human and the calling Chat app, set
     * `Space.spaceType` to `DIRECT_MESSAGE` and
     * `Space.singleUserBotDm` to `true`. Don't set `Space.displayName` or
     * `Space.spaceDetails`.
     *
     * If a `DIRECT_MESSAGE` space already exists, that space is returned instead
     * of creating a new space.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.chat.v1.Space.Builder getSpaceBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getSpaceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The `Space.spaceType` field is required.
     *
     * To create a space, set `Space.spaceType` to `SPACE` and set
     * `Space.displayName`. If you receive the error message `ALREADY_EXISTS` when
     * setting up a space, try a different `displayName`. An existing space
     * within the Google Workspace organization might already use this display
     * name.
     *
     * To create a group chat, set `Space.spaceType` to
     * `GROUP_CHAT`. Don't set `Space.displayName`.
     *
     * To create a 1:1 conversation between humans,
     * set `Space.spaceType` to `DIRECT_MESSAGE` and set
     * `Space.singleUserBotDm` to `false`. Don't set `Space.displayName` or
     * `Space.spaceDetails`.
     *
     * To create an 1:1 conversation between a human and the calling Chat app, set
     * `Space.spaceType` to `DIRECT_MESSAGE` and
     * `Space.singleUserBotDm` to `true`. Don't set `Space.displayName` or
     * `Space.spaceDetails`.
     *
     * If a `DIRECT_MESSAGE` space already exists, that space is returned instead
     * of creating a new space.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.chat.v1.SpaceOrBuilder getSpaceOrBuilder() {
      if (spaceBuilder_ != null) {
        return spaceBuilder_.getMessageOrBuilder();
      } else {
        return space_ == null ? com.google.chat.v1.Space.getDefaultInstance() : space_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The `Space.spaceType` field is required.
     *
     * To create a space, set `Space.spaceType` to `SPACE` and set
     * `Space.displayName`. If you receive the error message `ALREADY_EXISTS` when
     * setting up a space, try a different `displayName`. An existing space
     * within the Google Workspace organization might already use this display
     * name.
     *
     * To create a group chat, set `Space.spaceType` to
     * `GROUP_CHAT`. Don't set `Space.displayName`.
     *
     * To create a 1:1 conversation between humans,
     * set `Space.spaceType` to `DIRECT_MESSAGE` and set
     * `Space.singleUserBotDm` to `false`. Don't set `Space.displayName` or
     * `Space.spaceDetails`.
     *
     * To create an 1:1 conversation between a human and the calling Chat app, set
     * `Space.spaceType` to `DIRECT_MESSAGE` and
     * `Space.singleUserBotDm` to `true`. Don't set `Space.displayName` or
     * `Space.spaceDetails`.
     *
     * If a `DIRECT_MESSAGE` space already exists, that space is returned instead
     * of creating a new space.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.Space,
            com.google.chat.v1.Space.Builder,
            com.google.chat.v1.SpaceOrBuilder>
        getSpaceFieldBuilder() {
      if (spaceBuilder_ == null) {
        spaceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.Space,
                com.google.chat.v1.Space.Builder,
                com.google.chat.v1.SpaceOrBuilder>(getSpace(), getParentForChildren(), isClean());
        space_ = null;
      }
      return spaceBuilder_;
    }

    private java.lang.Object requestId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for this request.
     * A random UUID is recommended.
     * Specifying an existing request ID returns the space created with that ID
     * instead of creating a new space.
     * Specifying an existing request ID from the same Chat app with a different
     * authenticated user returns an error.
     * </pre>
     *
     * <code>string request_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for this request.
     * A random UUID is recommended.
     * Specifying an existing request ID returns the space created with that ID
     * instead of creating a new space.
     * Specifying an existing request ID from the same Chat app with a different
     * authenticated user returns an error.
     * </pre>
     *
     * <code>string request_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for this request.
     * A random UUID is recommended.
     * Specifying an existing request ID returns the space created with that ID
     * instead of creating a new space.
     * Specifying an existing request ID from the same Chat app with a different
     * authenticated user returns an error.
     * </pre>
     *
     * <code>string request_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for this request.
     * A random UUID is recommended.
     * Specifying an existing request ID returns the space created with that ID
     * instead of creating a new space.
     * Specifying an existing request ID from the same Chat app with a different
     * authenticated user returns an error.
     * </pre>
     *
     * <code>string request_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {
      requestId_ = getDefaultInstance().getRequestId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A unique identifier for this request.
     * A random UUID is recommended.
     * Specifying an existing request ID returns the space created with that ID
     * instead of creating a new space.
     * Specifying an existing request ID from the same Chat app with a different
     * authenticated user returns an error.
     * </pre>
     *
     * <code>string request_id = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.chat.v1.Membership> memberships_ =
        java.util.Collections.emptyList();

    private void ensureMembershipsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        memberships_ = new java.util.ArrayList<com.google.chat.v1.Membership>(memberships_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.chat.v1.Membership,
            com.google.chat.v1.Membership.Builder,
            com.google.chat.v1.MembershipOrBuilder>
        membershipsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The Google Chat users to invite to join the space. Omit the
     * calling user, as they are added automatically.
     *
     * The set currently allows up to 20 memberships (in addition to the caller).
     *
     * The `Membership.member` field must contain a `user` with `name` populated
     * (format: `users/{user}`) and `type` set to `User.Type.HUMAN`. You can only
     * add human users when setting up a space (adding Chat apps is only supported
     * for direct message setup with the calling app). You can also add members
     * using the user's email as an alias for {user}. For example, the `user.name`
     * can be `users/example&#64;gmail.com`." To invite Gmail users or users from
     * external Google Workspace domains, user's email must be used for
     * `{user}`.
     *
     * Optional when setting `Space.spaceType` to `SPACE`.
     *
     * Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
     * least two memberships.
     *
     * Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
     * user, along with exactly one membership.
     *
     * Must be empty when creating a 1:1 conversation between a human and the
     * calling Chat app (when setting `Space.spaceType` to
     * `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Membership memberships = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.chat.v1.Membership> getMembershipsList() {
      if (membershipsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(memberships_);
      } else {
        return membershipsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Google Chat users to invite to join the space. Omit the
     * calling user, as they are added automatically.
     *
     * The set currently allows up to 20 memberships (in addition to the caller).
     *
     * The `Membership.member` field must contain a `user` with `name` populated
     * (format: `users/{user}`) and `type` set to `User.Type.HUMAN`. You can only
     * add human users when setting up a space (adding Chat apps is only supported
     * for direct message setup with the calling app). You can also add members
     * using the user's email as an alias for {user}. For example, the `user.name`
     * can be `users/example&#64;gmail.com`." To invite Gmail users or users from
     * external Google Workspace domains, user's email must be used for
     * `{user}`.
     *
     * Optional when setting `Space.spaceType` to `SPACE`.
     *
     * Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
     * least two memberships.
     *
     * Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
     * user, along with exactly one membership.
     *
     * Must be empty when creating a 1:1 conversation between a human and the
     * calling Chat app (when setting `Space.spaceType` to
     * `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Membership memberships = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getMembershipsCount() {
      if (membershipsBuilder_ == null) {
        return memberships_.size();
      } else {
        return membershipsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Google Chat users to invite to join the space. Omit the
     * calling user, as they are added automatically.
     *
     * The set currently allows up to 20 memberships (in addition to the caller).
     *
     * The `Membership.member` field must contain a `user` with `name` populated
     * (format: `users/{user}`) and `type` set to `User.Type.HUMAN`. You can only
     * add human users when setting up a space (adding Chat apps is only supported
     * for direct message setup with the calling app). You can also add members
     * using the user's email as an alias for {user}. For example, the `user.name`
     * can be `users/example&#64;gmail.com`." To invite Gmail users or users from
     * external Google Workspace domains, user's email must be used for
     * `{user}`.
     *
     * Optional when setting `Space.spaceType` to `SPACE`.
     *
     * Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
     * least two memberships.
     *
     * Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
     * user, along with exactly one membership.
     *
     * Must be empty when creating a 1:1 conversation between a human and the
     * calling Chat app (when setting `Space.spaceType` to
     * `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Membership memberships = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.Membership getMemberships(int index) {
      if (membershipsBuilder_ == null) {
        return memberships_.get(index);
      } else {
        return membershipsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Google Chat users to invite to join the space. Omit the
     * calling user, as they are added automatically.
     *
     * The set currently allows up to 20 memberships (in addition to the caller).
     *
     * The `Membership.member` field must contain a `user` with `name` populated
     * (format: `users/{user}`) and `type` set to `User.Type.HUMAN`. You can only
     * add human users when setting up a space (adding Chat apps is only supported
     * for direct message setup with the calling app). You can also add members
     * using the user's email as an alias for {user}. For example, the `user.name`
     * can be `users/example&#64;gmail.com`." To invite Gmail users or users from
     * external Google Workspace domains, user's email must be used for
     * `{user}`.
     *
     * Optional when setting `Space.spaceType` to `SPACE`.
     *
     * Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
     * least two memberships.
     *
     * Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
     * user, along with exactly one membership.
     *
     * Must be empty when creating a 1:1 conversation between a human and the
     * calling Chat app (when setting `Space.spaceType` to
     * `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Membership memberships = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMemberships(int index, com.google.chat.v1.Membership value) {
      if (membershipsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMembershipsIsMutable();
        memberships_.set(index, value);
        onChanged();
      } else {
        membershipsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Google Chat users to invite to join the space. Omit the
     * calling user, as they are added automatically.
     *
     * The set currently allows up to 20 memberships (in addition to the caller).
     *
     * The `Membership.member` field must contain a `user` with `name` populated
     * (format: `users/{user}`) and `type` set to `User.Type.HUMAN`. You can only
     * add human users when setting up a space (adding Chat apps is only supported
     * for direct message setup with the calling app). You can also add members
     * using the user's email as an alias for {user}. For example, the `user.name`
     * can be `users/example&#64;gmail.com`." To invite Gmail users or users from
     * external Google Workspace domains, user's email must be used for
     * `{user}`.
     *
     * Optional when setting `Space.spaceType` to `SPACE`.
     *
     * Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
     * least two memberships.
     *
     * Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
     * user, along with exactly one membership.
     *
     * Must be empty when creating a 1:1 conversation between a human and the
     * calling Chat app (when setting `Space.spaceType` to
     * `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Membership memberships = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMemberships(
        int index, com.google.chat.v1.Membership.Builder builderForValue) {
      if (membershipsBuilder_ == null) {
        ensureMembershipsIsMutable();
        memberships_.set(index, builderForValue.build());
        onChanged();
      } else {
        membershipsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Google Chat users to invite to join the space. Omit the
     * calling user, as they are added automatically.
     *
     * The set currently allows up to 20 memberships (in addition to the caller).
     *
     * The `Membership.member` field must contain a `user` with `name` populated
     * (format: `users/{user}`) and `type` set to `User.Type.HUMAN`. You can only
     * add human users when setting up a space (adding Chat apps is only supported
     * for direct message setup with the calling app). You can also add members
     * using the user's email as an alias for {user}. For example, the `user.name`
     * can be `users/example&#64;gmail.com`." To invite Gmail users or users from
     * external Google Workspace domains, user's email must be used for
     * `{user}`.
     *
     * Optional when setting `Space.spaceType` to `SPACE`.
     *
     * Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
     * least two memberships.
     *
     * Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
     * user, along with exactly one membership.
     *
     * Must be empty when creating a 1:1 conversation between a human and the
     * calling Chat app (when setting `Space.spaceType` to
     * `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Membership memberships = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addMemberships(com.google.chat.v1.Membership value) {
      if (membershipsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMembershipsIsMutable();
        memberships_.add(value);
        onChanged();
      } else {
        membershipsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Google Chat users to invite to join the space. Omit the
     * calling user, as they are added automatically.
     *
     * The set currently allows up to 20 memberships (in addition to the caller).
     *
     * The `Membership.member` field must contain a `user` with `name` populated
     * (format: `users/{user}`) and `type` set to `User.Type.HUMAN`. You can only
     * add human users when setting up a space (adding Chat apps is only supported
     * for direct message setup with the calling app). You can also add members
     * using the user's email as an alias for {user}. For example, the `user.name`
     * can be `users/example&#64;gmail.com`." To invite Gmail users or users from
     * external Google Workspace domains, user's email must be used for
     * `{user}`.
     *
     * Optional when setting `Space.spaceType` to `SPACE`.
     *
     * Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
     * least two memberships.
     *
     * Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
     * user, along with exactly one membership.
     *
     * Must be empty when creating a 1:1 conversation between a human and the
     * calling Chat app (when setting `Space.spaceType` to
     * `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Membership memberships = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addMemberships(int index, com.google.chat.v1.Membership value) {
      if (membershipsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMembershipsIsMutable();
        memberships_.add(index, value);
        onChanged();
      } else {
        membershipsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Google Chat users to invite to join the space. Omit the
     * calling user, as they are added automatically.
     *
     * The set currently allows up to 20 memberships (in addition to the caller).
     *
     * The `Membership.member` field must contain a `user` with `name` populated
     * (format: `users/{user}`) and `type` set to `User.Type.HUMAN`. You can only
     * add human users when setting up a space (adding Chat apps is only supported
     * for direct message setup with the calling app). You can also add members
     * using the user's email as an alias for {user}. For example, the `user.name`
     * can be `users/example&#64;gmail.com`." To invite Gmail users or users from
     * external Google Workspace domains, user's email must be used for
     * `{user}`.
     *
     * Optional when setting `Space.spaceType` to `SPACE`.
     *
     * Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
     * least two memberships.
     *
     * Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
     * user, along with exactly one membership.
     *
     * Must be empty when creating a 1:1 conversation between a human and the
     * calling Chat app (when setting `Space.spaceType` to
     * `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Membership memberships = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addMemberships(com.google.chat.v1.Membership.Builder builderForValue) {
      if (membershipsBuilder_ == null) {
        ensureMembershipsIsMutable();
        memberships_.add(builderForValue.build());
        onChanged();
      } else {
        membershipsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Google Chat users to invite to join the space. Omit the
     * calling user, as they are added automatically.
     *
     * The set currently allows up to 20 memberships (in addition to the caller).
     *
     * The `Membership.member` field must contain a `user` with `name` populated
     * (format: `users/{user}`) and `type` set to `User.Type.HUMAN`. You can only
     * add human users when setting up a space (adding Chat apps is only supported
     * for direct message setup with the calling app). You can also add members
     * using the user's email as an alias for {user}. For example, the `user.name`
     * can be `users/example&#64;gmail.com`." To invite Gmail users or users from
     * external Google Workspace domains, user's email must be used for
     * `{user}`.
     *
     * Optional when setting `Space.spaceType` to `SPACE`.
     *
     * Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
     * least two memberships.
     *
     * Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
     * user, along with exactly one membership.
     *
     * Must be empty when creating a 1:1 conversation between a human and the
     * calling Chat app (when setting `Space.spaceType` to
     * `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Membership memberships = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addMemberships(
        int index, com.google.chat.v1.Membership.Builder builderForValue) {
      if (membershipsBuilder_ == null) {
        ensureMembershipsIsMutable();
        memberships_.add(index, builderForValue.build());
        onChanged();
      } else {
        membershipsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Google Chat users to invite to join the space. Omit the
     * calling user, as they are added automatically.
     *
     * The set currently allows up to 20 memberships (in addition to the caller).
     *
     * The `Membership.member` field must contain a `user` with `name` populated
     * (format: `users/{user}`) and `type` set to `User.Type.HUMAN`. You can only
     * add human users when setting up a space (adding Chat apps is only supported
     * for direct message setup with the calling app). You can also add members
     * using the user's email as an alias for {user}. For example, the `user.name`
     * can be `users/example&#64;gmail.com`." To invite Gmail users or users from
     * external Google Workspace domains, user's email must be used for
     * `{user}`.
     *
     * Optional when setting `Space.spaceType` to `SPACE`.
     *
     * Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
     * least two memberships.
     *
     * Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
     * user, along with exactly one membership.
     *
     * Must be empty when creating a 1:1 conversation between a human and the
     * calling Chat app (when setting `Space.spaceType` to
     * `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Membership memberships = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllMemberships(
        java.lang.Iterable<? extends com.google.chat.v1.Membership> values) {
      if (membershipsBuilder_ == null) {
        ensureMembershipsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, memberships_);
        onChanged();
      } else {
        membershipsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Google Chat users to invite to join the space. Omit the
     * calling user, as they are added automatically.
     *
     * The set currently allows up to 20 memberships (in addition to the caller).
     *
     * The `Membership.member` field must contain a `user` with `name` populated
     * (format: `users/{user}`) and `type` set to `User.Type.HUMAN`. You can only
     * add human users when setting up a space (adding Chat apps is only supported
     * for direct message setup with the calling app). You can also add members
     * using the user's email as an alias for {user}. For example, the `user.name`
     * can be `users/example&#64;gmail.com`." To invite Gmail users or users from
     * external Google Workspace domains, user's email must be used for
     * `{user}`.
     *
     * Optional when setting `Space.spaceType` to `SPACE`.
     *
     * Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
     * least two memberships.
     *
     * Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
     * user, along with exactly one membership.
     *
     * Must be empty when creating a 1:1 conversation between a human and the
     * calling Chat app (when setting `Space.spaceType` to
     * `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Membership memberships = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMemberships() {
      if (membershipsBuilder_ == null) {
        memberships_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        membershipsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Google Chat users to invite to join the space. Omit the
     * calling user, as they are added automatically.
     *
     * The set currently allows up to 20 memberships (in addition to the caller).
     *
     * The `Membership.member` field must contain a `user` with `name` populated
     * (format: `users/{user}`) and `type` set to `User.Type.HUMAN`. You can only
     * add human users when setting up a space (adding Chat apps is only supported
     * for direct message setup with the calling app). You can also add members
     * using the user's email as an alias for {user}. For example, the `user.name`
     * can be `users/example&#64;gmail.com`." To invite Gmail users or users from
     * external Google Workspace domains, user's email must be used for
     * `{user}`.
     *
     * Optional when setting `Space.spaceType` to `SPACE`.
     *
     * Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
     * least two memberships.
     *
     * Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
     * user, along with exactly one membership.
     *
     * Must be empty when creating a 1:1 conversation between a human and the
     * calling Chat app (when setting `Space.spaceType` to
     * `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Membership memberships = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeMemberships(int index) {
      if (membershipsBuilder_ == null) {
        ensureMembershipsIsMutable();
        memberships_.remove(index);
        onChanged();
      } else {
        membershipsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The Google Chat users to invite to join the space. Omit the
     * calling user, as they are added automatically.
     *
     * The set currently allows up to 20 memberships (in addition to the caller).
     *
     * The `Membership.member` field must contain a `user` with `name` populated
     * (format: `users/{user}`) and `type` set to `User.Type.HUMAN`. You can only
     * add human users when setting up a space (adding Chat apps is only supported
     * for direct message setup with the calling app). You can also add members
     * using the user's email as an alias for {user}. For example, the `user.name`
     * can be `users/example&#64;gmail.com`." To invite Gmail users or users from
     * external Google Workspace domains, user's email must be used for
     * `{user}`.
     *
     * Optional when setting `Space.spaceType` to `SPACE`.
     *
     * Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
     * least two memberships.
     *
     * Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
     * user, along with exactly one membership.
     *
     * Must be empty when creating a 1:1 conversation between a human and the
     * calling Chat app (when setting `Space.spaceType` to
     * `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Membership memberships = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.Membership.Builder getMembershipsBuilder(int index) {
      return getMembershipsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The Google Chat users to invite to join the space. Omit the
     * calling user, as they are added automatically.
     *
     * The set currently allows up to 20 memberships (in addition to the caller).
     *
     * The `Membership.member` field must contain a `user` with `name` populated
     * (format: `users/{user}`) and `type` set to `User.Type.HUMAN`. You can only
     * add human users when setting up a space (adding Chat apps is only supported
     * for direct message setup with the calling app). You can also add members
     * using the user's email as an alias for {user}. For example, the `user.name`
     * can be `users/example&#64;gmail.com`." To invite Gmail users or users from
     * external Google Workspace domains, user's email must be used for
     * `{user}`.
     *
     * Optional when setting `Space.spaceType` to `SPACE`.
     *
     * Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
     * least two memberships.
     *
     * Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
     * user, along with exactly one membership.
     *
     * Must be empty when creating a 1:1 conversation between a human and the
     * calling Chat app (when setting `Space.spaceType` to
     * `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Membership memberships = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.MembershipOrBuilder getMembershipsOrBuilder(int index) {
      if (membershipsBuilder_ == null) {
        return memberships_.get(index);
      } else {
        return membershipsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Google Chat users to invite to join the space. Omit the
     * calling user, as they are added automatically.
     *
     * The set currently allows up to 20 memberships (in addition to the caller).
     *
     * The `Membership.member` field must contain a `user` with `name` populated
     * (format: `users/{user}`) and `type` set to `User.Type.HUMAN`. You can only
     * add human users when setting up a space (adding Chat apps is only supported
     * for direct message setup with the calling app). You can also add members
     * using the user's email as an alias for {user}. For example, the `user.name`
     * can be `users/example&#64;gmail.com`." To invite Gmail users or users from
     * external Google Workspace domains, user's email must be used for
     * `{user}`.
     *
     * Optional when setting `Space.spaceType` to `SPACE`.
     *
     * Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
     * least two memberships.
     *
     * Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
     * user, along with exactly one membership.
     *
     * Must be empty when creating a 1:1 conversation between a human and the
     * calling Chat app (when setting `Space.spaceType` to
     * `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Membership memberships = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.chat.v1.MembershipOrBuilder>
        getMembershipsOrBuilderList() {
      if (membershipsBuilder_ != null) {
        return membershipsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(memberships_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The Google Chat users to invite to join the space. Omit the
     * calling user, as they are added automatically.
     *
     * The set currently allows up to 20 memberships (in addition to the caller).
     *
     * The `Membership.member` field must contain a `user` with `name` populated
     * (format: `users/{user}`) and `type` set to `User.Type.HUMAN`. You can only
     * add human users when setting up a space (adding Chat apps is only supported
     * for direct message setup with the calling app). You can also add members
     * using the user's email as an alias for {user}. For example, the `user.name`
     * can be `users/example&#64;gmail.com`." To invite Gmail users or users from
     * external Google Workspace domains, user's email must be used for
     * `{user}`.
     *
     * Optional when setting `Space.spaceType` to `SPACE`.
     *
     * Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
     * least two memberships.
     *
     * Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
     * user, along with exactly one membership.
     *
     * Must be empty when creating a 1:1 conversation between a human and the
     * calling Chat app (when setting `Space.spaceType` to
     * `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Membership memberships = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.Membership.Builder addMembershipsBuilder() {
      return getMembershipsFieldBuilder()
          .addBuilder(com.google.chat.v1.Membership.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The Google Chat users to invite to join the space. Omit the
     * calling user, as they are added automatically.
     *
     * The set currently allows up to 20 memberships (in addition to the caller).
     *
     * The `Membership.member` field must contain a `user` with `name` populated
     * (format: `users/{user}`) and `type` set to `User.Type.HUMAN`. You can only
     * add human users when setting up a space (adding Chat apps is only supported
     * for direct message setup with the calling app). You can also add members
     * using the user's email as an alias for {user}. For example, the `user.name`
     * can be `users/example&#64;gmail.com`." To invite Gmail users or users from
     * external Google Workspace domains, user's email must be used for
     * `{user}`.
     *
     * Optional when setting `Space.spaceType` to `SPACE`.
     *
     * Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
     * least two memberships.
     *
     * Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
     * user, along with exactly one membership.
     *
     * Must be empty when creating a 1:1 conversation between a human and the
     * calling Chat app (when setting `Space.spaceType` to
     * `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Membership memberships = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.chat.v1.Membership.Builder addMembershipsBuilder(int index) {
      return getMembershipsFieldBuilder()
          .addBuilder(index, com.google.chat.v1.Membership.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. The Google Chat users to invite to join the space. Omit the
     * calling user, as they are added automatically.
     *
     * The set currently allows up to 20 memberships (in addition to the caller).
     *
     * The `Membership.member` field must contain a `user` with `name` populated
     * (format: `users/{user}`) and `type` set to `User.Type.HUMAN`. You can only
     * add human users when setting up a space (adding Chat apps is only supported
     * for direct message setup with the calling app). You can also add members
     * using the user's email as an alias for {user}. For example, the `user.name`
     * can be `users/example&#64;gmail.com`." To invite Gmail users or users from
     * external Google Workspace domains, user's email must be used for
     * `{user}`.
     *
     * Optional when setting `Space.spaceType` to `SPACE`.
     *
     * Required when setting `Space.spaceType` to `GROUP_CHAT`, along with at
     * least two memberships.
     *
     * Required when setting `Space.spaceType` to `DIRECT_MESSAGE` with a human
     * user, along with exactly one membership.
     *
     * Must be empty when creating a 1:1 conversation between a human and the
     * calling Chat app (when setting `Space.spaceType` to
     * `DIRECT_MESSAGE` and `Space.singleUserBotDm` to `true`).
     * </pre>
     *
     * <code>
     * repeated .google.chat.v1.Membership memberships = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.chat.v1.Membership.Builder> getMembershipsBuilderList() {
      return getMembershipsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.chat.v1.Membership,
            com.google.chat.v1.Membership.Builder,
            com.google.chat.v1.MembershipOrBuilder>
        getMembershipsFieldBuilder() {
      if (membershipsBuilder_ == null) {
        membershipsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.chat.v1.Membership,
                com.google.chat.v1.Membership.Builder,
                com.google.chat.v1.MembershipOrBuilder>(
                memberships_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        memberships_ = null;
      }
      return membershipsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.chat.v1.SetUpSpaceRequest)
  }

  // @@protoc_insertion_point(class_scope:google.chat.v1.SetUpSpaceRequest)
  private static final com.google.chat.v1.SetUpSpaceRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.chat.v1.SetUpSpaceRequest();
  }

  public static com.google.chat.v1.SetUpSpaceRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SetUpSpaceRequest> PARSER =
      new com.google.protobuf.AbstractParser<SetUpSpaceRequest>() {
        @java.lang.Override
        public SetUpSpaceRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SetUpSpaceRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SetUpSpaceRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.chat.v1.SetUpSpaceRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
