/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/message.proto

// Protobuf Java Version: 3.25.2
package com.google.chat.v1;

/**
 *
 *
 * <pre>
 * Parameters that a Chat app can use to configure how its response is posted.
 * </pre>
 *
 * Protobuf type {@code google.chat.v1.ActionResponse}
 */
public final class ActionResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.chat.v1.ActionResponse)
    ActionResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ActionResponse.newBuilder() to construct.
  private ActionResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ActionResponse() {
    type_ = 0;
    url_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ActionResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.chat.v1.MessageProto.internal_static_google_chat_v1_ActionResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.chat.v1.MessageProto
        .internal_static_google_chat_v1_ActionResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.chat.v1.ActionResponse.class,
            com.google.chat.v1.ActionResponse.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type of Chat app response.
   * </pre>
   *
   * Protobuf enum {@code google.chat.v1.ActionResponse.ResponseType}
   */
  public enum ResponseType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default type that's handled as `NEW_MESSAGE`.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Post as a new message in the topic.
     * </pre>
     *
     * <code>NEW_MESSAGE = 1;</code>
     */
    NEW_MESSAGE(1),
    /**
     *
     *
     * <pre>
     * Update the Chat app's message. This is only permitted on a `CARD_CLICKED`
     * event where the message sender type is `BOT`.
     * </pre>
     *
     * <code>UPDATE_MESSAGE = 2;</code>
     */
    UPDATE_MESSAGE(2),
    /**
     *
     *
     * <pre>
     * Update the cards on a user's message. This is only permitted as a
     * response to a `MESSAGE` event with a matched url, or a `CARD_CLICKED`
     * event where the message sender type is `HUMAN`. Text is ignored.
     * </pre>
     *
     * <code>UPDATE_USER_MESSAGE_CARDS = 6;</code>
     */
    UPDATE_USER_MESSAGE_CARDS(6),
    /**
     *
     *
     * <pre>
     * Privately ask the user for additional authentication or configuration.
     * </pre>
     *
     * <code>REQUEST_CONFIG = 3;</code>
     */
    REQUEST_CONFIG(3),
    /**
     *
     *
     * <pre>
     * Presents a
     * [dialog](https://developers.google.com/chat/how-tos/dialogs).
     * </pre>
     *
     * <code>DIALOG = 4;</code>
     */
    DIALOG(4),
    /**
     *
     *
     * <pre>
     * Widget text autocomplete options query.
     * </pre>
     *
     * <code>UPDATE_WIDGET = 7;</code>
     */
    UPDATE_WIDGET(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default type that's handled as `NEW_MESSAGE`.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Post as a new message in the topic.
     * </pre>
     *
     * <code>NEW_MESSAGE = 1;</code>
     */
    public static final int NEW_MESSAGE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Update the Chat app's message. This is only permitted on a `CARD_CLICKED`
     * event where the message sender type is `BOT`.
     * </pre>
     *
     * <code>UPDATE_MESSAGE = 2;</code>
     */
    public static final int UPDATE_MESSAGE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Update the cards on a user's message. This is only permitted as a
     * response to a `MESSAGE` event with a matched url, or a `CARD_CLICKED`
     * event where the message sender type is `HUMAN`. Text is ignored.
     * </pre>
     *
     * <code>UPDATE_USER_MESSAGE_CARDS = 6;</code>
     */
    public static final int UPDATE_USER_MESSAGE_CARDS_VALUE = 6;
    /**
     *
     *
     * <pre>
     * Privately ask the user for additional authentication or configuration.
     * </pre>
     *
     * <code>REQUEST_CONFIG = 3;</code>
     */
    public static final int REQUEST_CONFIG_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Presents a
     * [dialog](https://developers.google.com/chat/how-tos/dialogs).
     * </pre>
     *
     * <code>DIALOG = 4;</code>
     */
    public static final int DIALOG_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Widget text autocomplete options query.
     * </pre>
     *
     * <code>UPDATE_WIDGET = 7;</code>
     */
    public static final int UPDATE_WIDGET_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ResponseType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ResponseType forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return NEW_MESSAGE;
        case 2:
          return UPDATE_MESSAGE;
        case 6:
          return UPDATE_USER_MESSAGE_CARDS;
        case 3:
          return REQUEST_CONFIG;
        case 4:
          return DIALOG;
        case 7:
          return UPDATE_WIDGET;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ResponseType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ResponseType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ResponseType>() {
          public ResponseType findValueByNumber(int number) {
            return ResponseType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.chat.v1.ActionResponse.getDescriptor().getEnumTypes().get(0);
    }

    private static final ResponseType[] VALUES = values();

    public static ResponseType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ResponseType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.chat.v1.ActionResponse.ResponseType)
  }

  public interface SelectionItemsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.chat.v1.ActionResponse.SelectionItems)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * An array of the SelectionItem objects.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 1;</code>
     */
    java.util.List<com.google.apps.card.v1.SelectionInput.SelectionItem> getItemsList();
    /**
     *
     *
     * <pre>
     * An array of the SelectionItem objects.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 1;</code>
     */
    com.google.apps.card.v1.SelectionInput.SelectionItem getItems(int index);
    /**
     *
     *
     * <pre>
     * An array of the SelectionItem objects.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 1;</code>
     */
    int getItemsCount();
    /**
     *
     *
     * <pre>
     * An array of the SelectionItem objects.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 1;</code>
     */
    java.util.List<? extends com.google.apps.card.v1.SelectionInput.SelectionItemOrBuilder>
        getItemsOrBuilderList();
    /**
     *
     *
     * <pre>
     * An array of the SelectionItem objects.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 1;</code>
     */
    com.google.apps.card.v1.SelectionInput.SelectionItemOrBuilder getItemsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * List of widget autocomplete results.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.ActionResponse.SelectionItems}
   */
  public static final class SelectionItems extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.chat.v1.ActionResponse.SelectionItems)
      SelectionItemsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use SelectionItems.newBuilder() to construct.
    private SelectionItems(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SelectionItems() {
      items_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SelectionItems();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.MessageProto
          .internal_static_google_chat_v1_ActionResponse_SelectionItems_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.MessageProto
          .internal_static_google_chat_v1_ActionResponse_SelectionItems_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.ActionResponse.SelectionItems.class,
              com.google.chat.v1.ActionResponse.SelectionItems.Builder.class);
    }

    public static final int ITEMS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.apps.card.v1.SelectionInput.SelectionItem> items_;
    /**
     *
     *
     * <pre>
     * An array of the SelectionItem objects.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.apps.card.v1.SelectionInput.SelectionItem> getItemsList() {
      return items_;
    }
    /**
     *
     *
     * <pre>
     * An array of the SelectionItem objects.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.apps.card.v1.SelectionInput.SelectionItemOrBuilder>
        getItemsOrBuilderList() {
      return items_;
    }
    /**
     *
     *
     * <pre>
     * An array of the SelectionItem objects.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 1;</code>
     */
    @java.lang.Override
    public int getItemsCount() {
      return items_.size();
    }
    /**
     *
     *
     * <pre>
     * An array of the SelectionItem objects.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 1;</code>
     */
    @java.lang.Override
    public com.google.apps.card.v1.SelectionInput.SelectionItem getItems(int index) {
      return items_.get(index);
    }
    /**
     *
     *
     * <pre>
     * An array of the SelectionItem objects.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 1;</code>
     */
    @java.lang.Override
    public com.google.apps.card.v1.SelectionInput.SelectionItemOrBuilder getItemsOrBuilder(
        int index) {
      return items_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < items_.size(); i++) {
        output.writeMessage(1, items_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < items_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, items_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.chat.v1.ActionResponse.SelectionItems)) {
        return super.equals(obj);
      }
      com.google.chat.v1.ActionResponse.SelectionItems other =
          (com.google.chat.v1.ActionResponse.SelectionItems) obj;

      if (!getItemsList().equals(other.getItemsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getItemsCount() > 0) {
        hash = (37 * hash) + ITEMS_FIELD_NUMBER;
        hash = (53 * hash) + getItemsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.chat.v1.ActionResponse.SelectionItems parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.ActionResponse.SelectionItems parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.ActionResponse.SelectionItems parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.ActionResponse.SelectionItems parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.ActionResponse.SelectionItems parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.ActionResponse.SelectionItems parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.ActionResponse.SelectionItems parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.ActionResponse.SelectionItems parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.ActionResponse.SelectionItems parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.ActionResponse.SelectionItems parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.ActionResponse.SelectionItems parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.ActionResponse.SelectionItems parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.chat.v1.ActionResponse.SelectionItems prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * List of widget autocomplete results.
     * </pre>
     *
     * Protobuf type {@code google.chat.v1.ActionResponse.SelectionItems}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.chat.v1.ActionResponse.SelectionItems)
        com.google.chat.v1.ActionResponse.SelectionItemsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.chat.v1.MessageProto
            .internal_static_google_chat_v1_ActionResponse_SelectionItems_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.chat.v1.MessageProto
            .internal_static_google_chat_v1_ActionResponse_SelectionItems_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.chat.v1.ActionResponse.SelectionItems.class,
                com.google.chat.v1.ActionResponse.SelectionItems.Builder.class);
      }

      // Construct using com.google.chat.v1.ActionResponse.SelectionItems.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (itemsBuilder_ == null) {
          items_ = java.util.Collections.emptyList();
        } else {
          items_ = null;
          itemsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.chat.v1.MessageProto
            .internal_static_google_chat_v1_ActionResponse_SelectionItems_descriptor;
      }

      @java.lang.Override
      public com.google.chat.v1.ActionResponse.SelectionItems getDefaultInstanceForType() {
        return com.google.chat.v1.ActionResponse.SelectionItems.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.chat.v1.ActionResponse.SelectionItems build() {
        com.google.chat.v1.ActionResponse.SelectionItems result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.chat.v1.ActionResponse.SelectionItems buildPartial() {
        com.google.chat.v1.ActionResponse.SelectionItems result =
            new com.google.chat.v1.ActionResponse.SelectionItems(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.chat.v1.ActionResponse.SelectionItems result) {
        if (itemsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            items_ = java.util.Collections.unmodifiableList(items_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.items_ = items_;
        } else {
          result.items_ = itemsBuilder_.build();
        }
      }

      private void buildPartial0(com.google.chat.v1.ActionResponse.SelectionItems result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.chat.v1.ActionResponse.SelectionItems) {
          return mergeFrom((com.google.chat.v1.ActionResponse.SelectionItems) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.chat.v1.ActionResponse.SelectionItems other) {
        if (other == com.google.chat.v1.ActionResponse.SelectionItems.getDefaultInstance())
          return this;
        if (itemsBuilder_ == null) {
          if (!other.items_.isEmpty()) {
            if (items_.isEmpty()) {
              items_ = other.items_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureItemsIsMutable();
              items_.addAll(other.items_);
            }
            onChanged();
          }
        } else {
          if (!other.items_.isEmpty()) {
            if (itemsBuilder_.isEmpty()) {
              itemsBuilder_.dispose();
              itemsBuilder_ = null;
              items_ = other.items_;
              bitField0_ = (bitField0_ & ~0x00000001);
              itemsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getItemsFieldBuilder()
                      : null;
            } else {
              itemsBuilder_.addAllMessages(other.items_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.apps.card.v1.SelectionInput.SelectionItem m =
                      input.readMessage(
                          com.google.apps.card.v1.SelectionInput.SelectionItem.parser(),
                          extensionRegistry);
                  if (itemsBuilder_ == null) {
                    ensureItemsIsMutable();
                    items_.add(m);
                  } else {
                    itemsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.apps.card.v1.SelectionInput.SelectionItem> items_ =
          java.util.Collections.emptyList();

      private void ensureItemsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          items_ =
              new java.util.ArrayList<com.google.apps.card.v1.SelectionInput.SelectionItem>(items_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.apps.card.v1.SelectionInput.SelectionItem,
              com.google.apps.card.v1.SelectionInput.SelectionItem.Builder,
              com.google.apps.card.v1.SelectionInput.SelectionItemOrBuilder>
          itemsBuilder_;

      /**
       *
       *
       * <pre>
       * An array of the SelectionItem objects.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 1;</code>
       */
      public java.util.List<com.google.apps.card.v1.SelectionInput.SelectionItem> getItemsList() {
        if (itemsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(items_);
        } else {
          return itemsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * An array of the SelectionItem objects.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 1;</code>
       */
      public int getItemsCount() {
        if (itemsBuilder_ == null) {
          return items_.size();
        } else {
          return itemsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * An array of the SelectionItem objects.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 1;</code>
       */
      public com.google.apps.card.v1.SelectionInput.SelectionItem getItems(int index) {
        if (itemsBuilder_ == null) {
          return items_.get(index);
        } else {
          return itemsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * An array of the SelectionItem objects.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 1;</code>
       */
      public Builder setItems(
          int index, com.google.apps.card.v1.SelectionInput.SelectionItem value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.set(index, value);
          onChanged();
        } else {
          itemsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An array of the SelectionItem objects.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 1;</code>
       */
      public Builder setItems(
          int index, com.google.apps.card.v1.SelectionInput.SelectionItem.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.set(index, builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An array of the SelectionItem objects.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 1;</code>
       */
      public Builder addItems(com.google.apps.card.v1.SelectionInput.SelectionItem value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.add(value);
          onChanged();
        } else {
          itemsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An array of the SelectionItem objects.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 1;</code>
       */
      public Builder addItems(
          int index, com.google.apps.card.v1.SelectionInput.SelectionItem value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.add(index, value);
          onChanged();
        } else {
          itemsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An array of the SelectionItem objects.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 1;</code>
       */
      public Builder addItems(
          com.google.apps.card.v1.SelectionInput.SelectionItem.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.add(builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An array of the SelectionItem objects.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 1;</code>
       */
      public Builder addItems(
          int index, com.google.apps.card.v1.SelectionInput.SelectionItem.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.add(index, builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An array of the SelectionItem objects.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 1;</code>
       */
      public Builder addAllItems(
          java.lang.Iterable<? extends com.google.apps.card.v1.SelectionInput.SelectionItem>
              values) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, items_);
          onChanged();
        } else {
          itemsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An array of the SelectionItem objects.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 1;</code>
       */
      public Builder clearItems() {
        if (itemsBuilder_ == null) {
          items_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          itemsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An array of the SelectionItem objects.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 1;</code>
       */
      public Builder removeItems(int index) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.remove(index);
          onChanged();
        } else {
          itemsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * An array of the SelectionItem objects.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 1;</code>
       */
      public com.google.apps.card.v1.SelectionInput.SelectionItem.Builder getItemsBuilder(
          int index) {
        return getItemsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * An array of the SelectionItem objects.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 1;</code>
       */
      public com.google.apps.card.v1.SelectionInput.SelectionItemOrBuilder getItemsOrBuilder(
          int index) {
        if (itemsBuilder_ == null) {
          return items_.get(index);
        } else {
          return itemsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * An array of the SelectionItem objects.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 1;</code>
       */
      public java.util.List<? extends com.google.apps.card.v1.SelectionInput.SelectionItemOrBuilder>
          getItemsOrBuilderList() {
        if (itemsBuilder_ != null) {
          return itemsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(items_);
        }
      }
      /**
       *
       *
       * <pre>
       * An array of the SelectionItem objects.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 1;</code>
       */
      public com.google.apps.card.v1.SelectionInput.SelectionItem.Builder addItemsBuilder() {
        return getItemsFieldBuilder()
            .addBuilder(com.google.apps.card.v1.SelectionInput.SelectionItem.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * An array of the SelectionItem objects.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 1;</code>
       */
      public com.google.apps.card.v1.SelectionInput.SelectionItem.Builder addItemsBuilder(
          int index) {
        return getItemsFieldBuilder()
            .addBuilder(
                index, com.google.apps.card.v1.SelectionInput.SelectionItem.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * An array of the SelectionItem objects.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.SelectionInput.SelectionItem items = 1;</code>
       */
      public java.util.List<com.google.apps.card.v1.SelectionInput.SelectionItem.Builder>
          getItemsBuilderList() {
        return getItemsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.apps.card.v1.SelectionInput.SelectionItem,
              com.google.apps.card.v1.SelectionInput.SelectionItem.Builder,
              com.google.apps.card.v1.SelectionInput.SelectionItemOrBuilder>
          getItemsFieldBuilder() {
        if (itemsBuilder_ == null) {
          itemsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.apps.card.v1.SelectionInput.SelectionItem,
                  com.google.apps.card.v1.SelectionInput.SelectionItem.Builder,
                  com.google.apps.card.v1.SelectionInput.SelectionItemOrBuilder>(
                  items_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          items_ = null;
        }
        return itemsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.chat.v1.ActionResponse.SelectionItems)
    }

    // @@protoc_insertion_point(class_scope:google.chat.v1.ActionResponse.SelectionItems)
    private static final com.google.chat.v1.ActionResponse.SelectionItems DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.chat.v1.ActionResponse.SelectionItems();
    }

    public static com.google.chat.v1.ActionResponse.SelectionItems getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SelectionItems> PARSER =
        new com.google.protobuf.AbstractParser<SelectionItems>() {
          @java.lang.Override
          public SelectionItems parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SelectionItems> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SelectionItems> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.chat.v1.ActionResponse.SelectionItems getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface UpdatedWidgetOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.chat.v1.ActionResponse.UpdatedWidget)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * List of widget autocomplete results
     * </pre>
     *
     * <code>.google.chat.v1.ActionResponse.SelectionItems suggestions = 1;</code>
     *
     * @return Whether the suggestions field is set.
     */
    boolean hasSuggestions();
    /**
     *
     *
     * <pre>
     * List of widget autocomplete results
     * </pre>
     *
     * <code>.google.chat.v1.ActionResponse.SelectionItems suggestions = 1;</code>
     *
     * @return The suggestions.
     */
    com.google.chat.v1.ActionResponse.SelectionItems getSuggestions();
    /**
     *
     *
     * <pre>
     * List of widget autocomplete results
     * </pre>
     *
     * <code>.google.chat.v1.ActionResponse.SelectionItems suggestions = 1;</code>
     */
    com.google.chat.v1.ActionResponse.SelectionItemsOrBuilder getSuggestionsOrBuilder();

    /**
     *
     *
     * <pre>
     * The ID of the updated widget. The ID must match the one for the
     * widget that triggered the update request.
     * </pre>
     *
     * <code>string widget = 2;</code>
     *
     * @return The widget.
     */
    java.lang.String getWidget();
    /**
     *
     *
     * <pre>
     * The ID of the updated widget. The ID must match the one for the
     * widget that triggered the update request.
     * </pre>
     *
     * <code>string widget = 2;</code>
     *
     * @return The bytes for widget.
     */
    com.google.protobuf.ByteString getWidgetBytes();

    com.google.chat.v1.ActionResponse.UpdatedWidget.UpdatedWidgetCase getUpdatedWidgetCase();
  }
  /**
   *
   *
   * <pre>
   * The response of the updated widget.
   * Used to provide autocomplete options for a widget.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.ActionResponse.UpdatedWidget}
   */
  public static final class UpdatedWidget extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.chat.v1.ActionResponse.UpdatedWidget)
      UpdatedWidgetOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use UpdatedWidget.newBuilder() to construct.
    private UpdatedWidget(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private UpdatedWidget() {
      widget_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new UpdatedWidget();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.MessageProto
          .internal_static_google_chat_v1_ActionResponse_UpdatedWidget_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.MessageProto
          .internal_static_google_chat_v1_ActionResponse_UpdatedWidget_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.ActionResponse.UpdatedWidget.class,
              com.google.chat.v1.ActionResponse.UpdatedWidget.Builder.class);
    }

    private int updatedWidgetCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object updatedWidget_;

    public enum UpdatedWidgetCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      SUGGESTIONS(1),
      UPDATEDWIDGET_NOT_SET(0);
      private final int value;

      private UpdatedWidgetCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static UpdatedWidgetCase valueOf(int value) {
        return forNumber(value);
      }

      public static UpdatedWidgetCase forNumber(int value) {
        switch (value) {
          case 1:
            return SUGGESTIONS;
          case 0:
            return UPDATEDWIDGET_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public UpdatedWidgetCase getUpdatedWidgetCase() {
      return UpdatedWidgetCase.forNumber(updatedWidgetCase_);
    }

    public static final int SUGGESTIONS_FIELD_NUMBER = 1;
    /**
     *
     *
     * <pre>
     * List of widget autocomplete results
     * </pre>
     *
     * <code>.google.chat.v1.ActionResponse.SelectionItems suggestions = 1;</code>
     *
     * @return Whether the suggestions field is set.
     */
    @java.lang.Override
    public boolean hasSuggestions() {
      return updatedWidgetCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * List of widget autocomplete results
     * </pre>
     *
     * <code>.google.chat.v1.ActionResponse.SelectionItems suggestions = 1;</code>
     *
     * @return The suggestions.
     */
    @java.lang.Override
    public com.google.chat.v1.ActionResponse.SelectionItems getSuggestions() {
      if (updatedWidgetCase_ == 1) {
        return (com.google.chat.v1.ActionResponse.SelectionItems) updatedWidget_;
      }
      return com.google.chat.v1.ActionResponse.SelectionItems.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * List of widget autocomplete results
     * </pre>
     *
     * <code>.google.chat.v1.ActionResponse.SelectionItems suggestions = 1;</code>
     */
    @java.lang.Override
    public com.google.chat.v1.ActionResponse.SelectionItemsOrBuilder getSuggestionsOrBuilder() {
      if (updatedWidgetCase_ == 1) {
        return (com.google.chat.v1.ActionResponse.SelectionItems) updatedWidget_;
      }
      return com.google.chat.v1.ActionResponse.SelectionItems.getDefaultInstance();
    }

    public static final int WIDGET_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object widget_ = "";
    /**
     *
     *
     * <pre>
     * The ID of the updated widget. The ID must match the one for the
     * widget that triggered the update request.
     * </pre>
     *
     * <code>string widget = 2;</code>
     *
     * @return The widget.
     */
    @java.lang.Override
    public java.lang.String getWidget() {
      java.lang.Object ref = widget_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        widget_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The ID of the updated widget. The ID must match the one for the
     * widget that triggered the update request.
     * </pre>
     *
     * <code>string widget = 2;</code>
     *
     * @return The bytes for widget.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getWidgetBytes() {
      java.lang.Object ref = widget_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        widget_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (updatedWidgetCase_ == 1) {
        output.writeMessage(1, (com.google.chat.v1.ActionResponse.SelectionItems) updatedWidget_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(widget_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, widget_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (updatedWidgetCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, (com.google.chat.v1.ActionResponse.SelectionItems) updatedWidget_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(widget_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, widget_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.chat.v1.ActionResponse.UpdatedWidget)) {
        return super.equals(obj);
      }
      com.google.chat.v1.ActionResponse.UpdatedWidget other =
          (com.google.chat.v1.ActionResponse.UpdatedWidget) obj;

      if (!getWidget().equals(other.getWidget())) return false;
      if (!getUpdatedWidgetCase().equals(other.getUpdatedWidgetCase())) return false;
      switch (updatedWidgetCase_) {
        case 1:
          if (!getSuggestions().equals(other.getSuggestions())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + WIDGET_FIELD_NUMBER;
      hash = (53 * hash) + getWidget().hashCode();
      switch (updatedWidgetCase_) {
        case 1:
          hash = (37 * hash) + SUGGESTIONS_FIELD_NUMBER;
          hash = (53 * hash) + getSuggestions().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.chat.v1.ActionResponse.UpdatedWidget parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.ActionResponse.UpdatedWidget parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.ActionResponse.UpdatedWidget parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.ActionResponse.UpdatedWidget parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.ActionResponse.UpdatedWidget parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.chat.v1.ActionResponse.UpdatedWidget parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.chat.v1.ActionResponse.UpdatedWidget parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.ActionResponse.UpdatedWidget parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.ActionResponse.UpdatedWidget parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.ActionResponse.UpdatedWidget parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.chat.v1.ActionResponse.UpdatedWidget parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.chat.v1.ActionResponse.UpdatedWidget parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.chat.v1.ActionResponse.UpdatedWidget prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The response of the updated widget.
     * Used to provide autocomplete options for a widget.
     * </pre>
     *
     * Protobuf type {@code google.chat.v1.ActionResponse.UpdatedWidget}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.chat.v1.ActionResponse.UpdatedWidget)
        com.google.chat.v1.ActionResponse.UpdatedWidgetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.chat.v1.MessageProto
            .internal_static_google_chat_v1_ActionResponse_UpdatedWidget_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.chat.v1.MessageProto
            .internal_static_google_chat_v1_ActionResponse_UpdatedWidget_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.chat.v1.ActionResponse.UpdatedWidget.class,
                com.google.chat.v1.ActionResponse.UpdatedWidget.Builder.class);
      }

      // Construct using com.google.chat.v1.ActionResponse.UpdatedWidget.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (suggestionsBuilder_ != null) {
          suggestionsBuilder_.clear();
        }
        widget_ = "";
        updatedWidgetCase_ = 0;
        updatedWidget_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.chat.v1.MessageProto
            .internal_static_google_chat_v1_ActionResponse_UpdatedWidget_descriptor;
      }

      @java.lang.Override
      public com.google.chat.v1.ActionResponse.UpdatedWidget getDefaultInstanceForType() {
        return com.google.chat.v1.ActionResponse.UpdatedWidget.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.chat.v1.ActionResponse.UpdatedWidget build() {
        com.google.chat.v1.ActionResponse.UpdatedWidget result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.chat.v1.ActionResponse.UpdatedWidget buildPartial() {
        com.google.chat.v1.ActionResponse.UpdatedWidget result =
            new com.google.chat.v1.ActionResponse.UpdatedWidget(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.chat.v1.ActionResponse.UpdatedWidget result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.widget_ = widget_;
        }
      }

      private void buildPartialOneofs(com.google.chat.v1.ActionResponse.UpdatedWidget result) {
        result.updatedWidgetCase_ = updatedWidgetCase_;
        result.updatedWidget_ = this.updatedWidget_;
        if (updatedWidgetCase_ == 1 && suggestionsBuilder_ != null) {
          result.updatedWidget_ = suggestionsBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.chat.v1.ActionResponse.UpdatedWidget) {
          return mergeFrom((com.google.chat.v1.ActionResponse.UpdatedWidget) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.chat.v1.ActionResponse.UpdatedWidget other) {
        if (other == com.google.chat.v1.ActionResponse.UpdatedWidget.getDefaultInstance())
          return this;
        if (!other.getWidget().isEmpty()) {
          widget_ = other.widget_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        switch (other.getUpdatedWidgetCase()) {
          case SUGGESTIONS:
            {
              mergeSuggestions(other.getSuggestions());
              break;
            }
          case UPDATEDWIDGET_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getSuggestionsFieldBuilder().getBuilder(), extensionRegistry);
                  updatedWidgetCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  widget_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int updatedWidgetCase_ = 0;
      private java.lang.Object updatedWidget_;

      public UpdatedWidgetCase getUpdatedWidgetCase() {
        return UpdatedWidgetCase.forNumber(updatedWidgetCase_);
      }

      public Builder clearUpdatedWidget() {
        updatedWidgetCase_ = 0;
        updatedWidget_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.ActionResponse.SelectionItems,
              com.google.chat.v1.ActionResponse.SelectionItems.Builder,
              com.google.chat.v1.ActionResponse.SelectionItemsOrBuilder>
          suggestionsBuilder_;
      /**
       *
       *
       * <pre>
       * List of widget autocomplete results
       * </pre>
       *
       * <code>.google.chat.v1.ActionResponse.SelectionItems suggestions = 1;</code>
       *
       * @return Whether the suggestions field is set.
       */
      @java.lang.Override
      public boolean hasSuggestions() {
        return updatedWidgetCase_ == 1;
      }
      /**
       *
       *
       * <pre>
       * List of widget autocomplete results
       * </pre>
       *
       * <code>.google.chat.v1.ActionResponse.SelectionItems suggestions = 1;</code>
       *
       * @return The suggestions.
       */
      @java.lang.Override
      public com.google.chat.v1.ActionResponse.SelectionItems getSuggestions() {
        if (suggestionsBuilder_ == null) {
          if (updatedWidgetCase_ == 1) {
            return (com.google.chat.v1.ActionResponse.SelectionItems) updatedWidget_;
          }
          return com.google.chat.v1.ActionResponse.SelectionItems.getDefaultInstance();
        } else {
          if (updatedWidgetCase_ == 1) {
            return suggestionsBuilder_.getMessage();
          }
          return com.google.chat.v1.ActionResponse.SelectionItems.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * List of widget autocomplete results
       * </pre>
       *
       * <code>.google.chat.v1.ActionResponse.SelectionItems suggestions = 1;</code>
       */
      public Builder setSuggestions(com.google.chat.v1.ActionResponse.SelectionItems value) {
        if (suggestionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          updatedWidget_ = value;
          onChanged();
        } else {
          suggestionsBuilder_.setMessage(value);
        }
        updatedWidgetCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of widget autocomplete results
       * </pre>
       *
       * <code>.google.chat.v1.ActionResponse.SelectionItems suggestions = 1;</code>
       */
      public Builder setSuggestions(
          com.google.chat.v1.ActionResponse.SelectionItems.Builder builderForValue) {
        if (suggestionsBuilder_ == null) {
          updatedWidget_ = builderForValue.build();
          onChanged();
        } else {
          suggestionsBuilder_.setMessage(builderForValue.build());
        }
        updatedWidgetCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of widget autocomplete results
       * </pre>
       *
       * <code>.google.chat.v1.ActionResponse.SelectionItems suggestions = 1;</code>
       */
      public Builder mergeSuggestions(com.google.chat.v1.ActionResponse.SelectionItems value) {
        if (suggestionsBuilder_ == null) {
          if (updatedWidgetCase_ == 1
              && updatedWidget_
                  != com.google.chat.v1.ActionResponse.SelectionItems.getDefaultInstance()) {
            updatedWidget_ =
                com.google.chat.v1.ActionResponse.SelectionItems.newBuilder(
                        (com.google.chat.v1.ActionResponse.SelectionItems) updatedWidget_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            updatedWidget_ = value;
          }
          onChanged();
        } else {
          if (updatedWidgetCase_ == 1) {
            suggestionsBuilder_.mergeFrom(value);
          } else {
            suggestionsBuilder_.setMessage(value);
          }
        }
        updatedWidgetCase_ = 1;
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of widget autocomplete results
       * </pre>
       *
       * <code>.google.chat.v1.ActionResponse.SelectionItems suggestions = 1;</code>
       */
      public Builder clearSuggestions() {
        if (suggestionsBuilder_ == null) {
          if (updatedWidgetCase_ == 1) {
            updatedWidgetCase_ = 0;
            updatedWidget_ = null;
            onChanged();
          }
        } else {
          if (updatedWidgetCase_ == 1) {
            updatedWidgetCase_ = 0;
            updatedWidget_ = null;
          }
          suggestionsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of widget autocomplete results
       * </pre>
       *
       * <code>.google.chat.v1.ActionResponse.SelectionItems suggestions = 1;</code>
       */
      public com.google.chat.v1.ActionResponse.SelectionItems.Builder getSuggestionsBuilder() {
        return getSuggestionsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * List of widget autocomplete results
       * </pre>
       *
       * <code>.google.chat.v1.ActionResponse.SelectionItems suggestions = 1;</code>
       */
      @java.lang.Override
      public com.google.chat.v1.ActionResponse.SelectionItemsOrBuilder getSuggestionsOrBuilder() {
        if ((updatedWidgetCase_ == 1) && (suggestionsBuilder_ != null)) {
          return suggestionsBuilder_.getMessageOrBuilder();
        } else {
          if (updatedWidgetCase_ == 1) {
            return (com.google.chat.v1.ActionResponse.SelectionItems) updatedWidget_;
          }
          return com.google.chat.v1.ActionResponse.SelectionItems.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * List of widget autocomplete results
       * </pre>
       *
       * <code>.google.chat.v1.ActionResponse.SelectionItems suggestions = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.chat.v1.ActionResponse.SelectionItems,
              com.google.chat.v1.ActionResponse.SelectionItems.Builder,
              com.google.chat.v1.ActionResponse.SelectionItemsOrBuilder>
          getSuggestionsFieldBuilder() {
        if (suggestionsBuilder_ == null) {
          if (!(updatedWidgetCase_ == 1)) {
            updatedWidget_ = com.google.chat.v1.ActionResponse.SelectionItems.getDefaultInstance();
          }
          suggestionsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.chat.v1.ActionResponse.SelectionItems,
                  com.google.chat.v1.ActionResponse.SelectionItems.Builder,
                  com.google.chat.v1.ActionResponse.SelectionItemsOrBuilder>(
                  (com.google.chat.v1.ActionResponse.SelectionItems) updatedWidget_,
                  getParentForChildren(),
                  isClean());
          updatedWidget_ = null;
        }
        updatedWidgetCase_ = 1;
        onChanged();
        return suggestionsBuilder_;
      }

      private java.lang.Object widget_ = "";
      /**
       *
       *
       * <pre>
       * The ID of the updated widget. The ID must match the one for the
       * widget that triggered the update request.
       * </pre>
       *
       * <code>string widget = 2;</code>
       *
       * @return The widget.
       */
      public java.lang.String getWidget() {
        java.lang.Object ref = widget_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          widget_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The ID of the updated widget. The ID must match the one for the
       * widget that triggered the update request.
       * </pre>
       *
       * <code>string widget = 2;</code>
       *
       * @return The bytes for widget.
       */
      public com.google.protobuf.ByteString getWidgetBytes() {
        java.lang.Object ref = widget_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          widget_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The ID of the updated widget. The ID must match the one for the
       * widget that triggered the update request.
       * </pre>
       *
       * <code>string widget = 2;</code>
       *
       * @param value The widget to set.
       * @return This builder for chaining.
       */
      public Builder setWidget(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        widget_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ID of the updated widget. The ID must match the one for the
       * widget that triggered the update request.
       * </pre>
       *
       * <code>string widget = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearWidget() {
        widget_ = getDefaultInstance().getWidget();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The ID of the updated widget. The ID must match the one for the
       * widget that triggered the update request.
       * </pre>
       *
       * <code>string widget = 2;</code>
       *
       * @param value The bytes for widget to set.
       * @return This builder for chaining.
       */
      public Builder setWidgetBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        widget_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.chat.v1.ActionResponse.UpdatedWidget)
    }

    // @@protoc_insertion_point(class_scope:google.chat.v1.ActionResponse.UpdatedWidget)
    private static final com.google.chat.v1.ActionResponse.UpdatedWidget DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.chat.v1.ActionResponse.UpdatedWidget();
    }

    public static com.google.chat.v1.ActionResponse.UpdatedWidget getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<UpdatedWidget> PARSER =
        new com.google.protobuf.AbstractParser<UpdatedWidget>() {
          @java.lang.Override
          public UpdatedWidget parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<UpdatedWidget> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<UpdatedWidget> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.chat.v1.ActionResponse.UpdatedWidget getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int TYPE_FIELD_NUMBER = 1;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * Input only. The type of Chat app response.
   * </pre>
   *
   * <code>
   * .google.chat.v1.ActionResponse.ResponseType type = 1 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * Input only. The type of Chat app response.
   * </pre>
   *
   * <code>
   * .google.chat.v1.ActionResponse.ResponseType type = 1 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.chat.v1.ActionResponse.ResponseType getType() {
    com.google.chat.v1.ActionResponse.ResponseType result =
        com.google.chat.v1.ActionResponse.ResponseType.forNumber(type_);
    return result == null ? com.google.chat.v1.ActionResponse.ResponseType.UNRECOGNIZED : result;
  }

  public static final int URL_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object url_ = "";
  /**
   *
   *
   * <pre>
   * Input only. URL for users to authenticate or configure. (Only for
   * `REQUEST_CONFIG` response types.)
   * </pre>
   *
   * <code>string url = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The url.
   */
  @java.lang.Override
  public java.lang.String getUrl() {
    java.lang.Object ref = url_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      url_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Input only. URL for users to authenticate or configure. (Only for
   * `REQUEST_CONFIG` response types.)
   * </pre>
   *
   * <code>string url = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
   *
   * @return The bytes for url.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUrlBytes() {
    java.lang.Object ref = url_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      url_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DIALOG_ACTION_FIELD_NUMBER = 3;
  private com.google.chat.v1.DialogAction dialogAction_;
  /**
   *
   *
   * <pre>
   * Input only. A response to an interaction event related to a
   * [dialog](https://developers.google.com/chat/how-tos/dialogs). Must be
   * accompanied by `ResponseType.Dialog`.
   * </pre>
   *
   * <code>
   * .google.chat.v1.DialogAction dialog_action = 3 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return Whether the dialogAction field is set.
   */
  @java.lang.Override
  public boolean hasDialogAction() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Input only. A response to an interaction event related to a
   * [dialog](https://developers.google.com/chat/how-tos/dialogs). Must be
   * accompanied by `ResponseType.Dialog`.
   * </pre>
   *
   * <code>
   * .google.chat.v1.DialogAction dialog_action = 3 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return The dialogAction.
   */
  @java.lang.Override
  public com.google.chat.v1.DialogAction getDialogAction() {
    return dialogAction_ == null
        ? com.google.chat.v1.DialogAction.getDefaultInstance()
        : dialogAction_;
  }
  /**
   *
   *
   * <pre>
   * Input only. A response to an interaction event related to a
   * [dialog](https://developers.google.com/chat/how-tos/dialogs). Must be
   * accompanied by `ResponseType.Dialog`.
   * </pre>
   *
   * <code>
   * .google.chat.v1.DialogAction dialog_action = 3 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.DialogActionOrBuilder getDialogActionOrBuilder() {
    return dialogAction_ == null
        ? com.google.chat.v1.DialogAction.getDefaultInstance()
        : dialogAction_;
  }

  public static final int UPDATED_WIDGET_FIELD_NUMBER = 4;
  private com.google.chat.v1.ActionResponse.UpdatedWidget updatedWidget_;
  /**
   *
   *
   * <pre>
   * Input only. The response of the updated widget.
   * </pre>
   *
   * <code>
   * .google.chat.v1.ActionResponse.UpdatedWidget updated_widget = 4 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return Whether the updatedWidget field is set.
   */
  @java.lang.Override
  public boolean hasUpdatedWidget() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Input only. The response of the updated widget.
   * </pre>
   *
   * <code>
   * .google.chat.v1.ActionResponse.UpdatedWidget updated_widget = 4 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return The updatedWidget.
   */
  @java.lang.Override
  public com.google.chat.v1.ActionResponse.UpdatedWidget getUpdatedWidget() {
    return updatedWidget_ == null
        ? com.google.chat.v1.ActionResponse.UpdatedWidget.getDefaultInstance()
        : updatedWidget_;
  }
  /**
   *
   *
   * <pre>
   * Input only. The response of the updated widget.
   * </pre>
   *
   * <code>
   * .google.chat.v1.ActionResponse.UpdatedWidget updated_widget = 4 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.chat.v1.ActionResponse.UpdatedWidgetOrBuilder getUpdatedWidgetOrBuilder() {
    return updatedWidget_ == null
        ? com.google.chat.v1.ActionResponse.UpdatedWidget.getDefaultInstance()
        : updatedWidget_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (type_ != com.google.chat.v1.ActionResponse.ResponseType.TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(url_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, url_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getDialogAction());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getUpdatedWidget());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (type_ != com.google.chat.v1.ActionResponse.ResponseType.TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(url_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, url_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getDialogAction());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getUpdatedWidget());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.chat.v1.ActionResponse)) {
      return super.equals(obj);
    }
    com.google.chat.v1.ActionResponse other = (com.google.chat.v1.ActionResponse) obj;

    if (type_ != other.type_) return false;
    if (!getUrl().equals(other.getUrl())) return false;
    if (hasDialogAction() != other.hasDialogAction()) return false;
    if (hasDialogAction()) {
      if (!getDialogAction().equals(other.getDialogAction())) return false;
    }
    if (hasUpdatedWidget() != other.hasUpdatedWidget()) return false;
    if (hasUpdatedWidget()) {
      if (!getUpdatedWidget().equals(other.getUpdatedWidget())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + URL_FIELD_NUMBER;
    hash = (53 * hash) + getUrl().hashCode();
    if (hasDialogAction()) {
      hash = (37 * hash) + DIALOG_ACTION_FIELD_NUMBER;
      hash = (53 * hash) + getDialogAction().hashCode();
    }
    if (hasUpdatedWidget()) {
      hash = (37 * hash) + UPDATED_WIDGET_FIELD_NUMBER;
      hash = (53 * hash) + getUpdatedWidget().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.chat.v1.ActionResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.ActionResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.ActionResponse parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.ActionResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.ActionResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.ActionResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.ActionResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.ActionResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.ActionResponse parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.ActionResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.ActionResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.ActionResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.chat.v1.ActionResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Parameters that a Chat app can use to configure how its response is posted.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.ActionResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.chat.v1.ActionResponse)
      com.google.chat.v1.ActionResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.MessageProto
          .internal_static_google_chat_v1_ActionResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.MessageProto
          .internal_static_google_chat_v1_ActionResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.ActionResponse.class,
              com.google.chat.v1.ActionResponse.Builder.class);
    }

    // Construct using com.google.chat.v1.ActionResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getDialogActionFieldBuilder();
        getUpdatedWidgetFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      type_ = 0;
      url_ = "";
      dialogAction_ = null;
      if (dialogActionBuilder_ != null) {
        dialogActionBuilder_.dispose();
        dialogActionBuilder_ = null;
      }
      updatedWidget_ = null;
      if (updatedWidgetBuilder_ != null) {
        updatedWidgetBuilder_.dispose();
        updatedWidgetBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.chat.v1.MessageProto
          .internal_static_google_chat_v1_ActionResponse_descriptor;
    }

    @java.lang.Override
    public com.google.chat.v1.ActionResponse getDefaultInstanceForType() {
      return com.google.chat.v1.ActionResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.chat.v1.ActionResponse build() {
      com.google.chat.v1.ActionResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.chat.v1.ActionResponse buildPartial() {
      com.google.chat.v1.ActionResponse result = new com.google.chat.v1.ActionResponse(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.chat.v1.ActionResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.url_ = url_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.dialogAction_ =
            dialogActionBuilder_ == null ? dialogAction_ : dialogActionBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.updatedWidget_ =
            updatedWidgetBuilder_ == null ? updatedWidget_ : updatedWidgetBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.chat.v1.ActionResponse) {
        return mergeFrom((com.google.chat.v1.ActionResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.chat.v1.ActionResponse other) {
      if (other == com.google.chat.v1.ActionResponse.getDefaultInstance()) return this;
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (!other.getUrl().isEmpty()) {
        url_ = other.url_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasDialogAction()) {
        mergeDialogAction(other.getDialogAction());
      }
      if (other.hasUpdatedWidget()) {
        mergeUpdatedWidget(other.getUpdatedWidget());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                url_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getDialogActionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getUpdatedWidgetFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * Input only. The type of Chat app response.
     * </pre>
     *
     * <code>
     * .google.chat.v1.ActionResponse.ResponseType type = 1 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Input only. The type of Chat app response.
     * </pre>
     *
     * <code>
     * .google.chat.v1.ActionResponse.ResponseType type = 1 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The type of Chat app response.
     * </pre>
     *
     * <code>
     * .google.chat.v1.ActionResponse.ResponseType type = 1 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.chat.v1.ActionResponse.ResponseType getType() {
      com.google.chat.v1.ActionResponse.ResponseType result =
          com.google.chat.v1.ActionResponse.ResponseType.forNumber(type_);
      return result == null ? com.google.chat.v1.ActionResponse.ResponseType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Input only. The type of Chat app response.
     * </pre>
     *
     * <code>
     * .google.chat.v1.ActionResponse.ResponseType type = 1 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.chat.v1.ActionResponse.ResponseType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The type of Chat app response.
     * </pre>
     *
     * <code>
     * .google.chat.v1.ActionResponse.ResponseType type = 1 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000001);
      type_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object url_ = "";
    /**
     *
     *
     * <pre>
     * Input only. URL for users to authenticate or configure. (Only for
     * `REQUEST_CONFIG` response types.)
     * </pre>
     *
     * <code>string url = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The url.
     */
    public java.lang.String getUrl() {
      java.lang.Object ref = url_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        url_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. URL for users to authenticate or configure. (Only for
     * `REQUEST_CONFIG` response types.)
     * </pre>
     *
     * <code>string url = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return The bytes for url.
     */
    public com.google.protobuf.ByteString getUrlBytes() {
      java.lang.Object ref = url_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        url_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. URL for users to authenticate or configure. (Only for
     * `REQUEST_CONFIG` response types.)
     * </pre>
     *
     * <code>string url = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The url to set.
     * @return This builder for chaining.
     */
    public Builder setUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      url_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. URL for users to authenticate or configure. (Only for
     * `REQUEST_CONFIG` response types.)
     * </pre>
     *
     * <code>string url = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUrl() {
      url_ = getDefaultInstance().getUrl();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. URL for users to authenticate or configure. (Only for
     * `REQUEST_CONFIG` response types.)
     * </pre>
     *
     * <code>string url = 2 [(.google.api.field_behavior) = INPUT_ONLY];</code>
     *
     * @param value The bytes for url to set.
     * @return This builder for chaining.
     */
    public Builder setUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      url_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.chat.v1.DialogAction dialogAction_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.DialogAction,
            com.google.chat.v1.DialogAction.Builder,
            com.google.chat.v1.DialogActionOrBuilder>
        dialogActionBuilder_;
    /**
     *
     *
     * <pre>
     * Input only. A response to an interaction event related to a
     * [dialog](https://developers.google.com/chat/how-tos/dialogs). Must be
     * accompanied by `ResponseType.Dialog`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.DialogAction dialog_action = 3 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return Whether the dialogAction field is set.
     */
    public boolean hasDialogAction() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Input only. A response to an interaction event related to a
     * [dialog](https://developers.google.com/chat/how-tos/dialogs). Must be
     * accompanied by `ResponseType.Dialog`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.DialogAction dialog_action = 3 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The dialogAction.
     */
    public com.google.chat.v1.DialogAction getDialogAction() {
      if (dialogActionBuilder_ == null) {
        return dialogAction_ == null
            ? com.google.chat.v1.DialogAction.getDefaultInstance()
            : dialogAction_;
      } else {
        return dialogActionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. A response to an interaction event related to a
     * [dialog](https://developers.google.com/chat/how-tos/dialogs). Must be
     * accompanied by `ResponseType.Dialog`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.DialogAction dialog_action = 3 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder setDialogAction(com.google.chat.v1.DialogAction value) {
      if (dialogActionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dialogAction_ = value;
      } else {
        dialogActionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. A response to an interaction event related to a
     * [dialog](https://developers.google.com/chat/how-tos/dialogs). Must be
     * accompanied by `ResponseType.Dialog`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.DialogAction dialog_action = 3 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder setDialogAction(com.google.chat.v1.DialogAction.Builder builderForValue) {
      if (dialogActionBuilder_ == null) {
        dialogAction_ = builderForValue.build();
      } else {
        dialogActionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. A response to an interaction event related to a
     * [dialog](https://developers.google.com/chat/how-tos/dialogs). Must be
     * accompanied by `ResponseType.Dialog`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.DialogAction dialog_action = 3 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder mergeDialogAction(com.google.chat.v1.DialogAction value) {
      if (dialogActionBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && dialogAction_ != null
            && dialogAction_ != com.google.chat.v1.DialogAction.getDefaultInstance()) {
          getDialogActionBuilder().mergeFrom(value);
        } else {
          dialogAction_ = value;
        }
      } else {
        dialogActionBuilder_.mergeFrom(value);
      }
      if (dialogAction_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. A response to an interaction event related to a
     * [dialog](https://developers.google.com/chat/how-tos/dialogs). Must be
     * accompanied by `ResponseType.Dialog`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.DialogAction dialog_action = 3 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder clearDialogAction() {
      bitField0_ = (bitField0_ & ~0x00000004);
      dialogAction_ = null;
      if (dialogActionBuilder_ != null) {
        dialogActionBuilder_.dispose();
        dialogActionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. A response to an interaction event related to a
     * [dialog](https://developers.google.com/chat/how-tos/dialogs). Must be
     * accompanied by `ResponseType.Dialog`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.DialogAction dialog_action = 3 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.DialogAction.Builder getDialogActionBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getDialogActionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input only. A response to an interaction event related to a
     * [dialog](https://developers.google.com/chat/how-tos/dialogs). Must be
     * accompanied by `ResponseType.Dialog`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.DialogAction dialog_action = 3 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.DialogActionOrBuilder getDialogActionOrBuilder() {
      if (dialogActionBuilder_ != null) {
        return dialogActionBuilder_.getMessageOrBuilder();
      } else {
        return dialogAction_ == null
            ? com.google.chat.v1.DialogAction.getDefaultInstance()
            : dialogAction_;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. A response to an interaction event related to a
     * [dialog](https://developers.google.com/chat/how-tos/dialogs). Must be
     * accompanied by `ResponseType.Dialog`.
     * </pre>
     *
     * <code>
     * .google.chat.v1.DialogAction dialog_action = 3 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.DialogAction,
            com.google.chat.v1.DialogAction.Builder,
            com.google.chat.v1.DialogActionOrBuilder>
        getDialogActionFieldBuilder() {
      if (dialogActionBuilder_ == null) {
        dialogActionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.DialogAction,
                com.google.chat.v1.DialogAction.Builder,
                com.google.chat.v1.DialogActionOrBuilder>(
                getDialogAction(), getParentForChildren(), isClean());
        dialogAction_ = null;
      }
      return dialogActionBuilder_;
    }

    private com.google.chat.v1.ActionResponse.UpdatedWidget updatedWidget_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.ActionResponse.UpdatedWidget,
            com.google.chat.v1.ActionResponse.UpdatedWidget.Builder,
            com.google.chat.v1.ActionResponse.UpdatedWidgetOrBuilder>
        updatedWidgetBuilder_;
    /**
     *
     *
     * <pre>
     * Input only. The response of the updated widget.
     * </pre>
     *
     * <code>
     * .google.chat.v1.ActionResponse.UpdatedWidget updated_widget = 4 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return Whether the updatedWidget field is set.
     */
    public boolean hasUpdatedWidget() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Input only. The response of the updated widget.
     * </pre>
     *
     * <code>
     * .google.chat.v1.ActionResponse.UpdatedWidget updated_widget = 4 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     *
     * @return The updatedWidget.
     */
    public com.google.chat.v1.ActionResponse.UpdatedWidget getUpdatedWidget() {
      if (updatedWidgetBuilder_ == null) {
        return updatedWidget_ == null
            ? com.google.chat.v1.ActionResponse.UpdatedWidget.getDefaultInstance()
            : updatedWidget_;
      } else {
        return updatedWidgetBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. The response of the updated widget.
     * </pre>
     *
     * <code>
     * .google.chat.v1.ActionResponse.UpdatedWidget updated_widget = 4 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder setUpdatedWidget(com.google.chat.v1.ActionResponse.UpdatedWidget value) {
      if (updatedWidgetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updatedWidget_ = value;
      } else {
        updatedWidgetBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The response of the updated widget.
     * </pre>
     *
     * <code>
     * .google.chat.v1.ActionResponse.UpdatedWidget updated_widget = 4 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder setUpdatedWidget(
        com.google.chat.v1.ActionResponse.UpdatedWidget.Builder builderForValue) {
      if (updatedWidgetBuilder_ == null) {
        updatedWidget_ = builderForValue.build();
      } else {
        updatedWidgetBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The response of the updated widget.
     * </pre>
     *
     * <code>
     * .google.chat.v1.ActionResponse.UpdatedWidget updated_widget = 4 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdatedWidget(com.google.chat.v1.ActionResponse.UpdatedWidget value) {
      if (updatedWidgetBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && updatedWidget_ != null
            && updatedWidget_
                != com.google.chat.v1.ActionResponse.UpdatedWidget.getDefaultInstance()) {
          getUpdatedWidgetBuilder().mergeFrom(value);
        } else {
          updatedWidget_ = value;
        }
      } else {
        updatedWidgetBuilder_.mergeFrom(value);
      }
      if (updatedWidget_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The response of the updated widget.
     * </pre>
     *
     * <code>
     * .google.chat.v1.ActionResponse.UpdatedWidget updated_widget = 4 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public Builder clearUpdatedWidget() {
      bitField0_ = (bitField0_ & ~0x00000008);
      updatedWidget_ = null;
      if (updatedWidgetBuilder_ != null) {
        updatedWidgetBuilder_.dispose();
        updatedWidgetBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input only. The response of the updated widget.
     * </pre>
     *
     * <code>
     * .google.chat.v1.ActionResponse.UpdatedWidget updated_widget = 4 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.ActionResponse.UpdatedWidget.Builder getUpdatedWidgetBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getUpdatedWidgetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input only. The response of the updated widget.
     * </pre>
     *
     * <code>
     * .google.chat.v1.ActionResponse.UpdatedWidget updated_widget = 4 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    public com.google.chat.v1.ActionResponse.UpdatedWidgetOrBuilder getUpdatedWidgetOrBuilder() {
      if (updatedWidgetBuilder_ != null) {
        return updatedWidgetBuilder_.getMessageOrBuilder();
      } else {
        return updatedWidget_ == null
            ? com.google.chat.v1.ActionResponse.UpdatedWidget.getDefaultInstance()
            : updatedWidget_;
      }
    }
    /**
     *
     *
     * <pre>
     * Input only. The response of the updated widget.
     * </pre>
     *
     * <code>
     * .google.chat.v1.ActionResponse.UpdatedWidget updated_widget = 4 [(.google.api.field_behavior) = INPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.ActionResponse.UpdatedWidget,
            com.google.chat.v1.ActionResponse.UpdatedWidget.Builder,
            com.google.chat.v1.ActionResponse.UpdatedWidgetOrBuilder>
        getUpdatedWidgetFieldBuilder() {
      if (updatedWidgetBuilder_ == null) {
        updatedWidgetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.ActionResponse.UpdatedWidget,
                com.google.chat.v1.ActionResponse.UpdatedWidget.Builder,
                com.google.chat.v1.ActionResponse.UpdatedWidgetOrBuilder>(
                getUpdatedWidget(), getParentForChildren(), isClean());
        updatedWidget_ = null;
      }
      return updatedWidgetBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.chat.v1.ActionResponse)
  }

  // @@protoc_insertion_point(class_scope:google.chat.v1.ActionResponse)
  private static final com.google.chat.v1.ActionResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.chat.v1.ActionResponse();
  }

  public static com.google.chat.v1.ActionResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ActionResponse> PARSER =
      new com.google.protobuf.AbstractParser<ActionResponse>() {
        @java.lang.Override
        public ActionResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ActionResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ActionResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.chat.v1.ActionResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
