/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/apps/card/v1/card.proto

// Protobuf Java Version: 3.25.2
package com.google.apps.card.v1;

/**
 *
 *
 * <pre>
 * A text, icon, or text and icon button that users can click. For an example in
 * Google Chat apps, see
 * [Button list](https://developers.google.com/chat/ui/widgets/button-list).
 *
 * To make an image a clickable button, specify an
 * [`Image`][google.apps.card.v1.Image] (not an
 * [`ImageComponent`][google.apps.card.v1.ImageComponent]) and set an
 * `onClick` action.
 *
 * [Google Workspace
 * Add-ons and Chat apps](https://developers.google.com/workspace/extend):
 * </pre>
 *
 * Protobuf type {@code google.apps.card.v1.Button}
 */
public final class Button extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.apps.card.v1.Button)
    ButtonOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Button.newBuilder() to construct.
  private Button(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Button() {
    text_ = "";
    altText_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Button();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.apps.card.v1.CardProto.internal_static_google_apps_card_v1_Button_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.apps.card.v1.CardProto
        .internal_static_google_apps_card_v1_Button_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.apps.card.v1.Button.class, com.google.apps.card.v1.Button.Builder.class);
  }

  private int bitField0_;
  public static final int TEXT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object text_ = "";
  /**
   *
   *
   * <pre>
   * The text displayed inside the button.
   * </pre>
   *
   * <code>string text = 1;</code>
   *
   * @return The text.
   */
  @java.lang.Override
  public java.lang.String getText() {
    java.lang.Object ref = text_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      text_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The text displayed inside the button.
   * </pre>
   *
   * <code>string text = 1;</code>
   *
   * @return The bytes for text.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTextBytes() {
    java.lang.Object ref = text_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      text_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ICON_FIELD_NUMBER = 2;
  private com.google.apps.card.v1.Icon icon_;
  /**
   *
   *
   * <pre>
   * The icon image. If both `icon` and `text` are set, then the icon appears
   * before the text.
   * </pre>
   *
   * <code>.google.apps.card.v1.Icon icon = 2;</code>
   *
   * @return Whether the icon field is set.
   */
  @java.lang.Override
  public boolean hasIcon() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * The icon image. If both `icon` and `text` are set, then the icon appears
   * before the text.
   * </pre>
   *
   * <code>.google.apps.card.v1.Icon icon = 2;</code>
   *
   * @return The icon.
   */
  @java.lang.Override
  public com.google.apps.card.v1.Icon getIcon() {
    return icon_ == null ? com.google.apps.card.v1.Icon.getDefaultInstance() : icon_;
  }
  /**
   *
   *
   * <pre>
   * The icon image. If both `icon` and `text` are set, then the icon appears
   * before the text.
   * </pre>
   *
   * <code>.google.apps.card.v1.Icon icon = 2;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.IconOrBuilder getIconOrBuilder() {
    return icon_ == null ? com.google.apps.card.v1.Icon.getDefaultInstance() : icon_;
  }

  public static final int COLOR_FIELD_NUMBER = 3;
  private com.google.type.Color color_;
  /**
   *
   *
   * <pre>
   * If set, the button is filled with a solid background color and the font
   * color changes to maintain contrast with the background color. For example,
   * setting a blue background likely results in white text.
   *
   * If unset, the image background is white and the font color is blue.
   *
   * For red, green, and blue, the value of each field is a `float` number that
   * you can express in either of two ways: as a number between 0 and 255
   * divided by 255 (153/255), or as a value between 0 and 1 (0.6). 0 represents
   * the absence of a color and 1 or 255/255 represent the full presence of that
   * color on the RGB scale.
   *
   * Optionally set `alpha`, which sets a level of transparency using this
   * equation:
   *
   * ```
   * pixel color = alpha * (this color) + (1.0 - alpha) * (background color)
   * ```
   *
   * For `alpha`, a value of `1` corresponds with a solid color, and a value of
   * `0` corresponds with a completely transparent color.
   *
   * For example, the following color represents a half transparent red:
   *
   * ```
   * "color": {
   *    "red": 1,
   *    "green": 0,
   *    "blue": 0,
   *    "alpha": 0.5
   * }
   * ```
   * </pre>
   *
   * <code>.google.type.Color color = 3;</code>
   *
   * @return Whether the color field is set.
   */
  @java.lang.Override
  public boolean hasColor() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * If set, the button is filled with a solid background color and the font
   * color changes to maintain contrast with the background color. For example,
   * setting a blue background likely results in white text.
   *
   * If unset, the image background is white and the font color is blue.
   *
   * For red, green, and blue, the value of each field is a `float` number that
   * you can express in either of two ways: as a number between 0 and 255
   * divided by 255 (153/255), or as a value between 0 and 1 (0.6). 0 represents
   * the absence of a color and 1 or 255/255 represent the full presence of that
   * color on the RGB scale.
   *
   * Optionally set `alpha`, which sets a level of transparency using this
   * equation:
   *
   * ```
   * pixel color = alpha * (this color) + (1.0 - alpha) * (background color)
   * ```
   *
   * For `alpha`, a value of `1` corresponds with a solid color, and a value of
   * `0` corresponds with a completely transparent color.
   *
   * For example, the following color represents a half transparent red:
   *
   * ```
   * "color": {
   *    "red": 1,
   *    "green": 0,
   *    "blue": 0,
   *    "alpha": 0.5
   * }
   * ```
   * </pre>
   *
   * <code>.google.type.Color color = 3;</code>
   *
   * @return The color.
   */
  @java.lang.Override
  public com.google.type.Color getColor() {
    return color_ == null ? com.google.type.Color.getDefaultInstance() : color_;
  }
  /**
   *
   *
   * <pre>
   * If set, the button is filled with a solid background color and the font
   * color changes to maintain contrast with the background color. For example,
   * setting a blue background likely results in white text.
   *
   * If unset, the image background is white and the font color is blue.
   *
   * For red, green, and blue, the value of each field is a `float` number that
   * you can express in either of two ways: as a number between 0 and 255
   * divided by 255 (153/255), or as a value between 0 and 1 (0.6). 0 represents
   * the absence of a color and 1 or 255/255 represent the full presence of that
   * color on the RGB scale.
   *
   * Optionally set `alpha`, which sets a level of transparency using this
   * equation:
   *
   * ```
   * pixel color = alpha * (this color) + (1.0 - alpha) * (background color)
   * ```
   *
   * For `alpha`, a value of `1` corresponds with a solid color, and a value of
   * `0` corresponds with a completely transparent color.
   *
   * For example, the following color represents a half transparent red:
   *
   * ```
   * "color": {
   *    "red": 1,
   *    "green": 0,
   *    "blue": 0,
   *    "alpha": 0.5
   * }
   * ```
   * </pre>
   *
   * <code>.google.type.Color color = 3;</code>
   */
  @java.lang.Override
  public com.google.type.ColorOrBuilder getColorOrBuilder() {
    return color_ == null ? com.google.type.Color.getDefaultInstance() : color_;
  }

  public static final int ON_CLICK_FIELD_NUMBER = 4;
  private com.google.apps.card.v1.OnClick onClick_;
  /**
   *
   *
   * <pre>
   * Required. The action to perform when a user clicks the button, such as
   * opening a hyperlink or running a custom function.
   * </pre>
   *
   * <code>.google.apps.card.v1.OnClick on_click = 4;</code>
   *
   * @return Whether the onClick field is set.
   */
  @java.lang.Override
  public boolean hasOnClick() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The action to perform when a user clicks the button, such as
   * opening a hyperlink or running a custom function.
   * </pre>
   *
   * <code>.google.apps.card.v1.OnClick on_click = 4;</code>
   *
   * @return The onClick.
   */
  @java.lang.Override
  public com.google.apps.card.v1.OnClick getOnClick() {
    return onClick_ == null ? com.google.apps.card.v1.OnClick.getDefaultInstance() : onClick_;
  }
  /**
   *
   *
   * <pre>
   * Required. The action to perform when a user clicks the button, such as
   * opening a hyperlink or running a custom function.
   * </pre>
   *
   * <code>.google.apps.card.v1.OnClick on_click = 4;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.OnClickOrBuilder getOnClickOrBuilder() {
    return onClick_ == null ? com.google.apps.card.v1.OnClick.getDefaultInstance() : onClick_;
  }

  public static final int DISABLED_FIELD_NUMBER = 5;
  private boolean disabled_ = false;
  /**
   *
   *
   * <pre>
   * If `true`, the button is displayed in an inactive state and doesn't respond
   * to user actions.
   * </pre>
   *
   * <code>bool disabled = 5;</code>
   *
   * @return The disabled.
   */
  @java.lang.Override
  public boolean getDisabled() {
    return disabled_;
  }

  public static final int ALT_TEXT_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object altText_ = "";
  /**
   *
   *
   * <pre>
   * The alternative text that's used for accessibility.
   *
   * Set descriptive text that lets users know what the button does. For
   * example, if a button opens a hyperlink, you might write: "Opens a new
   * browser tab and navigates to the Google Chat developer documentation at
   * https://developers.google.com/chat".
   * </pre>
   *
   * <code>string alt_text = 6;</code>
   *
   * @return The altText.
   */
  @java.lang.Override
  public java.lang.String getAltText() {
    java.lang.Object ref = altText_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      altText_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The alternative text that's used for accessibility.
   *
   * Set descriptive text that lets users know what the button does. For
   * example, if a button opens a hyperlink, you might write: "Opens a new
   * browser tab and navigates to the Google Chat developer documentation at
   * https://developers.google.com/chat".
   * </pre>
   *
   * <code>string alt_text = 6;</code>
   *
   * @return The bytes for altText.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAltTextBytes() {
    java.lang.Object ref = altText_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      altText_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, text_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getIcon());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getColor());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getOnClick());
    }
    if (disabled_ != false) {
      output.writeBool(5, disabled_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(altText_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, altText_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(text_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, text_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getIcon());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getColor());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getOnClick());
    }
    if (disabled_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, disabled_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(altText_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, altText_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.apps.card.v1.Button)) {
      return super.equals(obj);
    }
    com.google.apps.card.v1.Button other = (com.google.apps.card.v1.Button) obj;

    if (!getText().equals(other.getText())) return false;
    if (hasIcon() != other.hasIcon()) return false;
    if (hasIcon()) {
      if (!getIcon().equals(other.getIcon())) return false;
    }
    if (hasColor() != other.hasColor()) return false;
    if (hasColor()) {
      if (!getColor().equals(other.getColor())) return false;
    }
    if (hasOnClick() != other.hasOnClick()) return false;
    if (hasOnClick()) {
      if (!getOnClick().equals(other.getOnClick())) return false;
    }
    if (getDisabled() != other.getDisabled()) return false;
    if (!getAltText().equals(other.getAltText())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TEXT_FIELD_NUMBER;
    hash = (53 * hash) + getText().hashCode();
    if (hasIcon()) {
      hash = (37 * hash) + ICON_FIELD_NUMBER;
      hash = (53 * hash) + getIcon().hashCode();
    }
    if (hasColor()) {
      hash = (37 * hash) + COLOR_FIELD_NUMBER;
      hash = (53 * hash) + getColor().hashCode();
    }
    if (hasOnClick()) {
      hash = (37 * hash) + ON_CLICK_FIELD_NUMBER;
      hash = (53 * hash) + getOnClick().hashCode();
    }
    hash = (37 * hash) + DISABLED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisabled());
    hash = (37 * hash) + ALT_TEXT_FIELD_NUMBER;
    hash = (53 * hash) + getAltText().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.apps.card.v1.Button parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.Button parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.Button parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.Button parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.Button parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.Button parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.Button parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.Button parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.card.v1.Button parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.Button parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.card.v1.Button parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.Button parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.apps.card.v1.Button prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A text, icon, or text and icon button that users can click. For an example in
   * Google Chat apps, see
   * [Button list](https://developers.google.com/chat/ui/widgets/button-list).
   *
   * To make an image a clickable button, specify an
   * [`Image`][google.apps.card.v1.Image] (not an
   * [`ImageComponent`][google.apps.card.v1.ImageComponent]) and set an
   * `onClick` action.
   *
   * [Google Workspace
   * Add-ons and Chat apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * Protobuf type {@code google.apps.card.v1.Button}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.apps.card.v1.Button)
      com.google.apps.card.v1.ButtonOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Button_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Button_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.card.v1.Button.class, com.google.apps.card.v1.Button.Builder.class);
    }

    // Construct using com.google.apps.card.v1.Button.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getIconFieldBuilder();
        getColorFieldBuilder();
        getOnClickFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      text_ = "";
      icon_ = null;
      if (iconBuilder_ != null) {
        iconBuilder_.dispose();
        iconBuilder_ = null;
      }
      color_ = null;
      if (colorBuilder_ != null) {
        colorBuilder_.dispose();
        colorBuilder_ = null;
      }
      onClick_ = null;
      if (onClickBuilder_ != null) {
        onClickBuilder_.dispose();
        onClickBuilder_ = null;
      }
      disabled_ = false;
      altText_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Button_descriptor;
    }

    @java.lang.Override
    public com.google.apps.card.v1.Button getDefaultInstanceForType() {
      return com.google.apps.card.v1.Button.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.apps.card.v1.Button build() {
      com.google.apps.card.v1.Button result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.apps.card.v1.Button buildPartial() {
      com.google.apps.card.v1.Button result = new com.google.apps.card.v1.Button(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.apps.card.v1.Button result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.text_ = text_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.icon_ = iconBuilder_ == null ? icon_ : iconBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.color_ = colorBuilder_ == null ? color_ : colorBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.onClick_ = onClickBuilder_ == null ? onClick_ : onClickBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.disabled_ = disabled_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.altText_ = altText_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.apps.card.v1.Button) {
        return mergeFrom((com.google.apps.card.v1.Button) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.apps.card.v1.Button other) {
      if (other == com.google.apps.card.v1.Button.getDefaultInstance()) return this;
      if (!other.getText().isEmpty()) {
        text_ = other.text_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasIcon()) {
        mergeIcon(other.getIcon());
      }
      if (other.hasColor()) {
        mergeColor(other.getColor());
      }
      if (other.hasOnClick()) {
        mergeOnClick(other.getOnClick());
      }
      if (other.getDisabled() != false) {
        setDisabled(other.getDisabled());
      }
      if (!other.getAltText().isEmpty()) {
        altText_ = other.altText_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                text_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getIconFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getColorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getOnClickFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                disabled_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                altText_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object text_ = "";
    /**
     *
     *
     * <pre>
     * The text displayed inside the button.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The text.
     */
    public java.lang.String getText() {
      java.lang.Object ref = text_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        text_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The text displayed inside the button.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The bytes for text.
     */
    public com.google.protobuf.ByteString getTextBytes() {
      java.lang.Object ref = text_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        text_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The text displayed inside the button.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @param value The text to set.
     * @return This builder for chaining.
     */
    public Builder setText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      text_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The text displayed inside the button.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearText() {
      text_ = getDefaultInstance().getText();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The text displayed inside the button.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @param value The bytes for text to set.
     * @return This builder for chaining.
     */
    public Builder setTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      text_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.apps.card.v1.Icon icon_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.Icon,
            com.google.apps.card.v1.Icon.Builder,
            com.google.apps.card.v1.IconOrBuilder>
        iconBuilder_;
    /**
     *
     *
     * <pre>
     * The icon image. If both `icon` and `text` are set, then the icon appears
     * before the text.
     * </pre>
     *
     * <code>.google.apps.card.v1.Icon icon = 2;</code>
     *
     * @return Whether the icon field is set.
     */
    public boolean hasIcon() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The icon image. If both `icon` and `text` are set, then the icon appears
     * before the text.
     * </pre>
     *
     * <code>.google.apps.card.v1.Icon icon = 2;</code>
     *
     * @return The icon.
     */
    public com.google.apps.card.v1.Icon getIcon() {
      if (iconBuilder_ == null) {
        return icon_ == null ? com.google.apps.card.v1.Icon.getDefaultInstance() : icon_;
      } else {
        return iconBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The icon image. If both `icon` and `text` are set, then the icon appears
     * before the text.
     * </pre>
     *
     * <code>.google.apps.card.v1.Icon icon = 2;</code>
     */
    public Builder setIcon(com.google.apps.card.v1.Icon value) {
      if (iconBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        icon_ = value;
      } else {
        iconBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The icon image. If both `icon` and `text` are set, then the icon appears
     * before the text.
     * </pre>
     *
     * <code>.google.apps.card.v1.Icon icon = 2;</code>
     */
    public Builder setIcon(com.google.apps.card.v1.Icon.Builder builderForValue) {
      if (iconBuilder_ == null) {
        icon_ = builderForValue.build();
      } else {
        iconBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The icon image. If both `icon` and `text` are set, then the icon appears
     * before the text.
     * </pre>
     *
     * <code>.google.apps.card.v1.Icon icon = 2;</code>
     */
    public Builder mergeIcon(com.google.apps.card.v1.Icon value) {
      if (iconBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && icon_ != null
            && icon_ != com.google.apps.card.v1.Icon.getDefaultInstance()) {
          getIconBuilder().mergeFrom(value);
        } else {
          icon_ = value;
        }
      } else {
        iconBuilder_.mergeFrom(value);
      }
      if (icon_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The icon image. If both `icon` and `text` are set, then the icon appears
     * before the text.
     * </pre>
     *
     * <code>.google.apps.card.v1.Icon icon = 2;</code>
     */
    public Builder clearIcon() {
      bitField0_ = (bitField0_ & ~0x00000002);
      icon_ = null;
      if (iconBuilder_ != null) {
        iconBuilder_.dispose();
        iconBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The icon image. If both `icon` and `text` are set, then the icon appears
     * before the text.
     * </pre>
     *
     * <code>.google.apps.card.v1.Icon icon = 2;</code>
     */
    public com.google.apps.card.v1.Icon.Builder getIconBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getIconFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The icon image. If both `icon` and `text` are set, then the icon appears
     * before the text.
     * </pre>
     *
     * <code>.google.apps.card.v1.Icon icon = 2;</code>
     */
    public com.google.apps.card.v1.IconOrBuilder getIconOrBuilder() {
      if (iconBuilder_ != null) {
        return iconBuilder_.getMessageOrBuilder();
      } else {
        return icon_ == null ? com.google.apps.card.v1.Icon.getDefaultInstance() : icon_;
      }
    }
    /**
     *
     *
     * <pre>
     * The icon image. If both `icon` and `text` are set, then the icon appears
     * before the text.
     * </pre>
     *
     * <code>.google.apps.card.v1.Icon icon = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.Icon,
            com.google.apps.card.v1.Icon.Builder,
            com.google.apps.card.v1.IconOrBuilder>
        getIconFieldBuilder() {
      if (iconBuilder_ == null) {
        iconBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.card.v1.Icon,
                com.google.apps.card.v1.Icon.Builder,
                com.google.apps.card.v1.IconOrBuilder>(
                getIcon(), getParentForChildren(), isClean());
        icon_ = null;
      }
      return iconBuilder_;
    }

    private com.google.type.Color color_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Color, com.google.type.Color.Builder, com.google.type.ColorOrBuilder>
        colorBuilder_;
    /**
     *
     *
     * <pre>
     * If set, the button is filled with a solid background color and the font
     * color changes to maintain contrast with the background color. For example,
     * setting a blue background likely results in white text.
     *
     * If unset, the image background is white and the font color is blue.
     *
     * For red, green, and blue, the value of each field is a `float` number that
     * you can express in either of two ways: as a number between 0 and 255
     * divided by 255 (153/255), or as a value between 0 and 1 (0.6). 0 represents
     * the absence of a color and 1 or 255/255 represent the full presence of that
     * color on the RGB scale.
     *
     * Optionally set `alpha`, which sets a level of transparency using this
     * equation:
     *
     * ```
     * pixel color = alpha * (this color) + (1.0 - alpha) * (background color)
     * ```
     *
     * For `alpha`, a value of `1` corresponds with a solid color, and a value of
     * `0` corresponds with a completely transparent color.
     *
     * For example, the following color represents a half transparent red:
     *
     * ```
     * "color": {
     *    "red": 1,
     *    "green": 0,
     *    "blue": 0,
     *    "alpha": 0.5
     * }
     * ```
     * </pre>
     *
     * <code>.google.type.Color color = 3;</code>
     *
     * @return Whether the color field is set.
     */
    public boolean hasColor() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * If set, the button is filled with a solid background color and the font
     * color changes to maintain contrast with the background color. For example,
     * setting a blue background likely results in white text.
     *
     * If unset, the image background is white and the font color is blue.
     *
     * For red, green, and blue, the value of each field is a `float` number that
     * you can express in either of two ways: as a number between 0 and 255
     * divided by 255 (153/255), or as a value between 0 and 1 (0.6). 0 represents
     * the absence of a color and 1 or 255/255 represent the full presence of that
     * color on the RGB scale.
     *
     * Optionally set `alpha`, which sets a level of transparency using this
     * equation:
     *
     * ```
     * pixel color = alpha * (this color) + (1.0 - alpha) * (background color)
     * ```
     *
     * For `alpha`, a value of `1` corresponds with a solid color, and a value of
     * `0` corresponds with a completely transparent color.
     *
     * For example, the following color represents a half transparent red:
     *
     * ```
     * "color": {
     *    "red": 1,
     *    "green": 0,
     *    "blue": 0,
     *    "alpha": 0.5
     * }
     * ```
     * </pre>
     *
     * <code>.google.type.Color color = 3;</code>
     *
     * @return The color.
     */
    public com.google.type.Color getColor() {
      if (colorBuilder_ == null) {
        return color_ == null ? com.google.type.Color.getDefaultInstance() : color_;
      } else {
        return colorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If set, the button is filled with a solid background color and the font
     * color changes to maintain contrast with the background color. For example,
     * setting a blue background likely results in white text.
     *
     * If unset, the image background is white and the font color is blue.
     *
     * For red, green, and blue, the value of each field is a `float` number that
     * you can express in either of two ways: as a number between 0 and 255
     * divided by 255 (153/255), or as a value between 0 and 1 (0.6). 0 represents
     * the absence of a color and 1 or 255/255 represent the full presence of that
     * color on the RGB scale.
     *
     * Optionally set `alpha`, which sets a level of transparency using this
     * equation:
     *
     * ```
     * pixel color = alpha * (this color) + (1.0 - alpha) * (background color)
     * ```
     *
     * For `alpha`, a value of `1` corresponds with a solid color, and a value of
     * `0` corresponds with a completely transparent color.
     *
     * For example, the following color represents a half transparent red:
     *
     * ```
     * "color": {
     *    "red": 1,
     *    "green": 0,
     *    "blue": 0,
     *    "alpha": 0.5
     * }
     * ```
     * </pre>
     *
     * <code>.google.type.Color color = 3;</code>
     */
    public Builder setColor(com.google.type.Color value) {
      if (colorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        color_ = value;
      } else {
        colorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, the button is filled with a solid background color and the font
     * color changes to maintain contrast with the background color. For example,
     * setting a blue background likely results in white text.
     *
     * If unset, the image background is white and the font color is blue.
     *
     * For red, green, and blue, the value of each field is a `float` number that
     * you can express in either of two ways: as a number between 0 and 255
     * divided by 255 (153/255), or as a value between 0 and 1 (0.6). 0 represents
     * the absence of a color and 1 or 255/255 represent the full presence of that
     * color on the RGB scale.
     *
     * Optionally set `alpha`, which sets a level of transparency using this
     * equation:
     *
     * ```
     * pixel color = alpha * (this color) + (1.0 - alpha) * (background color)
     * ```
     *
     * For `alpha`, a value of `1` corresponds with a solid color, and a value of
     * `0` corresponds with a completely transparent color.
     *
     * For example, the following color represents a half transparent red:
     *
     * ```
     * "color": {
     *    "red": 1,
     *    "green": 0,
     *    "blue": 0,
     *    "alpha": 0.5
     * }
     * ```
     * </pre>
     *
     * <code>.google.type.Color color = 3;</code>
     */
    public Builder setColor(com.google.type.Color.Builder builderForValue) {
      if (colorBuilder_ == null) {
        color_ = builderForValue.build();
      } else {
        colorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, the button is filled with a solid background color and the font
     * color changes to maintain contrast with the background color. For example,
     * setting a blue background likely results in white text.
     *
     * If unset, the image background is white and the font color is blue.
     *
     * For red, green, and blue, the value of each field is a `float` number that
     * you can express in either of two ways: as a number between 0 and 255
     * divided by 255 (153/255), or as a value between 0 and 1 (0.6). 0 represents
     * the absence of a color and 1 or 255/255 represent the full presence of that
     * color on the RGB scale.
     *
     * Optionally set `alpha`, which sets a level of transparency using this
     * equation:
     *
     * ```
     * pixel color = alpha * (this color) + (1.0 - alpha) * (background color)
     * ```
     *
     * For `alpha`, a value of `1` corresponds with a solid color, and a value of
     * `0` corresponds with a completely transparent color.
     *
     * For example, the following color represents a half transparent red:
     *
     * ```
     * "color": {
     *    "red": 1,
     *    "green": 0,
     *    "blue": 0,
     *    "alpha": 0.5
     * }
     * ```
     * </pre>
     *
     * <code>.google.type.Color color = 3;</code>
     */
    public Builder mergeColor(com.google.type.Color value) {
      if (colorBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && color_ != null
            && color_ != com.google.type.Color.getDefaultInstance()) {
          getColorBuilder().mergeFrom(value);
        } else {
          color_ = value;
        }
      } else {
        colorBuilder_.mergeFrom(value);
      }
      if (color_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, the button is filled with a solid background color and the font
     * color changes to maintain contrast with the background color. For example,
     * setting a blue background likely results in white text.
     *
     * If unset, the image background is white and the font color is blue.
     *
     * For red, green, and blue, the value of each field is a `float` number that
     * you can express in either of two ways: as a number between 0 and 255
     * divided by 255 (153/255), or as a value between 0 and 1 (0.6). 0 represents
     * the absence of a color and 1 or 255/255 represent the full presence of that
     * color on the RGB scale.
     *
     * Optionally set `alpha`, which sets a level of transparency using this
     * equation:
     *
     * ```
     * pixel color = alpha * (this color) + (1.0 - alpha) * (background color)
     * ```
     *
     * For `alpha`, a value of `1` corresponds with a solid color, and a value of
     * `0` corresponds with a completely transparent color.
     *
     * For example, the following color represents a half transparent red:
     *
     * ```
     * "color": {
     *    "red": 1,
     *    "green": 0,
     *    "blue": 0,
     *    "alpha": 0.5
     * }
     * ```
     * </pre>
     *
     * <code>.google.type.Color color = 3;</code>
     */
    public Builder clearColor() {
      bitField0_ = (bitField0_ & ~0x00000004);
      color_ = null;
      if (colorBuilder_ != null) {
        colorBuilder_.dispose();
        colorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, the button is filled with a solid background color and the font
     * color changes to maintain contrast with the background color. For example,
     * setting a blue background likely results in white text.
     *
     * If unset, the image background is white and the font color is blue.
     *
     * For red, green, and blue, the value of each field is a `float` number that
     * you can express in either of two ways: as a number between 0 and 255
     * divided by 255 (153/255), or as a value between 0 and 1 (0.6). 0 represents
     * the absence of a color and 1 or 255/255 represent the full presence of that
     * color on the RGB scale.
     *
     * Optionally set `alpha`, which sets a level of transparency using this
     * equation:
     *
     * ```
     * pixel color = alpha * (this color) + (1.0 - alpha) * (background color)
     * ```
     *
     * For `alpha`, a value of `1` corresponds with a solid color, and a value of
     * `0` corresponds with a completely transparent color.
     *
     * For example, the following color represents a half transparent red:
     *
     * ```
     * "color": {
     *    "red": 1,
     *    "green": 0,
     *    "blue": 0,
     *    "alpha": 0.5
     * }
     * ```
     * </pre>
     *
     * <code>.google.type.Color color = 3;</code>
     */
    public com.google.type.Color.Builder getColorBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getColorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If set, the button is filled with a solid background color and the font
     * color changes to maintain contrast with the background color. For example,
     * setting a blue background likely results in white text.
     *
     * If unset, the image background is white and the font color is blue.
     *
     * For red, green, and blue, the value of each field is a `float` number that
     * you can express in either of two ways: as a number between 0 and 255
     * divided by 255 (153/255), or as a value between 0 and 1 (0.6). 0 represents
     * the absence of a color and 1 or 255/255 represent the full presence of that
     * color on the RGB scale.
     *
     * Optionally set `alpha`, which sets a level of transparency using this
     * equation:
     *
     * ```
     * pixel color = alpha * (this color) + (1.0 - alpha) * (background color)
     * ```
     *
     * For `alpha`, a value of `1` corresponds with a solid color, and a value of
     * `0` corresponds with a completely transparent color.
     *
     * For example, the following color represents a half transparent red:
     *
     * ```
     * "color": {
     *    "red": 1,
     *    "green": 0,
     *    "blue": 0,
     *    "alpha": 0.5
     * }
     * ```
     * </pre>
     *
     * <code>.google.type.Color color = 3;</code>
     */
    public com.google.type.ColorOrBuilder getColorOrBuilder() {
      if (colorBuilder_ != null) {
        return colorBuilder_.getMessageOrBuilder();
      } else {
        return color_ == null ? com.google.type.Color.getDefaultInstance() : color_;
      }
    }
    /**
     *
     *
     * <pre>
     * If set, the button is filled with a solid background color and the font
     * color changes to maintain contrast with the background color. For example,
     * setting a blue background likely results in white text.
     *
     * If unset, the image background is white and the font color is blue.
     *
     * For red, green, and blue, the value of each field is a `float` number that
     * you can express in either of two ways: as a number between 0 and 255
     * divided by 255 (153/255), or as a value between 0 and 1 (0.6). 0 represents
     * the absence of a color and 1 or 255/255 represent the full presence of that
     * color on the RGB scale.
     *
     * Optionally set `alpha`, which sets a level of transparency using this
     * equation:
     *
     * ```
     * pixel color = alpha * (this color) + (1.0 - alpha) * (background color)
     * ```
     *
     * For `alpha`, a value of `1` corresponds with a solid color, and a value of
     * `0` corresponds with a completely transparent color.
     *
     * For example, the following color represents a half transparent red:
     *
     * ```
     * "color": {
     *    "red": 1,
     *    "green": 0,
     *    "blue": 0,
     *    "alpha": 0.5
     * }
     * ```
     * </pre>
     *
     * <code>.google.type.Color color = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.Color, com.google.type.Color.Builder, com.google.type.ColorOrBuilder>
        getColorFieldBuilder() {
      if (colorBuilder_ == null) {
        colorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.Color,
                com.google.type.Color.Builder,
                com.google.type.ColorOrBuilder>(getColor(), getParentForChildren(), isClean());
        color_ = null;
      }
      return colorBuilder_;
    }

    private com.google.apps.card.v1.OnClick onClick_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.OnClick,
            com.google.apps.card.v1.OnClick.Builder,
            com.google.apps.card.v1.OnClickOrBuilder>
        onClickBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The action to perform when a user clicks the button, such as
     * opening a hyperlink or running a custom function.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 4;</code>
     *
     * @return Whether the onClick field is set.
     */
    public boolean hasOnClick() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The action to perform when a user clicks the button, such as
     * opening a hyperlink or running a custom function.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 4;</code>
     *
     * @return The onClick.
     */
    public com.google.apps.card.v1.OnClick getOnClick() {
      if (onClickBuilder_ == null) {
        return onClick_ == null ? com.google.apps.card.v1.OnClick.getDefaultInstance() : onClick_;
      } else {
        return onClickBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The action to perform when a user clicks the button, such as
     * opening a hyperlink or running a custom function.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 4;</code>
     */
    public Builder setOnClick(com.google.apps.card.v1.OnClick value) {
      if (onClickBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        onClick_ = value;
      } else {
        onClickBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The action to perform when a user clicks the button, such as
     * opening a hyperlink or running a custom function.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 4;</code>
     */
    public Builder setOnClick(com.google.apps.card.v1.OnClick.Builder builderForValue) {
      if (onClickBuilder_ == null) {
        onClick_ = builderForValue.build();
      } else {
        onClickBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The action to perform when a user clicks the button, such as
     * opening a hyperlink or running a custom function.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 4;</code>
     */
    public Builder mergeOnClick(com.google.apps.card.v1.OnClick value) {
      if (onClickBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && onClick_ != null
            && onClick_ != com.google.apps.card.v1.OnClick.getDefaultInstance()) {
          getOnClickBuilder().mergeFrom(value);
        } else {
          onClick_ = value;
        }
      } else {
        onClickBuilder_.mergeFrom(value);
      }
      if (onClick_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The action to perform when a user clicks the button, such as
     * opening a hyperlink or running a custom function.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 4;</code>
     */
    public Builder clearOnClick() {
      bitField0_ = (bitField0_ & ~0x00000008);
      onClick_ = null;
      if (onClickBuilder_ != null) {
        onClickBuilder_.dispose();
        onClickBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The action to perform when a user clicks the button, such as
     * opening a hyperlink or running a custom function.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 4;</code>
     */
    public com.google.apps.card.v1.OnClick.Builder getOnClickBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getOnClickFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The action to perform when a user clicks the button, such as
     * opening a hyperlink or running a custom function.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 4;</code>
     */
    public com.google.apps.card.v1.OnClickOrBuilder getOnClickOrBuilder() {
      if (onClickBuilder_ != null) {
        return onClickBuilder_.getMessageOrBuilder();
      } else {
        return onClick_ == null ? com.google.apps.card.v1.OnClick.getDefaultInstance() : onClick_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The action to perform when a user clicks the button, such as
     * opening a hyperlink or running a custom function.
     * </pre>
     *
     * <code>.google.apps.card.v1.OnClick on_click = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.apps.card.v1.OnClick,
            com.google.apps.card.v1.OnClick.Builder,
            com.google.apps.card.v1.OnClickOrBuilder>
        getOnClickFieldBuilder() {
      if (onClickBuilder_ == null) {
        onClickBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.apps.card.v1.OnClick,
                com.google.apps.card.v1.OnClick.Builder,
                com.google.apps.card.v1.OnClickOrBuilder>(
                getOnClick(), getParentForChildren(), isClean());
        onClick_ = null;
      }
      return onClickBuilder_;
    }

    private boolean disabled_;
    /**
     *
     *
     * <pre>
     * If `true`, the button is displayed in an inactive state and doesn't respond
     * to user actions.
     * </pre>
     *
     * <code>bool disabled = 5;</code>
     *
     * @return The disabled.
     */
    @java.lang.Override
    public boolean getDisabled() {
      return disabled_;
    }
    /**
     *
     *
     * <pre>
     * If `true`, the button is displayed in an inactive state and doesn't respond
     * to user actions.
     * </pre>
     *
     * <code>bool disabled = 5;</code>
     *
     * @param value The disabled to set.
     * @return This builder for chaining.
     */
    public Builder setDisabled(boolean value) {

      disabled_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If `true`, the button is displayed in an inactive state and doesn't respond
     * to user actions.
     * </pre>
     *
     * <code>bool disabled = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisabled() {
      bitField0_ = (bitField0_ & ~0x00000010);
      disabled_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object altText_ = "";
    /**
     *
     *
     * <pre>
     * The alternative text that's used for accessibility.
     *
     * Set descriptive text that lets users know what the button does. For
     * example, if a button opens a hyperlink, you might write: "Opens a new
     * browser tab and navigates to the Google Chat developer documentation at
     * https://developers.google.com/chat".
     * </pre>
     *
     * <code>string alt_text = 6;</code>
     *
     * @return The altText.
     */
    public java.lang.String getAltText() {
      java.lang.Object ref = altText_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        altText_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The alternative text that's used for accessibility.
     *
     * Set descriptive text that lets users know what the button does. For
     * example, if a button opens a hyperlink, you might write: "Opens a new
     * browser tab and navigates to the Google Chat developer documentation at
     * https://developers.google.com/chat".
     * </pre>
     *
     * <code>string alt_text = 6;</code>
     *
     * @return The bytes for altText.
     */
    public com.google.protobuf.ByteString getAltTextBytes() {
      java.lang.Object ref = altText_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        altText_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The alternative text that's used for accessibility.
     *
     * Set descriptive text that lets users know what the button does. For
     * example, if a button opens a hyperlink, you might write: "Opens a new
     * browser tab and navigates to the Google Chat developer documentation at
     * https://developers.google.com/chat".
     * </pre>
     *
     * <code>string alt_text = 6;</code>
     *
     * @param value The altText to set.
     * @return This builder for chaining.
     */
    public Builder setAltText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      altText_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The alternative text that's used for accessibility.
     *
     * Set descriptive text that lets users know what the button does. For
     * example, if a button opens a hyperlink, you might write: "Opens a new
     * browser tab and navigates to the Google Chat developer documentation at
     * https://developers.google.com/chat".
     * </pre>
     *
     * <code>string alt_text = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAltText() {
      altText_ = getDefaultInstance().getAltText();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The alternative text that's used for accessibility.
     *
     * Set descriptive text that lets users know what the button does. For
     * example, if a button opens a hyperlink, you might write: "Opens a new
     * browser tab and navigates to the Google Chat developer documentation at
     * https://developers.google.com/chat".
     * </pre>
     *
     * <code>string alt_text = 6;</code>
     *
     * @param value The bytes for altText to set.
     * @return This builder for chaining.
     */
    public Builder setAltTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      altText_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.apps.card.v1.Button)
  }

  // @@protoc_insertion_point(class_scope:google.apps.card.v1.Button)
  private static final com.google.apps.card.v1.Button DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.apps.card.v1.Button();
  }

  public static com.google.apps.card.v1.Button getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Button> PARSER =
      new com.google.protobuf.AbstractParser<Button>() {
        @java.lang.Override
        public Button parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Button> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Button> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.apps.card.v1.Button getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
