/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.channel.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ChannelPartnerRepricingConfigName
implements ResourceName {
    private static final PathTemplate ACCOUNT_CHANNEL_PARTNER_CHANNEL_PARTNER_REPRICING_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"accounts/{account}/channelPartnerLinks/{channel_partner}/channelPartnerRepricingConfigs/{channel_partner_repricing_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String account;
    private final String channelPartner;
    private final String channelPartnerRepricingConfig;

    @Deprecated
    protected ChannelPartnerRepricingConfigName() {
        this.account = null;
        this.channelPartner = null;
        this.channelPartnerRepricingConfig = null;
    }

    private ChannelPartnerRepricingConfigName(Builder builder) {
        this.account = (String)Preconditions.checkNotNull((Object)builder.getAccount());
        this.channelPartner = (String)Preconditions.checkNotNull((Object)builder.getChannelPartner());
        this.channelPartnerRepricingConfig = (String)Preconditions.checkNotNull((Object)builder.getChannelPartnerRepricingConfig());
    }

    public String getAccount() {
        return this.account;
    }

    public String getChannelPartner() {
        return this.channelPartner;
    }

    public String getChannelPartnerRepricingConfig() {
        return this.channelPartnerRepricingConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ChannelPartnerRepricingConfigName of(String account, String channelPartner, String channelPartnerRepricingConfig) {
        return ChannelPartnerRepricingConfigName.newBuilder().setAccount(account).setChannelPartner(channelPartner).setChannelPartnerRepricingConfig(channelPartnerRepricingConfig).build();
    }

    public static String format(String account, String channelPartner, String channelPartnerRepricingConfig) {
        return ChannelPartnerRepricingConfigName.newBuilder().setAccount(account).setChannelPartner(channelPartner).setChannelPartnerRepricingConfig(channelPartnerRepricingConfig).build().toString();
    }

    public static ChannelPartnerRepricingConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ACCOUNT_CHANNEL_PARTNER_CHANNEL_PARTNER_REPRICING_CONFIG.validatedMatch(formattedString, "ChannelPartnerRepricingConfigName.parse: formattedString not in valid format");
        return ChannelPartnerRepricingConfigName.of((String)matchMap.get("account"), (String)matchMap.get("channel_partner"), (String)matchMap.get("channel_partner_repricing_config"));
    }

    public static List<ChannelPartnerRepricingConfigName> parseList(List<String> formattedStrings) {
        ArrayList<ChannelPartnerRepricingConfigName> list = new ArrayList<ChannelPartnerRepricingConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ChannelPartnerRepricingConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ChannelPartnerRepricingConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ChannelPartnerRepricingConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ACCOUNT_CHANNEL_PARTNER_CHANNEL_PARTNER_REPRICING_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ChannelPartnerRepricingConfigName channelPartnerRepricingConfigName = this;
            synchronized (channelPartnerRepricingConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.account != null) {
                        fieldMapBuilder.put((Object)"account", (Object)this.account);
                    }
                    if (this.channelPartner != null) {
                        fieldMapBuilder.put((Object)"channel_partner", (Object)this.channelPartner);
                    }
                    if (this.channelPartnerRepricingConfig != null) {
                        fieldMapBuilder.put((Object)"channel_partner_repricing_config", (Object)this.channelPartnerRepricingConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ACCOUNT_CHANNEL_PARTNER_CHANNEL_PARTNER_REPRICING_CONFIG.instantiate(new String[]{"account", this.account, "channel_partner", this.channelPartner, "channel_partner_repricing_config", this.channelPartnerRepricingConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ChannelPartnerRepricingConfigName that = (ChannelPartnerRepricingConfigName)o;
            return Objects.equals(this.account, that.account) && Objects.equals(this.channelPartner, that.channelPartner) && Objects.equals(this.channelPartnerRepricingConfig, that.channelPartnerRepricingConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.account);
        h *= 1000003;
        h ^= Objects.hashCode(this.channelPartner);
        h *= 1000003;
        return h ^= Objects.hashCode(this.channelPartnerRepricingConfig);
    }

    public static class Builder {
        private String account;
        private String channelPartner;
        private String channelPartnerRepricingConfig;

        protected Builder() {
        }

        public String getAccount() {
            return this.account;
        }

        public String getChannelPartner() {
            return this.channelPartner;
        }

        public String getChannelPartnerRepricingConfig() {
            return this.channelPartnerRepricingConfig;
        }

        public Builder setAccount(String account) {
            this.account = account;
            return this;
        }

        public Builder setChannelPartner(String channelPartner) {
            this.channelPartner = channelPartner;
            return this;
        }

        public Builder setChannelPartnerRepricingConfig(String channelPartnerRepricingConfig) {
            this.channelPartnerRepricingConfig = channelPartnerRepricingConfig;
            return this;
        }

        private Builder(ChannelPartnerRepricingConfigName channelPartnerRepricingConfigName) {
            this.account = channelPartnerRepricingConfigName.account;
            this.channelPartner = channelPartnerRepricingConfigName.channelPartner;
            this.channelPartnerRepricingConfig = channelPartnerRepricingConfigName.channelPartnerRepricingConfig;
        }

        public ChannelPartnerRepricingConfigName build() {
            return new ChannelPartnerRepricingConfigName(this);
        }
    }
}

