/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.channel.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomerRepricingConfigName
implements ResourceName {
    private static final PathTemplate ACCOUNT_CUSTOMER_CUSTOMER_REPRICING_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"accounts/{account}/customers/{customer}/customerRepricingConfigs/{customer_repricing_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String account;
    private final String customer;
    private final String customerRepricingConfig;

    @Deprecated
    protected CustomerRepricingConfigName() {
        this.account = null;
        this.customer = null;
        this.customerRepricingConfig = null;
    }

    private CustomerRepricingConfigName(Builder builder) {
        this.account = (String)Preconditions.checkNotNull((Object)builder.getAccount());
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.customerRepricingConfig = (String)Preconditions.checkNotNull((Object)builder.getCustomerRepricingConfig());
    }

    public String getAccount() {
        return this.account;
    }

    public String getCustomer() {
        return this.customer;
    }

    public String getCustomerRepricingConfig() {
        return this.customerRepricingConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomerRepricingConfigName of(String account, String customer, String customerRepricingConfig) {
        return CustomerRepricingConfigName.newBuilder().setAccount(account).setCustomer(customer).setCustomerRepricingConfig(customerRepricingConfig).build();
    }

    public static String format(String account, String customer, String customerRepricingConfig) {
        return CustomerRepricingConfigName.newBuilder().setAccount(account).setCustomer(customer).setCustomerRepricingConfig(customerRepricingConfig).build().toString();
    }

    public static CustomerRepricingConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ACCOUNT_CUSTOMER_CUSTOMER_REPRICING_CONFIG.validatedMatch(formattedString, "CustomerRepricingConfigName.parse: formattedString not in valid format");
        return CustomerRepricingConfigName.of((String)matchMap.get("account"), (String)matchMap.get("customer"), (String)matchMap.get("customer_repricing_config"));
    }

    public static List<CustomerRepricingConfigName> parseList(List<String> formattedStrings) {
        ArrayList<CustomerRepricingConfigName> list = new ArrayList<CustomerRepricingConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomerRepricingConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomerRepricingConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomerRepricingConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ACCOUNT_CUSTOMER_CUSTOMER_REPRICING_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomerRepricingConfigName customerRepricingConfigName = this;
            synchronized (customerRepricingConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.account != null) {
                        fieldMapBuilder.put((Object)"account", (Object)this.account);
                    }
                    if (this.customer != null) {
                        fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    }
                    if (this.customerRepricingConfig != null) {
                        fieldMapBuilder.put((Object)"customer_repricing_config", (Object)this.customerRepricingConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ACCOUNT_CUSTOMER_CUSTOMER_REPRICING_CONFIG.instantiate(new String[]{"account", this.account, "customer", this.customer, "customer_repricing_config", this.customerRepricingConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CustomerRepricingConfigName that = (CustomerRepricingConfigName)o;
            return Objects.equals(this.account, that.account) && Objects.equals(this.customer, that.customer) && Objects.equals(this.customerRepricingConfig, that.customerRepricingConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.account);
        h *= 1000003;
        h ^= Objects.hashCode(this.customer);
        h *= 1000003;
        return h ^= Objects.hashCode(this.customerRepricingConfig);
    }

    public static class Builder {
        private String account;
        private String customer;
        private String customerRepricingConfig;

        protected Builder() {
        }

        public String getAccount() {
            return this.account;
        }

        public String getCustomer() {
            return this.customer;
        }

        public String getCustomerRepricingConfig() {
            return this.customerRepricingConfig;
        }

        public Builder setAccount(String account) {
            this.account = account;
            return this;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCustomerRepricingConfig(String customerRepricingConfig) {
            this.customerRepricingConfig = customerRepricingConfig;
            return this;
        }

        private Builder(CustomerRepricingConfigName customerRepricingConfigName) {
            this.account = customerRepricingConfigName.account;
            this.customer = customerRepricingConfigName.customer;
            this.customerRepricingConfig = customerRepricingConfigName.customerRepricingConfig;
        }

        public CustomerRepricingConfigName build() {
            return new CustomerRepricingConfigName(this);
        }
    }
}

