/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.channel.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OfferName
implements ResourceName {
    private static final PathTemplate ACCOUNT_OFFER = PathTemplate.createWithoutUrlEncoding((String)"accounts/{account}/offers/{offer}");
    private volatile Map<String, String> fieldValuesMap;
    private final String account;
    private final String offer;

    @Deprecated
    protected OfferName() {
        this.account = null;
        this.offer = null;
    }

    private OfferName(Builder builder) {
        this.account = (String)Preconditions.checkNotNull((Object)builder.getAccount());
        this.offer = (String)Preconditions.checkNotNull((Object)builder.getOffer());
    }

    public String getAccount() {
        return this.account;
    }

    public String getOffer() {
        return this.offer;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static OfferName of(String account, String offer) {
        return OfferName.newBuilder().setAccount(account).setOffer(offer).build();
    }

    public static String format(String account, String offer) {
        return OfferName.newBuilder().setAccount(account).setOffer(offer).build().toString();
    }

    public static OfferName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ACCOUNT_OFFER.validatedMatch(formattedString, "OfferName.parse: formattedString not in valid format");
        return OfferName.of((String)matchMap.get("account"), (String)matchMap.get("offer"));
    }

    public static List<OfferName> parseList(List<String> formattedStrings) {
        ArrayList<OfferName> list = new ArrayList<OfferName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(OfferName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<OfferName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (OfferName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ACCOUNT_OFFER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            OfferName offerName = this;
            synchronized (offerName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.account != null) {
                        fieldMapBuilder.put((Object)"account", (Object)this.account);
                    }
                    if (this.offer != null) {
                        fieldMapBuilder.put((Object)"offer", (Object)this.offer);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ACCOUNT_OFFER.instantiate(new String[]{"account", this.account, "offer", this.offer});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            OfferName that = (OfferName)o;
            return Objects.equals(this.account, that.account) && Objects.equals(this.offer, that.offer);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.account);
        h *= 1000003;
        return h ^= Objects.hashCode(this.offer);
    }

    public static class Builder {
        private String account;
        private String offer;

        protected Builder() {
        }

        public String getAccount() {
            return this.account;
        }

        public String getOffer() {
            return this.offer;
        }

        public Builder setAccount(String account) {
            this.account = account;
            return this;
        }

        public Builder setOffer(String offer) {
            this.offer = offer;
            return this;
        }

        private Builder(OfferName offerName) {
            this.account = offerName.account;
            this.offer = offerName.offer;
        }

        public OfferName build() {
            return new OfferName(this);
        }
    }
}

