/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.certificatemanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CertificateName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CERTIFICATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/certificates/{certificate}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String certificate;

    @Deprecated
    protected CertificateName() {
        this.project = null;
        this.location = null;
        this.certificate = null;
    }

    private CertificateName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.certificate = (String)Preconditions.checkNotNull((Object)builder.getCertificate());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CertificateName of(String project, String location, String certificate) {
        return CertificateName.newBuilder().setProject(project).setLocation(location).setCertificate(certificate).build();
    }

    public static String format(String project, String location, String certificate) {
        return CertificateName.newBuilder().setProject(project).setLocation(location).setCertificate(certificate).build().toString();
    }

    public static CertificateName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CERTIFICATE.validatedMatch(formattedString, "CertificateName.parse: formattedString not in valid format");
        return CertificateName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("certificate"));
    }

    public static List<CertificateName> parseList(List<String> formattedStrings) {
        ArrayList<CertificateName> list = new ArrayList<CertificateName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CertificateName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CertificateName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CertificateName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CERTIFICATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CertificateName certificateName = this;
            synchronized (certificateName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.certificate != null) {
                        fieldMapBuilder.put((Object)"certificate", (Object)this.certificate);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CERTIFICATE.instantiate(new String[]{"project", this.project, "location", this.location, "certificate", this.certificate});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CertificateName that = (CertificateName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.certificate, that.certificate);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.certificate);
    }

    public static class Builder {
        private String project;
        private String location;
        private String certificate;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCertificate() {
            return this.certificate;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCertificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        private Builder(CertificateName certificateName) {
            this.project = certificateName.project;
            this.location = certificateName.location;
            this.certificate = certificateName.certificate;
        }

        public CertificateName build() {
            return new CertificateName(this);
        }
    }
}

