/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.certificatemanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TrustConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_TRUST_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/trustConfigs/{trust_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String trustConfig;

    @Deprecated
    protected TrustConfigName() {
        this.project = null;
        this.location = null;
        this.trustConfig = null;
    }

    private TrustConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.trustConfig = (String)Preconditions.checkNotNull((Object)builder.getTrustConfig());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTrustConfig() {
        return this.trustConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TrustConfigName of(String project, String location, String trustConfig) {
        return TrustConfigName.newBuilder().setProject(project).setLocation(location).setTrustConfig(trustConfig).build();
    }

    public static String format(String project, String location, String trustConfig) {
        return TrustConfigName.newBuilder().setProject(project).setLocation(location).setTrustConfig(trustConfig).build().toString();
    }

    public static TrustConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_TRUST_CONFIG.validatedMatch(formattedString, "TrustConfigName.parse: formattedString not in valid format");
        return TrustConfigName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("trust_config"));
    }

    public static List<TrustConfigName> parseList(List<String> formattedStrings) {
        ArrayList<TrustConfigName> list = new ArrayList<TrustConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TrustConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TrustConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TrustConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_TRUST_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TrustConfigName trustConfigName = this;
            synchronized (trustConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.trustConfig != null) {
                        fieldMapBuilder.put((Object)"trust_config", (Object)this.trustConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_TRUST_CONFIG.instantiate(new String[]{"project", this.project, "location", this.location, "trust_config", this.trustConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TrustConfigName that = (TrustConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.trustConfig, that.trustConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.trustConfig);
    }

    public static class Builder {
        private String project;
        private String location;
        private String trustConfig;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTrustConfig() {
            return this.trustConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setTrustConfig(String trustConfig) {
            this.trustConfig = trustConfig;
            return this;
        }

        private Builder(TrustConfigName trustConfigName) {
            this.project = trustConfigName.project;
            this.location = trustConfigName.location;
            this.trustConfig = trustConfigName.trustConfig;
        }

        public TrustConfigName build() {
            return new TrustConfigName(this);
        }
    }
}

