/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.certificatemanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CertificateMapEntryName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CERTIFICATE_MAP_CERTIFICATE_MAP_ENTRY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/certificateMaps/{certificate_map}/certificateMapEntries/{certificate_map_entry}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String certificateMap;
    private final String certificateMapEntry;

    @Deprecated
    protected CertificateMapEntryName() {
        this.project = null;
        this.location = null;
        this.certificateMap = null;
        this.certificateMapEntry = null;
    }

    private CertificateMapEntryName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.certificateMap = (String)Preconditions.checkNotNull((Object)builder.getCertificateMap());
        this.certificateMapEntry = (String)Preconditions.checkNotNull((Object)builder.getCertificateMapEntry());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCertificateMap() {
        return this.certificateMap;
    }

    public String getCertificateMapEntry() {
        return this.certificateMapEntry;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CertificateMapEntryName of(String project, String location, String certificateMap, String certificateMapEntry) {
        return CertificateMapEntryName.newBuilder().setProject(project).setLocation(location).setCertificateMap(certificateMap).setCertificateMapEntry(certificateMapEntry).build();
    }

    public static String format(String project, String location, String certificateMap, String certificateMapEntry) {
        return CertificateMapEntryName.newBuilder().setProject(project).setLocation(location).setCertificateMap(certificateMap).setCertificateMapEntry(certificateMapEntry).build().toString();
    }

    public static CertificateMapEntryName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CERTIFICATE_MAP_CERTIFICATE_MAP_ENTRY.validatedMatch(formattedString, "CertificateMapEntryName.parse: formattedString not in valid format");
        return CertificateMapEntryName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("certificate_map"), (String)matchMap.get("certificate_map_entry"));
    }

    public static List<CertificateMapEntryName> parseList(List<String> formattedStrings) {
        ArrayList<CertificateMapEntryName> list = new ArrayList<CertificateMapEntryName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CertificateMapEntryName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CertificateMapEntryName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CertificateMapEntryName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CERTIFICATE_MAP_CERTIFICATE_MAP_ENTRY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CertificateMapEntryName certificateMapEntryName = this;
            synchronized (certificateMapEntryName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.certificateMap != null) {
                        fieldMapBuilder.put((Object)"certificate_map", (Object)this.certificateMap);
                    }
                    if (this.certificateMapEntry != null) {
                        fieldMapBuilder.put((Object)"certificate_map_entry", (Object)this.certificateMapEntry);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CERTIFICATE_MAP_CERTIFICATE_MAP_ENTRY.instantiate(new String[]{"project", this.project, "location", this.location, "certificate_map", this.certificateMap, "certificate_map_entry", this.certificateMapEntry});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CertificateMapEntryName that = (CertificateMapEntryName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.certificateMap, that.certificateMap) && Objects.equals(this.certificateMapEntry, that.certificateMapEntry);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.certificateMap);
        h *= 1000003;
        return h ^= Objects.hashCode(this.certificateMapEntry);
    }

    public static class Builder {
        private String project;
        private String location;
        private String certificateMap;
        private String certificateMapEntry;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCertificateMap() {
            return this.certificateMap;
        }

        public String getCertificateMapEntry() {
            return this.certificateMapEntry;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCertificateMap(String certificateMap) {
            this.certificateMap = certificateMap;
            return this;
        }

        public Builder setCertificateMapEntry(String certificateMapEntry) {
            this.certificateMapEntry = certificateMapEntry;
            return this;
        }

        private Builder(CertificateMapEntryName certificateMapEntryName) {
            this.project = certificateMapEntryName.project;
            this.location = certificateMapEntryName.location;
            this.certificateMap = certificateMapEntryName.certificateMap;
            this.certificateMapEntry = certificateMapEntryName.certificateMapEntry;
        }

        public CertificateMapEntryName build() {
            return new CertificateMapEntryName(this);
        }
    }
}

