/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.certificatemanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DnsAuthorizationName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DNS_AUTHORIZATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dnsAuthorizations/{dns_authorization}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String dnsAuthorization;

    @Deprecated
    protected DnsAuthorizationName() {
        this.project = null;
        this.location = null;
        this.dnsAuthorization = null;
    }

    private DnsAuthorizationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dnsAuthorization = (String)Preconditions.checkNotNull((Object)builder.getDnsAuthorization());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDnsAuthorization() {
        return this.dnsAuthorization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DnsAuthorizationName of(String project, String location, String dnsAuthorization) {
        return DnsAuthorizationName.newBuilder().setProject(project).setLocation(location).setDnsAuthorization(dnsAuthorization).build();
    }

    public static String format(String project, String location, String dnsAuthorization) {
        return DnsAuthorizationName.newBuilder().setProject(project).setLocation(location).setDnsAuthorization(dnsAuthorization).build().toString();
    }

    public static DnsAuthorizationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DNS_AUTHORIZATION.validatedMatch(formattedString, "DnsAuthorizationName.parse: formattedString not in valid format");
        return DnsAuthorizationName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("dns_authorization"));
    }

    public static List<DnsAuthorizationName> parseList(List<String> formattedStrings) {
        ArrayList<DnsAuthorizationName> list = new ArrayList<DnsAuthorizationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DnsAuthorizationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DnsAuthorizationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DnsAuthorizationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DNS_AUTHORIZATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DnsAuthorizationName dnsAuthorizationName = this;
            synchronized (dnsAuthorizationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dnsAuthorization != null) {
                        fieldMapBuilder.put((Object)"dns_authorization", (Object)this.dnsAuthorization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DNS_AUTHORIZATION.instantiate(new String[]{"project", this.project, "location", this.location, "dns_authorization", this.dnsAuthorization});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DnsAuthorizationName that = (DnsAuthorizationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dnsAuthorization, that.dnsAuthorization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.dnsAuthorization);
    }

    public static class Builder {
        private String project;
        private String location;
        private String dnsAuthorization;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDnsAuthorization() {
            return this.dnsAuthorization;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDnsAuthorization(String dnsAuthorization) {
            this.dnsAuthorization = dnsAuthorization;
            return this;
        }

        private Builder(DnsAuthorizationName dnsAuthorizationName) {
            this.project = dnsAuthorizationName.project;
            this.location = dnsAuthorizationName.location;
            this.dnsAuthorization = dnsAuthorizationName.dnsAuthorization;
        }

        public DnsAuthorizationName build() {
            return new DnsAuthorizationName(this);
        }
    }
}

