/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.certificatemanager.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CertificateIssuanceConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CERTIFICATE_ISSUANCE_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/certificateIssuanceConfigs/{certificate_issuance_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String certificateIssuanceConfig;

    @Deprecated
    protected CertificateIssuanceConfigName() {
        this.project = null;
        this.location = null;
        this.certificateIssuanceConfig = null;
    }

    private CertificateIssuanceConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.certificateIssuanceConfig = (String)Preconditions.checkNotNull((Object)builder.getCertificateIssuanceConfig());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCertificateIssuanceConfig() {
        return this.certificateIssuanceConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CertificateIssuanceConfigName of(String project, String location, String certificateIssuanceConfig) {
        return CertificateIssuanceConfigName.newBuilder().setProject(project).setLocation(location).setCertificateIssuanceConfig(certificateIssuanceConfig).build();
    }

    public static String format(String project, String location, String certificateIssuanceConfig) {
        return CertificateIssuanceConfigName.newBuilder().setProject(project).setLocation(location).setCertificateIssuanceConfig(certificateIssuanceConfig).build().toString();
    }

    public static CertificateIssuanceConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CERTIFICATE_ISSUANCE_CONFIG.validatedMatch(formattedString, "CertificateIssuanceConfigName.parse: formattedString not in valid format");
        return CertificateIssuanceConfigName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("certificate_issuance_config"));
    }

    public static List<CertificateIssuanceConfigName> parseList(List<String> formattedStrings) {
        ArrayList<CertificateIssuanceConfigName> list = new ArrayList<CertificateIssuanceConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CertificateIssuanceConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CertificateIssuanceConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CertificateIssuanceConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CERTIFICATE_ISSUANCE_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CertificateIssuanceConfigName certificateIssuanceConfigName = this;
            synchronized (certificateIssuanceConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.certificateIssuanceConfig != null) {
                        fieldMapBuilder.put((Object)"certificate_issuance_config", (Object)this.certificateIssuanceConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CERTIFICATE_ISSUANCE_CONFIG.instantiate(new String[]{"project", this.project, "location", this.location, "certificate_issuance_config", this.certificateIssuanceConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CertificateIssuanceConfigName that = (CertificateIssuanceConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.certificateIssuanceConfig, that.certificateIssuanceConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.certificateIssuanceConfig);
    }

    public static class Builder {
        private String project;
        private String location;
        private String certificateIssuanceConfig;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCertificateIssuanceConfig() {
            return this.certificateIssuanceConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCertificateIssuanceConfig(String certificateIssuanceConfig) {
            this.certificateIssuanceConfig = certificateIssuanceConfig;
            return this;
        }

        private Builder(CertificateIssuanceConfigName certificateIssuanceConfigName) {
            this.project = certificateIssuanceConfigName.project;
            this.location = certificateIssuanceConfigName.location;
            this.certificateIssuanceConfig = certificateIssuanceConfigName.certificateIssuanceConfig;
        }

        public CertificateIssuanceConfigName build() {
            return new CertificateIssuanceConfigName(this);
        }
    }
}

