/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.capacityplanner.v1beta;

import com.google.cloud.capacityplanner.v1beta.MachineShape;
import com.google.cloud.capacityplanner.v1beta.MachineShapeOrBuilder;
import com.google.cloud.capacityplanner.v1beta.QueryReservationsRequestOrBuilder;
import com.google.cloud.capacityplanner.v1beta.TimeSeries;
import com.google.cloud.capacityplanner.v1beta.UsageHistory;
import com.google.cloud.capacityplanner.v1beta.UsageServiceProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.type.Date;
import com.google.type.DateOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class QueryReservationsRequest
extends GeneratedMessageV3
implements QueryReservationsRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int PARENT_FIELD_NUMBER = 1;
    private volatile Object parent_ = "";
    public static final int LOCATION_LEVEL_FIELD_NUMBER = 16;
    private int locationLevel_ = 0;
    public static final int MACHINE_FAMILY_FIELD_NUMBER = 2;
    private volatile Object machineFamily_ = "";
    public static final int MACHINE_SHAPE_FIELD_NUMBER = 11;
    private MachineShape machineShape_;
    public static final int GPU_TYPE_FIELD_NUMBER = 3;
    private volatile Object gpuType_ = "";
    public static final int CLOUD_RESOURCE_TYPE_FIELD_NUMBER = 4;
    private volatile Object cloudResourceType_ = "";
    public static final int RESERVATION_TYPE_FIELD_NUMBER = 5;
    private int reservationType_ = 0;
    public static final int SHARE_TYPE_FIELD_NUMBER = 6;
    private int shareType_ = 0;
    public static final int OWNERSHIP_TYPE_FIELD_NUMBER = 7;
    private int ownershipType_ = 0;
    public static final int RESERVATION_DATA_LEVEL_FIELD_NUMBER = 8;
    private int reservationDataLevel_ = 0;
    public static final int INCLUDE_UNAPPROVED_RESERVATIONS_FIELD_NUMBER = 12;
    private boolean includeUnapprovedReservations_ = false;
    public static final int AGGREGATION_METHOD_FIELD_NUMBER = 13;
    private int aggregationMethod_ = 0;
    public static final int START_DATE_FIELD_NUMBER = 14;
    private Date startDate_;
    public static final int END_DATE_FIELD_NUMBER = 15;
    private Date endDate_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final QueryReservationsRequest DEFAULT_INSTANCE = new QueryReservationsRequest();
    private static final Parser<QueryReservationsRequest> PARSER = new AbstractParser<QueryReservationsRequest>(){

        public QueryReservationsRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = QueryReservationsRequest.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private QueryReservationsRequest(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private QueryReservationsRequest() {
        this.parent_ = "";
        this.locationLevel_ = 0;
        this.machineFamily_ = "";
        this.gpuType_ = "";
        this.cloudResourceType_ = "";
        this.reservationType_ = 0;
        this.shareType_ = 0;
        this.ownershipType_ = 0;
        this.reservationDataLevel_ = 0;
        this.aggregationMethod_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new QueryReservationsRequest();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return UsageServiceProto.internal_static_google_cloud_capacityplanner_v1beta_QueryReservationsRequest_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return UsageServiceProto.internal_static_google_cloud_capacityplanner_v1beta_QueryReservationsRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(QueryReservationsRequest.class, Builder.class);
    }

    @Override
    public String getParent() {
        Object ref = this.parent_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.parent_ = s;
        return s;
    }

    @Override
    public ByteString getParentBytes() {
        Object ref = this.parent_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.parent_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getLocationLevelValue() {
        return this.locationLevel_;
    }

    @Override
    public TimeSeries.LocationType getLocationLevel() {
        TimeSeries.LocationType result = TimeSeries.LocationType.forNumber(this.locationLevel_);
        return result == null ? TimeSeries.LocationType.UNRECOGNIZED : result;
    }

    @Override
    public String getMachineFamily() {
        Object ref = this.machineFamily_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.machineFamily_ = s;
        return s;
    }

    @Override
    public ByteString getMachineFamilyBytes() {
        Object ref = this.machineFamily_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.machineFamily_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasMachineShape() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public MachineShape getMachineShape() {
        return this.machineShape_ == null ? MachineShape.getDefaultInstance() : this.machineShape_;
    }

    @Override
    public MachineShapeOrBuilder getMachineShapeOrBuilder() {
        return this.machineShape_ == null ? MachineShape.getDefaultInstance() : this.machineShape_;
    }

    @Override
    public String getGpuType() {
        Object ref = this.gpuType_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.gpuType_ = s;
        return s;
    }

    @Override
    public ByteString getGpuTypeBytes() {
        Object ref = this.gpuType_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.gpuType_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getCloudResourceType() {
        Object ref = this.cloudResourceType_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.cloudResourceType_ = s;
        return s;
    }

    @Override
    public ByteString getCloudResourceTypeBytes() {
        Object ref = this.cloudResourceType_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.cloudResourceType_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getReservationTypeValue() {
        return this.reservationType_;
    }

    @Override
    public ReservationType getReservationType() {
        ReservationType result = ReservationType.forNumber(this.reservationType_);
        return result == null ? ReservationType.UNRECOGNIZED : result;
    }

    @Override
    public int getShareTypeValue() {
        return this.shareType_;
    }

    @Override
    public ShareType getShareType() {
        ShareType result = ShareType.forNumber(this.shareType_);
        return result == null ? ShareType.UNRECOGNIZED : result;
    }

    @Override
    public int getOwnershipTypeValue() {
        return this.ownershipType_;
    }

    @Override
    public OwnershipType getOwnershipType() {
        OwnershipType result = OwnershipType.forNumber(this.ownershipType_);
        return result == null ? OwnershipType.UNRECOGNIZED : result;
    }

    @Override
    public int getReservationDataLevelValue() {
        return this.reservationDataLevel_;
    }

    @Override
    public ReservationDataLevel getReservationDataLevel() {
        ReservationDataLevel result = ReservationDataLevel.forNumber(this.reservationDataLevel_);
        return result == null ? ReservationDataLevel.UNRECOGNIZED : result;
    }

    @Override
    public boolean getIncludeUnapprovedReservations() {
        return this.includeUnapprovedReservations_;
    }

    @Override
    public int getAggregationMethodValue() {
        return this.aggregationMethod_;
    }

    @Override
    public UsageHistory.AggregationMethod getAggregationMethod() {
        UsageHistory.AggregationMethod result = UsageHistory.AggregationMethod.forNumber(this.aggregationMethod_);
        return result == null ? UsageHistory.AggregationMethod.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasStartDate() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public Date getStartDate() {
        return this.startDate_ == null ? Date.getDefaultInstance() : this.startDate_;
    }

    @Override
    public DateOrBuilder getStartDateOrBuilder() {
        return this.startDate_ == null ? Date.getDefaultInstance() : this.startDate_;
    }

    @Override
    public boolean hasEndDate() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public Date getEndDate() {
        return this.endDate_ == null ? Date.getDefaultInstance() : this.endDate_;
    }

    @Override
    public DateOrBuilder getEndDateOrBuilder() {
        return this.endDate_ == null ? Date.getDefaultInstance() : this.endDate_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.parent_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.parent_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.machineFamily_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)2, (Object)this.machineFamily_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.gpuType_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3, (Object)this.gpuType_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.cloudResourceType_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.cloudResourceType_);
        }
        if (this.reservationType_ != ReservationType.RESERVATION_TYPE_UNSPECIFIED.getNumber()) {
            output.writeEnum(5, this.reservationType_);
        }
        if (this.shareType_ != ShareType.SHARE_TYPE_UNSPECIFIED.getNumber()) {
            output.writeEnum(6, this.shareType_);
        }
        if (this.ownershipType_ != OwnershipType.OWNERSHIP_TYPE_UNSPECIFIED.getNumber()) {
            output.writeEnum(7, this.ownershipType_);
        }
        if (this.reservationDataLevel_ != ReservationDataLevel.RESERVATION_DATA_LEVEL_UNSPECIFIED.getNumber()) {
            output.writeEnum(8, this.reservationDataLevel_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(11, (MessageLite)this.getMachineShape());
        }
        if (this.includeUnapprovedReservations_) {
            output.writeBool(12, this.includeUnapprovedReservations_);
        }
        if (this.aggregationMethod_ != UsageHistory.AggregationMethod.AGGREGATION_METHOD_UNSPECIFIED.getNumber()) {
            output.writeEnum(13, this.aggregationMethod_);
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(14, (MessageLite)this.getStartDate());
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(15, (MessageLite)this.getEndDate());
        }
        if (this.locationLevel_ != TimeSeries.LocationType.LOCATION_TYPE_UNSPECIFIED.getNumber()) {
            output.writeEnum(16, this.locationLevel_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.parent_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.parent_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.machineFamily_)) {
            size += GeneratedMessageV3.computeStringSize((int)2, (Object)this.machineFamily_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.gpuType_)) {
            size += GeneratedMessageV3.computeStringSize((int)3, (Object)this.gpuType_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.cloudResourceType_)) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.cloudResourceType_);
        }
        if (this.reservationType_ != ReservationType.RESERVATION_TYPE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)5, (int)this.reservationType_);
        }
        if (this.shareType_ != ShareType.SHARE_TYPE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)6, (int)this.shareType_);
        }
        if (this.ownershipType_ != OwnershipType.OWNERSHIP_TYPE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)7, (int)this.ownershipType_);
        }
        if (this.reservationDataLevel_ != ReservationDataLevel.RESERVATION_DATA_LEVEL_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)8, (int)this.reservationDataLevel_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)11, (MessageLite)this.getMachineShape());
        }
        if (this.includeUnapprovedReservations_) {
            size += CodedOutputStream.computeBoolSize((int)12, (boolean)this.includeUnapprovedReservations_);
        }
        if (this.aggregationMethod_ != UsageHistory.AggregationMethod.AGGREGATION_METHOD_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)13, (int)this.aggregationMethod_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)14, (MessageLite)this.getStartDate());
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)15, (MessageLite)this.getEndDate());
        }
        if (this.locationLevel_ != TimeSeries.LocationType.LOCATION_TYPE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)16, (int)this.locationLevel_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof QueryReservationsRequest)) {
            return super.equals(obj);
        }
        QueryReservationsRequest other = (QueryReservationsRequest)obj;
        if (!this.getParent().equals(other.getParent())) {
            return false;
        }
        if (this.locationLevel_ != other.locationLevel_) {
            return false;
        }
        if (!this.getMachineFamily().equals(other.getMachineFamily())) {
            return false;
        }
        if (this.hasMachineShape() != other.hasMachineShape()) {
            return false;
        }
        if (this.hasMachineShape() && !this.getMachineShape().equals(other.getMachineShape())) {
            return false;
        }
        if (!this.getGpuType().equals(other.getGpuType())) {
            return false;
        }
        if (!this.getCloudResourceType().equals(other.getCloudResourceType())) {
            return false;
        }
        if (this.reservationType_ != other.reservationType_) {
            return false;
        }
        if (this.shareType_ != other.shareType_) {
            return false;
        }
        if (this.ownershipType_ != other.ownershipType_) {
            return false;
        }
        if (this.reservationDataLevel_ != other.reservationDataLevel_) {
            return false;
        }
        if (this.getIncludeUnapprovedReservations() != other.getIncludeUnapprovedReservations()) {
            return false;
        }
        if (this.aggregationMethod_ != other.aggregationMethod_) {
            return false;
        }
        if (this.hasStartDate() != other.hasStartDate()) {
            return false;
        }
        if (this.hasStartDate() && !this.getStartDate().equals((Object)other.getStartDate())) {
            return false;
        }
        if (this.hasEndDate() != other.hasEndDate()) {
            return false;
        }
        if (this.hasEndDate() && !this.getEndDate().equals((Object)other.getEndDate())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + QueryReservationsRequest.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getParent().hashCode();
        hash = 37 * hash + 16;
        hash = 53 * hash + this.locationLevel_;
        hash = 37 * hash + 2;
        hash = 53 * hash + this.getMachineFamily().hashCode();
        if (this.hasMachineShape()) {
            hash = 37 * hash + 11;
            hash = 53 * hash + this.getMachineShape().hashCode();
        }
        hash = 37 * hash + 3;
        hash = 53 * hash + this.getGpuType().hashCode();
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getCloudResourceType().hashCode();
        hash = 37 * hash + 5;
        hash = 53 * hash + this.reservationType_;
        hash = 37 * hash + 6;
        hash = 53 * hash + this.shareType_;
        hash = 37 * hash + 7;
        hash = 53 * hash + this.ownershipType_;
        hash = 37 * hash + 8;
        hash = 53 * hash + this.reservationDataLevel_;
        hash = 37 * hash + 12;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getIncludeUnapprovedReservations());
        hash = 37 * hash + 13;
        hash = 53 * hash + this.aggregationMethod_;
        if (this.hasStartDate()) {
            hash = 37 * hash + 14;
            hash = 53 * hash + this.getStartDate().hashCode();
        }
        if (this.hasEndDate()) {
            hash = 37 * hash + 15;
            hash = 53 * hash + this.getEndDate().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static QueryReservationsRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (QueryReservationsRequest)PARSER.parseFrom(data);
    }

    public static QueryReservationsRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (QueryReservationsRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static QueryReservationsRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (QueryReservationsRequest)PARSER.parseFrom(data);
    }

    public static QueryReservationsRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (QueryReservationsRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static QueryReservationsRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (QueryReservationsRequest)PARSER.parseFrom(data);
    }

    public static QueryReservationsRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (QueryReservationsRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static QueryReservationsRequest parseFrom(InputStream input) throws IOException {
        return (QueryReservationsRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static QueryReservationsRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (QueryReservationsRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static QueryReservationsRequest parseDelimitedFrom(InputStream input) throws IOException {
        return (QueryReservationsRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static QueryReservationsRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (QueryReservationsRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static QueryReservationsRequest parseFrom(CodedInputStream input) throws IOException {
        return (QueryReservationsRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static QueryReservationsRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (QueryReservationsRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return QueryReservationsRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(QueryReservationsRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static QueryReservationsRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<QueryReservationsRequest> parser() {
        return PARSER;
    }

    public Parser<QueryReservationsRequest> getParserForType() {
        return PARSER;
    }

    public QueryReservationsRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements QueryReservationsRequestOrBuilder {
        private int bitField0_;
        private Object parent_ = "";
        private int locationLevel_ = 0;
        private Object machineFamily_ = "";
        private MachineShape machineShape_;
        private SingleFieldBuilderV3<MachineShape, MachineShape.Builder, MachineShapeOrBuilder> machineShapeBuilder_;
        private Object gpuType_ = "";
        private Object cloudResourceType_ = "";
        private int reservationType_ = 0;
        private int shareType_ = 0;
        private int ownershipType_ = 0;
        private int reservationDataLevel_ = 0;
        private boolean includeUnapprovedReservations_;
        private int aggregationMethod_ = 0;
        private Date startDate_;
        private SingleFieldBuilderV3<Date, Date.Builder, DateOrBuilder> startDateBuilder_;
        private Date endDate_;
        private SingleFieldBuilderV3<Date, Date.Builder, DateOrBuilder> endDateBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return UsageServiceProto.internal_static_google_cloud_capacityplanner_v1beta_QueryReservationsRequest_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return UsageServiceProto.internal_static_google_cloud_capacityplanner_v1beta_QueryReservationsRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(QueryReservationsRequest.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getMachineShapeFieldBuilder();
                this.getStartDateFieldBuilder();
                this.getEndDateFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.parent_ = "";
            this.locationLevel_ = 0;
            this.machineFamily_ = "";
            this.machineShape_ = null;
            if (this.machineShapeBuilder_ != null) {
                this.machineShapeBuilder_.dispose();
                this.machineShapeBuilder_ = null;
            }
            this.gpuType_ = "";
            this.cloudResourceType_ = "";
            this.reservationType_ = 0;
            this.shareType_ = 0;
            this.ownershipType_ = 0;
            this.reservationDataLevel_ = 0;
            this.includeUnapprovedReservations_ = false;
            this.aggregationMethod_ = 0;
            this.startDate_ = null;
            if (this.startDateBuilder_ != null) {
                this.startDateBuilder_.dispose();
                this.startDateBuilder_ = null;
            }
            this.endDate_ = null;
            if (this.endDateBuilder_ != null) {
                this.endDateBuilder_.dispose();
                this.endDateBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return UsageServiceProto.internal_static_google_cloud_capacityplanner_v1beta_QueryReservationsRequest_descriptor;
        }

        public QueryReservationsRequest getDefaultInstanceForType() {
            return QueryReservationsRequest.getDefaultInstance();
        }

        public QueryReservationsRequest build() {
            QueryReservationsRequest result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public QueryReservationsRequest buildPartial() {
            QueryReservationsRequest result = new QueryReservationsRequest(this);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartial0(QueryReservationsRequest result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.parent_ = this.parent_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.locationLevel_ = this.locationLevel_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.machineFamily_ = this.machineFamily_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 8) != 0) {
                result.machineShape_ = this.machineShapeBuilder_ == null ? this.machineShape_ : (MachineShape)this.machineShapeBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.gpuType_ = this.gpuType_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.cloudResourceType_ = this.cloudResourceType_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.reservationType_ = this.reservationType_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.shareType_ = this.shareType_;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.ownershipType_ = this.ownershipType_;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.reservationDataLevel_ = this.reservationDataLevel_;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.includeUnapprovedReservations_ = this.includeUnapprovedReservations_;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.aggregationMethod_ = this.aggregationMethod_;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.startDate_ = this.startDateBuilder_ == null ? this.startDate_ : (Date)this.startDateBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                result.endDate_ = this.endDateBuilder_ == null ? this.endDate_ : (Date)this.endDateBuilder_.build();
                to_bitField0_ |= 4;
            }
            QueryReservationsRequest queryReservationsRequest = result;
            queryReservationsRequest.bitField0_ = queryReservationsRequest.bitField0_ | to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof QueryReservationsRequest) {
                return this.mergeFrom((QueryReservationsRequest)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(QueryReservationsRequest other) {
            if (other == QueryReservationsRequest.getDefaultInstance()) {
                return this;
            }
            if (!other.getParent().isEmpty()) {
                this.parent_ = other.parent_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.locationLevel_ != 0) {
                this.setLocationLevelValue(other.getLocationLevelValue());
            }
            if (!other.getMachineFamily().isEmpty()) {
                this.machineFamily_ = other.machineFamily_;
                this.bitField0_ |= 4;
                this.onChanged();
            }
            if (other.hasMachineShape()) {
                this.mergeMachineShape(other.getMachineShape());
            }
            if (!other.getGpuType().isEmpty()) {
                this.gpuType_ = other.gpuType_;
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            if (!other.getCloudResourceType().isEmpty()) {
                this.cloudResourceType_ = other.cloudResourceType_;
                this.bitField0_ |= 0x20;
                this.onChanged();
            }
            if (other.reservationType_ != 0) {
                this.setReservationTypeValue(other.getReservationTypeValue());
            }
            if (other.shareType_ != 0) {
                this.setShareTypeValue(other.getShareTypeValue());
            }
            if (other.ownershipType_ != 0) {
                this.setOwnershipTypeValue(other.getOwnershipTypeValue());
            }
            if (other.reservationDataLevel_ != 0) {
                this.setReservationDataLevelValue(other.getReservationDataLevelValue());
            }
            if (other.getIncludeUnapprovedReservations()) {
                this.setIncludeUnapprovedReservations(other.getIncludeUnapprovedReservations());
            }
            if (other.aggregationMethod_ != 0) {
                this.setAggregationMethodValue(other.getAggregationMethodValue());
            }
            if (other.hasStartDate()) {
                this.mergeStartDate(other.getStartDate());
            }
            if (other.hasEndDate()) {
                this.mergeEndDate(other.getEndDate());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block22: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block22;
                        }
                        case 10: {
                            this.parent_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block22;
                        }
                        case 18: {
                            this.machineFamily_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 4;
                            continue block22;
                        }
                        case 26: {
                            this.gpuType_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x10;
                            continue block22;
                        }
                        case 34: {
                            this.cloudResourceType_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x20;
                            continue block22;
                        }
                        case 40: {
                            this.reservationType_ = input.readEnum();
                            this.bitField0_ |= 0x40;
                            continue block22;
                        }
                        case 48: {
                            this.shareType_ = input.readEnum();
                            this.bitField0_ |= 0x80;
                            continue block22;
                        }
                        case 56: {
                            this.ownershipType_ = input.readEnum();
                            this.bitField0_ |= 0x100;
                            continue block22;
                        }
                        case 64: {
                            this.reservationDataLevel_ = input.readEnum();
                            this.bitField0_ |= 0x200;
                            continue block22;
                        }
                        case 90: {
                            input.readMessage((MessageLite.Builder)this.getMachineShapeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 8;
                            continue block22;
                        }
                        case 96: {
                            this.includeUnapprovedReservations_ = input.readBool();
                            this.bitField0_ |= 0x400;
                            continue block22;
                        }
                        case 104: {
                            this.aggregationMethod_ = input.readEnum();
                            this.bitField0_ |= 0x800;
                            continue block22;
                        }
                        case 114: {
                            input.readMessage((MessageLite.Builder)this.getStartDateFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x1000;
                            continue block22;
                        }
                        case 122: {
                            input.readMessage((MessageLite.Builder)this.getEndDateFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x2000;
                            continue block22;
                        }
                        case 128: {
                            this.locationLevel_ = input.readEnum();
                            this.bitField0_ |= 2;
                            continue block22;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getParent() {
            Object ref = this.parent_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.parent_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getParentBytes() {
            Object ref = this.parent_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.parent_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setParent(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.parent_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearParent() {
            this.parent_ = QueryReservationsRequest.getDefaultInstance().getParent();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setParentBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            QueryReservationsRequest.checkByteStringIsUtf8((ByteString)value);
            this.parent_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public int getLocationLevelValue() {
            return this.locationLevel_;
        }

        public Builder setLocationLevelValue(int value) {
            this.locationLevel_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public TimeSeries.LocationType getLocationLevel() {
            TimeSeries.LocationType result = TimeSeries.LocationType.forNumber(this.locationLevel_);
            return result == null ? TimeSeries.LocationType.UNRECOGNIZED : result;
        }

        public Builder setLocationLevel(TimeSeries.LocationType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 2;
            this.locationLevel_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearLocationLevel() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.locationLevel_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getMachineFamily() {
            Object ref = this.machineFamily_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.machineFamily_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getMachineFamilyBytes() {
            Object ref = this.machineFamily_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.machineFamily_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setMachineFamily(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.machineFamily_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearMachineFamily() {
            this.machineFamily_ = QueryReservationsRequest.getDefaultInstance().getMachineFamily();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        public Builder setMachineFamilyBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            QueryReservationsRequest.checkByteStringIsUtf8((ByteString)value);
            this.machineFamily_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasMachineShape() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public MachineShape getMachineShape() {
            if (this.machineShapeBuilder_ == null) {
                return this.machineShape_ == null ? MachineShape.getDefaultInstance() : this.machineShape_;
            }
            return (MachineShape)this.machineShapeBuilder_.getMessage();
        }

        public Builder setMachineShape(MachineShape value) {
            if (this.machineShapeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.machineShape_ = value;
            } else {
                this.machineShapeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder setMachineShape(MachineShape.Builder builderForValue) {
            if (this.machineShapeBuilder_ == null) {
                this.machineShape_ = builderForValue.build();
            } else {
                this.machineShapeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder mergeMachineShape(MachineShape value) {
            if (this.machineShapeBuilder_ == null) {
                if ((this.bitField0_ & 8) != 0 && this.machineShape_ != null && this.machineShape_ != MachineShape.getDefaultInstance()) {
                    this.getMachineShapeBuilder().mergeFrom(value);
                } else {
                    this.machineShape_ = value;
                }
            } else {
                this.machineShapeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.machineShape_ != null) {
                this.bitField0_ |= 8;
                this.onChanged();
            }
            return this;
        }

        public Builder clearMachineShape() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.machineShape_ = null;
            if (this.machineShapeBuilder_ != null) {
                this.machineShapeBuilder_.dispose();
                this.machineShapeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public MachineShape.Builder getMachineShapeBuilder() {
            this.bitField0_ |= 8;
            this.onChanged();
            return (MachineShape.Builder)this.getMachineShapeFieldBuilder().getBuilder();
        }

        @Override
        public MachineShapeOrBuilder getMachineShapeOrBuilder() {
            if (this.machineShapeBuilder_ != null) {
                return (MachineShapeOrBuilder)this.machineShapeBuilder_.getMessageOrBuilder();
            }
            return this.machineShape_ == null ? MachineShape.getDefaultInstance() : this.machineShape_;
        }

        private SingleFieldBuilderV3<MachineShape, MachineShape.Builder, MachineShapeOrBuilder> getMachineShapeFieldBuilder() {
            if (this.machineShapeBuilder_ == null) {
                this.machineShapeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getMachineShape(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.machineShape_ = null;
            }
            return this.machineShapeBuilder_;
        }

        @Override
        public String getGpuType() {
            Object ref = this.gpuType_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.gpuType_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getGpuTypeBytes() {
            Object ref = this.gpuType_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.gpuType_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setGpuType(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.gpuType_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder clearGpuType() {
            this.gpuType_ = QueryReservationsRequest.getDefaultInstance().getGpuType();
            this.bitField0_ &= 0xFFFFFFEF;
            this.onChanged();
            return this;
        }

        public Builder setGpuTypeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            QueryReservationsRequest.checkByteStringIsUtf8((ByteString)value);
            this.gpuType_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public String getCloudResourceType() {
            Object ref = this.cloudResourceType_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.cloudResourceType_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getCloudResourceTypeBytes() {
            Object ref = this.cloudResourceType_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.cloudResourceType_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setCloudResourceType(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.cloudResourceType_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearCloudResourceType() {
            this.cloudResourceType_ = QueryReservationsRequest.getDefaultInstance().getCloudResourceType();
            this.bitField0_ &= 0xFFFFFFDF;
            this.onChanged();
            return this;
        }

        public Builder setCloudResourceTypeBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            QueryReservationsRequest.checkByteStringIsUtf8((ByteString)value);
            this.cloudResourceType_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        @Override
        public int getReservationTypeValue() {
            return this.reservationType_;
        }

        public Builder setReservationTypeValue(int value) {
            this.reservationType_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        @Override
        public ReservationType getReservationType() {
            ReservationType result = ReservationType.forNumber(this.reservationType_);
            return result == null ? ReservationType.UNRECOGNIZED : result;
        }

        public Builder setReservationType(ReservationType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x40;
            this.reservationType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearReservationType() {
            this.bitField0_ &= 0xFFFFFFBF;
            this.reservationType_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getShareTypeValue() {
            return this.shareType_;
        }

        public Builder setShareTypeValue(int value) {
            this.shareType_ = value;
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        @Override
        public ShareType getShareType() {
            ShareType result = ShareType.forNumber(this.shareType_);
            return result == null ? ShareType.UNRECOGNIZED : result;
        }

        public Builder setShareType(ShareType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x80;
            this.shareType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearShareType() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.shareType_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getOwnershipTypeValue() {
            return this.ownershipType_;
        }

        public Builder setOwnershipTypeValue(int value) {
            this.ownershipType_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        @Override
        public OwnershipType getOwnershipType() {
            OwnershipType result = OwnershipType.forNumber(this.ownershipType_);
            return result == null ? OwnershipType.UNRECOGNIZED : result;
        }

        public Builder setOwnershipType(OwnershipType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x100;
            this.ownershipType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearOwnershipType() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.ownershipType_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getReservationDataLevelValue() {
            return this.reservationDataLevel_;
        }

        public Builder setReservationDataLevelValue(int value) {
            this.reservationDataLevel_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        @Override
        public ReservationDataLevel getReservationDataLevel() {
            ReservationDataLevel result = ReservationDataLevel.forNumber(this.reservationDataLevel_);
            return result == null ? ReservationDataLevel.UNRECOGNIZED : result;
        }

        public Builder setReservationDataLevel(ReservationDataLevel value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x200;
            this.reservationDataLevel_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearReservationDataLevel() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.reservationDataLevel_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getIncludeUnapprovedReservations() {
            return this.includeUnapprovedReservations_;
        }

        public Builder setIncludeUnapprovedReservations(boolean value) {
            this.includeUnapprovedReservations_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearIncludeUnapprovedReservations() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.includeUnapprovedReservations_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public int getAggregationMethodValue() {
            return this.aggregationMethod_;
        }

        public Builder setAggregationMethodValue(int value) {
            this.aggregationMethod_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        @Override
        public UsageHistory.AggregationMethod getAggregationMethod() {
            UsageHistory.AggregationMethod result = UsageHistory.AggregationMethod.forNumber(this.aggregationMethod_);
            return result == null ? UsageHistory.AggregationMethod.UNRECOGNIZED : result;
        }

        public Builder setAggregationMethod(UsageHistory.AggregationMethod value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x800;
            this.aggregationMethod_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearAggregationMethod() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.aggregationMethod_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasStartDate() {
            return (this.bitField0_ & 0x1000) != 0;
        }

        @Override
        public Date getStartDate() {
            if (this.startDateBuilder_ == null) {
                return this.startDate_ == null ? Date.getDefaultInstance() : this.startDate_;
            }
            return (Date)this.startDateBuilder_.getMessage();
        }

        public Builder setStartDate(Date value) {
            if (this.startDateBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.startDate_ = value;
            } else {
                this.startDateBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder setStartDate(Date.Builder builderForValue) {
            if (this.startDateBuilder_ == null) {
                this.startDate_ = builderForValue.build();
            } else {
                this.startDateBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder mergeStartDate(Date value) {
            if (this.startDateBuilder_ == null) {
                if ((this.bitField0_ & 0x1000) != 0 && this.startDate_ != null && this.startDate_ != Date.getDefaultInstance()) {
                    this.getStartDateBuilder().mergeFrom(value);
                } else {
                    this.startDate_ = value;
                }
            } else {
                this.startDateBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.startDate_ != null) {
                this.bitField0_ |= 0x1000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearStartDate() {
            this.bitField0_ &= 0xFFFFEFFF;
            this.startDate_ = null;
            if (this.startDateBuilder_ != null) {
                this.startDateBuilder_.dispose();
                this.startDateBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Date.Builder getStartDateBuilder() {
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return (Date.Builder)this.getStartDateFieldBuilder().getBuilder();
        }

        @Override
        public DateOrBuilder getStartDateOrBuilder() {
            if (this.startDateBuilder_ != null) {
                return (DateOrBuilder)this.startDateBuilder_.getMessageOrBuilder();
            }
            return this.startDate_ == null ? Date.getDefaultInstance() : this.startDate_;
        }

        private SingleFieldBuilderV3<Date, Date.Builder, DateOrBuilder> getStartDateFieldBuilder() {
            if (this.startDateBuilder_ == null) {
                this.startDateBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getStartDate(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.startDate_ = null;
            }
            return this.startDateBuilder_;
        }

        @Override
        public boolean hasEndDate() {
            return (this.bitField0_ & 0x2000) != 0;
        }

        @Override
        public Date getEndDate() {
            if (this.endDateBuilder_ == null) {
                return this.endDate_ == null ? Date.getDefaultInstance() : this.endDate_;
            }
            return (Date)this.endDateBuilder_.getMessage();
        }

        public Builder setEndDate(Date value) {
            if (this.endDateBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.endDate_ = value;
            } else {
                this.endDateBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder setEndDate(Date.Builder builderForValue) {
            if (this.endDateBuilder_ == null) {
                this.endDate_ = builderForValue.build();
            } else {
                this.endDateBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder mergeEndDate(Date value) {
            if (this.endDateBuilder_ == null) {
                if ((this.bitField0_ & 0x2000) != 0 && this.endDate_ != null && this.endDate_ != Date.getDefaultInstance()) {
                    this.getEndDateBuilder().mergeFrom(value);
                } else {
                    this.endDate_ = value;
                }
            } else {
                this.endDateBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.endDate_ != null) {
                this.bitField0_ |= 0x2000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearEndDate() {
            this.bitField0_ &= 0xFFFFDFFF;
            this.endDate_ = null;
            if (this.endDateBuilder_ != null) {
                this.endDateBuilder_.dispose();
                this.endDateBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Date.Builder getEndDateBuilder() {
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return (Date.Builder)this.getEndDateFieldBuilder().getBuilder();
        }

        @Override
        public DateOrBuilder getEndDateOrBuilder() {
            if (this.endDateBuilder_ != null) {
                return (DateOrBuilder)this.endDateBuilder_.getMessageOrBuilder();
            }
            return this.endDate_ == null ? Date.getDefaultInstance() : this.endDate_;
        }

        private SingleFieldBuilderV3<Date, Date.Builder, DateOrBuilder> getEndDateFieldBuilder() {
            if (this.endDateBuilder_ == null) {
                this.endDateBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getEndDate(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.endDate_ = null;
            }
            return this.endDateBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum ReservationDataLevel implements ProtocolMessageEnum
    {
        RESERVATION_DATA_LEVEL_UNSPECIFIED(0),
        RESERVATION_DATA_LEVEL_AGGREGATED(1),
        RESERVATION_DATA_LEVEL_PER_RESERVATION(2),
        UNRECOGNIZED(-1);

        public static final int RESERVATION_DATA_LEVEL_UNSPECIFIED_VALUE = 0;
        public static final int RESERVATION_DATA_LEVEL_AGGREGATED_VALUE = 1;
        public static final int RESERVATION_DATA_LEVEL_PER_RESERVATION_VALUE = 2;
        private static final Internal.EnumLiteMap<ReservationDataLevel> internalValueMap;
        private static final ReservationDataLevel[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static ReservationDataLevel valueOf(int value) {
            return ReservationDataLevel.forNumber(value);
        }

        public static ReservationDataLevel forNumber(int value) {
            switch (value) {
                case 0: {
                    return RESERVATION_DATA_LEVEL_UNSPECIFIED;
                }
                case 1: {
                    return RESERVATION_DATA_LEVEL_AGGREGATED;
                }
                case 2: {
                    return RESERVATION_DATA_LEVEL_PER_RESERVATION;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<ReservationDataLevel> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)ReservationDataLevel.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return ReservationDataLevel.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)QueryReservationsRequest.getDescriptor().getEnumTypes().get(3);
        }

        public static ReservationDataLevel valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != ReservationDataLevel.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private ReservationDataLevel(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<ReservationDataLevel>(){

                public ReservationDataLevel findValueByNumber(int number) {
                    return ReservationDataLevel.forNumber(number);
                }
            };
            VALUES = ReservationDataLevel.values();
        }
    }

    public static enum OwnershipType implements ProtocolMessageEnum
    {
        OWNERSHIP_TYPE_UNSPECIFIED(0),
        OWNERSHIP_TYPE_OWNED(1),
        OWNERSHIP_TYPE_SHARED_BY_OTHERS(2),
        UNRECOGNIZED(-1);

        public static final int OWNERSHIP_TYPE_UNSPECIFIED_VALUE = 0;
        public static final int OWNERSHIP_TYPE_OWNED_VALUE = 1;
        public static final int OWNERSHIP_TYPE_SHARED_BY_OTHERS_VALUE = 2;
        private static final Internal.EnumLiteMap<OwnershipType> internalValueMap;
        private static final OwnershipType[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static OwnershipType valueOf(int value) {
            return OwnershipType.forNumber(value);
        }

        public static OwnershipType forNumber(int value) {
            switch (value) {
                case 0: {
                    return OWNERSHIP_TYPE_UNSPECIFIED;
                }
                case 1: {
                    return OWNERSHIP_TYPE_OWNED;
                }
                case 2: {
                    return OWNERSHIP_TYPE_SHARED_BY_OTHERS;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<OwnershipType> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)OwnershipType.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return OwnershipType.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)QueryReservationsRequest.getDescriptor().getEnumTypes().get(2);
        }

        public static OwnershipType valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != OwnershipType.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private OwnershipType(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<OwnershipType>(){

                public OwnershipType findValueByNumber(int number) {
                    return OwnershipType.forNumber(number);
                }
            };
            VALUES = OwnershipType.values();
        }
    }

    public static enum ShareType implements ProtocolMessageEnum
    {
        SHARE_TYPE_UNSPECIFIED(0),
        SHARE_TYPE_LOCAL(1),
        SHARE_TYPE_SPECIFIC_PROJECTS(2),
        UNRECOGNIZED(-1);

        public static final int SHARE_TYPE_UNSPECIFIED_VALUE = 0;
        public static final int SHARE_TYPE_LOCAL_VALUE = 1;
        public static final int SHARE_TYPE_SPECIFIC_PROJECTS_VALUE = 2;
        private static final Internal.EnumLiteMap<ShareType> internalValueMap;
        private static final ShareType[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static ShareType valueOf(int value) {
            return ShareType.forNumber(value);
        }

        public static ShareType forNumber(int value) {
            switch (value) {
                case 0: {
                    return SHARE_TYPE_UNSPECIFIED;
                }
                case 1: {
                    return SHARE_TYPE_LOCAL;
                }
                case 2: {
                    return SHARE_TYPE_SPECIFIC_PROJECTS;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<ShareType> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)ShareType.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return ShareType.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)QueryReservationsRequest.getDescriptor().getEnumTypes().get(1);
        }

        public static ShareType valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != ShareType.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private ShareType(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<ShareType>(){

                public ShareType findValueByNumber(int number) {
                    return ShareType.forNumber(number);
                }
            };
            VALUES = ShareType.values();
        }
    }

    public static enum ReservationType implements ProtocolMessageEnum
    {
        RESERVATION_TYPE_UNSPECIFIED(0),
        RESERVATION_TYPE_ALLOCATION(1),
        RESERVATION_TYPE_FUTURE_RESERVATION(2),
        RESERVATION_TYPE_ALL(3),
        UNRECOGNIZED(-1);

        public static final int RESERVATION_TYPE_UNSPECIFIED_VALUE = 0;
        public static final int RESERVATION_TYPE_ALLOCATION_VALUE = 1;
        public static final int RESERVATION_TYPE_FUTURE_RESERVATION_VALUE = 2;
        public static final int RESERVATION_TYPE_ALL_VALUE = 3;
        private static final Internal.EnumLiteMap<ReservationType> internalValueMap;
        private static final ReservationType[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static ReservationType valueOf(int value) {
            return ReservationType.forNumber(value);
        }

        public static ReservationType forNumber(int value) {
            switch (value) {
                case 0: {
                    return RESERVATION_TYPE_UNSPECIFIED;
                }
                case 1: {
                    return RESERVATION_TYPE_ALLOCATION;
                }
                case 2: {
                    return RESERVATION_TYPE_FUTURE_RESERVATION;
                }
                case 3: {
                    return RESERVATION_TYPE_ALL;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<ReservationType> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)ReservationType.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return ReservationType.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)QueryReservationsRequest.getDescriptor().getEnumTypes().get(0);
        }

        public static ReservationType valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != ReservationType.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private ReservationType(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<ReservationType>(){

                public ReservationType findValueByNumber(int number) {
                    return ReservationType.forNumber(number);
                }
            };
            VALUES = ReservationType.values();
        }
    }
}

