/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloudbuild.v1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BuildName
implements ResourceName {
    private static final PathTemplate PROJECT_BUILD_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/builds/{build}");
    private static final PathTemplate PROJECT_LOCATION_BUILD_PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/builds/{build}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private String project;
    private String build;
    private String location;

    @Deprecated
    protected BuildName() {
    }

    public String getProject() {
        return this.project;
    }

    public String getBuild() {
        return this.build;
    }

    public String getLocation() {
        return this.location;
    }

    private BuildName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.build = (String)Preconditions.checkNotNull((Object)builder.getBuild());
        this.pathTemplate = PROJECT_BUILD_PATH_TEMPLATE;
    }

    private BuildName(ProjectLocationBuildBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.build = (String)Preconditions.checkNotNull((Object)builder.getBuild());
        this.pathTemplate = PROJECT_LOCATION_BUILD_PATH_TEMPLATE;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectBuildBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static ProjectLocationBuildBuilder newProjectLocationBuildBuilder() {
        return new ProjectLocationBuildBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BuildName of(String project, String build) {
        return BuildName.newProjectBuildBuilder().setProject(project).setBuild(build).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static BuildName ofProjectBuildName(String project, String build) {
        return BuildName.newProjectBuildBuilder().setProject(project).setBuild(build).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static BuildName ofProjectLocationBuildName(String project, String location, String build) {
        return BuildName.newProjectLocationBuildBuilder().setProject(project).setLocation(location).setBuild(build).build();
    }

    public static String format(String project, String build) {
        return BuildName.newBuilder().setProject(project).setBuild(build).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectBuildName(String project, String build) {
        return BuildName.newBuilder().setProject(project).setBuild(build).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectLocationBuildName(String project, String location, String build) {
        return BuildName.newProjectLocationBuildBuilder().setProject(project).setLocation(location).setBuild(build).build().toString();
    }

    public static BuildName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_BUILD_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_BUILD_PATH_TEMPLATE.match(formattedString);
            return BuildName.ofProjectBuildName((String)matchMap.get("project"), (String)matchMap.get("build"));
        }
        if (PROJECT_LOCATION_BUILD_PATH_TEMPLATE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_BUILD_PATH_TEMPLATE.match(formattedString);
            return BuildName.ofProjectLocationBuildName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("build"));
        }
        throw new ValidationException("JobName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<BuildName> parseList(List<String> formattedStrings) {
        ArrayList<BuildName> list = new ArrayList<BuildName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BuildName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BuildName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BuildName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_BUILD_PATH_TEMPLATE.matches(formattedString) || PROJECT_LOCATION_BUILD_PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BuildName buildName = this;
            synchronized (buildName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.build != null) {
                        fieldMapBuilder.put((Object)"build", (Object)this.build);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            BuildName that = (BuildName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.build, that.build) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.build);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class ProjectLocationBuildBuilder {
        private String project;
        private String location;
        private String build;

        private ProjectLocationBuildBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getBuild() {
            return this.build;
        }

        public ProjectLocationBuildBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationBuildBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationBuildBuilder setBuild(String build) {
            this.build = build;
            return this;
        }

        public BuildName build() {
            return new BuildName(this);
        }
    }

    public static class Builder {
        private String project;
        private String build;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getBuild() {
            return this.build;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setBuild(String build) {
            this.build = build;
            return this;
        }

        private Builder(BuildName buildName) {
            Preconditions.checkArgument((buildName.pathTemplate == PROJECT_BUILD_PATH_TEMPLATE ? 1 : 0) != 0, (Object)"toBuilder is only supported when BuildName has the pattern of projects/{project}/builds/{build}.");
            this.project = buildName.project;
            this.build = buildName.build;
        }

        public BuildName build() {
            return new BuildName(this);
        }
    }
}

