/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.binaryauthorization.v1beta1;

import com.google.api.core.BetaApi;
import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PolicyName
implements ResourceName {
    private static final PathTemplate PROJECT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/policy");
    private static final PathTemplate LOCATION = PathTemplate.createWithoutUrlEncoding((String)"locations/{location}/policy");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;

    @Deprecated
    protected PolicyName() {
        this.project = null;
        this.location = null;
    }

    private PolicyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = null;
        this.pathTemplate = PROJECT;
    }

    private PolicyName(LocationBuilder builder) {
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.project = null;
        this.pathTemplate = LOCATION;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static LocationBuilder newLocationBuilder() {
        return new LocationBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PolicyName of(String project) {
        return PolicyName.newBuilder().setProject(project).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static PolicyName ofProjectName(String project) {
        return PolicyName.newBuilder().setProject(project).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static PolicyName ofLocationName(String location) {
        return PolicyName.newLocationBuilder().setLocation(location).build();
    }

    public static String format(String project) {
        return PolicyName.newBuilder().setProject(project).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectName(String project) {
        return PolicyName.newBuilder().setProject(project).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatLocationName(String location) {
        return PolicyName.newLocationBuilder().setLocation(location).build().toString();
    }

    public static PolicyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT.matches(formattedString)) {
            Map matchMap = PROJECT.match(formattedString);
            return PolicyName.ofProjectName((String)matchMap.get("project"));
        }
        if (LOCATION.matches(formattedString)) {
            Map matchMap = LOCATION.match(formattedString);
            return PolicyName.ofLocationName((String)matchMap.get("location"));
        }
        throw new ValidationException("PolicyName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<PolicyName> parseList(List<String> formattedStrings) {
        ArrayList<PolicyName> list = new ArrayList<PolicyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PolicyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PolicyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PolicyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT.matches(formattedString) || LOCATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PolicyName policyName = this;
            synchronized (policyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            PolicyName that = (PolicyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class LocationBuilder {
        private String location;

        protected LocationBuilder() {
        }

        public String getLocation() {
            return this.location;
        }

        public LocationBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public PolicyName build() {
            return new PolicyName(this);
        }
    }

    public static class Builder {
        private String project;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder(PolicyName policyName) {
            Preconditions.checkArgument((boolean)Objects.equals(policyName.pathTemplate, PROJECT), (Object)"toBuilder is only supported when PolicyName has the pattern of projects/{project}/policy");
            this.project = policyName.project;
        }

        public PolicyName build() {
            return new PolicyName(this);
        }
    }
}

