/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.binaryauthorization.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PolicyName
implements ResourceName {
    private static final PathTemplate PROJECT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/policy");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;

    @Deprecated
    protected PolicyName() {
        this.project = null;
    }

    private PolicyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
    }

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PolicyName of(String project) {
        return PolicyName.newBuilder().setProject(project).build();
    }

    public static String format(String project) {
        return PolicyName.newBuilder().setProject(project).build().toString();
    }

    public static PolicyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT.validatedMatch(formattedString, "PolicyName.parse: formattedString not in valid format");
        return PolicyName.of((String)matchMap.get("project"));
    }

    public static List<PolicyName> parseList(List<String> formattedStrings) {
        ArrayList<PolicyName> list = new ArrayList<PolicyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PolicyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PolicyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PolicyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PolicyName policyName = this;
            synchronized (policyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT.instantiate(new String[]{"project", this.project});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            PolicyName that = (PolicyName)o;
            return Objects.equals(this.project, that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.project);
    }

    public static class Builder {
        private String project;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder(PolicyName policyName) {
            this.project = policyName.project;
        }

        public PolicyName build() {
            return new PolicyName(this);
        }
    }
}

