/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/v2/data.proto

// Protobuf Java Version: 3.25.8
package com.google.bigtable.v2;

/**
 *
 *
 * <pre>
 * Specifies a particular change to be made to the contents of a row.
 * </pre>
 *
 * Protobuf type {@code google.bigtable.v2.Mutation}
 */
public final class Mutation extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.v2.Mutation)
    MutationOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Mutation.newBuilder() to construct.
  private Mutation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Mutation() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Mutation();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.v2.DataProto.internal_static_google_bigtable_v2_Mutation_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.v2.DataProto
        .internal_static_google_bigtable_v2_Mutation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.v2.Mutation.class, com.google.bigtable.v2.Mutation.Builder.class);
  }

  public interface SetCellOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.v2.Mutation.SetCell)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the family into which new data should be written.
     * Must match `[-_.a-zA-Z0-9]+`
     * </pre>
     *
     * <code>string family_name = 1;</code>
     *
     * @return The familyName.
     */
    java.lang.String getFamilyName();

    /**
     *
     *
     * <pre>
     * The name of the family into which new data should be written.
     * Must match `[-_.a-zA-Z0-9]+`
     * </pre>
     *
     * <code>string family_name = 1;</code>
     *
     * @return The bytes for familyName.
     */
    com.google.protobuf.ByteString getFamilyNameBytes();

    /**
     *
     *
     * <pre>
     * The qualifier of the column into which new data should be written.
     * Can be any byte string, including the empty string.
     * </pre>
     *
     * <code>bytes column_qualifier = 2;</code>
     *
     * @return The columnQualifier.
     */
    com.google.protobuf.ByteString getColumnQualifier();

    /**
     *
     *
     * <pre>
     * The timestamp of the cell into which new data should be written.
     * Use -1 for current Bigtable server time.
     * Otherwise, the client should set this value itself, noting that the
     * default value is a timestamp of zero if the field is left unspecified.
     * Values must match the granularity of the table (e.g. micros, millis).
     * </pre>
     *
     * <code>int64 timestamp_micros = 3;</code>
     *
     * @return The timestampMicros.
     */
    long getTimestampMicros();

    /**
     *
     *
     * <pre>
     * The value to be written into the specified cell.
     * </pre>
     *
     * <code>bytes value = 4;</code>
     *
     * @return The value.
     */
    com.google.protobuf.ByteString getValue();
  }

  /**
   *
   *
   * <pre>
   * A Mutation which sets the value of the specified cell.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.Mutation.SetCell}
   */
  public static final class SetCell extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.v2.Mutation.SetCell)
      SetCellOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use SetCell.newBuilder() to construct.
    private SetCell(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SetCell() {
      familyName_ = "";
      columnQualifier_ = com.google.protobuf.ByteString.EMPTY;
      value_ = com.google.protobuf.ByteString.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SetCell();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.DataProto
          .internal_static_google_bigtable_v2_Mutation_SetCell_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.DataProto
          .internal_static_google_bigtable_v2_Mutation_SetCell_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.Mutation.SetCell.class,
              com.google.bigtable.v2.Mutation.SetCell.Builder.class);
    }

    public static final int FAMILY_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object familyName_ = "";

    /**
     *
     *
     * <pre>
     * The name of the family into which new data should be written.
     * Must match `[-_.a-zA-Z0-9]+`
     * </pre>
     *
     * <code>string family_name = 1;</code>
     *
     * @return The familyName.
     */
    @java.lang.Override
    public java.lang.String getFamilyName() {
      java.lang.Object ref = familyName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        familyName_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the family into which new data should be written.
     * Must match `[-_.a-zA-Z0-9]+`
     * </pre>
     *
     * <code>string family_name = 1;</code>
     *
     * @return The bytes for familyName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFamilyNameBytes() {
      java.lang.Object ref = familyName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        familyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int COLUMN_QUALIFIER_FIELD_NUMBER = 2;
    private com.google.protobuf.ByteString columnQualifier_ = com.google.protobuf.ByteString.EMPTY;

    /**
     *
     *
     * <pre>
     * The qualifier of the column into which new data should be written.
     * Can be any byte string, including the empty string.
     * </pre>
     *
     * <code>bytes column_qualifier = 2;</code>
     *
     * @return The columnQualifier.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getColumnQualifier() {
      return columnQualifier_;
    }

    public static final int TIMESTAMP_MICROS_FIELD_NUMBER = 3;
    private long timestampMicros_ = 0L;

    /**
     *
     *
     * <pre>
     * The timestamp of the cell into which new data should be written.
     * Use -1 for current Bigtable server time.
     * Otherwise, the client should set this value itself, noting that the
     * default value is a timestamp of zero if the field is left unspecified.
     * Values must match the granularity of the table (e.g. micros, millis).
     * </pre>
     *
     * <code>int64 timestamp_micros = 3;</code>
     *
     * @return The timestampMicros.
     */
    @java.lang.Override
    public long getTimestampMicros() {
      return timestampMicros_;
    }

    public static final int VALUE_FIELD_NUMBER = 4;
    private com.google.protobuf.ByteString value_ = com.google.protobuf.ByteString.EMPTY;

    /**
     *
     *
     * <pre>
     * The value to be written into the specified cell.
     * </pre>
     *
     * <code>bytes value = 4;</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getValue() {
      return value_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(familyName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, familyName_);
      }
      if (!columnQualifier_.isEmpty()) {
        output.writeBytes(2, columnQualifier_);
      }
      if (timestampMicros_ != 0L) {
        output.writeInt64(3, timestampMicros_);
      }
      if (!value_.isEmpty()) {
        output.writeBytes(4, value_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(familyName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, familyName_);
      }
      if (!columnQualifier_.isEmpty()) {
        size += com.google.protobuf.CodedOutputStream.computeBytesSize(2, columnQualifier_);
      }
      if (timestampMicros_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, timestampMicros_);
      }
      if (!value_.isEmpty()) {
        size += com.google.protobuf.CodedOutputStream.computeBytesSize(4, value_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.v2.Mutation.SetCell)) {
        return super.equals(obj);
      }
      com.google.bigtable.v2.Mutation.SetCell other = (com.google.bigtable.v2.Mutation.SetCell) obj;

      if (!getFamilyName().equals(other.getFamilyName())) return false;
      if (!getColumnQualifier().equals(other.getColumnQualifier())) return false;
      if (getTimestampMicros() != other.getTimestampMicros()) return false;
      if (!getValue().equals(other.getValue())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + FAMILY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getFamilyName().hashCode();
      hash = (37 * hash) + COLUMN_QUALIFIER_FIELD_NUMBER;
      hash = (53 * hash) + getColumnQualifier().hashCode();
      hash = (37 * hash) + TIMESTAMP_MICROS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTimestampMicros());
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getValue().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.v2.Mutation.SetCell parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.Mutation.SetCell parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.SetCell parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.Mutation.SetCell parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.SetCell parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.Mutation.SetCell parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.SetCell parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.Mutation.SetCell parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.SetCell parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.Mutation.SetCell parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.SetCell parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.Mutation.SetCell parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.v2.Mutation.SetCell prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A Mutation which sets the value of the specified cell.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.v2.Mutation.SetCell}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.v2.Mutation.SetCell)
        com.google.bigtable.v2.Mutation.SetCellOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.v2.DataProto
            .internal_static_google_bigtable_v2_Mutation_SetCell_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.v2.DataProto
            .internal_static_google_bigtable_v2_Mutation_SetCell_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.v2.Mutation.SetCell.class,
                com.google.bigtable.v2.Mutation.SetCell.Builder.class);
      }

      // Construct using com.google.bigtable.v2.Mutation.SetCell.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        familyName_ = "";
        columnQualifier_ = com.google.protobuf.ByteString.EMPTY;
        timestampMicros_ = 0L;
        value_ = com.google.protobuf.ByteString.EMPTY;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.v2.DataProto
            .internal_static_google_bigtable_v2_Mutation_SetCell_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.v2.Mutation.SetCell getDefaultInstanceForType() {
        return com.google.bigtable.v2.Mutation.SetCell.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.v2.Mutation.SetCell build() {
        com.google.bigtable.v2.Mutation.SetCell result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.v2.Mutation.SetCell buildPartial() {
        com.google.bigtable.v2.Mutation.SetCell result =
            new com.google.bigtable.v2.Mutation.SetCell(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.bigtable.v2.Mutation.SetCell result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.familyName_ = familyName_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.columnQualifier_ = columnQualifier_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.timestampMicros_ = timestampMicros_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.value_ = value_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.v2.Mutation.SetCell) {
          return mergeFrom((com.google.bigtable.v2.Mutation.SetCell) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.v2.Mutation.SetCell other) {
        if (other == com.google.bigtable.v2.Mutation.SetCell.getDefaultInstance()) return this;
        if (!other.getFamilyName().isEmpty()) {
          familyName_ = other.familyName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getColumnQualifier() != com.google.protobuf.ByteString.EMPTY) {
          setColumnQualifier(other.getColumnQualifier());
        }
        if (other.getTimestampMicros() != 0L) {
          setTimestampMicros(other.getTimestampMicros());
        }
        if (other.getValue() != com.google.protobuf.ByteString.EMPTY) {
          setValue(other.getValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  familyName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  columnQualifier_ = input.readBytes();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 24:
                {
                  timestampMicros_ = input.readInt64();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 34:
                {
                  value_ = input.readBytes();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object familyName_ = "";

      /**
       *
       *
       * <pre>
       * The name of the family into which new data should be written.
       * Must match `[-_.a-zA-Z0-9]+`
       * </pre>
       *
       * <code>string family_name = 1;</code>
       *
       * @return The familyName.
       */
      public java.lang.String getFamilyName() {
        java.lang.Object ref = familyName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          familyName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The name of the family into which new data should be written.
       * Must match `[-_.a-zA-Z0-9]+`
       * </pre>
       *
       * <code>string family_name = 1;</code>
       *
       * @return The bytes for familyName.
       */
      public com.google.protobuf.ByteString getFamilyNameBytes() {
        java.lang.Object ref = familyName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          familyName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The name of the family into which new data should be written.
       * Must match `[-_.a-zA-Z0-9]+`
       * </pre>
       *
       * <code>string family_name = 1;</code>
       *
       * @param value The familyName to set.
       * @return This builder for chaining.
       */
      public Builder setFamilyName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        familyName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The name of the family into which new data should be written.
       * Must match `[-_.a-zA-Z0-9]+`
       * </pre>
       *
       * <code>string family_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFamilyName() {
        familyName_ = getDefaultInstance().getFamilyName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The name of the family into which new data should be written.
       * Must match `[-_.a-zA-Z0-9]+`
       * </pre>
       *
       * <code>string family_name = 1;</code>
       *
       * @param value The bytes for familyName to set.
       * @return This builder for chaining.
       */
      public Builder setFamilyNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        familyName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString columnQualifier_ =
          com.google.protobuf.ByteString.EMPTY;

      /**
       *
       *
       * <pre>
       * The qualifier of the column into which new data should be written.
       * Can be any byte string, including the empty string.
       * </pre>
       *
       * <code>bytes column_qualifier = 2;</code>
       *
       * @return The columnQualifier.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getColumnQualifier() {
        return columnQualifier_;
      }

      /**
       *
       *
       * <pre>
       * The qualifier of the column into which new data should be written.
       * Can be any byte string, including the empty string.
       * </pre>
       *
       * <code>bytes column_qualifier = 2;</code>
       *
       * @param value The columnQualifier to set.
       * @return This builder for chaining.
       */
      public Builder setColumnQualifier(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        columnQualifier_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The qualifier of the column into which new data should be written.
       * Can be any byte string, including the empty string.
       * </pre>
       *
       * <code>bytes column_qualifier = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearColumnQualifier() {
        bitField0_ = (bitField0_ & ~0x00000002);
        columnQualifier_ = getDefaultInstance().getColumnQualifier();
        onChanged();
        return this;
      }

      private long timestampMicros_;

      /**
       *
       *
       * <pre>
       * The timestamp of the cell into which new data should be written.
       * Use -1 for current Bigtable server time.
       * Otherwise, the client should set this value itself, noting that the
       * default value is a timestamp of zero if the field is left unspecified.
       * Values must match the granularity of the table (e.g. micros, millis).
       * </pre>
       *
       * <code>int64 timestamp_micros = 3;</code>
       *
       * @return The timestampMicros.
       */
      @java.lang.Override
      public long getTimestampMicros() {
        return timestampMicros_;
      }

      /**
       *
       *
       * <pre>
       * The timestamp of the cell into which new data should be written.
       * Use -1 for current Bigtable server time.
       * Otherwise, the client should set this value itself, noting that the
       * default value is a timestamp of zero if the field is left unspecified.
       * Values must match the granularity of the table (e.g. micros, millis).
       * </pre>
       *
       * <code>int64 timestamp_micros = 3;</code>
       *
       * @param value The timestampMicros to set.
       * @return This builder for chaining.
       */
      public Builder setTimestampMicros(long value) {

        timestampMicros_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The timestamp of the cell into which new data should be written.
       * Use -1 for current Bigtable server time.
       * Otherwise, the client should set this value itself, noting that the
       * default value is a timestamp of zero if the field is left unspecified.
       * Values must match the granularity of the table (e.g. micros, millis).
       * </pre>
       *
       * <code>int64 timestamp_micros = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTimestampMicros() {
        bitField0_ = (bitField0_ & ~0x00000004);
        timestampMicros_ = 0L;
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString value_ = com.google.protobuf.ByteString.EMPTY;

      /**
       *
       *
       * <pre>
       * The value to be written into the specified cell.
       * </pre>
       *
       * <code>bytes value = 4;</code>
       *
       * @return The value.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getValue() {
        return value_;
      }

      /**
       *
       *
       * <pre>
       * The value to be written into the specified cell.
       * </pre>
       *
       * <code>bytes value = 4;</code>
       *
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        value_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The value to be written into the specified cell.
       * </pre>
       *
       * <code>bytes value = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValue() {
        bitField0_ = (bitField0_ & ~0x00000008);
        value_ = getDefaultInstance().getValue();
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.v2.Mutation.SetCell)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.v2.Mutation.SetCell)
    private static final com.google.bigtable.v2.Mutation.SetCell DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.v2.Mutation.SetCell();
    }

    public static com.google.bigtable.v2.Mutation.SetCell getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SetCell> PARSER =
        new com.google.protobuf.AbstractParser<SetCell>() {
          @java.lang.Override
          public SetCell parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SetCell> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SetCell> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.v2.Mutation.SetCell getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AddToCellOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.v2.Mutation.AddToCell)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the `Aggregate` family into which new data should be added.
     * This must be a family with a `value_type` of `Aggregate`.
     * Format: `[-_.a-zA-Z0-9]+`
     * </pre>
     *
     * <code>string family_name = 1;</code>
     *
     * @return The familyName.
     */
    java.lang.String getFamilyName();

    /**
     *
     *
     * <pre>
     * The name of the `Aggregate` family into which new data should be added.
     * This must be a family with a `value_type` of `Aggregate`.
     * Format: `[-_.a-zA-Z0-9]+`
     * </pre>
     *
     * <code>string family_name = 1;</code>
     *
     * @return The bytes for familyName.
     */
    com.google.protobuf.ByteString getFamilyNameBytes();

    /**
     *
     *
     * <pre>
     * The qualifier of the column into which new data should be added. This
     * must be a `raw_value`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
     *
     * @return Whether the columnQualifier field is set.
     */
    boolean hasColumnQualifier();

    /**
     *
     *
     * <pre>
     * The qualifier of the column into which new data should be added. This
     * must be a `raw_value`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
     *
     * @return The columnQualifier.
     */
    com.google.bigtable.v2.Value getColumnQualifier();

    /**
     *
     *
     * <pre>
     * The qualifier of the column into which new data should be added. This
     * must be a `raw_value`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
     */
    com.google.bigtable.v2.ValueOrBuilder getColumnQualifierOrBuilder();

    /**
     *
     *
     * <pre>
     * The timestamp of the cell to which new data should be added. This must
     * be a `raw_timestamp_micros` that matches the table's `granularity`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value timestamp = 3;</code>
     *
     * @return Whether the timestamp field is set.
     */
    boolean hasTimestamp();

    /**
     *
     *
     * <pre>
     * The timestamp of the cell to which new data should be added. This must
     * be a `raw_timestamp_micros` that matches the table's `granularity`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value timestamp = 3;</code>
     *
     * @return The timestamp.
     */
    com.google.bigtable.v2.Value getTimestamp();

    /**
     *
     *
     * <pre>
     * The timestamp of the cell to which new data should be added. This must
     * be a `raw_timestamp_micros` that matches the table's `granularity`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value timestamp = 3;</code>
     */
    com.google.bigtable.v2.ValueOrBuilder getTimestampOrBuilder();

    /**
     *
     *
     * <pre>
     * The input value to be accumulated into the specified cell. This must be
     * compatible with the family's `value_type.input_type`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value input = 4;</code>
     *
     * @return Whether the input field is set.
     */
    boolean hasInput();

    /**
     *
     *
     * <pre>
     * The input value to be accumulated into the specified cell. This must be
     * compatible with the family's `value_type.input_type`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value input = 4;</code>
     *
     * @return The input.
     */
    com.google.bigtable.v2.Value getInput();

    /**
     *
     *
     * <pre>
     * The input value to be accumulated into the specified cell. This must be
     * compatible with the family's `value_type.input_type`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value input = 4;</code>
     */
    com.google.bigtable.v2.ValueOrBuilder getInputOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * A Mutation which incrementally updates a cell in an `Aggregate` family.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.Mutation.AddToCell}
   */
  public static final class AddToCell extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.v2.Mutation.AddToCell)
      AddToCellOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use AddToCell.newBuilder() to construct.
    private AddToCell(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AddToCell() {
      familyName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AddToCell();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.DataProto
          .internal_static_google_bigtable_v2_Mutation_AddToCell_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.DataProto
          .internal_static_google_bigtable_v2_Mutation_AddToCell_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.Mutation.AddToCell.class,
              com.google.bigtable.v2.Mutation.AddToCell.Builder.class);
    }

    private int bitField0_;
    public static final int FAMILY_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object familyName_ = "";

    /**
     *
     *
     * <pre>
     * The name of the `Aggregate` family into which new data should be added.
     * This must be a family with a `value_type` of `Aggregate`.
     * Format: `[-_.a-zA-Z0-9]+`
     * </pre>
     *
     * <code>string family_name = 1;</code>
     *
     * @return The familyName.
     */
    @java.lang.Override
    public java.lang.String getFamilyName() {
      java.lang.Object ref = familyName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        familyName_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the `Aggregate` family into which new data should be added.
     * This must be a family with a `value_type` of `Aggregate`.
     * Format: `[-_.a-zA-Z0-9]+`
     * </pre>
     *
     * <code>string family_name = 1;</code>
     *
     * @return The bytes for familyName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFamilyNameBytes() {
      java.lang.Object ref = familyName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        familyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int COLUMN_QUALIFIER_FIELD_NUMBER = 2;
    private com.google.bigtable.v2.Value columnQualifier_;

    /**
     *
     *
     * <pre>
     * The qualifier of the column into which new data should be added. This
     * must be a `raw_value`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
     *
     * @return Whether the columnQualifier field is set.
     */
    @java.lang.Override
    public boolean hasColumnQualifier() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The qualifier of the column into which new data should be added. This
     * must be a `raw_value`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
     *
     * @return The columnQualifier.
     */
    @java.lang.Override
    public com.google.bigtable.v2.Value getColumnQualifier() {
      return columnQualifier_ == null
          ? com.google.bigtable.v2.Value.getDefaultInstance()
          : columnQualifier_;
    }

    /**
     *
     *
     * <pre>
     * The qualifier of the column into which new data should be added. This
     * must be a `raw_value`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.ValueOrBuilder getColumnQualifierOrBuilder() {
      return columnQualifier_ == null
          ? com.google.bigtable.v2.Value.getDefaultInstance()
          : columnQualifier_;
    }

    public static final int TIMESTAMP_FIELD_NUMBER = 3;
    private com.google.bigtable.v2.Value timestamp_;

    /**
     *
     *
     * <pre>
     * The timestamp of the cell to which new data should be added. This must
     * be a `raw_timestamp_micros` that matches the table's `granularity`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value timestamp = 3;</code>
     *
     * @return Whether the timestamp field is set.
     */
    @java.lang.Override
    public boolean hasTimestamp() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * The timestamp of the cell to which new data should be added. This must
     * be a `raw_timestamp_micros` that matches the table's `granularity`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value timestamp = 3;</code>
     *
     * @return The timestamp.
     */
    @java.lang.Override
    public com.google.bigtable.v2.Value getTimestamp() {
      return timestamp_ == null ? com.google.bigtable.v2.Value.getDefaultInstance() : timestamp_;
    }

    /**
     *
     *
     * <pre>
     * The timestamp of the cell to which new data should be added. This must
     * be a `raw_timestamp_micros` that matches the table's `granularity`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value timestamp = 3;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.ValueOrBuilder getTimestampOrBuilder() {
      return timestamp_ == null ? com.google.bigtable.v2.Value.getDefaultInstance() : timestamp_;
    }

    public static final int INPUT_FIELD_NUMBER = 4;
    private com.google.bigtable.v2.Value input_;

    /**
     *
     *
     * <pre>
     * The input value to be accumulated into the specified cell. This must be
     * compatible with the family's `value_type.input_type`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value input = 4;</code>
     *
     * @return Whether the input field is set.
     */
    @java.lang.Override
    public boolean hasInput() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * The input value to be accumulated into the specified cell. This must be
     * compatible with the family's `value_type.input_type`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value input = 4;</code>
     *
     * @return The input.
     */
    @java.lang.Override
    public com.google.bigtable.v2.Value getInput() {
      return input_ == null ? com.google.bigtable.v2.Value.getDefaultInstance() : input_;
    }

    /**
     *
     *
     * <pre>
     * The input value to be accumulated into the specified cell. This must be
     * compatible with the family's `value_type.input_type`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value input = 4;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.ValueOrBuilder getInputOrBuilder() {
      return input_ == null ? com.google.bigtable.v2.Value.getDefaultInstance() : input_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(familyName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, familyName_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getColumnQualifier());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(3, getTimestamp());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(4, getInput());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(familyName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, familyName_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getColumnQualifier());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTimestamp());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getInput());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.v2.Mutation.AddToCell)) {
        return super.equals(obj);
      }
      com.google.bigtable.v2.Mutation.AddToCell other =
          (com.google.bigtable.v2.Mutation.AddToCell) obj;

      if (!getFamilyName().equals(other.getFamilyName())) return false;
      if (hasColumnQualifier() != other.hasColumnQualifier()) return false;
      if (hasColumnQualifier()) {
        if (!getColumnQualifier().equals(other.getColumnQualifier())) return false;
      }
      if (hasTimestamp() != other.hasTimestamp()) return false;
      if (hasTimestamp()) {
        if (!getTimestamp().equals(other.getTimestamp())) return false;
      }
      if (hasInput() != other.hasInput()) return false;
      if (hasInput()) {
        if (!getInput().equals(other.getInput())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + FAMILY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getFamilyName().hashCode();
      if (hasColumnQualifier()) {
        hash = (37 * hash) + COLUMN_QUALIFIER_FIELD_NUMBER;
        hash = (53 * hash) + getColumnQualifier().hashCode();
      }
      if (hasTimestamp()) {
        hash = (37 * hash) + TIMESTAMP_FIELD_NUMBER;
        hash = (53 * hash) + getTimestamp().hashCode();
      }
      if (hasInput()) {
        hash = (37 * hash) + INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getInput().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.v2.Mutation.AddToCell parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.Mutation.AddToCell parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.AddToCell parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.Mutation.AddToCell parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.AddToCell parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.Mutation.AddToCell parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.AddToCell parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.Mutation.AddToCell parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.AddToCell parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.Mutation.AddToCell parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.AddToCell parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.Mutation.AddToCell parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.v2.Mutation.AddToCell prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A Mutation which incrementally updates a cell in an `Aggregate` family.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.v2.Mutation.AddToCell}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.v2.Mutation.AddToCell)
        com.google.bigtable.v2.Mutation.AddToCellOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.v2.DataProto
            .internal_static_google_bigtable_v2_Mutation_AddToCell_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.v2.DataProto
            .internal_static_google_bigtable_v2_Mutation_AddToCell_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.v2.Mutation.AddToCell.class,
                com.google.bigtable.v2.Mutation.AddToCell.Builder.class);
      }

      // Construct using com.google.bigtable.v2.Mutation.AddToCell.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getColumnQualifierFieldBuilder();
          getTimestampFieldBuilder();
          getInputFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        familyName_ = "";
        columnQualifier_ = null;
        if (columnQualifierBuilder_ != null) {
          columnQualifierBuilder_.dispose();
          columnQualifierBuilder_ = null;
        }
        timestamp_ = null;
        if (timestampBuilder_ != null) {
          timestampBuilder_.dispose();
          timestampBuilder_ = null;
        }
        input_ = null;
        if (inputBuilder_ != null) {
          inputBuilder_.dispose();
          inputBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.v2.DataProto
            .internal_static_google_bigtable_v2_Mutation_AddToCell_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.v2.Mutation.AddToCell getDefaultInstanceForType() {
        return com.google.bigtable.v2.Mutation.AddToCell.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.v2.Mutation.AddToCell build() {
        com.google.bigtable.v2.Mutation.AddToCell result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.v2.Mutation.AddToCell buildPartial() {
        com.google.bigtable.v2.Mutation.AddToCell result =
            new com.google.bigtable.v2.Mutation.AddToCell(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.bigtable.v2.Mutation.AddToCell result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.familyName_ = familyName_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.columnQualifier_ =
              columnQualifierBuilder_ == null ? columnQualifier_ : columnQualifierBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.timestamp_ = timestampBuilder_ == null ? timestamp_ : timestampBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.input_ = inputBuilder_ == null ? input_ : inputBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.v2.Mutation.AddToCell) {
          return mergeFrom((com.google.bigtable.v2.Mutation.AddToCell) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.v2.Mutation.AddToCell other) {
        if (other == com.google.bigtable.v2.Mutation.AddToCell.getDefaultInstance()) return this;
        if (!other.getFamilyName().isEmpty()) {
          familyName_ = other.familyName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasColumnQualifier()) {
          mergeColumnQualifier(other.getColumnQualifier());
        }
        if (other.hasTimestamp()) {
          mergeTimestamp(other.getTimestamp());
        }
        if (other.hasInput()) {
          mergeInput(other.getInput());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  familyName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getColumnQualifierFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getTimestampFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getInputFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object familyName_ = "";

      /**
       *
       *
       * <pre>
       * The name of the `Aggregate` family into which new data should be added.
       * This must be a family with a `value_type` of `Aggregate`.
       * Format: `[-_.a-zA-Z0-9]+`
       * </pre>
       *
       * <code>string family_name = 1;</code>
       *
       * @return The familyName.
       */
      public java.lang.String getFamilyName() {
        java.lang.Object ref = familyName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          familyName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The name of the `Aggregate` family into which new data should be added.
       * This must be a family with a `value_type` of `Aggregate`.
       * Format: `[-_.a-zA-Z0-9]+`
       * </pre>
       *
       * <code>string family_name = 1;</code>
       *
       * @return The bytes for familyName.
       */
      public com.google.protobuf.ByteString getFamilyNameBytes() {
        java.lang.Object ref = familyName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          familyName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The name of the `Aggregate` family into which new data should be added.
       * This must be a family with a `value_type` of `Aggregate`.
       * Format: `[-_.a-zA-Z0-9]+`
       * </pre>
       *
       * <code>string family_name = 1;</code>
       *
       * @param value The familyName to set.
       * @return This builder for chaining.
       */
      public Builder setFamilyName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        familyName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The name of the `Aggregate` family into which new data should be added.
       * This must be a family with a `value_type` of `Aggregate`.
       * Format: `[-_.a-zA-Z0-9]+`
       * </pre>
       *
       * <code>string family_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFamilyName() {
        familyName_ = getDefaultInstance().getFamilyName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The name of the `Aggregate` family into which new data should be added.
       * This must be a family with a `value_type` of `Aggregate`.
       * Format: `[-_.a-zA-Z0-9]+`
       * </pre>
       *
       * <code>string family_name = 1;</code>
       *
       * @param value The bytes for familyName to set.
       * @return This builder for chaining.
       */
      public Builder setFamilyNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        familyName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.bigtable.v2.Value columnQualifier_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.v2.Value,
              com.google.bigtable.v2.Value.Builder,
              com.google.bigtable.v2.ValueOrBuilder>
          columnQualifierBuilder_;

      /**
       *
       *
       * <pre>
       * The qualifier of the column into which new data should be added. This
       * must be a `raw_value`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
       *
       * @return Whether the columnQualifier field is set.
       */
      public boolean hasColumnQualifier() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * The qualifier of the column into which new data should be added. This
       * must be a `raw_value`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
       *
       * @return The columnQualifier.
       */
      public com.google.bigtable.v2.Value getColumnQualifier() {
        if (columnQualifierBuilder_ == null) {
          return columnQualifier_ == null
              ? com.google.bigtable.v2.Value.getDefaultInstance()
              : columnQualifier_;
        } else {
          return columnQualifierBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The qualifier of the column into which new data should be added. This
       * must be a `raw_value`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
       */
      public Builder setColumnQualifier(com.google.bigtable.v2.Value value) {
        if (columnQualifierBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          columnQualifier_ = value;
        } else {
          columnQualifierBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The qualifier of the column into which new data should be added. This
       * must be a `raw_value`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
       */
      public Builder setColumnQualifier(com.google.bigtable.v2.Value.Builder builderForValue) {
        if (columnQualifierBuilder_ == null) {
          columnQualifier_ = builderForValue.build();
        } else {
          columnQualifierBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The qualifier of the column into which new data should be added. This
       * must be a `raw_value`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
       */
      public Builder mergeColumnQualifier(com.google.bigtable.v2.Value value) {
        if (columnQualifierBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && columnQualifier_ != null
              && columnQualifier_ != com.google.bigtable.v2.Value.getDefaultInstance()) {
            getColumnQualifierBuilder().mergeFrom(value);
          } else {
            columnQualifier_ = value;
          }
        } else {
          columnQualifierBuilder_.mergeFrom(value);
        }
        if (columnQualifier_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The qualifier of the column into which new data should be added. This
       * must be a `raw_value`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
       */
      public Builder clearColumnQualifier() {
        bitField0_ = (bitField0_ & ~0x00000002);
        columnQualifier_ = null;
        if (columnQualifierBuilder_ != null) {
          columnQualifierBuilder_.dispose();
          columnQualifierBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The qualifier of the column into which new data should be added. This
       * must be a `raw_value`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
       */
      public com.google.bigtable.v2.Value.Builder getColumnQualifierBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getColumnQualifierFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The qualifier of the column into which new data should be added. This
       * must be a `raw_value`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
       */
      public com.google.bigtable.v2.ValueOrBuilder getColumnQualifierOrBuilder() {
        if (columnQualifierBuilder_ != null) {
          return columnQualifierBuilder_.getMessageOrBuilder();
        } else {
          return columnQualifier_ == null
              ? com.google.bigtable.v2.Value.getDefaultInstance()
              : columnQualifier_;
        }
      }

      /**
       *
       *
       * <pre>
       * The qualifier of the column into which new data should be added. This
       * must be a `raw_value`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.v2.Value,
              com.google.bigtable.v2.Value.Builder,
              com.google.bigtable.v2.ValueOrBuilder>
          getColumnQualifierFieldBuilder() {
        if (columnQualifierBuilder_ == null) {
          columnQualifierBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.bigtable.v2.Value,
                  com.google.bigtable.v2.Value.Builder,
                  com.google.bigtable.v2.ValueOrBuilder>(
                  getColumnQualifier(), getParentForChildren(), isClean());
          columnQualifier_ = null;
        }
        return columnQualifierBuilder_;
      }

      private com.google.bigtable.v2.Value timestamp_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.v2.Value,
              com.google.bigtable.v2.Value.Builder,
              com.google.bigtable.v2.ValueOrBuilder>
          timestampBuilder_;

      /**
       *
       *
       * <pre>
       * The timestamp of the cell to which new data should be added. This must
       * be a `raw_timestamp_micros` that matches the table's `granularity`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value timestamp = 3;</code>
       *
       * @return Whether the timestamp field is set.
       */
      public boolean hasTimestamp() {
        return ((bitField0_ & 0x00000004) != 0);
      }

      /**
       *
       *
       * <pre>
       * The timestamp of the cell to which new data should be added. This must
       * be a `raw_timestamp_micros` that matches the table's `granularity`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value timestamp = 3;</code>
       *
       * @return The timestamp.
       */
      public com.google.bigtable.v2.Value getTimestamp() {
        if (timestampBuilder_ == null) {
          return timestamp_ == null
              ? com.google.bigtable.v2.Value.getDefaultInstance()
              : timestamp_;
        } else {
          return timestampBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The timestamp of the cell to which new data should be added. This must
       * be a `raw_timestamp_micros` that matches the table's `granularity`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value timestamp = 3;</code>
       */
      public Builder setTimestamp(com.google.bigtable.v2.Value value) {
        if (timestampBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          timestamp_ = value;
        } else {
          timestampBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The timestamp of the cell to which new data should be added. This must
       * be a `raw_timestamp_micros` that matches the table's `granularity`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value timestamp = 3;</code>
       */
      public Builder setTimestamp(com.google.bigtable.v2.Value.Builder builderForValue) {
        if (timestampBuilder_ == null) {
          timestamp_ = builderForValue.build();
        } else {
          timestampBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The timestamp of the cell to which new data should be added. This must
       * be a `raw_timestamp_micros` that matches the table's `granularity`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value timestamp = 3;</code>
       */
      public Builder mergeTimestamp(com.google.bigtable.v2.Value value) {
        if (timestampBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && timestamp_ != null
              && timestamp_ != com.google.bigtable.v2.Value.getDefaultInstance()) {
            getTimestampBuilder().mergeFrom(value);
          } else {
            timestamp_ = value;
          }
        } else {
          timestampBuilder_.mergeFrom(value);
        }
        if (timestamp_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The timestamp of the cell to which new data should be added. This must
       * be a `raw_timestamp_micros` that matches the table's `granularity`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value timestamp = 3;</code>
       */
      public Builder clearTimestamp() {
        bitField0_ = (bitField0_ & ~0x00000004);
        timestamp_ = null;
        if (timestampBuilder_ != null) {
          timestampBuilder_.dispose();
          timestampBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The timestamp of the cell to which new data should be added. This must
       * be a `raw_timestamp_micros` that matches the table's `granularity`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value timestamp = 3;</code>
       */
      public com.google.bigtable.v2.Value.Builder getTimestampBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getTimestampFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The timestamp of the cell to which new data should be added. This must
       * be a `raw_timestamp_micros` that matches the table's `granularity`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value timestamp = 3;</code>
       */
      public com.google.bigtable.v2.ValueOrBuilder getTimestampOrBuilder() {
        if (timestampBuilder_ != null) {
          return timestampBuilder_.getMessageOrBuilder();
        } else {
          return timestamp_ == null
              ? com.google.bigtable.v2.Value.getDefaultInstance()
              : timestamp_;
        }
      }

      /**
       *
       *
       * <pre>
       * The timestamp of the cell to which new data should be added. This must
       * be a `raw_timestamp_micros` that matches the table's `granularity`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value timestamp = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.v2.Value,
              com.google.bigtable.v2.Value.Builder,
              com.google.bigtable.v2.ValueOrBuilder>
          getTimestampFieldBuilder() {
        if (timestampBuilder_ == null) {
          timestampBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.bigtable.v2.Value,
                  com.google.bigtable.v2.Value.Builder,
                  com.google.bigtable.v2.ValueOrBuilder>(
                  getTimestamp(), getParentForChildren(), isClean());
          timestamp_ = null;
        }
        return timestampBuilder_;
      }

      private com.google.bigtable.v2.Value input_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.v2.Value,
              com.google.bigtable.v2.Value.Builder,
              com.google.bigtable.v2.ValueOrBuilder>
          inputBuilder_;

      /**
       *
       *
       * <pre>
       * The input value to be accumulated into the specified cell. This must be
       * compatible with the family's `value_type.input_type`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value input = 4;</code>
       *
       * @return Whether the input field is set.
       */
      public boolean hasInput() {
        return ((bitField0_ & 0x00000008) != 0);
      }

      /**
       *
       *
       * <pre>
       * The input value to be accumulated into the specified cell. This must be
       * compatible with the family's `value_type.input_type`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value input = 4;</code>
       *
       * @return The input.
       */
      public com.google.bigtable.v2.Value getInput() {
        if (inputBuilder_ == null) {
          return input_ == null ? com.google.bigtable.v2.Value.getDefaultInstance() : input_;
        } else {
          return inputBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The input value to be accumulated into the specified cell. This must be
       * compatible with the family's `value_type.input_type`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value input = 4;</code>
       */
      public Builder setInput(com.google.bigtable.v2.Value value) {
        if (inputBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          input_ = value;
        } else {
          inputBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The input value to be accumulated into the specified cell. This must be
       * compatible with the family's `value_type.input_type`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value input = 4;</code>
       */
      public Builder setInput(com.google.bigtable.v2.Value.Builder builderForValue) {
        if (inputBuilder_ == null) {
          input_ = builderForValue.build();
        } else {
          inputBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The input value to be accumulated into the specified cell. This must be
       * compatible with the family's `value_type.input_type`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value input = 4;</code>
       */
      public Builder mergeInput(com.google.bigtable.v2.Value value) {
        if (inputBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && input_ != null
              && input_ != com.google.bigtable.v2.Value.getDefaultInstance()) {
            getInputBuilder().mergeFrom(value);
          } else {
            input_ = value;
          }
        } else {
          inputBuilder_.mergeFrom(value);
        }
        if (input_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The input value to be accumulated into the specified cell. This must be
       * compatible with the family's `value_type.input_type`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value input = 4;</code>
       */
      public Builder clearInput() {
        bitField0_ = (bitField0_ & ~0x00000008);
        input_ = null;
        if (inputBuilder_ != null) {
          inputBuilder_.dispose();
          inputBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The input value to be accumulated into the specified cell. This must be
       * compatible with the family's `value_type.input_type`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value input = 4;</code>
       */
      public com.google.bigtable.v2.Value.Builder getInputBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getInputFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The input value to be accumulated into the specified cell. This must be
       * compatible with the family's `value_type.input_type`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value input = 4;</code>
       */
      public com.google.bigtable.v2.ValueOrBuilder getInputOrBuilder() {
        if (inputBuilder_ != null) {
          return inputBuilder_.getMessageOrBuilder();
        } else {
          return input_ == null ? com.google.bigtable.v2.Value.getDefaultInstance() : input_;
        }
      }

      /**
       *
       *
       * <pre>
       * The input value to be accumulated into the specified cell. This must be
       * compatible with the family's `value_type.input_type`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value input = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.v2.Value,
              com.google.bigtable.v2.Value.Builder,
              com.google.bigtable.v2.ValueOrBuilder>
          getInputFieldBuilder() {
        if (inputBuilder_ == null) {
          inputBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.bigtable.v2.Value,
                  com.google.bigtable.v2.Value.Builder,
                  com.google.bigtable.v2.ValueOrBuilder>(
                  getInput(), getParentForChildren(), isClean());
          input_ = null;
        }
        return inputBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.v2.Mutation.AddToCell)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.v2.Mutation.AddToCell)
    private static final com.google.bigtable.v2.Mutation.AddToCell DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.v2.Mutation.AddToCell();
    }

    public static com.google.bigtable.v2.Mutation.AddToCell getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AddToCell> PARSER =
        new com.google.protobuf.AbstractParser<AddToCell>() {
          @java.lang.Override
          public AddToCell parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AddToCell> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AddToCell> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.v2.Mutation.AddToCell getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface MergeToCellOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.v2.Mutation.MergeToCell)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the `Aggregate` family into which new data should be added.
     * This must be a family with a `value_type` of `Aggregate`.
     * Format: `[-_.a-zA-Z0-9]+`
     * </pre>
     *
     * <code>string family_name = 1;</code>
     *
     * @return The familyName.
     */
    java.lang.String getFamilyName();

    /**
     *
     *
     * <pre>
     * The name of the `Aggregate` family into which new data should be added.
     * This must be a family with a `value_type` of `Aggregate`.
     * Format: `[-_.a-zA-Z0-9]+`
     * </pre>
     *
     * <code>string family_name = 1;</code>
     *
     * @return The bytes for familyName.
     */
    com.google.protobuf.ByteString getFamilyNameBytes();

    /**
     *
     *
     * <pre>
     * The qualifier of the column into which new data should be added. This
     * must be a `raw_value`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
     *
     * @return Whether the columnQualifier field is set.
     */
    boolean hasColumnQualifier();

    /**
     *
     *
     * <pre>
     * The qualifier of the column into which new data should be added. This
     * must be a `raw_value`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
     *
     * @return The columnQualifier.
     */
    com.google.bigtable.v2.Value getColumnQualifier();

    /**
     *
     *
     * <pre>
     * The qualifier of the column into which new data should be added. This
     * must be a `raw_value`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
     */
    com.google.bigtable.v2.ValueOrBuilder getColumnQualifierOrBuilder();

    /**
     *
     *
     * <pre>
     * The timestamp of the cell to which new data should be added. This must
     * be a `raw_timestamp_micros` that matches the table's `granularity`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value timestamp = 3;</code>
     *
     * @return Whether the timestamp field is set.
     */
    boolean hasTimestamp();

    /**
     *
     *
     * <pre>
     * The timestamp of the cell to which new data should be added. This must
     * be a `raw_timestamp_micros` that matches the table's `granularity`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value timestamp = 3;</code>
     *
     * @return The timestamp.
     */
    com.google.bigtable.v2.Value getTimestamp();

    /**
     *
     *
     * <pre>
     * The timestamp of the cell to which new data should be added. This must
     * be a `raw_timestamp_micros` that matches the table's `granularity`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value timestamp = 3;</code>
     */
    com.google.bigtable.v2.ValueOrBuilder getTimestampOrBuilder();

    /**
     *
     *
     * <pre>
     * The input value to be merged into the specified cell. This must be
     * compatible with the family's `value_type.state_type`. Merging `NULL` is
     * allowed, but has no effect.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value input = 4;</code>
     *
     * @return Whether the input field is set.
     */
    boolean hasInput();

    /**
     *
     *
     * <pre>
     * The input value to be merged into the specified cell. This must be
     * compatible with the family's `value_type.state_type`. Merging `NULL` is
     * allowed, but has no effect.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value input = 4;</code>
     *
     * @return The input.
     */
    com.google.bigtable.v2.Value getInput();

    /**
     *
     *
     * <pre>
     * The input value to be merged into the specified cell. This must be
     * compatible with the family's `value_type.state_type`. Merging `NULL` is
     * allowed, but has no effect.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value input = 4;</code>
     */
    com.google.bigtable.v2.ValueOrBuilder getInputOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * A Mutation which merges accumulated state into a cell in an `Aggregate`
   * family.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.Mutation.MergeToCell}
   */
  public static final class MergeToCell extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.v2.Mutation.MergeToCell)
      MergeToCellOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use MergeToCell.newBuilder() to construct.
    private MergeToCell(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MergeToCell() {
      familyName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MergeToCell();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.DataProto
          .internal_static_google_bigtable_v2_Mutation_MergeToCell_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.DataProto
          .internal_static_google_bigtable_v2_Mutation_MergeToCell_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.Mutation.MergeToCell.class,
              com.google.bigtable.v2.Mutation.MergeToCell.Builder.class);
    }

    private int bitField0_;
    public static final int FAMILY_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object familyName_ = "";

    /**
     *
     *
     * <pre>
     * The name of the `Aggregate` family into which new data should be added.
     * This must be a family with a `value_type` of `Aggregate`.
     * Format: `[-_.a-zA-Z0-9]+`
     * </pre>
     *
     * <code>string family_name = 1;</code>
     *
     * @return The familyName.
     */
    @java.lang.Override
    public java.lang.String getFamilyName() {
      java.lang.Object ref = familyName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        familyName_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the `Aggregate` family into which new data should be added.
     * This must be a family with a `value_type` of `Aggregate`.
     * Format: `[-_.a-zA-Z0-9]+`
     * </pre>
     *
     * <code>string family_name = 1;</code>
     *
     * @return The bytes for familyName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFamilyNameBytes() {
      java.lang.Object ref = familyName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        familyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int COLUMN_QUALIFIER_FIELD_NUMBER = 2;
    private com.google.bigtable.v2.Value columnQualifier_;

    /**
     *
     *
     * <pre>
     * The qualifier of the column into which new data should be added. This
     * must be a `raw_value`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
     *
     * @return Whether the columnQualifier field is set.
     */
    @java.lang.Override
    public boolean hasColumnQualifier() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The qualifier of the column into which new data should be added. This
     * must be a `raw_value`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
     *
     * @return The columnQualifier.
     */
    @java.lang.Override
    public com.google.bigtable.v2.Value getColumnQualifier() {
      return columnQualifier_ == null
          ? com.google.bigtable.v2.Value.getDefaultInstance()
          : columnQualifier_;
    }

    /**
     *
     *
     * <pre>
     * The qualifier of the column into which new data should be added. This
     * must be a `raw_value`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.ValueOrBuilder getColumnQualifierOrBuilder() {
      return columnQualifier_ == null
          ? com.google.bigtable.v2.Value.getDefaultInstance()
          : columnQualifier_;
    }

    public static final int TIMESTAMP_FIELD_NUMBER = 3;
    private com.google.bigtable.v2.Value timestamp_;

    /**
     *
     *
     * <pre>
     * The timestamp of the cell to which new data should be added. This must
     * be a `raw_timestamp_micros` that matches the table's `granularity`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value timestamp = 3;</code>
     *
     * @return Whether the timestamp field is set.
     */
    @java.lang.Override
    public boolean hasTimestamp() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * The timestamp of the cell to which new data should be added. This must
     * be a `raw_timestamp_micros` that matches the table's `granularity`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value timestamp = 3;</code>
     *
     * @return The timestamp.
     */
    @java.lang.Override
    public com.google.bigtable.v2.Value getTimestamp() {
      return timestamp_ == null ? com.google.bigtable.v2.Value.getDefaultInstance() : timestamp_;
    }

    /**
     *
     *
     * <pre>
     * The timestamp of the cell to which new data should be added. This must
     * be a `raw_timestamp_micros` that matches the table's `granularity`.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value timestamp = 3;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.ValueOrBuilder getTimestampOrBuilder() {
      return timestamp_ == null ? com.google.bigtable.v2.Value.getDefaultInstance() : timestamp_;
    }

    public static final int INPUT_FIELD_NUMBER = 4;
    private com.google.bigtable.v2.Value input_;

    /**
     *
     *
     * <pre>
     * The input value to be merged into the specified cell. This must be
     * compatible with the family's `value_type.state_type`. Merging `NULL` is
     * allowed, but has no effect.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value input = 4;</code>
     *
     * @return Whether the input field is set.
     */
    @java.lang.Override
    public boolean hasInput() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * The input value to be merged into the specified cell. This must be
     * compatible with the family's `value_type.state_type`. Merging `NULL` is
     * allowed, but has no effect.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value input = 4;</code>
     *
     * @return The input.
     */
    @java.lang.Override
    public com.google.bigtable.v2.Value getInput() {
      return input_ == null ? com.google.bigtable.v2.Value.getDefaultInstance() : input_;
    }

    /**
     *
     *
     * <pre>
     * The input value to be merged into the specified cell. This must be
     * compatible with the family's `value_type.state_type`. Merging `NULL` is
     * allowed, but has no effect.
     * </pre>
     *
     * <code>.google.bigtable.v2.Value input = 4;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.ValueOrBuilder getInputOrBuilder() {
      return input_ == null ? com.google.bigtable.v2.Value.getDefaultInstance() : input_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(familyName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, familyName_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(2, getColumnQualifier());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(3, getTimestamp());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(4, getInput());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(familyName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, familyName_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getColumnQualifier());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTimestamp());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getInput());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.v2.Mutation.MergeToCell)) {
        return super.equals(obj);
      }
      com.google.bigtable.v2.Mutation.MergeToCell other =
          (com.google.bigtable.v2.Mutation.MergeToCell) obj;

      if (!getFamilyName().equals(other.getFamilyName())) return false;
      if (hasColumnQualifier() != other.hasColumnQualifier()) return false;
      if (hasColumnQualifier()) {
        if (!getColumnQualifier().equals(other.getColumnQualifier())) return false;
      }
      if (hasTimestamp() != other.hasTimestamp()) return false;
      if (hasTimestamp()) {
        if (!getTimestamp().equals(other.getTimestamp())) return false;
      }
      if (hasInput() != other.hasInput()) return false;
      if (hasInput()) {
        if (!getInput().equals(other.getInput())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + FAMILY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getFamilyName().hashCode();
      if (hasColumnQualifier()) {
        hash = (37 * hash) + COLUMN_QUALIFIER_FIELD_NUMBER;
        hash = (53 * hash) + getColumnQualifier().hashCode();
      }
      if (hasTimestamp()) {
        hash = (37 * hash) + TIMESTAMP_FIELD_NUMBER;
        hash = (53 * hash) + getTimestamp().hashCode();
      }
      if (hasInput()) {
        hash = (37 * hash) + INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getInput().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.v2.Mutation.MergeToCell parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.Mutation.MergeToCell parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.MergeToCell parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.Mutation.MergeToCell parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.MergeToCell parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.Mutation.MergeToCell parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.MergeToCell parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.Mutation.MergeToCell parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.MergeToCell parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.Mutation.MergeToCell parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.MergeToCell parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.Mutation.MergeToCell parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.v2.Mutation.MergeToCell prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A Mutation which merges accumulated state into a cell in an `Aggregate`
     * family.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.v2.Mutation.MergeToCell}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.v2.Mutation.MergeToCell)
        com.google.bigtable.v2.Mutation.MergeToCellOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.v2.DataProto
            .internal_static_google_bigtable_v2_Mutation_MergeToCell_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.v2.DataProto
            .internal_static_google_bigtable_v2_Mutation_MergeToCell_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.v2.Mutation.MergeToCell.class,
                com.google.bigtable.v2.Mutation.MergeToCell.Builder.class);
      }

      // Construct using com.google.bigtable.v2.Mutation.MergeToCell.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getColumnQualifierFieldBuilder();
          getTimestampFieldBuilder();
          getInputFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        familyName_ = "";
        columnQualifier_ = null;
        if (columnQualifierBuilder_ != null) {
          columnQualifierBuilder_.dispose();
          columnQualifierBuilder_ = null;
        }
        timestamp_ = null;
        if (timestampBuilder_ != null) {
          timestampBuilder_.dispose();
          timestampBuilder_ = null;
        }
        input_ = null;
        if (inputBuilder_ != null) {
          inputBuilder_.dispose();
          inputBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.v2.DataProto
            .internal_static_google_bigtable_v2_Mutation_MergeToCell_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.v2.Mutation.MergeToCell getDefaultInstanceForType() {
        return com.google.bigtable.v2.Mutation.MergeToCell.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.v2.Mutation.MergeToCell build() {
        com.google.bigtable.v2.Mutation.MergeToCell result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.v2.Mutation.MergeToCell buildPartial() {
        com.google.bigtable.v2.Mutation.MergeToCell result =
            new com.google.bigtable.v2.Mutation.MergeToCell(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.bigtable.v2.Mutation.MergeToCell result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.familyName_ = familyName_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.columnQualifier_ =
              columnQualifierBuilder_ == null ? columnQualifier_ : columnQualifierBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.timestamp_ = timestampBuilder_ == null ? timestamp_ : timestampBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.input_ = inputBuilder_ == null ? input_ : inputBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.v2.Mutation.MergeToCell) {
          return mergeFrom((com.google.bigtable.v2.Mutation.MergeToCell) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.v2.Mutation.MergeToCell other) {
        if (other == com.google.bigtable.v2.Mutation.MergeToCell.getDefaultInstance()) return this;
        if (!other.getFamilyName().isEmpty()) {
          familyName_ = other.familyName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasColumnQualifier()) {
          mergeColumnQualifier(other.getColumnQualifier());
        }
        if (other.hasTimestamp()) {
          mergeTimestamp(other.getTimestamp());
        }
        if (other.hasInput()) {
          mergeInput(other.getInput());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  familyName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getColumnQualifierFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getTimestampFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getInputFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object familyName_ = "";

      /**
       *
       *
       * <pre>
       * The name of the `Aggregate` family into which new data should be added.
       * This must be a family with a `value_type` of `Aggregate`.
       * Format: `[-_.a-zA-Z0-9]+`
       * </pre>
       *
       * <code>string family_name = 1;</code>
       *
       * @return The familyName.
       */
      public java.lang.String getFamilyName() {
        java.lang.Object ref = familyName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          familyName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The name of the `Aggregate` family into which new data should be added.
       * This must be a family with a `value_type` of `Aggregate`.
       * Format: `[-_.a-zA-Z0-9]+`
       * </pre>
       *
       * <code>string family_name = 1;</code>
       *
       * @return The bytes for familyName.
       */
      public com.google.protobuf.ByteString getFamilyNameBytes() {
        java.lang.Object ref = familyName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          familyName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The name of the `Aggregate` family into which new data should be added.
       * This must be a family with a `value_type` of `Aggregate`.
       * Format: `[-_.a-zA-Z0-9]+`
       * </pre>
       *
       * <code>string family_name = 1;</code>
       *
       * @param value The familyName to set.
       * @return This builder for chaining.
       */
      public Builder setFamilyName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        familyName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The name of the `Aggregate` family into which new data should be added.
       * This must be a family with a `value_type` of `Aggregate`.
       * Format: `[-_.a-zA-Z0-9]+`
       * </pre>
       *
       * <code>string family_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFamilyName() {
        familyName_ = getDefaultInstance().getFamilyName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The name of the `Aggregate` family into which new data should be added.
       * This must be a family with a `value_type` of `Aggregate`.
       * Format: `[-_.a-zA-Z0-9]+`
       * </pre>
       *
       * <code>string family_name = 1;</code>
       *
       * @param value The bytes for familyName to set.
       * @return This builder for chaining.
       */
      public Builder setFamilyNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        familyName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.bigtable.v2.Value columnQualifier_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.v2.Value,
              com.google.bigtable.v2.Value.Builder,
              com.google.bigtable.v2.ValueOrBuilder>
          columnQualifierBuilder_;

      /**
       *
       *
       * <pre>
       * The qualifier of the column into which new data should be added. This
       * must be a `raw_value`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
       *
       * @return Whether the columnQualifier field is set.
       */
      public boolean hasColumnQualifier() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * The qualifier of the column into which new data should be added. This
       * must be a `raw_value`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
       *
       * @return The columnQualifier.
       */
      public com.google.bigtable.v2.Value getColumnQualifier() {
        if (columnQualifierBuilder_ == null) {
          return columnQualifier_ == null
              ? com.google.bigtable.v2.Value.getDefaultInstance()
              : columnQualifier_;
        } else {
          return columnQualifierBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The qualifier of the column into which new data should be added. This
       * must be a `raw_value`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
       */
      public Builder setColumnQualifier(com.google.bigtable.v2.Value value) {
        if (columnQualifierBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          columnQualifier_ = value;
        } else {
          columnQualifierBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The qualifier of the column into which new data should be added. This
       * must be a `raw_value`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
       */
      public Builder setColumnQualifier(com.google.bigtable.v2.Value.Builder builderForValue) {
        if (columnQualifierBuilder_ == null) {
          columnQualifier_ = builderForValue.build();
        } else {
          columnQualifierBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The qualifier of the column into which new data should be added. This
       * must be a `raw_value`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
       */
      public Builder mergeColumnQualifier(com.google.bigtable.v2.Value value) {
        if (columnQualifierBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && columnQualifier_ != null
              && columnQualifier_ != com.google.bigtable.v2.Value.getDefaultInstance()) {
            getColumnQualifierBuilder().mergeFrom(value);
          } else {
            columnQualifier_ = value;
          }
        } else {
          columnQualifierBuilder_.mergeFrom(value);
        }
        if (columnQualifier_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The qualifier of the column into which new data should be added. This
       * must be a `raw_value`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
       */
      public Builder clearColumnQualifier() {
        bitField0_ = (bitField0_ & ~0x00000002);
        columnQualifier_ = null;
        if (columnQualifierBuilder_ != null) {
          columnQualifierBuilder_.dispose();
          columnQualifierBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The qualifier of the column into which new data should be added. This
       * must be a `raw_value`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
       */
      public com.google.bigtable.v2.Value.Builder getColumnQualifierBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getColumnQualifierFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The qualifier of the column into which new data should be added. This
       * must be a `raw_value`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
       */
      public com.google.bigtable.v2.ValueOrBuilder getColumnQualifierOrBuilder() {
        if (columnQualifierBuilder_ != null) {
          return columnQualifierBuilder_.getMessageOrBuilder();
        } else {
          return columnQualifier_ == null
              ? com.google.bigtable.v2.Value.getDefaultInstance()
              : columnQualifier_;
        }
      }

      /**
       *
       *
       * <pre>
       * The qualifier of the column into which new data should be added. This
       * must be a `raw_value`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value column_qualifier = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.v2.Value,
              com.google.bigtable.v2.Value.Builder,
              com.google.bigtable.v2.ValueOrBuilder>
          getColumnQualifierFieldBuilder() {
        if (columnQualifierBuilder_ == null) {
          columnQualifierBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.bigtable.v2.Value,
                  com.google.bigtable.v2.Value.Builder,
                  com.google.bigtable.v2.ValueOrBuilder>(
                  getColumnQualifier(), getParentForChildren(), isClean());
          columnQualifier_ = null;
        }
        return columnQualifierBuilder_;
      }

      private com.google.bigtable.v2.Value timestamp_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.v2.Value,
              com.google.bigtable.v2.Value.Builder,
              com.google.bigtable.v2.ValueOrBuilder>
          timestampBuilder_;

      /**
       *
       *
       * <pre>
       * The timestamp of the cell to which new data should be added. This must
       * be a `raw_timestamp_micros` that matches the table's `granularity`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value timestamp = 3;</code>
       *
       * @return Whether the timestamp field is set.
       */
      public boolean hasTimestamp() {
        return ((bitField0_ & 0x00000004) != 0);
      }

      /**
       *
       *
       * <pre>
       * The timestamp of the cell to which new data should be added. This must
       * be a `raw_timestamp_micros` that matches the table's `granularity`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value timestamp = 3;</code>
       *
       * @return The timestamp.
       */
      public com.google.bigtable.v2.Value getTimestamp() {
        if (timestampBuilder_ == null) {
          return timestamp_ == null
              ? com.google.bigtable.v2.Value.getDefaultInstance()
              : timestamp_;
        } else {
          return timestampBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The timestamp of the cell to which new data should be added. This must
       * be a `raw_timestamp_micros` that matches the table's `granularity`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value timestamp = 3;</code>
       */
      public Builder setTimestamp(com.google.bigtable.v2.Value value) {
        if (timestampBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          timestamp_ = value;
        } else {
          timestampBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The timestamp of the cell to which new data should be added. This must
       * be a `raw_timestamp_micros` that matches the table's `granularity`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value timestamp = 3;</code>
       */
      public Builder setTimestamp(com.google.bigtable.v2.Value.Builder builderForValue) {
        if (timestampBuilder_ == null) {
          timestamp_ = builderForValue.build();
        } else {
          timestampBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The timestamp of the cell to which new data should be added. This must
       * be a `raw_timestamp_micros` that matches the table's `granularity`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value timestamp = 3;</code>
       */
      public Builder mergeTimestamp(com.google.bigtable.v2.Value value) {
        if (timestampBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && timestamp_ != null
              && timestamp_ != com.google.bigtable.v2.Value.getDefaultInstance()) {
            getTimestampBuilder().mergeFrom(value);
          } else {
            timestamp_ = value;
          }
        } else {
          timestampBuilder_.mergeFrom(value);
        }
        if (timestamp_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The timestamp of the cell to which new data should be added. This must
       * be a `raw_timestamp_micros` that matches the table's `granularity`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value timestamp = 3;</code>
       */
      public Builder clearTimestamp() {
        bitField0_ = (bitField0_ & ~0x00000004);
        timestamp_ = null;
        if (timestampBuilder_ != null) {
          timestampBuilder_.dispose();
          timestampBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The timestamp of the cell to which new data should be added. This must
       * be a `raw_timestamp_micros` that matches the table's `granularity`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value timestamp = 3;</code>
       */
      public com.google.bigtable.v2.Value.Builder getTimestampBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getTimestampFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The timestamp of the cell to which new data should be added. This must
       * be a `raw_timestamp_micros` that matches the table's `granularity`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value timestamp = 3;</code>
       */
      public com.google.bigtable.v2.ValueOrBuilder getTimestampOrBuilder() {
        if (timestampBuilder_ != null) {
          return timestampBuilder_.getMessageOrBuilder();
        } else {
          return timestamp_ == null
              ? com.google.bigtable.v2.Value.getDefaultInstance()
              : timestamp_;
        }
      }

      /**
       *
       *
       * <pre>
       * The timestamp of the cell to which new data should be added. This must
       * be a `raw_timestamp_micros` that matches the table's `granularity`.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value timestamp = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.v2.Value,
              com.google.bigtable.v2.Value.Builder,
              com.google.bigtable.v2.ValueOrBuilder>
          getTimestampFieldBuilder() {
        if (timestampBuilder_ == null) {
          timestampBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.bigtable.v2.Value,
                  com.google.bigtable.v2.Value.Builder,
                  com.google.bigtable.v2.ValueOrBuilder>(
                  getTimestamp(), getParentForChildren(), isClean());
          timestamp_ = null;
        }
        return timestampBuilder_;
      }

      private com.google.bigtable.v2.Value input_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.v2.Value,
              com.google.bigtable.v2.Value.Builder,
              com.google.bigtable.v2.ValueOrBuilder>
          inputBuilder_;

      /**
       *
       *
       * <pre>
       * The input value to be merged into the specified cell. This must be
       * compatible with the family's `value_type.state_type`. Merging `NULL` is
       * allowed, but has no effect.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value input = 4;</code>
       *
       * @return Whether the input field is set.
       */
      public boolean hasInput() {
        return ((bitField0_ & 0x00000008) != 0);
      }

      /**
       *
       *
       * <pre>
       * The input value to be merged into the specified cell. This must be
       * compatible with the family's `value_type.state_type`. Merging `NULL` is
       * allowed, but has no effect.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value input = 4;</code>
       *
       * @return The input.
       */
      public com.google.bigtable.v2.Value getInput() {
        if (inputBuilder_ == null) {
          return input_ == null ? com.google.bigtable.v2.Value.getDefaultInstance() : input_;
        } else {
          return inputBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The input value to be merged into the specified cell. This must be
       * compatible with the family's `value_type.state_type`. Merging `NULL` is
       * allowed, but has no effect.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value input = 4;</code>
       */
      public Builder setInput(com.google.bigtable.v2.Value value) {
        if (inputBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          input_ = value;
        } else {
          inputBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The input value to be merged into the specified cell. This must be
       * compatible with the family's `value_type.state_type`. Merging `NULL` is
       * allowed, but has no effect.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value input = 4;</code>
       */
      public Builder setInput(com.google.bigtable.v2.Value.Builder builderForValue) {
        if (inputBuilder_ == null) {
          input_ = builderForValue.build();
        } else {
          inputBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The input value to be merged into the specified cell. This must be
       * compatible with the family's `value_type.state_type`. Merging `NULL` is
       * allowed, but has no effect.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value input = 4;</code>
       */
      public Builder mergeInput(com.google.bigtable.v2.Value value) {
        if (inputBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && input_ != null
              && input_ != com.google.bigtable.v2.Value.getDefaultInstance()) {
            getInputBuilder().mergeFrom(value);
          } else {
            input_ = value;
          }
        } else {
          inputBuilder_.mergeFrom(value);
        }
        if (input_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The input value to be merged into the specified cell. This must be
       * compatible with the family's `value_type.state_type`. Merging `NULL` is
       * allowed, but has no effect.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value input = 4;</code>
       */
      public Builder clearInput() {
        bitField0_ = (bitField0_ & ~0x00000008);
        input_ = null;
        if (inputBuilder_ != null) {
          inputBuilder_.dispose();
          inputBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The input value to be merged into the specified cell. This must be
       * compatible with the family's `value_type.state_type`. Merging `NULL` is
       * allowed, but has no effect.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value input = 4;</code>
       */
      public com.google.bigtable.v2.Value.Builder getInputBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getInputFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The input value to be merged into the specified cell. This must be
       * compatible with the family's `value_type.state_type`. Merging `NULL` is
       * allowed, but has no effect.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value input = 4;</code>
       */
      public com.google.bigtable.v2.ValueOrBuilder getInputOrBuilder() {
        if (inputBuilder_ != null) {
          return inputBuilder_.getMessageOrBuilder();
        } else {
          return input_ == null ? com.google.bigtable.v2.Value.getDefaultInstance() : input_;
        }
      }

      /**
       *
       *
       * <pre>
       * The input value to be merged into the specified cell. This must be
       * compatible with the family's `value_type.state_type`. Merging `NULL` is
       * allowed, but has no effect.
       * </pre>
       *
       * <code>.google.bigtable.v2.Value input = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.v2.Value,
              com.google.bigtable.v2.Value.Builder,
              com.google.bigtable.v2.ValueOrBuilder>
          getInputFieldBuilder() {
        if (inputBuilder_ == null) {
          inputBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.bigtable.v2.Value,
                  com.google.bigtable.v2.Value.Builder,
                  com.google.bigtable.v2.ValueOrBuilder>(
                  getInput(), getParentForChildren(), isClean());
          input_ = null;
        }
        return inputBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.v2.Mutation.MergeToCell)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.v2.Mutation.MergeToCell)
    private static final com.google.bigtable.v2.Mutation.MergeToCell DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.v2.Mutation.MergeToCell();
    }

    public static com.google.bigtable.v2.Mutation.MergeToCell getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MergeToCell> PARSER =
        new com.google.protobuf.AbstractParser<MergeToCell>() {
          @java.lang.Override
          public MergeToCell parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MergeToCell> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MergeToCell> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.v2.Mutation.MergeToCell getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeleteFromColumnOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.v2.Mutation.DeleteFromColumn)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the family from which cells should be deleted.
     * Must match `[-_.a-zA-Z0-9]+`
     * </pre>
     *
     * <code>string family_name = 1;</code>
     *
     * @return The familyName.
     */
    java.lang.String getFamilyName();

    /**
     *
     *
     * <pre>
     * The name of the family from which cells should be deleted.
     * Must match `[-_.a-zA-Z0-9]+`
     * </pre>
     *
     * <code>string family_name = 1;</code>
     *
     * @return The bytes for familyName.
     */
    com.google.protobuf.ByteString getFamilyNameBytes();

    /**
     *
     *
     * <pre>
     * The qualifier of the column from which cells should be deleted.
     * Can be any byte string, including the empty string.
     * </pre>
     *
     * <code>bytes column_qualifier = 2;</code>
     *
     * @return The columnQualifier.
     */
    com.google.protobuf.ByteString getColumnQualifier();

    /**
     *
     *
     * <pre>
     * The range of timestamps within which cells should be deleted.
     * </pre>
     *
     * <code>.google.bigtable.v2.TimestampRange time_range = 3;</code>
     *
     * @return Whether the timeRange field is set.
     */
    boolean hasTimeRange();

    /**
     *
     *
     * <pre>
     * The range of timestamps within which cells should be deleted.
     * </pre>
     *
     * <code>.google.bigtable.v2.TimestampRange time_range = 3;</code>
     *
     * @return The timeRange.
     */
    com.google.bigtable.v2.TimestampRange getTimeRange();

    /**
     *
     *
     * <pre>
     * The range of timestamps within which cells should be deleted.
     * </pre>
     *
     * <code>.google.bigtable.v2.TimestampRange time_range = 3;</code>
     */
    com.google.bigtable.v2.TimestampRangeOrBuilder getTimeRangeOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * A Mutation which deletes cells from the specified column, optionally
   * restricting the deletions to a given timestamp range.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.Mutation.DeleteFromColumn}
   */
  public static final class DeleteFromColumn extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.v2.Mutation.DeleteFromColumn)
      DeleteFromColumnOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use DeleteFromColumn.newBuilder() to construct.
    private DeleteFromColumn(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DeleteFromColumn() {
      familyName_ = "";
      columnQualifier_ = com.google.protobuf.ByteString.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DeleteFromColumn();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.DataProto
          .internal_static_google_bigtable_v2_Mutation_DeleteFromColumn_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.DataProto
          .internal_static_google_bigtable_v2_Mutation_DeleteFromColumn_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.Mutation.DeleteFromColumn.class,
              com.google.bigtable.v2.Mutation.DeleteFromColumn.Builder.class);
    }

    private int bitField0_;
    public static final int FAMILY_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object familyName_ = "";

    /**
     *
     *
     * <pre>
     * The name of the family from which cells should be deleted.
     * Must match `[-_.a-zA-Z0-9]+`
     * </pre>
     *
     * <code>string family_name = 1;</code>
     *
     * @return The familyName.
     */
    @java.lang.Override
    public java.lang.String getFamilyName() {
      java.lang.Object ref = familyName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        familyName_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the family from which cells should be deleted.
     * Must match `[-_.a-zA-Z0-9]+`
     * </pre>
     *
     * <code>string family_name = 1;</code>
     *
     * @return The bytes for familyName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFamilyNameBytes() {
      java.lang.Object ref = familyName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        familyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int COLUMN_QUALIFIER_FIELD_NUMBER = 2;
    private com.google.protobuf.ByteString columnQualifier_ = com.google.protobuf.ByteString.EMPTY;

    /**
     *
     *
     * <pre>
     * The qualifier of the column from which cells should be deleted.
     * Can be any byte string, including the empty string.
     * </pre>
     *
     * <code>bytes column_qualifier = 2;</code>
     *
     * @return The columnQualifier.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getColumnQualifier() {
      return columnQualifier_;
    }

    public static final int TIME_RANGE_FIELD_NUMBER = 3;
    private com.google.bigtable.v2.TimestampRange timeRange_;

    /**
     *
     *
     * <pre>
     * The range of timestamps within which cells should be deleted.
     * </pre>
     *
     * <code>.google.bigtable.v2.TimestampRange time_range = 3;</code>
     *
     * @return Whether the timeRange field is set.
     */
    @java.lang.Override
    public boolean hasTimeRange() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The range of timestamps within which cells should be deleted.
     * </pre>
     *
     * <code>.google.bigtable.v2.TimestampRange time_range = 3;</code>
     *
     * @return The timeRange.
     */
    @java.lang.Override
    public com.google.bigtable.v2.TimestampRange getTimeRange() {
      return timeRange_ == null
          ? com.google.bigtable.v2.TimestampRange.getDefaultInstance()
          : timeRange_;
    }

    /**
     *
     *
     * <pre>
     * The range of timestamps within which cells should be deleted.
     * </pre>
     *
     * <code>.google.bigtable.v2.TimestampRange time_range = 3;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.TimestampRangeOrBuilder getTimeRangeOrBuilder() {
      return timeRange_ == null
          ? com.google.bigtable.v2.TimestampRange.getDefaultInstance()
          : timeRange_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(familyName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, familyName_);
      }
      if (!columnQualifier_.isEmpty()) {
        output.writeBytes(2, columnQualifier_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getTimeRange());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(familyName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, familyName_);
      }
      if (!columnQualifier_.isEmpty()) {
        size += com.google.protobuf.CodedOutputStream.computeBytesSize(2, columnQualifier_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTimeRange());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.v2.Mutation.DeleteFromColumn)) {
        return super.equals(obj);
      }
      com.google.bigtable.v2.Mutation.DeleteFromColumn other =
          (com.google.bigtable.v2.Mutation.DeleteFromColumn) obj;

      if (!getFamilyName().equals(other.getFamilyName())) return false;
      if (!getColumnQualifier().equals(other.getColumnQualifier())) return false;
      if (hasTimeRange() != other.hasTimeRange()) return false;
      if (hasTimeRange()) {
        if (!getTimeRange().equals(other.getTimeRange())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + FAMILY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getFamilyName().hashCode();
      hash = (37 * hash) + COLUMN_QUALIFIER_FIELD_NUMBER;
      hash = (53 * hash) + getColumnQualifier().hashCode();
      if (hasTimeRange()) {
        hash = (37 * hash) + TIME_RANGE_FIELD_NUMBER;
        hash = (53 * hash) + getTimeRange().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromColumn parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromColumn parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromColumn parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromColumn parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromColumn parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromColumn parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromColumn parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromColumn parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromColumn parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromColumn parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromColumn parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromColumn parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.v2.Mutation.DeleteFromColumn prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A Mutation which deletes cells from the specified column, optionally
     * restricting the deletions to a given timestamp range.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.v2.Mutation.DeleteFromColumn}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.v2.Mutation.DeleteFromColumn)
        com.google.bigtable.v2.Mutation.DeleteFromColumnOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.v2.DataProto
            .internal_static_google_bigtable_v2_Mutation_DeleteFromColumn_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.v2.DataProto
            .internal_static_google_bigtable_v2_Mutation_DeleteFromColumn_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.v2.Mutation.DeleteFromColumn.class,
                com.google.bigtable.v2.Mutation.DeleteFromColumn.Builder.class);
      }

      // Construct using com.google.bigtable.v2.Mutation.DeleteFromColumn.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getTimeRangeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        familyName_ = "";
        columnQualifier_ = com.google.protobuf.ByteString.EMPTY;
        timeRange_ = null;
        if (timeRangeBuilder_ != null) {
          timeRangeBuilder_.dispose();
          timeRangeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.v2.DataProto
            .internal_static_google_bigtable_v2_Mutation_DeleteFromColumn_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.v2.Mutation.DeleteFromColumn getDefaultInstanceForType() {
        return com.google.bigtable.v2.Mutation.DeleteFromColumn.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.v2.Mutation.DeleteFromColumn build() {
        com.google.bigtable.v2.Mutation.DeleteFromColumn result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.v2.Mutation.DeleteFromColumn buildPartial() {
        com.google.bigtable.v2.Mutation.DeleteFromColumn result =
            new com.google.bigtable.v2.Mutation.DeleteFromColumn(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.bigtable.v2.Mutation.DeleteFromColumn result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.familyName_ = familyName_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.columnQualifier_ = columnQualifier_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.timeRange_ = timeRangeBuilder_ == null ? timeRange_ : timeRangeBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.v2.Mutation.DeleteFromColumn) {
          return mergeFrom((com.google.bigtable.v2.Mutation.DeleteFromColumn) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.v2.Mutation.DeleteFromColumn other) {
        if (other == com.google.bigtable.v2.Mutation.DeleteFromColumn.getDefaultInstance())
          return this;
        if (!other.getFamilyName().isEmpty()) {
          familyName_ = other.familyName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getColumnQualifier() != com.google.protobuf.ByteString.EMPTY) {
          setColumnQualifier(other.getColumnQualifier());
        }
        if (other.hasTimeRange()) {
          mergeTimeRange(other.getTimeRange());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  familyName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  columnQualifier_ = input.readBytes();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getTimeRangeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object familyName_ = "";

      /**
       *
       *
       * <pre>
       * The name of the family from which cells should be deleted.
       * Must match `[-_.a-zA-Z0-9]+`
       * </pre>
       *
       * <code>string family_name = 1;</code>
       *
       * @return The familyName.
       */
      public java.lang.String getFamilyName() {
        java.lang.Object ref = familyName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          familyName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The name of the family from which cells should be deleted.
       * Must match `[-_.a-zA-Z0-9]+`
       * </pre>
       *
       * <code>string family_name = 1;</code>
       *
       * @return The bytes for familyName.
       */
      public com.google.protobuf.ByteString getFamilyNameBytes() {
        java.lang.Object ref = familyName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          familyName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The name of the family from which cells should be deleted.
       * Must match `[-_.a-zA-Z0-9]+`
       * </pre>
       *
       * <code>string family_name = 1;</code>
       *
       * @param value The familyName to set.
       * @return This builder for chaining.
       */
      public Builder setFamilyName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        familyName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The name of the family from which cells should be deleted.
       * Must match `[-_.a-zA-Z0-9]+`
       * </pre>
       *
       * <code>string family_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFamilyName() {
        familyName_ = getDefaultInstance().getFamilyName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The name of the family from which cells should be deleted.
       * Must match `[-_.a-zA-Z0-9]+`
       * </pre>
       *
       * <code>string family_name = 1;</code>
       *
       * @param value The bytes for familyName to set.
       * @return This builder for chaining.
       */
      public Builder setFamilyNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        familyName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString columnQualifier_ =
          com.google.protobuf.ByteString.EMPTY;

      /**
       *
       *
       * <pre>
       * The qualifier of the column from which cells should be deleted.
       * Can be any byte string, including the empty string.
       * </pre>
       *
       * <code>bytes column_qualifier = 2;</code>
       *
       * @return The columnQualifier.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getColumnQualifier() {
        return columnQualifier_;
      }

      /**
       *
       *
       * <pre>
       * The qualifier of the column from which cells should be deleted.
       * Can be any byte string, including the empty string.
       * </pre>
       *
       * <code>bytes column_qualifier = 2;</code>
       *
       * @param value The columnQualifier to set.
       * @return This builder for chaining.
       */
      public Builder setColumnQualifier(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        columnQualifier_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The qualifier of the column from which cells should be deleted.
       * Can be any byte string, including the empty string.
       * </pre>
       *
       * <code>bytes column_qualifier = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearColumnQualifier() {
        bitField0_ = (bitField0_ & ~0x00000002);
        columnQualifier_ = getDefaultInstance().getColumnQualifier();
        onChanged();
        return this;
      }

      private com.google.bigtable.v2.TimestampRange timeRange_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.v2.TimestampRange,
              com.google.bigtable.v2.TimestampRange.Builder,
              com.google.bigtable.v2.TimestampRangeOrBuilder>
          timeRangeBuilder_;

      /**
       *
       *
       * <pre>
       * The range of timestamps within which cells should be deleted.
       * </pre>
       *
       * <code>.google.bigtable.v2.TimestampRange time_range = 3;</code>
       *
       * @return Whether the timeRange field is set.
       */
      public boolean hasTimeRange() {
        return ((bitField0_ & 0x00000004) != 0);
      }

      /**
       *
       *
       * <pre>
       * The range of timestamps within which cells should be deleted.
       * </pre>
       *
       * <code>.google.bigtable.v2.TimestampRange time_range = 3;</code>
       *
       * @return The timeRange.
       */
      public com.google.bigtable.v2.TimestampRange getTimeRange() {
        if (timeRangeBuilder_ == null) {
          return timeRange_ == null
              ? com.google.bigtable.v2.TimestampRange.getDefaultInstance()
              : timeRange_;
        } else {
          return timeRangeBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The range of timestamps within which cells should be deleted.
       * </pre>
       *
       * <code>.google.bigtable.v2.TimestampRange time_range = 3;</code>
       */
      public Builder setTimeRange(com.google.bigtable.v2.TimestampRange value) {
        if (timeRangeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          timeRange_ = value;
        } else {
          timeRangeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The range of timestamps within which cells should be deleted.
       * </pre>
       *
       * <code>.google.bigtable.v2.TimestampRange time_range = 3;</code>
       */
      public Builder setTimeRange(com.google.bigtable.v2.TimestampRange.Builder builderForValue) {
        if (timeRangeBuilder_ == null) {
          timeRange_ = builderForValue.build();
        } else {
          timeRangeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The range of timestamps within which cells should be deleted.
       * </pre>
       *
       * <code>.google.bigtable.v2.TimestampRange time_range = 3;</code>
       */
      public Builder mergeTimeRange(com.google.bigtable.v2.TimestampRange value) {
        if (timeRangeBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && timeRange_ != null
              && timeRange_ != com.google.bigtable.v2.TimestampRange.getDefaultInstance()) {
            getTimeRangeBuilder().mergeFrom(value);
          } else {
            timeRange_ = value;
          }
        } else {
          timeRangeBuilder_.mergeFrom(value);
        }
        if (timeRange_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The range of timestamps within which cells should be deleted.
       * </pre>
       *
       * <code>.google.bigtable.v2.TimestampRange time_range = 3;</code>
       */
      public Builder clearTimeRange() {
        bitField0_ = (bitField0_ & ~0x00000004);
        timeRange_ = null;
        if (timeRangeBuilder_ != null) {
          timeRangeBuilder_.dispose();
          timeRangeBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The range of timestamps within which cells should be deleted.
       * </pre>
       *
       * <code>.google.bigtable.v2.TimestampRange time_range = 3;</code>
       */
      public com.google.bigtable.v2.TimestampRange.Builder getTimeRangeBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getTimeRangeFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The range of timestamps within which cells should be deleted.
       * </pre>
       *
       * <code>.google.bigtable.v2.TimestampRange time_range = 3;</code>
       */
      public com.google.bigtable.v2.TimestampRangeOrBuilder getTimeRangeOrBuilder() {
        if (timeRangeBuilder_ != null) {
          return timeRangeBuilder_.getMessageOrBuilder();
        } else {
          return timeRange_ == null
              ? com.google.bigtable.v2.TimestampRange.getDefaultInstance()
              : timeRange_;
        }
      }

      /**
       *
       *
       * <pre>
       * The range of timestamps within which cells should be deleted.
       * </pre>
       *
       * <code>.google.bigtable.v2.TimestampRange time_range = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.v2.TimestampRange,
              com.google.bigtable.v2.TimestampRange.Builder,
              com.google.bigtable.v2.TimestampRangeOrBuilder>
          getTimeRangeFieldBuilder() {
        if (timeRangeBuilder_ == null) {
          timeRangeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.bigtable.v2.TimestampRange,
                  com.google.bigtable.v2.TimestampRange.Builder,
                  com.google.bigtable.v2.TimestampRangeOrBuilder>(
                  getTimeRange(), getParentForChildren(), isClean());
          timeRange_ = null;
        }
        return timeRangeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.v2.Mutation.DeleteFromColumn)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.v2.Mutation.DeleteFromColumn)
    private static final com.google.bigtable.v2.Mutation.DeleteFromColumn DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.v2.Mutation.DeleteFromColumn();
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromColumn getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DeleteFromColumn> PARSER =
        new com.google.protobuf.AbstractParser<DeleteFromColumn>() {
          @java.lang.Override
          public DeleteFromColumn parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DeleteFromColumn> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeleteFromColumn> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.v2.Mutation.DeleteFromColumn getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeleteFromFamilyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.v2.Mutation.DeleteFromFamily)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The name of the family from which cells should be deleted.
     * Must match `[-_.a-zA-Z0-9]+`
     * </pre>
     *
     * <code>string family_name = 1;</code>
     *
     * @return The familyName.
     */
    java.lang.String getFamilyName();

    /**
     *
     *
     * <pre>
     * The name of the family from which cells should be deleted.
     * Must match `[-_.a-zA-Z0-9]+`
     * </pre>
     *
     * <code>string family_name = 1;</code>
     *
     * @return The bytes for familyName.
     */
    com.google.protobuf.ByteString getFamilyNameBytes();
  }

  /**
   *
   *
   * <pre>
   * A Mutation which deletes all cells from the specified column family.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.Mutation.DeleteFromFamily}
   */
  public static final class DeleteFromFamily extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.v2.Mutation.DeleteFromFamily)
      DeleteFromFamilyOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use DeleteFromFamily.newBuilder() to construct.
    private DeleteFromFamily(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DeleteFromFamily() {
      familyName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DeleteFromFamily();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.DataProto
          .internal_static_google_bigtable_v2_Mutation_DeleteFromFamily_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.DataProto
          .internal_static_google_bigtable_v2_Mutation_DeleteFromFamily_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.Mutation.DeleteFromFamily.class,
              com.google.bigtable.v2.Mutation.DeleteFromFamily.Builder.class);
    }

    public static final int FAMILY_NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object familyName_ = "";

    /**
     *
     *
     * <pre>
     * The name of the family from which cells should be deleted.
     * Must match `[-_.a-zA-Z0-9]+`
     * </pre>
     *
     * <code>string family_name = 1;</code>
     *
     * @return The familyName.
     */
    @java.lang.Override
    public java.lang.String getFamilyName() {
      java.lang.Object ref = familyName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        familyName_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the family from which cells should be deleted.
     * Must match `[-_.a-zA-Z0-9]+`
     * </pre>
     *
     * <code>string family_name = 1;</code>
     *
     * @return The bytes for familyName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFamilyNameBytes() {
      java.lang.Object ref = familyName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        familyName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(familyName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, familyName_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(familyName_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, familyName_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.v2.Mutation.DeleteFromFamily)) {
        return super.equals(obj);
      }
      com.google.bigtable.v2.Mutation.DeleteFromFamily other =
          (com.google.bigtable.v2.Mutation.DeleteFromFamily) obj;

      if (!getFamilyName().equals(other.getFamilyName())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + FAMILY_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getFamilyName().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromFamily parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromFamily parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromFamily parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromFamily parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromFamily parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromFamily parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromFamily parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromFamily parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromFamily parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromFamily parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromFamily parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromFamily parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.v2.Mutation.DeleteFromFamily prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A Mutation which deletes all cells from the specified column family.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.v2.Mutation.DeleteFromFamily}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.v2.Mutation.DeleteFromFamily)
        com.google.bigtable.v2.Mutation.DeleteFromFamilyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.v2.DataProto
            .internal_static_google_bigtable_v2_Mutation_DeleteFromFamily_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.v2.DataProto
            .internal_static_google_bigtable_v2_Mutation_DeleteFromFamily_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.v2.Mutation.DeleteFromFamily.class,
                com.google.bigtable.v2.Mutation.DeleteFromFamily.Builder.class);
      }

      // Construct using com.google.bigtable.v2.Mutation.DeleteFromFamily.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        familyName_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.v2.DataProto
            .internal_static_google_bigtable_v2_Mutation_DeleteFromFamily_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.v2.Mutation.DeleteFromFamily getDefaultInstanceForType() {
        return com.google.bigtable.v2.Mutation.DeleteFromFamily.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.v2.Mutation.DeleteFromFamily build() {
        com.google.bigtable.v2.Mutation.DeleteFromFamily result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.v2.Mutation.DeleteFromFamily buildPartial() {
        com.google.bigtable.v2.Mutation.DeleteFromFamily result =
            new com.google.bigtable.v2.Mutation.DeleteFromFamily(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.bigtable.v2.Mutation.DeleteFromFamily result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.familyName_ = familyName_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.v2.Mutation.DeleteFromFamily) {
          return mergeFrom((com.google.bigtable.v2.Mutation.DeleteFromFamily) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.v2.Mutation.DeleteFromFamily other) {
        if (other == com.google.bigtable.v2.Mutation.DeleteFromFamily.getDefaultInstance())
          return this;
        if (!other.getFamilyName().isEmpty()) {
          familyName_ = other.familyName_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  familyName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object familyName_ = "";

      /**
       *
       *
       * <pre>
       * The name of the family from which cells should be deleted.
       * Must match `[-_.a-zA-Z0-9]+`
       * </pre>
       *
       * <code>string family_name = 1;</code>
       *
       * @return The familyName.
       */
      public java.lang.String getFamilyName() {
        java.lang.Object ref = familyName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          familyName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The name of the family from which cells should be deleted.
       * Must match `[-_.a-zA-Z0-9]+`
       * </pre>
       *
       * <code>string family_name = 1;</code>
       *
       * @return The bytes for familyName.
       */
      public com.google.protobuf.ByteString getFamilyNameBytes() {
        java.lang.Object ref = familyName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          familyName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * The name of the family from which cells should be deleted.
       * Must match `[-_.a-zA-Z0-9]+`
       * </pre>
       *
       * <code>string family_name = 1;</code>
       *
       * @param value The familyName to set.
       * @return This builder for chaining.
       */
      public Builder setFamilyName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        familyName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The name of the family from which cells should be deleted.
       * Must match `[-_.a-zA-Z0-9]+`
       * </pre>
       *
       * <code>string family_name = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFamilyName() {
        familyName_ = getDefaultInstance().getFamilyName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The name of the family from which cells should be deleted.
       * Must match `[-_.a-zA-Z0-9]+`
       * </pre>
       *
       * <code>string family_name = 1;</code>
       *
       * @param value The bytes for familyName to set.
       * @return This builder for chaining.
       */
      public Builder setFamilyNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        familyName_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.v2.Mutation.DeleteFromFamily)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.v2.Mutation.DeleteFromFamily)
    private static final com.google.bigtable.v2.Mutation.DeleteFromFamily DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.v2.Mutation.DeleteFromFamily();
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromFamily getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DeleteFromFamily> PARSER =
        new com.google.protobuf.AbstractParser<DeleteFromFamily>() {
          @java.lang.Override
          public DeleteFromFamily parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DeleteFromFamily> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeleteFromFamily> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.v2.Mutation.DeleteFromFamily getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeleteFromRowOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.v2.Mutation.DeleteFromRow)
      com.google.protobuf.MessageOrBuilder {}

  /**
   *
   *
   * <pre>
   * A Mutation which deletes all cells from the containing row.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.Mutation.DeleteFromRow}
   */
  public static final class DeleteFromRow extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.v2.Mutation.DeleteFromRow)
      DeleteFromRowOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use DeleteFromRow.newBuilder() to construct.
    private DeleteFromRow(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DeleteFromRow() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DeleteFromRow();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.DataProto
          .internal_static_google_bigtable_v2_Mutation_DeleteFromRow_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.DataProto
          .internal_static_google_bigtable_v2_Mutation_DeleteFromRow_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.Mutation.DeleteFromRow.class,
              com.google.bigtable.v2.Mutation.DeleteFromRow.Builder.class);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.v2.Mutation.DeleteFromRow)) {
        return super.equals(obj);
      }
      com.google.bigtable.v2.Mutation.DeleteFromRow other =
          (com.google.bigtable.v2.Mutation.DeleteFromRow) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromRow parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromRow parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromRow parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromRow parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromRow parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromRow parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromRow parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromRow parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromRow parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromRow parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromRow parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromRow parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.v2.Mutation.DeleteFromRow prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A Mutation which deletes all cells from the containing row.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.v2.Mutation.DeleteFromRow}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.v2.Mutation.DeleteFromRow)
        com.google.bigtable.v2.Mutation.DeleteFromRowOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.v2.DataProto
            .internal_static_google_bigtable_v2_Mutation_DeleteFromRow_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.v2.DataProto
            .internal_static_google_bigtable_v2_Mutation_DeleteFromRow_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.v2.Mutation.DeleteFromRow.class,
                com.google.bigtable.v2.Mutation.DeleteFromRow.Builder.class);
      }

      // Construct using com.google.bigtable.v2.Mutation.DeleteFromRow.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.v2.DataProto
            .internal_static_google_bigtable_v2_Mutation_DeleteFromRow_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.v2.Mutation.DeleteFromRow getDefaultInstanceForType() {
        return com.google.bigtable.v2.Mutation.DeleteFromRow.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.v2.Mutation.DeleteFromRow build() {
        com.google.bigtable.v2.Mutation.DeleteFromRow result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.v2.Mutation.DeleteFromRow buildPartial() {
        com.google.bigtable.v2.Mutation.DeleteFromRow result =
            new com.google.bigtable.v2.Mutation.DeleteFromRow(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.v2.Mutation.DeleteFromRow) {
          return mergeFrom((com.google.bigtable.v2.Mutation.DeleteFromRow) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.v2.Mutation.DeleteFromRow other) {
        if (other == com.google.bigtable.v2.Mutation.DeleteFromRow.getDefaultInstance())
          return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.v2.Mutation.DeleteFromRow)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.v2.Mutation.DeleteFromRow)
    private static final com.google.bigtable.v2.Mutation.DeleteFromRow DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.v2.Mutation.DeleteFromRow();
    }

    public static com.google.bigtable.v2.Mutation.DeleteFromRow getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DeleteFromRow> PARSER =
        new com.google.protobuf.AbstractParser<DeleteFromRow>() {
          @java.lang.Override
          public DeleteFromRow parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DeleteFromRow> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeleteFromRow> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.v2.Mutation.DeleteFromRow getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int mutationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object mutation_;

  public enum MutationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SET_CELL(1),
    ADD_TO_CELL(5),
    MERGE_TO_CELL(6),
    DELETE_FROM_COLUMN(2),
    DELETE_FROM_FAMILY(3),
    DELETE_FROM_ROW(4),
    MUTATION_NOT_SET(0);
    private final int value;

    private MutationCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MutationCase valueOf(int value) {
      return forNumber(value);
    }

    public static MutationCase forNumber(int value) {
      switch (value) {
        case 1:
          return SET_CELL;
        case 5:
          return ADD_TO_CELL;
        case 6:
          return MERGE_TO_CELL;
        case 2:
          return DELETE_FROM_COLUMN;
        case 3:
          return DELETE_FROM_FAMILY;
        case 4:
          return DELETE_FROM_ROW;
        case 0:
          return MUTATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public MutationCase getMutationCase() {
    return MutationCase.forNumber(mutationCase_);
  }

  public static final int SET_CELL_FIELD_NUMBER = 1;

  /**
   *
   *
   * <pre>
   * Set a cell's value.
   * </pre>
   *
   * <code>.google.bigtable.v2.Mutation.SetCell set_cell = 1;</code>
   *
   * @return Whether the setCell field is set.
   */
  @java.lang.Override
  public boolean hasSetCell() {
    return mutationCase_ == 1;
  }

  /**
   *
   *
   * <pre>
   * Set a cell's value.
   * </pre>
   *
   * <code>.google.bigtable.v2.Mutation.SetCell set_cell = 1;</code>
   *
   * @return The setCell.
   */
  @java.lang.Override
  public com.google.bigtable.v2.Mutation.SetCell getSetCell() {
    if (mutationCase_ == 1) {
      return (com.google.bigtable.v2.Mutation.SetCell) mutation_;
    }
    return com.google.bigtable.v2.Mutation.SetCell.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Set a cell's value.
   * </pre>
   *
   * <code>.google.bigtable.v2.Mutation.SetCell set_cell = 1;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.Mutation.SetCellOrBuilder getSetCellOrBuilder() {
    if (mutationCase_ == 1) {
      return (com.google.bigtable.v2.Mutation.SetCell) mutation_;
    }
    return com.google.bigtable.v2.Mutation.SetCell.getDefaultInstance();
  }

  public static final int ADD_TO_CELL_FIELD_NUMBER = 5;

  /**
   *
   *
   * <pre>
   * Incrementally updates an `Aggregate` cell.
   * </pre>
   *
   * <code>.google.bigtable.v2.Mutation.AddToCell add_to_cell = 5;</code>
   *
   * @return Whether the addToCell field is set.
   */
  @java.lang.Override
  public boolean hasAddToCell() {
    return mutationCase_ == 5;
  }

  /**
   *
   *
   * <pre>
   * Incrementally updates an `Aggregate` cell.
   * </pre>
   *
   * <code>.google.bigtable.v2.Mutation.AddToCell add_to_cell = 5;</code>
   *
   * @return The addToCell.
   */
  @java.lang.Override
  public com.google.bigtable.v2.Mutation.AddToCell getAddToCell() {
    if (mutationCase_ == 5) {
      return (com.google.bigtable.v2.Mutation.AddToCell) mutation_;
    }
    return com.google.bigtable.v2.Mutation.AddToCell.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Incrementally updates an `Aggregate` cell.
   * </pre>
   *
   * <code>.google.bigtable.v2.Mutation.AddToCell add_to_cell = 5;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.Mutation.AddToCellOrBuilder getAddToCellOrBuilder() {
    if (mutationCase_ == 5) {
      return (com.google.bigtable.v2.Mutation.AddToCell) mutation_;
    }
    return com.google.bigtable.v2.Mutation.AddToCell.getDefaultInstance();
  }

  public static final int MERGE_TO_CELL_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * Merges accumulated state to an `Aggregate` cell.
   * </pre>
   *
   * <code>.google.bigtable.v2.Mutation.MergeToCell merge_to_cell = 6;</code>
   *
   * @return Whether the mergeToCell field is set.
   */
  @java.lang.Override
  public boolean hasMergeToCell() {
    return mutationCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * Merges accumulated state to an `Aggregate` cell.
   * </pre>
   *
   * <code>.google.bigtable.v2.Mutation.MergeToCell merge_to_cell = 6;</code>
   *
   * @return The mergeToCell.
   */
  @java.lang.Override
  public com.google.bigtable.v2.Mutation.MergeToCell getMergeToCell() {
    if (mutationCase_ == 6) {
      return (com.google.bigtable.v2.Mutation.MergeToCell) mutation_;
    }
    return com.google.bigtable.v2.Mutation.MergeToCell.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Merges accumulated state to an `Aggregate` cell.
   * </pre>
   *
   * <code>.google.bigtable.v2.Mutation.MergeToCell merge_to_cell = 6;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.Mutation.MergeToCellOrBuilder getMergeToCellOrBuilder() {
    if (mutationCase_ == 6) {
      return (com.google.bigtable.v2.Mutation.MergeToCell) mutation_;
    }
    return com.google.bigtable.v2.Mutation.MergeToCell.getDefaultInstance();
  }

  public static final int DELETE_FROM_COLUMN_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * Deletes cells from a column.
   * </pre>
   *
   * <code>.google.bigtable.v2.Mutation.DeleteFromColumn delete_from_column = 2;</code>
   *
   * @return Whether the deleteFromColumn field is set.
   */
  @java.lang.Override
  public boolean hasDeleteFromColumn() {
    return mutationCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * Deletes cells from a column.
   * </pre>
   *
   * <code>.google.bigtable.v2.Mutation.DeleteFromColumn delete_from_column = 2;</code>
   *
   * @return The deleteFromColumn.
   */
  @java.lang.Override
  public com.google.bigtable.v2.Mutation.DeleteFromColumn getDeleteFromColumn() {
    if (mutationCase_ == 2) {
      return (com.google.bigtable.v2.Mutation.DeleteFromColumn) mutation_;
    }
    return com.google.bigtable.v2.Mutation.DeleteFromColumn.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Deletes cells from a column.
   * </pre>
   *
   * <code>.google.bigtable.v2.Mutation.DeleteFromColumn delete_from_column = 2;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.Mutation.DeleteFromColumnOrBuilder getDeleteFromColumnOrBuilder() {
    if (mutationCase_ == 2) {
      return (com.google.bigtable.v2.Mutation.DeleteFromColumn) mutation_;
    }
    return com.google.bigtable.v2.Mutation.DeleteFromColumn.getDefaultInstance();
  }

  public static final int DELETE_FROM_FAMILY_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * Deletes cells from a column family.
   * </pre>
   *
   * <code>.google.bigtable.v2.Mutation.DeleteFromFamily delete_from_family = 3;</code>
   *
   * @return Whether the deleteFromFamily field is set.
   */
  @java.lang.Override
  public boolean hasDeleteFromFamily() {
    return mutationCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * Deletes cells from a column family.
   * </pre>
   *
   * <code>.google.bigtable.v2.Mutation.DeleteFromFamily delete_from_family = 3;</code>
   *
   * @return The deleteFromFamily.
   */
  @java.lang.Override
  public com.google.bigtable.v2.Mutation.DeleteFromFamily getDeleteFromFamily() {
    if (mutationCase_ == 3) {
      return (com.google.bigtable.v2.Mutation.DeleteFromFamily) mutation_;
    }
    return com.google.bigtable.v2.Mutation.DeleteFromFamily.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Deletes cells from a column family.
   * </pre>
   *
   * <code>.google.bigtable.v2.Mutation.DeleteFromFamily delete_from_family = 3;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.Mutation.DeleteFromFamilyOrBuilder getDeleteFromFamilyOrBuilder() {
    if (mutationCase_ == 3) {
      return (com.google.bigtable.v2.Mutation.DeleteFromFamily) mutation_;
    }
    return com.google.bigtable.v2.Mutation.DeleteFromFamily.getDefaultInstance();
  }

  public static final int DELETE_FROM_ROW_FIELD_NUMBER = 4;

  /**
   *
   *
   * <pre>
   * Deletes cells from the entire row.
   * </pre>
   *
   * <code>.google.bigtable.v2.Mutation.DeleteFromRow delete_from_row = 4;</code>
   *
   * @return Whether the deleteFromRow field is set.
   */
  @java.lang.Override
  public boolean hasDeleteFromRow() {
    return mutationCase_ == 4;
  }

  /**
   *
   *
   * <pre>
   * Deletes cells from the entire row.
   * </pre>
   *
   * <code>.google.bigtable.v2.Mutation.DeleteFromRow delete_from_row = 4;</code>
   *
   * @return The deleteFromRow.
   */
  @java.lang.Override
  public com.google.bigtable.v2.Mutation.DeleteFromRow getDeleteFromRow() {
    if (mutationCase_ == 4) {
      return (com.google.bigtable.v2.Mutation.DeleteFromRow) mutation_;
    }
    return com.google.bigtable.v2.Mutation.DeleteFromRow.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Deletes cells from the entire row.
   * </pre>
   *
   * <code>.google.bigtable.v2.Mutation.DeleteFromRow delete_from_row = 4;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.Mutation.DeleteFromRowOrBuilder getDeleteFromRowOrBuilder() {
    if (mutationCase_ == 4) {
      return (com.google.bigtable.v2.Mutation.DeleteFromRow) mutation_;
    }
    return com.google.bigtable.v2.Mutation.DeleteFromRow.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (mutationCase_ == 1) {
      output.writeMessage(1, (com.google.bigtable.v2.Mutation.SetCell) mutation_);
    }
    if (mutationCase_ == 2) {
      output.writeMessage(2, (com.google.bigtable.v2.Mutation.DeleteFromColumn) mutation_);
    }
    if (mutationCase_ == 3) {
      output.writeMessage(3, (com.google.bigtable.v2.Mutation.DeleteFromFamily) mutation_);
    }
    if (mutationCase_ == 4) {
      output.writeMessage(4, (com.google.bigtable.v2.Mutation.DeleteFromRow) mutation_);
    }
    if (mutationCase_ == 5) {
      output.writeMessage(5, (com.google.bigtable.v2.Mutation.AddToCell) mutation_);
    }
    if (mutationCase_ == 6) {
      output.writeMessage(6, (com.google.bigtable.v2.Mutation.MergeToCell) mutation_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (mutationCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.bigtable.v2.Mutation.SetCell) mutation_);
    }
    if (mutationCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.bigtable.v2.Mutation.DeleteFromColumn) mutation_);
    }
    if (mutationCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.bigtable.v2.Mutation.DeleteFromFamily) mutation_);
    }
    if (mutationCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.bigtable.v2.Mutation.DeleteFromRow) mutation_);
    }
    if (mutationCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.bigtable.v2.Mutation.AddToCell) mutation_);
    }
    if (mutationCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.bigtable.v2.Mutation.MergeToCell) mutation_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.v2.Mutation)) {
      return super.equals(obj);
    }
    com.google.bigtable.v2.Mutation other = (com.google.bigtable.v2.Mutation) obj;

    if (!getMutationCase().equals(other.getMutationCase())) return false;
    switch (mutationCase_) {
      case 1:
        if (!getSetCell().equals(other.getSetCell())) return false;
        break;
      case 5:
        if (!getAddToCell().equals(other.getAddToCell())) return false;
        break;
      case 6:
        if (!getMergeToCell().equals(other.getMergeToCell())) return false;
        break;
      case 2:
        if (!getDeleteFromColumn().equals(other.getDeleteFromColumn())) return false;
        break;
      case 3:
        if (!getDeleteFromFamily().equals(other.getDeleteFromFamily())) return false;
        break;
      case 4:
        if (!getDeleteFromRow().equals(other.getDeleteFromRow())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (mutationCase_) {
      case 1:
        hash = (37 * hash) + SET_CELL_FIELD_NUMBER;
        hash = (53 * hash) + getSetCell().hashCode();
        break;
      case 5:
        hash = (37 * hash) + ADD_TO_CELL_FIELD_NUMBER;
        hash = (53 * hash) + getAddToCell().hashCode();
        break;
      case 6:
        hash = (37 * hash) + MERGE_TO_CELL_FIELD_NUMBER;
        hash = (53 * hash) + getMergeToCell().hashCode();
        break;
      case 2:
        hash = (37 * hash) + DELETE_FROM_COLUMN_FIELD_NUMBER;
        hash = (53 * hash) + getDeleteFromColumn().hashCode();
        break;
      case 3:
        hash = (37 * hash) + DELETE_FROM_FAMILY_FIELD_NUMBER;
        hash = (53 * hash) + getDeleteFromFamily().hashCode();
        break;
      case 4:
        hash = (37 * hash) + DELETE_FROM_ROW_FIELD_NUMBER;
        hash = (53 * hash) + getDeleteFromRow().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.v2.Mutation parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.Mutation parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.Mutation parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.Mutation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.Mutation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.Mutation parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.Mutation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.Mutation parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.Mutation parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.Mutation parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.Mutation parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.Mutation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.v2.Mutation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Specifies a particular change to be made to the contents of a row.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.Mutation}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.v2.Mutation)
      com.google.bigtable.v2.MutationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.DataProto
          .internal_static_google_bigtable_v2_Mutation_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.DataProto
          .internal_static_google_bigtable_v2_Mutation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.Mutation.class, com.google.bigtable.v2.Mutation.Builder.class);
    }

    // Construct using com.google.bigtable.v2.Mutation.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (setCellBuilder_ != null) {
        setCellBuilder_.clear();
      }
      if (addToCellBuilder_ != null) {
        addToCellBuilder_.clear();
      }
      if (mergeToCellBuilder_ != null) {
        mergeToCellBuilder_.clear();
      }
      if (deleteFromColumnBuilder_ != null) {
        deleteFromColumnBuilder_.clear();
      }
      if (deleteFromFamilyBuilder_ != null) {
        deleteFromFamilyBuilder_.clear();
      }
      if (deleteFromRowBuilder_ != null) {
        deleteFromRowBuilder_.clear();
      }
      mutationCase_ = 0;
      mutation_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.v2.DataProto
          .internal_static_google_bigtable_v2_Mutation_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.v2.Mutation getDefaultInstanceForType() {
      return com.google.bigtable.v2.Mutation.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.v2.Mutation build() {
      com.google.bigtable.v2.Mutation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.v2.Mutation buildPartial() {
      com.google.bigtable.v2.Mutation result = new com.google.bigtable.v2.Mutation(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.bigtable.v2.Mutation result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.bigtable.v2.Mutation result) {
      result.mutationCase_ = mutationCase_;
      result.mutation_ = this.mutation_;
      if (mutationCase_ == 1 && setCellBuilder_ != null) {
        result.mutation_ = setCellBuilder_.build();
      }
      if (mutationCase_ == 5 && addToCellBuilder_ != null) {
        result.mutation_ = addToCellBuilder_.build();
      }
      if (mutationCase_ == 6 && mergeToCellBuilder_ != null) {
        result.mutation_ = mergeToCellBuilder_.build();
      }
      if (mutationCase_ == 2 && deleteFromColumnBuilder_ != null) {
        result.mutation_ = deleteFromColumnBuilder_.build();
      }
      if (mutationCase_ == 3 && deleteFromFamilyBuilder_ != null) {
        result.mutation_ = deleteFromFamilyBuilder_.build();
      }
      if (mutationCase_ == 4 && deleteFromRowBuilder_ != null) {
        result.mutation_ = deleteFromRowBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.v2.Mutation) {
        return mergeFrom((com.google.bigtable.v2.Mutation) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.v2.Mutation other) {
      if (other == com.google.bigtable.v2.Mutation.getDefaultInstance()) return this;
      switch (other.getMutationCase()) {
        case SET_CELL:
          {
            mergeSetCell(other.getSetCell());
            break;
          }
        case ADD_TO_CELL:
          {
            mergeAddToCell(other.getAddToCell());
            break;
          }
        case MERGE_TO_CELL:
          {
            mergeMergeToCell(other.getMergeToCell());
            break;
          }
        case DELETE_FROM_COLUMN:
          {
            mergeDeleteFromColumn(other.getDeleteFromColumn());
            break;
          }
        case DELETE_FROM_FAMILY:
          {
            mergeDeleteFromFamily(other.getDeleteFromFamily());
            break;
          }
        case DELETE_FROM_ROW:
          {
            mergeDeleteFromRow(other.getDeleteFromRow());
            break;
          }
        case MUTATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getSetCellFieldBuilder().getBuilder(), extensionRegistry);
                mutationCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getDeleteFromColumnFieldBuilder().getBuilder(), extensionRegistry);
                mutationCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getDeleteFromFamilyFieldBuilder().getBuilder(), extensionRegistry);
                mutationCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getDeleteFromRowFieldBuilder().getBuilder(), extensionRegistry);
                mutationCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getAddToCellFieldBuilder().getBuilder(), extensionRegistry);
                mutationCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getMergeToCellFieldBuilder().getBuilder(), extensionRegistry);
                mutationCase_ = 6;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int mutationCase_ = 0;
    private java.lang.Object mutation_;

    public MutationCase getMutationCase() {
      return MutationCase.forNumber(mutationCase_);
    }

    public Builder clearMutation() {
      mutationCase_ = 0;
      mutation_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.Mutation.SetCell,
            com.google.bigtable.v2.Mutation.SetCell.Builder,
            com.google.bigtable.v2.Mutation.SetCellOrBuilder>
        setCellBuilder_;

    /**
     *
     *
     * <pre>
     * Set a cell's value.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.SetCell set_cell = 1;</code>
     *
     * @return Whether the setCell field is set.
     */
    @java.lang.Override
    public boolean hasSetCell() {
      return mutationCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Set a cell's value.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.SetCell set_cell = 1;</code>
     *
     * @return The setCell.
     */
    @java.lang.Override
    public com.google.bigtable.v2.Mutation.SetCell getSetCell() {
      if (setCellBuilder_ == null) {
        if (mutationCase_ == 1) {
          return (com.google.bigtable.v2.Mutation.SetCell) mutation_;
        }
        return com.google.bigtable.v2.Mutation.SetCell.getDefaultInstance();
      } else {
        if (mutationCase_ == 1) {
          return setCellBuilder_.getMessage();
        }
        return com.google.bigtable.v2.Mutation.SetCell.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Set a cell's value.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.SetCell set_cell = 1;</code>
     */
    public Builder setSetCell(com.google.bigtable.v2.Mutation.SetCell value) {
      if (setCellBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mutation_ = value;
        onChanged();
      } else {
        setCellBuilder_.setMessage(value);
      }
      mutationCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Set a cell's value.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.SetCell set_cell = 1;</code>
     */
    public Builder setSetCell(com.google.bigtable.v2.Mutation.SetCell.Builder builderForValue) {
      if (setCellBuilder_ == null) {
        mutation_ = builderForValue.build();
        onChanged();
      } else {
        setCellBuilder_.setMessage(builderForValue.build());
      }
      mutationCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Set a cell's value.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.SetCell set_cell = 1;</code>
     */
    public Builder mergeSetCell(com.google.bigtable.v2.Mutation.SetCell value) {
      if (setCellBuilder_ == null) {
        if (mutationCase_ == 1
            && mutation_ != com.google.bigtable.v2.Mutation.SetCell.getDefaultInstance()) {
          mutation_ =
              com.google.bigtable.v2.Mutation.SetCell.newBuilder(
                      (com.google.bigtable.v2.Mutation.SetCell) mutation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          mutation_ = value;
        }
        onChanged();
      } else {
        if (mutationCase_ == 1) {
          setCellBuilder_.mergeFrom(value);
        } else {
          setCellBuilder_.setMessage(value);
        }
      }
      mutationCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Set a cell's value.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.SetCell set_cell = 1;</code>
     */
    public Builder clearSetCell() {
      if (setCellBuilder_ == null) {
        if (mutationCase_ == 1) {
          mutationCase_ = 0;
          mutation_ = null;
          onChanged();
        }
      } else {
        if (mutationCase_ == 1) {
          mutationCase_ = 0;
          mutation_ = null;
        }
        setCellBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Set a cell's value.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.SetCell set_cell = 1;</code>
     */
    public com.google.bigtable.v2.Mutation.SetCell.Builder getSetCellBuilder() {
      return getSetCellFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Set a cell's value.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.SetCell set_cell = 1;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.Mutation.SetCellOrBuilder getSetCellOrBuilder() {
      if ((mutationCase_ == 1) && (setCellBuilder_ != null)) {
        return setCellBuilder_.getMessageOrBuilder();
      } else {
        if (mutationCase_ == 1) {
          return (com.google.bigtable.v2.Mutation.SetCell) mutation_;
        }
        return com.google.bigtable.v2.Mutation.SetCell.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Set a cell's value.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.SetCell set_cell = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.Mutation.SetCell,
            com.google.bigtable.v2.Mutation.SetCell.Builder,
            com.google.bigtable.v2.Mutation.SetCellOrBuilder>
        getSetCellFieldBuilder() {
      if (setCellBuilder_ == null) {
        if (!(mutationCase_ == 1)) {
          mutation_ = com.google.bigtable.v2.Mutation.SetCell.getDefaultInstance();
        }
        setCellBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.v2.Mutation.SetCell,
                com.google.bigtable.v2.Mutation.SetCell.Builder,
                com.google.bigtable.v2.Mutation.SetCellOrBuilder>(
                (com.google.bigtable.v2.Mutation.SetCell) mutation_,
                getParentForChildren(),
                isClean());
        mutation_ = null;
      }
      mutationCase_ = 1;
      onChanged();
      return setCellBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.Mutation.AddToCell,
            com.google.bigtable.v2.Mutation.AddToCell.Builder,
            com.google.bigtable.v2.Mutation.AddToCellOrBuilder>
        addToCellBuilder_;

    /**
     *
     *
     * <pre>
     * Incrementally updates an `Aggregate` cell.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.AddToCell add_to_cell = 5;</code>
     *
     * @return Whether the addToCell field is set.
     */
    @java.lang.Override
    public boolean hasAddToCell() {
      return mutationCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * Incrementally updates an `Aggregate` cell.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.AddToCell add_to_cell = 5;</code>
     *
     * @return The addToCell.
     */
    @java.lang.Override
    public com.google.bigtable.v2.Mutation.AddToCell getAddToCell() {
      if (addToCellBuilder_ == null) {
        if (mutationCase_ == 5) {
          return (com.google.bigtable.v2.Mutation.AddToCell) mutation_;
        }
        return com.google.bigtable.v2.Mutation.AddToCell.getDefaultInstance();
      } else {
        if (mutationCase_ == 5) {
          return addToCellBuilder_.getMessage();
        }
        return com.google.bigtable.v2.Mutation.AddToCell.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Incrementally updates an `Aggregate` cell.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.AddToCell add_to_cell = 5;</code>
     */
    public Builder setAddToCell(com.google.bigtable.v2.Mutation.AddToCell value) {
      if (addToCellBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mutation_ = value;
        onChanged();
      } else {
        addToCellBuilder_.setMessage(value);
      }
      mutationCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Incrementally updates an `Aggregate` cell.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.AddToCell add_to_cell = 5;</code>
     */
    public Builder setAddToCell(com.google.bigtable.v2.Mutation.AddToCell.Builder builderForValue) {
      if (addToCellBuilder_ == null) {
        mutation_ = builderForValue.build();
        onChanged();
      } else {
        addToCellBuilder_.setMessage(builderForValue.build());
      }
      mutationCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Incrementally updates an `Aggregate` cell.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.AddToCell add_to_cell = 5;</code>
     */
    public Builder mergeAddToCell(com.google.bigtable.v2.Mutation.AddToCell value) {
      if (addToCellBuilder_ == null) {
        if (mutationCase_ == 5
            && mutation_ != com.google.bigtable.v2.Mutation.AddToCell.getDefaultInstance()) {
          mutation_ =
              com.google.bigtable.v2.Mutation.AddToCell.newBuilder(
                      (com.google.bigtable.v2.Mutation.AddToCell) mutation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          mutation_ = value;
        }
        onChanged();
      } else {
        if (mutationCase_ == 5) {
          addToCellBuilder_.mergeFrom(value);
        } else {
          addToCellBuilder_.setMessage(value);
        }
      }
      mutationCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Incrementally updates an `Aggregate` cell.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.AddToCell add_to_cell = 5;</code>
     */
    public Builder clearAddToCell() {
      if (addToCellBuilder_ == null) {
        if (mutationCase_ == 5) {
          mutationCase_ = 0;
          mutation_ = null;
          onChanged();
        }
      } else {
        if (mutationCase_ == 5) {
          mutationCase_ = 0;
          mutation_ = null;
        }
        addToCellBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Incrementally updates an `Aggregate` cell.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.AddToCell add_to_cell = 5;</code>
     */
    public com.google.bigtable.v2.Mutation.AddToCell.Builder getAddToCellBuilder() {
      return getAddToCellFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Incrementally updates an `Aggregate` cell.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.AddToCell add_to_cell = 5;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.Mutation.AddToCellOrBuilder getAddToCellOrBuilder() {
      if ((mutationCase_ == 5) && (addToCellBuilder_ != null)) {
        return addToCellBuilder_.getMessageOrBuilder();
      } else {
        if (mutationCase_ == 5) {
          return (com.google.bigtable.v2.Mutation.AddToCell) mutation_;
        }
        return com.google.bigtable.v2.Mutation.AddToCell.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Incrementally updates an `Aggregate` cell.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.AddToCell add_to_cell = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.Mutation.AddToCell,
            com.google.bigtable.v2.Mutation.AddToCell.Builder,
            com.google.bigtable.v2.Mutation.AddToCellOrBuilder>
        getAddToCellFieldBuilder() {
      if (addToCellBuilder_ == null) {
        if (!(mutationCase_ == 5)) {
          mutation_ = com.google.bigtable.v2.Mutation.AddToCell.getDefaultInstance();
        }
        addToCellBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.v2.Mutation.AddToCell,
                com.google.bigtable.v2.Mutation.AddToCell.Builder,
                com.google.bigtable.v2.Mutation.AddToCellOrBuilder>(
                (com.google.bigtable.v2.Mutation.AddToCell) mutation_,
                getParentForChildren(),
                isClean());
        mutation_ = null;
      }
      mutationCase_ = 5;
      onChanged();
      return addToCellBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.Mutation.MergeToCell,
            com.google.bigtable.v2.Mutation.MergeToCell.Builder,
            com.google.bigtable.v2.Mutation.MergeToCellOrBuilder>
        mergeToCellBuilder_;

    /**
     *
     *
     * <pre>
     * Merges accumulated state to an `Aggregate` cell.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.MergeToCell merge_to_cell = 6;</code>
     *
     * @return Whether the mergeToCell field is set.
     */
    @java.lang.Override
    public boolean hasMergeToCell() {
      return mutationCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * Merges accumulated state to an `Aggregate` cell.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.MergeToCell merge_to_cell = 6;</code>
     *
     * @return The mergeToCell.
     */
    @java.lang.Override
    public com.google.bigtable.v2.Mutation.MergeToCell getMergeToCell() {
      if (mergeToCellBuilder_ == null) {
        if (mutationCase_ == 6) {
          return (com.google.bigtable.v2.Mutation.MergeToCell) mutation_;
        }
        return com.google.bigtable.v2.Mutation.MergeToCell.getDefaultInstance();
      } else {
        if (mutationCase_ == 6) {
          return mergeToCellBuilder_.getMessage();
        }
        return com.google.bigtable.v2.Mutation.MergeToCell.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Merges accumulated state to an `Aggregate` cell.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.MergeToCell merge_to_cell = 6;</code>
     */
    public Builder setMergeToCell(com.google.bigtable.v2.Mutation.MergeToCell value) {
      if (mergeToCellBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mutation_ = value;
        onChanged();
      } else {
        mergeToCellBuilder_.setMessage(value);
      }
      mutationCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Merges accumulated state to an `Aggregate` cell.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.MergeToCell merge_to_cell = 6;</code>
     */
    public Builder setMergeToCell(
        com.google.bigtable.v2.Mutation.MergeToCell.Builder builderForValue) {
      if (mergeToCellBuilder_ == null) {
        mutation_ = builderForValue.build();
        onChanged();
      } else {
        mergeToCellBuilder_.setMessage(builderForValue.build());
      }
      mutationCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Merges accumulated state to an `Aggregate` cell.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.MergeToCell merge_to_cell = 6;</code>
     */
    public Builder mergeMergeToCell(com.google.bigtable.v2.Mutation.MergeToCell value) {
      if (mergeToCellBuilder_ == null) {
        if (mutationCase_ == 6
            && mutation_ != com.google.bigtable.v2.Mutation.MergeToCell.getDefaultInstance()) {
          mutation_ =
              com.google.bigtable.v2.Mutation.MergeToCell.newBuilder(
                      (com.google.bigtable.v2.Mutation.MergeToCell) mutation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          mutation_ = value;
        }
        onChanged();
      } else {
        if (mutationCase_ == 6) {
          mergeToCellBuilder_.mergeFrom(value);
        } else {
          mergeToCellBuilder_.setMessage(value);
        }
      }
      mutationCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Merges accumulated state to an `Aggregate` cell.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.MergeToCell merge_to_cell = 6;</code>
     */
    public Builder clearMergeToCell() {
      if (mergeToCellBuilder_ == null) {
        if (mutationCase_ == 6) {
          mutationCase_ = 0;
          mutation_ = null;
          onChanged();
        }
      } else {
        if (mutationCase_ == 6) {
          mutationCase_ = 0;
          mutation_ = null;
        }
        mergeToCellBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Merges accumulated state to an `Aggregate` cell.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.MergeToCell merge_to_cell = 6;</code>
     */
    public com.google.bigtable.v2.Mutation.MergeToCell.Builder getMergeToCellBuilder() {
      return getMergeToCellFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Merges accumulated state to an `Aggregate` cell.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.MergeToCell merge_to_cell = 6;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.Mutation.MergeToCellOrBuilder getMergeToCellOrBuilder() {
      if ((mutationCase_ == 6) && (mergeToCellBuilder_ != null)) {
        return mergeToCellBuilder_.getMessageOrBuilder();
      } else {
        if (mutationCase_ == 6) {
          return (com.google.bigtable.v2.Mutation.MergeToCell) mutation_;
        }
        return com.google.bigtable.v2.Mutation.MergeToCell.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Merges accumulated state to an `Aggregate` cell.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.MergeToCell merge_to_cell = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.Mutation.MergeToCell,
            com.google.bigtable.v2.Mutation.MergeToCell.Builder,
            com.google.bigtable.v2.Mutation.MergeToCellOrBuilder>
        getMergeToCellFieldBuilder() {
      if (mergeToCellBuilder_ == null) {
        if (!(mutationCase_ == 6)) {
          mutation_ = com.google.bigtable.v2.Mutation.MergeToCell.getDefaultInstance();
        }
        mergeToCellBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.v2.Mutation.MergeToCell,
                com.google.bigtable.v2.Mutation.MergeToCell.Builder,
                com.google.bigtable.v2.Mutation.MergeToCellOrBuilder>(
                (com.google.bigtable.v2.Mutation.MergeToCell) mutation_,
                getParentForChildren(),
                isClean());
        mutation_ = null;
      }
      mutationCase_ = 6;
      onChanged();
      return mergeToCellBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.Mutation.DeleteFromColumn,
            com.google.bigtable.v2.Mutation.DeleteFromColumn.Builder,
            com.google.bigtable.v2.Mutation.DeleteFromColumnOrBuilder>
        deleteFromColumnBuilder_;

    /**
     *
     *
     * <pre>
     * Deletes cells from a column.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.DeleteFromColumn delete_from_column = 2;</code>
     *
     * @return Whether the deleteFromColumn field is set.
     */
    @java.lang.Override
    public boolean hasDeleteFromColumn() {
      return mutationCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Deletes cells from a column.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.DeleteFromColumn delete_from_column = 2;</code>
     *
     * @return The deleteFromColumn.
     */
    @java.lang.Override
    public com.google.bigtable.v2.Mutation.DeleteFromColumn getDeleteFromColumn() {
      if (deleteFromColumnBuilder_ == null) {
        if (mutationCase_ == 2) {
          return (com.google.bigtable.v2.Mutation.DeleteFromColumn) mutation_;
        }
        return com.google.bigtable.v2.Mutation.DeleteFromColumn.getDefaultInstance();
      } else {
        if (mutationCase_ == 2) {
          return deleteFromColumnBuilder_.getMessage();
        }
        return com.google.bigtable.v2.Mutation.DeleteFromColumn.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Deletes cells from a column.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.DeleteFromColumn delete_from_column = 2;</code>
     */
    public Builder setDeleteFromColumn(com.google.bigtable.v2.Mutation.DeleteFromColumn value) {
      if (deleteFromColumnBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mutation_ = value;
        onChanged();
      } else {
        deleteFromColumnBuilder_.setMessage(value);
      }
      mutationCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deletes cells from a column.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.DeleteFromColumn delete_from_column = 2;</code>
     */
    public Builder setDeleteFromColumn(
        com.google.bigtable.v2.Mutation.DeleteFromColumn.Builder builderForValue) {
      if (deleteFromColumnBuilder_ == null) {
        mutation_ = builderForValue.build();
        onChanged();
      } else {
        deleteFromColumnBuilder_.setMessage(builderForValue.build());
      }
      mutationCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deletes cells from a column.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.DeleteFromColumn delete_from_column = 2;</code>
     */
    public Builder mergeDeleteFromColumn(com.google.bigtable.v2.Mutation.DeleteFromColumn value) {
      if (deleteFromColumnBuilder_ == null) {
        if (mutationCase_ == 2
            && mutation_ != com.google.bigtable.v2.Mutation.DeleteFromColumn.getDefaultInstance()) {
          mutation_ =
              com.google.bigtable.v2.Mutation.DeleteFromColumn.newBuilder(
                      (com.google.bigtable.v2.Mutation.DeleteFromColumn) mutation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          mutation_ = value;
        }
        onChanged();
      } else {
        if (mutationCase_ == 2) {
          deleteFromColumnBuilder_.mergeFrom(value);
        } else {
          deleteFromColumnBuilder_.setMessage(value);
        }
      }
      mutationCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deletes cells from a column.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.DeleteFromColumn delete_from_column = 2;</code>
     */
    public Builder clearDeleteFromColumn() {
      if (deleteFromColumnBuilder_ == null) {
        if (mutationCase_ == 2) {
          mutationCase_ = 0;
          mutation_ = null;
          onChanged();
        }
      } else {
        if (mutationCase_ == 2) {
          mutationCase_ = 0;
          mutation_ = null;
        }
        deleteFromColumnBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deletes cells from a column.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.DeleteFromColumn delete_from_column = 2;</code>
     */
    public com.google.bigtable.v2.Mutation.DeleteFromColumn.Builder getDeleteFromColumnBuilder() {
      return getDeleteFromColumnFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Deletes cells from a column.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.DeleteFromColumn delete_from_column = 2;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.Mutation.DeleteFromColumnOrBuilder
        getDeleteFromColumnOrBuilder() {
      if ((mutationCase_ == 2) && (deleteFromColumnBuilder_ != null)) {
        return deleteFromColumnBuilder_.getMessageOrBuilder();
      } else {
        if (mutationCase_ == 2) {
          return (com.google.bigtable.v2.Mutation.DeleteFromColumn) mutation_;
        }
        return com.google.bigtable.v2.Mutation.DeleteFromColumn.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Deletes cells from a column.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.DeleteFromColumn delete_from_column = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.Mutation.DeleteFromColumn,
            com.google.bigtable.v2.Mutation.DeleteFromColumn.Builder,
            com.google.bigtable.v2.Mutation.DeleteFromColumnOrBuilder>
        getDeleteFromColumnFieldBuilder() {
      if (deleteFromColumnBuilder_ == null) {
        if (!(mutationCase_ == 2)) {
          mutation_ = com.google.bigtable.v2.Mutation.DeleteFromColumn.getDefaultInstance();
        }
        deleteFromColumnBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.v2.Mutation.DeleteFromColumn,
                com.google.bigtable.v2.Mutation.DeleteFromColumn.Builder,
                com.google.bigtable.v2.Mutation.DeleteFromColumnOrBuilder>(
                (com.google.bigtable.v2.Mutation.DeleteFromColumn) mutation_,
                getParentForChildren(),
                isClean());
        mutation_ = null;
      }
      mutationCase_ = 2;
      onChanged();
      return deleteFromColumnBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.Mutation.DeleteFromFamily,
            com.google.bigtable.v2.Mutation.DeleteFromFamily.Builder,
            com.google.bigtable.v2.Mutation.DeleteFromFamilyOrBuilder>
        deleteFromFamilyBuilder_;

    /**
     *
     *
     * <pre>
     * Deletes cells from a column family.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.DeleteFromFamily delete_from_family = 3;</code>
     *
     * @return Whether the deleteFromFamily field is set.
     */
    @java.lang.Override
    public boolean hasDeleteFromFamily() {
      return mutationCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Deletes cells from a column family.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.DeleteFromFamily delete_from_family = 3;</code>
     *
     * @return The deleteFromFamily.
     */
    @java.lang.Override
    public com.google.bigtable.v2.Mutation.DeleteFromFamily getDeleteFromFamily() {
      if (deleteFromFamilyBuilder_ == null) {
        if (mutationCase_ == 3) {
          return (com.google.bigtable.v2.Mutation.DeleteFromFamily) mutation_;
        }
        return com.google.bigtable.v2.Mutation.DeleteFromFamily.getDefaultInstance();
      } else {
        if (mutationCase_ == 3) {
          return deleteFromFamilyBuilder_.getMessage();
        }
        return com.google.bigtable.v2.Mutation.DeleteFromFamily.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Deletes cells from a column family.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.DeleteFromFamily delete_from_family = 3;</code>
     */
    public Builder setDeleteFromFamily(com.google.bigtable.v2.Mutation.DeleteFromFamily value) {
      if (deleteFromFamilyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mutation_ = value;
        onChanged();
      } else {
        deleteFromFamilyBuilder_.setMessage(value);
      }
      mutationCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deletes cells from a column family.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.DeleteFromFamily delete_from_family = 3;</code>
     */
    public Builder setDeleteFromFamily(
        com.google.bigtable.v2.Mutation.DeleteFromFamily.Builder builderForValue) {
      if (deleteFromFamilyBuilder_ == null) {
        mutation_ = builderForValue.build();
        onChanged();
      } else {
        deleteFromFamilyBuilder_.setMessage(builderForValue.build());
      }
      mutationCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deletes cells from a column family.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.DeleteFromFamily delete_from_family = 3;</code>
     */
    public Builder mergeDeleteFromFamily(com.google.bigtable.v2.Mutation.DeleteFromFamily value) {
      if (deleteFromFamilyBuilder_ == null) {
        if (mutationCase_ == 3
            && mutation_ != com.google.bigtable.v2.Mutation.DeleteFromFamily.getDefaultInstance()) {
          mutation_ =
              com.google.bigtable.v2.Mutation.DeleteFromFamily.newBuilder(
                      (com.google.bigtable.v2.Mutation.DeleteFromFamily) mutation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          mutation_ = value;
        }
        onChanged();
      } else {
        if (mutationCase_ == 3) {
          deleteFromFamilyBuilder_.mergeFrom(value);
        } else {
          deleteFromFamilyBuilder_.setMessage(value);
        }
      }
      mutationCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deletes cells from a column family.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.DeleteFromFamily delete_from_family = 3;</code>
     */
    public Builder clearDeleteFromFamily() {
      if (deleteFromFamilyBuilder_ == null) {
        if (mutationCase_ == 3) {
          mutationCase_ = 0;
          mutation_ = null;
          onChanged();
        }
      } else {
        if (mutationCase_ == 3) {
          mutationCase_ = 0;
          mutation_ = null;
        }
        deleteFromFamilyBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deletes cells from a column family.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.DeleteFromFamily delete_from_family = 3;</code>
     */
    public com.google.bigtable.v2.Mutation.DeleteFromFamily.Builder getDeleteFromFamilyBuilder() {
      return getDeleteFromFamilyFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Deletes cells from a column family.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.DeleteFromFamily delete_from_family = 3;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.Mutation.DeleteFromFamilyOrBuilder
        getDeleteFromFamilyOrBuilder() {
      if ((mutationCase_ == 3) && (deleteFromFamilyBuilder_ != null)) {
        return deleteFromFamilyBuilder_.getMessageOrBuilder();
      } else {
        if (mutationCase_ == 3) {
          return (com.google.bigtable.v2.Mutation.DeleteFromFamily) mutation_;
        }
        return com.google.bigtable.v2.Mutation.DeleteFromFamily.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Deletes cells from a column family.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.DeleteFromFamily delete_from_family = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.Mutation.DeleteFromFamily,
            com.google.bigtable.v2.Mutation.DeleteFromFamily.Builder,
            com.google.bigtable.v2.Mutation.DeleteFromFamilyOrBuilder>
        getDeleteFromFamilyFieldBuilder() {
      if (deleteFromFamilyBuilder_ == null) {
        if (!(mutationCase_ == 3)) {
          mutation_ = com.google.bigtable.v2.Mutation.DeleteFromFamily.getDefaultInstance();
        }
        deleteFromFamilyBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.v2.Mutation.DeleteFromFamily,
                com.google.bigtable.v2.Mutation.DeleteFromFamily.Builder,
                com.google.bigtable.v2.Mutation.DeleteFromFamilyOrBuilder>(
                (com.google.bigtable.v2.Mutation.DeleteFromFamily) mutation_,
                getParentForChildren(),
                isClean());
        mutation_ = null;
      }
      mutationCase_ = 3;
      onChanged();
      return deleteFromFamilyBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.Mutation.DeleteFromRow,
            com.google.bigtable.v2.Mutation.DeleteFromRow.Builder,
            com.google.bigtable.v2.Mutation.DeleteFromRowOrBuilder>
        deleteFromRowBuilder_;

    /**
     *
     *
     * <pre>
     * Deletes cells from the entire row.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.DeleteFromRow delete_from_row = 4;</code>
     *
     * @return Whether the deleteFromRow field is set.
     */
    @java.lang.Override
    public boolean hasDeleteFromRow() {
      return mutationCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * Deletes cells from the entire row.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.DeleteFromRow delete_from_row = 4;</code>
     *
     * @return The deleteFromRow.
     */
    @java.lang.Override
    public com.google.bigtable.v2.Mutation.DeleteFromRow getDeleteFromRow() {
      if (deleteFromRowBuilder_ == null) {
        if (mutationCase_ == 4) {
          return (com.google.bigtable.v2.Mutation.DeleteFromRow) mutation_;
        }
        return com.google.bigtable.v2.Mutation.DeleteFromRow.getDefaultInstance();
      } else {
        if (mutationCase_ == 4) {
          return deleteFromRowBuilder_.getMessage();
        }
        return com.google.bigtable.v2.Mutation.DeleteFromRow.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Deletes cells from the entire row.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.DeleteFromRow delete_from_row = 4;</code>
     */
    public Builder setDeleteFromRow(com.google.bigtable.v2.Mutation.DeleteFromRow value) {
      if (deleteFromRowBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        mutation_ = value;
        onChanged();
      } else {
        deleteFromRowBuilder_.setMessage(value);
      }
      mutationCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deletes cells from the entire row.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.DeleteFromRow delete_from_row = 4;</code>
     */
    public Builder setDeleteFromRow(
        com.google.bigtable.v2.Mutation.DeleteFromRow.Builder builderForValue) {
      if (deleteFromRowBuilder_ == null) {
        mutation_ = builderForValue.build();
        onChanged();
      } else {
        deleteFromRowBuilder_.setMessage(builderForValue.build());
      }
      mutationCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deletes cells from the entire row.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.DeleteFromRow delete_from_row = 4;</code>
     */
    public Builder mergeDeleteFromRow(com.google.bigtable.v2.Mutation.DeleteFromRow value) {
      if (deleteFromRowBuilder_ == null) {
        if (mutationCase_ == 4
            && mutation_ != com.google.bigtable.v2.Mutation.DeleteFromRow.getDefaultInstance()) {
          mutation_ =
              com.google.bigtable.v2.Mutation.DeleteFromRow.newBuilder(
                      (com.google.bigtable.v2.Mutation.DeleteFromRow) mutation_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          mutation_ = value;
        }
        onChanged();
      } else {
        if (mutationCase_ == 4) {
          deleteFromRowBuilder_.mergeFrom(value);
        } else {
          deleteFromRowBuilder_.setMessage(value);
        }
      }
      mutationCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deletes cells from the entire row.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.DeleteFromRow delete_from_row = 4;</code>
     */
    public Builder clearDeleteFromRow() {
      if (deleteFromRowBuilder_ == null) {
        if (mutationCase_ == 4) {
          mutationCase_ = 0;
          mutation_ = null;
          onChanged();
        }
      } else {
        if (mutationCase_ == 4) {
          mutationCase_ = 0;
          mutation_ = null;
        }
        deleteFromRowBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deletes cells from the entire row.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.DeleteFromRow delete_from_row = 4;</code>
     */
    public com.google.bigtable.v2.Mutation.DeleteFromRow.Builder getDeleteFromRowBuilder() {
      return getDeleteFromRowFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Deletes cells from the entire row.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.DeleteFromRow delete_from_row = 4;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.Mutation.DeleteFromRowOrBuilder getDeleteFromRowOrBuilder() {
      if ((mutationCase_ == 4) && (deleteFromRowBuilder_ != null)) {
        return deleteFromRowBuilder_.getMessageOrBuilder();
      } else {
        if (mutationCase_ == 4) {
          return (com.google.bigtable.v2.Mutation.DeleteFromRow) mutation_;
        }
        return com.google.bigtable.v2.Mutation.DeleteFromRow.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Deletes cells from the entire row.
     * </pre>
     *
     * <code>.google.bigtable.v2.Mutation.DeleteFromRow delete_from_row = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.Mutation.DeleteFromRow,
            com.google.bigtable.v2.Mutation.DeleteFromRow.Builder,
            com.google.bigtable.v2.Mutation.DeleteFromRowOrBuilder>
        getDeleteFromRowFieldBuilder() {
      if (deleteFromRowBuilder_ == null) {
        if (!(mutationCase_ == 4)) {
          mutation_ = com.google.bigtable.v2.Mutation.DeleteFromRow.getDefaultInstance();
        }
        deleteFromRowBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.v2.Mutation.DeleteFromRow,
                com.google.bigtable.v2.Mutation.DeleteFromRow.Builder,
                com.google.bigtable.v2.Mutation.DeleteFromRowOrBuilder>(
                (com.google.bigtable.v2.Mutation.DeleteFromRow) mutation_,
                getParentForChildren(),
                isClean());
        mutation_ = null;
      }
      mutationCase_ = 4;
      onChanged();
      return deleteFromRowBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.v2.Mutation)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.v2.Mutation)
  private static final com.google.bigtable.v2.Mutation DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.v2.Mutation();
  }

  public static com.google.bigtable.v2.Mutation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Mutation> PARSER =
      new com.google.protobuf.AbstractParser<Mutation>() {
        @java.lang.Override
        public Mutation parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Mutation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Mutation> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.v2.Mutation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
