/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/v2/bigtable.proto

package com.google.bigtable.v2;

/**
 *
 *
 * <pre>
 * Request message for Bigtable.ReadRows.
 * </pre>
 *
 * Protobuf type {@code google.bigtable.v2.ReadRowsRequest}
 */
public final class ReadRowsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.v2.ReadRowsRequest)
    ReadRowsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReadRowsRequest.newBuilder() to construct.
  private ReadRowsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReadRowsRequest() {
    tableName_ = "";
    appProfileId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReadRowsRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ReadRowsRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              tableName_ = s;
              break;
            }
          case 18:
            {
              com.google.bigtable.v2.RowSet.Builder subBuilder = null;
              if (rows_ != null) {
                subBuilder = rows_.toBuilder();
              }
              rows_ = input.readMessage(com.google.bigtable.v2.RowSet.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(rows_);
                rows_ = subBuilder.buildPartial();
              }

              break;
            }
          case 26:
            {
              com.google.bigtable.v2.RowFilter.Builder subBuilder = null;
              if (filter_ != null) {
                subBuilder = filter_.toBuilder();
              }
              filter_ =
                  input.readMessage(com.google.bigtable.v2.RowFilter.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(filter_);
                filter_ = subBuilder.buildPartial();
              }

              break;
            }
          case 32:
            {
              rowsLimit_ = input.readInt64();
              break;
            }
          case 42:
            {
              java.lang.String s = input.readStringRequireUtf8();

              appProfileId_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.v2.BigtableProto
        .internal_static_google_bigtable_v2_ReadRowsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.v2.BigtableProto
        .internal_static_google_bigtable_v2_ReadRowsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.v2.ReadRowsRequest.class,
            com.google.bigtable.v2.ReadRowsRequest.Builder.class);
  }

  public static final int TABLE_NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object tableName_;
  /**
   *
   *
   * <pre>
   * Required. The unique name of the table from which to read.
   * Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
   * </pre>
   *
   * <code>
   * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The tableName.
   */
  @java.lang.Override
  public java.lang.String getTableName() {
    java.lang.Object ref = tableName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tableName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The unique name of the table from which to read.
   * Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
   * </pre>
   *
   * <code>
   * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for tableName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTableNameBytes() {
    java.lang.Object ref = tableName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tableName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int APP_PROFILE_ID_FIELD_NUMBER = 5;
  private volatile java.lang.Object appProfileId_;
  /**
   *
   *
   * <pre>
   * This value specifies routing for replication. If not specified, the
   * "default" application profile will be used.
   * </pre>
   *
   * <code>string app_profile_id = 5;</code>
   *
   * @return The appProfileId.
   */
  @java.lang.Override
  public java.lang.String getAppProfileId() {
    java.lang.Object ref = appProfileId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      appProfileId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This value specifies routing for replication. If not specified, the
   * "default" application profile will be used.
   * </pre>
   *
   * <code>string app_profile_id = 5;</code>
   *
   * @return The bytes for appProfileId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAppProfileIdBytes() {
    java.lang.Object ref = appProfileId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      appProfileId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROWS_FIELD_NUMBER = 2;
  private com.google.bigtable.v2.RowSet rows_;
  /**
   *
   *
   * <pre>
   * The row keys and/or ranges to read. If not specified, reads from all rows.
   * </pre>
   *
   * <code>.google.bigtable.v2.RowSet rows = 2;</code>
   *
   * @return Whether the rows field is set.
   */
  @java.lang.Override
  public boolean hasRows() {
    return rows_ != null;
  }
  /**
   *
   *
   * <pre>
   * The row keys and/or ranges to read. If not specified, reads from all rows.
   * </pre>
   *
   * <code>.google.bigtable.v2.RowSet rows = 2;</code>
   *
   * @return The rows.
   */
  @java.lang.Override
  public com.google.bigtable.v2.RowSet getRows() {
    return rows_ == null ? com.google.bigtable.v2.RowSet.getDefaultInstance() : rows_;
  }
  /**
   *
   *
   * <pre>
   * The row keys and/or ranges to read. If not specified, reads from all rows.
   * </pre>
   *
   * <code>.google.bigtable.v2.RowSet rows = 2;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.RowSetOrBuilder getRowsOrBuilder() {
    return getRows();
  }

  public static final int FILTER_FIELD_NUMBER = 3;
  private com.google.bigtable.v2.RowFilter filter_;
  /**
   *
   *
   * <pre>
   * The filter to apply to the contents of the specified row(s). If unset,
   * reads the entirety of each row.
   * </pre>
   *
   * <code>.google.bigtable.v2.RowFilter filter = 3;</code>
   *
   * @return Whether the filter field is set.
   */
  @java.lang.Override
  public boolean hasFilter() {
    return filter_ != null;
  }
  /**
   *
   *
   * <pre>
   * The filter to apply to the contents of the specified row(s). If unset,
   * reads the entirety of each row.
   * </pre>
   *
   * <code>.google.bigtable.v2.RowFilter filter = 3;</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public com.google.bigtable.v2.RowFilter getFilter() {
    return filter_ == null ? com.google.bigtable.v2.RowFilter.getDefaultInstance() : filter_;
  }
  /**
   *
   *
   * <pre>
   * The filter to apply to the contents of the specified row(s). If unset,
   * reads the entirety of each row.
   * </pre>
   *
   * <code>.google.bigtable.v2.RowFilter filter = 3;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.RowFilterOrBuilder getFilterOrBuilder() {
    return getFilter();
  }

  public static final int ROWS_LIMIT_FIELD_NUMBER = 4;
  private long rowsLimit_;
  /**
   *
   *
   * <pre>
   * The read will terminate after committing to N rows' worth of results. The
   * default (zero) is to return all results.
   * </pre>
   *
   * <code>int64 rows_limit = 4;</code>
   *
   * @return The rowsLimit.
   */
  @java.lang.Override
  public long getRowsLimit() {
    return rowsLimit_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, tableName_);
    }
    if (rows_ != null) {
      output.writeMessage(2, getRows());
    }
    if (filter_ != null) {
      output.writeMessage(3, getFilter());
    }
    if (rowsLimit_ != 0L) {
      output.writeInt64(4, rowsLimit_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(appProfileId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, appProfileId_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(tableName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, tableName_);
    }
    if (rows_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getRows());
    }
    if (filter_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getFilter());
    }
    if (rowsLimit_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, rowsLimit_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(appProfileId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, appProfileId_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.v2.ReadRowsRequest)) {
      return super.equals(obj);
    }
    com.google.bigtable.v2.ReadRowsRequest other = (com.google.bigtable.v2.ReadRowsRequest) obj;

    if (!getTableName().equals(other.getTableName())) return false;
    if (!getAppProfileId().equals(other.getAppProfileId())) return false;
    if (hasRows() != other.hasRows()) return false;
    if (hasRows()) {
      if (!getRows().equals(other.getRows())) return false;
    }
    if (hasFilter() != other.hasFilter()) return false;
    if (hasFilter()) {
      if (!getFilter().equals(other.getFilter())) return false;
    }
    if (getRowsLimit() != other.getRowsLimit()) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TABLE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getTableName().hashCode();
    hash = (37 * hash) + APP_PROFILE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getAppProfileId().hashCode();
    if (hasRows()) {
      hash = (37 * hash) + ROWS_FIELD_NUMBER;
      hash = (53 * hash) + getRows().hashCode();
    }
    if (hasFilter()) {
      hash = (37 * hash) + FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getFilter().hashCode();
    }
    hash = (37 * hash) + ROWS_LIMIT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getRowsLimit());
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.v2.ReadRowsRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.ReadRowsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadRowsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.ReadRowsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadRowsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.ReadRowsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadRowsRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.ReadRowsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadRowsRequest parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.ReadRowsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadRowsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.ReadRowsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.v2.ReadRowsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for Bigtable.ReadRows.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.ReadRowsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.v2.ReadRowsRequest)
      com.google.bigtable.v2.ReadRowsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_ReadRowsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_ReadRowsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.ReadRowsRequest.class,
              com.google.bigtable.v2.ReadRowsRequest.Builder.class);
    }

    // Construct using com.google.bigtable.v2.ReadRowsRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      tableName_ = "";

      appProfileId_ = "";

      if (rowsBuilder_ == null) {
        rows_ = null;
      } else {
        rows_ = null;
        rowsBuilder_ = null;
      }
      if (filterBuilder_ == null) {
        filter_ = null;
      } else {
        filter_ = null;
        filterBuilder_ = null;
      }
      rowsLimit_ = 0L;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_ReadRowsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.v2.ReadRowsRequest getDefaultInstanceForType() {
      return com.google.bigtable.v2.ReadRowsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.v2.ReadRowsRequest build() {
      com.google.bigtable.v2.ReadRowsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.v2.ReadRowsRequest buildPartial() {
      com.google.bigtable.v2.ReadRowsRequest result =
          new com.google.bigtable.v2.ReadRowsRequest(this);
      result.tableName_ = tableName_;
      result.appProfileId_ = appProfileId_;
      if (rowsBuilder_ == null) {
        result.rows_ = rows_;
      } else {
        result.rows_ = rowsBuilder_.build();
      }
      if (filterBuilder_ == null) {
        result.filter_ = filter_;
      } else {
        result.filter_ = filterBuilder_.build();
      }
      result.rowsLimit_ = rowsLimit_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.v2.ReadRowsRequest) {
        return mergeFrom((com.google.bigtable.v2.ReadRowsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.v2.ReadRowsRequest other) {
      if (other == com.google.bigtable.v2.ReadRowsRequest.getDefaultInstance()) return this;
      if (!other.getTableName().isEmpty()) {
        tableName_ = other.tableName_;
        onChanged();
      }
      if (!other.getAppProfileId().isEmpty()) {
        appProfileId_ = other.appProfileId_;
        onChanged();
      }
      if (other.hasRows()) {
        mergeRows(other.getRows());
      }
      if (other.hasFilter()) {
        mergeFilter(other.getFilter());
      }
      if (other.getRowsLimit() != 0L) {
        setRowsLimit(other.getRowsLimit());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.bigtable.v2.ReadRowsRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.bigtable.v2.ReadRowsRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object tableName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table from which to read.
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The tableName.
     */
    public java.lang.String getTableName() {
      java.lang.Object ref = tableName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tableName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table from which to read.
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for tableName.
     */
    public com.google.protobuf.ByteString getTableNameBytes() {
      java.lang.Object ref = tableName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tableName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table from which to read.
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The tableName to set.
     * @return This builder for chaining.
     */
    public Builder setTableName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      tableName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table from which to read.
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTableName() {

      tableName_ = getDefaultInstance().getTableName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table from which to read.
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for tableName to set.
     * @return This builder for chaining.
     */
    public Builder setTableNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      tableName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object appProfileId_ = "";
    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 5;</code>
     *
     * @return The appProfileId.
     */
    public java.lang.String getAppProfileId() {
      java.lang.Object ref = appProfileId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        appProfileId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 5;</code>
     *
     * @return The bytes for appProfileId.
     */
    public com.google.protobuf.ByteString getAppProfileIdBytes() {
      java.lang.Object ref = appProfileId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        appProfileId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 5;</code>
     *
     * @param value The appProfileId to set.
     * @return This builder for chaining.
     */
    public Builder setAppProfileId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      appProfileId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAppProfileId() {

      appProfileId_ = getDefaultInstance().getAppProfileId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 5;</code>
     *
     * @param value The bytes for appProfileId to set.
     * @return This builder for chaining.
     */
    public Builder setAppProfileIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      appProfileId_ = value;
      onChanged();
      return this;
    }

    private com.google.bigtable.v2.RowSet rows_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.RowSet,
            com.google.bigtable.v2.RowSet.Builder,
            com.google.bigtable.v2.RowSetOrBuilder>
        rowsBuilder_;
    /**
     *
     *
     * <pre>
     * The row keys and/or ranges to read. If not specified, reads from all rows.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowSet rows = 2;</code>
     *
     * @return Whether the rows field is set.
     */
    public boolean hasRows() {
      return rowsBuilder_ != null || rows_ != null;
    }
    /**
     *
     *
     * <pre>
     * The row keys and/or ranges to read. If not specified, reads from all rows.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowSet rows = 2;</code>
     *
     * @return The rows.
     */
    public com.google.bigtable.v2.RowSet getRows() {
      if (rowsBuilder_ == null) {
        return rows_ == null ? com.google.bigtable.v2.RowSet.getDefaultInstance() : rows_;
      } else {
        return rowsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The row keys and/or ranges to read. If not specified, reads from all rows.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowSet rows = 2;</code>
     */
    public Builder setRows(com.google.bigtable.v2.RowSet value) {
      if (rowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rows_ = value;
        onChanged();
      } else {
        rowsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The row keys and/or ranges to read. If not specified, reads from all rows.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowSet rows = 2;</code>
     */
    public Builder setRows(com.google.bigtable.v2.RowSet.Builder builderForValue) {
      if (rowsBuilder_ == null) {
        rows_ = builderForValue.build();
        onChanged();
      } else {
        rowsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The row keys and/or ranges to read. If not specified, reads from all rows.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowSet rows = 2;</code>
     */
    public Builder mergeRows(com.google.bigtable.v2.RowSet value) {
      if (rowsBuilder_ == null) {
        if (rows_ != null) {
          rows_ = com.google.bigtable.v2.RowSet.newBuilder(rows_).mergeFrom(value).buildPartial();
        } else {
          rows_ = value;
        }
        onChanged();
      } else {
        rowsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The row keys and/or ranges to read. If not specified, reads from all rows.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowSet rows = 2;</code>
     */
    public Builder clearRows() {
      if (rowsBuilder_ == null) {
        rows_ = null;
        onChanged();
      } else {
        rows_ = null;
        rowsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The row keys and/or ranges to read. If not specified, reads from all rows.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowSet rows = 2;</code>
     */
    public com.google.bigtable.v2.RowSet.Builder getRowsBuilder() {

      onChanged();
      return getRowsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The row keys and/or ranges to read. If not specified, reads from all rows.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowSet rows = 2;</code>
     */
    public com.google.bigtable.v2.RowSetOrBuilder getRowsOrBuilder() {
      if (rowsBuilder_ != null) {
        return rowsBuilder_.getMessageOrBuilder();
      } else {
        return rows_ == null ? com.google.bigtable.v2.RowSet.getDefaultInstance() : rows_;
      }
    }
    /**
     *
     *
     * <pre>
     * The row keys and/or ranges to read. If not specified, reads from all rows.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowSet rows = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.RowSet,
            com.google.bigtable.v2.RowSet.Builder,
            com.google.bigtable.v2.RowSetOrBuilder>
        getRowsFieldBuilder() {
      if (rowsBuilder_ == null) {
        rowsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.v2.RowSet,
                com.google.bigtable.v2.RowSet.Builder,
                com.google.bigtable.v2.RowSetOrBuilder>(
                getRows(), getParentForChildren(), isClean());
        rows_ = null;
      }
      return rowsBuilder_;
    }

    private com.google.bigtable.v2.RowFilter filter_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.RowFilter,
            com.google.bigtable.v2.RowFilter.Builder,
            com.google.bigtable.v2.RowFilterOrBuilder>
        filterBuilder_;
    /**
     *
     *
     * <pre>
     * The filter to apply to the contents of the specified row(s). If unset,
     * reads the entirety of each row.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter filter = 3;</code>
     *
     * @return Whether the filter field is set.
     */
    public boolean hasFilter() {
      return filterBuilder_ != null || filter_ != null;
    }
    /**
     *
     *
     * <pre>
     * The filter to apply to the contents of the specified row(s). If unset,
     * reads the entirety of each row.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter filter = 3;</code>
     *
     * @return The filter.
     */
    public com.google.bigtable.v2.RowFilter getFilter() {
      if (filterBuilder_ == null) {
        return filter_ == null ? com.google.bigtable.v2.RowFilter.getDefaultInstance() : filter_;
      } else {
        return filterBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The filter to apply to the contents of the specified row(s). If unset,
     * reads the entirety of each row.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter filter = 3;</code>
     */
    public Builder setFilter(com.google.bigtable.v2.RowFilter value) {
      if (filterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        onChanged();
      } else {
        filterBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter to apply to the contents of the specified row(s). If unset,
     * reads the entirety of each row.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter filter = 3;</code>
     */
    public Builder setFilter(com.google.bigtable.v2.RowFilter.Builder builderForValue) {
      if (filterBuilder_ == null) {
        filter_ = builderForValue.build();
        onChanged();
      } else {
        filterBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter to apply to the contents of the specified row(s). If unset,
     * reads the entirety of each row.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter filter = 3;</code>
     */
    public Builder mergeFilter(com.google.bigtable.v2.RowFilter value) {
      if (filterBuilder_ == null) {
        if (filter_ != null) {
          filter_ =
              com.google.bigtable.v2.RowFilter.newBuilder(filter_).mergeFrom(value).buildPartial();
        } else {
          filter_ = value;
        }
        onChanged();
      } else {
        filterBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter to apply to the contents of the specified row(s). If unset,
     * reads the entirety of each row.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter filter = 3;</code>
     */
    public Builder clearFilter() {
      if (filterBuilder_ == null) {
        filter_ = null;
        onChanged();
      } else {
        filter_ = null;
        filterBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter to apply to the contents of the specified row(s). If unset,
     * reads the entirety of each row.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter filter = 3;</code>
     */
    public com.google.bigtable.v2.RowFilter.Builder getFilterBuilder() {

      onChanged();
      return getFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The filter to apply to the contents of the specified row(s). If unset,
     * reads the entirety of each row.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter filter = 3;</code>
     */
    public com.google.bigtable.v2.RowFilterOrBuilder getFilterOrBuilder() {
      if (filterBuilder_ != null) {
        return filterBuilder_.getMessageOrBuilder();
      } else {
        return filter_ == null ? com.google.bigtable.v2.RowFilter.getDefaultInstance() : filter_;
      }
    }
    /**
     *
     *
     * <pre>
     * The filter to apply to the contents of the specified row(s). If unset,
     * reads the entirety of each row.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter filter = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.RowFilter,
            com.google.bigtable.v2.RowFilter.Builder,
            com.google.bigtable.v2.RowFilterOrBuilder>
        getFilterFieldBuilder() {
      if (filterBuilder_ == null) {
        filterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.v2.RowFilter,
                com.google.bigtable.v2.RowFilter.Builder,
                com.google.bigtable.v2.RowFilterOrBuilder>(
                getFilter(), getParentForChildren(), isClean());
        filter_ = null;
      }
      return filterBuilder_;
    }

    private long rowsLimit_;
    /**
     *
     *
     * <pre>
     * The read will terminate after committing to N rows' worth of results. The
     * default (zero) is to return all results.
     * </pre>
     *
     * <code>int64 rows_limit = 4;</code>
     *
     * @return The rowsLimit.
     */
    @java.lang.Override
    public long getRowsLimit() {
      return rowsLimit_;
    }
    /**
     *
     *
     * <pre>
     * The read will terminate after committing to N rows' worth of results. The
     * default (zero) is to return all results.
     * </pre>
     *
     * <code>int64 rows_limit = 4;</code>
     *
     * @param value The rowsLimit to set.
     * @return This builder for chaining.
     */
    public Builder setRowsLimit(long value) {

      rowsLimit_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The read will terminate after committing to N rows' worth of results. The
     * default (zero) is to return all results.
     * </pre>
     *
     * <code>int64 rows_limit = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRowsLimit() {

      rowsLimit_ = 0L;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.v2.ReadRowsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.v2.ReadRowsRequest)
  private static final com.google.bigtable.v2.ReadRowsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.v2.ReadRowsRequest();
  }

  public static com.google.bigtable.v2.ReadRowsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReadRowsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ReadRowsRequest>() {
        @java.lang.Override
        public ReadRowsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ReadRowsRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ReadRowsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReadRowsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.v2.ReadRowsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
