/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/v2/bigtable.proto

// Protobuf Java Version: 3.25.3
package com.google.bigtable.v2;

/**
 *
 *
 * <pre>
 * Information about how client should adjust the load to Bigtable.
 * </pre>
 *
 * Protobuf type {@code google.bigtable.v2.RateLimitInfo}
 */
public final class RateLimitInfo extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.v2.RateLimitInfo)
    RateLimitInfoOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RateLimitInfo.newBuilder() to construct.
  private RateLimitInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RateLimitInfo() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RateLimitInfo();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.v2.BigtableProto
        .internal_static_google_bigtable_v2_RateLimitInfo_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.v2.BigtableProto
        .internal_static_google_bigtable_v2_RateLimitInfo_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.v2.RateLimitInfo.class,
            com.google.bigtable.v2.RateLimitInfo.Builder.class);
  }

  private int bitField0_;
  public static final int PERIOD_FIELD_NUMBER = 1;
  private com.google.protobuf.Duration period_;
  /**
   *
   *
   * <pre>
   * Time that clients should wait before adjusting the target rate again.
   * If clients adjust rate too frequently, the impact of the previous
   * adjustment may not have been taken into account and may
   * over-throttle or under-throttle. If clients adjust rate too slowly, they
   * will not be responsive to load changes on server side, and may
   * over-throttle or under-throttle.
   * </pre>
   *
   * <code>.google.protobuf.Duration period = 1;</code>
   *
   * @return Whether the period field is set.
   */
  @java.lang.Override
  public boolean hasPeriod() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Time that clients should wait before adjusting the target rate again.
   * If clients adjust rate too frequently, the impact of the previous
   * adjustment may not have been taken into account and may
   * over-throttle or under-throttle. If clients adjust rate too slowly, they
   * will not be responsive to load changes on server side, and may
   * over-throttle or under-throttle.
   * </pre>
   *
   * <code>.google.protobuf.Duration period = 1;</code>
   *
   * @return The period.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getPeriod() {
    return period_ == null ? com.google.protobuf.Duration.getDefaultInstance() : period_;
  }
  /**
   *
   *
   * <pre>
   * Time that clients should wait before adjusting the target rate again.
   * If clients adjust rate too frequently, the impact of the previous
   * adjustment may not have been taken into account and may
   * over-throttle or under-throttle. If clients adjust rate too slowly, they
   * will not be responsive to load changes on server side, and may
   * over-throttle or under-throttle.
   * </pre>
   *
   * <code>.google.protobuf.Duration period = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getPeriodOrBuilder() {
    return period_ == null ? com.google.protobuf.Duration.getDefaultInstance() : period_;
  }

  public static final int FACTOR_FIELD_NUMBER = 2;
  private double factor_ = 0D;
  /**
   *
   *
   * <pre>
   * If it has been at least one `period` since the last load adjustment, the
   * client should multiply the current load by this value to get the new target
   * load. For example, if the current load is 100 and `factor` is 0.8, the new
   * target load should be 80. After adjusting, the client should ignore
   * `factor` until another `period` has passed.
   *
   * The client can measure its load using any unit that's comparable over time
   * For example, QPS can be used as long as each request involves a similar
   * amount of work.
   * </pre>
   *
   * <code>double factor = 2;</code>
   *
   * @return The factor.
   */
  @java.lang.Override
  public double getFactor() {
    return factor_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getPeriod());
    }
    if (java.lang.Double.doubleToRawLongBits(factor_) != 0) {
      output.writeDouble(2, factor_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getPeriod());
    }
    if (java.lang.Double.doubleToRawLongBits(factor_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, factor_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.v2.RateLimitInfo)) {
      return super.equals(obj);
    }
    com.google.bigtable.v2.RateLimitInfo other = (com.google.bigtable.v2.RateLimitInfo) obj;

    if (hasPeriod() != other.hasPeriod()) return false;
    if (hasPeriod()) {
      if (!getPeriod().equals(other.getPeriod())) return false;
    }
    if (java.lang.Double.doubleToLongBits(getFactor())
        != java.lang.Double.doubleToLongBits(other.getFactor())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasPeriod()) {
      hash = (37 * hash) + PERIOD_FIELD_NUMBER;
      hash = (53 * hash) + getPeriod().hashCode();
    }
    hash = (37 * hash) + FACTOR_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(java.lang.Double.doubleToLongBits(getFactor()));
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.v2.RateLimitInfo parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.RateLimitInfo parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.RateLimitInfo parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.RateLimitInfo parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.RateLimitInfo parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.RateLimitInfo parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.RateLimitInfo parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.RateLimitInfo parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.RateLimitInfo parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.RateLimitInfo parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.RateLimitInfo parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.RateLimitInfo parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.v2.RateLimitInfo prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Information about how client should adjust the load to Bigtable.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.RateLimitInfo}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.v2.RateLimitInfo)
      com.google.bigtable.v2.RateLimitInfoOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_RateLimitInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_RateLimitInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.RateLimitInfo.class,
              com.google.bigtable.v2.RateLimitInfo.Builder.class);
    }

    // Construct using com.google.bigtable.v2.RateLimitInfo.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPeriodFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      period_ = null;
      if (periodBuilder_ != null) {
        periodBuilder_.dispose();
        periodBuilder_ = null;
      }
      factor_ = 0D;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_RateLimitInfo_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.v2.RateLimitInfo getDefaultInstanceForType() {
      return com.google.bigtable.v2.RateLimitInfo.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.v2.RateLimitInfo build() {
      com.google.bigtable.v2.RateLimitInfo result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.v2.RateLimitInfo buildPartial() {
      com.google.bigtable.v2.RateLimitInfo result = new com.google.bigtable.v2.RateLimitInfo(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.bigtable.v2.RateLimitInfo result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.period_ = periodBuilder_ == null ? period_ : periodBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.factor_ = factor_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.v2.RateLimitInfo) {
        return mergeFrom((com.google.bigtable.v2.RateLimitInfo) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.v2.RateLimitInfo other) {
      if (other == com.google.bigtable.v2.RateLimitInfo.getDefaultInstance()) return this;
      if (other.hasPeriod()) {
        mergePeriod(other.getPeriod());
      }
      if (other.getFactor() != 0D) {
        setFactor(other.getFactor());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getPeriodFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 17:
              {
                factor_ = input.readDouble();
                bitField0_ |= 0x00000002;
                break;
              } // case 17
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Duration period_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        periodBuilder_;
    /**
     *
     *
     * <pre>
     * Time that clients should wait before adjusting the target rate again.
     * If clients adjust rate too frequently, the impact of the previous
     * adjustment may not have been taken into account and may
     * over-throttle or under-throttle. If clients adjust rate too slowly, they
     * will not be responsive to load changes on server side, and may
     * over-throttle or under-throttle.
     * </pre>
     *
     * <code>.google.protobuf.Duration period = 1;</code>
     *
     * @return Whether the period field is set.
     */
    public boolean hasPeriod() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Time that clients should wait before adjusting the target rate again.
     * If clients adjust rate too frequently, the impact of the previous
     * adjustment may not have been taken into account and may
     * over-throttle or under-throttle. If clients adjust rate too slowly, they
     * will not be responsive to load changes on server side, and may
     * over-throttle or under-throttle.
     * </pre>
     *
     * <code>.google.protobuf.Duration period = 1;</code>
     *
     * @return The period.
     */
    public com.google.protobuf.Duration getPeriod() {
      if (periodBuilder_ == null) {
        return period_ == null ? com.google.protobuf.Duration.getDefaultInstance() : period_;
      } else {
        return periodBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Time that clients should wait before adjusting the target rate again.
     * If clients adjust rate too frequently, the impact of the previous
     * adjustment may not have been taken into account and may
     * over-throttle or under-throttle. If clients adjust rate too slowly, they
     * will not be responsive to load changes on server side, and may
     * over-throttle or under-throttle.
     * </pre>
     *
     * <code>.google.protobuf.Duration period = 1;</code>
     */
    public Builder setPeriod(com.google.protobuf.Duration value) {
      if (periodBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        period_ = value;
      } else {
        periodBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time that clients should wait before adjusting the target rate again.
     * If clients adjust rate too frequently, the impact of the previous
     * adjustment may not have been taken into account and may
     * over-throttle or under-throttle. If clients adjust rate too slowly, they
     * will not be responsive to load changes on server side, and may
     * over-throttle or under-throttle.
     * </pre>
     *
     * <code>.google.protobuf.Duration period = 1;</code>
     */
    public Builder setPeriod(com.google.protobuf.Duration.Builder builderForValue) {
      if (periodBuilder_ == null) {
        period_ = builderForValue.build();
      } else {
        periodBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time that clients should wait before adjusting the target rate again.
     * If clients adjust rate too frequently, the impact of the previous
     * adjustment may not have been taken into account and may
     * over-throttle or under-throttle. If clients adjust rate too slowly, they
     * will not be responsive to load changes on server side, and may
     * over-throttle or under-throttle.
     * </pre>
     *
     * <code>.google.protobuf.Duration period = 1;</code>
     */
    public Builder mergePeriod(com.google.protobuf.Duration value) {
      if (periodBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && period_ != null
            && period_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getPeriodBuilder().mergeFrom(value);
        } else {
          period_ = value;
        }
      } else {
        periodBuilder_.mergeFrom(value);
      }
      if (period_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time that clients should wait before adjusting the target rate again.
     * If clients adjust rate too frequently, the impact of the previous
     * adjustment may not have been taken into account and may
     * over-throttle or under-throttle. If clients adjust rate too slowly, they
     * will not be responsive to load changes on server side, and may
     * over-throttle or under-throttle.
     * </pre>
     *
     * <code>.google.protobuf.Duration period = 1;</code>
     */
    public Builder clearPeriod() {
      bitField0_ = (bitField0_ & ~0x00000001);
      period_ = null;
      if (periodBuilder_ != null) {
        periodBuilder_.dispose();
        periodBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time that clients should wait before adjusting the target rate again.
     * If clients adjust rate too frequently, the impact of the previous
     * adjustment may not have been taken into account and may
     * over-throttle or under-throttle. If clients adjust rate too slowly, they
     * will not be responsive to load changes on server side, and may
     * over-throttle or under-throttle.
     * </pre>
     *
     * <code>.google.protobuf.Duration period = 1;</code>
     */
    public com.google.protobuf.Duration.Builder getPeriodBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getPeriodFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time that clients should wait before adjusting the target rate again.
     * If clients adjust rate too frequently, the impact of the previous
     * adjustment may not have been taken into account and may
     * over-throttle or under-throttle. If clients adjust rate too slowly, they
     * will not be responsive to load changes on server side, and may
     * over-throttle or under-throttle.
     * </pre>
     *
     * <code>.google.protobuf.Duration period = 1;</code>
     */
    public com.google.protobuf.DurationOrBuilder getPeriodOrBuilder() {
      if (periodBuilder_ != null) {
        return periodBuilder_.getMessageOrBuilder();
      } else {
        return period_ == null ? com.google.protobuf.Duration.getDefaultInstance() : period_;
      }
    }
    /**
     *
     *
     * <pre>
     * Time that clients should wait before adjusting the target rate again.
     * If clients adjust rate too frequently, the impact of the previous
     * adjustment may not have been taken into account and may
     * over-throttle or under-throttle. If clients adjust rate too slowly, they
     * will not be responsive to load changes on server side, and may
     * over-throttle or under-throttle.
     * </pre>
     *
     * <code>.google.protobuf.Duration period = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getPeriodFieldBuilder() {
      if (periodBuilder_ == null) {
        periodBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getPeriod(), getParentForChildren(), isClean());
        period_ = null;
      }
      return periodBuilder_;
    }

    private double factor_;
    /**
     *
     *
     * <pre>
     * If it has been at least one `period` since the last load adjustment, the
     * client should multiply the current load by this value to get the new target
     * load. For example, if the current load is 100 and `factor` is 0.8, the new
     * target load should be 80. After adjusting, the client should ignore
     * `factor` until another `period` has passed.
     *
     * The client can measure its load using any unit that's comparable over time
     * For example, QPS can be used as long as each request involves a similar
     * amount of work.
     * </pre>
     *
     * <code>double factor = 2;</code>
     *
     * @return The factor.
     */
    @java.lang.Override
    public double getFactor() {
      return factor_;
    }
    /**
     *
     *
     * <pre>
     * If it has been at least one `period` since the last load adjustment, the
     * client should multiply the current load by this value to get the new target
     * load. For example, if the current load is 100 and `factor` is 0.8, the new
     * target load should be 80. After adjusting, the client should ignore
     * `factor` until another `period` has passed.
     *
     * The client can measure its load using any unit that's comparable over time
     * For example, QPS can be used as long as each request involves a similar
     * amount of work.
     * </pre>
     *
     * <code>double factor = 2;</code>
     *
     * @param value The factor to set.
     * @return This builder for chaining.
     */
    public Builder setFactor(double value) {

      factor_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If it has been at least one `period` since the last load adjustment, the
     * client should multiply the current load by this value to get the new target
     * load. For example, if the current load is 100 and `factor` is 0.8, the new
     * target load should be 80. After adjusting, the client should ignore
     * `factor` until another `period` has passed.
     *
     * The client can measure its load using any unit that's comparable over time
     * For example, QPS can be used as long as each request involves a similar
     * amount of work.
     * </pre>
     *
     * <code>double factor = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFactor() {
      bitField0_ = (bitField0_ & ~0x00000002);
      factor_ = 0D;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.v2.RateLimitInfo)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.v2.RateLimitInfo)
  private static final com.google.bigtable.v2.RateLimitInfo DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.v2.RateLimitInfo();
  }

  public static com.google.bigtable.v2.RateLimitInfo getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RateLimitInfo> PARSER =
      new com.google.protobuf.AbstractParser<RateLimitInfo>() {
        @java.lang.Override
        public RateLimitInfo parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RateLimitInfo> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RateLimitInfo> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.v2.RateLimitInfo getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
