/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/v2/data.proto

package com.google.bigtable.v2;

public interface CellOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.bigtable.v2.Cell)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The cell's stored timestamp, which also uniquely identifies it within
   * its column.
   * Values are always expressed in microseconds, but individual tables may set
   * a coarser granularity to further restrict the allowed values. For
   * example, a table which specifies millisecond granularity will only allow
   * values of `timestamp_micros` which are multiples of 1000.
   * </pre>
   *
   * <code>int64 timestamp_micros = 1;</code>
   *
   * @return The timestampMicros.
   */
  long getTimestampMicros();

  /**
   *
   *
   * <pre>
   * The value stored in the cell.
   * May contain any byte string, including the empty string, up to 100MiB in
   * length.
   * </pre>
   *
   * <code>bytes value = 2;</code>
   *
   * @return The value.
   */
  com.google.protobuf.ByteString getValue();

  /**
   *
   *
   * <pre>
   * Labels applied to the cell by a [RowFilter][google.bigtable.v2.RowFilter].
   * </pre>
   *
   * <code>repeated string labels = 3;</code>
   *
   * @return A list containing the labels.
   */
  java.util.List<java.lang.String> getLabelsList();
  /**
   *
   *
   * <pre>
   * Labels applied to the cell by a [RowFilter][google.bigtable.v2.RowFilter].
   * </pre>
   *
   * <code>repeated string labels = 3;</code>
   *
   * @return The count of labels.
   */
  int getLabelsCount();
  /**
   *
   *
   * <pre>
   * Labels applied to the cell by a [RowFilter][google.bigtable.v2.RowFilter].
   * </pre>
   *
   * <code>repeated string labels = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The labels at the given index.
   */
  java.lang.String getLabels(int index);
  /**
   *
   *
   * <pre>
   * Labels applied to the cell by a [RowFilter][google.bigtable.v2.RowFilter].
   * </pre>
   *
   * <code>repeated string labels = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the labels at the given index.
   */
  com.google.protobuf.ByteString getLabelsBytes(int index);
}
