/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/v2/bigtable.proto

package com.google.bigtable.v2;

/**
 *
 *
 * <pre>
 * Request message for Bigtable.CheckAndMutateRow.
 * </pre>
 *
 * Protobuf type {@code google.bigtable.v2.CheckAndMutateRowRequest}
 */
public final class CheckAndMutateRowRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.v2.CheckAndMutateRowRequest)
    CheckAndMutateRowRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CheckAndMutateRowRequest.newBuilder() to construct.
  private CheckAndMutateRowRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CheckAndMutateRowRequest() {
    tableName_ = "";
    appProfileId_ = "";
    rowKey_ = com.google.protobuf.ByteString.EMPTY;
    trueMutations_ = java.util.Collections.emptyList();
    falseMutations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CheckAndMutateRowRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private CheckAndMutateRowRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              tableName_ = s;
              break;
            }
          case 18:
            {
              rowKey_ = input.readBytes();
              break;
            }
          case 34:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                trueMutations_ = new java.util.ArrayList<com.google.bigtable.v2.Mutation>();
                mutable_bitField0_ |= 0x00000001;
              }
              trueMutations_.add(
                  input.readMessage(com.google.bigtable.v2.Mutation.parser(), extensionRegistry));
              break;
            }
          case 42:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                falseMutations_ = new java.util.ArrayList<com.google.bigtable.v2.Mutation>();
                mutable_bitField0_ |= 0x00000002;
              }
              falseMutations_.add(
                  input.readMessage(com.google.bigtable.v2.Mutation.parser(), extensionRegistry));
              break;
            }
          case 50:
            {
              com.google.bigtable.v2.RowFilter.Builder subBuilder = null;
              if (predicateFilter_ != null) {
                subBuilder = predicateFilter_.toBuilder();
              }
              predicateFilter_ =
                  input.readMessage(com.google.bigtable.v2.RowFilter.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(predicateFilter_);
                predicateFilter_ = subBuilder.buildPartial();
              }

              break;
            }
          case 58:
            {
              java.lang.String s = input.readStringRequireUtf8();

              appProfileId_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        trueMutations_ = java.util.Collections.unmodifiableList(trueMutations_);
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        falseMutations_ = java.util.Collections.unmodifiableList(falseMutations_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.v2.BigtableProto
        .internal_static_google_bigtable_v2_CheckAndMutateRowRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.v2.BigtableProto
        .internal_static_google_bigtable_v2_CheckAndMutateRowRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.v2.CheckAndMutateRowRequest.class,
            com.google.bigtable.v2.CheckAndMutateRowRequest.Builder.class);
  }

  public static final int TABLE_NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object tableName_;
  /**
   *
   *
   * <pre>
   * Required. The unique name of the table to which the conditional mutation should be
   * applied.
   * Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
   * </pre>
   *
   * <code>
   * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The tableName.
   */
  @java.lang.Override
  public java.lang.String getTableName() {
    java.lang.Object ref = tableName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      tableName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The unique name of the table to which the conditional mutation should be
   * applied.
   * Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
   * </pre>
   *
   * <code>
   * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for tableName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTableNameBytes() {
    java.lang.Object ref = tableName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      tableName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int APP_PROFILE_ID_FIELD_NUMBER = 7;
  private volatile java.lang.Object appProfileId_;
  /**
   *
   *
   * <pre>
   * This value specifies routing for replication. If not specified, the
   * "default" application profile will be used.
   * </pre>
   *
   * <code>string app_profile_id = 7;</code>
   *
   * @return The appProfileId.
   */
  @java.lang.Override
  public java.lang.String getAppProfileId() {
    java.lang.Object ref = appProfileId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      appProfileId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This value specifies routing for replication. If not specified, the
   * "default" application profile will be used.
   * </pre>
   *
   * <code>string app_profile_id = 7;</code>
   *
   * @return The bytes for appProfileId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAppProfileIdBytes() {
    java.lang.Object ref = appProfileId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      appProfileId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ROW_KEY_FIELD_NUMBER = 2;
  private com.google.protobuf.ByteString rowKey_;
  /**
   *
   *
   * <pre>
   * Required. The key of the row to which the conditional mutation should be applied.
   * </pre>
   *
   * <code>bytes row_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The rowKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRowKey() {
    return rowKey_;
  }

  public static final int PREDICATE_FILTER_FIELD_NUMBER = 6;
  private com.google.bigtable.v2.RowFilter predicateFilter_;
  /**
   *
   *
   * <pre>
   * The filter to be applied to the contents of the specified row. Depending
   * on whether or not any results are yielded, either `true_mutations` or
   * `false_mutations` will be executed. If unset, checks that the row contains
   * any values at all.
   * </pre>
   *
   * <code>.google.bigtable.v2.RowFilter predicate_filter = 6;</code>
   *
   * @return Whether the predicateFilter field is set.
   */
  @java.lang.Override
  public boolean hasPredicateFilter() {
    return predicateFilter_ != null;
  }
  /**
   *
   *
   * <pre>
   * The filter to be applied to the contents of the specified row. Depending
   * on whether or not any results are yielded, either `true_mutations` or
   * `false_mutations` will be executed. If unset, checks that the row contains
   * any values at all.
   * </pre>
   *
   * <code>.google.bigtable.v2.RowFilter predicate_filter = 6;</code>
   *
   * @return The predicateFilter.
   */
  @java.lang.Override
  public com.google.bigtable.v2.RowFilter getPredicateFilter() {
    return predicateFilter_ == null
        ? com.google.bigtable.v2.RowFilter.getDefaultInstance()
        : predicateFilter_;
  }
  /**
   *
   *
   * <pre>
   * The filter to be applied to the contents of the specified row. Depending
   * on whether or not any results are yielded, either `true_mutations` or
   * `false_mutations` will be executed. If unset, checks that the row contains
   * any values at all.
   * </pre>
   *
   * <code>.google.bigtable.v2.RowFilter predicate_filter = 6;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.RowFilterOrBuilder getPredicateFilterOrBuilder() {
    return getPredicateFilter();
  }

  public static final int TRUE_MUTATIONS_FIELD_NUMBER = 4;
  private java.util.List<com.google.bigtable.v2.Mutation> trueMutations_;
  /**
   *
   *
   * <pre>
   * Changes to be atomically applied to the specified row if `predicate_filter`
   * yields at least one cell when applied to `row_key`. Entries are applied in
   * order, meaning that earlier mutations can be masked by later ones.
   * Must contain at least one entry if `false_mutations` is empty, and at most
   * 100000.
   * </pre>
   *
   * <code>repeated .google.bigtable.v2.Mutation true_mutations = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.bigtable.v2.Mutation> getTrueMutationsList() {
    return trueMutations_;
  }
  /**
   *
   *
   * <pre>
   * Changes to be atomically applied to the specified row if `predicate_filter`
   * yields at least one cell when applied to `row_key`. Entries are applied in
   * order, meaning that earlier mutations can be masked by later ones.
   * Must contain at least one entry if `false_mutations` is empty, and at most
   * 100000.
   * </pre>
   *
   * <code>repeated .google.bigtable.v2.Mutation true_mutations = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.bigtable.v2.MutationOrBuilder>
      getTrueMutationsOrBuilderList() {
    return trueMutations_;
  }
  /**
   *
   *
   * <pre>
   * Changes to be atomically applied to the specified row if `predicate_filter`
   * yields at least one cell when applied to `row_key`. Entries are applied in
   * order, meaning that earlier mutations can be masked by later ones.
   * Must contain at least one entry if `false_mutations` is empty, and at most
   * 100000.
   * </pre>
   *
   * <code>repeated .google.bigtable.v2.Mutation true_mutations = 4;</code>
   */
  @java.lang.Override
  public int getTrueMutationsCount() {
    return trueMutations_.size();
  }
  /**
   *
   *
   * <pre>
   * Changes to be atomically applied to the specified row if `predicate_filter`
   * yields at least one cell when applied to `row_key`. Entries are applied in
   * order, meaning that earlier mutations can be masked by later ones.
   * Must contain at least one entry if `false_mutations` is empty, and at most
   * 100000.
   * </pre>
   *
   * <code>repeated .google.bigtable.v2.Mutation true_mutations = 4;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.Mutation getTrueMutations(int index) {
    return trueMutations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Changes to be atomically applied to the specified row if `predicate_filter`
   * yields at least one cell when applied to `row_key`. Entries are applied in
   * order, meaning that earlier mutations can be masked by later ones.
   * Must contain at least one entry if `false_mutations` is empty, and at most
   * 100000.
   * </pre>
   *
   * <code>repeated .google.bigtable.v2.Mutation true_mutations = 4;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.MutationOrBuilder getTrueMutationsOrBuilder(int index) {
    return trueMutations_.get(index);
  }

  public static final int FALSE_MUTATIONS_FIELD_NUMBER = 5;
  private java.util.List<com.google.bigtable.v2.Mutation> falseMutations_;
  /**
   *
   *
   * <pre>
   * Changes to be atomically applied to the specified row if `predicate_filter`
   * does not yield any cells when applied to `row_key`. Entries are applied in
   * order, meaning that earlier mutations can be masked by later ones.
   * Must contain at least one entry if `true_mutations` is empty, and at most
   * 100000.
   * </pre>
   *
   * <code>repeated .google.bigtable.v2.Mutation false_mutations = 5;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.bigtable.v2.Mutation> getFalseMutationsList() {
    return falseMutations_;
  }
  /**
   *
   *
   * <pre>
   * Changes to be atomically applied to the specified row if `predicate_filter`
   * does not yield any cells when applied to `row_key`. Entries are applied in
   * order, meaning that earlier mutations can be masked by later ones.
   * Must contain at least one entry if `true_mutations` is empty, and at most
   * 100000.
   * </pre>
   *
   * <code>repeated .google.bigtable.v2.Mutation false_mutations = 5;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.bigtable.v2.MutationOrBuilder>
      getFalseMutationsOrBuilderList() {
    return falseMutations_;
  }
  /**
   *
   *
   * <pre>
   * Changes to be atomically applied to the specified row if `predicate_filter`
   * does not yield any cells when applied to `row_key`. Entries are applied in
   * order, meaning that earlier mutations can be masked by later ones.
   * Must contain at least one entry if `true_mutations` is empty, and at most
   * 100000.
   * </pre>
   *
   * <code>repeated .google.bigtable.v2.Mutation false_mutations = 5;</code>
   */
  @java.lang.Override
  public int getFalseMutationsCount() {
    return falseMutations_.size();
  }
  /**
   *
   *
   * <pre>
   * Changes to be atomically applied to the specified row if `predicate_filter`
   * does not yield any cells when applied to `row_key`. Entries are applied in
   * order, meaning that earlier mutations can be masked by later ones.
   * Must contain at least one entry if `true_mutations` is empty, and at most
   * 100000.
   * </pre>
   *
   * <code>repeated .google.bigtable.v2.Mutation false_mutations = 5;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.Mutation getFalseMutations(int index) {
    return falseMutations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Changes to be atomically applied to the specified row if `predicate_filter`
   * does not yield any cells when applied to `row_key`. Entries are applied in
   * order, meaning that earlier mutations can be masked by later ones.
   * Must contain at least one entry if `true_mutations` is empty, and at most
   * 100000.
   * </pre>
   *
   * <code>repeated .google.bigtable.v2.Mutation false_mutations = 5;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.MutationOrBuilder getFalseMutationsOrBuilder(int index) {
    return falseMutations_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getTableNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, tableName_);
    }
    if (!rowKey_.isEmpty()) {
      output.writeBytes(2, rowKey_);
    }
    for (int i = 0; i < trueMutations_.size(); i++) {
      output.writeMessage(4, trueMutations_.get(i));
    }
    for (int i = 0; i < falseMutations_.size(); i++) {
      output.writeMessage(5, falseMutations_.get(i));
    }
    if (predicateFilter_ != null) {
      output.writeMessage(6, getPredicateFilter());
    }
    if (!getAppProfileIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, appProfileId_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getTableNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, tableName_);
    }
    if (!rowKey_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(2, rowKey_);
    }
    for (int i = 0; i < trueMutations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, trueMutations_.get(i));
    }
    for (int i = 0; i < falseMutations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, falseMutations_.get(i));
    }
    if (predicateFilter_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getPredicateFilter());
    }
    if (!getAppProfileIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, appProfileId_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.v2.CheckAndMutateRowRequest)) {
      return super.equals(obj);
    }
    com.google.bigtable.v2.CheckAndMutateRowRequest other =
        (com.google.bigtable.v2.CheckAndMutateRowRequest) obj;

    if (!getTableName().equals(other.getTableName())) return false;
    if (!getAppProfileId().equals(other.getAppProfileId())) return false;
    if (!getRowKey().equals(other.getRowKey())) return false;
    if (hasPredicateFilter() != other.hasPredicateFilter()) return false;
    if (hasPredicateFilter()) {
      if (!getPredicateFilter().equals(other.getPredicateFilter())) return false;
    }
    if (!getTrueMutationsList().equals(other.getTrueMutationsList())) return false;
    if (!getFalseMutationsList().equals(other.getFalseMutationsList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TABLE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getTableName().hashCode();
    hash = (37 * hash) + APP_PROFILE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getAppProfileId().hashCode();
    hash = (37 * hash) + ROW_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getRowKey().hashCode();
    if (hasPredicateFilter()) {
      hash = (37 * hash) + PREDICATE_FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getPredicateFilter().hashCode();
    }
    if (getTrueMutationsCount() > 0) {
      hash = (37 * hash) + TRUE_MUTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getTrueMutationsList().hashCode();
    }
    if (getFalseMutationsCount() > 0) {
      hash = (37 * hash) + FALSE_MUTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getFalseMutationsList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.v2.CheckAndMutateRowRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.CheckAndMutateRowRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.CheckAndMutateRowRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.CheckAndMutateRowRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.CheckAndMutateRowRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.CheckAndMutateRowRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.CheckAndMutateRowRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.CheckAndMutateRowRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.CheckAndMutateRowRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.CheckAndMutateRowRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.CheckAndMutateRowRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.CheckAndMutateRowRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.v2.CheckAndMutateRowRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for Bigtable.CheckAndMutateRow.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.CheckAndMutateRowRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.v2.CheckAndMutateRowRequest)
      com.google.bigtable.v2.CheckAndMutateRowRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_CheckAndMutateRowRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_CheckAndMutateRowRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.CheckAndMutateRowRequest.class,
              com.google.bigtable.v2.CheckAndMutateRowRequest.Builder.class);
    }

    // Construct using com.google.bigtable.v2.CheckAndMutateRowRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTrueMutationsFieldBuilder();
        getFalseMutationsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      tableName_ = "";

      appProfileId_ = "";

      rowKey_ = com.google.protobuf.ByteString.EMPTY;

      if (predicateFilterBuilder_ == null) {
        predicateFilter_ = null;
      } else {
        predicateFilter_ = null;
        predicateFilterBuilder_ = null;
      }
      if (trueMutationsBuilder_ == null) {
        trueMutations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        trueMutationsBuilder_.clear();
      }
      if (falseMutationsBuilder_ == null) {
        falseMutations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        falseMutationsBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_CheckAndMutateRowRequest_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.v2.CheckAndMutateRowRequest getDefaultInstanceForType() {
      return com.google.bigtable.v2.CheckAndMutateRowRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.v2.CheckAndMutateRowRequest build() {
      com.google.bigtable.v2.CheckAndMutateRowRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.v2.CheckAndMutateRowRequest buildPartial() {
      com.google.bigtable.v2.CheckAndMutateRowRequest result =
          new com.google.bigtable.v2.CheckAndMutateRowRequest(this);
      int from_bitField0_ = bitField0_;
      result.tableName_ = tableName_;
      result.appProfileId_ = appProfileId_;
      result.rowKey_ = rowKey_;
      if (predicateFilterBuilder_ == null) {
        result.predicateFilter_ = predicateFilter_;
      } else {
        result.predicateFilter_ = predicateFilterBuilder_.build();
      }
      if (trueMutationsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          trueMutations_ = java.util.Collections.unmodifiableList(trueMutations_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.trueMutations_ = trueMutations_;
      } else {
        result.trueMutations_ = trueMutationsBuilder_.build();
      }
      if (falseMutationsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          falseMutations_ = java.util.Collections.unmodifiableList(falseMutations_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.falseMutations_ = falseMutations_;
      } else {
        result.falseMutations_ = falseMutationsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.v2.CheckAndMutateRowRequest) {
        return mergeFrom((com.google.bigtable.v2.CheckAndMutateRowRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.v2.CheckAndMutateRowRequest other) {
      if (other == com.google.bigtable.v2.CheckAndMutateRowRequest.getDefaultInstance())
        return this;
      if (!other.getTableName().isEmpty()) {
        tableName_ = other.tableName_;
        onChanged();
      }
      if (!other.getAppProfileId().isEmpty()) {
        appProfileId_ = other.appProfileId_;
        onChanged();
      }
      if (other.getRowKey() != com.google.protobuf.ByteString.EMPTY) {
        setRowKey(other.getRowKey());
      }
      if (other.hasPredicateFilter()) {
        mergePredicateFilter(other.getPredicateFilter());
      }
      if (trueMutationsBuilder_ == null) {
        if (!other.trueMutations_.isEmpty()) {
          if (trueMutations_.isEmpty()) {
            trueMutations_ = other.trueMutations_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureTrueMutationsIsMutable();
            trueMutations_.addAll(other.trueMutations_);
          }
          onChanged();
        }
      } else {
        if (!other.trueMutations_.isEmpty()) {
          if (trueMutationsBuilder_.isEmpty()) {
            trueMutationsBuilder_.dispose();
            trueMutationsBuilder_ = null;
            trueMutations_ = other.trueMutations_;
            bitField0_ = (bitField0_ & ~0x00000001);
            trueMutationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTrueMutationsFieldBuilder()
                    : null;
          } else {
            trueMutationsBuilder_.addAllMessages(other.trueMutations_);
          }
        }
      }
      if (falseMutationsBuilder_ == null) {
        if (!other.falseMutations_.isEmpty()) {
          if (falseMutations_.isEmpty()) {
            falseMutations_ = other.falseMutations_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureFalseMutationsIsMutable();
            falseMutations_.addAll(other.falseMutations_);
          }
          onChanged();
        }
      } else {
        if (!other.falseMutations_.isEmpty()) {
          if (falseMutationsBuilder_.isEmpty()) {
            falseMutationsBuilder_.dispose();
            falseMutationsBuilder_ = null;
            falseMutations_ = other.falseMutations_;
            bitField0_ = (bitField0_ & ~0x00000002);
            falseMutationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFalseMutationsFieldBuilder()
                    : null;
          } else {
            falseMutationsBuilder_.addAllMessages(other.falseMutations_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.bigtable.v2.CheckAndMutateRowRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.bigtable.v2.CheckAndMutateRowRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object tableName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table to which the conditional mutation should be
     * applied.
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The tableName.
     */
    public java.lang.String getTableName() {
      java.lang.Object ref = tableName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tableName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table to which the conditional mutation should be
     * applied.
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for tableName.
     */
    public com.google.protobuf.ByteString getTableNameBytes() {
      java.lang.Object ref = tableName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        tableName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table to which the conditional mutation should be
     * applied.
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The tableName to set.
     * @return This builder for chaining.
     */
    public Builder setTableName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      tableName_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table to which the conditional mutation should be
     * applied.
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTableName() {

      tableName_ = getDefaultInstance().getTableName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The unique name of the table to which the conditional mutation should be
     * applied.
     * Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`.
     * </pre>
     *
     * <code>
     * string table_name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for tableName to set.
     * @return This builder for chaining.
     */
    public Builder setTableNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      tableName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object appProfileId_ = "";
    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 7;</code>
     *
     * @return The appProfileId.
     */
    public java.lang.String getAppProfileId() {
      java.lang.Object ref = appProfileId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        appProfileId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 7;</code>
     *
     * @return The bytes for appProfileId.
     */
    public com.google.protobuf.ByteString getAppProfileIdBytes() {
      java.lang.Object ref = appProfileId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        appProfileId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 7;</code>
     *
     * @param value The appProfileId to set.
     * @return This builder for chaining.
     */
    public Builder setAppProfileId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      appProfileId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAppProfileId() {

      appProfileId_ = getDefaultInstance().getAppProfileId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This value specifies routing for replication. If not specified, the
     * "default" application profile will be used.
     * </pre>
     *
     * <code>string app_profile_id = 7;</code>
     *
     * @param value The bytes for appProfileId to set.
     * @return This builder for chaining.
     */
    public Builder setAppProfileIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      appProfileId_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.ByteString rowKey_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Required. The key of the row to which the conditional mutation should be applied.
     * </pre>
     *
     * <code>bytes row_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The rowKey.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRowKey() {
      return rowKey_;
    }
    /**
     *
     *
     * <pre>
     * Required. The key of the row to which the conditional mutation should be applied.
     * </pre>
     *
     * <code>bytes row_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The rowKey to set.
     * @return This builder for chaining.
     */
    public Builder setRowKey(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }

      rowKey_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The key of the row to which the conditional mutation should be applied.
     * </pre>
     *
     * <code>bytes row_key = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRowKey() {

      rowKey_ = getDefaultInstance().getRowKey();
      onChanged();
      return this;
    }

    private com.google.bigtable.v2.RowFilter predicateFilter_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.RowFilter,
            com.google.bigtable.v2.RowFilter.Builder,
            com.google.bigtable.v2.RowFilterOrBuilder>
        predicateFilterBuilder_;
    /**
     *
     *
     * <pre>
     * The filter to be applied to the contents of the specified row. Depending
     * on whether or not any results are yielded, either `true_mutations` or
     * `false_mutations` will be executed. If unset, checks that the row contains
     * any values at all.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter predicate_filter = 6;</code>
     *
     * @return Whether the predicateFilter field is set.
     */
    public boolean hasPredicateFilter() {
      return predicateFilterBuilder_ != null || predicateFilter_ != null;
    }
    /**
     *
     *
     * <pre>
     * The filter to be applied to the contents of the specified row. Depending
     * on whether or not any results are yielded, either `true_mutations` or
     * `false_mutations` will be executed. If unset, checks that the row contains
     * any values at all.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter predicate_filter = 6;</code>
     *
     * @return The predicateFilter.
     */
    public com.google.bigtable.v2.RowFilter getPredicateFilter() {
      if (predicateFilterBuilder_ == null) {
        return predicateFilter_ == null
            ? com.google.bigtable.v2.RowFilter.getDefaultInstance()
            : predicateFilter_;
      } else {
        return predicateFilterBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The filter to be applied to the contents of the specified row. Depending
     * on whether or not any results are yielded, either `true_mutations` or
     * `false_mutations` will be executed. If unset, checks that the row contains
     * any values at all.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter predicate_filter = 6;</code>
     */
    public Builder setPredicateFilter(com.google.bigtable.v2.RowFilter value) {
      if (predicateFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        predicateFilter_ = value;
        onChanged();
      } else {
        predicateFilterBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter to be applied to the contents of the specified row. Depending
     * on whether or not any results are yielded, either `true_mutations` or
     * `false_mutations` will be executed. If unset, checks that the row contains
     * any values at all.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter predicate_filter = 6;</code>
     */
    public Builder setPredicateFilter(com.google.bigtable.v2.RowFilter.Builder builderForValue) {
      if (predicateFilterBuilder_ == null) {
        predicateFilter_ = builderForValue.build();
        onChanged();
      } else {
        predicateFilterBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter to be applied to the contents of the specified row. Depending
     * on whether or not any results are yielded, either `true_mutations` or
     * `false_mutations` will be executed. If unset, checks that the row contains
     * any values at all.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter predicate_filter = 6;</code>
     */
    public Builder mergePredicateFilter(com.google.bigtable.v2.RowFilter value) {
      if (predicateFilterBuilder_ == null) {
        if (predicateFilter_ != null) {
          predicateFilter_ =
              com.google.bigtable.v2.RowFilter.newBuilder(predicateFilter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          predicateFilter_ = value;
        }
        onChanged();
      } else {
        predicateFilterBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter to be applied to the contents of the specified row. Depending
     * on whether or not any results are yielded, either `true_mutations` or
     * `false_mutations` will be executed. If unset, checks that the row contains
     * any values at all.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter predicate_filter = 6;</code>
     */
    public Builder clearPredicateFilter() {
      if (predicateFilterBuilder_ == null) {
        predicateFilter_ = null;
        onChanged();
      } else {
        predicateFilter_ = null;
        predicateFilterBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The filter to be applied to the contents of the specified row. Depending
     * on whether or not any results are yielded, either `true_mutations` or
     * `false_mutations` will be executed. If unset, checks that the row contains
     * any values at all.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter predicate_filter = 6;</code>
     */
    public com.google.bigtable.v2.RowFilter.Builder getPredicateFilterBuilder() {

      onChanged();
      return getPredicateFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The filter to be applied to the contents of the specified row. Depending
     * on whether or not any results are yielded, either `true_mutations` or
     * `false_mutations` will be executed. If unset, checks that the row contains
     * any values at all.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter predicate_filter = 6;</code>
     */
    public com.google.bigtable.v2.RowFilterOrBuilder getPredicateFilterOrBuilder() {
      if (predicateFilterBuilder_ != null) {
        return predicateFilterBuilder_.getMessageOrBuilder();
      } else {
        return predicateFilter_ == null
            ? com.google.bigtable.v2.RowFilter.getDefaultInstance()
            : predicateFilter_;
      }
    }
    /**
     *
     *
     * <pre>
     * The filter to be applied to the contents of the specified row. Depending
     * on whether or not any results are yielded, either `true_mutations` or
     * `false_mutations` will be executed. If unset, checks that the row contains
     * any values at all.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter predicate_filter = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.RowFilter,
            com.google.bigtable.v2.RowFilter.Builder,
            com.google.bigtable.v2.RowFilterOrBuilder>
        getPredicateFilterFieldBuilder() {
      if (predicateFilterBuilder_ == null) {
        predicateFilterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.v2.RowFilter,
                com.google.bigtable.v2.RowFilter.Builder,
                com.google.bigtable.v2.RowFilterOrBuilder>(
                getPredicateFilter(), getParentForChildren(), isClean());
        predicateFilter_ = null;
      }
      return predicateFilterBuilder_;
    }

    private java.util.List<com.google.bigtable.v2.Mutation> trueMutations_ =
        java.util.Collections.emptyList();

    private void ensureTrueMutationsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        trueMutations_ = new java.util.ArrayList<com.google.bigtable.v2.Mutation>(trueMutations_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.bigtable.v2.Mutation,
            com.google.bigtable.v2.Mutation.Builder,
            com.google.bigtable.v2.MutationOrBuilder>
        trueMutationsBuilder_;

    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * yields at least one cell when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `false_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation true_mutations = 4;</code>
     */
    public java.util.List<com.google.bigtable.v2.Mutation> getTrueMutationsList() {
      if (trueMutationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(trueMutations_);
      } else {
        return trueMutationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * yields at least one cell when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `false_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation true_mutations = 4;</code>
     */
    public int getTrueMutationsCount() {
      if (trueMutationsBuilder_ == null) {
        return trueMutations_.size();
      } else {
        return trueMutationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * yields at least one cell when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `false_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation true_mutations = 4;</code>
     */
    public com.google.bigtable.v2.Mutation getTrueMutations(int index) {
      if (trueMutationsBuilder_ == null) {
        return trueMutations_.get(index);
      } else {
        return trueMutationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * yields at least one cell when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `false_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation true_mutations = 4;</code>
     */
    public Builder setTrueMutations(int index, com.google.bigtable.v2.Mutation value) {
      if (trueMutationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTrueMutationsIsMutable();
        trueMutations_.set(index, value);
        onChanged();
      } else {
        trueMutationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * yields at least one cell when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `false_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation true_mutations = 4;</code>
     */
    public Builder setTrueMutations(
        int index, com.google.bigtable.v2.Mutation.Builder builderForValue) {
      if (trueMutationsBuilder_ == null) {
        ensureTrueMutationsIsMutable();
        trueMutations_.set(index, builderForValue.build());
        onChanged();
      } else {
        trueMutationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * yields at least one cell when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `false_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation true_mutations = 4;</code>
     */
    public Builder addTrueMutations(com.google.bigtable.v2.Mutation value) {
      if (trueMutationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTrueMutationsIsMutable();
        trueMutations_.add(value);
        onChanged();
      } else {
        trueMutationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * yields at least one cell when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `false_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation true_mutations = 4;</code>
     */
    public Builder addTrueMutations(int index, com.google.bigtable.v2.Mutation value) {
      if (trueMutationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTrueMutationsIsMutable();
        trueMutations_.add(index, value);
        onChanged();
      } else {
        trueMutationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * yields at least one cell when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `false_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation true_mutations = 4;</code>
     */
    public Builder addTrueMutations(com.google.bigtable.v2.Mutation.Builder builderForValue) {
      if (trueMutationsBuilder_ == null) {
        ensureTrueMutationsIsMutable();
        trueMutations_.add(builderForValue.build());
        onChanged();
      } else {
        trueMutationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * yields at least one cell when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `false_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation true_mutations = 4;</code>
     */
    public Builder addTrueMutations(
        int index, com.google.bigtable.v2.Mutation.Builder builderForValue) {
      if (trueMutationsBuilder_ == null) {
        ensureTrueMutationsIsMutable();
        trueMutations_.add(index, builderForValue.build());
        onChanged();
      } else {
        trueMutationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * yields at least one cell when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `false_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation true_mutations = 4;</code>
     */
    public Builder addAllTrueMutations(
        java.lang.Iterable<? extends com.google.bigtable.v2.Mutation> values) {
      if (trueMutationsBuilder_ == null) {
        ensureTrueMutationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, trueMutations_);
        onChanged();
      } else {
        trueMutationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * yields at least one cell when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `false_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation true_mutations = 4;</code>
     */
    public Builder clearTrueMutations() {
      if (trueMutationsBuilder_ == null) {
        trueMutations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        trueMutationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * yields at least one cell when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `false_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation true_mutations = 4;</code>
     */
    public Builder removeTrueMutations(int index) {
      if (trueMutationsBuilder_ == null) {
        ensureTrueMutationsIsMutable();
        trueMutations_.remove(index);
        onChanged();
      } else {
        trueMutationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * yields at least one cell when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `false_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation true_mutations = 4;</code>
     */
    public com.google.bigtable.v2.Mutation.Builder getTrueMutationsBuilder(int index) {
      return getTrueMutationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * yields at least one cell when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `false_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation true_mutations = 4;</code>
     */
    public com.google.bigtable.v2.MutationOrBuilder getTrueMutationsOrBuilder(int index) {
      if (trueMutationsBuilder_ == null) {
        return trueMutations_.get(index);
      } else {
        return trueMutationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * yields at least one cell when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `false_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation true_mutations = 4;</code>
     */
    public java.util.List<? extends com.google.bigtable.v2.MutationOrBuilder>
        getTrueMutationsOrBuilderList() {
      if (trueMutationsBuilder_ != null) {
        return trueMutationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(trueMutations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * yields at least one cell when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `false_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation true_mutations = 4;</code>
     */
    public com.google.bigtable.v2.Mutation.Builder addTrueMutationsBuilder() {
      return getTrueMutationsFieldBuilder()
          .addBuilder(com.google.bigtable.v2.Mutation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * yields at least one cell when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `false_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation true_mutations = 4;</code>
     */
    public com.google.bigtable.v2.Mutation.Builder addTrueMutationsBuilder(int index) {
      return getTrueMutationsFieldBuilder()
          .addBuilder(index, com.google.bigtable.v2.Mutation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * yields at least one cell when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `false_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation true_mutations = 4;</code>
     */
    public java.util.List<com.google.bigtable.v2.Mutation.Builder> getTrueMutationsBuilderList() {
      return getTrueMutationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.bigtable.v2.Mutation,
            com.google.bigtable.v2.Mutation.Builder,
            com.google.bigtable.v2.MutationOrBuilder>
        getTrueMutationsFieldBuilder() {
      if (trueMutationsBuilder_ == null) {
        trueMutationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.bigtable.v2.Mutation,
                com.google.bigtable.v2.Mutation.Builder,
                com.google.bigtable.v2.MutationOrBuilder>(
                trueMutations_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        trueMutations_ = null;
      }
      return trueMutationsBuilder_;
    }

    private java.util.List<com.google.bigtable.v2.Mutation> falseMutations_ =
        java.util.Collections.emptyList();

    private void ensureFalseMutationsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        falseMutations_ = new java.util.ArrayList<com.google.bigtable.v2.Mutation>(falseMutations_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.bigtable.v2.Mutation,
            com.google.bigtable.v2.Mutation.Builder,
            com.google.bigtable.v2.MutationOrBuilder>
        falseMutationsBuilder_;

    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * does not yield any cells when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `true_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation false_mutations = 5;</code>
     */
    public java.util.List<com.google.bigtable.v2.Mutation> getFalseMutationsList() {
      if (falseMutationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(falseMutations_);
      } else {
        return falseMutationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * does not yield any cells when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `true_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation false_mutations = 5;</code>
     */
    public int getFalseMutationsCount() {
      if (falseMutationsBuilder_ == null) {
        return falseMutations_.size();
      } else {
        return falseMutationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * does not yield any cells when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `true_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation false_mutations = 5;</code>
     */
    public com.google.bigtable.v2.Mutation getFalseMutations(int index) {
      if (falseMutationsBuilder_ == null) {
        return falseMutations_.get(index);
      } else {
        return falseMutationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * does not yield any cells when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `true_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation false_mutations = 5;</code>
     */
    public Builder setFalseMutations(int index, com.google.bigtable.v2.Mutation value) {
      if (falseMutationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFalseMutationsIsMutable();
        falseMutations_.set(index, value);
        onChanged();
      } else {
        falseMutationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * does not yield any cells when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `true_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation false_mutations = 5;</code>
     */
    public Builder setFalseMutations(
        int index, com.google.bigtable.v2.Mutation.Builder builderForValue) {
      if (falseMutationsBuilder_ == null) {
        ensureFalseMutationsIsMutable();
        falseMutations_.set(index, builderForValue.build());
        onChanged();
      } else {
        falseMutationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * does not yield any cells when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `true_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation false_mutations = 5;</code>
     */
    public Builder addFalseMutations(com.google.bigtable.v2.Mutation value) {
      if (falseMutationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFalseMutationsIsMutable();
        falseMutations_.add(value);
        onChanged();
      } else {
        falseMutationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * does not yield any cells when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `true_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation false_mutations = 5;</code>
     */
    public Builder addFalseMutations(int index, com.google.bigtable.v2.Mutation value) {
      if (falseMutationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFalseMutationsIsMutable();
        falseMutations_.add(index, value);
        onChanged();
      } else {
        falseMutationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * does not yield any cells when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `true_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation false_mutations = 5;</code>
     */
    public Builder addFalseMutations(com.google.bigtable.v2.Mutation.Builder builderForValue) {
      if (falseMutationsBuilder_ == null) {
        ensureFalseMutationsIsMutable();
        falseMutations_.add(builderForValue.build());
        onChanged();
      } else {
        falseMutationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * does not yield any cells when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `true_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation false_mutations = 5;</code>
     */
    public Builder addFalseMutations(
        int index, com.google.bigtable.v2.Mutation.Builder builderForValue) {
      if (falseMutationsBuilder_ == null) {
        ensureFalseMutationsIsMutable();
        falseMutations_.add(index, builderForValue.build());
        onChanged();
      } else {
        falseMutationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * does not yield any cells when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `true_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation false_mutations = 5;</code>
     */
    public Builder addAllFalseMutations(
        java.lang.Iterable<? extends com.google.bigtable.v2.Mutation> values) {
      if (falseMutationsBuilder_ == null) {
        ensureFalseMutationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, falseMutations_);
        onChanged();
      } else {
        falseMutationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * does not yield any cells when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `true_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation false_mutations = 5;</code>
     */
    public Builder clearFalseMutations() {
      if (falseMutationsBuilder_ == null) {
        falseMutations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        falseMutationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * does not yield any cells when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `true_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation false_mutations = 5;</code>
     */
    public Builder removeFalseMutations(int index) {
      if (falseMutationsBuilder_ == null) {
        ensureFalseMutationsIsMutable();
        falseMutations_.remove(index);
        onChanged();
      } else {
        falseMutationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * does not yield any cells when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `true_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation false_mutations = 5;</code>
     */
    public com.google.bigtable.v2.Mutation.Builder getFalseMutationsBuilder(int index) {
      return getFalseMutationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * does not yield any cells when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `true_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation false_mutations = 5;</code>
     */
    public com.google.bigtable.v2.MutationOrBuilder getFalseMutationsOrBuilder(int index) {
      if (falseMutationsBuilder_ == null) {
        return falseMutations_.get(index);
      } else {
        return falseMutationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * does not yield any cells when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `true_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation false_mutations = 5;</code>
     */
    public java.util.List<? extends com.google.bigtable.v2.MutationOrBuilder>
        getFalseMutationsOrBuilderList() {
      if (falseMutationsBuilder_ != null) {
        return falseMutationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(falseMutations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * does not yield any cells when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `true_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation false_mutations = 5;</code>
     */
    public com.google.bigtable.v2.Mutation.Builder addFalseMutationsBuilder() {
      return getFalseMutationsFieldBuilder()
          .addBuilder(com.google.bigtable.v2.Mutation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * does not yield any cells when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `true_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation false_mutations = 5;</code>
     */
    public com.google.bigtable.v2.Mutation.Builder addFalseMutationsBuilder(int index) {
      return getFalseMutationsFieldBuilder()
          .addBuilder(index, com.google.bigtable.v2.Mutation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Changes to be atomically applied to the specified row if `predicate_filter`
     * does not yield any cells when applied to `row_key`. Entries are applied in
     * order, meaning that earlier mutations can be masked by later ones.
     * Must contain at least one entry if `true_mutations` is empty, and at most
     * 100000.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.Mutation false_mutations = 5;</code>
     */
    public java.util.List<com.google.bigtable.v2.Mutation.Builder> getFalseMutationsBuilderList() {
      return getFalseMutationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.bigtable.v2.Mutation,
            com.google.bigtable.v2.Mutation.Builder,
            com.google.bigtable.v2.MutationOrBuilder>
        getFalseMutationsFieldBuilder() {
      if (falseMutationsBuilder_ == null) {
        falseMutationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.bigtable.v2.Mutation,
                com.google.bigtable.v2.Mutation.Builder,
                com.google.bigtable.v2.MutationOrBuilder>(
                falseMutations_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        falseMutations_ = null;
      }
      return falseMutationsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.v2.CheckAndMutateRowRequest)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.v2.CheckAndMutateRowRequest)
  private static final com.google.bigtable.v2.CheckAndMutateRowRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.v2.CheckAndMutateRowRequest();
  }

  public static com.google.bigtable.v2.CheckAndMutateRowRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CheckAndMutateRowRequest> PARSER =
      new com.google.protobuf.AbstractParser<CheckAndMutateRowRequest>() {
        @java.lang.Override
        public CheckAndMutateRowRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new CheckAndMutateRowRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<CheckAndMutateRowRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CheckAndMutateRowRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.v2.CheckAndMutateRowRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
