/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/v2/data.proto

package com.google.bigtable.v2;

/**
 *
 *
 * <pre>
 * Takes a row as input and produces an alternate view of the row based on
 * specified rules. For example, a RowFilter might trim down a row to include
 * just the cells from columns matching a given regular expression, or might
 * return all the cells of a row but not their values. More complicated filters
 * can be composed out of these components to express requests such as, "within
 * every column of a particular family, give just the two most recent cells
 * which are older than timestamp X."
 * There are two broad categories of RowFilters (true filters and transformers),
 * as well as two ways to compose simple filters into more complex ones
 * (chains and interleaves). They work as follows:
 * * True filters alter the input row by excluding some of its cells wholesale
 * from the output row. An example of a true filter is the `value_regex_filter`,
 * which excludes cells whose values don't match the specified pattern. All
 * regex true filters use RE2 syntax (https://github.com/google/re2/wiki/Syntax)
 * in raw byte mode (RE2::Latin1), and are evaluated as full matches. An
 * important point to keep in mind is that `RE2(.)` is equivalent by default to
 * `RE2([^&#92;n])`, meaning that it does not match newlines. When attempting to
 * match an arbitrary byte, you should therefore use the escape sequence `&#92;C`,
 * which may need to be further escaped as `&#92;&#92;C` in your client language.
 * * Transformers alter the input row by changing the values of some of its
 * cells in the output, without excluding them completely. Currently, the only
 * supported transformer is the `strip_value_transformer`, which replaces every
 * cell's value with the empty string.
 * * Chains and interleaves are described in more detail in the
 * RowFilter.Chain and RowFilter.Interleave documentation.
 * The total serialized size of a RowFilter message must not
 * exceed 4096 bytes, and RowFilters may not be nested within each other
 * (in Chains or Interleaves) to a depth of more than 20.
 * </pre>
 *
 * Protobuf type {@code google.bigtable.v2.RowFilter}
 */
public final class RowFilter extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.v2.RowFilter)
    RowFilterOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RowFilter.newBuilder() to construct.
  private RowFilter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RowFilter() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RowFilter();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private RowFilter(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.bigtable.v2.RowFilter.Chain.Builder subBuilder = null;
              if (filterCase_ == 1) {
                subBuilder = ((com.google.bigtable.v2.RowFilter.Chain) filter_).toBuilder();
              }
              filter_ =
                  input.readMessage(
                      com.google.bigtable.v2.RowFilter.Chain.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.bigtable.v2.RowFilter.Chain) filter_);
                filter_ = subBuilder.buildPartial();
              }
              filterCase_ = 1;
              break;
            }
          case 18:
            {
              com.google.bigtable.v2.RowFilter.Interleave.Builder subBuilder = null;
              if (filterCase_ == 2) {
                subBuilder = ((com.google.bigtable.v2.RowFilter.Interleave) filter_).toBuilder();
              }
              filter_ =
                  input.readMessage(
                      com.google.bigtable.v2.RowFilter.Interleave.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.bigtable.v2.RowFilter.Interleave) filter_);
                filter_ = subBuilder.buildPartial();
              }
              filterCase_ = 2;
              break;
            }
          case 26:
            {
              com.google.bigtable.v2.RowFilter.Condition.Builder subBuilder = null;
              if (filterCase_ == 3) {
                subBuilder = ((com.google.bigtable.v2.RowFilter.Condition) filter_).toBuilder();
              }
              filter_ =
                  input.readMessage(
                      com.google.bigtable.v2.RowFilter.Condition.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.bigtable.v2.RowFilter.Condition) filter_);
                filter_ = subBuilder.buildPartial();
              }
              filterCase_ = 3;
              break;
            }
          case 34:
            {
              filterCase_ = 4;
              filter_ = input.readBytes();
              break;
            }
          case 42:
            {
              java.lang.String s = input.readStringRequireUtf8();
              filterCase_ = 5;
              filter_ = s;
              break;
            }
          case 50:
            {
              filterCase_ = 6;
              filter_ = input.readBytes();
              break;
            }
          case 58:
            {
              com.google.bigtable.v2.ColumnRange.Builder subBuilder = null;
              if (filterCase_ == 7) {
                subBuilder = ((com.google.bigtable.v2.ColumnRange) filter_).toBuilder();
              }
              filter_ =
                  input.readMessage(com.google.bigtable.v2.ColumnRange.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.bigtable.v2.ColumnRange) filter_);
                filter_ = subBuilder.buildPartial();
              }
              filterCase_ = 7;
              break;
            }
          case 66:
            {
              com.google.bigtable.v2.TimestampRange.Builder subBuilder = null;
              if (filterCase_ == 8) {
                subBuilder = ((com.google.bigtable.v2.TimestampRange) filter_).toBuilder();
              }
              filter_ =
                  input.readMessage(
                      com.google.bigtable.v2.TimestampRange.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.bigtable.v2.TimestampRange) filter_);
                filter_ = subBuilder.buildPartial();
              }
              filterCase_ = 8;
              break;
            }
          case 74:
            {
              filterCase_ = 9;
              filter_ = input.readBytes();
              break;
            }
          case 80:
            {
              filterCase_ = 10;
              filter_ = input.readInt32();
              break;
            }
          case 88:
            {
              filterCase_ = 11;
              filter_ = input.readInt32();
              break;
            }
          case 96:
            {
              filterCase_ = 12;
              filter_ = input.readInt32();
              break;
            }
          case 104:
            {
              filterCase_ = 13;
              filter_ = input.readBool();
              break;
            }
          case 113:
            {
              filterCase_ = 14;
              filter_ = input.readDouble();
              break;
            }
          case 122:
            {
              com.google.bigtable.v2.ValueRange.Builder subBuilder = null;
              if (filterCase_ == 15) {
                subBuilder = ((com.google.bigtable.v2.ValueRange) filter_).toBuilder();
              }
              filter_ =
                  input.readMessage(com.google.bigtable.v2.ValueRange.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.bigtable.v2.ValueRange) filter_);
                filter_ = subBuilder.buildPartial();
              }
              filterCase_ = 15;
              break;
            }
          case 128:
            {
              filterCase_ = 16;
              filter_ = input.readBool();
              break;
            }
          case 136:
            {
              filterCase_ = 17;
              filter_ = input.readBool();
              break;
            }
          case 144:
            {
              filterCase_ = 18;
              filter_ = input.readBool();
              break;
            }
          case 154:
            {
              java.lang.String s = input.readStringRequireUtf8();
              filterCase_ = 19;
              filter_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.v2.DataProto.internal_static_google_bigtable_v2_RowFilter_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.v2.DataProto
        .internal_static_google_bigtable_v2_RowFilter_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.v2.RowFilter.class, com.google.bigtable.v2.RowFilter.Builder.class);
  }

  public interface ChainOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.v2.RowFilter.Chain)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The elements of "filters" are chained together to process the input row:
     * in row -&gt; f(0) -&gt; intermediate row -&gt; f(1) -&gt; ... -&gt; f(N) -&gt; out row
     * The full chain is executed atomically.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
     */
    java.util.List<com.google.bigtable.v2.RowFilter> getFiltersList();
    /**
     *
     *
     * <pre>
     * The elements of "filters" are chained together to process the input row:
     * in row -&gt; f(0) -&gt; intermediate row -&gt; f(1) -&gt; ... -&gt; f(N) -&gt; out row
     * The full chain is executed atomically.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
     */
    com.google.bigtable.v2.RowFilter getFilters(int index);
    /**
     *
     *
     * <pre>
     * The elements of "filters" are chained together to process the input row:
     * in row -&gt; f(0) -&gt; intermediate row -&gt; f(1) -&gt; ... -&gt; f(N) -&gt; out row
     * The full chain is executed atomically.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
     */
    int getFiltersCount();
    /**
     *
     *
     * <pre>
     * The elements of "filters" are chained together to process the input row:
     * in row -&gt; f(0) -&gt; intermediate row -&gt; f(1) -&gt; ... -&gt; f(N) -&gt; out row
     * The full chain is executed atomically.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
     */
    java.util.List<? extends com.google.bigtable.v2.RowFilterOrBuilder> getFiltersOrBuilderList();
    /**
     *
     *
     * <pre>
     * The elements of "filters" are chained together to process the input row:
     * in row -&gt; f(0) -&gt; intermediate row -&gt; f(1) -&gt; ... -&gt; f(N) -&gt; out row
     * The full chain is executed atomically.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
     */
    com.google.bigtable.v2.RowFilterOrBuilder getFiltersOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * A RowFilter which sends rows through several RowFilters in sequence.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.RowFilter.Chain}
   */
  public static final class Chain extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.v2.RowFilter.Chain)
      ChainOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Chain.newBuilder() to construct.
    private Chain(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Chain() {
      filters_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Chain();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Chain(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  filters_ = new java.util.ArrayList<com.google.bigtable.v2.RowFilter>();
                  mutable_bitField0_ |= 0x00000001;
                }
                filters_.add(
                    input.readMessage(
                        com.google.bigtable.v2.RowFilter.parser(), extensionRegistry));
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          filters_ = java.util.Collections.unmodifiableList(filters_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.DataProto
          .internal_static_google_bigtable_v2_RowFilter_Chain_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.DataProto
          .internal_static_google_bigtable_v2_RowFilter_Chain_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.RowFilter.Chain.class,
              com.google.bigtable.v2.RowFilter.Chain.Builder.class);
    }

    public static final int FILTERS_FIELD_NUMBER = 1;
    private java.util.List<com.google.bigtable.v2.RowFilter> filters_;
    /**
     *
     *
     * <pre>
     * The elements of "filters" are chained together to process the input row:
     * in row -&gt; f(0) -&gt; intermediate row -&gt; f(1) -&gt; ... -&gt; f(N) -&gt; out row
     * The full chain is executed atomically.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.bigtable.v2.RowFilter> getFiltersList() {
      return filters_;
    }
    /**
     *
     *
     * <pre>
     * The elements of "filters" are chained together to process the input row:
     * in row -&gt; f(0) -&gt; intermediate row -&gt; f(1) -&gt; ... -&gt; f(N) -&gt; out row
     * The full chain is executed atomically.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.bigtable.v2.RowFilterOrBuilder>
        getFiltersOrBuilderList() {
      return filters_;
    }
    /**
     *
     *
     * <pre>
     * The elements of "filters" are chained together to process the input row:
     * in row -&gt; f(0) -&gt; intermediate row -&gt; f(1) -&gt; ... -&gt; f(N) -&gt; out row
     * The full chain is executed atomically.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
     */
    @java.lang.Override
    public int getFiltersCount() {
      return filters_.size();
    }
    /**
     *
     *
     * <pre>
     * The elements of "filters" are chained together to process the input row:
     * in row -&gt; f(0) -&gt; intermediate row -&gt; f(1) -&gt; ... -&gt; f(N) -&gt; out row
     * The full chain is executed atomically.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.RowFilter getFilters(int index) {
      return filters_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The elements of "filters" are chained together to process the input row:
     * in row -&gt; f(0) -&gt; intermediate row -&gt; f(1) -&gt; ... -&gt; f(N) -&gt; out row
     * The full chain is executed atomically.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.RowFilterOrBuilder getFiltersOrBuilder(int index) {
      return filters_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < filters_.size(); i++) {
        output.writeMessage(1, filters_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < filters_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, filters_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.v2.RowFilter.Chain)) {
        return super.equals(obj);
      }
      com.google.bigtable.v2.RowFilter.Chain other = (com.google.bigtable.v2.RowFilter.Chain) obj;

      if (!getFiltersList().equals(other.getFiltersList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getFiltersCount() > 0) {
        hash = (37 * hash) + FILTERS_FIELD_NUMBER;
        hash = (53 * hash) + getFiltersList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.v2.RowFilter.Chain parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.RowFilter.Chain parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.RowFilter.Chain parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.RowFilter.Chain parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.RowFilter.Chain parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.RowFilter.Chain parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.RowFilter.Chain parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.RowFilter.Chain parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.RowFilter.Chain parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.RowFilter.Chain parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.RowFilter.Chain parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.RowFilter.Chain parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.v2.RowFilter.Chain prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A RowFilter which sends rows through several RowFilters in sequence.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.v2.RowFilter.Chain}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.v2.RowFilter.Chain)
        com.google.bigtable.v2.RowFilter.ChainOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.v2.DataProto
            .internal_static_google_bigtable_v2_RowFilter_Chain_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.v2.DataProto
            .internal_static_google_bigtable_v2_RowFilter_Chain_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.v2.RowFilter.Chain.class,
                com.google.bigtable.v2.RowFilter.Chain.Builder.class);
      }

      // Construct using com.google.bigtable.v2.RowFilter.Chain.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getFiltersFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (filtersBuilder_ == null) {
          filters_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          filtersBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.v2.DataProto
            .internal_static_google_bigtable_v2_RowFilter_Chain_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.v2.RowFilter.Chain getDefaultInstanceForType() {
        return com.google.bigtable.v2.RowFilter.Chain.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.v2.RowFilter.Chain build() {
        com.google.bigtable.v2.RowFilter.Chain result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.v2.RowFilter.Chain buildPartial() {
        com.google.bigtable.v2.RowFilter.Chain result =
            new com.google.bigtable.v2.RowFilter.Chain(this);
        int from_bitField0_ = bitField0_;
        if (filtersBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            filters_ = java.util.Collections.unmodifiableList(filters_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.filters_ = filters_;
        } else {
          result.filters_ = filtersBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.v2.RowFilter.Chain) {
          return mergeFrom((com.google.bigtable.v2.RowFilter.Chain) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.v2.RowFilter.Chain other) {
        if (other == com.google.bigtable.v2.RowFilter.Chain.getDefaultInstance()) return this;
        if (filtersBuilder_ == null) {
          if (!other.filters_.isEmpty()) {
            if (filters_.isEmpty()) {
              filters_ = other.filters_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureFiltersIsMutable();
              filters_.addAll(other.filters_);
            }
            onChanged();
          }
        } else {
          if (!other.filters_.isEmpty()) {
            if (filtersBuilder_.isEmpty()) {
              filtersBuilder_.dispose();
              filtersBuilder_ = null;
              filters_ = other.filters_;
              bitField0_ = (bitField0_ & ~0x00000001);
              filtersBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getFiltersFieldBuilder()
                      : null;
            } else {
              filtersBuilder_.addAllMessages(other.filters_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.bigtable.v2.RowFilter.Chain parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.bigtable.v2.RowFilter.Chain) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.bigtable.v2.RowFilter> filters_ =
          java.util.Collections.emptyList();

      private void ensureFiltersIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          filters_ = new java.util.ArrayList<com.google.bigtable.v2.RowFilter>(filters_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.bigtable.v2.RowFilter,
              com.google.bigtable.v2.RowFilter.Builder,
              com.google.bigtable.v2.RowFilterOrBuilder>
          filtersBuilder_;

      /**
       *
       *
       * <pre>
       * The elements of "filters" are chained together to process the input row:
       * in row -&gt; f(0) -&gt; intermediate row -&gt; f(1) -&gt; ... -&gt; f(N) -&gt; out row
       * The full chain is executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public java.util.List<com.google.bigtable.v2.RowFilter> getFiltersList() {
        if (filtersBuilder_ == null) {
          return java.util.Collections.unmodifiableList(filters_);
        } else {
          return filtersBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" are chained together to process the input row:
       * in row -&gt; f(0) -&gt; intermediate row -&gt; f(1) -&gt; ... -&gt; f(N) -&gt; out row
       * The full chain is executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public int getFiltersCount() {
        if (filtersBuilder_ == null) {
          return filters_.size();
        } else {
          return filtersBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" are chained together to process the input row:
       * in row -&gt; f(0) -&gt; intermediate row -&gt; f(1) -&gt; ... -&gt; f(N) -&gt; out row
       * The full chain is executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public com.google.bigtable.v2.RowFilter getFilters(int index) {
        if (filtersBuilder_ == null) {
          return filters_.get(index);
        } else {
          return filtersBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" are chained together to process the input row:
       * in row -&gt; f(0) -&gt; intermediate row -&gt; f(1) -&gt; ... -&gt; f(N) -&gt; out row
       * The full chain is executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public Builder setFilters(int index, com.google.bigtable.v2.RowFilter value) {
        if (filtersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFiltersIsMutable();
          filters_.set(index, value);
          onChanged();
        } else {
          filtersBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" are chained together to process the input row:
       * in row -&gt; f(0) -&gt; intermediate row -&gt; f(1) -&gt; ... -&gt; f(N) -&gt; out row
       * The full chain is executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public Builder setFilters(
          int index, com.google.bigtable.v2.RowFilter.Builder builderForValue) {
        if (filtersBuilder_ == null) {
          ensureFiltersIsMutable();
          filters_.set(index, builderForValue.build());
          onChanged();
        } else {
          filtersBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" are chained together to process the input row:
       * in row -&gt; f(0) -&gt; intermediate row -&gt; f(1) -&gt; ... -&gt; f(N) -&gt; out row
       * The full chain is executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public Builder addFilters(com.google.bigtable.v2.RowFilter value) {
        if (filtersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFiltersIsMutable();
          filters_.add(value);
          onChanged();
        } else {
          filtersBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" are chained together to process the input row:
       * in row -&gt; f(0) -&gt; intermediate row -&gt; f(1) -&gt; ... -&gt; f(N) -&gt; out row
       * The full chain is executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public Builder addFilters(int index, com.google.bigtable.v2.RowFilter value) {
        if (filtersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFiltersIsMutable();
          filters_.add(index, value);
          onChanged();
        } else {
          filtersBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" are chained together to process the input row:
       * in row -&gt; f(0) -&gt; intermediate row -&gt; f(1) -&gt; ... -&gt; f(N) -&gt; out row
       * The full chain is executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public Builder addFilters(com.google.bigtable.v2.RowFilter.Builder builderForValue) {
        if (filtersBuilder_ == null) {
          ensureFiltersIsMutable();
          filters_.add(builderForValue.build());
          onChanged();
        } else {
          filtersBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" are chained together to process the input row:
       * in row -&gt; f(0) -&gt; intermediate row -&gt; f(1) -&gt; ... -&gt; f(N) -&gt; out row
       * The full chain is executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public Builder addFilters(
          int index, com.google.bigtable.v2.RowFilter.Builder builderForValue) {
        if (filtersBuilder_ == null) {
          ensureFiltersIsMutable();
          filters_.add(index, builderForValue.build());
          onChanged();
        } else {
          filtersBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" are chained together to process the input row:
       * in row -&gt; f(0) -&gt; intermediate row -&gt; f(1) -&gt; ... -&gt; f(N) -&gt; out row
       * The full chain is executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public Builder addAllFilters(
          java.lang.Iterable<? extends com.google.bigtable.v2.RowFilter> values) {
        if (filtersBuilder_ == null) {
          ensureFiltersIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, filters_);
          onChanged();
        } else {
          filtersBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" are chained together to process the input row:
       * in row -&gt; f(0) -&gt; intermediate row -&gt; f(1) -&gt; ... -&gt; f(N) -&gt; out row
       * The full chain is executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public Builder clearFilters() {
        if (filtersBuilder_ == null) {
          filters_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          filtersBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" are chained together to process the input row:
       * in row -&gt; f(0) -&gt; intermediate row -&gt; f(1) -&gt; ... -&gt; f(N) -&gt; out row
       * The full chain is executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public Builder removeFilters(int index) {
        if (filtersBuilder_ == null) {
          ensureFiltersIsMutable();
          filters_.remove(index);
          onChanged();
        } else {
          filtersBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" are chained together to process the input row:
       * in row -&gt; f(0) -&gt; intermediate row -&gt; f(1) -&gt; ... -&gt; f(N) -&gt; out row
       * The full chain is executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public com.google.bigtable.v2.RowFilter.Builder getFiltersBuilder(int index) {
        return getFiltersFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" are chained together to process the input row:
       * in row -&gt; f(0) -&gt; intermediate row -&gt; f(1) -&gt; ... -&gt; f(N) -&gt; out row
       * The full chain is executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public com.google.bigtable.v2.RowFilterOrBuilder getFiltersOrBuilder(int index) {
        if (filtersBuilder_ == null) {
          return filters_.get(index);
        } else {
          return filtersBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" are chained together to process the input row:
       * in row -&gt; f(0) -&gt; intermediate row -&gt; f(1) -&gt; ... -&gt; f(N) -&gt; out row
       * The full chain is executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public java.util.List<? extends com.google.bigtable.v2.RowFilterOrBuilder>
          getFiltersOrBuilderList() {
        if (filtersBuilder_ != null) {
          return filtersBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(filters_);
        }
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" are chained together to process the input row:
       * in row -&gt; f(0) -&gt; intermediate row -&gt; f(1) -&gt; ... -&gt; f(N) -&gt; out row
       * The full chain is executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public com.google.bigtable.v2.RowFilter.Builder addFiltersBuilder() {
        return getFiltersFieldBuilder()
            .addBuilder(com.google.bigtable.v2.RowFilter.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" are chained together to process the input row:
       * in row -&gt; f(0) -&gt; intermediate row -&gt; f(1) -&gt; ... -&gt; f(N) -&gt; out row
       * The full chain is executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public com.google.bigtable.v2.RowFilter.Builder addFiltersBuilder(int index) {
        return getFiltersFieldBuilder()
            .addBuilder(index, com.google.bigtable.v2.RowFilter.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" are chained together to process the input row:
       * in row -&gt; f(0) -&gt; intermediate row -&gt; f(1) -&gt; ... -&gt; f(N) -&gt; out row
       * The full chain is executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public java.util.List<com.google.bigtable.v2.RowFilter.Builder> getFiltersBuilderList() {
        return getFiltersFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.bigtable.v2.RowFilter,
              com.google.bigtable.v2.RowFilter.Builder,
              com.google.bigtable.v2.RowFilterOrBuilder>
          getFiltersFieldBuilder() {
        if (filtersBuilder_ == null) {
          filtersBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.bigtable.v2.RowFilter,
                  com.google.bigtable.v2.RowFilter.Builder,
                  com.google.bigtable.v2.RowFilterOrBuilder>(
                  filters_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          filters_ = null;
        }
        return filtersBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.v2.RowFilter.Chain)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.v2.RowFilter.Chain)
    private static final com.google.bigtable.v2.RowFilter.Chain DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.v2.RowFilter.Chain();
    }

    public static com.google.bigtable.v2.RowFilter.Chain getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Chain> PARSER =
        new com.google.protobuf.AbstractParser<Chain>() {
          @java.lang.Override
          public Chain parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Chain(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Chain> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Chain> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.v2.RowFilter.Chain getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface InterleaveOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.v2.RowFilter.Interleave)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The elements of "filters" all process a copy of the input row, and the
     * results are pooled, sorted, and combined into a single output row.
     * If multiple cells are produced with the same column and timestamp,
     * they will all appear in the output row in an unspecified mutual order.
     * Consider the following example, with three filters:
     *                                  input row
     *                                      |
     *            -----------------------------------------------------
     *            |                         |                         |
     *           f(0)                      f(1)                      f(2)
     *            |                         |                         |
     *     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
     *     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
     *            |                         |                         |
     *            -----------------------------------------------------
     *                                      |
     *     1:                      foo,bar,10,z   // could have switched with #2
     *     2:                      foo,bar,10,x   // could have switched with #1
     *     3:                      foo,blah,11,z
     *     4:                      far,bar,7,a
     *     5:                      far,blah,5,x   // identical to #6
     *     6:                      far,blah,5,x   // identical to #5
     * All interleaved filters are executed atomically.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
     */
    java.util.List<com.google.bigtable.v2.RowFilter> getFiltersList();
    /**
     *
     *
     * <pre>
     * The elements of "filters" all process a copy of the input row, and the
     * results are pooled, sorted, and combined into a single output row.
     * If multiple cells are produced with the same column and timestamp,
     * they will all appear in the output row in an unspecified mutual order.
     * Consider the following example, with three filters:
     *                                  input row
     *                                      |
     *            -----------------------------------------------------
     *            |                         |                         |
     *           f(0)                      f(1)                      f(2)
     *            |                         |                         |
     *     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
     *     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
     *            |                         |                         |
     *            -----------------------------------------------------
     *                                      |
     *     1:                      foo,bar,10,z   // could have switched with #2
     *     2:                      foo,bar,10,x   // could have switched with #1
     *     3:                      foo,blah,11,z
     *     4:                      far,bar,7,a
     *     5:                      far,blah,5,x   // identical to #6
     *     6:                      far,blah,5,x   // identical to #5
     * All interleaved filters are executed atomically.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
     */
    com.google.bigtable.v2.RowFilter getFilters(int index);
    /**
     *
     *
     * <pre>
     * The elements of "filters" all process a copy of the input row, and the
     * results are pooled, sorted, and combined into a single output row.
     * If multiple cells are produced with the same column and timestamp,
     * they will all appear in the output row in an unspecified mutual order.
     * Consider the following example, with three filters:
     *                                  input row
     *                                      |
     *            -----------------------------------------------------
     *            |                         |                         |
     *           f(0)                      f(1)                      f(2)
     *            |                         |                         |
     *     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
     *     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
     *            |                         |                         |
     *            -----------------------------------------------------
     *                                      |
     *     1:                      foo,bar,10,z   // could have switched with #2
     *     2:                      foo,bar,10,x   // could have switched with #1
     *     3:                      foo,blah,11,z
     *     4:                      far,bar,7,a
     *     5:                      far,blah,5,x   // identical to #6
     *     6:                      far,blah,5,x   // identical to #5
     * All interleaved filters are executed atomically.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
     */
    int getFiltersCount();
    /**
     *
     *
     * <pre>
     * The elements of "filters" all process a copy of the input row, and the
     * results are pooled, sorted, and combined into a single output row.
     * If multiple cells are produced with the same column and timestamp,
     * they will all appear in the output row in an unspecified mutual order.
     * Consider the following example, with three filters:
     *                                  input row
     *                                      |
     *            -----------------------------------------------------
     *            |                         |                         |
     *           f(0)                      f(1)                      f(2)
     *            |                         |                         |
     *     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
     *     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
     *            |                         |                         |
     *            -----------------------------------------------------
     *                                      |
     *     1:                      foo,bar,10,z   // could have switched with #2
     *     2:                      foo,bar,10,x   // could have switched with #1
     *     3:                      foo,blah,11,z
     *     4:                      far,bar,7,a
     *     5:                      far,blah,5,x   // identical to #6
     *     6:                      far,blah,5,x   // identical to #5
     * All interleaved filters are executed atomically.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
     */
    java.util.List<? extends com.google.bigtable.v2.RowFilterOrBuilder> getFiltersOrBuilderList();
    /**
     *
     *
     * <pre>
     * The elements of "filters" all process a copy of the input row, and the
     * results are pooled, sorted, and combined into a single output row.
     * If multiple cells are produced with the same column and timestamp,
     * they will all appear in the output row in an unspecified mutual order.
     * Consider the following example, with three filters:
     *                                  input row
     *                                      |
     *            -----------------------------------------------------
     *            |                         |                         |
     *           f(0)                      f(1)                      f(2)
     *            |                         |                         |
     *     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
     *     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
     *            |                         |                         |
     *            -----------------------------------------------------
     *                                      |
     *     1:                      foo,bar,10,z   // could have switched with #2
     *     2:                      foo,bar,10,x   // could have switched with #1
     *     3:                      foo,blah,11,z
     *     4:                      far,bar,7,a
     *     5:                      far,blah,5,x   // identical to #6
     *     6:                      far,blah,5,x   // identical to #5
     * All interleaved filters are executed atomically.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
     */
    com.google.bigtable.v2.RowFilterOrBuilder getFiltersOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * A RowFilter which sends each row to each of several component
   * RowFilters and interleaves the results.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.RowFilter.Interleave}
   */
  public static final class Interleave extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.v2.RowFilter.Interleave)
      InterleaveOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Interleave.newBuilder() to construct.
    private Interleave(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Interleave() {
      filters_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Interleave();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Interleave(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  filters_ = new java.util.ArrayList<com.google.bigtable.v2.RowFilter>();
                  mutable_bitField0_ |= 0x00000001;
                }
                filters_.add(
                    input.readMessage(
                        com.google.bigtable.v2.RowFilter.parser(), extensionRegistry));
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          filters_ = java.util.Collections.unmodifiableList(filters_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.DataProto
          .internal_static_google_bigtable_v2_RowFilter_Interleave_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.DataProto
          .internal_static_google_bigtable_v2_RowFilter_Interleave_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.RowFilter.Interleave.class,
              com.google.bigtable.v2.RowFilter.Interleave.Builder.class);
    }

    public static final int FILTERS_FIELD_NUMBER = 1;
    private java.util.List<com.google.bigtable.v2.RowFilter> filters_;
    /**
     *
     *
     * <pre>
     * The elements of "filters" all process a copy of the input row, and the
     * results are pooled, sorted, and combined into a single output row.
     * If multiple cells are produced with the same column and timestamp,
     * they will all appear in the output row in an unspecified mutual order.
     * Consider the following example, with three filters:
     *                                  input row
     *                                      |
     *            -----------------------------------------------------
     *            |                         |                         |
     *           f(0)                      f(1)                      f(2)
     *            |                         |                         |
     *     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
     *     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
     *            |                         |                         |
     *            -----------------------------------------------------
     *                                      |
     *     1:                      foo,bar,10,z   // could have switched with #2
     *     2:                      foo,bar,10,x   // could have switched with #1
     *     3:                      foo,blah,11,z
     *     4:                      far,bar,7,a
     *     5:                      far,blah,5,x   // identical to #6
     *     6:                      far,blah,5,x   // identical to #5
     * All interleaved filters are executed atomically.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.bigtable.v2.RowFilter> getFiltersList() {
      return filters_;
    }
    /**
     *
     *
     * <pre>
     * The elements of "filters" all process a copy of the input row, and the
     * results are pooled, sorted, and combined into a single output row.
     * If multiple cells are produced with the same column and timestamp,
     * they will all appear in the output row in an unspecified mutual order.
     * Consider the following example, with three filters:
     *                                  input row
     *                                      |
     *            -----------------------------------------------------
     *            |                         |                         |
     *           f(0)                      f(1)                      f(2)
     *            |                         |                         |
     *     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
     *     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
     *            |                         |                         |
     *            -----------------------------------------------------
     *                                      |
     *     1:                      foo,bar,10,z   // could have switched with #2
     *     2:                      foo,bar,10,x   // could have switched with #1
     *     3:                      foo,blah,11,z
     *     4:                      far,bar,7,a
     *     5:                      far,blah,5,x   // identical to #6
     *     6:                      far,blah,5,x   // identical to #5
     * All interleaved filters are executed atomically.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.bigtable.v2.RowFilterOrBuilder>
        getFiltersOrBuilderList() {
      return filters_;
    }
    /**
     *
     *
     * <pre>
     * The elements of "filters" all process a copy of the input row, and the
     * results are pooled, sorted, and combined into a single output row.
     * If multiple cells are produced with the same column and timestamp,
     * they will all appear in the output row in an unspecified mutual order.
     * Consider the following example, with three filters:
     *                                  input row
     *                                      |
     *            -----------------------------------------------------
     *            |                         |                         |
     *           f(0)                      f(1)                      f(2)
     *            |                         |                         |
     *     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
     *     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
     *            |                         |                         |
     *            -----------------------------------------------------
     *                                      |
     *     1:                      foo,bar,10,z   // could have switched with #2
     *     2:                      foo,bar,10,x   // could have switched with #1
     *     3:                      foo,blah,11,z
     *     4:                      far,bar,7,a
     *     5:                      far,blah,5,x   // identical to #6
     *     6:                      far,blah,5,x   // identical to #5
     * All interleaved filters are executed atomically.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
     */
    @java.lang.Override
    public int getFiltersCount() {
      return filters_.size();
    }
    /**
     *
     *
     * <pre>
     * The elements of "filters" all process a copy of the input row, and the
     * results are pooled, sorted, and combined into a single output row.
     * If multiple cells are produced with the same column and timestamp,
     * they will all appear in the output row in an unspecified mutual order.
     * Consider the following example, with three filters:
     *                                  input row
     *                                      |
     *            -----------------------------------------------------
     *            |                         |                         |
     *           f(0)                      f(1)                      f(2)
     *            |                         |                         |
     *     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
     *     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
     *            |                         |                         |
     *            -----------------------------------------------------
     *                                      |
     *     1:                      foo,bar,10,z   // could have switched with #2
     *     2:                      foo,bar,10,x   // could have switched with #1
     *     3:                      foo,blah,11,z
     *     4:                      far,bar,7,a
     *     5:                      far,blah,5,x   // identical to #6
     *     6:                      far,blah,5,x   // identical to #5
     * All interleaved filters are executed atomically.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.RowFilter getFilters(int index) {
      return filters_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The elements of "filters" all process a copy of the input row, and the
     * results are pooled, sorted, and combined into a single output row.
     * If multiple cells are produced with the same column and timestamp,
     * they will all appear in the output row in an unspecified mutual order.
     * Consider the following example, with three filters:
     *                                  input row
     *                                      |
     *            -----------------------------------------------------
     *            |                         |                         |
     *           f(0)                      f(1)                      f(2)
     *            |                         |                         |
     *     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
     *     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
     *            |                         |                         |
     *            -----------------------------------------------------
     *                                      |
     *     1:                      foo,bar,10,z   // could have switched with #2
     *     2:                      foo,bar,10,x   // could have switched with #1
     *     3:                      foo,blah,11,z
     *     4:                      far,bar,7,a
     *     5:                      far,blah,5,x   // identical to #6
     *     6:                      far,blah,5,x   // identical to #5
     * All interleaved filters are executed atomically.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.RowFilterOrBuilder getFiltersOrBuilder(int index) {
      return filters_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < filters_.size(); i++) {
        output.writeMessage(1, filters_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < filters_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, filters_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.v2.RowFilter.Interleave)) {
        return super.equals(obj);
      }
      com.google.bigtable.v2.RowFilter.Interleave other =
          (com.google.bigtable.v2.RowFilter.Interleave) obj;

      if (!getFiltersList().equals(other.getFiltersList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getFiltersCount() > 0) {
        hash = (37 * hash) + FILTERS_FIELD_NUMBER;
        hash = (53 * hash) + getFiltersList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.v2.RowFilter.Interleave parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.RowFilter.Interleave parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.RowFilter.Interleave parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.RowFilter.Interleave parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.RowFilter.Interleave parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.RowFilter.Interleave parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.RowFilter.Interleave parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.RowFilter.Interleave parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.RowFilter.Interleave parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.RowFilter.Interleave parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.RowFilter.Interleave parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.RowFilter.Interleave parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.v2.RowFilter.Interleave prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A RowFilter which sends each row to each of several component
     * RowFilters and interleaves the results.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.v2.RowFilter.Interleave}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.v2.RowFilter.Interleave)
        com.google.bigtable.v2.RowFilter.InterleaveOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.v2.DataProto
            .internal_static_google_bigtable_v2_RowFilter_Interleave_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.v2.DataProto
            .internal_static_google_bigtable_v2_RowFilter_Interleave_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.v2.RowFilter.Interleave.class,
                com.google.bigtable.v2.RowFilter.Interleave.Builder.class);
      }

      // Construct using com.google.bigtable.v2.RowFilter.Interleave.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getFiltersFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (filtersBuilder_ == null) {
          filters_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          filtersBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.v2.DataProto
            .internal_static_google_bigtable_v2_RowFilter_Interleave_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.v2.RowFilter.Interleave getDefaultInstanceForType() {
        return com.google.bigtable.v2.RowFilter.Interleave.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.v2.RowFilter.Interleave build() {
        com.google.bigtable.v2.RowFilter.Interleave result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.v2.RowFilter.Interleave buildPartial() {
        com.google.bigtable.v2.RowFilter.Interleave result =
            new com.google.bigtable.v2.RowFilter.Interleave(this);
        int from_bitField0_ = bitField0_;
        if (filtersBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            filters_ = java.util.Collections.unmodifiableList(filters_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.filters_ = filters_;
        } else {
          result.filters_ = filtersBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.v2.RowFilter.Interleave) {
          return mergeFrom((com.google.bigtable.v2.RowFilter.Interleave) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.v2.RowFilter.Interleave other) {
        if (other == com.google.bigtable.v2.RowFilter.Interleave.getDefaultInstance()) return this;
        if (filtersBuilder_ == null) {
          if (!other.filters_.isEmpty()) {
            if (filters_.isEmpty()) {
              filters_ = other.filters_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureFiltersIsMutable();
              filters_.addAll(other.filters_);
            }
            onChanged();
          }
        } else {
          if (!other.filters_.isEmpty()) {
            if (filtersBuilder_.isEmpty()) {
              filtersBuilder_.dispose();
              filtersBuilder_ = null;
              filters_ = other.filters_;
              bitField0_ = (bitField0_ & ~0x00000001);
              filtersBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getFiltersFieldBuilder()
                      : null;
            } else {
              filtersBuilder_.addAllMessages(other.filters_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.bigtable.v2.RowFilter.Interleave parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.bigtable.v2.RowFilter.Interleave) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.bigtable.v2.RowFilter> filters_ =
          java.util.Collections.emptyList();

      private void ensureFiltersIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          filters_ = new java.util.ArrayList<com.google.bigtable.v2.RowFilter>(filters_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.bigtable.v2.RowFilter,
              com.google.bigtable.v2.RowFilter.Builder,
              com.google.bigtable.v2.RowFilterOrBuilder>
          filtersBuilder_;

      /**
       *
       *
       * <pre>
       * The elements of "filters" all process a copy of the input row, and the
       * results are pooled, sorted, and combined into a single output row.
       * If multiple cells are produced with the same column and timestamp,
       * they will all appear in the output row in an unspecified mutual order.
       * Consider the following example, with three filters:
       *                                  input row
       *                                      |
       *            -----------------------------------------------------
       *            |                         |                         |
       *           f(0)                      f(1)                      f(2)
       *            |                         |                         |
       *     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
       *     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
       *            |                         |                         |
       *            -----------------------------------------------------
       *                                      |
       *     1:                      foo,bar,10,z   // could have switched with #2
       *     2:                      foo,bar,10,x   // could have switched with #1
       *     3:                      foo,blah,11,z
       *     4:                      far,bar,7,a
       *     5:                      far,blah,5,x   // identical to #6
       *     6:                      far,blah,5,x   // identical to #5
       * All interleaved filters are executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public java.util.List<com.google.bigtable.v2.RowFilter> getFiltersList() {
        if (filtersBuilder_ == null) {
          return java.util.Collections.unmodifiableList(filters_);
        } else {
          return filtersBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" all process a copy of the input row, and the
       * results are pooled, sorted, and combined into a single output row.
       * If multiple cells are produced with the same column and timestamp,
       * they will all appear in the output row in an unspecified mutual order.
       * Consider the following example, with three filters:
       *                                  input row
       *                                      |
       *            -----------------------------------------------------
       *            |                         |                         |
       *           f(0)                      f(1)                      f(2)
       *            |                         |                         |
       *     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
       *     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
       *            |                         |                         |
       *            -----------------------------------------------------
       *                                      |
       *     1:                      foo,bar,10,z   // could have switched with #2
       *     2:                      foo,bar,10,x   // could have switched with #1
       *     3:                      foo,blah,11,z
       *     4:                      far,bar,7,a
       *     5:                      far,blah,5,x   // identical to #6
       *     6:                      far,blah,5,x   // identical to #5
       * All interleaved filters are executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public int getFiltersCount() {
        if (filtersBuilder_ == null) {
          return filters_.size();
        } else {
          return filtersBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" all process a copy of the input row, and the
       * results are pooled, sorted, and combined into a single output row.
       * If multiple cells are produced with the same column and timestamp,
       * they will all appear in the output row in an unspecified mutual order.
       * Consider the following example, with three filters:
       *                                  input row
       *                                      |
       *            -----------------------------------------------------
       *            |                         |                         |
       *           f(0)                      f(1)                      f(2)
       *            |                         |                         |
       *     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
       *     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
       *            |                         |                         |
       *            -----------------------------------------------------
       *                                      |
       *     1:                      foo,bar,10,z   // could have switched with #2
       *     2:                      foo,bar,10,x   // could have switched with #1
       *     3:                      foo,blah,11,z
       *     4:                      far,bar,7,a
       *     5:                      far,blah,5,x   // identical to #6
       *     6:                      far,blah,5,x   // identical to #5
       * All interleaved filters are executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public com.google.bigtable.v2.RowFilter getFilters(int index) {
        if (filtersBuilder_ == null) {
          return filters_.get(index);
        } else {
          return filtersBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" all process a copy of the input row, and the
       * results are pooled, sorted, and combined into a single output row.
       * If multiple cells are produced with the same column and timestamp,
       * they will all appear in the output row in an unspecified mutual order.
       * Consider the following example, with three filters:
       *                                  input row
       *                                      |
       *            -----------------------------------------------------
       *            |                         |                         |
       *           f(0)                      f(1)                      f(2)
       *            |                         |                         |
       *     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
       *     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
       *            |                         |                         |
       *            -----------------------------------------------------
       *                                      |
       *     1:                      foo,bar,10,z   // could have switched with #2
       *     2:                      foo,bar,10,x   // could have switched with #1
       *     3:                      foo,blah,11,z
       *     4:                      far,bar,7,a
       *     5:                      far,blah,5,x   // identical to #6
       *     6:                      far,blah,5,x   // identical to #5
       * All interleaved filters are executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public Builder setFilters(int index, com.google.bigtable.v2.RowFilter value) {
        if (filtersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFiltersIsMutable();
          filters_.set(index, value);
          onChanged();
        } else {
          filtersBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" all process a copy of the input row, and the
       * results are pooled, sorted, and combined into a single output row.
       * If multiple cells are produced with the same column and timestamp,
       * they will all appear in the output row in an unspecified mutual order.
       * Consider the following example, with three filters:
       *                                  input row
       *                                      |
       *            -----------------------------------------------------
       *            |                         |                         |
       *           f(0)                      f(1)                      f(2)
       *            |                         |                         |
       *     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
       *     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
       *            |                         |                         |
       *            -----------------------------------------------------
       *                                      |
       *     1:                      foo,bar,10,z   // could have switched with #2
       *     2:                      foo,bar,10,x   // could have switched with #1
       *     3:                      foo,blah,11,z
       *     4:                      far,bar,7,a
       *     5:                      far,blah,5,x   // identical to #6
       *     6:                      far,blah,5,x   // identical to #5
       * All interleaved filters are executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public Builder setFilters(
          int index, com.google.bigtable.v2.RowFilter.Builder builderForValue) {
        if (filtersBuilder_ == null) {
          ensureFiltersIsMutable();
          filters_.set(index, builderForValue.build());
          onChanged();
        } else {
          filtersBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" all process a copy of the input row, and the
       * results are pooled, sorted, and combined into a single output row.
       * If multiple cells are produced with the same column and timestamp,
       * they will all appear in the output row in an unspecified mutual order.
       * Consider the following example, with three filters:
       *                                  input row
       *                                      |
       *            -----------------------------------------------------
       *            |                         |                         |
       *           f(0)                      f(1)                      f(2)
       *            |                         |                         |
       *     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
       *     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
       *            |                         |                         |
       *            -----------------------------------------------------
       *                                      |
       *     1:                      foo,bar,10,z   // could have switched with #2
       *     2:                      foo,bar,10,x   // could have switched with #1
       *     3:                      foo,blah,11,z
       *     4:                      far,bar,7,a
       *     5:                      far,blah,5,x   // identical to #6
       *     6:                      far,blah,5,x   // identical to #5
       * All interleaved filters are executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public Builder addFilters(com.google.bigtable.v2.RowFilter value) {
        if (filtersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFiltersIsMutable();
          filters_.add(value);
          onChanged();
        } else {
          filtersBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" all process a copy of the input row, and the
       * results are pooled, sorted, and combined into a single output row.
       * If multiple cells are produced with the same column and timestamp,
       * they will all appear in the output row in an unspecified mutual order.
       * Consider the following example, with three filters:
       *                                  input row
       *                                      |
       *            -----------------------------------------------------
       *            |                         |                         |
       *           f(0)                      f(1)                      f(2)
       *            |                         |                         |
       *     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
       *     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
       *            |                         |                         |
       *            -----------------------------------------------------
       *                                      |
       *     1:                      foo,bar,10,z   // could have switched with #2
       *     2:                      foo,bar,10,x   // could have switched with #1
       *     3:                      foo,blah,11,z
       *     4:                      far,bar,7,a
       *     5:                      far,blah,5,x   // identical to #6
       *     6:                      far,blah,5,x   // identical to #5
       * All interleaved filters are executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public Builder addFilters(int index, com.google.bigtable.v2.RowFilter value) {
        if (filtersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFiltersIsMutable();
          filters_.add(index, value);
          onChanged();
        } else {
          filtersBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" all process a copy of the input row, and the
       * results are pooled, sorted, and combined into a single output row.
       * If multiple cells are produced with the same column and timestamp,
       * they will all appear in the output row in an unspecified mutual order.
       * Consider the following example, with three filters:
       *                                  input row
       *                                      |
       *            -----------------------------------------------------
       *            |                         |                         |
       *           f(0)                      f(1)                      f(2)
       *            |                         |                         |
       *     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
       *     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
       *            |                         |                         |
       *            -----------------------------------------------------
       *                                      |
       *     1:                      foo,bar,10,z   // could have switched with #2
       *     2:                      foo,bar,10,x   // could have switched with #1
       *     3:                      foo,blah,11,z
       *     4:                      far,bar,7,a
       *     5:                      far,blah,5,x   // identical to #6
       *     6:                      far,blah,5,x   // identical to #5
       * All interleaved filters are executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public Builder addFilters(com.google.bigtable.v2.RowFilter.Builder builderForValue) {
        if (filtersBuilder_ == null) {
          ensureFiltersIsMutable();
          filters_.add(builderForValue.build());
          onChanged();
        } else {
          filtersBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" all process a copy of the input row, and the
       * results are pooled, sorted, and combined into a single output row.
       * If multiple cells are produced with the same column and timestamp,
       * they will all appear in the output row in an unspecified mutual order.
       * Consider the following example, with three filters:
       *                                  input row
       *                                      |
       *            -----------------------------------------------------
       *            |                         |                         |
       *           f(0)                      f(1)                      f(2)
       *            |                         |                         |
       *     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
       *     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
       *            |                         |                         |
       *            -----------------------------------------------------
       *                                      |
       *     1:                      foo,bar,10,z   // could have switched with #2
       *     2:                      foo,bar,10,x   // could have switched with #1
       *     3:                      foo,blah,11,z
       *     4:                      far,bar,7,a
       *     5:                      far,blah,5,x   // identical to #6
       *     6:                      far,blah,5,x   // identical to #5
       * All interleaved filters are executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public Builder addFilters(
          int index, com.google.bigtable.v2.RowFilter.Builder builderForValue) {
        if (filtersBuilder_ == null) {
          ensureFiltersIsMutable();
          filters_.add(index, builderForValue.build());
          onChanged();
        } else {
          filtersBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" all process a copy of the input row, and the
       * results are pooled, sorted, and combined into a single output row.
       * If multiple cells are produced with the same column and timestamp,
       * they will all appear in the output row in an unspecified mutual order.
       * Consider the following example, with three filters:
       *                                  input row
       *                                      |
       *            -----------------------------------------------------
       *            |                         |                         |
       *           f(0)                      f(1)                      f(2)
       *            |                         |                         |
       *     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
       *     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
       *            |                         |                         |
       *            -----------------------------------------------------
       *                                      |
       *     1:                      foo,bar,10,z   // could have switched with #2
       *     2:                      foo,bar,10,x   // could have switched with #1
       *     3:                      foo,blah,11,z
       *     4:                      far,bar,7,a
       *     5:                      far,blah,5,x   // identical to #6
       *     6:                      far,blah,5,x   // identical to #5
       * All interleaved filters are executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public Builder addAllFilters(
          java.lang.Iterable<? extends com.google.bigtable.v2.RowFilter> values) {
        if (filtersBuilder_ == null) {
          ensureFiltersIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, filters_);
          onChanged();
        } else {
          filtersBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" all process a copy of the input row, and the
       * results are pooled, sorted, and combined into a single output row.
       * If multiple cells are produced with the same column and timestamp,
       * they will all appear in the output row in an unspecified mutual order.
       * Consider the following example, with three filters:
       *                                  input row
       *                                      |
       *            -----------------------------------------------------
       *            |                         |                         |
       *           f(0)                      f(1)                      f(2)
       *            |                         |                         |
       *     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
       *     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
       *            |                         |                         |
       *            -----------------------------------------------------
       *                                      |
       *     1:                      foo,bar,10,z   // could have switched with #2
       *     2:                      foo,bar,10,x   // could have switched with #1
       *     3:                      foo,blah,11,z
       *     4:                      far,bar,7,a
       *     5:                      far,blah,5,x   // identical to #6
       *     6:                      far,blah,5,x   // identical to #5
       * All interleaved filters are executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public Builder clearFilters() {
        if (filtersBuilder_ == null) {
          filters_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          filtersBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" all process a copy of the input row, and the
       * results are pooled, sorted, and combined into a single output row.
       * If multiple cells are produced with the same column and timestamp,
       * they will all appear in the output row in an unspecified mutual order.
       * Consider the following example, with three filters:
       *                                  input row
       *                                      |
       *            -----------------------------------------------------
       *            |                         |                         |
       *           f(0)                      f(1)                      f(2)
       *            |                         |                         |
       *     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
       *     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
       *            |                         |                         |
       *            -----------------------------------------------------
       *                                      |
       *     1:                      foo,bar,10,z   // could have switched with #2
       *     2:                      foo,bar,10,x   // could have switched with #1
       *     3:                      foo,blah,11,z
       *     4:                      far,bar,7,a
       *     5:                      far,blah,5,x   // identical to #6
       *     6:                      far,blah,5,x   // identical to #5
       * All interleaved filters are executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public Builder removeFilters(int index) {
        if (filtersBuilder_ == null) {
          ensureFiltersIsMutable();
          filters_.remove(index);
          onChanged();
        } else {
          filtersBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" all process a copy of the input row, and the
       * results are pooled, sorted, and combined into a single output row.
       * If multiple cells are produced with the same column and timestamp,
       * they will all appear in the output row in an unspecified mutual order.
       * Consider the following example, with three filters:
       *                                  input row
       *                                      |
       *            -----------------------------------------------------
       *            |                         |                         |
       *           f(0)                      f(1)                      f(2)
       *            |                         |                         |
       *     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
       *     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
       *            |                         |                         |
       *            -----------------------------------------------------
       *                                      |
       *     1:                      foo,bar,10,z   // could have switched with #2
       *     2:                      foo,bar,10,x   // could have switched with #1
       *     3:                      foo,blah,11,z
       *     4:                      far,bar,7,a
       *     5:                      far,blah,5,x   // identical to #6
       *     6:                      far,blah,5,x   // identical to #5
       * All interleaved filters are executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public com.google.bigtable.v2.RowFilter.Builder getFiltersBuilder(int index) {
        return getFiltersFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" all process a copy of the input row, and the
       * results are pooled, sorted, and combined into a single output row.
       * If multiple cells are produced with the same column and timestamp,
       * they will all appear in the output row in an unspecified mutual order.
       * Consider the following example, with three filters:
       *                                  input row
       *                                      |
       *            -----------------------------------------------------
       *            |                         |                         |
       *           f(0)                      f(1)                      f(2)
       *            |                         |                         |
       *     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
       *     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
       *            |                         |                         |
       *            -----------------------------------------------------
       *                                      |
       *     1:                      foo,bar,10,z   // could have switched with #2
       *     2:                      foo,bar,10,x   // could have switched with #1
       *     3:                      foo,blah,11,z
       *     4:                      far,bar,7,a
       *     5:                      far,blah,5,x   // identical to #6
       *     6:                      far,blah,5,x   // identical to #5
       * All interleaved filters are executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public com.google.bigtable.v2.RowFilterOrBuilder getFiltersOrBuilder(int index) {
        if (filtersBuilder_ == null) {
          return filters_.get(index);
        } else {
          return filtersBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" all process a copy of the input row, and the
       * results are pooled, sorted, and combined into a single output row.
       * If multiple cells are produced with the same column and timestamp,
       * they will all appear in the output row in an unspecified mutual order.
       * Consider the following example, with three filters:
       *                                  input row
       *                                      |
       *            -----------------------------------------------------
       *            |                         |                         |
       *           f(0)                      f(1)                      f(2)
       *            |                         |                         |
       *     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
       *     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
       *            |                         |                         |
       *            -----------------------------------------------------
       *                                      |
       *     1:                      foo,bar,10,z   // could have switched with #2
       *     2:                      foo,bar,10,x   // could have switched with #1
       *     3:                      foo,blah,11,z
       *     4:                      far,bar,7,a
       *     5:                      far,blah,5,x   // identical to #6
       *     6:                      far,blah,5,x   // identical to #5
       * All interleaved filters are executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public java.util.List<? extends com.google.bigtable.v2.RowFilterOrBuilder>
          getFiltersOrBuilderList() {
        if (filtersBuilder_ != null) {
          return filtersBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(filters_);
        }
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" all process a copy of the input row, and the
       * results are pooled, sorted, and combined into a single output row.
       * If multiple cells are produced with the same column and timestamp,
       * they will all appear in the output row in an unspecified mutual order.
       * Consider the following example, with three filters:
       *                                  input row
       *                                      |
       *            -----------------------------------------------------
       *            |                         |                         |
       *           f(0)                      f(1)                      f(2)
       *            |                         |                         |
       *     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
       *     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
       *            |                         |                         |
       *            -----------------------------------------------------
       *                                      |
       *     1:                      foo,bar,10,z   // could have switched with #2
       *     2:                      foo,bar,10,x   // could have switched with #1
       *     3:                      foo,blah,11,z
       *     4:                      far,bar,7,a
       *     5:                      far,blah,5,x   // identical to #6
       *     6:                      far,blah,5,x   // identical to #5
       * All interleaved filters are executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public com.google.bigtable.v2.RowFilter.Builder addFiltersBuilder() {
        return getFiltersFieldBuilder()
            .addBuilder(com.google.bigtable.v2.RowFilter.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" all process a copy of the input row, and the
       * results are pooled, sorted, and combined into a single output row.
       * If multiple cells are produced with the same column and timestamp,
       * they will all appear in the output row in an unspecified mutual order.
       * Consider the following example, with three filters:
       *                                  input row
       *                                      |
       *            -----------------------------------------------------
       *            |                         |                         |
       *           f(0)                      f(1)                      f(2)
       *            |                         |                         |
       *     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
       *     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
       *            |                         |                         |
       *            -----------------------------------------------------
       *                                      |
       *     1:                      foo,bar,10,z   // could have switched with #2
       *     2:                      foo,bar,10,x   // could have switched with #1
       *     3:                      foo,blah,11,z
       *     4:                      far,bar,7,a
       *     5:                      far,blah,5,x   // identical to #6
       *     6:                      far,blah,5,x   // identical to #5
       * All interleaved filters are executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public com.google.bigtable.v2.RowFilter.Builder addFiltersBuilder(int index) {
        return getFiltersFieldBuilder()
            .addBuilder(index, com.google.bigtable.v2.RowFilter.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * The elements of "filters" all process a copy of the input row, and the
       * results are pooled, sorted, and combined into a single output row.
       * If multiple cells are produced with the same column and timestamp,
       * they will all appear in the output row in an unspecified mutual order.
       * Consider the following example, with three filters:
       *                                  input row
       *                                      |
       *            -----------------------------------------------------
       *            |                         |                         |
       *           f(0)                      f(1)                      f(2)
       *            |                         |                         |
       *     1: foo,bar,10,x             foo,bar,10,z              far,bar,7,a
       *     2: foo,blah,11,z            far,blah,5,x              far,blah,5,x
       *            |                         |                         |
       *            -----------------------------------------------------
       *                                      |
       *     1:                      foo,bar,10,z   // could have switched with #2
       *     2:                      foo,bar,10,x   // could have switched with #1
       *     3:                      foo,blah,11,z
       *     4:                      far,bar,7,a
       *     5:                      far,blah,5,x   // identical to #6
       *     6:                      far,blah,5,x   // identical to #5
       * All interleaved filters are executed atomically.
       * </pre>
       *
       * <code>repeated .google.bigtable.v2.RowFilter filters = 1;</code>
       */
      public java.util.List<com.google.bigtable.v2.RowFilter.Builder> getFiltersBuilderList() {
        return getFiltersFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.bigtable.v2.RowFilter,
              com.google.bigtable.v2.RowFilter.Builder,
              com.google.bigtable.v2.RowFilterOrBuilder>
          getFiltersFieldBuilder() {
        if (filtersBuilder_ == null) {
          filtersBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.bigtable.v2.RowFilter,
                  com.google.bigtable.v2.RowFilter.Builder,
                  com.google.bigtable.v2.RowFilterOrBuilder>(
                  filters_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          filters_ = null;
        }
        return filtersBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.v2.RowFilter.Interleave)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.v2.RowFilter.Interleave)
    private static final com.google.bigtable.v2.RowFilter.Interleave DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.v2.RowFilter.Interleave();
    }

    public static com.google.bigtable.v2.RowFilter.Interleave getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Interleave> PARSER =
        new com.google.protobuf.AbstractParser<Interleave>() {
          @java.lang.Override
          public Interleave parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Interleave(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Interleave> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Interleave> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.v2.RowFilter.Interleave getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ConditionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.v2.RowFilter.Condition)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * If `predicate_filter` outputs any cells, then `true_filter` will be
     * evaluated on the input row. Otherwise, `false_filter` will be evaluated.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter predicate_filter = 1;</code>
     *
     * @return Whether the predicateFilter field is set.
     */
    boolean hasPredicateFilter();
    /**
     *
     *
     * <pre>
     * If `predicate_filter` outputs any cells, then `true_filter` will be
     * evaluated on the input row. Otherwise, `false_filter` will be evaluated.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter predicate_filter = 1;</code>
     *
     * @return The predicateFilter.
     */
    com.google.bigtable.v2.RowFilter getPredicateFilter();
    /**
     *
     *
     * <pre>
     * If `predicate_filter` outputs any cells, then `true_filter` will be
     * evaluated on the input row. Otherwise, `false_filter` will be evaluated.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter predicate_filter = 1;</code>
     */
    com.google.bigtable.v2.RowFilterOrBuilder getPredicateFilterOrBuilder();

    /**
     *
     *
     * <pre>
     * The filter to apply to the input row if `predicate_filter` returns any
     * results. If not provided, no results will be returned in the true case.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter true_filter = 2;</code>
     *
     * @return Whether the trueFilter field is set.
     */
    boolean hasTrueFilter();
    /**
     *
     *
     * <pre>
     * The filter to apply to the input row if `predicate_filter` returns any
     * results. If not provided, no results will be returned in the true case.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter true_filter = 2;</code>
     *
     * @return The trueFilter.
     */
    com.google.bigtable.v2.RowFilter getTrueFilter();
    /**
     *
     *
     * <pre>
     * The filter to apply to the input row if `predicate_filter` returns any
     * results. If not provided, no results will be returned in the true case.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter true_filter = 2;</code>
     */
    com.google.bigtable.v2.RowFilterOrBuilder getTrueFilterOrBuilder();

    /**
     *
     *
     * <pre>
     * The filter to apply to the input row if `predicate_filter` does not
     * return any results. If not provided, no results will be returned in the
     * false case.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter false_filter = 3;</code>
     *
     * @return Whether the falseFilter field is set.
     */
    boolean hasFalseFilter();
    /**
     *
     *
     * <pre>
     * The filter to apply to the input row if `predicate_filter` does not
     * return any results. If not provided, no results will be returned in the
     * false case.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter false_filter = 3;</code>
     *
     * @return The falseFilter.
     */
    com.google.bigtable.v2.RowFilter getFalseFilter();
    /**
     *
     *
     * <pre>
     * The filter to apply to the input row if `predicate_filter` does not
     * return any results. If not provided, no results will be returned in the
     * false case.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter false_filter = 3;</code>
     */
    com.google.bigtable.v2.RowFilterOrBuilder getFalseFilterOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * A RowFilter which evaluates one of two possible RowFilters, depending on
   * whether or not a predicate RowFilter outputs any cells from the input row.
   * IMPORTANT NOTE: The predicate filter does not execute atomically with the
   * true and false filters, which may lead to inconsistent or unexpected
   * results. Additionally, Condition filters have poor performance, especially
   * when filters are set for the false condition.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.RowFilter.Condition}
   */
  public static final class Condition extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.v2.RowFilter.Condition)
      ConditionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Condition.newBuilder() to construct.
    private Condition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Condition() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Condition();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Condition(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.bigtable.v2.RowFilter.Builder subBuilder = null;
                if (predicateFilter_ != null) {
                  subBuilder = predicateFilter_.toBuilder();
                }
                predicateFilter_ =
                    input.readMessage(com.google.bigtable.v2.RowFilter.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(predicateFilter_);
                  predicateFilter_ = subBuilder.buildPartial();
                }

                break;
              }
            case 18:
              {
                com.google.bigtable.v2.RowFilter.Builder subBuilder = null;
                if (trueFilter_ != null) {
                  subBuilder = trueFilter_.toBuilder();
                }
                trueFilter_ =
                    input.readMessage(com.google.bigtable.v2.RowFilter.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(trueFilter_);
                  trueFilter_ = subBuilder.buildPartial();
                }

                break;
              }
            case 26:
              {
                com.google.bigtable.v2.RowFilter.Builder subBuilder = null;
                if (falseFilter_ != null) {
                  subBuilder = falseFilter_.toBuilder();
                }
                falseFilter_ =
                    input.readMessage(com.google.bigtable.v2.RowFilter.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(falseFilter_);
                  falseFilter_ = subBuilder.buildPartial();
                }

                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.DataProto
          .internal_static_google_bigtable_v2_RowFilter_Condition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.DataProto
          .internal_static_google_bigtable_v2_RowFilter_Condition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.RowFilter.Condition.class,
              com.google.bigtable.v2.RowFilter.Condition.Builder.class);
    }

    public static final int PREDICATE_FILTER_FIELD_NUMBER = 1;
    private com.google.bigtable.v2.RowFilter predicateFilter_;
    /**
     *
     *
     * <pre>
     * If `predicate_filter` outputs any cells, then `true_filter` will be
     * evaluated on the input row. Otherwise, `false_filter` will be evaluated.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter predicate_filter = 1;</code>
     *
     * @return Whether the predicateFilter field is set.
     */
    @java.lang.Override
    public boolean hasPredicateFilter() {
      return predicateFilter_ != null;
    }
    /**
     *
     *
     * <pre>
     * If `predicate_filter` outputs any cells, then `true_filter` will be
     * evaluated on the input row. Otherwise, `false_filter` will be evaluated.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter predicate_filter = 1;</code>
     *
     * @return The predicateFilter.
     */
    @java.lang.Override
    public com.google.bigtable.v2.RowFilter getPredicateFilter() {
      return predicateFilter_ == null
          ? com.google.bigtable.v2.RowFilter.getDefaultInstance()
          : predicateFilter_;
    }
    /**
     *
     *
     * <pre>
     * If `predicate_filter` outputs any cells, then `true_filter` will be
     * evaluated on the input row. Otherwise, `false_filter` will be evaluated.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter predicate_filter = 1;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.RowFilterOrBuilder getPredicateFilterOrBuilder() {
      return getPredicateFilter();
    }

    public static final int TRUE_FILTER_FIELD_NUMBER = 2;
    private com.google.bigtable.v2.RowFilter trueFilter_;
    /**
     *
     *
     * <pre>
     * The filter to apply to the input row if `predicate_filter` returns any
     * results. If not provided, no results will be returned in the true case.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter true_filter = 2;</code>
     *
     * @return Whether the trueFilter field is set.
     */
    @java.lang.Override
    public boolean hasTrueFilter() {
      return trueFilter_ != null;
    }
    /**
     *
     *
     * <pre>
     * The filter to apply to the input row if `predicate_filter` returns any
     * results. If not provided, no results will be returned in the true case.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter true_filter = 2;</code>
     *
     * @return The trueFilter.
     */
    @java.lang.Override
    public com.google.bigtable.v2.RowFilter getTrueFilter() {
      return trueFilter_ == null
          ? com.google.bigtable.v2.RowFilter.getDefaultInstance()
          : trueFilter_;
    }
    /**
     *
     *
     * <pre>
     * The filter to apply to the input row if `predicate_filter` returns any
     * results. If not provided, no results will be returned in the true case.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter true_filter = 2;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.RowFilterOrBuilder getTrueFilterOrBuilder() {
      return getTrueFilter();
    }

    public static final int FALSE_FILTER_FIELD_NUMBER = 3;
    private com.google.bigtable.v2.RowFilter falseFilter_;
    /**
     *
     *
     * <pre>
     * The filter to apply to the input row if `predicate_filter` does not
     * return any results. If not provided, no results will be returned in the
     * false case.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter false_filter = 3;</code>
     *
     * @return Whether the falseFilter field is set.
     */
    @java.lang.Override
    public boolean hasFalseFilter() {
      return falseFilter_ != null;
    }
    /**
     *
     *
     * <pre>
     * The filter to apply to the input row if `predicate_filter` does not
     * return any results. If not provided, no results will be returned in the
     * false case.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter false_filter = 3;</code>
     *
     * @return The falseFilter.
     */
    @java.lang.Override
    public com.google.bigtable.v2.RowFilter getFalseFilter() {
      return falseFilter_ == null
          ? com.google.bigtable.v2.RowFilter.getDefaultInstance()
          : falseFilter_;
    }
    /**
     *
     *
     * <pre>
     * The filter to apply to the input row if `predicate_filter` does not
     * return any results. If not provided, no results will be returned in the
     * false case.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter false_filter = 3;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.RowFilterOrBuilder getFalseFilterOrBuilder() {
      return getFalseFilter();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (predicateFilter_ != null) {
        output.writeMessage(1, getPredicateFilter());
      }
      if (trueFilter_ != null) {
        output.writeMessage(2, getTrueFilter());
      }
      if (falseFilter_ != null) {
        output.writeMessage(3, getFalseFilter());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (predicateFilter_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getPredicateFilter());
      }
      if (trueFilter_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getTrueFilter());
      }
      if (falseFilter_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getFalseFilter());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.v2.RowFilter.Condition)) {
        return super.equals(obj);
      }
      com.google.bigtable.v2.RowFilter.Condition other =
          (com.google.bigtable.v2.RowFilter.Condition) obj;

      if (hasPredicateFilter() != other.hasPredicateFilter()) return false;
      if (hasPredicateFilter()) {
        if (!getPredicateFilter().equals(other.getPredicateFilter())) return false;
      }
      if (hasTrueFilter() != other.hasTrueFilter()) return false;
      if (hasTrueFilter()) {
        if (!getTrueFilter().equals(other.getTrueFilter())) return false;
      }
      if (hasFalseFilter() != other.hasFalseFilter()) return false;
      if (hasFalseFilter()) {
        if (!getFalseFilter().equals(other.getFalseFilter())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasPredicateFilter()) {
        hash = (37 * hash) + PREDICATE_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getPredicateFilter().hashCode();
      }
      if (hasTrueFilter()) {
        hash = (37 * hash) + TRUE_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getTrueFilter().hashCode();
      }
      if (hasFalseFilter()) {
        hash = (37 * hash) + FALSE_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getFalseFilter().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.v2.RowFilter.Condition parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.RowFilter.Condition parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.RowFilter.Condition parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.RowFilter.Condition parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.RowFilter.Condition parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.RowFilter.Condition parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.RowFilter.Condition parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.RowFilter.Condition parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.RowFilter.Condition parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.RowFilter.Condition parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.RowFilter.Condition parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.RowFilter.Condition parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.v2.RowFilter.Condition prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A RowFilter which evaluates one of two possible RowFilters, depending on
     * whether or not a predicate RowFilter outputs any cells from the input row.
     * IMPORTANT NOTE: The predicate filter does not execute atomically with the
     * true and false filters, which may lead to inconsistent or unexpected
     * results. Additionally, Condition filters have poor performance, especially
     * when filters are set for the false condition.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.v2.RowFilter.Condition}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.v2.RowFilter.Condition)
        com.google.bigtable.v2.RowFilter.ConditionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.v2.DataProto
            .internal_static_google_bigtable_v2_RowFilter_Condition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.v2.DataProto
            .internal_static_google_bigtable_v2_RowFilter_Condition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.v2.RowFilter.Condition.class,
                com.google.bigtable.v2.RowFilter.Condition.Builder.class);
      }

      // Construct using com.google.bigtable.v2.RowFilter.Condition.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (predicateFilterBuilder_ == null) {
          predicateFilter_ = null;
        } else {
          predicateFilter_ = null;
          predicateFilterBuilder_ = null;
        }
        if (trueFilterBuilder_ == null) {
          trueFilter_ = null;
        } else {
          trueFilter_ = null;
          trueFilterBuilder_ = null;
        }
        if (falseFilterBuilder_ == null) {
          falseFilter_ = null;
        } else {
          falseFilter_ = null;
          falseFilterBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.v2.DataProto
            .internal_static_google_bigtable_v2_RowFilter_Condition_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.v2.RowFilter.Condition getDefaultInstanceForType() {
        return com.google.bigtable.v2.RowFilter.Condition.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.v2.RowFilter.Condition build() {
        com.google.bigtable.v2.RowFilter.Condition result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.v2.RowFilter.Condition buildPartial() {
        com.google.bigtable.v2.RowFilter.Condition result =
            new com.google.bigtable.v2.RowFilter.Condition(this);
        if (predicateFilterBuilder_ == null) {
          result.predicateFilter_ = predicateFilter_;
        } else {
          result.predicateFilter_ = predicateFilterBuilder_.build();
        }
        if (trueFilterBuilder_ == null) {
          result.trueFilter_ = trueFilter_;
        } else {
          result.trueFilter_ = trueFilterBuilder_.build();
        }
        if (falseFilterBuilder_ == null) {
          result.falseFilter_ = falseFilter_;
        } else {
          result.falseFilter_ = falseFilterBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.v2.RowFilter.Condition) {
          return mergeFrom((com.google.bigtable.v2.RowFilter.Condition) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.v2.RowFilter.Condition other) {
        if (other == com.google.bigtable.v2.RowFilter.Condition.getDefaultInstance()) return this;
        if (other.hasPredicateFilter()) {
          mergePredicateFilter(other.getPredicateFilter());
        }
        if (other.hasTrueFilter()) {
          mergeTrueFilter(other.getTrueFilter());
        }
        if (other.hasFalseFilter()) {
          mergeFalseFilter(other.getFalseFilter());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.bigtable.v2.RowFilter.Condition parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.bigtable.v2.RowFilter.Condition) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private com.google.bigtable.v2.RowFilter predicateFilter_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.v2.RowFilter,
              com.google.bigtable.v2.RowFilter.Builder,
              com.google.bigtable.v2.RowFilterOrBuilder>
          predicateFilterBuilder_;
      /**
       *
       *
       * <pre>
       * If `predicate_filter` outputs any cells, then `true_filter` will be
       * evaluated on the input row. Otherwise, `false_filter` will be evaluated.
       * </pre>
       *
       * <code>.google.bigtable.v2.RowFilter predicate_filter = 1;</code>
       *
       * @return Whether the predicateFilter field is set.
       */
      public boolean hasPredicateFilter() {
        return predicateFilterBuilder_ != null || predicateFilter_ != null;
      }
      /**
       *
       *
       * <pre>
       * If `predicate_filter` outputs any cells, then `true_filter` will be
       * evaluated on the input row. Otherwise, `false_filter` will be evaluated.
       * </pre>
       *
       * <code>.google.bigtable.v2.RowFilter predicate_filter = 1;</code>
       *
       * @return The predicateFilter.
       */
      public com.google.bigtable.v2.RowFilter getPredicateFilter() {
        if (predicateFilterBuilder_ == null) {
          return predicateFilter_ == null
              ? com.google.bigtable.v2.RowFilter.getDefaultInstance()
              : predicateFilter_;
        } else {
          return predicateFilterBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * If `predicate_filter` outputs any cells, then `true_filter` will be
       * evaluated on the input row. Otherwise, `false_filter` will be evaluated.
       * </pre>
       *
       * <code>.google.bigtable.v2.RowFilter predicate_filter = 1;</code>
       */
      public Builder setPredicateFilter(com.google.bigtable.v2.RowFilter value) {
        if (predicateFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          predicateFilter_ = value;
          onChanged();
        } else {
          predicateFilterBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * If `predicate_filter` outputs any cells, then `true_filter` will be
       * evaluated on the input row. Otherwise, `false_filter` will be evaluated.
       * </pre>
       *
       * <code>.google.bigtable.v2.RowFilter predicate_filter = 1;</code>
       */
      public Builder setPredicateFilter(com.google.bigtable.v2.RowFilter.Builder builderForValue) {
        if (predicateFilterBuilder_ == null) {
          predicateFilter_ = builderForValue.build();
          onChanged();
        } else {
          predicateFilterBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * If `predicate_filter` outputs any cells, then `true_filter` will be
       * evaluated on the input row. Otherwise, `false_filter` will be evaluated.
       * </pre>
       *
       * <code>.google.bigtable.v2.RowFilter predicate_filter = 1;</code>
       */
      public Builder mergePredicateFilter(com.google.bigtable.v2.RowFilter value) {
        if (predicateFilterBuilder_ == null) {
          if (predicateFilter_ != null) {
            predicateFilter_ =
                com.google.bigtable.v2.RowFilter.newBuilder(predicateFilter_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            predicateFilter_ = value;
          }
          onChanged();
        } else {
          predicateFilterBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * If `predicate_filter` outputs any cells, then `true_filter` will be
       * evaluated on the input row. Otherwise, `false_filter` will be evaluated.
       * </pre>
       *
       * <code>.google.bigtable.v2.RowFilter predicate_filter = 1;</code>
       */
      public Builder clearPredicateFilter() {
        if (predicateFilterBuilder_ == null) {
          predicateFilter_ = null;
          onChanged();
        } else {
          predicateFilter_ = null;
          predicateFilterBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * If `predicate_filter` outputs any cells, then `true_filter` will be
       * evaluated on the input row. Otherwise, `false_filter` will be evaluated.
       * </pre>
       *
       * <code>.google.bigtable.v2.RowFilter predicate_filter = 1;</code>
       */
      public com.google.bigtable.v2.RowFilter.Builder getPredicateFilterBuilder() {

        onChanged();
        return getPredicateFilterFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * If `predicate_filter` outputs any cells, then `true_filter` will be
       * evaluated on the input row. Otherwise, `false_filter` will be evaluated.
       * </pre>
       *
       * <code>.google.bigtable.v2.RowFilter predicate_filter = 1;</code>
       */
      public com.google.bigtable.v2.RowFilterOrBuilder getPredicateFilterOrBuilder() {
        if (predicateFilterBuilder_ != null) {
          return predicateFilterBuilder_.getMessageOrBuilder();
        } else {
          return predicateFilter_ == null
              ? com.google.bigtable.v2.RowFilter.getDefaultInstance()
              : predicateFilter_;
        }
      }
      /**
       *
       *
       * <pre>
       * If `predicate_filter` outputs any cells, then `true_filter` will be
       * evaluated on the input row. Otherwise, `false_filter` will be evaluated.
       * </pre>
       *
       * <code>.google.bigtable.v2.RowFilter predicate_filter = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.v2.RowFilter,
              com.google.bigtable.v2.RowFilter.Builder,
              com.google.bigtable.v2.RowFilterOrBuilder>
          getPredicateFilterFieldBuilder() {
        if (predicateFilterBuilder_ == null) {
          predicateFilterBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.bigtable.v2.RowFilter,
                  com.google.bigtable.v2.RowFilter.Builder,
                  com.google.bigtable.v2.RowFilterOrBuilder>(
                  getPredicateFilter(), getParentForChildren(), isClean());
          predicateFilter_ = null;
        }
        return predicateFilterBuilder_;
      }

      private com.google.bigtable.v2.RowFilter trueFilter_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.v2.RowFilter,
              com.google.bigtable.v2.RowFilter.Builder,
              com.google.bigtable.v2.RowFilterOrBuilder>
          trueFilterBuilder_;
      /**
       *
       *
       * <pre>
       * The filter to apply to the input row if `predicate_filter` returns any
       * results. If not provided, no results will be returned in the true case.
       * </pre>
       *
       * <code>.google.bigtable.v2.RowFilter true_filter = 2;</code>
       *
       * @return Whether the trueFilter field is set.
       */
      public boolean hasTrueFilter() {
        return trueFilterBuilder_ != null || trueFilter_ != null;
      }
      /**
       *
       *
       * <pre>
       * The filter to apply to the input row if `predicate_filter` returns any
       * results. If not provided, no results will be returned in the true case.
       * </pre>
       *
       * <code>.google.bigtable.v2.RowFilter true_filter = 2;</code>
       *
       * @return The trueFilter.
       */
      public com.google.bigtable.v2.RowFilter getTrueFilter() {
        if (trueFilterBuilder_ == null) {
          return trueFilter_ == null
              ? com.google.bigtable.v2.RowFilter.getDefaultInstance()
              : trueFilter_;
        } else {
          return trueFilterBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The filter to apply to the input row if `predicate_filter` returns any
       * results. If not provided, no results will be returned in the true case.
       * </pre>
       *
       * <code>.google.bigtable.v2.RowFilter true_filter = 2;</code>
       */
      public Builder setTrueFilter(com.google.bigtable.v2.RowFilter value) {
        if (trueFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          trueFilter_ = value;
          onChanged();
        } else {
          trueFilterBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The filter to apply to the input row if `predicate_filter` returns any
       * results. If not provided, no results will be returned in the true case.
       * </pre>
       *
       * <code>.google.bigtable.v2.RowFilter true_filter = 2;</code>
       */
      public Builder setTrueFilter(com.google.bigtable.v2.RowFilter.Builder builderForValue) {
        if (trueFilterBuilder_ == null) {
          trueFilter_ = builderForValue.build();
          onChanged();
        } else {
          trueFilterBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The filter to apply to the input row if `predicate_filter` returns any
       * results. If not provided, no results will be returned in the true case.
       * </pre>
       *
       * <code>.google.bigtable.v2.RowFilter true_filter = 2;</code>
       */
      public Builder mergeTrueFilter(com.google.bigtable.v2.RowFilter value) {
        if (trueFilterBuilder_ == null) {
          if (trueFilter_ != null) {
            trueFilter_ =
                com.google.bigtable.v2.RowFilter.newBuilder(trueFilter_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            trueFilter_ = value;
          }
          onChanged();
        } else {
          trueFilterBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The filter to apply to the input row if `predicate_filter` returns any
       * results. If not provided, no results will be returned in the true case.
       * </pre>
       *
       * <code>.google.bigtable.v2.RowFilter true_filter = 2;</code>
       */
      public Builder clearTrueFilter() {
        if (trueFilterBuilder_ == null) {
          trueFilter_ = null;
          onChanged();
        } else {
          trueFilter_ = null;
          trueFilterBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The filter to apply to the input row if `predicate_filter` returns any
       * results. If not provided, no results will be returned in the true case.
       * </pre>
       *
       * <code>.google.bigtable.v2.RowFilter true_filter = 2;</code>
       */
      public com.google.bigtable.v2.RowFilter.Builder getTrueFilterBuilder() {

        onChanged();
        return getTrueFilterFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The filter to apply to the input row if `predicate_filter` returns any
       * results. If not provided, no results will be returned in the true case.
       * </pre>
       *
       * <code>.google.bigtable.v2.RowFilter true_filter = 2;</code>
       */
      public com.google.bigtable.v2.RowFilterOrBuilder getTrueFilterOrBuilder() {
        if (trueFilterBuilder_ != null) {
          return trueFilterBuilder_.getMessageOrBuilder();
        } else {
          return trueFilter_ == null
              ? com.google.bigtable.v2.RowFilter.getDefaultInstance()
              : trueFilter_;
        }
      }
      /**
       *
       *
       * <pre>
       * The filter to apply to the input row if `predicate_filter` returns any
       * results. If not provided, no results will be returned in the true case.
       * </pre>
       *
       * <code>.google.bigtable.v2.RowFilter true_filter = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.v2.RowFilter,
              com.google.bigtable.v2.RowFilter.Builder,
              com.google.bigtable.v2.RowFilterOrBuilder>
          getTrueFilterFieldBuilder() {
        if (trueFilterBuilder_ == null) {
          trueFilterBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.bigtable.v2.RowFilter,
                  com.google.bigtable.v2.RowFilter.Builder,
                  com.google.bigtable.v2.RowFilterOrBuilder>(
                  getTrueFilter(), getParentForChildren(), isClean());
          trueFilter_ = null;
        }
        return trueFilterBuilder_;
      }

      private com.google.bigtable.v2.RowFilter falseFilter_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.v2.RowFilter,
              com.google.bigtable.v2.RowFilter.Builder,
              com.google.bigtable.v2.RowFilterOrBuilder>
          falseFilterBuilder_;
      /**
       *
       *
       * <pre>
       * The filter to apply to the input row if `predicate_filter` does not
       * return any results. If not provided, no results will be returned in the
       * false case.
       * </pre>
       *
       * <code>.google.bigtable.v2.RowFilter false_filter = 3;</code>
       *
       * @return Whether the falseFilter field is set.
       */
      public boolean hasFalseFilter() {
        return falseFilterBuilder_ != null || falseFilter_ != null;
      }
      /**
       *
       *
       * <pre>
       * The filter to apply to the input row if `predicate_filter` does not
       * return any results. If not provided, no results will be returned in the
       * false case.
       * </pre>
       *
       * <code>.google.bigtable.v2.RowFilter false_filter = 3;</code>
       *
       * @return The falseFilter.
       */
      public com.google.bigtable.v2.RowFilter getFalseFilter() {
        if (falseFilterBuilder_ == null) {
          return falseFilter_ == null
              ? com.google.bigtable.v2.RowFilter.getDefaultInstance()
              : falseFilter_;
        } else {
          return falseFilterBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The filter to apply to the input row if `predicate_filter` does not
       * return any results. If not provided, no results will be returned in the
       * false case.
       * </pre>
       *
       * <code>.google.bigtable.v2.RowFilter false_filter = 3;</code>
       */
      public Builder setFalseFilter(com.google.bigtable.v2.RowFilter value) {
        if (falseFilterBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          falseFilter_ = value;
          onChanged();
        } else {
          falseFilterBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The filter to apply to the input row if `predicate_filter` does not
       * return any results. If not provided, no results will be returned in the
       * false case.
       * </pre>
       *
       * <code>.google.bigtable.v2.RowFilter false_filter = 3;</code>
       */
      public Builder setFalseFilter(com.google.bigtable.v2.RowFilter.Builder builderForValue) {
        if (falseFilterBuilder_ == null) {
          falseFilter_ = builderForValue.build();
          onChanged();
        } else {
          falseFilterBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The filter to apply to the input row if `predicate_filter` does not
       * return any results. If not provided, no results will be returned in the
       * false case.
       * </pre>
       *
       * <code>.google.bigtable.v2.RowFilter false_filter = 3;</code>
       */
      public Builder mergeFalseFilter(com.google.bigtable.v2.RowFilter value) {
        if (falseFilterBuilder_ == null) {
          if (falseFilter_ != null) {
            falseFilter_ =
                com.google.bigtable.v2.RowFilter.newBuilder(falseFilter_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            falseFilter_ = value;
          }
          onChanged();
        } else {
          falseFilterBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The filter to apply to the input row if `predicate_filter` does not
       * return any results. If not provided, no results will be returned in the
       * false case.
       * </pre>
       *
       * <code>.google.bigtable.v2.RowFilter false_filter = 3;</code>
       */
      public Builder clearFalseFilter() {
        if (falseFilterBuilder_ == null) {
          falseFilter_ = null;
          onChanged();
        } else {
          falseFilter_ = null;
          falseFilterBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The filter to apply to the input row if `predicate_filter` does not
       * return any results. If not provided, no results will be returned in the
       * false case.
       * </pre>
       *
       * <code>.google.bigtable.v2.RowFilter false_filter = 3;</code>
       */
      public com.google.bigtable.v2.RowFilter.Builder getFalseFilterBuilder() {

        onChanged();
        return getFalseFilterFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The filter to apply to the input row if `predicate_filter` does not
       * return any results. If not provided, no results will be returned in the
       * false case.
       * </pre>
       *
       * <code>.google.bigtable.v2.RowFilter false_filter = 3;</code>
       */
      public com.google.bigtable.v2.RowFilterOrBuilder getFalseFilterOrBuilder() {
        if (falseFilterBuilder_ != null) {
          return falseFilterBuilder_.getMessageOrBuilder();
        } else {
          return falseFilter_ == null
              ? com.google.bigtable.v2.RowFilter.getDefaultInstance()
              : falseFilter_;
        }
      }
      /**
       *
       *
       * <pre>
       * The filter to apply to the input row if `predicate_filter` does not
       * return any results. If not provided, no results will be returned in the
       * false case.
       * </pre>
       *
       * <code>.google.bigtable.v2.RowFilter false_filter = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.bigtable.v2.RowFilter,
              com.google.bigtable.v2.RowFilter.Builder,
              com.google.bigtable.v2.RowFilterOrBuilder>
          getFalseFilterFieldBuilder() {
        if (falseFilterBuilder_ == null) {
          falseFilterBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.bigtable.v2.RowFilter,
                  com.google.bigtable.v2.RowFilter.Builder,
                  com.google.bigtable.v2.RowFilterOrBuilder>(
                  getFalseFilter(), getParentForChildren(), isClean());
          falseFilter_ = null;
        }
        return falseFilterBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.v2.RowFilter.Condition)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.v2.RowFilter.Condition)
    private static final com.google.bigtable.v2.RowFilter.Condition DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.v2.RowFilter.Condition();
    }

    public static com.google.bigtable.v2.RowFilter.Condition getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Condition> PARSER =
        new com.google.protobuf.AbstractParser<Condition>() {
          @java.lang.Override
          public Condition parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Condition(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Condition> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Condition> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.v2.RowFilter.Condition getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int filterCase_ = 0;
  private java.lang.Object filter_;

  public enum FilterCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    CHAIN(1),
    INTERLEAVE(2),
    CONDITION(3),
    SINK(16),
    PASS_ALL_FILTER(17),
    BLOCK_ALL_FILTER(18),
    ROW_KEY_REGEX_FILTER(4),
    ROW_SAMPLE_FILTER(14),
    FAMILY_NAME_REGEX_FILTER(5),
    COLUMN_QUALIFIER_REGEX_FILTER(6),
    COLUMN_RANGE_FILTER(7),
    TIMESTAMP_RANGE_FILTER(8),
    VALUE_REGEX_FILTER(9),
    VALUE_RANGE_FILTER(15),
    CELLS_PER_ROW_OFFSET_FILTER(10),
    CELLS_PER_ROW_LIMIT_FILTER(11),
    CELLS_PER_COLUMN_LIMIT_FILTER(12),
    STRIP_VALUE_TRANSFORMER(13),
    APPLY_LABEL_TRANSFORMER(19),
    FILTER_NOT_SET(0);
    private final int value;

    private FilterCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static FilterCase valueOf(int value) {
      return forNumber(value);
    }

    public static FilterCase forNumber(int value) {
      switch (value) {
        case 1:
          return CHAIN;
        case 2:
          return INTERLEAVE;
        case 3:
          return CONDITION;
        case 16:
          return SINK;
        case 17:
          return PASS_ALL_FILTER;
        case 18:
          return BLOCK_ALL_FILTER;
        case 4:
          return ROW_KEY_REGEX_FILTER;
        case 14:
          return ROW_SAMPLE_FILTER;
        case 5:
          return FAMILY_NAME_REGEX_FILTER;
        case 6:
          return COLUMN_QUALIFIER_REGEX_FILTER;
        case 7:
          return COLUMN_RANGE_FILTER;
        case 8:
          return TIMESTAMP_RANGE_FILTER;
        case 9:
          return VALUE_REGEX_FILTER;
        case 15:
          return VALUE_RANGE_FILTER;
        case 10:
          return CELLS_PER_ROW_OFFSET_FILTER;
        case 11:
          return CELLS_PER_ROW_LIMIT_FILTER;
        case 12:
          return CELLS_PER_COLUMN_LIMIT_FILTER;
        case 13:
          return STRIP_VALUE_TRANSFORMER;
        case 19:
          return APPLY_LABEL_TRANSFORMER;
        case 0:
          return FILTER_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public FilterCase getFilterCase() {
    return FilterCase.forNumber(filterCase_);
  }

  public static final int CHAIN_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Applies several RowFilters to the data in sequence, progressively
   * narrowing the results.
   * </pre>
   *
   * <code>.google.bigtable.v2.RowFilter.Chain chain = 1;</code>
   *
   * @return Whether the chain field is set.
   */
  @java.lang.Override
  public boolean hasChain() {
    return filterCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Applies several RowFilters to the data in sequence, progressively
   * narrowing the results.
   * </pre>
   *
   * <code>.google.bigtable.v2.RowFilter.Chain chain = 1;</code>
   *
   * @return The chain.
   */
  @java.lang.Override
  public com.google.bigtable.v2.RowFilter.Chain getChain() {
    if (filterCase_ == 1) {
      return (com.google.bigtable.v2.RowFilter.Chain) filter_;
    }
    return com.google.bigtable.v2.RowFilter.Chain.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Applies several RowFilters to the data in sequence, progressively
   * narrowing the results.
   * </pre>
   *
   * <code>.google.bigtable.v2.RowFilter.Chain chain = 1;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.RowFilter.ChainOrBuilder getChainOrBuilder() {
    if (filterCase_ == 1) {
      return (com.google.bigtable.v2.RowFilter.Chain) filter_;
    }
    return com.google.bigtable.v2.RowFilter.Chain.getDefaultInstance();
  }

  public static final int INTERLEAVE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Applies several RowFilters to the data in parallel and combines the
   * results.
   * </pre>
   *
   * <code>.google.bigtable.v2.RowFilter.Interleave interleave = 2;</code>
   *
   * @return Whether the interleave field is set.
   */
  @java.lang.Override
  public boolean hasInterleave() {
    return filterCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Applies several RowFilters to the data in parallel and combines the
   * results.
   * </pre>
   *
   * <code>.google.bigtable.v2.RowFilter.Interleave interleave = 2;</code>
   *
   * @return The interleave.
   */
  @java.lang.Override
  public com.google.bigtable.v2.RowFilter.Interleave getInterleave() {
    if (filterCase_ == 2) {
      return (com.google.bigtable.v2.RowFilter.Interleave) filter_;
    }
    return com.google.bigtable.v2.RowFilter.Interleave.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Applies several RowFilters to the data in parallel and combines the
   * results.
   * </pre>
   *
   * <code>.google.bigtable.v2.RowFilter.Interleave interleave = 2;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.RowFilter.InterleaveOrBuilder getInterleaveOrBuilder() {
    if (filterCase_ == 2) {
      return (com.google.bigtable.v2.RowFilter.Interleave) filter_;
    }
    return com.google.bigtable.v2.RowFilter.Interleave.getDefaultInstance();
  }

  public static final int CONDITION_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Applies one of two possible RowFilters to the data based on the output of
   * a predicate RowFilter.
   * </pre>
   *
   * <code>.google.bigtable.v2.RowFilter.Condition condition = 3;</code>
   *
   * @return Whether the condition field is set.
   */
  @java.lang.Override
  public boolean hasCondition() {
    return filterCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Applies one of two possible RowFilters to the data based on the output of
   * a predicate RowFilter.
   * </pre>
   *
   * <code>.google.bigtable.v2.RowFilter.Condition condition = 3;</code>
   *
   * @return The condition.
   */
  @java.lang.Override
  public com.google.bigtable.v2.RowFilter.Condition getCondition() {
    if (filterCase_ == 3) {
      return (com.google.bigtable.v2.RowFilter.Condition) filter_;
    }
    return com.google.bigtable.v2.RowFilter.Condition.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Applies one of two possible RowFilters to the data based on the output of
   * a predicate RowFilter.
   * </pre>
   *
   * <code>.google.bigtable.v2.RowFilter.Condition condition = 3;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.RowFilter.ConditionOrBuilder getConditionOrBuilder() {
    if (filterCase_ == 3) {
      return (com.google.bigtable.v2.RowFilter.Condition) filter_;
    }
    return com.google.bigtable.v2.RowFilter.Condition.getDefaultInstance();
  }

  public static final int SINK_FIELD_NUMBER = 16;
  /**
   *
   *
   * <pre>
   * ADVANCED USE ONLY.
   * Hook for introspection into the RowFilter. Outputs all cells directly to
   * the output of the read rather than to any parent filter. Consider the
   * following example:
   *     Chain(
   *       FamilyRegex("A"),
   *       Interleave(
   *         All(),
   *         Chain(Label("foo"), Sink())
   *       ),
   *       QualifierRegex("B")
   *     )
   *                         A,A,1,w
   *                         A,B,2,x
   *                         B,B,4,z
   *                            |
   *                     FamilyRegex("A")
   *                            |
   *                         A,A,1,w
   *                         A,B,2,x
   *                            |
   *               +------------+-------------+
   *               |                          |
   *             All()                    Label(foo)
   *               |                          |
   *            A,A,1,w              A,A,1,w,labels:[foo]
   *            A,B,2,x              A,B,2,x,labels:[foo]
   *               |                          |
   *               |                        Sink() --------------+
   *               |                          |                  |
   *               +------------+      x------+          A,A,1,w,labels:[foo]
   *                            |                        A,B,2,x,labels:[foo]
   *                         A,A,1,w                             |
   *                         A,B,2,x                             |
   *                            |                                |
   *                    QualifierRegex("B")                      |
   *                            |                                |
   *                         A,B,2,x                             |
   *                            |                                |
   *                            +--------------------------------+
   *                            |
   *                         A,A,1,w,labels:[foo]
   *                         A,B,2,x,labels:[foo]  // could be switched
   *                         A,B,2,x               // could be switched
   * Despite being excluded by the qualifier filter, a copy of every cell
   * that reaches the sink is present in the final result.
   * As with an [Interleave][google.bigtable.v2.RowFilter.Interleave],
   * duplicate cells are possible, and appear in an unspecified mutual order.
   * In this case we have a duplicate with column "A:B" and timestamp 2,
   * because one copy passed through the all filter while the other was
   * passed through the label and sink. Note that one copy has label "foo",
   * while the other does not.
   * Cannot be used within the `predicate_filter`, `true_filter`, or
   * `false_filter` of a [Condition][google.bigtable.v2.RowFilter.Condition].
   * </pre>
   *
   * <code>bool sink = 16;</code>
   *
   * @return The sink.
   */
  @java.lang.Override
  public boolean getSink() {
    if (filterCase_ == 16) {
      return (java.lang.Boolean) filter_;
    }
    return false;
  }

  public static final int PASS_ALL_FILTER_FIELD_NUMBER = 17;
  /**
   *
   *
   * <pre>
   * Matches all cells, regardless of input. Functionally equivalent to
   * leaving `filter` unset, but included for completeness.
   * </pre>
   *
   * <code>bool pass_all_filter = 17;</code>
   *
   * @return The passAllFilter.
   */
  @java.lang.Override
  public boolean getPassAllFilter() {
    if (filterCase_ == 17) {
      return (java.lang.Boolean) filter_;
    }
    return false;
  }

  public static final int BLOCK_ALL_FILTER_FIELD_NUMBER = 18;
  /**
   *
   *
   * <pre>
   * Does not match any cells, regardless of input. Useful for temporarily
   * disabling just part of a filter.
   * </pre>
   *
   * <code>bool block_all_filter = 18;</code>
   *
   * @return The blockAllFilter.
   */
  @java.lang.Override
  public boolean getBlockAllFilter() {
    if (filterCase_ == 18) {
      return (java.lang.Boolean) filter_;
    }
    return false;
  }

  public static final int ROW_KEY_REGEX_FILTER_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Matches only cells from rows whose keys satisfy the given RE2 regex. In
   * other words, passes through the entire row when the key matches, and
   * otherwise produces an empty row.
   * Note that, since row keys can contain arbitrary bytes, the `&#92;C` escape
   * sequence must be used if a true wildcard is desired. The `.` character
   * will not match the new line character `&#92;n`, which may be present in a
   * binary key.
   * </pre>
   *
   * <code>bytes row_key_regex_filter = 4;</code>
   *
   * @return The rowKeyRegexFilter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRowKeyRegexFilter() {
    if (filterCase_ == 4) {
      return (com.google.protobuf.ByteString) filter_;
    }
    return com.google.protobuf.ByteString.EMPTY;
  }

  public static final int ROW_SAMPLE_FILTER_FIELD_NUMBER = 14;
  /**
   *
   *
   * <pre>
   * Matches all cells from a row with probability p, and matches no cells
   * from the row with probability 1-p.
   * </pre>
   *
   * <code>double row_sample_filter = 14;</code>
   *
   * @return The rowSampleFilter.
   */
  @java.lang.Override
  public double getRowSampleFilter() {
    if (filterCase_ == 14) {
      return (java.lang.Double) filter_;
    }
    return 0D;
  }

  public static final int FAMILY_NAME_REGEX_FILTER_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Matches only cells from columns whose families satisfy the given RE2
   * regex. For technical reasons, the regex must not contain the `:`
   * character, even if it is not being used as a literal.
   * Note that, since column families cannot contain the new line character
   * `&#92;n`, it is sufficient to use `.` as a full wildcard when matching
   * column family names.
   * </pre>
   *
   * <code>string family_name_regex_filter = 5;</code>
   *
   * @return The familyNameRegexFilter.
   */
  public java.lang.String getFamilyNameRegexFilter() {
    java.lang.Object ref = "";
    if (filterCase_ == 5) {
      ref = filter_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (filterCase_ == 5) {
        filter_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Matches only cells from columns whose families satisfy the given RE2
   * regex. For technical reasons, the regex must not contain the `:`
   * character, even if it is not being used as a literal.
   * Note that, since column families cannot contain the new line character
   * `&#92;n`, it is sufficient to use `.` as a full wildcard when matching
   * column family names.
   * </pre>
   *
   * <code>string family_name_regex_filter = 5;</code>
   *
   * @return The bytes for familyNameRegexFilter.
   */
  public com.google.protobuf.ByteString getFamilyNameRegexFilterBytes() {
    java.lang.Object ref = "";
    if (filterCase_ == 5) {
      ref = filter_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (filterCase_ == 5) {
        filter_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COLUMN_QUALIFIER_REGEX_FILTER_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * Matches only cells from columns whose qualifiers satisfy the given RE2
   * regex.
   * Note that, since column qualifiers can contain arbitrary bytes, the `&#92;C`
   * escape sequence must be used if a true wildcard is desired. The `.`
   * character will not match the new line character `&#92;n`, which may be
   * present in a binary qualifier.
   * </pre>
   *
   * <code>bytes column_qualifier_regex_filter = 6;</code>
   *
   * @return The columnQualifierRegexFilter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getColumnQualifierRegexFilter() {
    if (filterCase_ == 6) {
      return (com.google.protobuf.ByteString) filter_;
    }
    return com.google.protobuf.ByteString.EMPTY;
  }

  public static final int COLUMN_RANGE_FILTER_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * Matches only cells from columns within the given range.
   * </pre>
   *
   * <code>.google.bigtable.v2.ColumnRange column_range_filter = 7;</code>
   *
   * @return Whether the columnRangeFilter field is set.
   */
  @java.lang.Override
  public boolean hasColumnRangeFilter() {
    return filterCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * Matches only cells from columns within the given range.
   * </pre>
   *
   * <code>.google.bigtable.v2.ColumnRange column_range_filter = 7;</code>
   *
   * @return The columnRangeFilter.
   */
  @java.lang.Override
  public com.google.bigtable.v2.ColumnRange getColumnRangeFilter() {
    if (filterCase_ == 7) {
      return (com.google.bigtable.v2.ColumnRange) filter_;
    }
    return com.google.bigtable.v2.ColumnRange.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Matches only cells from columns within the given range.
   * </pre>
   *
   * <code>.google.bigtable.v2.ColumnRange column_range_filter = 7;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.ColumnRangeOrBuilder getColumnRangeFilterOrBuilder() {
    if (filterCase_ == 7) {
      return (com.google.bigtable.v2.ColumnRange) filter_;
    }
    return com.google.bigtable.v2.ColumnRange.getDefaultInstance();
  }

  public static final int TIMESTAMP_RANGE_FILTER_FIELD_NUMBER = 8;
  /**
   *
   *
   * <pre>
   * Matches only cells with timestamps within the given range.
   * </pre>
   *
   * <code>.google.bigtable.v2.TimestampRange timestamp_range_filter = 8;</code>
   *
   * @return Whether the timestampRangeFilter field is set.
   */
  @java.lang.Override
  public boolean hasTimestampRangeFilter() {
    return filterCase_ == 8;
  }
  /**
   *
   *
   * <pre>
   * Matches only cells with timestamps within the given range.
   * </pre>
   *
   * <code>.google.bigtable.v2.TimestampRange timestamp_range_filter = 8;</code>
   *
   * @return The timestampRangeFilter.
   */
  @java.lang.Override
  public com.google.bigtable.v2.TimestampRange getTimestampRangeFilter() {
    if (filterCase_ == 8) {
      return (com.google.bigtable.v2.TimestampRange) filter_;
    }
    return com.google.bigtable.v2.TimestampRange.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Matches only cells with timestamps within the given range.
   * </pre>
   *
   * <code>.google.bigtable.v2.TimestampRange timestamp_range_filter = 8;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.TimestampRangeOrBuilder getTimestampRangeFilterOrBuilder() {
    if (filterCase_ == 8) {
      return (com.google.bigtable.v2.TimestampRange) filter_;
    }
    return com.google.bigtable.v2.TimestampRange.getDefaultInstance();
  }

  public static final int VALUE_REGEX_FILTER_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * Matches only cells with values that satisfy the given regular expression.
   * Note that, since cell values can contain arbitrary bytes, the `&#92;C` escape
   * sequence must be used if a true wildcard is desired. The `.` character
   * will not match the new line character `&#92;n`, which may be present in a
   * binary value.
   * </pre>
   *
   * <code>bytes value_regex_filter = 9;</code>
   *
   * @return The valueRegexFilter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getValueRegexFilter() {
    if (filterCase_ == 9) {
      return (com.google.protobuf.ByteString) filter_;
    }
    return com.google.protobuf.ByteString.EMPTY;
  }

  public static final int VALUE_RANGE_FILTER_FIELD_NUMBER = 15;
  /**
   *
   *
   * <pre>
   * Matches only cells with values that fall within the given range.
   * </pre>
   *
   * <code>.google.bigtable.v2.ValueRange value_range_filter = 15;</code>
   *
   * @return Whether the valueRangeFilter field is set.
   */
  @java.lang.Override
  public boolean hasValueRangeFilter() {
    return filterCase_ == 15;
  }
  /**
   *
   *
   * <pre>
   * Matches only cells with values that fall within the given range.
   * </pre>
   *
   * <code>.google.bigtable.v2.ValueRange value_range_filter = 15;</code>
   *
   * @return The valueRangeFilter.
   */
  @java.lang.Override
  public com.google.bigtable.v2.ValueRange getValueRangeFilter() {
    if (filterCase_ == 15) {
      return (com.google.bigtable.v2.ValueRange) filter_;
    }
    return com.google.bigtable.v2.ValueRange.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Matches only cells with values that fall within the given range.
   * </pre>
   *
   * <code>.google.bigtable.v2.ValueRange value_range_filter = 15;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.ValueRangeOrBuilder getValueRangeFilterOrBuilder() {
    if (filterCase_ == 15) {
      return (com.google.bigtable.v2.ValueRange) filter_;
    }
    return com.google.bigtable.v2.ValueRange.getDefaultInstance();
  }

  public static final int CELLS_PER_ROW_OFFSET_FILTER_FIELD_NUMBER = 10;
  /**
   *
   *
   * <pre>
   * Skips the first N cells of each row, matching all subsequent cells.
   * If duplicate cells are present, as is possible when using an Interleave,
   * each copy of the cell is counted separately.
   * </pre>
   *
   * <code>int32 cells_per_row_offset_filter = 10;</code>
   *
   * @return The cellsPerRowOffsetFilter.
   */
  @java.lang.Override
  public int getCellsPerRowOffsetFilter() {
    if (filterCase_ == 10) {
      return (java.lang.Integer) filter_;
    }
    return 0;
  }

  public static final int CELLS_PER_ROW_LIMIT_FILTER_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * Matches only the first N cells of each row.
   * If duplicate cells are present, as is possible when using an Interleave,
   * each copy of the cell is counted separately.
   * </pre>
   *
   * <code>int32 cells_per_row_limit_filter = 11;</code>
   *
   * @return The cellsPerRowLimitFilter.
   */
  @java.lang.Override
  public int getCellsPerRowLimitFilter() {
    if (filterCase_ == 11) {
      return (java.lang.Integer) filter_;
    }
    return 0;
  }

  public static final int CELLS_PER_COLUMN_LIMIT_FILTER_FIELD_NUMBER = 12;
  /**
   *
   *
   * <pre>
   * Matches only the most recent N cells within each column. For example,
   * if N=2, this filter would match column `foo:bar` at timestamps 10 and 9,
   * skip all earlier cells in `foo:bar`, and then begin matching again in
   * column `foo:bar2`.
   * If duplicate cells are present, as is possible when using an Interleave,
   * each copy of the cell is counted separately.
   * </pre>
   *
   * <code>int32 cells_per_column_limit_filter = 12;</code>
   *
   * @return The cellsPerColumnLimitFilter.
   */
  @java.lang.Override
  public int getCellsPerColumnLimitFilter() {
    if (filterCase_ == 12) {
      return (java.lang.Integer) filter_;
    }
    return 0;
  }

  public static final int STRIP_VALUE_TRANSFORMER_FIELD_NUMBER = 13;
  /**
   *
   *
   * <pre>
   * Replaces each cell's value with the empty string.
   * </pre>
   *
   * <code>bool strip_value_transformer = 13;</code>
   *
   * @return The stripValueTransformer.
   */
  @java.lang.Override
  public boolean getStripValueTransformer() {
    if (filterCase_ == 13) {
      return (java.lang.Boolean) filter_;
    }
    return false;
  }

  public static final int APPLY_LABEL_TRANSFORMER_FIELD_NUMBER = 19;
  /**
   *
   *
   * <pre>
   * Applies the given label to all cells in the output row. This allows
   * the client to determine which results were produced from which part of
   * the filter.
   * Values must be at most 15 characters in length, and match the RE2
   * pattern `[a-z0-9&#92;&#92;-]+`
   * Due to a technical limitation, it is not currently possible to apply
   * multiple labels to a cell. As a result, a Chain may have no more than
   * one sub-filter which contains a `apply_label_transformer`. It is okay for
   * an Interleave to contain multiple `apply_label_transformers`, as they
   * will be applied to separate copies of the input. This may be relaxed in
   * the future.
   * </pre>
   *
   * <code>string apply_label_transformer = 19;</code>
   *
   * @return The applyLabelTransformer.
   */
  public java.lang.String getApplyLabelTransformer() {
    java.lang.Object ref = "";
    if (filterCase_ == 19) {
      ref = filter_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (filterCase_ == 19) {
        filter_ = s;
      }
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Applies the given label to all cells in the output row. This allows
   * the client to determine which results were produced from which part of
   * the filter.
   * Values must be at most 15 characters in length, and match the RE2
   * pattern `[a-z0-9&#92;&#92;-]+`
   * Due to a technical limitation, it is not currently possible to apply
   * multiple labels to a cell. As a result, a Chain may have no more than
   * one sub-filter which contains a `apply_label_transformer`. It is okay for
   * an Interleave to contain multiple `apply_label_transformers`, as they
   * will be applied to separate copies of the input. This may be relaxed in
   * the future.
   * </pre>
   *
   * <code>string apply_label_transformer = 19;</code>
   *
   * @return The bytes for applyLabelTransformer.
   */
  public com.google.protobuf.ByteString getApplyLabelTransformerBytes() {
    java.lang.Object ref = "";
    if (filterCase_ == 19) {
      ref = filter_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (filterCase_ == 19) {
        filter_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (filterCase_ == 1) {
      output.writeMessage(1, (com.google.bigtable.v2.RowFilter.Chain) filter_);
    }
    if (filterCase_ == 2) {
      output.writeMessage(2, (com.google.bigtable.v2.RowFilter.Interleave) filter_);
    }
    if (filterCase_ == 3) {
      output.writeMessage(3, (com.google.bigtable.v2.RowFilter.Condition) filter_);
    }
    if (filterCase_ == 4) {
      output.writeBytes(4, (com.google.protobuf.ByteString) filter_);
    }
    if (filterCase_ == 5) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, filter_);
    }
    if (filterCase_ == 6) {
      output.writeBytes(6, (com.google.protobuf.ByteString) filter_);
    }
    if (filterCase_ == 7) {
      output.writeMessage(7, (com.google.bigtable.v2.ColumnRange) filter_);
    }
    if (filterCase_ == 8) {
      output.writeMessage(8, (com.google.bigtable.v2.TimestampRange) filter_);
    }
    if (filterCase_ == 9) {
      output.writeBytes(9, (com.google.protobuf.ByteString) filter_);
    }
    if (filterCase_ == 10) {
      output.writeInt32(10, (int) ((java.lang.Integer) filter_));
    }
    if (filterCase_ == 11) {
      output.writeInt32(11, (int) ((java.lang.Integer) filter_));
    }
    if (filterCase_ == 12) {
      output.writeInt32(12, (int) ((java.lang.Integer) filter_));
    }
    if (filterCase_ == 13) {
      output.writeBool(13, (boolean) ((java.lang.Boolean) filter_));
    }
    if (filterCase_ == 14) {
      output.writeDouble(14, (double) ((java.lang.Double) filter_));
    }
    if (filterCase_ == 15) {
      output.writeMessage(15, (com.google.bigtable.v2.ValueRange) filter_);
    }
    if (filterCase_ == 16) {
      output.writeBool(16, (boolean) ((java.lang.Boolean) filter_));
    }
    if (filterCase_ == 17) {
      output.writeBool(17, (boolean) ((java.lang.Boolean) filter_));
    }
    if (filterCase_ == 18) {
      output.writeBool(18, (boolean) ((java.lang.Boolean) filter_));
    }
    if (filterCase_ == 19) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 19, filter_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (filterCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.bigtable.v2.RowFilter.Chain) filter_);
    }
    if (filterCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.bigtable.v2.RowFilter.Interleave) filter_);
    }
    if (filterCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.bigtable.v2.RowFilter.Condition) filter_);
    }
    if (filterCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBytesSize(
              4, (com.google.protobuf.ByteString) filter_);
    }
    if (filterCase_ == 5) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, filter_);
    }
    if (filterCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBytesSize(
              6, (com.google.protobuf.ByteString) filter_);
    }
    if (filterCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.bigtable.v2.ColumnRange) filter_);
    }
    if (filterCase_ == 8) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              8, (com.google.bigtable.v2.TimestampRange) filter_);
    }
    if (filterCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBytesSize(
              9, (com.google.protobuf.ByteString) filter_);
    }
    if (filterCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              10, (int) ((java.lang.Integer) filter_));
    }
    if (filterCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              11, (int) ((java.lang.Integer) filter_));
    }
    if (filterCase_ == 12) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              12, (int) ((java.lang.Integer) filter_));
    }
    if (filterCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              13, (boolean) ((java.lang.Boolean) filter_));
    }
    if (filterCase_ == 14) {
      size +=
          com.google.protobuf.CodedOutputStream.computeDoubleSize(
              14, (double) ((java.lang.Double) filter_));
    }
    if (filterCase_ == 15) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              15, (com.google.bigtable.v2.ValueRange) filter_);
    }
    if (filterCase_ == 16) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              16, (boolean) ((java.lang.Boolean) filter_));
    }
    if (filterCase_ == 17) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              17, (boolean) ((java.lang.Boolean) filter_));
    }
    if (filterCase_ == 18) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              18, (boolean) ((java.lang.Boolean) filter_));
    }
    if (filterCase_ == 19) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(19, filter_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.v2.RowFilter)) {
      return super.equals(obj);
    }
    com.google.bigtable.v2.RowFilter other = (com.google.bigtable.v2.RowFilter) obj;

    if (!getFilterCase().equals(other.getFilterCase())) return false;
    switch (filterCase_) {
      case 1:
        if (!getChain().equals(other.getChain())) return false;
        break;
      case 2:
        if (!getInterleave().equals(other.getInterleave())) return false;
        break;
      case 3:
        if (!getCondition().equals(other.getCondition())) return false;
        break;
      case 16:
        if (getSink() != other.getSink()) return false;
        break;
      case 17:
        if (getPassAllFilter() != other.getPassAllFilter()) return false;
        break;
      case 18:
        if (getBlockAllFilter() != other.getBlockAllFilter()) return false;
        break;
      case 4:
        if (!getRowKeyRegexFilter().equals(other.getRowKeyRegexFilter())) return false;
        break;
      case 14:
        if (java.lang.Double.doubleToLongBits(getRowSampleFilter())
            != java.lang.Double.doubleToLongBits(other.getRowSampleFilter())) return false;
        break;
      case 5:
        if (!getFamilyNameRegexFilter().equals(other.getFamilyNameRegexFilter())) return false;
        break;
      case 6:
        if (!getColumnQualifierRegexFilter().equals(other.getColumnQualifierRegexFilter()))
          return false;
        break;
      case 7:
        if (!getColumnRangeFilter().equals(other.getColumnRangeFilter())) return false;
        break;
      case 8:
        if (!getTimestampRangeFilter().equals(other.getTimestampRangeFilter())) return false;
        break;
      case 9:
        if (!getValueRegexFilter().equals(other.getValueRegexFilter())) return false;
        break;
      case 15:
        if (!getValueRangeFilter().equals(other.getValueRangeFilter())) return false;
        break;
      case 10:
        if (getCellsPerRowOffsetFilter() != other.getCellsPerRowOffsetFilter()) return false;
        break;
      case 11:
        if (getCellsPerRowLimitFilter() != other.getCellsPerRowLimitFilter()) return false;
        break;
      case 12:
        if (getCellsPerColumnLimitFilter() != other.getCellsPerColumnLimitFilter()) return false;
        break;
      case 13:
        if (getStripValueTransformer() != other.getStripValueTransformer()) return false;
        break;
      case 19:
        if (!getApplyLabelTransformer().equals(other.getApplyLabelTransformer())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (filterCase_) {
      case 1:
        hash = (37 * hash) + CHAIN_FIELD_NUMBER;
        hash = (53 * hash) + getChain().hashCode();
        break;
      case 2:
        hash = (37 * hash) + INTERLEAVE_FIELD_NUMBER;
        hash = (53 * hash) + getInterleave().hashCode();
        break;
      case 3:
        hash = (37 * hash) + CONDITION_FIELD_NUMBER;
        hash = (53 * hash) + getCondition().hashCode();
        break;
      case 16:
        hash = (37 * hash) + SINK_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSink());
        break;
      case 17:
        hash = (37 * hash) + PASS_ALL_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPassAllFilter());
        break;
      case 18:
        hash = (37 * hash) + BLOCK_ALL_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getBlockAllFilter());
        break;
      case 4:
        hash = (37 * hash) + ROW_KEY_REGEX_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getRowKeyRegexFilter().hashCode();
        break;
      case 14:
        hash = (37 * hash) + ROW_SAMPLE_FILTER_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getRowSampleFilter()));
        break;
      case 5:
        hash = (37 * hash) + FAMILY_NAME_REGEX_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getFamilyNameRegexFilter().hashCode();
        break;
      case 6:
        hash = (37 * hash) + COLUMN_QUALIFIER_REGEX_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getColumnQualifierRegexFilter().hashCode();
        break;
      case 7:
        hash = (37 * hash) + COLUMN_RANGE_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getColumnRangeFilter().hashCode();
        break;
      case 8:
        hash = (37 * hash) + TIMESTAMP_RANGE_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getTimestampRangeFilter().hashCode();
        break;
      case 9:
        hash = (37 * hash) + VALUE_REGEX_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getValueRegexFilter().hashCode();
        break;
      case 15:
        hash = (37 * hash) + VALUE_RANGE_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getValueRangeFilter().hashCode();
        break;
      case 10:
        hash = (37 * hash) + CELLS_PER_ROW_OFFSET_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getCellsPerRowOffsetFilter();
        break;
      case 11:
        hash = (37 * hash) + CELLS_PER_ROW_LIMIT_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getCellsPerRowLimitFilter();
        break;
      case 12:
        hash = (37 * hash) + CELLS_PER_COLUMN_LIMIT_FILTER_FIELD_NUMBER;
        hash = (53 * hash) + getCellsPerColumnLimitFilter();
        break;
      case 13:
        hash = (37 * hash) + STRIP_VALUE_TRANSFORMER_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getStripValueTransformer());
        break;
      case 19:
        hash = (37 * hash) + APPLY_LABEL_TRANSFORMER_FIELD_NUMBER;
        hash = (53 * hash) + getApplyLabelTransformer().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.v2.RowFilter parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.RowFilter parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.RowFilter parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.RowFilter parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.RowFilter parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.RowFilter parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.RowFilter parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.RowFilter parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.RowFilter parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.RowFilter parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.RowFilter parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.RowFilter parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.v2.RowFilter prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Takes a row as input and produces an alternate view of the row based on
   * specified rules. For example, a RowFilter might trim down a row to include
   * just the cells from columns matching a given regular expression, or might
   * return all the cells of a row but not their values. More complicated filters
   * can be composed out of these components to express requests such as, "within
   * every column of a particular family, give just the two most recent cells
   * which are older than timestamp X."
   * There are two broad categories of RowFilters (true filters and transformers),
   * as well as two ways to compose simple filters into more complex ones
   * (chains and interleaves). They work as follows:
   * * True filters alter the input row by excluding some of its cells wholesale
   * from the output row. An example of a true filter is the `value_regex_filter`,
   * which excludes cells whose values don't match the specified pattern. All
   * regex true filters use RE2 syntax (https://github.com/google/re2/wiki/Syntax)
   * in raw byte mode (RE2::Latin1), and are evaluated as full matches. An
   * important point to keep in mind is that `RE2(.)` is equivalent by default to
   * `RE2([^&#92;n])`, meaning that it does not match newlines. When attempting to
   * match an arbitrary byte, you should therefore use the escape sequence `&#92;C`,
   * which may need to be further escaped as `&#92;&#92;C` in your client language.
   * * Transformers alter the input row by changing the values of some of its
   * cells in the output, without excluding them completely. Currently, the only
   * supported transformer is the `strip_value_transformer`, which replaces every
   * cell's value with the empty string.
   * * Chains and interleaves are described in more detail in the
   * RowFilter.Chain and RowFilter.Interleave documentation.
   * The total serialized size of a RowFilter message must not
   * exceed 4096 bytes, and RowFilters may not be nested within each other
   * (in Chains or Interleaves) to a depth of more than 20.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.RowFilter}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.v2.RowFilter)
      com.google.bigtable.v2.RowFilterOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.DataProto
          .internal_static_google_bigtable_v2_RowFilter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.DataProto
          .internal_static_google_bigtable_v2_RowFilter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.RowFilter.class,
              com.google.bigtable.v2.RowFilter.Builder.class);
    }

    // Construct using com.google.bigtable.v2.RowFilter.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      filterCase_ = 0;
      filter_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.v2.DataProto
          .internal_static_google_bigtable_v2_RowFilter_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.v2.RowFilter getDefaultInstanceForType() {
      return com.google.bigtable.v2.RowFilter.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.v2.RowFilter build() {
      com.google.bigtable.v2.RowFilter result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.v2.RowFilter buildPartial() {
      com.google.bigtable.v2.RowFilter result = new com.google.bigtable.v2.RowFilter(this);
      if (filterCase_ == 1) {
        if (chainBuilder_ == null) {
          result.filter_ = filter_;
        } else {
          result.filter_ = chainBuilder_.build();
        }
      }
      if (filterCase_ == 2) {
        if (interleaveBuilder_ == null) {
          result.filter_ = filter_;
        } else {
          result.filter_ = interleaveBuilder_.build();
        }
      }
      if (filterCase_ == 3) {
        if (conditionBuilder_ == null) {
          result.filter_ = filter_;
        } else {
          result.filter_ = conditionBuilder_.build();
        }
      }
      if (filterCase_ == 16) {
        result.filter_ = filter_;
      }
      if (filterCase_ == 17) {
        result.filter_ = filter_;
      }
      if (filterCase_ == 18) {
        result.filter_ = filter_;
      }
      if (filterCase_ == 4) {
        result.filter_ = filter_;
      }
      if (filterCase_ == 14) {
        result.filter_ = filter_;
      }
      if (filterCase_ == 5) {
        result.filter_ = filter_;
      }
      if (filterCase_ == 6) {
        result.filter_ = filter_;
      }
      if (filterCase_ == 7) {
        if (columnRangeFilterBuilder_ == null) {
          result.filter_ = filter_;
        } else {
          result.filter_ = columnRangeFilterBuilder_.build();
        }
      }
      if (filterCase_ == 8) {
        if (timestampRangeFilterBuilder_ == null) {
          result.filter_ = filter_;
        } else {
          result.filter_ = timestampRangeFilterBuilder_.build();
        }
      }
      if (filterCase_ == 9) {
        result.filter_ = filter_;
      }
      if (filterCase_ == 15) {
        if (valueRangeFilterBuilder_ == null) {
          result.filter_ = filter_;
        } else {
          result.filter_ = valueRangeFilterBuilder_.build();
        }
      }
      if (filterCase_ == 10) {
        result.filter_ = filter_;
      }
      if (filterCase_ == 11) {
        result.filter_ = filter_;
      }
      if (filterCase_ == 12) {
        result.filter_ = filter_;
      }
      if (filterCase_ == 13) {
        result.filter_ = filter_;
      }
      if (filterCase_ == 19) {
        result.filter_ = filter_;
      }
      result.filterCase_ = filterCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.v2.RowFilter) {
        return mergeFrom((com.google.bigtable.v2.RowFilter) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.v2.RowFilter other) {
      if (other == com.google.bigtable.v2.RowFilter.getDefaultInstance()) return this;
      switch (other.getFilterCase()) {
        case CHAIN:
          {
            mergeChain(other.getChain());
            break;
          }
        case INTERLEAVE:
          {
            mergeInterleave(other.getInterleave());
            break;
          }
        case CONDITION:
          {
            mergeCondition(other.getCondition());
            break;
          }
        case SINK:
          {
            setSink(other.getSink());
            break;
          }
        case PASS_ALL_FILTER:
          {
            setPassAllFilter(other.getPassAllFilter());
            break;
          }
        case BLOCK_ALL_FILTER:
          {
            setBlockAllFilter(other.getBlockAllFilter());
            break;
          }
        case ROW_KEY_REGEX_FILTER:
          {
            setRowKeyRegexFilter(other.getRowKeyRegexFilter());
            break;
          }
        case ROW_SAMPLE_FILTER:
          {
            setRowSampleFilter(other.getRowSampleFilter());
            break;
          }
        case FAMILY_NAME_REGEX_FILTER:
          {
            filterCase_ = 5;
            filter_ = other.filter_;
            onChanged();
            break;
          }
        case COLUMN_QUALIFIER_REGEX_FILTER:
          {
            setColumnQualifierRegexFilter(other.getColumnQualifierRegexFilter());
            break;
          }
        case COLUMN_RANGE_FILTER:
          {
            mergeColumnRangeFilter(other.getColumnRangeFilter());
            break;
          }
        case TIMESTAMP_RANGE_FILTER:
          {
            mergeTimestampRangeFilter(other.getTimestampRangeFilter());
            break;
          }
        case VALUE_REGEX_FILTER:
          {
            setValueRegexFilter(other.getValueRegexFilter());
            break;
          }
        case VALUE_RANGE_FILTER:
          {
            mergeValueRangeFilter(other.getValueRangeFilter());
            break;
          }
        case CELLS_PER_ROW_OFFSET_FILTER:
          {
            setCellsPerRowOffsetFilter(other.getCellsPerRowOffsetFilter());
            break;
          }
        case CELLS_PER_ROW_LIMIT_FILTER:
          {
            setCellsPerRowLimitFilter(other.getCellsPerRowLimitFilter());
            break;
          }
        case CELLS_PER_COLUMN_LIMIT_FILTER:
          {
            setCellsPerColumnLimitFilter(other.getCellsPerColumnLimitFilter());
            break;
          }
        case STRIP_VALUE_TRANSFORMER:
          {
            setStripValueTransformer(other.getStripValueTransformer());
            break;
          }
        case APPLY_LABEL_TRANSFORMER:
          {
            filterCase_ = 19;
            filter_ = other.filter_;
            onChanged();
            break;
          }
        case FILTER_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.bigtable.v2.RowFilter parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.bigtable.v2.RowFilter) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int filterCase_ = 0;
    private java.lang.Object filter_;

    public FilterCase getFilterCase() {
      return FilterCase.forNumber(filterCase_);
    }

    public Builder clearFilter() {
      filterCase_ = 0;
      filter_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.RowFilter.Chain,
            com.google.bigtable.v2.RowFilter.Chain.Builder,
            com.google.bigtable.v2.RowFilter.ChainOrBuilder>
        chainBuilder_;
    /**
     *
     *
     * <pre>
     * Applies several RowFilters to the data in sequence, progressively
     * narrowing the results.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter.Chain chain = 1;</code>
     *
     * @return Whether the chain field is set.
     */
    @java.lang.Override
    public boolean hasChain() {
      return filterCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Applies several RowFilters to the data in sequence, progressively
     * narrowing the results.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter.Chain chain = 1;</code>
     *
     * @return The chain.
     */
    @java.lang.Override
    public com.google.bigtable.v2.RowFilter.Chain getChain() {
      if (chainBuilder_ == null) {
        if (filterCase_ == 1) {
          return (com.google.bigtable.v2.RowFilter.Chain) filter_;
        }
        return com.google.bigtable.v2.RowFilter.Chain.getDefaultInstance();
      } else {
        if (filterCase_ == 1) {
          return chainBuilder_.getMessage();
        }
        return com.google.bigtable.v2.RowFilter.Chain.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Applies several RowFilters to the data in sequence, progressively
     * narrowing the results.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter.Chain chain = 1;</code>
     */
    public Builder setChain(com.google.bigtable.v2.RowFilter.Chain value) {
      if (chainBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        onChanged();
      } else {
        chainBuilder_.setMessage(value);
      }
      filterCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applies several RowFilters to the data in sequence, progressively
     * narrowing the results.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter.Chain chain = 1;</code>
     */
    public Builder setChain(com.google.bigtable.v2.RowFilter.Chain.Builder builderForValue) {
      if (chainBuilder_ == null) {
        filter_ = builderForValue.build();
        onChanged();
      } else {
        chainBuilder_.setMessage(builderForValue.build());
      }
      filterCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applies several RowFilters to the data in sequence, progressively
     * narrowing the results.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter.Chain chain = 1;</code>
     */
    public Builder mergeChain(com.google.bigtable.v2.RowFilter.Chain value) {
      if (chainBuilder_ == null) {
        if (filterCase_ == 1
            && filter_ != com.google.bigtable.v2.RowFilter.Chain.getDefaultInstance()) {
          filter_ =
              com.google.bigtable.v2.RowFilter.Chain.newBuilder(
                      (com.google.bigtable.v2.RowFilter.Chain) filter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          filter_ = value;
        }
        onChanged();
      } else {
        if (filterCase_ == 1) {
          chainBuilder_.mergeFrom(value);
        }
        chainBuilder_.setMessage(value);
      }
      filterCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applies several RowFilters to the data in sequence, progressively
     * narrowing the results.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter.Chain chain = 1;</code>
     */
    public Builder clearChain() {
      if (chainBuilder_ == null) {
        if (filterCase_ == 1) {
          filterCase_ = 0;
          filter_ = null;
          onChanged();
        }
      } else {
        if (filterCase_ == 1) {
          filterCase_ = 0;
          filter_ = null;
        }
        chainBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applies several RowFilters to the data in sequence, progressively
     * narrowing the results.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter.Chain chain = 1;</code>
     */
    public com.google.bigtable.v2.RowFilter.Chain.Builder getChainBuilder() {
      return getChainFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Applies several RowFilters to the data in sequence, progressively
     * narrowing the results.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter.Chain chain = 1;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.RowFilter.ChainOrBuilder getChainOrBuilder() {
      if ((filterCase_ == 1) && (chainBuilder_ != null)) {
        return chainBuilder_.getMessageOrBuilder();
      } else {
        if (filterCase_ == 1) {
          return (com.google.bigtable.v2.RowFilter.Chain) filter_;
        }
        return com.google.bigtable.v2.RowFilter.Chain.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Applies several RowFilters to the data in sequence, progressively
     * narrowing the results.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter.Chain chain = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.RowFilter.Chain,
            com.google.bigtable.v2.RowFilter.Chain.Builder,
            com.google.bigtable.v2.RowFilter.ChainOrBuilder>
        getChainFieldBuilder() {
      if (chainBuilder_ == null) {
        if (!(filterCase_ == 1)) {
          filter_ = com.google.bigtable.v2.RowFilter.Chain.getDefaultInstance();
        }
        chainBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.v2.RowFilter.Chain,
                com.google.bigtable.v2.RowFilter.Chain.Builder,
                com.google.bigtable.v2.RowFilter.ChainOrBuilder>(
                (com.google.bigtable.v2.RowFilter.Chain) filter_,
                getParentForChildren(),
                isClean());
        filter_ = null;
      }
      filterCase_ = 1;
      onChanged();
      ;
      return chainBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.RowFilter.Interleave,
            com.google.bigtable.v2.RowFilter.Interleave.Builder,
            com.google.bigtable.v2.RowFilter.InterleaveOrBuilder>
        interleaveBuilder_;
    /**
     *
     *
     * <pre>
     * Applies several RowFilters to the data in parallel and combines the
     * results.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter.Interleave interleave = 2;</code>
     *
     * @return Whether the interleave field is set.
     */
    @java.lang.Override
    public boolean hasInterleave() {
      return filterCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Applies several RowFilters to the data in parallel and combines the
     * results.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter.Interleave interleave = 2;</code>
     *
     * @return The interleave.
     */
    @java.lang.Override
    public com.google.bigtable.v2.RowFilter.Interleave getInterleave() {
      if (interleaveBuilder_ == null) {
        if (filterCase_ == 2) {
          return (com.google.bigtable.v2.RowFilter.Interleave) filter_;
        }
        return com.google.bigtable.v2.RowFilter.Interleave.getDefaultInstance();
      } else {
        if (filterCase_ == 2) {
          return interleaveBuilder_.getMessage();
        }
        return com.google.bigtable.v2.RowFilter.Interleave.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Applies several RowFilters to the data in parallel and combines the
     * results.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter.Interleave interleave = 2;</code>
     */
    public Builder setInterleave(com.google.bigtable.v2.RowFilter.Interleave value) {
      if (interleaveBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        onChanged();
      } else {
        interleaveBuilder_.setMessage(value);
      }
      filterCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applies several RowFilters to the data in parallel and combines the
     * results.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter.Interleave interleave = 2;</code>
     */
    public Builder setInterleave(
        com.google.bigtable.v2.RowFilter.Interleave.Builder builderForValue) {
      if (interleaveBuilder_ == null) {
        filter_ = builderForValue.build();
        onChanged();
      } else {
        interleaveBuilder_.setMessage(builderForValue.build());
      }
      filterCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applies several RowFilters to the data in parallel and combines the
     * results.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter.Interleave interleave = 2;</code>
     */
    public Builder mergeInterleave(com.google.bigtable.v2.RowFilter.Interleave value) {
      if (interleaveBuilder_ == null) {
        if (filterCase_ == 2
            && filter_ != com.google.bigtable.v2.RowFilter.Interleave.getDefaultInstance()) {
          filter_ =
              com.google.bigtable.v2.RowFilter.Interleave.newBuilder(
                      (com.google.bigtable.v2.RowFilter.Interleave) filter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          filter_ = value;
        }
        onChanged();
      } else {
        if (filterCase_ == 2) {
          interleaveBuilder_.mergeFrom(value);
        }
        interleaveBuilder_.setMessage(value);
      }
      filterCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applies several RowFilters to the data in parallel and combines the
     * results.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter.Interleave interleave = 2;</code>
     */
    public Builder clearInterleave() {
      if (interleaveBuilder_ == null) {
        if (filterCase_ == 2) {
          filterCase_ = 0;
          filter_ = null;
          onChanged();
        }
      } else {
        if (filterCase_ == 2) {
          filterCase_ = 0;
          filter_ = null;
        }
        interleaveBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applies several RowFilters to the data in parallel and combines the
     * results.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter.Interleave interleave = 2;</code>
     */
    public com.google.bigtable.v2.RowFilter.Interleave.Builder getInterleaveBuilder() {
      return getInterleaveFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Applies several RowFilters to the data in parallel and combines the
     * results.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter.Interleave interleave = 2;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.RowFilter.InterleaveOrBuilder getInterleaveOrBuilder() {
      if ((filterCase_ == 2) && (interleaveBuilder_ != null)) {
        return interleaveBuilder_.getMessageOrBuilder();
      } else {
        if (filterCase_ == 2) {
          return (com.google.bigtable.v2.RowFilter.Interleave) filter_;
        }
        return com.google.bigtable.v2.RowFilter.Interleave.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Applies several RowFilters to the data in parallel and combines the
     * results.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter.Interleave interleave = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.RowFilter.Interleave,
            com.google.bigtable.v2.RowFilter.Interleave.Builder,
            com.google.bigtable.v2.RowFilter.InterleaveOrBuilder>
        getInterleaveFieldBuilder() {
      if (interleaveBuilder_ == null) {
        if (!(filterCase_ == 2)) {
          filter_ = com.google.bigtable.v2.RowFilter.Interleave.getDefaultInstance();
        }
        interleaveBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.v2.RowFilter.Interleave,
                com.google.bigtable.v2.RowFilter.Interleave.Builder,
                com.google.bigtable.v2.RowFilter.InterleaveOrBuilder>(
                (com.google.bigtable.v2.RowFilter.Interleave) filter_,
                getParentForChildren(),
                isClean());
        filter_ = null;
      }
      filterCase_ = 2;
      onChanged();
      ;
      return interleaveBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.RowFilter.Condition,
            com.google.bigtable.v2.RowFilter.Condition.Builder,
            com.google.bigtable.v2.RowFilter.ConditionOrBuilder>
        conditionBuilder_;
    /**
     *
     *
     * <pre>
     * Applies one of two possible RowFilters to the data based on the output of
     * a predicate RowFilter.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter.Condition condition = 3;</code>
     *
     * @return Whether the condition field is set.
     */
    @java.lang.Override
    public boolean hasCondition() {
      return filterCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Applies one of two possible RowFilters to the data based on the output of
     * a predicate RowFilter.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter.Condition condition = 3;</code>
     *
     * @return The condition.
     */
    @java.lang.Override
    public com.google.bigtable.v2.RowFilter.Condition getCondition() {
      if (conditionBuilder_ == null) {
        if (filterCase_ == 3) {
          return (com.google.bigtable.v2.RowFilter.Condition) filter_;
        }
        return com.google.bigtable.v2.RowFilter.Condition.getDefaultInstance();
      } else {
        if (filterCase_ == 3) {
          return conditionBuilder_.getMessage();
        }
        return com.google.bigtable.v2.RowFilter.Condition.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Applies one of two possible RowFilters to the data based on the output of
     * a predicate RowFilter.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter.Condition condition = 3;</code>
     */
    public Builder setCondition(com.google.bigtable.v2.RowFilter.Condition value) {
      if (conditionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        onChanged();
      } else {
        conditionBuilder_.setMessage(value);
      }
      filterCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applies one of two possible RowFilters to the data based on the output of
     * a predicate RowFilter.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter.Condition condition = 3;</code>
     */
    public Builder setCondition(
        com.google.bigtable.v2.RowFilter.Condition.Builder builderForValue) {
      if (conditionBuilder_ == null) {
        filter_ = builderForValue.build();
        onChanged();
      } else {
        conditionBuilder_.setMessage(builderForValue.build());
      }
      filterCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applies one of two possible RowFilters to the data based on the output of
     * a predicate RowFilter.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter.Condition condition = 3;</code>
     */
    public Builder mergeCondition(com.google.bigtable.v2.RowFilter.Condition value) {
      if (conditionBuilder_ == null) {
        if (filterCase_ == 3
            && filter_ != com.google.bigtable.v2.RowFilter.Condition.getDefaultInstance()) {
          filter_ =
              com.google.bigtable.v2.RowFilter.Condition.newBuilder(
                      (com.google.bigtable.v2.RowFilter.Condition) filter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          filter_ = value;
        }
        onChanged();
      } else {
        if (filterCase_ == 3) {
          conditionBuilder_.mergeFrom(value);
        }
        conditionBuilder_.setMessage(value);
      }
      filterCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applies one of two possible RowFilters to the data based on the output of
     * a predicate RowFilter.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter.Condition condition = 3;</code>
     */
    public Builder clearCondition() {
      if (conditionBuilder_ == null) {
        if (filterCase_ == 3) {
          filterCase_ = 0;
          filter_ = null;
          onChanged();
        }
      } else {
        if (filterCase_ == 3) {
          filterCase_ = 0;
          filter_ = null;
        }
        conditionBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applies one of two possible RowFilters to the data based on the output of
     * a predicate RowFilter.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter.Condition condition = 3;</code>
     */
    public com.google.bigtable.v2.RowFilter.Condition.Builder getConditionBuilder() {
      return getConditionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Applies one of two possible RowFilters to the data based on the output of
     * a predicate RowFilter.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter.Condition condition = 3;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.RowFilter.ConditionOrBuilder getConditionOrBuilder() {
      if ((filterCase_ == 3) && (conditionBuilder_ != null)) {
        return conditionBuilder_.getMessageOrBuilder();
      } else {
        if (filterCase_ == 3) {
          return (com.google.bigtable.v2.RowFilter.Condition) filter_;
        }
        return com.google.bigtable.v2.RowFilter.Condition.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Applies one of two possible RowFilters to the data based on the output of
     * a predicate RowFilter.
     * </pre>
     *
     * <code>.google.bigtable.v2.RowFilter.Condition condition = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.RowFilter.Condition,
            com.google.bigtable.v2.RowFilter.Condition.Builder,
            com.google.bigtable.v2.RowFilter.ConditionOrBuilder>
        getConditionFieldBuilder() {
      if (conditionBuilder_ == null) {
        if (!(filterCase_ == 3)) {
          filter_ = com.google.bigtable.v2.RowFilter.Condition.getDefaultInstance();
        }
        conditionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.v2.RowFilter.Condition,
                com.google.bigtable.v2.RowFilter.Condition.Builder,
                com.google.bigtable.v2.RowFilter.ConditionOrBuilder>(
                (com.google.bigtable.v2.RowFilter.Condition) filter_,
                getParentForChildren(),
                isClean());
        filter_ = null;
      }
      filterCase_ = 3;
      onChanged();
      ;
      return conditionBuilder_;
    }

    /**
     *
     *
     * <pre>
     * ADVANCED USE ONLY.
     * Hook for introspection into the RowFilter. Outputs all cells directly to
     * the output of the read rather than to any parent filter. Consider the
     * following example:
     *     Chain(
     *       FamilyRegex("A"),
     *       Interleave(
     *         All(),
     *         Chain(Label("foo"), Sink())
     *       ),
     *       QualifierRegex("B")
     *     )
     *                         A,A,1,w
     *                         A,B,2,x
     *                         B,B,4,z
     *                            |
     *                     FamilyRegex("A")
     *                            |
     *                         A,A,1,w
     *                         A,B,2,x
     *                            |
     *               +------------+-------------+
     *               |                          |
     *             All()                    Label(foo)
     *               |                          |
     *            A,A,1,w              A,A,1,w,labels:[foo]
     *            A,B,2,x              A,B,2,x,labels:[foo]
     *               |                          |
     *               |                        Sink() --------------+
     *               |                          |                  |
     *               +------------+      x------+          A,A,1,w,labels:[foo]
     *                            |                        A,B,2,x,labels:[foo]
     *                         A,A,1,w                             |
     *                         A,B,2,x                             |
     *                            |                                |
     *                    QualifierRegex("B")                      |
     *                            |                                |
     *                         A,B,2,x                             |
     *                            |                                |
     *                            +--------------------------------+
     *                            |
     *                         A,A,1,w,labels:[foo]
     *                         A,B,2,x,labels:[foo]  // could be switched
     *                         A,B,2,x               // could be switched
     * Despite being excluded by the qualifier filter, a copy of every cell
     * that reaches the sink is present in the final result.
     * As with an [Interleave][google.bigtable.v2.RowFilter.Interleave],
     * duplicate cells are possible, and appear in an unspecified mutual order.
     * In this case we have a duplicate with column "A:B" and timestamp 2,
     * because one copy passed through the all filter while the other was
     * passed through the label and sink. Note that one copy has label "foo",
     * while the other does not.
     * Cannot be used within the `predicate_filter`, `true_filter`, or
     * `false_filter` of a [Condition][google.bigtable.v2.RowFilter.Condition].
     * </pre>
     *
     * <code>bool sink = 16;</code>
     *
     * @return The sink.
     */
    public boolean getSink() {
      if (filterCase_ == 16) {
        return (java.lang.Boolean) filter_;
      }
      return false;
    }
    /**
     *
     *
     * <pre>
     * ADVANCED USE ONLY.
     * Hook for introspection into the RowFilter. Outputs all cells directly to
     * the output of the read rather than to any parent filter. Consider the
     * following example:
     *     Chain(
     *       FamilyRegex("A"),
     *       Interleave(
     *         All(),
     *         Chain(Label("foo"), Sink())
     *       ),
     *       QualifierRegex("B")
     *     )
     *                         A,A,1,w
     *                         A,B,2,x
     *                         B,B,4,z
     *                            |
     *                     FamilyRegex("A")
     *                            |
     *                         A,A,1,w
     *                         A,B,2,x
     *                            |
     *               +------------+-------------+
     *               |                          |
     *             All()                    Label(foo)
     *               |                          |
     *            A,A,1,w              A,A,1,w,labels:[foo]
     *            A,B,2,x              A,B,2,x,labels:[foo]
     *               |                          |
     *               |                        Sink() --------------+
     *               |                          |                  |
     *               +------------+      x------+          A,A,1,w,labels:[foo]
     *                            |                        A,B,2,x,labels:[foo]
     *                         A,A,1,w                             |
     *                         A,B,2,x                             |
     *                            |                                |
     *                    QualifierRegex("B")                      |
     *                            |                                |
     *                         A,B,2,x                             |
     *                            |                                |
     *                            +--------------------------------+
     *                            |
     *                         A,A,1,w,labels:[foo]
     *                         A,B,2,x,labels:[foo]  // could be switched
     *                         A,B,2,x               // could be switched
     * Despite being excluded by the qualifier filter, a copy of every cell
     * that reaches the sink is present in the final result.
     * As with an [Interleave][google.bigtable.v2.RowFilter.Interleave],
     * duplicate cells are possible, and appear in an unspecified mutual order.
     * In this case we have a duplicate with column "A:B" and timestamp 2,
     * because one copy passed through the all filter while the other was
     * passed through the label and sink. Note that one copy has label "foo",
     * while the other does not.
     * Cannot be used within the `predicate_filter`, `true_filter`, or
     * `false_filter` of a [Condition][google.bigtable.v2.RowFilter.Condition].
     * </pre>
     *
     * <code>bool sink = 16;</code>
     *
     * @param value The sink to set.
     * @return This builder for chaining.
     */
    public Builder setSink(boolean value) {
      filterCase_ = 16;
      filter_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * ADVANCED USE ONLY.
     * Hook for introspection into the RowFilter. Outputs all cells directly to
     * the output of the read rather than to any parent filter. Consider the
     * following example:
     *     Chain(
     *       FamilyRegex("A"),
     *       Interleave(
     *         All(),
     *         Chain(Label("foo"), Sink())
     *       ),
     *       QualifierRegex("B")
     *     )
     *                         A,A,1,w
     *                         A,B,2,x
     *                         B,B,4,z
     *                            |
     *                     FamilyRegex("A")
     *                            |
     *                         A,A,1,w
     *                         A,B,2,x
     *                            |
     *               +------------+-------------+
     *               |                          |
     *             All()                    Label(foo)
     *               |                          |
     *            A,A,1,w              A,A,1,w,labels:[foo]
     *            A,B,2,x              A,B,2,x,labels:[foo]
     *               |                          |
     *               |                        Sink() --------------+
     *               |                          |                  |
     *               +------------+      x------+          A,A,1,w,labels:[foo]
     *                            |                        A,B,2,x,labels:[foo]
     *                         A,A,1,w                             |
     *                         A,B,2,x                             |
     *                            |                                |
     *                    QualifierRegex("B")                      |
     *                            |                                |
     *                         A,B,2,x                             |
     *                            |                                |
     *                            +--------------------------------+
     *                            |
     *                         A,A,1,w,labels:[foo]
     *                         A,B,2,x,labels:[foo]  // could be switched
     *                         A,B,2,x               // could be switched
     * Despite being excluded by the qualifier filter, a copy of every cell
     * that reaches the sink is present in the final result.
     * As with an [Interleave][google.bigtable.v2.RowFilter.Interleave],
     * duplicate cells are possible, and appear in an unspecified mutual order.
     * In this case we have a duplicate with column "A:B" and timestamp 2,
     * because one copy passed through the all filter while the other was
     * passed through the label and sink. Note that one copy has label "foo",
     * while the other does not.
     * Cannot be used within the `predicate_filter`, `true_filter`, or
     * `false_filter` of a [Condition][google.bigtable.v2.RowFilter.Condition].
     * </pre>
     *
     * <code>bool sink = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSink() {
      if (filterCase_ == 16) {
        filterCase_ = 0;
        filter_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Matches all cells, regardless of input. Functionally equivalent to
     * leaving `filter` unset, but included for completeness.
     * </pre>
     *
     * <code>bool pass_all_filter = 17;</code>
     *
     * @return The passAllFilter.
     */
    public boolean getPassAllFilter() {
      if (filterCase_ == 17) {
        return (java.lang.Boolean) filter_;
      }
      return false;
    }
    /**
     *
     *
     * <pre>
     * Matches all cells, regardless of input. Functionally equivalent to
     * leaving `filter` unset, but included for completeness.
     * </pre>
     *
     * <code>bool pass_all_filter = 17;</code>
     *
     * @param value The passAllFilter to set.
     * @return This builder for chaining.
     */
    public Builder setPassAllFilter(boolean value) {
      filterCase_ = 17;
      filter_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matches all cells, regardless of input. Functionally equivalent to
     * leaving `filter` unset, but included for completeness.
     * </pre>
     *
     * <code>bool pass_all_filter = 17;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPassAllFilter() {
      if (filterCase_ == 17) {
        filterCase_ = 0;
        filter_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Does not match any cells, regardless of input. Useful for temporarily
     * disabling just part of a filter.
     * </pre>
     *
     * <code>bool block_all_filter = 18;</code>
     *
     * @return The blockAllFilter.
     */
    public boolean getBlockAllFilter() {
      if (filterCase_ == 18) {
        return (java.lang.Boolean) filter_;
      }
      return false;
    }
    /**
     *
     *
     * <pre>
     * Does not match any cells, regardless of input. Useful for temporarily
     * disabling just part of a filter.
     * </pre>
     *
     * <code>bool block_all_filter = 18;</code>
     *
     * @param value The blockAllFilter to set.
     * @return This builder for chaining.
     */
    public Builder setBlockAllFilter(boolean value) {
      filterCase_ = 18;
      filter_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Does not match any cells, regardless of input. Useful for temporarily
     * disabling just part of a filter.
     * </pre>
     *
     * <code>bool block_all_filter = 18;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBlockAllFilter() {
      if (filterCase_ == 18) {
        filterCase_ = 0;
        filter_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Matches only cells from rows whose keys satisfy the given RE2 regex. In
     * other words, passes through the entire row when the key matches, and
     * otherwise produces an empty row.
     * Note that, since row keys can contain arbitrary bytes, the `&#92;C` escape
     * sequence must be used if a true wildcard is desired. The `.` character
     * will not match the new line character `&#92;n`, which may be present in a
     * binary key.
     * </pre>
     *
     * <code>bytes row_key_regex_filter = 4;</code>
     *
     * @return The rowKeyRegexFilter.
     */
    public com.google.protobuf.ByteString getRowKeyRegexFilter() {
      if (filterCase_ == 4) {
        return (com.google.protobuf.ByteString) filter_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }
    /**
     *
     *
     * <pre>
     * Matches only cells from rows whose keys satisfy the given RE2 regex. In
     * other words, passes through the entire row when the key matches, and
     * otherwise produces an empty row.
     * Note that, since row keys can contain arbitrary bytes, the `&#92;C` escape
     * sequence must be used if a true wildcard is desired. The `.` character
     * will not match the new line character `&#92;n`, which may be present in a
     * binary key.
     * </pre>
     *
     * <code>bytes row_key_regex_filter = 4;</code>
     *
     * @param value The rowKeyRegexFilter to set.
     * @return This builder for chaining.
     */
    public Builder setRowKeyRegexFilter(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filterCase_ = 4;
      filter_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matches only cells from rows whose keys satisfy the given RE2 regex. In
     * other words, passes through the entire row when the key matches, and
     * otherwise produces an empty row.
     * Note that, since row keys can contain arbitrary bytes, the `&#92;C` escape
     * sequence must be used if a true wildcard is desired. The `.` character
     * will not match the new line character `&#92;n`, which may be present in a
     * binary key.
     * </pre>
     *
     * <code>bytes row_key_regex_filter = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRowKeyRegexFilter() {
      if (filterCase_ == 4) {
        filterCase_ = 0;
        filter_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Matches all cells from a row with probability p, and matches no cells
     * from the row with probability 1-p.
     * </pre>
     *
     * <code>double row_sample_filter = 14;</code>
     *
     * @return The rowSampleFilter.
     */
    public double getRowSampleFilter() {
      if (filterCase_ == 14) {
        return (java.lang.Double) filter_;
      }
      return 0D;
    }
    /**
     *
     *
     * <pre>
     * Matches all cells from a row with probability p, and matches no cells
     * from the row with probability 1-p.
     * </pre>
     *
     * <code>double row_sample_filter = 14;</code>
     *
     * @param value The rowSampleFilter to set.
     * @return This builder for chaining.
     */
    public Builder setRowSampleFilter(double value) {
      filterCase_ = 14;
      filter_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matches all cells from a row with probability p, and matches no cells
     * from the row with probability 1-p.
     * </pre>
     *
     * <code>double row_sample_filter = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRowSampleFilter() {
      if (filterCase_ == 14) {
        filterCase_ = 0;
        filter_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Matches only cells from columns whose families satisfy the given RE2
     * regex. For technical reasons, the regex must not contain the `:`
     * character, even if it is not being used as a literal.
     * Note that, since column families cannot contain the new line character
     * `&#92;n`, it is sufficient to use `.` as a full wildcard when matching
     * column family names.
     * </pre>
     *
     * <code>string family_name_regex_filter = 5;</code>
     *
     * @return The familyNameRegexFilter.
     */
    @java.lang.Override
    public java.lang.String getFamilyNameRegexFilter() {
      java.lang.Object ref = "";
      if (filterCase_ == 5) {
        ref = filter_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (filterCase_ == 5) {
          filter_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Matches only cells from columns whose families satisfy the given RE2
     * regex. For technical reasons, the regex must not contain the `:`
     * character, even if it is not being used as a literal.
     * Note that, since column families cannot contain the new line character
     * `&#92;n`, it is sufficient to use `.` as a full wildcard when matching
     * column family names.
     * </pre>
     *
     * <code>string family_name_regex_filter = 5;</code>
     *
     * @return The bytes for familyNameRegexFilter.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFamilyNameRegexFilterBytes() {
      java.lang.Object ref = "";
      if (filterCase_ == 5) {
        ref = filter_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (filterCase_ == 5) {
          filter_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Matches only cells from columns whose families satisfy the given RE2
     * regex. For technical reasons, the regex must not contain the `:`
     * character, even if it is not being used as a literal.
     * Note that, since column families cannot contain the new line character
     * `&#92;n`, it is sufficient to use `.` as a full wildcard when matching
     * column family names.
     * </pre>
     *
     * <code>string family_name_regex_filter = 5;</code>
     *
     * @param value The familyNameRegexFilter to set.
     * @return This builder for chaining.
     */
    public Builder setFamilyNameRegexFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filterCase_ = 5;
      filter_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matches only cells from columns whose families satisfy the given RE2
     * regex. For technical reasons, the regex must not contain the `:`
     * character, even if it is not being used as a literal.
     * Note that, since column families cannot contain the new line character
     * `&#92;n`, it is sufficient to use `.` as a full wildcard when matching
     * column family names.
     * </pre>
     *
     * <code>string family_name_regex_filter = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFamilyNameRegexFilter() {
      if (filterCase_ == 5) {
        filterCase_ = 0;
        filter_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matches only cells from columns whose families satisfy the given RE2
     * regex. For technical reasons, the regex must not contain the `:`
     * character, even if it is not being used as a literal.
     * Note that, since column families cannot contain the new line character
     * `&#92;n`, it is sufficient to use `.` as a full wildcard when matching
     * column family names.
     * </pre>
     *
     * <code>string family_name_regex_filter = 5;</code>
     *
     * @param value The bytes for familyNameRegexFilter to set.
     * @return This builder for chaining.
     */
    public Builder setFamilyNameRegexFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filterCase_ = 5;
      filter_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Matches only cells from columns whose qualifiers satisfy the given RE2
     * regex.
     * Note that, since column qualifiers can contain arbitrary bytes, the `&#92;C`
     * escape sequence must be used if a true wildcard is desired. The `.`
     * character will not match the new line character `&#92;n`, which may be
     * present in a binary qualifier.
     * </pre>
     *
     * <code>bytes column_qualifier_regex_filter = 6;</code>
     *
     * @return The columnQualifierRegexFilter.
     */
    public com.google.protobuf.ByteString getColumnQualifierRegexFilter() {
      if (filterCase_ == 6) {
        return (com.google.protobuf.ByteString) filter_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }
    /**
     *
     *
     * <pre>
     * Matches only cells from columns whose qualifiers satisfy the given RE2
     * regex.
     * Note that, since column qualifiers can contain arbitrary bytes, the `&#92;C`
     * escape sequence must be used if a true wildcard is desired. The `.`
     * character will not match the new line character `&#92;n`, which may be
     * present in a binary qualifier.
     * </pre>
     *
     * <code>bytes column_qualifier_regex_filter = 6;</code>
     *
     * @param value The columnQualifierRegexFilter to set.
     * @return This builder for chaining.
     */
    public Builder setColumnQualifierRegexFilter(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filterCase_ = 6;
      filter_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matches only cells from columns whose qualifiers satisfy the given RE2
     * regex.
     * Note that, since column qualifiers can contain arbitrary bytes, the `&#92;C`
     * escape sequence must be used if a true wildcard is desired. The `.`
     * character will not match the new line character `&#92;n`, which may be
     * present in a binary qualifier.
     * </pre>
     *
     * <code>bytes column_qualifier_regex_filter = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearColumnQualifierRegexFilter() {
      if (filterCase_ == 6) {
        filterCase_ = 0;
        filter_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.ColumnRange,
            com.google.bigtable.v2.ColumnRange.Builder,
            com.google.bigtable.v2.ColumnRangeOrBuilder>
        columnRangeFilterBuilder_;
    /**
     *
     *
     * <pre>
     * Matches only cells from columns within the given range.
     * </pre>
     *
     * <code>.google.bigtable.v2.ColumnRange column_range_filter = 7;</code>
     *
     * @return Whether the columnRangeFilter field is set.
     */
    @java.lang.Override
    public boolean hasColumnRangeFilter() {
      return filterCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * Matches only cells from columns within the given range.
     * </pre>
     *
     * <code>.google.bigtable.v2.ColumnRange column_range_filter = 7;</code>
     *
     * @return The columnRangeFilter.
     */
    @java.lang.Override
    public com.google.bigtable.v2.ColumnRange getColumnRangeFilter() {
      if (columnRangeFilterBuilder_ == null) {
        if (filterCase_ == 7) {
          return (com.google.bigtable.v2.ColumnRange) filter_;
        }
        return com.google.bigtable.v2.ColumnRange.getDefaultInstance();
      } else {
        if (filterCase_ == 7) {
          return columnRangeFilterBuilder_.getMessage();
        }
        return com.google.bigtable.v2.ColumnRange.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Matches only cells from columns within the given range.
     * </pre>
     *
     * <code>.google.bigtable.v2.ColumnRange column_range_filter = 7;</code>
     */
    public Builder setColumnRangeFilter(com.google.bigtable.v2.ColumnRange value) {
      if (columnRangeFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        onChanged();
      } else {
        columnRangeFilterBuilder_.setMessage(value);
      }
      filterCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matches only cells from columns within the given range.
     * </pre>
     *
     * <code>.google.bigtable.v2.ColumnRange column_range_filter = 7;</code>
     */
    public Builder setColumnRangeFilter(
        com.google.bigtable.v2.ColumnRange.Builder builderForValue) {
      if (columnRangeFilterBuilder_ == null) {
        filter_ = builderForValue.build();
        onChanged();
      } else {
        columnRangeFilterBuilder_.setMessage(builderForValue.build());
      }
      filterCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matches only cells from columns within the given range.
     * </pre>
     *
     * <code>.google.bigtable.v2.ColumnRange column_range_filter = 7;</code>
     */
    public Builder mergeColumnRangeFilter(com.google.bigtable.v2.ColumnRange value) {
      if (columnRangeFilterBuilder_ == null) {
        if (filterCase_ == 7
            && filter_ != com.google.bigtable.v2.ColumnRange.getDefaultInstance()) {
          filter_ =
              com.google.bigtable.v2.ColumnRange.newBuilder(
                      (com.google.bigtable.v2.ColumnRange) filter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          filter_ = value;
        }
        onChanged();
      } else {
        if (filterCase_ == 7) {
          columnRangeFilterBuilder_.mergeFrom(value);
        }
        columnRangeFilterBuilder_.setMessage(value);
      }
      filterCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matches only cells from columns within the given range.
     * </pre>
     *
     * <code>.google.bigtable.v2.ColumnRange column_range_filter = 7;</code>
     */
    public Builder clearColumnRangeFilter() {
      if (columnRangeFilterBuilder_ == null) {
        if (filterCase_ == 7) {
          filterCase_ = 0;
          filter_ = null;
          onChanged();
        }
      } else {
        if (filterCase_ == 7) {
          filterCase_ = 0;
          filter_ = null;
        }
        columnRangeFilterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matches only cells from columns within the given range.
     * </pre>
     *
     * <code>.google.bigtable.v2.ColumnRange column_range_filter = 7;</code>
     */
    public com.google.bigtable.v2.ColumnRange.Builder getColumnRangeFilterBuilder() {
      return getColumnRangeFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Matches only cells from columns within the given range.
     * </pre>
     *
     * <code>.google.bigtable.v2.ColumnRange column_range_filter = 7;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.ColumnRangeOrBuilder getColumnRangeFilterOrBuilder() {
      if ((filterCase_ == 7) && (columnRangeFilterBuilder_ != null)) {
        return columnRangeFilterBuilder_.getMessageOrBuilder();
      } else {
        if (filterCase_ == 7) {
          return (com.google.bigtable.v2.ColumnRange) filter_;
        }
        return com.google.bigtable.v2.ColumnRange.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Matches only cells from columns within the given range.
     * </pre>
     *
     * <code>.google.bigtable.v2.ColumnRange column_range_filter = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.ColumnRange,
            com.google.bigtable.v2.ColumnRange.Builder,
            com.google.bigtable.v2.ColumnRangeOrBuilder>
        getColumnRangeFilterFieldBuilder() {
      if (columnRangeFilterBuilder_ == null) {
        if (!(filterCase_ == 7)) {
          filter_ = com.google.bigtable.v2.ColumnRange.getDefaultInstance();
        }
        columnRangeFilterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.v2.ColumnRange,
                com.google.bigtable.v2.ColumnRange.Builder,
                com.google.bigtable.v2.ColumnRangeOrBuilder>(
                (com.google.bigtable.v2.ColumnRange) filter_, getParentForChildren(), isClean());
        filter_ = null;
      }
      filterCase_ = 7;
      onChanged();
      ;
      return columnRangeFilterBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.TimestampRange,
            com.google.bigtable.v2.TimestampRange.Builder,
            com.google.bigtable.v2.TimestampRangeOrBuilder>
        timestampRangeFilterBuilder_;
    /**
     *
     *
     * <pre>
     * Matches only cells with timestamps within the given range.
     * </pre>
     *
     * <code>.google.bigtable.v2.TimestampRange timestamp_range_filter = 8;</code>
     *
     * @return Whether the timestampRangeFilter field is set.
     */
    @java.lang.Override
    public boolean hasTimestampRangeFilter() {
      return filterCase_ == 8;
    }
    /**
     *
     *
     * <pre>
     * Matches only cells with timestamps within the given range.
     * </pre>
     *
     * <code>.google.bigtable.v2.TimestampRange timestamp_range_filter = 8;</code>
     *
     * @return The timestampRangeFilter.
     */
    @java.lang.Override
    public com.google.bigtable.v2.TimestampRange getTimestampRangeFilter() {
      if (timestampRangeFilterBuilder_ == null) {
        if (filterCase_ == 8) {
          return (com.google.bigtable.v2.TimestampRange) filter_;
        }
        return com.google.bigtable.v2.TimestampRange.getDefaultInstance();
      } else {
        if (filterCase_ == 8) {
          return timestampRangeFilterBuilder_.getMessage();
        }
        return com.google.bigtable.v2.TimestampRange.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Matches only cells with timestamps within the given range.
     * </pre>
     *
     * <code>.google.bigtable.v2.TimestampRange timestamp_range_filter = 8;</code>
     */
    public Builder setTimestampRangeFilter(com.google.bigtable.v2.TimestampRange value) {
      if (timestampRangeFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        onChanged();
      } else {
        timestampRangeFilterBuilder_.setMessage(value);
      }
      filterCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matches only cells with timestamps within the given range.
     * </pre>
     *
     * <code>.google.bigtable.v2.TimestampRange timestamp_range_filter = 8;</code>
     */
    public Builder setTimestampRangeFilter(
        com.google.bigtable.v2.TimestampRange.Builder builderForValue) {
      if (timestampRangeFilterBuilder_ == null) {
        filter_ = builderForValue.build();
        onChanged();
      } else {
        timestampRangeFilterBuilder_.setMessage(builderForValue.build());
      }
      filterCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matches only cells with timestamps within the given range.
     * </pre>
     *
     * <code>.google.bigtable.v2.TimestampRange timestamp_range_filter = 8;</code>
     */
    public Builder mergeTimestampRangeFilter(com.google.bigtable.v2.TimestampRange value) {
      if (timestampRangeFilterBuilder_ == null) {
        if (filterCase_ == 8
            && filter_ != com.google.bigtable.v2.TimestampRange.getDefaultInstance()) {
          filter_ =
              com.google.bigtable.v2.TimestampRange.newBuilder(
                      (com.google.bigtable.v2.TimestampRange) filter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          filter_ = value;
        }
        onChanged();
      } else {
        if (filterCase_ == 8) {
          timestampRangeFilterBuilder_.mergeFrom(value);
        }
        timestampRangeFilterBuilder_.setMessage(value);
      }
      filterCase_ = 8;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matches only cells with timestamps within the given range.
     * </pre>
     *
     * <code>.google.bigtable.v2.TimestampRange timestamp_range_filter = 8;</code>
     */
    public Builder clearTimestampRangeFilter() {
      if (timestampRangeFilterBuilder_ == null) {
        if (filterCase_ == 8) {
          filterCase_ = 0;
          filter_ = null;
          onChanged();
        }
      } else {
        if (filterCase_ == 8) {
          filterCase_ = 0;
          filter_ = null;
        }
        timestampRangeFilterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matches only cells with timestamps within the given range.
     * </pre>
     *
     * <code>.google.bigtable.v2.TimestampRange timestamp_range_filter = 8;</code>
     */
    public com.google.bigtable.v2.TimestampRange.Builder getTimestampRangeFilterBuilder() {
      return getTimestampRangeFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Matches only cells with timestamps within the given range.
     * </pre>
     *
     * <code>.google.bigtable.v2.TimestampRange timestamp_range_filter = 8;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.TimestampRangeOrBuilder getTimestampRangeFilterOrBuilder() {
      if ((filterCase_ == 8) && (timestampRangeFilterBuilder_ != null)) {
        return timestampRangeFilterBuilder_.getMessageOrBuilder();
      } else {
        if (filterCase_ == 8) {
          return (com.google.bigtable.v2.TimestampRange) filter_;
        }
        return com.google.bigtable.v2.TimestampRange.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Matches only cells with timestamps within the given range.
     * </pre>
     *
     * <code>.google.bigtable.v2.TimestampRange timestamp_range_filter = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.TimestampRange,
            com.google.bigtable.v2.TimestampRange.Builder,
            com.google.bigtable.v2.TimestampRangeOrBuilder>
        getTimestampRangeFilterFieldBuilder() {
      if (timestampRangeFilterBuilder_ == null) {
        if (!(filterCase_ == 8)) {
          filter_ = com.google.bigtable.v2.TimestampRange.getDefaultInstance();
        }
        timestampRangeFilterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.v2.TimestampRange,
                com.google.bigtable.v2.TimestampRange.Builder,
                com.google.bigtable.v2.TimestampRangeOrBuilder>(
                (com.google.bigtable.v2.TimestampRange) filter_, getParentForChildren(), isClean());
        filter_ = null;
      }
      filterCase_ = 8;
      onChanged();
      ;
      return timestampRangeFilterBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Matches only cells with values that satisfy the given regular expression.
     * Note that, since cell values can contain arbitrary bytes, the `&#92;C` escape
     * sequence must be used if a true wildcard is desired. The `.` character
     * will not match the new line character `&#92;n`, which may be present in a
     * binary value.
     * </pre>
     *
     * <code>bytes value_regex_filter = 9;</code>
     *
     * @return The valueRegexFilter.
     */
    public com.google.protobuf.ByteString getValueRegexFilter() {
      if (filterCase_ == 9) {
        return (com.google.protobuf.ByteString) filter_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }
    /**
     *
     *
     * <pre>
     * Matches only cells with values that satisfy the given regular expression.
     * Note that, since cell values can contain arbitrary bytes, the `&#92;C` escape
     * sequence must be used if a true wildcard is desired. The `.` character
     * will not match the new line character `&#92;n`, which may be present in a
     * binary value.
     * </pre>
     *
     * <code>bytes value_regex_filter = 9;</code>
     *
     * @param value The valueRegexFilter to set.
     * @return This builder for chaining.
     */
    public Builder setValueRegexFilter(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filterCase_ = 9;
      filter_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matches only cells with values that satisfy the given regular expression.
     * Note that, since cell values can contain arbitrary bytes, the `&#92;C` escape
     * sequence must be used if a true wildcard is desired. The `.` character
     * will not match the new line character `&#92;n`, which may be present in a
     * binary value.
     * </pre>
     *
     * <code>bytes value_regex_filter = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValueRegexFilter() {
      if (filterCase_ == 9) {
        filterCase_ = 0;
        filter_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.ValueRange,
            com.google.bigtable.v2.ValueRange.Builder,
            com.google.bigtable.v2.ValueRangeOrBuilder>
        valueRangeFilterBuilder_;
    /**
     *
     *
     * <pre>
     * Matches only cells with values that fall within the given range.
     * </pre>
     *
     * <code>.google.bigtable.v2.ValueRange value_range_filter = 15;</code>
     *
     * @return Whether the valueRangeFilter field is set.
     */
    @java.lang.Override
    public boolean hasValueRangeFilter() {
      return filterCase_ == 15;
    }
    /**
     *
     *
     * <pre>
     * Matches only cells with values that fall within the given range.
     * </pre>
     *
     * <code>.google.bigtable.v2.ValueRange value_range_filter = 15;</code>
     *
     * @return The valueRangeFilter.
     */
    @java.lang.Override
    public com.google.bigtable.v2.ValueRange getValueRangeFilter() {
      if (valueRangeFilterBuilder_ == null) {
        if (filterCase_ == 15) {
          return (com.google.bigtable.v2.ValueRange) filter_;
        }
        return com.google.bigtable.v2.ValueRange.getDefaultInstance();
      } else {
        if (filterCase_ == 15) {
          return valueRangeFilterBuilder_.getMessage();
        }
        return com.google.bigtable.v2.ValueRange.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Matches only cells with values that fall within the given range.
     * </pre>
     *
     * <code>.google.bigtable.v2.ValueRange value_range_filter = 15;</code>
     */
    public Builder setValueRangeFilter(com.google.bigtable.v2.ValueRange value) {
      if (valueRangeFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        onChanged();
      } else {
        valueRangeFilterBuilder_.setMessage(value);
      }
      filterCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matches only cells with values that fall within the given range.
     * </pre>
     *
     * <code>.google.bigtable.v2.ValueRange value_range_filter = 15;</code>
     */
    public Builder setValueRangeFilter(com.google.bigtable.v2.ValueRange.Builder builderForValue) {
      if (valueRangeFilterBuilder_ == null) {
        filter_ = builderForValue.build();
        onChanged();
      } else {
        valueRangeFilterBuilder_.setMessage(builderForValue.build());
      }
      filterCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matches only cells with values that fall within the given range.
     * </pre>
     *
     * <code>.google.bigtable.v2.ValueRange value_range_filter = 15;</code>
     */
    public Builder mergeValueRangeFilter(com.google.bigtable.v2.ValueRange value) {
      if (valueRangeFilterBuilder_ == null) {
        if (filterCase_ == 15
            && filter_ != com.google.bigtable.v2.ValueRange.getDefaultInstance()) {
          filter_ =
              com.google.bigtable.v2.ValueRange.newBuilder(
                      (com.google.bigtable.v2.ValueRange) filter_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          filter_ = value;
        }
        onChanged();
      } else {
        if (filterCase_ == 15) {
          valueRangeFilterBuilder_.mergeFrom(value);
        }
        valueRangeFilterBuilder_.setMessage(value);
      }
      filterCase_ = 15;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matches only cells with values that fall within the given range.
     * </pre>
     *
     * <code>.google.bigtable.v2.ValueRange value_range_filter = 15;</code>
     */
    public Builder clearValueRangeFilter() {
      if (valueRangeFilterBuilder_ == null) {
        if (filterCase_ == 15) {
          filterCase_ = 0;
          filter_ = null;
          onChanged();
        }
      } else {
        if (filterCase_ == 15) {
          filterCase_ = 0;
          filter_ = null;
        }
        valueRangeFilterBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matches only cells with values that fall within the given range.
     * </pre>
     *
     * <code>.google.bigtable.v2.ValueRange value_range_filter = 15;</code>
     */
    public com.google.bigtable.v2.ValueRange.Builder getValueRangeFilterBuilder() {
      return getValueRangeFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Matches only cells with values that fall within the given range.
     * </pre>
     *
     * <code>.google.bigtable.v2.ValueRange value_range_filter = 15;</code>
     */
    @java.lang.Override
    public com.google.bigtable.v2.ValueRangeOrBuilder getValueRangeFilterOrBuilder() {
      if ((filterCase_ == 15) && (valueRangeFilterBuilder_ != null)) {
        return valueRangeFilterBuilder_.getMessageOrBuilder();
      } else {
        if (filterCase_ == 15) {
          return (com.google.bigtable.v2.ValueRange) filter_;
        }
        return com.google.bigtable.v2.ValueRange.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Matches only cells with values that fall within the given range.
     * </pre>
     *
     * <code>.google.bigtable.v2.ValueRange value_range_filter = 15;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.v2.ValueRange,
            com.google.bigtable.v2.ValueRange.Builder,
            com.google.bigtable.v2.ValueRangeOrBuilder>
        getValueRangeFilterFieldBuilder() {
      if (valueRangeFilterBuilder_ == null) {
        if (!(filterCase_ == 15)) {
          filter_ = com.google.bigtable.v2.ValueRange.getDefaultInstance();
        }
        valueRangeFilterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.v2.ValueRange,
                com.google.bigtable.v2.ValueRange.Builder,
                com.google.bigtable.v2.ValueRangeOrBuilder>(
                (com.google.bigtable.v2.ValueRange) filter_, getParentForChildren(), isClean());
        filter_ = null;
      }
      filterCase_ = 15;
      onChanged();
      ;
      return valueRangeFilterBuilder_;
    }

    /**
     *
     *
     * <pre>
     * Skips the first N cells of each row, matching all subsequent cells.
     * If duplicate cells are present, as is possible when using an Interleave,
     * each copy of the cell is counted separately.
     * </pre>
     *
     * <code>int32 cells_per_row_offset_filter = 10;</code>
     *
     * @return The cellsPerRowOffsetFilter.
     */
    public int getCellsPerRowOffsetFilter() {
      if (filterCase_ == 10) {
        return (java.lang.Integer) filter_;
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * Skips the first N cells of each row, matching all subsequent cells.
     * If duplicate cells are present, as is possible when using an Interleave,
     * each copy of the cell is counted separately.
     * </pre>
     *
     * <code>int32 cells_per_row_offset_filter = 10;</code>
     *
     * @param value The cellsPerRowOffsetFilter to set.
     * @return This builder for chaining.
     */
    public Builder setCellsPerRowOffsetFilter(int value) {
      filterCase_ = 10;
      filter_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Skips the first N cells of each row, matching all subsequent cells.
     * If duplicate cells are present, as is possible when using an Interleave,
     * each copy of the cell is counted separately.
     * </pre>
     *
     * <code>int32 cells_per_row_offset_filter = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCellsPerRowOffsetFilter() {
      if (filterCase_ == 10) {
        filterCase_ = 0;
        filter_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Matches only the first N cells of each row.
     * If duplicate cells are present, as is possible when using an Interleave,
     * each copy of the cell is counted separately.
     * </pre>
     *
     * <code>int32 cells_per_row_limit_filter = 11;</code>
     *
     * @return The cellsPerRowLimitFilter.
     */
    public int getCellsPerRowLimitFilter() {
      if (filterCase_ == 11) {
        return (java.lang.Integer) filter_;
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * Matches only the first N cells of each row.
     * If duplicate cells are present, as is possible when using an Interleave,
     * each copy of the cell is counted separately.
     * </pre>
     *
     * <code>int32 cells_per_row_limit_filter = 11;</code>
     *
     * @param value The cellsPerRowLimitFilter to set.
     * @return This builder for chaining.
     */
    public Builder setCellsPerRowLimitFilter(int value) {
      filterCase_ = 11;
      filter_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matches only the first N cells of each row.
     * If duplicate cells are present, as is possible when using an Interleave,
     * each copy of the cell is counted separately.
     * </pre>
     *
     * <code>int32 cells_per_row_limit_filter = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCellsPerRowLimitFilter() {
      if (filterCase_ == 11) {
        filterCase_ = 0;
        filter_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Matches only the most recent N cells within each column. For example,
     * if N=2, this filter would match column `foo:bar` at timestamps 10 and 9,
     * skip all earlier cells in `foo:bar`, and then begin matching again in
     * column `foo:bar2`.
     * If duplicate cells are present, as is possible when using an Interleave,
     * each copy of the cell is counted separately.
     * </pre>
     *
     * <code>int32 cells_per_column_limit_filter = 12;</code>
     *
     * @return The cellsPerColumnLimitFilter.
     */
    public int getCellsPerColumnLimitFilter() {
      if (filterCase_ == 12) {
        return (java.lang.Integer) filter_;
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * Matches only the most recent N cells within each column. For example,
     * if N=2, this filter would match column `foo:bar` at timestamps 10 and 9,
     * skip all earlier cells in `foo:bar`, and then begin matching again in
     * column `foo:bar2`.
     * If duplicate cells are present, as is possible when using an Interleave,
     * each copy of the cell is counted separately.
     * </pre>
     *
     * <code>int32 cells_per_column_limit_filter = 12;</code>
     *
     * @param value The cellsPerColumnLimitFilter to set.
     * @return This builder for chaining.
     */
    public Builder setCellsPerColumnLimitFilter(int value) {
      filterCase_ = 12;
      filter_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Matches only the most recent N cells within each column. For example,
     * if N=2, this filter would match column `foo:bar` at timestamps 10 and 9,
     * skip all earlier cells in `foo:bar`, and then begin matching again in
     * column `foo:bar2`.
     * If duplicate cells are present, as is possible when using an Interleave,
     * each copy of the cell is counted separately.
     * </pre>
     *
     * <code>int32 cells_per_column_limit_filter = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCellsPerColumnLimitFilter() {
      if (filterCase_ == 12) {
        filterCase_ = 0;
        filter_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Replaces each cell's value with the empty string.
     * </pre>
     *
     * <code>bool strip_value_transformer = 13;</code>
     *
     * @return The stripValueTransformer.
     */
    public boolean getStripValueTransformer() {
      if (filterCase_ == 13) {
        return (java.lang.Boolean) filter_;
      }
      return false;
    }
    /**
     *
     *
     * <pre>
     * Replaces each cell's value with the empty string.
     * </pre>
     *
     * <code>bool strip_value_transformer = 13;</code>
     *
     * @param value The stripValueTransformer to set.
     * @return This builder for chaining.
     */
    public Builder setStripValueTransformer(boolean value) {
      filterCase_ = 13;
      filter_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Replaces each cell's value with the empty string.
     * </pre>
     *
     * <code>bool strip_value_transformer = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStripValueTransformer() {
      if (filterCase_ == 13) {
        filterCase_ = 0;
        filter_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Applies the given label to all cells in the output row. This allows
     * the client to determine which results were produced from which part of
     * the filter.
     * Values must be at most 15 characters in length, and match the RE2
     * pattern `[a-z0-9&#92;&#92;-]+`
     * Due to a technical limitation, it is not currently possible to apply
     * multiple labels to a cell. As a result, a Chain may have no more than
     * one sub-filter which contains a `apply_label_transformer`. It is okay for
     * an Interleave to contain multiple `apply_label_transformers`, as they
     * will be applied to separate copies of the input. This may be relaxed in
     * the future.
     * </pre>
     *
     * <code>string apply_label_transformer = 19;</code>
     *
     * @return The applyLabelTransformer.
     */
    @java.lang.Override
    public java.lang.String getApplyLabelTransformer() {
      java.lang.Object ref = "";
      if (filterCase_ == 19) {
        ref = filter_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (filterCase_ == 19) {
          filter_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Applies the given label to all cells in the output row. This allows
     * the client to determine which results were produced from which part of
     * the filter.
     * Values must be at most 15 characters in length, and match the RE2
     * pattern `[a-z0-9&#92;&#92;-]+`
     * Due to a technical limitation, it is not currently possible to apply
     * multiple labels to a cell. As a result, a Chain may have no more than
     * one sub-filter which contains a `apply_label_transformer`. It is okay for
     * an Interleave to contain multiple `apply_label_transformers`, as they
     * will be applied to separate copies of the input. This may be relaxed in
     * the future.
     * </pre>
     *
     * <code>string apply_label_transformer = 19;</code>
     *
     * @return The bytes for applyLabelTransformer.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getApplyLabelTransformerBytes() {
      java.lang.Object ref = "";
      if (filterCase_ == 19) {
        ref = filter_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (filterCase_ == 19) {
          filter_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Applies the given label to all cells in the output row. This allows
     * the client to determine which results were produced from which part of
     * the filter.
     * Values must be at most 15 characters in length, and match the RE2
     * pattern `[a-z0-9&#92;&#92;-]+`
     * Due to a technical limitation, it is not currently possible to apply
     * multiple labels to a cell. As a result, a Chain may have no more than
     * one sub-filter which contains a `apply_label_transformer`. It is okay for
     * an Interleave to contain multiple `apply_label_transformers`, as they
     * will be applied to separate copies of the input. This may be relaxed in
     * the future.
     * </pre>
     *
     * <code>string apply_label_transformer = 19;</code>
     *
     * @param value The applyLabelTransformer to set.
     * @return This builder for chaining.
     */
    public Builder setApplyLabelTransformer(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filterCase_ = 19;
      filter_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applies the given label to all cells in the output row. This allows
     * the client to determine which results were produced from which part of
     * the filter.
     * Values must be at most 15 characters in length, and match the RE2
     * pattern `[a-z0-9&#92;&#92;-]+`
     * Due to a technical limitation, it is not currently possible to apply
     * multiple labels to a cell. As a result, a Chain may have no more than
     * one sub-filter which contains a `apply_label_transformer`. It is okay for
     * an Interleave to contain multiple `apply_label_transformers`, as they
     * will be applied to separate copies of the input. This may be relaxed in
     * the future.
     * </pre>
     *
     * <code>string apply_label_transformer = 19;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearApplyLabelTransformer() {
      if (filterCase_ == 19) {
        filterCase_ = 0;
        filter_ = null;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Applies the given label to all cells in the output row. This allows
     * the client to determine which results were produced from which part of
     * the filter.
     * Values must be at most 15 characters in length, and match the RE2
     * pattern `[a-z0-9&#92;&#92;-]+`
     * Due to a technical limitation, it is not currently possible to apply
     * multiple labels to a cell. As a result, a Chain may have no more than
     * one sub-filter which contains a `apply_label_transformer`. It is okay for
     * an Interleave to contain multiple `apply_label_transformers`, as they
     * will be applied to separate copies of the input. This may be relaxed in
     * the future.
     * </pre>
     *
     * <code>string apply_label_transformer = 19;</code>
     *
     * @param value The bytes for applyLabelTransformer to set.
     * @return This builder for chaining.
     */
    public Builder setApplyLabelTransformerBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filterCase_ = 19;
      filter_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.v2.RowFilter)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.v2.RowFilter)
  private static final com.google.bigtable.v2.RowFilter DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.v2.RowFilter();
  }

  public static com.google.bigtable.v2.RowFilter getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RowFilter> PARSER =
      new com.google.protobuf.AbstractParser<RowFilter>() {
        @java.lang.Override
        public RowFilter parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new RowFilter(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<RowFilter> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RowFilter> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.v2.RowFilter getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
