/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/admin/v2/bigtable_instance_admin.proto

package com.google.bigtable.admin.v2;

/**
 *
 *
 * <pre>
 * The metadata for the Operation returned by CreateCluster.
 * </pre>
 *
 * Protobuf type {@code google.bigtable.admin.v2.CreateClusterMetadata}
 */
public final class CreateClusterMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.CreateClusterMetadata)
    CreateClusterMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CreateClusterMetadata.newBuilder() to construct.
  private CreateClusterMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateClusterMetadata() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateClusterMetadata();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.admin.v2.BigtableInstanceAdminProto
        .internal_static_google_bigtable_admin_v2_CreateClusterMetadata_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetTables();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.admin.v2.BigtableInstanceAdminProto
        .internal_static_google_bigtable_admin_v2_CreateClusterMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.admin.v2.CreateClusterMetadata.class,
            com.google.bigtable.admin.v2.CreateClusterMetadata.Builder.class);
  }

  public interface TableProgressOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.admin.v2.CreateClusterMetadata.TableProgress)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Estimate of the size of the table to be copied.
     * </pre>
     *
     * <code>int64 estimated_size_bytes = 2;</code>
     *
     * @return The estimatedSizeBytes.
     */
    long getEstimatedSizeBytes();

    /**
     *
     *
     * <pre>
     * Estimate of the number of bytes copied so far for this table.
     * This will eventually reach 'estimated_size_bytes' unless the table copy
     * is CANCELLED.
     * </pre>
     *
     * <code>int64 estimated_copied_bytes = 3;</code>
     *
     * @return The estimatedCopiedBytes.
     */
    long getEstimatedCopiedBytes();

    /**
     * <code>.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.State state = 4;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    int getStateValue();
    /**
     * <code>.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.State state = 4;</code>
     *
     * @return The state.
     */
    com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.State getState();
  }
  /**
   *
   *
   * <pre>
   * Progress info for copying a table's data to the new cluster.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.CreateClusterMetadata.TableProgress}
   */
  public static final class TableProgress extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.CreateClusterMetadata.TableProgress)
      TableProgressOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TableProgress.newBuilder() to construct.
    private TableProgress(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TableProgress() {
      state_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TableProgress();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.BigtableInstanceAdminProto
          .internal_static_google_bigtable_admin_v2_CreateClusterMetadata_TableProgress_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.BigtableInstanceAdminProto
          .internal_static_google_bigtable_admin_v2_CreateClusterMetadata_TableProgress_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.class,
              com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.Builder.class);
    }

    /** Protobuf enum {@code google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.State} */
    public enum State implements com.google.protobuf.ProtocolMessageEnum {
      /** <code>STATE_UNSPECIFIED = 0;</code> */
      STATE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The table has not yet begun copying to the new cluster.
       * </pre>
       *
       * <code>PENDING = 1;</code>
       */
      PENDING(1),
      /**
       *
       *
       * <pre>
       * The table is actively being copied to the new cluster.
       * </pre>
       *
       * <code>COPYING = 2;</code>
       */
      COPYING(2),
      /**
       *
       *
       * <pre>
       * The table has been fully copied to the new cluster.
       * </pre>
       *
       * <code>COMPLETED = 3;</code>
       */
      COMPLETED(3),
      /**
       *
       *
       * <pre>
       * The table was deleted before it finished copying to the new cluster.
       * Note that tables deleted after completion will stay marked as
       * COMPLETED, not CANCELLED.
       * </pre>
       *
       * <code>CANCELLED = 4;</code>
       */
      CANCELLED(4),
      UNRECOGNIZED(-1),
      ;

      /** <code>STATE_UNSPECIFIED = 0;</code> */
      public static final int STATE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The table has not yet begun copying to the new cluster.
       * </pre>
       *
       * <code>PENDING = 1;</code>
       */
      public static final int PENDING_VALUE = 1;
      /**
       *
       *
       * <pre>
       * The table is actively being copied to the new cluster.
       * </pre>
       *
       * <code>COPYING = 2;</code>
       */
      public static final int COPYING_VALUE = 2;
      /**
       *
       *
       * <pre>
       * The table has been fully copied to the new cluster.
       * </pre>
       *
       * <code>COMPLETED = 3;</code>
       */
      public static final int COMPLETED_VALUE = 3;
      /**
       *
       *
       * <pre>
       * The table was deleted before it finished copying to the new cluster.
       * Note that tables deleted after completion will stay marked as
       * COMPLETED, not CANCELLED.
       * </pre>
       *
       * <code>CANCELLED = 4;</code>
       */
      public static final int CANCELLED_VALUE = 4;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static State valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static State forNumber(int value) {
        switch (value) {
          case 0:
            return STATE_UNSPECIFIED;
          case 1:
            return PENDING;
          case 2:
            return COPYING;
          case 3:
            return COMPLETED;
          case 4:
            return CANCELLED;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<State>() {
            public State findValueByNumber(int number) {
              return State.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final State[] VALUES = values();

      public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private State(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.State)
    }

    public static final int ESTIMATED_SIZE_BYTES_FIELD_NUMBER = 2;
    private long estimatedSizeBytes_ = 0L;
    /**
     *
     *
     * <pre>
     * Estimate of the size of the table to be copied.
     * </pre>
     *
     * <code>int64 estimated_size_bytes = 2;</code>
     *
     * @return The estimatedSizeBytes.
     */
    @java.lang.Override
    public long getEstimatedSizeBytes() {
      return estimatedSizeBytes_;
    }

    public static final int ESTIMATED_COPIED_BYTES_FIELD_NUMBER = 3;
    private long estimatedCopiedBytes_ = 0L;
    /**
     *
     *
     * <pre>
     * Estimate of the number of bytes copied so far for this table.
     * This will eventually reach 'estimated_size_bytes' unless the table copy
     * is CANCELLED.
     * </pre>
     *
     * <code>int64 estimated_copied_bytes = 3;</code>
     *
     * @return The estimatedCopiedBytes.
     */
    @java.lang.Override
    public long getEstimatedCopiedBytes() {
      return estimatedCopiedBytes_;
    }

    public static final int STATE_FIELD_NUMBER = 4;
    private int state_ = 0;
    /**
     * <code>.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.State state = 4;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     * <code>.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.State state = 4;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.State getState() {
      com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.State result =
          com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.State.forNumber(state_);
      return result == null
          ? com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.State.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (estimatedSizeBytes_ != 0L) {
        output.writeInt64(2, estimatedSizeBytes_);
      }
      if (estimatedCopiedBytes_ != 0L) {
        output.writeInt64(3, estimatedCopiedBytes_);
      }
      if (state_
          != com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.State
              .STATE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(4, state_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (estimatedSizeBytes_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, estimatedSizeBytes_);
      }
      if (estimatedCopiedBytes_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, estimatedCopiedBytes_);
      }
      if (state_
          != com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.State
              .STATE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, state_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress)) {
        return super.equals(obj);
      }
      com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress other =
          (com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress) obj;

      if (getEstimatedSizeBytes() != other.getEstimatedSizeBytes()) return false;
      if (getEstimatedCopiedBytes() != other.getEstimatedCopiedBytes()) return false;
      if (state_ != other.state_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ESTIMATED_SIZE_BYTES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getEstimatedSizeBytes());
      hash = (37 * hash) + ESTIMATED_COPIED_BYTES_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getEstimatedCopiedBytes());
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + state_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Progress info for copying a table's data to the new cluster.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.admin.v2.CreateClusterMetadata.TableProgress}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.CreateClusterMetadata.TableProgress)
        com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgressOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.admin.v2.BigtableInstanceAdminProto
            .internal_static_google_bigtable_admin_v2_CreateClusterMetadata_TableProgress_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.admin.v2.BigtableInstanceAdminProto
            .internal_static_google_bigtable_admin_v2_CreateClusterMetadata_TableProgress_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.class,
                com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.Builder.class);
      }

      // Construct using
      // com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        estimatedSizeBytes_ = 0L;
        estimatedCopiedBytes_ = 0L;
        state_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.admin.v2.BigtableInstanceAdminProto
            .internal_static_google_bigtable_admin_v2_CreateClusterMetadata_TableProgress_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress
          getDefaultInstanceForType() {
        return com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress build() {
        com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress buildPartial() {
        com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress result =
            new com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.estimatedSizeBytes_ = estimatedSizeBytes_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.estimatedCopiedBytes_ = estimatedCopiedBytes_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.state_ = state_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress) {
          return mergeFrom(
              (com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress other) {
        if (other
            == com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress
                .getDefaultInstance()) return this;
        if (other.getEstimatedSizeBytes() != 0L) {
          setEstimatedSizeBytes(other.getEstimatedSizeBytes());
        }
        if (other.getEstimatedCopiedBytes() != 0L) {
          setEstimatedCopiedBytes(other.getEstimatedCopiedBytes());
        }
        if (other.state_ != 0) {
          setStateValue(other.getStateValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 16:
                {
                  estimatedSizeBytes_ = input.readInt64();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 16
              case 24:
                {
                  estimatedCopiedBytes_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 24
              case 32:
                {
                  state_ = input.readEnum();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private long estimatedSizeBytes_;
      /**
       *
       *
       * <pre>
       * Estimate of the size of the table to be copied.
       * </pre>
       *
       * <code>int64 estimated_size_bytes = 2;</code>
       *
       * @return The estimatedSizeBytes.
       */
      @java.lang.Override
      public long getEstimatedSizeBytes() {
        return estimatedSizeBytes_;
      }
      /**
       *
       *
       * <pre>
       * Estimate of the size of the table to be copied.
       * </pre>
       *
       * <code>int64 estimated_size_bytes = 2;</code>
       *
       * @param value The estimatedSizeBytes to set.
       * @return This builder for chaining.
       */
      public Builder setEstimatedSizeBytes(long value) {

        estimatedSizeBytes_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Estimate of the size of the table to be copied.
       * </pre>
       *
       * <code>int64 estimated_size_bytes = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEstimatedSizeBytes() {
        bitField0_ = (bitField0_ & ~0x00000001);
        estimatedSizeBytes_ = 0L;
        onChanged();
        return this;
      }

      private long estimatedCopiedBytes_;
      /**
       *
       *
       * <pre>
       * Estimate of the number of bytes copied so far for this table.
       * This will eventually reach 'estimated_size_bytes' unless the table copy
       * is CANCELLED.
       * </pre>
       *
       * <code>int64 estimated_copied_bytes = 3;</code>
       *
       * @return The estimatedCopiedBytes.
       */
      @java.lang.Override
      public long getEstimatedCopiedBytes() {
        return estimatedCopiedBytes_;
      }
      /**
       *
       *
       * <pre>
       * Estimate of the number of bytes copied so far for this table.
       * This will eventually reach 'estimated_size_bytes' unless the table copy
       * is CANCELLED.
       * </pre>
       *
       * <code>int64 estimated_copied_bytes = 3;</code>
       *
       * @param value The estimatedCopiedBytes to set.
       * @return This builder for chaining.
       */
      public Builder setEstimatedCopiedBytes(long value) {

        estimatedCopiedBytes_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Estimate of the number of bytes copied so far for this table.
       * This will eventually reach 'estimated_size_bytes' unless the table copy
       * is CANCELLED.
       * </pre>
       *
       * <code>int64 estimated_copied_bytes = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEstimatedCopiedBytes() {
        bitField0_ = (bitField0_ & ~0x00000002);
        estimatedCopiedBytes_ = 0L;
        onChanged();
        return this;
      }

      private int state_ = 0;
      /**
       * <code>.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.State state = 4;</code>
       *
       * @return The enum numeric value on the wire for state.
       */
      @java.lang.Override
      public int getStateValue() {
        return state_;
      }
      /**
       * <code>.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.State state = 4;</code>
       *
       * @param value The enum numeric value on the wire for state to set.
       * @return This builder for chaining.
       */
      public Builder setStateValue(int value) {
        state_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.State state = 4;</code>
       *
       * @return The state.
       */
      @java.lang.Override
      public com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.State getState() {
        com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.State result =
            com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.State.forNumber(
                state_);
        return result == null
            ? com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.State.UNRECOGNIZED
            : result;
      }
      /**
       * <code>.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.State state = 4;</code>
       *
       * @param value The state to set.
       * @return This builder for chaining.
       */
      public Builder setState(
          com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.State value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        state_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress.State state = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearState() {
        bitField0_ = (bitField0_ & ~0x00000004);
        state_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.CreateClusterMetadata.TableProgress)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.CreateClusterMetadata.TableProgress)
    private static final com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress();
    }

    public static com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TableProgress> PARSER =
        new com.google.protobuf.AbstractParser<TableProgress>() {
          @java.lang.Override
          public TableProgress parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TableProgress> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TableProgress> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int ORIGINAL_REQUEST_FIELD_NUMBER = 1;
  private com.google.bigtable.admin.v2.CreateClusterRequest originalRequest_;
  /**
   *
   *
   * <pre>
   * The request that prompted the initiation of this CreateCluster operation.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.CreateClusterRequest original_request = 1;</code>
   *
   * @return Whether the originalRequest field is set.
   */
  @java.lang.Override
  public boolean hasOriginalRequest() {
    return originalRequest_ != null;
  }
  /**
   *
   *
   * <pre>
   * The request that prompted the initiation of this CreateCluster operation.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.CreateClusterRequest original_request = 1;</code>
   *
   * @return The originalRequest.
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.CreateClusterRequest getOriginalRequest() {
    return originalRequest_ == null
        ? com.google.bigtable.admin.v2.CreateClusterRequest.getDefaultInstance()
        : originalRequest_;
  }
  /**
   *
   *
   * <pre>
   * The request that prompted the initiation of this CreateCluster operation.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.CreateClusterRequest original_request = 1;</code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.CreateClusterRequestOrBuilder getOriginalRequestOrBuilder() {
    return originalRequest_ == null
        ? com.google.bigtable.admin.v2.CreateClusterRequest.getDefaultInstance()
        : originalRequest_;
  }

  public static final int REQUEST_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp requestTime_;
  /**
   *
   *
   * <pre>
   * The time at which the original request was received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp request_time = 2;</code>
   *
   * @return Whether the requestTime field is set.
   */
  @java.lang.Override
  public boolean hasRequestTime() {
    return requestTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time at which the original request was received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp request_time = 2;</code>
   *
   * @return The requestTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getRequestTime() {
    return requestTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : requestTime_;
  }
  /**
   *
   *
   * <pre>
   * The time at which the original request was received.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp request_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getRequestTimeOrBuilder() {
    return requestTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : requestTime_;
  }

  public static final int FINISH_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp finishTime_;
  /**
   *
   *
   * <pre>
   * The time at which the operation failed or was completed successfully.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp finish_time = 3;</code>
   *
   * @return Whether the finishTime field is set.
   */
  @java.lang.Override
  public boolean hasFinishTime() {
    return finishTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time at which the operation failed or was completed successfully.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp finish_time = 3;</code>
   *
   * @return The finishTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getFinishTime() {
    return finishTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : finishTime_;
  }
  /**
   *
   *
   * <pre>
   * The time at which the operation failed or was completed successfully.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp finish_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getFinishTimeOrBuilder() {
    return finishTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : finishTime_;
  }

  public static final int TABLES_FIELD_NUMBER = 4;

  private static final class TablesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String,
                    com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress>
                    newDefaultInstance(
                        com.google.bigtable.admin.v2.BigtableInstanceAdminProto
                            .internal_static_google_bigtable_admin_v2_CreateClusterMetadata_TablesEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress>
      tables_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress>
      internalGetTables() {
    if (tables_ == null) {
      return com.google.protobuf.MapField.emptyMapField(TablesDefaultEntryHolder.defaultEntry);
    }
    return tables_;
  }

  public int getTablesCount() {
    return internalGetTables().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Keys: the full `name` of each table that existed in the instance when
   * CreateCluster was first called, i.e.
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`. Any table added
   * to the instance by a later API call will be created in the new cluster by
   * that API call, not this one.
   * Values: information on how much of a table's data has been copied to the
   * newly-created cluster so far.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.bigtable.admin.v2.CreateClusterMetadata.TableProgress&gt; tables = 4;
   * </code>
   */
  @java.lang.Override
  public boolean containsTables(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetTables().getMap().containsKey(key);
  }
  /** Use {@link #getTablesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<
          java.lang.String, com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress>
      getTables() {
    return getTablesMap();
  }
  /**
   *
   *
   * <pre>
   * Keys: the full `name` of each table that existed in the instance when
   * CreateCluster was first called, i.e.
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`. Any table added
   * to the instance by a later API call will be created in the new cluster by
   * that API call, not this one.
   * Values: information on how much of a table's data has been copied to the
   * newly-created cluster so far.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.bigtable.admin.v2.CreateClusterMetadata.TableProgress&gt; tables = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<
          java.lang.String, com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress>
      getTablesMap() {
    return internalGetTables().getMap();
  }
  /**
   *
   *
   * <pre>
   * Keys: the full `name` of each table that existed in the instance when
   * CreateCluster was first called, i.e.
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`. Any table added
   * to the instance by a later API call will be created in the new cluster by
   * that API call, not this one.
   * Values: information on how much of a table's data has been copied to the
   * newly-created cluster so far.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.bigtable.admin.v2.CreateClusterMetadata.TableProgress&gt; tables = 4;
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress
      getTablesOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String, com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress>
        map = internalGetTables().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Keys: the full `name` of each table that existed in the instance when
   * CreateCluster was first called, i.e.
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`. Any table added
   * to the instance by a later API call will be created in the new cluster by
   * that API call, not this one.
   * Values: information on how much of a table's data has been copied to the
   * newly-created cluster so far.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.bigtable.admin.v2.CreateClusterMetadata.TableProgress&gt; tables = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress getTablesOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<
            java.lang.String, com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress>
        map = internalGetTables().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (originalRequest_ != null) {
      output.writeMessage(1, getOriginalRequest());
    }
    if (requestTime_ != null) {
      output.writeMessage(2, getRequestTime());
    }
    if (finishTime_ != null) {
      output.writeMessage(3, getFinishTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetTables(), TablesDefaultEntryHolder.defaultEntry, 4);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (originalRequest_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getOriginalRequest());
    }
    if (requestTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getRequestTime());
    }
    if (finishTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getFinishTime());
    }
    for (java.util.Map.Entry<
            java.lang.String, com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress>
        entry : internalGetTables().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress>
          tables__ =
              TablesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, tables__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.admin.v2.CreateClusterMetadata)) {
      return super.equals(obj);
    }
    com.google.bigtable.admin.v2.CreateClusterMetadata other =
        (com.google.bigtable.admin.v2.CreateClusterMetadata) obj;

    if (hasOriginalRequest() != other.hasOriginalRequest()) return false;
    if (hasOriginalRequest()) {
      if (!getOriginalRequest().equals(other.getOriginalRequest())) return false;
    }
    if (hasRequestTime() != other.hasRequestTime()) return false;
    if (hasRequestTime()) {
      if (!getRequestTime().equals(other.getRequestTime())) return false;
    }
    if (hasFinishTime() != other.hasFinishTime()) return false;
    if (hasFinishTime()) {
      if (!getFinishTime().equals(other.getFinishTime())) return false;
    }
    if (!internalGetTables().equals(other.internalGetTables())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasOriginalRequest()) {
      hash = (37 * hash) + ORIGINAL_REQUEST_FIELD_NUMBER;
      hash = (53 * hash) + getOriginalRequest().hashCode();
    }
    if (hasRequestTime()) {
      hash = (37 * hash) + REQUEST_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getRequestTime().hashCode();
    }
    if (hasFinishTime()) {
      hash = (37 * hash) + FINISH_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getFinishTime().hashCode();
    }
    if (!internalGetTables().getMap().isEmpty()) {
      hash = (37 * hash) + TABLES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetTables().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.admin.v2.CreateClusterMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.CreateClusterMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.CreateClusterMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.CreateClusterMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.CreateClusterMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.CreateClusterMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.CreateClusterMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.CreateClusterMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.CreateClusterMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.CreateClusterMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.CreateClusterMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.CreateClusterMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.admin.v2.CreateClusterMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The metadata for the Operation returned by CreateCluster.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.CreateClusterMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.CreateClusterMetadata)
      com.google.bigtable.admin.v2.CreateClusterMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.BigtableInstanceAdminProto
          .internal_static_google_bigtable_admin_v2_CreateClusterMetadata_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetTables();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableTables();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.BigtableInstanceAdminProto
          .internal_static_google_bigtable_admin_v2_CreateClusterMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.CreateClusterMetadata.class,
              com.google.bigtable.admin.v2.CreateClusterMetadata.Builder.class);
    }

    // Construct using com.google.bigtable.admin.v2.CreateClusterMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      originalRequest_ = null;
      if (originalRequestBuilder_ != null) {
        originalRequestBuilder_.dispose();
        originalRequestBuilder_ = null;
      }
      requestTime_ = null;
      if (requestTimeBuilder_ != null) {
        requestTimeBuilder_.dispose();
        requestTimeBuilder_ = null;
      }
      finishTime_ = null;
      if (finishTimeBuilder_ != null) {
        finishTimeBuilder_.dispose();
        finishTimeBuilder_ = null;
      }
      internalGetMutableTables().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.admin.v2.BigtableInstanceAdminProto
          .internal_static_google_bigtable_admin_v2_CreateClusterMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.CreateClusterMetadata getDefaultInstanceForType() {
      return com.google.bigtable.admin.v2.CreateClusterMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.CreateClusterMetadata build() {
      com.google.bigtable.admin.v2.CreateClusterMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.CreateClusterMetadata buildPartial() {
      com.google.bigtable.admin.v2.CreateClusterMetadata result =
          new com.google.bigtable.admin.v2.CreateClusterMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.bigtable.admin.v2.CreateClusterMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.originalRequest_ =
            originalRequestBuilder_ == null ? originalRequest_ : originalRequestBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.requestTime_ =
            requestTimeBuilder_ == null ? requestTime_ : requestTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.finishTime_ = finishTimeBuilder_ == null ? finishTime_ : finishTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.tables_ = internalGetTables();
        result.tables_.makeImmutable();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.admin.v2.CreateClusterMetadata) {
        return mergeFrom((com.google.bigtable.admin.v2.CreateClusterMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.admin.v2.CreateClusterMetadata other) {
      if (other == com.google.bigtable.admin.v2.CreateClusterMetadata.getDefaultInstance())
        return this;
      if (other.hasOriginalRequest()) {
        mergeOriginalRequest(other.getOriginalRequest());
      }
      if (other.hasRequestTime()) {
        mergeRequestTime(other.getRequestTime());
      }
      if (other.hasFinishTime()) {
        mergeFinishTime(other.getFinishTime());
      }
      internalGetMutableTables().mergeFrom(other.internalGetTables());
      bitField0_ |= 0x00000008;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getOriginalRequestFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getRequestTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getFinishTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String,
                        com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress>
                    tables__ =
                        input.readMessage(
                            TablesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableTables()
                    .getMutableMap()
                    .put(tables__.getKey(), tables__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.bigtable.admin.v2.CreateClusterRequest originalRequest_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.admin.v2.CreateClusterRequest,
            com.google.bigtable.admin.v2.CreateClusterRequest.Builder,
            com.google.bigtable.admin.v2.CreateClusterRequestOrBuilder>
        originalRequestBuilder_;
    /**
     *
     *
     * <pre>
     * The request that prompted the initiation of this CreateCluster operation.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.CreateClusterRequest original_request = 1;</code>
     *
     * @return Whether the originalRequest field is set.
     */
    public boolean hasOriginalRequest() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The request that prompted the initiation of this CreateCluster operation.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.CreateClusterRequest original_request = 1;</code>
     *
     * @return The originalRequest.
     */
    public com.google.bigtable.admin.v2.CreateClusterRequest getOriginalRequest() {
      if (originalRequestBuilder_ == null) {
        return originalRequest_ == null
            ? com.google.bigtable.admin.v2.CreateClusterRequest.getDefaultInstance()
            : originalRequest_;
      } else {
        return originalRequestBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The request that prompted the initiation of this CreateCluster operation.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.CreateClusterRequest original_request = 1;</code>
     */
    public Builder setOriginalRequest(com.google.bigtable.admin.v2.CreateClusterRequest value) {
      if (originalRequestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        originalRequest_ = value;
      } else {
        originalRequestBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The request that prompted the initiation of this CreateCluster operation.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.CreateClusterRequest original_request = 1;</code>
     */
    public Builder setOriginalRequest(
        com.google.bigtable.admin.v2.CreateClusterRequest.Builder builderForValue) {
      if (originalRequestBuilder_ == null) {
        originalRequest_ = builderForValue.build();
      } else {
        originalRequestBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The request that prompted the initiation of this CreateCluster operation.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.CreateClusterRequest original_request = 1;</code>
     */
    public Builder mergeOriginalRequest(com.google.bigtable.admin.v2.CreateClusterRequest value) {
      if (originalRequestBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && originalRequest_ != null
            && originalRequest_
                != com.google.bigtable.admin.v2.CreateClusterRequest.getDefaultInstance()) {
          getOriginalRequestBuilder().mergeFrom(value);
        } else {
          originalRequest_ = value;
        }
      } else {
        originalRequestBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The request that prompted the initiation of this CreateCluster operation.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.CreateClusterRequest original_request = 1;</code>
     */
    public Builder clearOriginalRequest() {
      bitField0_ = (bitField0_ & ~0x00000001);
      originalRequest_ = null;
      if (originalRequestBuilder_ != null) {
        originalRequestBuilder_.dispose();
        originalRequestBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The request that prompted the initiation of this CreateCluster operation.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.CreateClusterRequest original_request = 1;</code>
     */
    public com.google.bigtable.admin.v2.CreateClusterRequest.Builder getOriginalRequestBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getOriginalRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The request that prompted the initiation of this CreateCluster operation.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.CreateClusterRequest original_request = 1;</code>
     */
    public com.google.bigtable.admin.v2.CreateClusterRequestOrBuilder
        getOriginalRequestOrBuilder() {
      if (originalRequestBuilder_ != null) {
        return originalRequestBuilder_.getMessageOrBuilder();
      } else {
        return originalRequest_ == null
            ? com.google.bigtable.admin.v2.CreateClusterRequest.getDefaultInstance()
            : originalRequest_;
      }
    }
    /**
     *
     *
     * <pre>
     * The request that prompted the initiation of this CreateCluster operation.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.CreateClusterRequest original_request = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.bigtable.admin.v2.CreateClusterRequest,
            com.google.bigtable.admin.v2.CreateClusterRequest.Builder,
            com.google.bigtable.admin.v2.CreateClusterRequestOrBuilder>
        getOriginalRequestFieldBuilder() {
      if (originalRequestBuilder_ == null) {
        originalRequestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.bigtable.admin.v2.CreateClusterRequest,
                com.google.bigtable.admin.v2.CreateClusterRequest.Builder,
                com.google.bigtable.admin.v2.CreateClusterRequestOrBuilder>(
                getOriginalRequest(), getParentForChildren(), isClean());
        originalRequest_ = null;
      }
      return originalRequestBuilder_;
    }

    private com.google.protobuf.Timestamp requestTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        requestTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which the original request was received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp request_time = 2;</code>
     *
     * @return Whether the requestTime field is set.
     */
    public boolean hasRequestTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time at which the original request was received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp request_time = 2;</code>
     *
     * @return The requestTime.
     */
    public com.google.protobuf.Timestamp getRequestTime() {
      if (requestTimeBuilder_ == null) {
        return requestTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : requestTime_;
      } else {
        return requestTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the original request was received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp request_time = 2;</code>
     */
    public Builder setRequestTime(com.google.protobuf.Timestamp value) {
      if (requestTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestTime_ = value;
      } else {
        requestTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the original request was received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp request_time = 2;</code>
     */
    public Builder setRequestTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (requestTimeBuilder_ == null) {
        requestTime_ = builderForValue.build();
      } else {
        requestTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the original request was received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp request_time = 2;</code>
     */
    public Builder mergeRequestTime(com.google.protobuf.Timestamp value) {
      if (requestTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && requestTime_ != null
            && requestTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getRequestTimeBuilder().mergeFrom(value);
        } else {
          requestTime_ = value;
        }
      } else {
        requestTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the original request was received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp request_time = 2;</code>
     */
    public Builder clearRequestTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      requestTime_ = null;
      if (requestTimeBuilder_ != null) {
        requestTimeBuilder_.dispose();
        requestTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the original request was received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp request_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getRequestTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getRequestTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which the original request was received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp request_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getRequestTimeOrBuilder() {
      if (requestTimeBuilder_ != null) {
        return requestTimeBuilder_.getMessageOrBuilder();
      } else {
        return requestTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : requestTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the original request was received.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp request_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getRequestTimeFieldBuilder() {
      if (requestTimeBuilder_ == null) {
        requestTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getRequestTime(), getParentForChildren(), isClean());
        requestTime_ = null;
      }
      return requestTimeBuilder_;
    }

    private com.google.protobuf.Timestamp finishTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        finishTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time at which the operation failed or was completed successfully.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp finish_time = 3;</code>
     *
     * @return Whether the finishTime field is set.
     */
    public boolean hasFinishTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time at which the operation failed or was completed successfully.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp finish_time = 3;</code>
     *
     * @return The finishTime.
     */
    public com.google.protobuf.Timestamp getFinishTime() {
      if (finishTimeBuilder_ == null) {
        return finishTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : finishTime_;
      } else {
        return finishTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the operation failed or was completed successfully.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp finish_time = 3;</code>
     */
    public Builder setFinishTime(com.google.protobuf.Timestamp value) {
      if (finishTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        finishTime_ = value;
      } else {
        finishTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the operation failed or was completed successfully.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp finish_time = 3;</code>
     */
    public Builder setFinishTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (finishTimeBuilder_ == null) {
        finishTime_ = builderForValue.build();
      } else {
        finishTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the operation failed or was completed successfully.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp finish_time = 3;</code>
     */
    public Builder mergeFinishTime(com.google.protobuf.Timestamp value) {
      if (finishTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && finishTime_ != null
            && finishTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getFinishTimeBuilder().mergeFrom(value);
        } else {
          finishTime_ = value;
        }
      } else {
        finishTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the operation failed or was completed successfully.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp finish_time = 3;</code>
     */
    public Builder clearFinishTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      finishTime_ = null;
      if (finishTimeBuilder_ != null) {
        finishTimeBuilder_.dispose();
        finishTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time at which the operation failed or was completed successfully.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp finish_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getFinishTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getFinishTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time at which the operation failed or was completed successfully.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp finish_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getFinishTimeOrBuilder() {
      if (finishTimeBuilder_ != null) {
        return finishTimeBuilder_.getMessageOrBuilder();
      } else {
        return finishTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : finishTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time at which the operation failed or was completed successfully.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp finish_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getFinishTimeFieldBuilder() {
      if (finishTimeBuilder_ == null) {
        finishTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getFinishTime(), getParentForChildren(), isClean());
        finishTime_ = null;
      }
      return finishTimeBuilder_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress>
        tables_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress>
        internalGetTables() {
      if (tables_ == null) {
        return com.google.protobuf.MapField.emptyMapField(TablesDefaultEntryHolder.defaultEntry);
      }
      return tables_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress>
        internalGetMutableTables() {
      if (tables_ == null) {
        tables_ = com.google.protobuf.MapField.newMapField(TablesDefaultEntryHolder.defaultEntry);
      }
      if (!tables_.isMutable()) {
        tables_ = tables_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return tables_;
    }

    public int getTablesCount() {
      return internalGetTables().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Keys: the full `name` of each table that existed in the instance when
     * CreateCluster was first called, i.e.
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`. Any table added
     * to the instance by a later API call will be created in the new cluster by
     * that API call, not this one.
     * Values: information on how much of a table's data has been copied to the
     * newly-created cluster so far.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.CreateClusterMetadata.TableProgress&gt; tables = 4;
     * </code>
     */
    @java.lang.Override
    public boolean containsTables(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetTables().getMap().containsKey(key);
    }
    /** Use {@link #getTablesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress>
        getTables() {
      return getTablesMap();
    }
    /**
     *
     *
     * <pre>
     * Keys: the full `name` of each table that existed in the instance when
     * CreateCluster was first called, i.e.
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`. Any table added
     * to the instance by a later API call will be created in the new cluster by
     * that API call, not this one.
     * Values: information on how much of a table's data has been copied to the
     * newly-created cluster so far.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.CreateClusterMetadata.TableProgress&gt; tables = 4;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress>
        getTablesMap() {
      return internalGetTables().getMap();
    }
    /**
     *
     *
     * <pre>
     * Keys: the full `name` of each table that existed in the instance when
     * CreateCluster was first called, i.e.
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`. Any table added
     * to the instance by a later API call will be created in the new cluster by
     * that API call, not this one.
     * Values: information on how much of a table's data has been copied to the
     * newly-created cluster so far.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.CreateClusterMetadata.TableProgress&gt; tables = 4;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress
        getTablesOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String, com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress>
          map = internalGetTables().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Keys: the full `name` of each table that existed in the instance when
     * CreateCluster was first called, i.e.
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`. Any table added
     * to the instance by a later API call will be created in the new cluster by
     * that API call, not this one.
     * Values: information on how much of a table's data has been copied to the
     * newly-created cluster so far.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.CreateClusterMetadata.TableProgress&gt; tables = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress getTablesOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String, com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress>
          map = internalGetTables().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearTables() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableTables().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Keys: the full `name` of each table that existed in the instance when
     * CreateCluster was first called, i.e.
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`. Any table added
     * to the instance by a later API call will be created in the new cluster by
     * that API call, not this one.
     * Values: information on how much of a table's data has been copied to the
     * newly-created cluster so far.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.CreateClusterMetadata.TableProgress&gt; tables = 4;
     * </code>
     */
    public Builder removeTables(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableTables().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress>
        getMutableTables() {
      bitField0_ |= 0x00000008;
      return internalGetMutableTables().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Keys: the full `name` of each table that existed in the instance when
     * CreateCluster was first called, i.e.
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`. Any table added
     * to the instance by a later API call will be created in the new cluster by
     * that API call, not this one.
     * Values: information on how much of a table's data has been copied to the
     * newly-created cluster so far.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.CreateClusterMetadata.TableProgress&gt; tables = 4;
     * </code>
     */
    public Builder putTables(
        java.lang.String key,
        com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableTables().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Keys: the full `name` of each table that existed in the instance when
     * CreateCluster was first called, i.e.
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/tables/&lt;table&gt;`. Any table added
     * to the instance by a later API call will be created in the new cluster by
     * that API call, not this one.
     * Values: information on how much of a table's data has been copied to the
     * newly-created cluster so far.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.bigtable.admin.v2.CreateClusterMetadata.TableProgress&gt; tables = 4;
     * </code>
     */
    public Builder putAllTables(
        java.util.Map<
                java.lang.String, com.google.bigtable.admin.v2.CreateClusterMetadata.TableProgress>
            values) {
      internalGetMutableTables().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.CreateClusterMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.CreateClusterMetadata)
  private static final com.google.bigtable.admin.v2.CreateClusterMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.CreateClusterMetadata();
  }

  public static com.google.bigtable.admin.v2.CreateClusterMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateClusterMetadata> PARSER =
      new com.google.protobuf.AbstractParser<CreateClusterMetadata>() {
        @java.lang.Override
        public CreateClusterMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreateClusterMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateClusterMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.admin.v2.CreateClusterMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
