/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/admin/v2/instance.proto

package com.google.bigtable.admin.v2;

/**
 *
 *
 * <pre>
 * A resizable group of nodes in a particular cloud location, capable
 * of serving all [Tables][google.bigtable.admin.v2.Table] in the parent
 * [Instance][google.bigtable.admin.v2.Instance].
 * </pre>
 *
 * Protobuf type {@code google.bigtable.admin.v2.Cluster}
 */
public final class Cluster extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.admin.v2.Cluster)
    ClusterOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Cluster.newBuilder() to construct.
  private Cluster(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Cluster() {
    name_ = "";
    location_ = "";
    state_ = 0;
    defaultStorageType_ = 0;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private Cluster(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              location_ = s;
              break;
            }
          case 24:
            {
              int rawValue = input.readEnum();

              state_ = rawValue;
              break;
            }
          case 32:
            {
              serveNodes_ = input.readInt32();
              break;
            }
          case 40:
            {
              int rawValue = input.readEnum();

              defaultStorageType_ = rawValue;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.admin.v2.InstanceProto
        .internal_static_google_bigtable_admin_v2_Cluster_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.admin.v2.InstanceProto
        .internal_static_google_bigtable_admin_v2_Cluster_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.admin.v2.Cluster.class,
            com.google.bigtable.admin.v2.Cluster.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Possible states of a cluster.
   * </pre>
   *
   * Protobuf enum {@code google.bigtable.admin.v2.Cluster.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The state of the cluster could not be determined.
     * </pre>
     *
     * <code>STATE_NOT_KNOWN = 0;</code>
     */
    STATE_NOT_KNOWN(0),
    /**
     *
     *
     * <pre>
     * The cluster has been successfully created and is ready to serve requests.
     * </pre>
     *
     * <code>READY = 1;</code>
     */
    READY(1),
    /**
     *
     *
     * <pre>
     * The cluster is currently being created, and may be destroyed
     * if the creation process encounters an error.
     * A cluster may not be able to serve requests while being created.
     * </pre>
     *
     * <code>CREATING = 2;</code>
     */
    CREATING(2),
    /**
     *
     *
     * <pre>
     * The cluster is currently being resized, and may revert to its previous
     * node count if the process encounters an error.
     * A cluster is still capable of serving requests while being resized,
     * but may exhibit performance as if its number of allocated nodes is
     * between the starting and requested states.
     * </pre>
     *
     * <code>RESIZING = 3;</code>
     */
    RESIZING(3),
    /**
     *
     *
     * <pre>
     * The cluster has no backing nodes. The data (tables) still
     * exist, but no operations can be performed on the cluster.
     * </pre>
     *
     * <code>DISABLED = 4;</code>
     */
    DISABLED(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The state of the cluster could not be determined.
     * </pre>
     *
     * <code>STATE_NOT_KNOWN = 0;</code>
     */
    public static final int STATE_NOT_KNOWN_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The cluster has been successfully created and is ready to serve requests.
     * </pre>
     *
     * <code>READY = 1;</code>
     */
    public static final int READY_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The cluster is currently being created, and may be destroyed
     * if the creation process encounters an error.
     * A cluster may not be able to serve requests while being created.
     * </pre>
     *
     * <code>CREATING = 2;</code>
     */
    public static final int CREATING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The cluster is currently being resized, and may revert to its previous
     * node count if the process encounters an error.
     * A cluster is still capable of serving requests while being resized,
     * but may exhibit performance as if its number of allocated nodes is
     * between the starting and requested states.
     * </pre>
     *
     * <code>RESIZING = 3;</code>
     */
    public static final int RESIZING_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The cluster has no backing nodes. The data (tables) still
     * exist, but no operations can be performed on the cluster.
     * </pre>
     *
     * <code>DISABLED = 4;</code>
     */
    public static final int DISABLED_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /** @deprecated Use {@link #forNumber(int)} instead. */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_NOT_KNOWN;
        case 1:
          return READY;
        case 2:
          return CREATING;
        case 3:
          return RESIZING;
        case 4:
          return DISABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.bigtable.admin.v2.Cluster.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.bigtable.admin.v2.Cluster.State)
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   *
   *
   * <pre>
   * (`OutputOnly`)
   * The unique name of the cluster. Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/clusters/[a-z][-a-z0-9]*`.
   * </pre>
   *
   * <code>string name = 1;</code>
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * (`OutputOnly`)
   * The unique name of the cluster. Values are of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/clusters/[a-z][-a-z0-9]*`.
   * </pre>
   *
   * <code>string name = 1;</code>
   */
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCATION_FIELD_NUMBER = 2;
  private volatile java.lang.Object location_;
  /**
   *
   *
   * <pre>
   * (`CreationOnly`)
   * The location where this cluster's nodes and storage reside. For best
   * performance, clients should be located as close as possible to this
   * cluster. Currently only zones are supported, so values should be of the
   * form `projects/&lt;project&gt;/locations/&lt;zone&gt;`.
   * </pre>
   *
   * <code>string location = 2;</code>
   */
  public java.lang.String getLocation() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      location_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * (`CreationOnly`)
   * The location where this cluster's nodes and storage reside. For best
   * performance, clients should be located as close as possible to this
   * cluster. Currently only zones are supported, so values should be of the
   * form `projects/&lt;project&gt;/locations/&lt;zone&gt;`.
   * </pre>
   *
   * <code>string location = 2;</code>
   */
  public com.google.protobuf.ByteString getLocationBytes() {
    java.lang.Object ref = location_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      location_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 3;
  private int state_;
  /**
   *
   *
   * <pre>
   * (`OutputOnly`)
   * The current state of the cluster.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Cluster.State state = 3;</code>
   */
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * (`OutputOnly`)
   * The current state of the cluster.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.Cluster.State state = 3;</code>
   */
  public com.google.bigtable.admin.v2.Cluster.State getState() {
    @SuppressWarnings("deprecation")
    com.google.bigtable.admin.v2.Cluster.State result =
        com.google.bigtable.admin.v2.Cluster.State.valueOf(state_);
    return result == null ? com.google.bigtable.admin.v2.Cluster.State.UNRECOGNIZED : result;
  }

  public static final int SERVE_NODES_FIELD_NUMBER = 4;
  private int serveNodes_;
  /**
   *
   *
   * <pre>
   * The number of nodes allocated to this cluster. More nodes enable higher
   * throughput and more consistent performance.
   * </pre>
   *
   * <code>int32 serve_nodes = 4;</code>
   */
  public int getServeNodes() {
    return serveNodes_;
  }

  public static final int DEFAULT_STORAGE_TYPE_FIELD_NUMBER = 5;
  private int defaultStorageType_;
  /**
   *
   *
   * <pre>
   * (`CreationOnly`)
   * The type of storage used by this cluster to serve its
   * parent instance's tables, unless explicitly overridden.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.StorageType default_storage_type = 5;</code>
   */
  public int getDefaultStorageTypeValue() {
    return defaultStorageType_;
  }
  /**
   *
   *
   * <pre>
   * (`CreationOnly`)
   * The type of storage used by this cluster to serve its
   * parent instance's tables, unless explicitly overridden.
   * </pre>
   *
   * <code>.google.bigtable.admin.v2.StorageType default_storage_type = 5;</code>
   */
  public com.google.bigtable.admin.v2.StorageType getDefaultStorageType() {
    @SuppressWarnings("deprecation")
    com.google.bigtable.admin.v2.StorageType result =
        com.google.bigtable.admin.v2.StorageType.valueOf(defaultStorageType_);
    return result == null ? com.google.bigtable.admin.v2.StorageType.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!getLocationBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, location_);
    }
    if (state_ != com.google.bigtable.admin.v2.Cluster.State.STATE_NOT_KNOWN.getNumber()) {
      output.writeEnum(3, state_);
    }
    if (serveNodes_ != 0) {
      output.writeInt32(4, serveNodes_);
    }
    if (defaultStorageType_
        != com.google.bigtable.admin.v2.StorageType.STORAGE_TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(5, defaultStorageType_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!getLocationBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, location_);
    }
    if (state_ != com.google.bigtable.admin.v2.Cluster.State.STATE_NOT_KNOWN.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, state_);
    }
    if (serveNodes_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, serveNodes_);
    }
    if (defaultStorageType_
        != com.google.bigtable.admin.v2.StorageType.STORAGE_TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, defaultStorageType_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.admin.v2.Cluster)) {
      return super.equals(obj);
    }
    com.google.bigtable.admin.v2.Cluster other = (com.google.bigtable.admin.v2.Cluster) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getLocation().equals(other.getLocation())) return false;
    if (state_ != other.state_) return false;
    if (getServeNodes() != other.getServeNodes()) return false;
    if (defaultStorageType_ != other.defaultStorageType_) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + LOCATION_FIELD_NUMBER;
    hash = (53 * hash) + getLocation().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + SERVE_NODES_FIELD_NUMBER;
    hash = (53 * hash) + getServeNodes();
    hash = (37 * hash) + DEFAULT_STORAGE_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + defaultStorageType_;
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.admin.v2.Cluster parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.Cluster parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Cluster parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.Cluster parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Cluster parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.admin.v2.Cluster parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Cluster parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.Cluster parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Cluster parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.Cluster parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.admin.v2.Cluster parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.admin.v2.Cluster parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.admin.v2.Cluster prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A resizable group of nodes in a particular cloud location, capable
   * of serving all [Tables][google.bigtable.admin.v2.Table] in the parent
   * [Instance][google.bigtable.admin.v2.Instance].
   * </pre>
   *
   * Protobuf type {@code google.bigtable.admin.v2.Cluster}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.admin.v2.Cluster)
      com.google.bigtable.admin.v2.ClusterOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.admin.v2.InstanceProto
          .internal_static_google_bigtable_admin_v2_Cluster_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.admin.v2.InstanceProto
          .internal_static_google_bigtable_admin_v2_Cluster_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.admin.v2.Cluster.class,
              com.google.bigtable.admin.v2.Cluster.Builder.class);
    }

    // Construct using com.google.bigtable.admin.v2.Cluster.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      name_ = "";

      location_ = "";

      state_ = 0;

      serveNodes_ = 0;

      defaultStorageType_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.admin.v2.InstanceProto
          .internal_static_google_bigtable_admin_v2_Cluster_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Cluster getDefaultInstanceForType() {
      return com.google.bigtable.admin.v2.Cluster.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Cluster build() {
      com.google.bigtable.admin.v2.Cluster result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.admin.v2.Cluster buildPartial() {
      com.google.bigtable.admin.v2.Cluster result = new com.google.bigtable.admin.v2.Cluster(this);
      result.name_ = name_;
      result.location_ = location_;
      result.state_ = state_;
      result.serveNodes_ = serveNodes_;
      result.defaultStorageType_ = defaultStorageType_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.admin.v2.Cluster) {
        return mergeFrom((com.google.bigtable.admin.v2.Cluster) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.admin.v2.Cluster other) {
      if (other == com.google.bigtable.admin.v2.Cluster.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getLocation().isEmpty()) {
        location_ = other.location_;
        onChanged();
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.getServeNodes() != 0) {
        setServeNodes(other.getServeNodes());
      }
      if (other.defaultStorageType_ != 0) {
        setDefaultStorageTypeValue(other.getDefaultStorageTypeValue());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.bigtable.admin.v2.Cluster parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.bigtable.admin.v2.Cluster) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * (`OutputOnly`)
     * The unique name of the cluster. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/clusters/[a-z][-a-z0-9]*`.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * (`OutputOnly`)
     * The unique name of the cluster. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/clusters/[a-z][-a-z0-9]*`.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * (`OutputOnly`)
     * The unique name of the cluster. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/clusters/[a-z][-a-z0-9]*`.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      name_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * (`OutputOnly`)
     * The unique name of the cluster. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/clusters/[a-z][-a-z0-9]*`.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder clearName() {

      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * (`OutputOnly`)
     * The unique name of the cluster. Values are of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/clusters/[a-z][-a-z0-9]*`.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object location_ = "";
    /**
     *
     *
     * <pre>
     * (`CreationOnly`)
     * The location where this cluster's nodes and storage reside. For best
     * performance, clients should be located as close as possible to this
     * cluster. Currently only zones are supported, so values should be of the
     * form `projects/&lt;project&gt;/locations/&lt;zone&gt;`.
     * </pre>
     *
     * <code>string location = 2;</code>
     */
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * (`CreationOnly`)
     * The location where this cluster's nodes and storage reside. For best
     * performance, clients should be located as close as possible to this
     * cluster. Currently only zones are supported, so values should be of the
     * form `projects/&lt;project&gt;/locations/&lt;zone&gt;`.
     * </pre>
     *
     * <code>string location = 2;</code>
     */
    public com.google.protobuf.ByteString getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * (`CreationOnly`)
     * The location where this cluster's nodes and storage reside. For best
     * performance, clients should be located as close as possible to this
     * cluster. Currently only zones are supported, so values should be of the
     * form `projects/&lt;project&gt;/locations/&lt;zone&gt;`.
     * </pre>
     *
     * <code>string location = 2;</code>
     */
    public Builder setLocation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      location_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * (`CreationOnly`)
     * The location where this cluster's nodes and storage reside. For best
     * performance, clients should be located as close as possible to this
     * cluster. Currently only zones are supported, so values should be of the
     * form `projects/&lt;project&gt;/locations/&lt;zone&gt;`.
     * </pre>
     *
     * <code>string location = 2;</code>
     */
    public Builder clearLocation() {

      location_ = getDefaultInstance().getLocation();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * (`CreationOnly`)
     * The location where this cluster's nodes and storage reside. For best
     * performance, clients should be located as close as possible to this
     * cluster. Currently only zones are supported, so values should be of the
     * form `projects/&lt;project&gt;/locations/&lt;zone&gt;`.
     * </pre>
     *
     * <code>string location = 2;</code>
     */
    public Builder setLocationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      location_ = value;
      onChanged();
      return this;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * (`OutputOnly`)
     * The current state of the cluster.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Cluster.State state = 3;</code>
     */
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * (`OutputOnly`)
     * The current state of the cluster.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Cluster.State state = 3;</code>
     */
    public Builder setStateValue(int value) {
      state_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * (`OutputOnly`)
     * The current state of the cluster.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Cluster.State state = 3;</code>
     */
    public com.google.bigtable.admin.v2.Cluster.State getState() {
      @SuppressWarnings("deprecation")
      com.google.bigtable.admin.v2.Cluster.State result =
          com.google.bigtable.admin.v2.Cluster.State.valueOf(state_);
      return result == null ? com.google.bigtable.admin.v2.Cluster.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * (`OutputOnly`)
     * The current state of the cluster.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Cluster.State state = 3;</code>
     */
    public Builder setState(com.google.bigtable.admin.v2.Cluster.State value) {
      if (value == null) {
        throw new NullPointerException();
      }

      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * (`OutputOnly`)
     * The current state of the cluster.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.Cluster.State state = 3;</code>
     */
    public Builder clearState() {

      state_ = 0;
      onChanged();
      return this;
    }

    private int serveNodes_;
    /**
     *
     *
     * <pre>
     * The number of nodes allocated to this cluster. More nodes enable higher
     * throughput and more consistent performance.
     * </pre>
     *
     * <code>int32 serve_nodes = 4;</code>
     */
    public int getServeNodes() {
      return serveNodes_;
    }
    /**
     *
     *
     * <pre>
     * The number of nodes allocated to this cluster. More nodes enable higher
     * throughput and more consistent performance.
     * </pre>
     *
     * <code>int32 serve_nodes = 4;</code>
     */
    public Builder setServeNodes(int value) {

      serveNodes_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The number of nodes allocated to this cluster. More nodes enable higher
     * throughput and more consistent performance.
     * </pre>
     *
     * <code>int32 serve_nodes = 4;</code>
     */
    public Builder clearServeNodes() {

      serveNodes_ = 0;
      onChanged();
      return this;
    }

    private int defaultStorageType_ = 0;
    /**
     *
     *
     * <pre>
     * (`CreationOnly`)
     * The type of storage used by this cluster to serve its
     * parent instance's tables, unless explicitly overridden.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.StorageType default_storage_type = 5;</code>
     */
    public int getDefaultStorageTypeValue() {
      return defaultStorageType_;
    }
    /**
     *
     *
     * <pre>
     * (`CreationOnly`)
     * The type of storage used by this cluster to serve its
     * parent instance's tables, unless explicitly overridden.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.StorageType default_storage_type = 5;</code>
     */
    public Builder setDefaultStorageTypeValue(int value) {
      defaultStorageType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * (`CreationOnly`)
     * The type of storage used by this cluster to serve its
     * parent instance's tables, unless explicitly overridden.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.StorageType default_storage_type = 5;</code>
     */
    public com.google.bigtable.admin.v2.StorageType getDefaultStorageType() {
      @SuppressWarnings("deprecation")
      com.google.bigtable.admin.v2.StorageType result =
          com.google.bigtable.admin.v2.StorageType.valueOf(defaultStorageType_);
      return result == null ? com.google.bigtable.admin.v2.StorageType.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * (`CreationOnly`)
     * The type of storage used by this cluster to serve its
     * parent instance's tables, unless explicitly overridden.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.StorageType default_storage_type = 5;</code>
     */
    public Builder setDefaultStorageType(com.google.bigtable.admin.v2.StorageType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      defaultStorageType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * (`CreationOnly`)
     * The type of storage used by this cluster to serve its
     * parent instance's tables, unless explicitly overridden.
     * </pre>
     *
     * <code>.google.bigtable.admin.v2.StorageType default_storage_type = 5;</code>
     */
    public Builder clearDefaultStorageType() {

      defaultStorageType_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.admin.v2.Cluster)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.admin.v2.Cluster)
  private static final com.google.bigtable.admin.v2.Cluster DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.admin.v2.Cluster();
  }

  public static com.google.bigtable.admin.v2.Cluster getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Cluster> PARSER =
      new com.google.protobuf.AbstractParser<Cluster>() {
        @java.lang.Override
        public Cluster parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new Cluster(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<Cluster> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Cluster> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.admin.v2.Cluster getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
