/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/storage/v1beta2/storage.proto

package com.google.cloud.bigquery.storage.v1beta2;

/**
 *
 *
 * <pre>
 * Response from calling `ReadRows` may include row data, progress and
 * throttling information.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.storage.v1beta2.ReadRowsResponse}
 */
public final class ReadRowsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1beta2.ReadRowsResponse)
    ReadRowsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReadRowsResponse.newBuilder() to construct.
  private ReadRowsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReadRowsResponse() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReadRowsResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ReadRowsResponse(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 18:
            {
              com.google.cloud.bigquery.storage.v1beta2.StreamStats.Builder subBuilder = null;
              if (stats_ != null) {
                subBuilder = stats_.toBuilder();
              }
              stats_ =
                  input.readMessage(
                      com.google.cloud.bigquery.storage.v1beta2.StreamStats.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(stats_);
                stats_ = subBuilder.buildPartial();
              }

              break;
            }
          case 26:
            {
              com.google.cloud.bigquery.storage.v1beta2.AvroRows.Builder subBuilder = null;
              if (rowsCase_ == 3) {
                subBuilder =
                    ((com.google.cloud.bigquery.storage.v1beta2.AvroRows) rows_).toBuilder();
              }
              rows_ =
                  input.readMessage(
                      com.google.cloud.bigquery.storage.v1beta2.AvroRows.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.cloud.bigquery.storage.v1beta2.AvroRows) rows_);
                rows_ = subBuilder.buildPartial();
              }
              rowsCase_ = 3;
              break;
            }
          case 34:
            {
              com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch.Builder subBuilder = null;
              if (rowsCase_ == 4) {
                subBuilder =
                    ((com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch) rows_)
                        .toBuilder();
              }
              rows_ =
                  input.readMessage(
                      com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch) rows_);
                rows_ = subBuilder.buildPartial();
              }
              rowsCase_ = 4;
              break;
            }
          case 42:
            {
              com.google.cloud.bigquery.storage.v1beta2.ThrottleState.Builder subBuilder = null;
              if (throttleState_ != null) {
                subBuilder = throttleState_.toBuilder();
              }
              throttleState_ =
                  input.readMessage(
                      com.google.cloud.bigquery.storage.v1beta2.ThrottleState.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(throttleState_);
                throttleState_ = subBuilder.buildPartial();
              }

              break;
            }
          case 48:
            {
              rowCount_ = input.readInt64();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.storage.v1beta2.StorageProto
        .internal_static_google_cloud_bigquery_storage_v1beta2_ReadRowsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.storage.v1beta2.StorageProto
        .internal_static_google_cloud_bigquery_storage_v1beta2_ReadRowsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse.class,
            com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse.Builder.class);
  }

  private int rowsCase_ = 0;
  private java.lang.Object rows_;

  public enum RowsCase implements com.google.protobuf.Internal.EnumLite {
    AVRO_ROWS(3),
    ARROW_RECORD_BATCH(4),
    ROWS_NOT_SET(0);
    private final int value;

    private RowsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RowsCase valueOf(int value) {
      return forNumber(value);
    }

    public static RowsCase forNumber(int value) {
      switch (value) {
        case 3:
          return AVRO_ROWS;
        case 4:
          return ARROW_RECORD_BATCH;
        case 0:
          return ROWS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public RowsCase getRowsCase() {
    return RowsCase.forNumber(rowsCase_);
  }

  public static final int AVRO_ROWS_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Serialized row data in AVRO format.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1beta2.AvroRows avro_rows = 3;</code>
   *
   * @return Whether the avroRows field is set.
   */
  public boolean hasAvroRows() {
    return rowsCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Serialized row data in AVRO format.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1beta2.AvroRows avro_rows = 3;</code>
   *
   * @return The avroRows.
   */
  public com.google.cloud.bigquery.storage.v1beta2.AvroRows getAvroRows() {
    if (rowsCase_ == 3) {
      return (com.google.cloud.bigquery.storage.v1beta2.AvroRows) rows_;
    }
    return com.google.cloud.bigquery.storage.v1beta2.AvroRows.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Serialized row data in AVRO format.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1beta2.AvroRows avro_rows = 3;</code>
   */
  public com.google.cloud.bigquery.storage.v1beta2.AvroRowsOrBuilder getAvroRowsOrBuilder() {
    if (rowsCase_ == 3) {
      return (com.google.cloud.bigquery.storage.v1beta2.AvroRows) rows_;
    }
    return com.google.cloud.bigquery.storage.v1beta2.AvroRows.getDefaultInstance();
  }

  public static final int ARROW_RECORD_BATCH_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Serialized row data in Arrow RecordBatch format.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch arrow_record_batch = 4;</code>
   *
   * @return Whether the arrowRecordBatch field is set.
   */
  public boolean hasArrowRecordBatch() {
    return rowsCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Serialized row data in Arrow RecordBatch format.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch arrow_record_batch = 4;</code>
   *
   * @return The arrowRecordBatch.
   */
  public com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch getArrowRecordBatch() {
    if (rowsCase_ == 4) {
      return (com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch) rows_;
    }
    return com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Serialized row data in Arrow RecordBatch format.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch arrow_record_batch = 4;</code>
   */
  public com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatchOrBuilder
      getArrowRecordBatchOrBuilder() {
    if (rowsCase_ == 4) {
      return (com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch) rows_;
    }
    return com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch.getDefaultInstance();
  }

  public static final int ROW_COUNT_FIELD_NUMBER = 6;
  private long rowCount_;
  /**
   *
   *
   * <pre>
   * Number of serialized rows in the rows block.
   * </pre>
   *
   * <code>int64 row_count = 6;</code>
   *
   * @return The rowCount.
   */
  public long getRowCount() {
    return rowCount_;
  }

  public static final int STATS_FIELD_NUMBER = 2;
  private com.google.cloud.bigquery.storage.v1beta2.StreamStats stats_;
  /**
   *
   *
   * <pre>
   * Statistics for the stream.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1beta2.StreamStats stats = 2;</code>
   *
   * @return Whether the stats field is set.
   */
  public boolean hasStats() {
    return stats_ != null;
  }
  /**
   *
   *
   * <pre>
   * Statistics for the stream.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1beta2.StreamStats stats = 2;</code>
   *
   * @return The stats.
   */
  public com.google.cloud.bigquery.storage.v1beta2.StreamStats getStats() {
    return stats_ == null
        ? com.google.cloud.bigquery.storage.v1beta2.StreamStats.getDefaultInstance()
        : stats_;
  }
  /**
   *
   *
   * <pre>
   * Statistics for the stream.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1beta2.StreamStats stats = 2;</code>
   */
  public com.google.cloud.bigquery.storage.v1beta2.StreamStatsOrBuilder getStatsOrBuilder() {
    return getStats();
  }

  public static final int THROTTLE_STATE_FIELD_NUMBER = 5;
  private com.google.cloud.bigquery.storage.v1beta2.ThrottleState throttleState_;
  /**
   *
   *
   * <pre>
   * Throttling state. If unset, the latest response still describes
   * the current throttling status.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1beta2.ThrottleState throttle_state = 5;</code>
   *
   * @return Whether the throttleState field is set.
   */
  public boolean hasThrottleState() {
    return throttleState_ != null;
  }
  /**
   *
   *
   * <pre>
   * Throttling state. If unset, the latest response still describes
   * the current throttling status.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1beta2.ThrottleState throttle_state = 5;</code>
   *
   * @return The throttleState.
   */
  public com.google.cloud.bigquery.storage.v1beta2.ThrottleState getThrottleState() {
    return throttleState_ == null
        ? com.google.cloud.bigquery.storage.v1beta2.ThrottleState.getDefaultInstance()
        : throttleState_;
  }
  /**
   *
   *
   * <pre>
   * Throttling state. If unset, the latest response still describes
   * the current throttling status.
   * </pre>
   *
   * <code>.google.cloud.bigquery.storage.v1beta2.ThrottleState throttle_state = 5;</code>
   */
  public com.google.cloud.bigquery.storage.v1beta2.ThrottleStateOrBuilder
      getThrottleStateOrBuilder() {
    return getThrottleState();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (stats_ != null) {
      output.writeMessage(2, getStats());
    }
    if (rowsCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.bigquery.storage.v1beta2.AvroRows) rows_);
    }
    if (rowsCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch) rows_);
    }
    if (throttleState_ != null) {
      output.writeMessage(5, getThrottleState());
    }
    if (rowCount_ != 0L) {
      output.writeInt64(6, rowCount_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (stats_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getStats());
    }
    if (rowsCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.bigquery.storage.v1beta2.AvroRows) rows_);
    }
    if (rowsCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch) rows_);
    }
    if (throttleState_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getThrottleState());
    }
    if (rowCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(6, rowCount_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse other =
        (com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse) obj;

    if (getRowCount() != other.getRowCount()) return false;
    if (hasStats() != other.hasStats()) return false;
    if (hasStats()) {
      if (!getStats().equals(other.getStats())) return false;
    }
    if (hasThrottleState() != other.hasThrottleState()) return false;
    if (hasThrottleState()) {
      if (!getThrottleState().equals(other.getThrottleState())) return false;
    }
    if (!getRowsCase().equals(other.getRowsCase())) return false;
    switch (rowsCase_) {
      case 3:
        if (!getAvroRows().equals(other.getAvroRows())) return false;
        break;
      case 4:
        if (!getArrowRecordBatch().equals(other.getArrowRecordBatch())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ROW_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getRowCount());
    if (hasStats()) {
      hash = (37 * hash) + STATS_FIELD_NUMBER;
      hash = (53 * hash) + getStats().hashCode();
    }
    if (hasThrottleState()) {
      hash = (37 * hash) + THROTTLE_STATE_FIELD_NUMBER;
      hash = (53 * hash) + getThrottleState().hashCode();
    }
    switch (rowsCase_) {
      case 3:
        hash = (37 * hash) + AVRO_ROWS_FIELD_NUMBER;
        hash = (53 * hash) + getAvroRows().hashCode();
        break;
      case 4:
        hash = (37 * hash) + ARROW_RECORD_BATCH_FIELD_NUMBER;
        hash = (53 * hash) + getArrowRecordBatch().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response from calling `ReadRows` may include row data, progress and
   * throttling information.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1beta2.ReadRowsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1beta2.ReadRowsResponse)
      com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1beta2.StorageProto
          .internal_static_google_cloud_bigquery_storage_v1beta2_ReadRowsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1beta2.StorageProto
          .internal_static_google_cloud_bigquery_storage_v1beta2_ReadRowsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse.class,
              com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      rowCount_ = 0L;

      if (statsBuilder_ == null) {
        stats_ = null;
      } else {
        stats_ = null;
        statsBuilder_ = null;
      }
      if (throttleStateBuilder_ == null) {
        throttleState_ = null;
      } else {
        throttleState_ = null;
        throttleStateBuilder_ = null;
      }
      rowsCase_ = 0;
      rows_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.storage.v1beta2.StorageProto
          .internal_static_google_cloud_bigquery_storage_v1beta2_ReadRowsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse getDefaultInstanceForType() {
      return com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse build() {
      com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse buildPartial() {
      com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse result =
          new com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse(this);
      if (rowsCase_ == 3) {
        if (avroRowsBuilder_ == null) {
          result.rows_ = rows_;
        } else {
          result.rows_ = avroRowsBuilder_.build();
        }
      }
      if (rowsCase_ == 4) {
        if (arrowRecordBatchBuilder_ == null) {
          result.rows_ = rows_;
        } else {
          result.rows_ = arrowRecordBatchBuilder_.build();
        }
      }
      result.rowCount_ = rowCount_;
      if (statsBuilder_ == null) {
        result.stats_ = stats_;
      } else {
        result.stats_ = statsBuilder_.build();
      }
      if (throttleStateBuilder_ == null) {
        result.throttleState_ = throttleState_;
      } else {
        result.throttleState_ = throttleStateBuilder_.build();
      }
      result.rowsCase_ = rowsCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse) {
        return mergeFrom((com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse other) {
      if (other == com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse.getDefaultInstance())
        return this;
      if (other.getRowCount() != 0L) {
        setRowCount(other.getRowCount());
      }
      if (other.hasStats()) {
        mergeStats(other.getStats());
      }
      if (other.hasThrottleState()) {
        mergeThrottleState(other.getThrottleState());
      }
      switch (other.getRowsCase()) {
        case AVRO_ROWS:
          {
            mergeAvroRows(other.getAvroRows());
            break;
          }
        case ARROW_RECORD_BATCH:
          {
            mergeArrowRecordBatch(other.getArrowRecordBatch());
            break;
          }
        case ROWS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int rowsCase_ = 0;
    private java.lang.Object rows_;

    public RowsCase getRowsCase() {
      return RowsCase.forNumber(rowsCase_);
    }

    public Builder clearRows() {
      rowsCase_ = 0;
      rows_ = null;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1beta2.AvroRows,
            com.google.cloud.bigquery.storage.v1beta2.AvroRows.Builder,
            com.google.cloud.bigquery.storage.v1beta2.AvroRowsOrBuilder>
        avroRowsBuilder_;
    /**
     *
     *
     * <pre>
     * Serialized row data in AVRO format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.AvroRows avro_rows = 3;</code>
     *
     * @return Whether the avroRows field is set.
     */
    public boolean hasAvroRows() {
      return rowsCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in AVRO format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.AvroRows avro_rows = 3;</code>
     *
     * @return The avroRows.
     */
    public com.google.cloud.bigquery.storage.v1beta2.AvroRows getAvroRows() {
      if (avroRowsBuilder_ == null) {
        if (rowsCase_ == 3) {
          return (com.google.cloud.bigquery.storage.v1beta2.AvroRows) rows_;
        }
        return com.google.cloud.bigquery.storage.v1beta2.AvroRows.getDefaultInstance();
      } else {
        if (rowsCase_ == 3) {
          return avroRowsBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.storage.v1beta2.AvroRows.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in AVRO format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.AvroRows avro_rows = 3;</code>
     */
    public Builder setAvroRows(com.google.cloud.bigquery.storage.v1beta2.AvroRows value) {
      if (avroRowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rows_ = value;
        onChanged();
      } else {
        avroRowsBuilder_.setMessage(value);
      }
      rowsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in AVRO format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.AvroRows avro_rows = 3;</code>
     */
    public Builder setAvroRows(
        com.google.cloud.bigquery.storage.v1beta2.AvroRows.Builder builderForValue) {
      if (avroRowsBuilder_ == null) {
        rows_ = builderForValue.build();
        onChanged();
      } else {
        avroRowsBuilder_.setMessage(builderForValue.build());
      }
      rowsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in AVRO format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.AvroRows avro_rows = 3;</code>
     */
    public Builder mergeAvroRows(com.google.cloud.bigquery.storage.v1beta2.AvroRows value) {
      if (avroRowsBuilder_ == null) {
        if (rowsCase_ == 3
            && rows_ != com.google.cloud.bigquery.storage.v1beta2.AvroRows.getDefaultInstance()) {
          rows_ =
              com.google.cloud.bigquery.storage.v1beta2.AvroRows.newBuilder(
                      (com.google.cloud.bigquery.storage.v1beta2.AvroRows) rows_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          rows_ = value;
        }
        onChanged();
      } else {
        if (rowsCase_ == 3) {
          avroRowsBuilder_.mergeFrom(value);
        }
        avroRowsBuilder_.setMessage(value);
      }
      rowsCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in AVRO format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.AvroRows avro_rows = 3;</code>
     */
    public Builder clearAvroRows() {
      if (avroRowsBuilder_ == null) {
        if (rowsCase_ == 3) {
          rowsCase_ = 0;
          rows_ = null;
          onChanged();
        }
      } else {
        if (rowsCase_ == 3) {
          rowsCase_ = 0;
          rows_ = null;
        }
        avroRowsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in AVRO format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.AvroRows avro_rows = 3;</code>
     */
    public com.google.cloud.bigquery.storage.v1beta2.AvroRows.Builder getAvroRowsBuilder() {
      return getAvroRowsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in AVRO format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.AvroRows avro_rows = 3;</code>
     */
    public com.google.cloud.bigquery.storage.v1beta2.AvroRowsOrBuilder getAvroRowsOrBuilder() {
      if ((rowsCase_ == 3) && (avroRowsBuilder_ != null)) {
        return avroRowsBuilder_.getMessageOrBuilder();
      } else {
        if (rowsCase_ == 3) {
          return (com.google.cloud.bigquery.storage.v1beta2.AvroRows) rows_;
        }
        return com.google.cloud.bigquery.storage.v1beta2.AvroRows.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in AVRO format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.AvroRows avro_rows = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1beta2.AvroRows,
            com.google.cloud.bigquery.storage.v1beta2.AvroRows.Builder,
            com.google.cloud.bigquery.storage.v1beta2.AvroRowsOrBuilder>
        getAvroRowsFieldBuilder() {
      if (avroRowsBuilder_ == null) {
        if (!(rowsCase_ == 3)) {
          rows_ = com.google.cloud.bigquery.storage.v1beta2.AvroRows.getDefaultInstance();
        }
        avroRowsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1beta2.AvroRows,
                com.google.cloud.bigquery.storage.v1beta2.AvroRows.Builder,
                com.google.cloud.bigquery.storage.v1beta2.AvroRowsOrBuilder>(
                (com.google.cloud.bigquery.storage.v1beta2.AvroRows) rows_,
                getParentForChildren(),
                isClean());
        rows_ = null;
      }
      rowsCase_ = 3;
      onChanged();
      ;
      return avroRowsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch,
            com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch.Builder,
            com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatchOrBuilder>
        arrowRecordBatchBuilder_;
    /**
     *
     *
     * <pre>
     * Serialized row data in Arrow RecordBatch format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch arrow_record_batch = 4;</code>
     *
     * @return Whether the arrowRecordBatch field is set.
     */
    public boolean hasArrowRecordBatch() {
      return rowsCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in Arrow RecordBatch format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch arrow_record_batch = 4;</code>
     *
     * @return The arrowRecordBatch.
     */
    public com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch getArrowRecordBatch() {
      if (arrowRecordBatchBuilder_ == null) {
        if (rowsCase_ == 4) {
          return (com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch) rows_;
        }
        return com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch.getDefaultInstance();
      } else {
        if (rowsCase_ == 4) {
          return arrowRecordBatchBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in Arrow RecordBatch format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch arrow_record_batch = 4;</code>
     */
    public Builder setArrowRecordBatch(
        com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch value) {
      if (arrowRecordBatchBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rows_ = value;
        onChanged();
      } else {
        arrowRecordBatchBuilder_.setMessage(value);
      }
      rowsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in Arrow RecordBatch format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch arrow_record_batch = 4;</code>
     */
    public Builder setArrowRecordBatch(
        com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch.Builder builderForValue) {
      if (arrowRecordBatchBuilder_ == null) {
        rows_ = builderForValue.build();
        onChanged();
      } else {
        arrowRecordBatchBuilder_.setMessage(builderForValue.build());
      }
      rowsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in Arrow RecordBatch format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch arrow_record_batch = 4;</code>
     */
    public Builder mergeArrowRecordBatch(
        com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch value) {
      if (arrowRecordBatchBuilder_ == null) {
        if (rowsCase_ == 4
            && rows_
                != com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch
                    .getDefaultInstance()) {
          rows_ =
              com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch.newBuilder(
                      (com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch) rows_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          rows_ = value;
        }
        onChanged();
      } else {
        if (rowsCase_ == 4) {
          arrowRecordBatchBuilder_.mergeFrom(value);
        }
        arrowRecordBatchBuilder_.setMessage(value);
      }
      rowsCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in Arrow RecordBatch format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch arrow_record_batch = 4;</code>
     */
    public Builder clearArrowRecordBatch() {
      if (arrowRecordBatchBuilder_ == null) {
        if (rowsCase_ == 4) {
          rowsCase_ = 0;
          rows_ = null;
          onChanged();
        }
      } else {
        if (rowsCase_ == 4) {
          rowsCase_ = 0;
          rows_ = null;
        }
        arrowRecordBatchBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in Arrow RecordBatch format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch arrow_record_batch = 4;</code>
     */
    public com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch.Builder
        getArrowRecordBatchBuilder() {
      return getArrowRecordBatchFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in Arrow RecordBatch format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch arrow_record_batch = 4;</code>
     */
    public com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatchOrBuilder
        getArrowRecordBatchOrBuilder() {
      if ((rowsCase_ == 4) && (arrowRecordBatchBuilder_ != null)) {
        return arrowRecordBatchBuilder_.getMessageOrBuilder();
      } else {
        if (rowsCase_ == 4) {
          return (com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch) rows_;
        }
        return com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Serialized row data in Arrow RecordBatch format.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch arrow_record_batch = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch,
            com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch.Builder,
            com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatchOrBuilder>
        getArrowRecordBatchFieldBuilder() {
      if (arrowRecordBatchBuilder_ == null) {
        if (!(rowsCase_ == 4)) {
          rows_ = com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch.getDefaultInstance();
        }
        arrowRecordBatchBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch,
                com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch.Builder,
                com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatchOrBuilder>(
                (com.google.cloud.bigquery.storage.v1beta2.ArrowRecordBatch) rows_,
                getParentForChildren(),
                isClean());
        rows_ = null;
      }
      rowsCase_ = 4;
      onChanged();
      ;
      return arrowRecordBatchBuilder_;
    }

    private long rowCount_;
    /**
     *
     *
     * <pre>
     * Number of serialized rows in the rows block.
     * </pre>
     *
     * <code>int64 row_count = 6;</code>
     *
     * @return The rowCount.
     */
    public long getRowCount() {
      return rowCount_;
    }
    /**
     *
     *
     * <pre>
     * Number of serialized rows in the rows block.
     * </pre>
     *
     * <code>int64 row_count = 6;</code>
     *
     * @param value The rowCount to set.
     * @return This builder for chaining.
     */
    public Builder setRowCount(long value) {

      rowCount_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of serialized rows in the rows block.
     * </pre>
     *
     * <code>int64 row_count = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRowCount() {

      rowCount_ = 0L;
      onChanged();
      return this;
    }

    private com.google.cloud.bigquery.storage.v1beta2.StreamStats stats_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1beta2.StreamStats,
            com.google.cloud.bigquery.storage.v1beta2.StreamStats.Builder,
            com.google.cloud.bigquery.storage.v1beta2.StreamStatsOrBuilder>
        statsBuilder_;
    /**
     *
     *
     * <pre>
     * Statistics for the stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.StreamStats stats = 2;</code>
     *
     * @return Whether the stats field is set.
     */
    public boolean hasStats() {
      return statsBuilder_ != null || stats_ != null;
    }
    /**
     *
     *
     * <pre>
     * Statistics for the stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.StreamStats stats = 2;</code>
     *
     * @return The stats.
     */
    public com.google.cloud.bigquery.storage.v1beta2.StreamStats getStats() {
      if (statsBuilder_ == null) {
        return stats_ == null
            ? com.google.cloud.bigquery.storage.v1beta2.StreamStats.getDefaultInstance()
            : stats_;
      } else {
        return statsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Statistics for the stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.StreamStats stats = 2;</code>
     */
    public Builder setStats(com.google.cloud.bigquery.storage.v1beta2.StreamStats value) {
      if (statsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stats_ = value;
        onChanged();
      } else {
        statsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Statistics for the stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.StreamStats stats = 2;</code>
     */
    public Builder setStats(
        com.google.cloud.bigquery.storage.v1beta2.StreamStats.Builder builderForValue) {
      if (statsBuilder_ == null) {
        stats_ = builderForValue.build();
        onChanged();
      } else {
        statsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Statistics for the stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.StreamStats stats = 2;</code>
     */
    public Builder mergeStats(com.google.cloud.bigquery.storage.v1beta2.StreamStats value) {
      if (statsBuilder_ == null) {
        if (stats_ != null) {
          stats_ =
              com.google.cloud.bigquery.storage.v1beta2.StreamStats.newBuilder(stats_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          stats_ = value;
        }
        onChanged();
      } else {
        statsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Statistics for the stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.StreamStats stats = 2;</code>
     */
    public Builder clearStats() {
      if (statsBuilder_ == null) {
        stats_ = null;
        onChanged();
      } else {
        stats_ = null;
        statsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Statistics for the stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.StreamStats stats = 2;</code>
     */
    public com.google.cloud.bigquery.storage.v1beta2.StreamStats.Builder getStatsBuilder() {

      onChanged();
      return getStatsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Statistics for the stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.StreamStats stats = 2;</code>
     */
    public com.google.cloud.bigquery.storage.v1beta2.StreamStatsOrBuilder getStatsOrBuilder() {
      if (statsBuilder_ != null) {
        return statsBuilder_.getMessageOrBuilder();
      } else {
        return stats_ == null
            ? com.google.cloud.bigquery.storage.v1beta2.StreamStats.getDefaultInstance()
            : stats_;
      }
    }
    /**
     *
     *
     * <pre>
     * Statistics for the stream.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.StreamStats stats = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1beta2.StreamStats,
            com.google.cloud.bigquery.storage.v1beta2.StreamStats.Builder,
            com.google.cloud.bigquery.storage.v1beta2.StreamStatsOrBuilder>
        getStatsFieldBuilder() {
      if (statsBuilder_ == null) {
        statsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1beta2.StreamStats,
                com.google.cloud.bigquery.storage.v1beta2.StreamStats.Builder,
                com.google.cloud.bigquery.storage.v1beta2.StreamStatsOrBuilder>(
                getStats(), getParentForChildren(), isClean());
        stats_ = null;
      }
      return statsBuilder_;
    }

    private com.google.cloud.bigquery.storage.v1beta2.ThrottleState throttleState_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1beta2.ThrottleState,
            com.google.cloud.bigquery.storage.v1beta2.ThrottleState.Builder,
            com.google.cloud.bigquery.storage.v1beta2.ThrottleStateOrBuilder>
        throttleStateBuilder_;
    /**
     *
     *
     * <pre>
     * Throttling state. If unset, the latest response still describes
     * the current throttling status.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.ThrottleState throttle_state = 5;</code>
     *
     * @return Whether the throttleState field is set.
     */
    public boolean hasThrottleState() {
      return throttleStateBuilder_ != null || throttleState_ != null;
    }
    /**
     *
     *
     * <pre>
     * Throttling state. If unset, the latest response still describes
     * the current throttling status.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.ThrottleState throttle_state = 5;</code>
     *
     * @return The throttleState.
     */
    public com.google.cloud.bigquery.storage.v1beta2.ThrottleState getThrottleState() {
      if (throttleStateBuilder_ == null) {
        return throttleState_ == null
            ? com.google.cloud.bigquery.storage.v1beta2.ThrottleState.getDefaultInstance()
            : throttleState_;
      } else {
        return throttleStateBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Throttling state. If unset, the latest response still describes
     * the current throttling status.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.ThrottleState throttle_state = 5;</code>
     */
    public Builder setThrottleState(com.google.cloud.bigquery.storage.v1beta2.ThrottleState value) {
      if (throttleStateBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        throttleState_ = value;
        onChanged();
      } else {
        throttleStateBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Throttling state. If unset, the latest response still describes
     * the current throttling status.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.ThrottleState throttle_state = 5;</code>
     */
    public Builder setThrottleState(
        com.google.cloud.bigquery.storage.v1beta2.ThrottleState.Builder builderForValue) {
      if (throttleStateBuilder_ == null) {
        throttleState_ = builderForValue.build();
        onChanged();
      } else {
        throttleStateBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Throttling state. If unset, the latest response still describes
     * the current throttling status.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.ThrottleState throttle_state = 5;</code>
     */
    public Builder mergeThrottleState(
        com.google.cloud.bigquery.storage.v1beta2.ThrottleState value) {
      if (throttleStateBuilder_ == null) {
        if (throttleState_ != null) {
          throttleState_ =
              com.google.cloud.bigquery.storage.v1beta2.ThrottleState.newBuilder(throttleState_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          throttleState_ = value;
        }
        onChanged();
      } else {
        throttleStateBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Throttling state. If unset, the latest response still describes
     * the current throttling status.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.ThrottleState throttle_state = 5;</code>
     */
    public Builder clearThrottleState() {
      if (throttleStateBuilder_ == null) {
        throttleState_ = null;
        onChanged();
      } else {
        throttleState_ = null;
        throttleStateBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Throttling state. If unset, the latest response still describes
     * the current throttling status.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.ThrottleState throttle_state = 5;</code>
     */
    public com.google.cloud.bigquery.storage.v1beta2.ThrottleState.Builder
        getThrottleStateBuilder() {

      onChanged();
      return getThrottleStateFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Throttling state. If unset, the latest response still describes
     * the current throttling status.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.ThrottleState throttle_state = 5;</code>
     */
    public com.google.cloud.bigquery.storage.v1beta2.ThrottleStateOrBuilder
        getThrottleStateOrBuilder() {
      if (throttleStateBuilder_ != null) {
        return throttleStateBuilder_.getMessageOrBuilder();
      } else {
        return throttleState_ == null
            ? com.google.cloud.bigquery.storage.v1beta2.ThrottleState.getDefaultInstance()
            : throttleState_;
      }
    }
    /**
     *
     *
     * <pre>
     * Throttling state. If unset, the latest response still describes
     * the current throttling status.
     * </pre>
     *
     * <code>.google.cloud.bigquery.storage.v1beta2.ThrottleState throttle_state = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1beta2.ThrottleState,
            com.google.cloud.bigquery.storage.v1beta2.ThrottleState.Builder,
            com.google.cloud.bigquery.storage.v1beta2.ThrottleStateOrBuilder>
        getThrottleStateFieldBuilder() {
      if (throttleStateBuilder_ == null) {
        throttleStateBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1beta2.ThrottleState,
                com.google.cloud.bigquery.storage.v1beta2.ThrottleState.Builder,
                com.google.cloud.bigquery.storage.v1beta2.ThrottleStateOrBuilder>(
                getThrottleState(), getParentForChildren(), isClean());
        throttleState_ = null;
      }
      return throttleStateBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1beta2.ReadRowsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1beta2.ReadRowsResponse)
  private static final com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse();
  }

  public static com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReadRowsResponse> PARSER =
      new com.google.protobuf.AbstractParser<ReadRowsResponse>() {
        @java.lang.Override
        public ReadRowsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ReadRowsResponse(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ReadRowsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReadRowsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
