/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/storage/v1alpha/metastore_partition.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.bigquery.storage.v1alpha;

/**
 *
 *
 * <pre>
 * The top-level message sent by the client to the
 * [Partitions.StreamMetastorePartitions]() method.
 * Follows the default gRPC streaming maximum size of 4 MB.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest}
 */
public final class StreamMetastorePartitionsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest)
    StreamMetastorePartitionsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StreamMetastorePartitionsRequest.newBuilder() to construct.
  private StreamMetastorePartitionsRequest(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StreamMetastorePartitionsRequest() {
    parent_ = "";
    metastorePartitions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StreamMetastorePartitionsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.storage.v1alpha.MetastorePartitionServiceProto
        .internal_static_google_cloud_bigquery_storage_v1alpha_StreamMetastorePartitionsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.storage.v1alpha.MetastorePartitionServiceProto
        .internal_static_google_cloud_bigquery_storage_v1alpha_StreamMetastorePartitionsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest.class,
            com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest.Builder
                .class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. Reference to the table to where the partition to be added, in the
   * format of
   * projects/{project}/locations/{location}/datasets/{dataset}/tables/{table}.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Reference to the table to where the partition to be added, in the
   * format of
   * projects/{project}/locations/{location}/datasets/{dataset}/tables/{table}.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METASTORE_PARTITIONS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.bigquery.storage.v1alpha.MetastorePartition>
      metastorePartitions_;
  /**
   *
   *
   * <pre>
   * Optional. A list of metastore partitions to be added to the table.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1alpha.MetastorePartition metastore_partitions = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.bigquery.storage.v1alpha.MetastorePartition>
      getMetastorePartitionsList() {
    return metastorePartitions_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of metastore partitions to be added to the table.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1alpha.MetastorePartition metastore_partitions = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.bigquery.storage.v1alpha.MetastorePartitionOrBuilder>
      getMetastorePartitionsOrBuilderList() {
    return metastorePartitions_;
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of metastore partitions to be added to the table.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1alpha.MetastorePartition metastore_partitions = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getMetastorePartitionsCount() {
    return metastorePartitions_.size();
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of metastore partitions to be added to the table.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1alpha.MetastorePartition metastore_partitions = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1alpha.MetastorePartition getMetastorePartitions(
      int index) {
    return metastorePartitions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Optional. A list of metastore partitions to be added to the table.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1alpha.MetastorePartition metastore_partitions = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1alpha.MetastorePartitionOrBuilder
      getMetastorePartitionsOrBuilder(int index) {
    return metastorePartitions_.get(index);
  }

  public static final int SKIP_EXISTING_PARTITIONS_FIELD_NUMBER = 3;
  private boolean skipExistingPartitions_ = false;
  /**
   *
   *
   * <pre>
   * Optional. Mimics the ifNotExists flag in IMetaStoreClient
   * add_partitions(..). If the flag is set to false, the server will return
   * ALREADY_EXISTS on commit if any partition already exists. If the flag is
   * set to true:
   *  1) the server will skip existing partitions
   *  insert only the non-existing partitions as part of the commit.
   *  2) The client must set the `skip_existing_partitions` field to true for
   *  all requests in the stream.
   * </pre>
   *
   * <code>bool skip_existing_partitions = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The skipExistingPartitions.
   */
  @java.lang.Override
  public boolean getSkipExistingPartitions() {
    return skipExistingPartitions_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    for (int i = 0; i < metastorePartitions_.size(); i++) {
      output.writeMessage(2, metastorePartitions_.get(i));
    }
    if (skipExistingPartitions_ != false) {
      output.writeBool(3, skipExistingPartitions_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    for (int i = 0; i < metastorePartitions_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(2, metastorePartitions_.get(i));
    }
    if (skipExistingPartitions_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, skipExistingPartitions_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest other =
        (com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getMetastorePartitionsList().equals(other.getMetastorePartitionsList())) return false;
    if (getSkipExistingPartitions() != other.getSkipExistingPartitions()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (getMetastorePartitionsCount() > 0) {
      hash = (37 * hash) + METASTORE_PARTITIONS_FIELD_NUMBER;
      hash = (53 * hash) + getMetastorePartitionsList().hashCode();
    }
    hash = (37 * hash) + SKIP_EXISTING_PARTITIONS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSkipExistingPartitions());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The top-level message sent by the client to the
   * [Partitions.StreamMetastorePartitions]() method.
   * Follows the default gRPC streaming maximum size of 4 MB.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest)
      com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1alpha.MetastorePartitionServiceProto
          .internal_static_google_cloud_bigquery_storage_v1alpha_StreamMetastorePartitionsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1alpha.MetastorePartitionServiceProto
          .internal_static_google_cloud_bigquery_storage_v1alpha_StreamMetastorePartitionsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest.class,
              com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest.Builder
                  .class);
    }

    // Construct using
    // com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      if (metastorePartitionsBuilder_ == null) {
        metastorePartitions_ = java.util.Collections.emptyList();
      } else {
        metastorePartitions_ = null;
        metastorePartitionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      skipExistingPartitions_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.storage.v1alpha.MetastorePartitionServiceProto
          .internal_static_google_cloud_bigquery_storage_v1alpha_StreamMetastorePartitionsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest
        getDefaultInstanceForType() {
      return com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest
          .getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest build() {
      com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest result =
          buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest
        buildPartial() {
      com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest result =
          new com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest result) {
      if (metastorePartitionsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          metastorePartitions_ = java.util.Collections.unmodifiableList(metastorePartitions_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.metastorePartitions_ = metastorePartitions_;
      } else {
        result.metastorePartitions_ = metastorePartitionsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.skipExistingPartitions_ = skipExistingPartitions_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest) {
        return mergeFrom(
            (com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest other) {
      if (other
          == com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest
              .getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (metastorePartitionsBuilder_ == null) {
        if (!other.metastorePartitions_.isEmpty()) {
          if (metastorePartitions_.isEmpty()) {
            metastorePartitions_ = other.metastorePartitions_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureMetastorePartitionsIsMutable();
            metastorePartitions_.addAll(other.metastorePartitions_);
          }
          onChanged();
        }
      } else {
        if (!other.metastorePartitions_.isEmpty()) {
          if (metastorePartitionsBuilder_.isEmpty()) {
            metastorePartitionsBuilder_.dispose();
            metastorePartitionsBuilder_ = null;
            metastorePartitions_ = other.metastorePartitions_;
            bitField0_ = (bitField0_ & ~0x00000002);
            metastorePartitionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMetastorePartitionsFieldBuilder()
                    : null;
          } else {
            metastorePartitionsBuilder_.addAllMessages(other.metastorePartitions_);
          }
        }
      }
      if (other.getSkipExistingPartitions() != false) {
        setSkipExistingPartitions(other.getSkipExistingPartitions());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.bigquery.storage.v1alpha.MetastorePartition m =
                    input.readMessage(
                        com.google.cloud.bigquery.storage.v1alpha.MetastorePartition.parser(),
                        extensionRegistry);
                if (metastorePartitionsBuilder_ == null) {
                  ensureMetastorePartitionsIsMutable();
                  metastorePartitions_.add(m);
                } else {
                  metastorePartitionsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 24:
              {
                skipExistingPartitions_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. Reference to the table to where the partition to be added, in the
     * format of
     * projects/{project}/locations/{location}/datasets/{dataset}/tables/{table}.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Reference to the table to where the partition to be added, in the
     * format of
     * projects/{project}/locations/{location}/datasets/{dataset}/tables/{table}.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Reference to the table to where the partition to be added, in the
     * format of
     * projects/{project}/locations/{location}/datasets/{dataset}/tables/{table}.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Reference to the table to where the partition to be added, in the
     * format of
     * projects/{project}/locations/{location}/datasets/{dataset}/tables/{table}.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Reference to the table to where the partition to be added, in the
     * format of
     * projects/{project}/locations/{location}/datasets/{dataset}/tables/{table}.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.bigquery.storage.v1alpha.MetastorePartition>
        metastorePartitions_ = java.util.Collections.emptyList();

    private void ensureMetastorePartitionsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        metastorePartitions_ =
            new java.util.ArrayList<com.google.cloud.bigquery.storage.v1alpha.MetastorePartition>(
                metastorePartitions_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1alpha.MetastorePartition,
            com.google.cloud.bigquery.storage.v1alpha.MetastorePartition.Builder,
            com.google.cloud.bigquery.storage.v1alpha.MetastorePartitionOrBuilder>
        metastorePartitionsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. A list of metastore partitions to be added to the table.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.MetastorePartition metastore_partitions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.storage.v1alpha.MetastorePartition>
        getMetastorePartitionsList() {
      if (metastorePartitionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(metastorePartitions_);
      } else {
        return metastorePartitionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of metastore partitions to be added to the table.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.MetastorePartition metastore_partitions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getMetastorePartitionsCount() {
      if (metastorePartitionsBuilder_ == null) {
        return metastorePartitions_.size();
      } else {
        return metastorePartitionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of metastore partitions to be added to the table.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.MetastorePartition metastore_partitions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1alpha.MetastorePartition getMetastorePartitions(
        int index) {
      if (metastorePartitionsBuilder_ == null) {
        return metastorePartitions_.get(index);
      } else {
        return metastorePartitionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of metastore partitions to be added to the table.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.MetastorePartition metastore_partitions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMetastorePartitions(
        int index, com.google.cloud.bigquery.storage.v1alpha.MetastorePartition value) {
      if (metastorePartitionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetastorePartitionsIsMutable();
        metastorePartitions_.set(index, value);
        onChanged();
      } else {
        metastorePartitionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of metastore partitions to be added to the table.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.MetastorePartition metastore_partitions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setMetastorePartitions(
        int index,
        com.google.cloud.bigquery.storage.v1alpha.MetastorePartition.Builder builderForValue) {
      if (metastorePartitionsBuilder_ == null) {
        ensureMetastorePartitionsIsMutable();
        metastorePartitions_.set(index, builderForValue.build());
        onChanged();
      } else {
        metastorePartitionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of metastore partitions to be added to the table.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.MetastorePartition metastore_partitions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addMetastorePartitions(
        com.google.cloud.bigquery.storage.v1alpha.MetastorePartition value) {
      if (metastorePartitionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetastorePartitionsIsMutable();
        metastorePartitions_.add(value);
        onChanged();
      } else {
        metastorePartitionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of metastore partitions to be added to the table.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.MetastorePartition metastore_partitions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addMetastorePartitions(
        int index, com.google.cloud.bigquery.storage.v1alpha.MetastorePartition value) {
      if (metastorePartitionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetastorePartitionsIsMutable();
        metastorePartitions_.add(index, value);
        onChanged();
      } else {
        metastorePartitionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of metastore partitions to be added to the table.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.MetastorePartition metastore_partitions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addMetastorePartitions(
        com.google.cloud.bigquery.storage.v1alpha.MetastorePartition.Builder builderForValue) {
      if (metastorePartitionsBuilder_ == null) {
        ensureMetastorePartitionsIsMutable();
        metastorePartitions_.add(builderForValue.build());
        onChanged();
      } else {
        metastorePartitionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of metastore partitions to be added to the table.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.MetastorePartition metastore_partitions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addMetastorePartitions(
        int index,
        com.google.cloud.bigquery.storage.v1alpha.MetastorePartition.Builder builderForValue) {
      if (metastorePartitionsBuilder_ == null) {
        ensureMetastorePartitionsIsMutable();
        metastorePartitions_.add(index, builderForValue.build());
        onChanged();
      } else {
        metastorePartitionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of metastore partitions to be added to the table.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.MetastorePartition metastore_partitions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllMetastorePartitions(
        java.lang.Iterable<? extends com.google.cloud.bigquery.storage.v1alpha.MetastorePartition>
            values) {
      if (metastorePartitionsBuilder_ == null) {
        ensureMetastorePartitionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metastorePartitions_);
        onChanged();
      } else {
        metastorePartitionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of metastore partitions to be added to the table.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.MetastorePartition metastore_partitions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearMetastorePartitions() {
      if (metastorePartitionsBuilder_ == null) {
        metastorePartitions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        metastorePartitionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of metastore partitions to be added to the table.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.MetastorePartition metastore_partitions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeMetastorePartitions(int index) {
      if (metastorePartitionsBuilder_ == null) {
        ensureMetastorePartitionsIsMutable();
        metastorePartitions_.remove(index);
        onChanged();
      } else {
        metastorePartitionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of metastore partitions to be added to the table.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.MetastorePartition metastore_partitions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1alpha.MetastorePartition.Builder
        getMetastorePartitionsBuilder(int index) {
      return getMetastorePartitionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of metastore partitions to be added to the table.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.MetastorePartition metastore_partitions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1alpha.MetastorePartitionOrBuilder
        getMetastorePartitionsOrBuilder(int index) {
      if (metastorePartitionsBuilder_ == null) {
        return metastorePartitions_.get(index);
      } else {
        return metastorePartitionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of metastore partitions to be added to the table.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.MetastorePartition metastore_partitions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.bigquery.storage.v1alpha.MetastorePartitionOrBuilder>
        getMetastorePartitionsOrBuilderList() {
      if (metastorePartitionsBuilder_ != null) {
        return metastorePartitionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(metastorePartitions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of metastore partitions to be added to the table.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.MetastorePartition metastore_partitions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1alpha.MetastorePartition.Builder
        addMetastorePartitionsBuilder() {
      return getMetastorePartitionsFieldBuilder()
          .addBuilder(
              com.google.cloud.bigquery.storage.v1alpha.MetastorePartition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of metastore partitions to be added to the table.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.MetastorePartition metastore_partitions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1alpha.MetastorePartition.Builder
        addMetastorePartitionsBuilder(int index) {
      return getMetastorePartitionsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.bigquery.storage.v1alpha.MetastorePartition.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Optional. A list of metastore partitions to be added to the table.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1alpha.MetastorePartition metastore_partitions = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.storage.v1alpha.MetastorePartition.Builder>
        getMetastorePartitionsBuilderList() {
      return getMetastorePartitionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1alpha.MetastorePartition,
            com.google.cloud.bigquery.storage.v1alpha.MetastorePartition.Builder,
            com.google.cloud.bigquery.storage.v1alpha.MetastorePartitionOrBuilder>
        getMetastorePartitionsFieldBuilder() {
      if (metastorePartitionsBuilder_ == null) {
        metastorePartitionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1alpha.MetastorePartition,
                com.google.cloud.bigquery.storage.v1alpha.MetastorePartition.Builder,
                com.google.cloud.bigquery.storage.v1alpha.MetastorePartitionOrBuilder>(
                metastorePartitions_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        metastorePartitions_ = null;
      }
      return metastorePartitionsBuilder_;
    }

    private boolean skipExistingPartitions_;
    /**
     *
     *
     * <pre>
     * Optional. Mimics the ifNotExists flag in IMetaStoreClient
     * add_partitions(..). If the flag is set to false, the server will return
     * ALREADY_EXISTS on commit if any partition already exists. If the flag is
     * set to true:
     *  1) the server will skip existing partitions
     *  insert only the non-existing partitions as part of the commit.
     *  2) The client must set the `skip_existing_partitions` field to true for
     *  all requests in the stream.
     * </pre>
     *
     * <code>bool skip_existing_partitions = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The skipExistingPartitions.
     */
    @java.lang.Override
    public boolean getSkipExistingPartitions() {
      return skipExistingPartitions_;
    }
    /**
     *
     *
     * <pre>
     * Optional. Mimics the ifNotExists flag in IMetaStoreClient
     * add_partitions(..). If the flag is set to false, the server will return
     * ALREADY_EXISTS on commit if any partition already exists. If the flag is
     * set to true:
     *  1) the server will skip existing partitions
     *  insert only the non-existing partitions as part of the commit.
     *  2) The client must set the `skip_existing_partitions` field to true for
     *  all requests in the stream.
     * </pre>
     *
     * <code>bool skip_existing_partitions = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The skipExistingPartitions to set.
     * @return This builder for chaining.
     */
    public Builder setSkipExistingPartitions(boolean value) {

      skipExistingPartitions_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Mimics the ifNotExists flag in IMetaStoreClient
     * add_partitions(..). If the flag is set to false, the server will return
     * ALREADY_EXISTS on commit if any partition already exists. If the flag is
     * set to true:
     *  1) the server will skip existing partitions
     *  insert only the non-existing partitions as part of the commit.
     *  2) The client must set the `skip_existing_partitions` field to true for
     *  all requests in the stream.
     * </pre>
     *
     * <code>bool skip_existing_partitions = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSkipExistingPartitions() {
      bitField0_ = (bitField0_ & ~0x00000004);
      skipExistingPartitions_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest)
  private static final com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest();
  }

  public static com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StreamMetastorePartitionsRequest> PARSER =
      new com.google.protobuf.AbstractParser<StreamMetastorePartitionsRequest>() {
        @java.lang.Override
        public StreamMetastorePartitionsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StreamMetastorePartitionsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StreamMetastorePartitionsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1alpha.StreamMetastorePartitionsRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
