/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/storage/v1/stream.proto

package com.google.cloud.bigquery.storage.v1;

/**
 *
 *
 * <pre>
 * Information about the ReadSession.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.storage.v1.ReadSession}
 */
public final class ReadSession extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1.ReadSession)
    ReadSessionOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReadSession.newBuilder() to construct.
  private ReadSession(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReadSession() {
    name_ = "";
    dataFormat_ = 0;
    table_ = "";
    streams_ = java.util.Collections.emptyList();
    traceId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReadSession();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.storage.v1.StreamProto
        .internal_static_google_cloud_bigquery_storage_v1_ReadSession_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.storage.v1.StreamProto
        .internal_static_google_cloud_bigquery_storage_v1_ReadSession_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.storage.v1.ReadSession.class,
            com.google.cloud.bigquery.storage.v1.ReadSession.Builder.class);
  }

  public interface TableModifiersOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1.ReadSession.TableModifiers)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The snapshot time of the table. If not set, interpreted as now.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
     *
     * @return Whether the snapshotTime field is set.
     */
    boolean hasSnapshotTime();
    /**
     *
     *
     * <pre>
     * The snapshot time of the table. If not set, interpreted as now.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
     *
     * @return The snapshotTime.
     */
    com.google.protobuf.Timestamp getSnapshotTime();
    /**
     *
     *
     * <pre>
     * The snapshot time of the table. If not set, interpreted as now.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
     */
    com.google.protobuf.TimestampOrBuilder getSnapshotTimeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Additional attributes when reading a table.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1.ReadSession.TableModifiers}
   */
  public static final class TableModifiers extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1.ReadSession.TableModifiers)
      TableModifiersOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TableModifiers.newBuilder() to construct.
    private TableModifiers(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TableModifiers() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TableModifiers();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1.StreamProto
          .internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableModifiers_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1.StreamProto
          .internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableModifiers_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.class,
              com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.Builder.class);
    }

    public static final int SNAPSHOT_TIME_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp snapshotTime_;
    /**
     *
     *
     * <pre>
     * The snapshot time of the table. If not set, interpreted as now.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
     *
     * @return Whether the snapshotTime field is set.
     */
    @java.lang.Override
    public boolean hasSnapshotTime() {
      return snapshotTime_ != null;
    }
    /**
     *
     *
     * <pre>
     * The snapshot time of the table. If not set, interpreted as now.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
     *
     * @return The snapshotTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getSnapshotTime() {
      return snapshotTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : snapshotTime_;
    }
    /**
     *
     *
     * <pre>
     * The snapshot time of the table. If not set, interpreted as now.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getSnapshotTimeOrBuilder() {
      return snapshotTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : snapshotTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (snapshotTime_ != null) {
        output.writeMessage(1, getSnapshotTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (snapshotTime_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getSnapshotTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers other =
          (com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers) obj;

      if (hasSnapshotTime() != other.hasSnapshotTime()) return false;
      if (hasSnapshotTime()) {
        if (!getSnapshotTime().equals(other.getSnapshotTime())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasSnapshotTime()) {
        hash = (37 * hash) + SNAPSHOT_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getSnapshotTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Additional attributes when reading a table.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1.ReadSession.TableModifiers}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1.ReadSession.TableModifiers)
        com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiersOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1.StreamProto
            .internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableModifiers_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1.StreamProto
            .internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableModifiers_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.class,
                com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        snapshotTime_ = null;
        if (snapshotTimeBuilder_ != null) {
          snapshotTimeBuilder_.dispose();
          snapshotTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1.StreamProto
            .internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableModifiers_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers build() {
        com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers buildPartial() {
        com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers result =
            new com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.snapshotTime_ =
              snapshotTimeBuilder_ == null ? snapshotTime_ : snapshotTimeBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers) {
          return mergeFrom((com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers other) {
        if (other
            == com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.getDefaultInstance())
          return this;
        if (other.hasSnapshotTime()) {
          mergeSnapshotTime(other.getSnapshotTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getSnapshotTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Timestamp snapshotTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          snapshotTimeBuilder_;
      /**
       *
       *
       * <pre>
       * The snapshot time of the table. If not set, interpreted as now.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       *
       * @return Whether the snapshotTime field is set.
       */
      public boolean hasSnapshotTime() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * The snapshot time of the table. If not set, interpreted as now.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       *
       * @return The snapshotTime.
       */
      public com.google.protobuf.Timestamp getSnapshotTime() {
        if (snapshotTimeBuilder_ == null) {
          return snapshotTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : snapshotTime_;
        } else {
          return snapshotTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The snapshot time of the table. If not set, interpreted as now.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       */
      public Builder setSnapshotTime(com.google.protobuf.Timestamp value) {
        if (snapshotTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          snapshotTime_ = value;
        } else {
          snapshotTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The snapshot time of the table. If not set, interpreted as now.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       */
      public Builder setSnapshotTime(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (snapshotTimeBuilder_ == null) {
          snapshotTime_ = builderForValue.build();
        } else {
          snapshotTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The snapshot time of the table. If not set, interpreted as now.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       */
      public Builder mergeSnapshotTime(com.google.protobuf.Timestamp value) {
        if (snapshotTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && snapshotTime_ != null
              && snapshotTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getSnapshotTimeBuilder().mergeFrom(value);
          } else {
            snapshotTime_ = value;
          }
        } else {
          snapshotTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The snapshot time of the table. If not set, interpreted as now.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       */
      public Builder clearSnapshotTime() {
        bitField0_ = (bitField0_ & ~0x00000001);
        snapshotTime_ = null;
        if (snapshotTimeBuilder_ != null) {
          snapshotTimeBuilder_.dispose();
          snapshotTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The snapshot time of the table. If not set, interpreted as now.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       */
      public com.google.protobuf.Timestamp.Builder getSnapshotTimeBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getSnapshotTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The snapshot time of the table. If not set, interpreted as now.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getSnapshotTimeOrBuilder() {
        if (snapshotTimeBuilder_ != null) {
          return snapshotTimeBuilder_.getMessageOrBuilder();
        } else {
          return snapshotTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : snapshotTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * The snapshot time of the table. If not set, interpreted as now.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp snapshot_time = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getSnapshotTimeFieldBuilder() {
        if (snapshotTimeBuilder_ == null) {
          snapshotTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getSnapshotTime(), getParentForChildren(), isClean());
          snapshotTime_ = null;
        }
        return snapshotTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1.ReadSession.TableModifiers)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1.ReadSession.TableModifiers)
    private static final com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers();
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TableModifiers> PARSER =
        new com.google.protobuf.AbstractParser<TableModifiers>() {
          @java.lang.Override
          public TableModifiers parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TableModifiers> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TableModifiers> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface TableReadOptionsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. The names of the fields in the table to be returned. If no
     * field names are specified, then all fields in the table are returned.
     * Nested fields -- the child elements of a STRUCT field -- can be selected
     * individually using their fully-qualified names, and will be returned as
     * record fields containing only the selected nested fields. If a STRUCT
     * field is specified in the selected fields list, all of the child elements
     * will be returned.
     * As an example, consider a table with the following schema:
     *   {
     *       "name": "struct_field",
     *       "type": "RECORD",
     *       "mode": "NULLABLE",
     *       "fields": [
     *           {
     *               "name": "string_field1",
     *               "type": "STRING",
     * .              "mode": "NULLABLE"
     *           },
     *           {
     *               "name": "string_field2",
     *               "type": "STRING",
     *               "mode": "NULLABLE"
     *           }
     *       ]
     *   }
     * Specifying "struct_field" in the selected fields list will result in a
     * read session schema with the following logical structure:
     *   struct_field {
     *       string_field1
     *       string_field2
     *   }
     * Specifying "struct_field.string_field1" in the selected fields list will
     * result in a read session schema with the following logical structure:
     *   struct_field {
     *       string_field1
     *   }
     * The order of the fields in the read session schema is derived from the
     * table schema and does not correspond to the order in which the fields are
     * specified in this list.
     * </pre>
     *
     * <code>repeated string selected_fields = 1;</code>
     *
     * @return A list containing the selectedFields.
     */
    java.util.List<java.lang.String> getSelectedFieldsList();
    /**
     *
     *
     * <pre>
     * Optional. The names of the fields in the table to be returned. If no
     * field names are specified, then all fields in the table are returned.
     * Nested fields -- the child elements of a STRUCT field -- can be selected
     * individually using their fully-qualified names, and will be returned as
     * record fields containing only the selected nested fields. If a STRUCT
     * field is specified in the selected fields list, all of the child elements
     * will be returned.
     * As an example, consider a table with the following schema:
     *   {
     *       "name": "struct_field",
     *       "type": "RECORD",
     *       "mode": "NULLABLE",
     *       "fields": [
     *           {
     *               "name": "string_field1",
     *               "type": "STRING",
     * .              "mode": "NULLABLE"
     *           },
     *           {
     *               "name": "string_field2",
     *               "type": "STRING",
     *               "mode": "NULLABLE"
     *           }
     *       ]
     *   }
     * Specifying "struct_field" in the selected fields list will result in a
     * read session schema with the following logical structure:
     *   struct_field {
     *       string_field1
     *       string_field2
     *   }
     * Specifying "struct_field.string_field1" in the selected fields list will
     * result in a read session schema with the following logical structure:
     *   struct_field {
     *       string_field1
     *   }
     * The order of the fields in the read session schema is derived from the
     * table schema and does not correspond to the order in which the fields are
     * specified in this list.
     * </pre>
     *
     * <code>repeated string selected_fields = 1;</code>
     *
     * @return The count of selectedFields.
     */
    int getSelectedFieldsCount();
    /**
     *
     *
     * <pre>
     * Optional. The names of the fields in the table to be returned. If no
     * field names are specified, then all fields in the table are returned.
     * Nested fields -- the child elements of a STRUCT field -- can be selected
     * individually using their fully-qualified names, and will be returned as
     * record fields containing only the selected nested fields. If a STRUCT
     * field is specified in the selected fields list, all of the child elements
     * will be returned.
     * As an example, consider a table with the following schema:
     *   {
     *       "name": "struct_field",
     *       "type": "RECORD",
     *       "mode": "NULLABLE",
     *       "fields": [
     *           {
     *               "name": "string_field1",
     *               "type": "STRING",
     * .              "mode": "NULLABLE"
     *           },
     *           {
     *               "name": "string_field2",
     *               "type": "STRING",
     *               "mode": "NULLABLE"
     *           }
     *       ]
     *   }
     * Specifying "struct_field" in the selected fields list will result in a
     * read session schema with the following logical structure:
     *   struct_field {
     *       string_field1
     *       string_field2
     *   }
     * Specifying "struct_field.string_field1" in the selected fields list will
     * result in a read session schema with the following logical structure:
     *   struct_field {
     *       string_field1
     *   }
     * The order of the fields in the read session schema is derived from the
     * table schema and does not correspond to the order in which the fields are
     * specified in this list.
     * </pre>
     *
     * <code>repeated string selected_fields = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The selectedFields at the given index.
     */
    java.lang.String getSelectedFields(int index);
    /**
     *
     *
     * <pre>
     * Optional. The names of the fields in the table to be returned. If no
     * field names are specified, then all fields in the table are returned.
     * Nested fields -- the child elements of a STRUCT field -- can be selected
     * individually using their fully-qualified names, and will be returned as
     * record fields containing only the selected nested fields. If a STRUCT
     * field is specified in the selected fields list, all of the child elements
     * will be returned.
     * As an example, consider a table with the following schema:
     *   {
     *       "name": "struct_field",
     *       "type": "RECORD",
     *       "mode": "NULLABLE",
     *       "fields": [
     *           {
     *               "name": "string_field1",
     *               "type": "STRING",
     * .              "mode": "NULLABLE"
     *           },
     *           {
     *               "name": "string_field2",
     *               "type": "STRING",
     *               "mode": "NULLABLE"
     *           }
     *       ]
     *   }
     * Specifying "struct_field" in the selected fields list will result in a
     * read session schema with the following logical structure:
     *   struct_field {
     *       string_field1
     *       string_field2
     *   }
     * Specifying "struct_field.string_field1" in the selected fields list will
     * result in a read session schema with the following logical structure:
     *   struct_field {
     *       string_field1
     *   }
     * The order of the fields in the read session schema is derived from the
     * table schema and does not correspond to the order in which the fields are
     * specified in this list.
     * </pre>
     *
     * <code>repeated string selected_fields = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the selectedFields at the given index.
     */
    com.google.protobuf.ByteString getSelectedFieldsBytes(int index);

    /**
     *
     *
     * <pre>
     * SQL text filtering statement, similar to a WHERE clause in a query.
     * Aggregates are not supported.
     * Examples: "int_field &gt; 5"
     *           "date_field = CAST('2014-9-27' as DATE)"
     *           "nullable_field is not NULL"
     *           "st_equals(geo_field, st_geofromtext("POINT(2, 2)"))"
     *           "numeric_field BETWEEN 1.0 AND 5.0"
     * Restricted to a maximum length for 1 MB.
     * </pre>
     *
     * <code>string row_restriction = 2;</code>
     *
     * @return The rowRestriction.
     */
    java.lang.String getRowRestriction();
    /**
     *
     *
     * <pre>
     * SQL text filtering statement, similar to a WHERE clause in a query.
     * Aggregates are not supported.
     * Examples: "int_field &gt; 5"
     *           "date_field = CAST('2014-9-27' as DATE)"
     *           "nullable_field is not NULL"
     *           "st_equals(geo_field, st_geofromtext("POINT(2, 2)"))"
     *           "numeric_field BETWEEN 1.0 AND 5.0"
     * Restricted to a maximum length for 1 MB.
     * </pre>
     *
     * <code>string row_restriction = 2;</code>
     *
     * @return The bytes for rowRestriction.
     */
    com.google.protobuf.ByteString getRowRestrictionBytes();

    /**
     *
     *
     * <pre>
     * Optional. Options specific to the Apache Arrow output format.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSerializationOptions arrow_serialization_options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the arrowSerializationOptions field is set.
     */
    boolean hasArrowSerializationOptions();
    /**
     *
     *
     * <pre>
     * Optional. Options specific to the Apache Arrow output format.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSerializationOptions arrow_serialization_options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The arrowSerializationOptions.
     */
    com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions getArrowSerializationOptions();
    /**
     *
     *
     * <pre>
     * Optional. Options specific to the Apache Arrow output format.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSerializationOptions arrow_serialization_options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.bigquery.storage.v1.ArrowSerializationOptionsOrBuilder
        getArrowSerializationOptionsOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Options specific to the Apache Avro output format
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSerializationOptions avro_serialization_options = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the avroSerializationOptions field is set.
     */
    boolean hasAvroSerializationOptions();
    /**
     *
     *
     * <pre>
     * Optional. Options specific to the Apache Avro output format
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSerializationOptions avro_serialization_options = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The avroSerializationOptions.
     */
    com.google.cloud.bigquery.storage.v1.AvroSerializationOptions getAvroSerializationOptions();
    /**
     *
     *
     * <pre>
     * Optional. Options specific to the Apache Avro output format
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSerializationOptions avro_serialization_options = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.bigquery.storage.v1.AvroSerializationOptionsOrBuilder
        getAvroSerializationOptionsOrBuilder();

    public com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions
            .OutputFormatSerializationOptionsCase
        getOutputFormatSerializationOptionsCase();
  }
  /**
   *
   *
   * <pre>
   * Options dictating how we read a table.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions}
   */
  public static final class TableReadOptions extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions)
      TableReadOptionsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TableReadOptions.newBuilder() to construct.
    private TableReadOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TableReadOptions() {
      selectedFields_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      rowRestriction_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TableReadOptions();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1.StreamProto
          .internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableReadOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1.StreamProto
          .internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableReadOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.class,
              com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.Builder.class);
    }

    private int outputFormatSerializationOptionsCase_ = 0;
    private java.lang.Object outputFormatSerializationOptions_;

    public enum OutputFormatSerializationOptionsCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      ARROW_SERIALIZATION_OPTIONS(3),
      AVRO_SERIALIZATION_OPTIONS(4),
      OUTPUTFORMATSERIALIZATIONOPTIONS_NOT_SET(0);
      private final int value;

      private OutputFormatSerializationOptionsCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static OutputFormatSerializationOptionsCase valueOf(int value) {
        return forNumber(value);
      }

      public static OutputFormatSerializationOptionsCase forNumber(int value) {
        switch (value) {
          case 3:
            return ARROW_SERIALIZATION_OPTIONS;
          case 4:
            return AVRO_SERIALIZATION_OPTIONS;
          case 0:
            return OUTPUTFORMATSERIALIZATIONOPTIONS_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public OutputFormatSerializationOptionsCase getOutputFormatSerializationOptionsCase() {
      return OutputFormatSerializationOptionsCase.forNumber(outputFormatSerializationOptionsCase_);
    }

    public static final int SELECTED_FIELDS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringList selectedFields_;
    /**
     *
     *
     * <pre>
     * Optional. The names of the fields in the table to be returned. If no
     * field names are specified, then all fields in the table are returned.
     * Nested fields -- the child elements of a STRUCT field -- can be selected
     * individually using their fully-qualified names, and will be returned as
     * record fields containing only the selected nested fields. If a STRUCT
     * field is specified in the selected fields list, all of the child elements
     * will be returned.
     * As an example, consider a table with the following schema:
     *   {
     *       "name": "struct_field",
     *       "type": "RECORD",
     *       "mode": "NULLABLE",
     *       "fields": [
     *           {
     *               "name": "string_field1",
     *               "type": "STRING",
     * .              "mode": "NULLABLE"
     *           },
     *           {
     *               "name": "string_field2",
     *               "type": "STRING",
     *               "mode": "NULLABLE"
     *           }
     *       ]
     *   }
     * Specifying "struct_field" in the selected fields list will result in a
     * read session schema with the following logical structure:
     *   struct_field {
     *       string_field1
     *       string_field2
     *   }
     * Specifying "struct_field.string_field1" in the selected fields list will
     * result in a read session schema with the following logical structure:
     *   struct_field {
     *       string_field1
     *   }
     * The order of the fields in the read session schema is derived from the
     * table schema and does not correspond to the order in which the fields are
     * specified in this list.
     * </pre>
     *
     * <code>repeated string selected_fields = 1;</code>
     *
     * @return A list containing the selectedFields.
     */
    public com.google.protobuf.ProtocolStringList getSelectedFieldsList() {
      return selectedFields_;
    }
    /**
     *
     *
     * <pre>
     * Optional. The names of the fields in the table to be returned. If no
     * field names are specified, then all fields in the table are returned.
     * Nested fields -- the child elements of a STRUCT field -- can be selected
     * individually using their fully-qualified names, and will be returned as
     * record fields containing only the selected nested fields. If a STRUCT
     * field is specified in the selected fields list, all of the child elements
     * will be returned.
     * As an example, consider a table with the following schema:
     *   {
     *       "name": "struct_field",
     *       "type": "RECORD",
     *       "mode": "NULLABLE",
     *       "fields": [
     *           {
     *               "name": "string_field1",
     *               "type": "STRING",
     * .              "mode": "NULLABLE"
     *           },
     *           {
     *               "name": "string_field2",
     *               "type": "STRING",
     *               "mode": "NULLABLE"
     *           }
     *       ]
     *   }
     * Specifying "struct_field" in the selected fields list will result in a
     * read session schema with the following logical structure:
     *   struct_field {
     *       string_field1
     *       string_field2
     *   }
     * Specifying "struct_field.string_field1" in the selected fields list will
     * result in a read session schema with the following logical structure:
     *   struct_field {
     *       string_field1
     *   }
     * The order of the fields in the read session schema is derived from the
     * table schema and does not correspond to the order in which the fields are
     * specified in this list.
     * </pre>
     *
     * <code>repeated string selected_fields = 1;</code>
     *
     * @return The count of selectedFields.
     */
    public int getSelectedFieldsCount() {
      return selectedFields_.size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The names of the fields in the table to be returned. If no
     * field names are specified, then all fields in the table are returned.
     * Nested fields -- the child elements of a STRUCT field -- can be selected
     * individually using their fully-qualified names, and will be returned as
     * record fields containing only the selected nested fields. If a STRUCT
     * field is specified in the selected fields list, all of the child elements
     * will be returned.
     * As an example, consider a table with the following schema:
     *   {
     *       "name": "struct_field",
     *       "type": "RECORD",
     *       "mode": "NULLABLE",
     *       "fields": [
     *           {
     *               "name": "string_field1",
     *               "type": "STRING",
     * .              "mode": "NULLABLE"
     *           },
     *           {
     *               "name": "string_field2",
     *               "type": "STRING",
     *               "mode": "NULLABLE"
     *           }
     *       ]
     *   }
     * Specifying "struct_field" in the selected fields list will result in a
     * read session schema with the following logical structure:
     *   struct_field {
     *       string_field1
     *       string_field2
     *   }
     * Specifying "struct_field.string_field1" in the selected fields list will
     * result in a read session schema with the following logical structure:
     *   struct_field {
     *       string_field1
     *   }
     * The order of the fields in the read session schema is derived from the
     * table schema and does not correspond to the order in which the fields are
     * specified in this list.
     * </pre>
     *
     * <code>repeated string selected_fields = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The selectedFields at the given index.
     */
    public java.lang.String getSelectedFields(int index) {
      return selectedFields_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Optional. The names of the fields in the table to be returned. If no
     * field names are specified, then all fields in the table are returned.
     * Nested fields -- the child elements of a STRUCT field -- can be selected
     * individually using their fully-qualified names, and will be returned as
     * record fields containing only the selected nested fields. If a STRUCT
     * field is specified in the selected fields list, all of the child elements
     * will be returned.
     * As an example, consider a table with the following schema:
     *   {
     *       "name": "struct_field",
     *       "type": "RECORD",
     *       "mode": "NULLABLE",
     *       "fields": [
     *           {
     *               "name": "string_field1",
     *               "type": "STRING",
     * .              "mode": "NULLABLE"
     *           },
     *           {
     *               "name": "string_field2",
     *               "type": "STRING",
     *               "mode": "NULLABLE"
     *           }
     *       ]
     *   }
     * Specifying "struct_field" in the selected fields list will result in a
     * read session schema with the following logical structure:
     *   struct_field {
     *       string_field1
     *       string_field2
     *   }
     * Specifying "struct_field.string_field1" in the selected fields list will
     * result in a read session schema with the following logical structure:
     *   struct_field {
     *       string_field1
     *   }
     * The order of the fields in the read session schema is derived from the
     * table schema and does not correspond to the order in which the fields are
     * specified in this list.
     * </pre>
     *
     * <code>repeated string selected_fields = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the selectedFields at the given index.
     */
    public com.google.protobuf.ByteString getSelectedFieldsBytes(int index) {
      return selectedFields_.getByteString(index);
    }

    public static final int ROW_RESTRICTION_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object rowRestriction_ = "";
    /**
     *
     *
     * <pre>
     * SQL text filtering statement, similar to a WHERE clause in a query.
     * Aggregates are not supported.
     * Examples: "int_field &gt; 5"
     *           "date_field = CAST('2014-9-27' as DATE)"
     *           "nullable_field is not NULL"
     *           "st_equals(geo_field, st_geofromtext("POINT(2, 2)"))"
     *           "numeric_field BETWEEN 1.0 AND 5.0"
     * Restricted to a maximum length for 1 MB.
     * </pre>
     *
     * <code>string row_restriction = 2;</code>
     *
     * @return The rowRestriction.
     */
    @java.lang.Override
    public java.lang.String getRowRestriction() {
      java.lang.Object ref = rowRestriction_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rowRestriction_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * SQL text filtering statement, similar to a WHERE clause in a query.
     * Aggregates are not supported.
     * Examples: "int_field &gt; 5"
     *           "date_field = CAST('2014-9-27' as DATE)"
     *           "nullable_field is not NULL"
     *           "st_equals(geo_field, st_geofromtext("POINT(2, 2)"))"
     *           "numeric_field BETWEEN 1.0 AND 5.0"
     * Restricted to a maximum length for 1 MB.
     * </pre>
     *
     * <code>string row_restriction = 2;</code>
     *
     * @return The bytes for rowRestriction.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRowRestrictionBytes() {
      java.lang.Object ref = rowRestriction_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rowRestriction_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ARROW_SERIALIZATION_OPTIONS_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * Optional. Options specific to the Apache Arrow output format.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSerializationOptions arrow_serialization_options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the arrowSerializationOptions field is set.
     */
    @java.lang.Override
    public boolean hasArrowSerializationOptions() {
      return outputFormatSerializationOptionsCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Optional. Options specific to the Apache Arrow output format.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSerializationOptions arrow_serialization_options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The arrowSerializationOptions.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions
        getArrowSerializationOptions() {
      if (outputFormatSerializationOptionsCase_ == 3) {
        return (com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions)
            outputFormatSerializationOptions_;
      }
      return com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Optional. Options specific to the Apache Arrow output format.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSerializationOptions arrow_serialization_options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ArrowSerializationOptionsOrBuilder
        getArrowSerializationOptionsOrBuilder() {
      if (outputFormatSerializationOptionsCase_ == 3) {
        return (com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions)
            outputFormatSerializationOptions_;
      }
      return com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions.getDefaultInstance();
    }

    public static final int AVRO_SERIALIZATION_OPTIONS_FIELD_NUMBER = 4;
    /**
     *
     *
     * <pre>
     * Optional. Options specific to the Apache Avro output format
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSerializationOptions avro_serialization_options = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the avroSerializationOptions field is set.
     */
    @java.lang.Override
    public boolean hasAvroSerializationOptions() {
      return outputFormatSerializationOptionsCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Optional. Options specific to the Apache Avro output format
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSerializationOptions avro_serialization_options = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The avroSerializationOptions.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.AvroSerializationOptions
        getAvroSerializationOptions() {
      if (outputFormatSerializationOptionsCase_ == 4) {
        return (com.google.cloud.bigquery.storage.v1.AvroSerializationOptions)
            outputFormatSerializationOptions_;
      }
      return com.google.cloud.bigquery.storage.v1.AvroSerializationOptions.getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * Optional. Options specific to the Apache Avro output format
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSerializationOptions avro_serialization_options = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.AvroSerializationOptionsOrBuilder
        getAvroSerializationOptionsOrBuilder() {
      if (outputFormatSerializationOptionsCase_ == 4) {
        return (com.google.cloud.bigquery.storage.v1.AvroSerializationOptions)
            outputFormatSerializationOptions_;
      }
      return com.google.cloud.bigquery.storage.v1.AvroSerializationOptions.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < selectedFields_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, selectedFields_.getRaw(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rowRestriction_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, rowRestriction_);
      }
      if (outputFormatSerializationOptionsCase_ == 3) {
        output.writeMessage(
            3,
            (com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions)
                outputFormatSerializationOptions_);
      }
      if (outputFormatSerializationOptionsCase_ == 4) {
        output.writeMessage(
            4,
            (com.google.cloud.bigquery.storage.v1.AvroSerializationOptions)
                outputFormatSerializationOptions_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < selectedFields_.size(); i++) {
          dataSize += computeStringSizeNoTag(selectedFields_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getSelectedFieldsList().size();
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rowRestriction_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, rowRestriction_);
      }
      if (outputFormatSerializationOptionsCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3,
                (com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions)
                    outputFormatSerializationOptions_);
      }
      if (outputFormatSerializationOptionsCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4,
                (com.google.cloud.bigquery.storage.v1.AvroSerializationOptions)
                    outputFormatSerializationOptions_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions other =
          (com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions) obj;

      if (!getSelectedFieldsList().equals(other.getSelectedFieldsList())) return false;
      if (!getRowRestriction().equals(other.getRowRestriction())) return false;
      if (!getOutputFormatSerializationOptionsCase()
          .equals(other.getOutputFormatSerializationOptionsCase())) return false;
      switch (outputFormatSerializationOptionsCase_) {
        case 3:
          if (!getArrowSerializationOptions().equals(other.getArrowSerializationOptions()))
            return false;
          break;
        case 4:
          if (!getAvroSerializationOptions().equals(other.getAvroSerializationOptions()))
            return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getSelectedFieldsCount() > 0) {
        hash = (37 * hash) + SELECTED_FIELDS_FIELD_NUMBER;
        hash = (53 * hash) + getSelectedFieldsList().hashCode();
      }
      hash = (37 * hash) + ROW_RESTRICTION_FIELD_NUMBER;
      hash = (53 * hash) + getRowRestriction().hashCode();
      switch (outputFormatSerializationOptionsCase_) {
        case 3:
          hash = (37 * hash) + ARROW_SERIALIZATION_OPTIONS_FIELD_NUMBER;
          hash = (53 * hash) + getArrowSerializationOptions().hashCode();
          break;
        case 4:
          hash = (37 * hash) + AVRO_SERIALIZATION_OPTIONS_FIELD_NUMBER;
          hash = (53 * hash) + getAvroSerializationOptions().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Options dictating how we read a table.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions)
        com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptionsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1.StreamProto
            .internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableReadOptions_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1.StreamProto
            .internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableReadOptions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.class,
                com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.Builder.class);
      }

      // Construct using
      // com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        selectedFields_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        rowRestriction_ = "";
        if (arrowSerializationOptionsBuilder_ != null) {
          arrowSerializationOptionsBuilder_.clear();
        }
        if (avroSerializationOptionsBuilder_ != null) {
          avroSerializationOptionsBuilder_.clear();
        }
        outputFormatSerializationOptionsCase_ = 0;
        outputFormatSerializationOptions_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1.StreamProto
            .internal_static_google_cloud_bigquery_storage_v1_ReadSession_TableReadOptions_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions build() {
        com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions buildPartial() {
        com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions result =
            new com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions result) {
        if (((bitField0_ & 0x00000001) != 0)) {
          selectedFields_ = selectedFields_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.selectedFields_ = selectedFields_;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.rowRestriction_ = rowRestriction_;
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions result) {
        result.outputFormatSerializationOptionsCase_ = outputFormatSerializationOptionsCase_;
        result.outputFormatSerializationOptions_ = this.outputFormatSerializationOptions_;
        if (outputFormatSerializationOptionsCase_ == 3
            && arrowSerializationOptionsBuilder_ != null) {
          result.outputFormatSerializationOptions_ = arrowSerializationOptionsBuilder_.build();
        }
        if (outputFormatSerializationOptionsCase_ == 4
            && avroSerializationOptionsBuilder_ != null) {
          result.outputFormatSerializationOptions_ = avroSerializationOptionsBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions) {
          return mergeFrom(
              (com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions other) {
        if (other
            == com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions
                .getDefaultInstance()) return this;
        if (!other.selectedFields_.isEmpty()) {
          if (selectedFields_.isEmpty()) {
            selectedFields_ = other.selectedFields_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureSelectedFieldsIsMutable();
            selectedFields_.addAll(other.selectedFields_);
          }
          onChanged();
        }
        if (!other.getRowRestriction().isEmpty()) {
          rowRestriction_ = other.rowRestriction_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        switch (other.getOutputFormatSerializationOptionsCase()) {
          case ARROW_SERIALIZATION_OPTIONS:
            {
              mergeArrowSerializationOptions(other.getArrowSerializationOptions());
              break;
            }
          case AVRO_SERIALIZATION_OPTIONS:
            {
              mergeAvroSerializationOptions(other.getAvroSerializationOptions());
              break;
            }
          case OUTPUTFORMATSERIALIZATIONOPTIONS_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureSelectedFieldsIsMutable();
                  selectedFields_.add(s);
                  break;
                } // case 10
              case 18:
                {
                  rowRestriction_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getArrowSerializationOptionsFieldBuilder().getBuilder(), extensionRegistry);
                  outputFormatSerializationOptionsCase_ = 3;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(
                      getAvroSerializationOptionsFieldBuilder().getBuilder(), extensionRegistry);
                  outputFormatSerializationOptionsCase_ = 4;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int outputFormatSerializationOptionsCase_ = 0;
      private java.lang.Object outputFormatSerializationOptions_;

      public OutputFormatSerializationOptionsCase getOutputFormatSerializationOptionsCase() {
        return OutputFormatSerializationOptionsCase.forNumber(
            outputFormatSerializationOptionsCase_);
      }

      public Builder clearOutputFormatSerializationOptions() {
        outputFormatSerializationOptionsCase_ = 0;
        outputFormatSerializationOptions_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringList selectedFields_ =
          com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensureSelectedFieldsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          selectedFields_ = new com.google.protobuf.LazyStringArrayList(selectedFields_);
          bitField0_ |= 0x00000001;
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. The names of the fields in the table to be returned. If no
       * field names are specified, then all fields in the table are returned.
       * Nested fields -- the child elements of a STRUCT field -- can be selected
       * individually using their fully-qualified names, and will be returned as
       * record fields containing only the selected nested fields. If a STRUCT
       * field is specified in the selected fields list, all of the child elements
       * will be returned.
       * As an example, consider a table with the following schema:
       *   {
       *       "name": "struct_field",
       *       "type": "RECORD",
       *       "mode": "NULLABLE",
       *       "fields": [
       *           {
       *               "name": "string_field1",
       *               "type": "STRING",
       * .              "mode": "NULLABLE"
       *           },
       *           {
       *               "name": "string_field2",
       *               "type": "STRING",
       *               "mode": "NULLABLE"
       *           }
       *       ]
       *   }
       * Specifying "struct_field" in the selected fields list will result in a
       * read session schema with the following logical structure:
       *   struct_field {
       *       string_field1
       *       string_field2
       *   }
       * Specifying "struct_field.string_field1" in the selected fields list will
       * result in a read session schema with the following logical structure:
       *   struct_field {
       *       string_field1
       *   }
       * The order of the fields in the read session schema is derived from the
       * table schema and does not correspond to the order in which the fields are
       * specified in this list.
       * </pre>
       *
       * <code>repeated string selected_fields = 1;</code>
       *
       * @return A list containing the selectedFields.
       */
      public com.google.protobuf.ProtocolStringList getSelectedFieldsList() {
        return selectedFields_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * Optional. The names of the fields in the table to be returned. If no
       * field names are specified, then all fields in the table are returned.
       * Nested fields -- the child elements of a STRUCT field -- can be selected
       * individually using their fully-qualified names, and will be returned as
       * record fields containing only the selected nested fields. If a STRUCT
       * field is specified in the selected fields list, all of the child elements
       * will be returned.
       * As an example, consider a table with the following schema:
       *   {
       *       "name": "struct_field",
       *       "type": "RECORD",
       *       "mode": "NULLABLE",
       *       "fields": [
       *           {
       *               "name": "string_field1",
       *               "type": "STRING",
       * .              "mode": "NULLABLE"
       *           },
       *           {
       *               "name": "string_field2",
       *               "type": "STRING",
       *               "mode": "NULLABLE"
       *           }
       *       ]
       *   }
       * Specifying "struct_field" in the selected fields list will result in a
       * read session schema with the following logical structure:
       *   struct_field {
       *       string_field1
       *       string_field2
       *   }
       * Specifying "struct_field.string_field1" in the selected fields list will
       * result in a read session schema with the following logical structure:
       *   struct_field {
       *       string_field1
       *   }
       * The order of the fields in the read session schema is derived from the
       * table schema and does not correspond to the order in which the fields are
       * specified in this list.
       * </pre>
       *
       * <code>repeated string selected_fields = 1;</code>
       *
       * @return The count of selectedFields.
       */
      public int getSelectedFieldsCount() {
        return selectedFields_.size();
      }
      /**
       *
       *
       * <pre>
       * Optional. The names of the fields in the table to be returned. If no
       * field names are specified, then all fields in the table are returned.
       * Nested fields -- the child elements of a STRUCT field -- can be selected
       * individually using their fully-qualified names, and will be returned as
       * record fields containing only the selected nested fields. If a STRUCT
       * field is specified in the selected fields list, all of the child elements
       * will be returned.
       * As an example, consider a table with the following schema:
       *   {
       *       "name": "struct_field",
       *       "type": "RECORD",
       *       "mode": "NULLABLE",
       *       "fields": [
       *           {
       *               "name": "string_field1",
       *               "type": "STRING",
       * .              "mode": "NULLABLE"
       *           },
       *           {
       *               "name": "string_field2",
       *               "type": "STRING",
       *               "mode": "NULLABLE"
       *           }
       *       ]
       *   }
       * Specifying "struct_field" in the selected fields list will result in a
       * read session schema with the following logical structure:
       *   struct_field {
       *       string_field1
       *       string_field2
       *   }
       * Specifying "struct_field.string_field1" in the selected fields list will
       * result in a read session schema with the following logical structure:
       *   struct_field {
       *       string_field1
       *   }
       * The order of the fields in the read session schema is derived from the
       * table schema and does not correspond to the order in which the fields are
       * specified in this list.
       * </pre>
       *
       * <code>repeated string selected_fields = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The selectedFields at the given index.
       */
      public java.lang.String getSelectedFields(int index) {
        return selectedFields_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. The names of the fields in the table to be returned. If no
       * field names are specified, then all fields in the table are returned.
       * Nested fields -- the child elements of a STRUCT field -- can be selected
       * individually using their fully-qualified names, and will be returned as
       * record fields containing only the selected nested fields. If a STRUCT
       * field is specified in the selected fields list, all of the child elements
       * will be returned.
       * As an example, consider a table with the following schema:
       *   {
       *       "name": "struct_field",
       *       "type": "RECORD",
       *       "mode": "NULLABLE",
       *       "fields": [
       *           {
       *               "name": "string_field1",
       *               "type": "STRING",
       * .              "mode": "NULLABLE"
       *           },
       *           {
       *               "name": "string_field2",
       *               "type": "STRING",
       *               "mode": "NULLABLE"
       *           }
       *       ]
       *   }
       * Specifying "struct_field" in the selected fields list will result in a
       * read session schema with the following logical structure:
       *   struct_field {
       *       string_field1
       *       string_field2
       *   }
       * Specifying "struct_field.string_field1" in the selected fields list will
       * result in a read session schema with the following logical structure:
       *   struct_field {
       *       string_field1
       *   }
       * The order of the fields in the read session schema is derived from the
       * table schema and does not correspond to the order in which the fields are
       * specified in this list.
       * </pre>
       *
       * <code>repeated string selected_fields = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the selectedFields at the given index.
       */
      public com.google.protobuf.ByteString getSelectedFieldsBytes(int index) {
        return selectedFields_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Optional. The names of the fields in the table to be returned. If no
       * field names are specified, then all fields in the table are returned.
       * Nested fields -- the child elements of a STRUCT field -- can be selected
       * individually using their fully-qualified names, and will be returned as
       * record fields containing only the selected nested fields. If a STRUCT
       * field is specified in the selected fields list, all of the child elements
       * will be returned.
       * As an example, consider a table with the following schema:
       *   {
       *       "name": "struct_field",
       *       "type": "RECORD",
       *       "mode": "NULLABLE",
       *       "fields": [
       *           {
       *               "name": "string_field1",
       *               "type": "STRING",
       * .              "mode": "NULLABLE"
       *           },
       *           {
       *               "name": "string_field2",
       *               "type": "STRING",
       *               "mode": "NULLABLE"
       *           }
       *       ]
       *   }
       * Specifying "struct_field" in the selected fields list will result in a
       * read session schema with the following logical structure:
       *   struct_field {
       *       string_field1
       *       string_field2
       *   }
       * Specifying "struct_field.string_field1" in the selected fields list will
       * result in a read session schema with the following logical structure:
       *   struct_field {
       *       string_field1
       *   }
       * The order of the fields in the read session schema is derived from the
       * table schema and does not correspond to the order in which the fields are
       * specified in this list.
       * </pre>
       *
       * <code>repeated string selected_fields = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The selectedFields to set.
       * @return This builder for chaining.
       */
      public Builder setSelectedFields(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSelectedFieldsIsMutable();
        selectedFields_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The names of the fields in the table to be returned. If no
       * field names are specified, then all fields in the table are returned.
       * Nested fields -- the child elements of a STRUCT field -- can be selected
       * individually using their fully-qualified names, and will be returned as
       * record fields containing only the selected nested fields. If a STRUCT
       * field is specified in the selected fields list, all of the child elements
       * will be returned.
       * As an example, consider a table with the following schema:
       *   {
       *       "name": "struct_field",
       *       "type": "RECORD",
       *       "mode": "NULLABLE",
       *       "fields": [
       *           {
       *               "name": "string_field1",
       *               "type": "STRING",
       * .              "mode": "NULLABLE"
       *           },
       *           {
       *               "name": "string_field2",
       *               "type": "STRING",
       *               "mode": "NULLABLE"
       *           }
       *       ]
       *   }
       * Specifying "struct_field" in the selected fields list will result in a
       * read session schema with the following logical structure:
       *   struct_field {
       *       string_field1
       *       string_field2
       *   }
       * Specifying "struct_field.string_field1" in the selected fields list will
       * result in a read session schema with the following logical structure:
       *   struct_field {
       *       string_field1
       *   }
       * The order of the fields in the read session schema is derived from the
       * table schema and does not correspond to the order in which the fields are
       * specified in this list.
       * </pre>
       *
       * <code>repeated string selected_fields = 1;</code>
       *
       * @param value The selectedFields to add.
       * @return This builder for chaining.
       */
      public Builder addSelectedFields(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSelectedFieldsIsMutable();
        selectedFields_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The names of the fields in the table to be returned. If no
       * field names are specified, then all fields in the table are returned.
       * Nested fields -- the child elements of a STRUCT field -- can be selected
       * individually using their fully-qualified names, and will be returned as
       * record fields containing only the selected nested fields. If a STRUCT
       * field is specified in the selected fields list, all of the child elements
       * will be returned.
       * As an example, consider a table with the following schema:
       *   {
       *       "name": "struct_field",
       *       "type": "RECORD",
       *       "mode": "NULLABLE",
       *       "fields": [
       *           {
       *               "name": "string_field1",
       *               "type": "STRING",
       * .              "mode": "NULLABLE"
       *           },
       *           {
       *               "name": "string_field2",
       *               "type": "STRING",
       *               "mode": "NULLABLE"
       *           }
       *       ]
       *   }
       * Specifying "struct_field" in the selected fields list will result in a
       * read session schema with the following logical structure:
       *   struct_field {
       *       string_field1
       *       string_field2
       *   }
       * Specifying "struct_field.string_field1" in the selected fields list will
       * result in a read session schema with the following logical structure:
       *   struct_field {
       *       string_field1
       *   }
       * The order of the fields in the read session schema is derived from the
       * table schema and does not correspond to the order in which the fields are
       * specified in this list.
       * </pre>
       *
       * <code>repeated string selected_fields = 1;</code>
       *
       * @param values The selectedFields to add.
       * @return This builder for chaining.
       */
      public Builder addAllSelectedFields(java.lang.Iterable<java.lang.String> values) {
        ensureSelectedFieldsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, selectedFields_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The names of the fields in the table to be returned. If no
       * field names are specified, then all fields in the table are returned.
       * Nested fields -- the child elements of a STRUCT field -- can be selected
       * individually using their fully-qualified names, and will be returned as
       * record fields containing only the selected nested fields. If a STRUCT
       * field is specified in the selected fields list, all of the child elements
       * will be returned.
       * As an example, consider a table with the following schema:
       *   {
       *       "name": "struct_field",
       *       "type": "RECORD",
       *       "mode": "NULLABLE",
       *       "fields": [
       *           {
       *               "name": "string_field1",
       *               "type": "STRING",
       * .              "mode": "NULLABLE"
       *           },
       *           {
       *               "name": "string_field2",
       *               "type": "STRING",
       *               "mode": "NULLABLE"
       *           }
       *       ]
       *   }
       * Specifying "struct_field" in the selected fields list will result in a
       * read session schema with the following logical structure:
       *   struct_field {
       *       string_field1
       *       string_field2
       *   }
       * Specifying "struct_field.string_field1" in the selected fields list will
       * result in a read session schema with the following logical structure:
       *   struct_field {
       *       string_field1
       *   }
       * The order of the fields in the read session schema is derived from the
       * table schema and does not correspond to the order in which the fields are
       * specified in this list.
       * </pre>
       *
       * <code>repeated string selected_fields = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSelectedFields() {
        selectedFields_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. The names of the fields in the table to be returned. If no
       * field names are specified, then all fields in the table are returned.
       * Nested fields -- the child elements of a STRUCT field -- can be selected
       * individually using their fully-qualified names, and will be returned as
       * record fields containing only the selected nested fields. If a STRUCT
       * field is specified in the selected fields list, all of the child elements
       * will be returned.
       * As an example, consider a table with the following schema:
       *   {
       *       "name": "struct_field",
       *       "type": "RECORD",
       *       "mode": "NULLABLE",
       *       "fields": [
       *           {
       *               "name": "string_field1",
       *               "type": "STRING",
       * .              "mode": "NULLABLE"
       *           },
       *           {
       *               "name": "string_field2",
       *               "type": "STRING",
       *               "mode": "NULLABLE"
       *           }
       *       ]
       *   }
       * Specifying "struct_field" in the selected fields list will result in a
       * read session schema with the following logical structure:
       *   struct_field {
       *       string_field1
       *       string_field2
       *   }
       * Specifying "struct_field.string_field1" in the selected fields list will
       * result in a read session schema with the following logical structure:
       *   struct_field {
       *       string_field1
       *   }
       * The order of the fields in the read session schema is derived from the
       * table schema and does not correspond to the order in which the fields are
       * specified in this list.
       * </pre>
       *
       * <code>repeated string selected_fields = 1;</code>
       *
       * @param value The bytes of the selectedFields to add.
       * @return This builder for chaining.
       */
      public Builder addSelectedFieldsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureSelectedFieldsIsMutable();
        selectedFields_.add(value);
        onChanged();
        return this;
      }

      private java.lang.Object rowRestriction_ = "";
      /**
       *
       *
       * <pre>
       * SQL text filtering statement, similar to a WHERE clause in a query.
       * Aggregates are not supported.
       * Examples: "int_field &gt; 5"
       *           "date_field = CAST('2014-9-27' as DATE)"
       *           "nullable_field is not NULL"
       *           "st_equals(geo_field, st_geofromtext("POINT(2, 2)"))"
       *           "numeric_field BETWEEN 1.0 AND 5.0"
       * Restricted to a maximum length for 1 MB.
       * </pre>
       *
       * <code>string row_restriction = 2;</code>
       *
       * @return The rowRestriction.
       */
      public java.lang.String getRowRestriction() {
        java.lang.Object ref = rowRestriction_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          rowRestriction_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * SQL text filtering statement, similar to a WHERE clause in a query.
       * Aggregates are not supported.
       * Examples: "int_field &gt; 5"
       *           "date_field = CAST('2014-9-27' as DATE)"
       *           "nullable_field is not NULL"
       *           "st_equals(geo_field, st_geofromtext("POINT(2, 2)"))"
       *           "numeric_field BETWEEN 1.0 AND 5.0"
       * Restricted to a maximum length for 1 MB.
       * </pre>
       *
       * <code>string row_restriction = 2;</code>
       *
       * @return The bytes for rowRestriction.
       */
      public com.google.protobuf.ByteString getRowRestrictionBytes() {
        java.lang.Object ref = rowRestriction_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          rowRestriction_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * SQL text filtering statement, similar to a WHERE clause in a query.
       * Aggregates are not supported.
       * Examples: "int_field &gt; 5"
       *           "date_field = CAST('2014-9-27' as DATE)"
       *           "nullable_field is not NULL"
       *           "st_equals(geo_field, st_geofromtext("POINT(2, 2)"))"
       *           "numeric_field BETWEEN 1.0 AND 5.0"
       * Restricted to a maximum length for 1 MB.
       * </pre>
       *
       * <code>string row_restriction = 2;</code>
       *
       * @param value The rowRestriction to set.
       * @return This builder for chaining.
       */
      public Builder setRowRestriction(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        rowRestriction_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * SQL text filtering statement, similar to a WHERE clause in a query.
       * Aggregates are not supported.
       * Examples: "int_field &gt; 5"
       *           "date_field = CAST('2014-9-27' as DATE)"
       *           "nullable_field is not NULL"
       *           "st_equals(geo_field, st_geofromtext("POINT(2, 2)"))"
       *           "numeric_field BETWEEN 1.0 AND 5.0"
       * Restricted to a maximum length for 1 MB.
       * </pre>
       *
       * <code>string row_restriction = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRowRestriction() {
        rowRestriction_ = getDefaultInstance().getRowRestriction();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * SQL text filtering statement, similar to a WHERE clause in a query.
       * Aggregates are not supported.
       * Examples: "int_field &gt; 5"
       *           "date_field = CAST('2014-9-27' as DATE)"
       *           "nullable_field is not NULL"
       *           "st_equals(geo_field, st_geofromtext("POINT(2, 2)"))"
       *           "numeric_field BETWEEN 1.0 AND 5.0"
       * Restricted to a maximum length for 1 MB.
       * </pre>
       *
       * <code>string row_restriction = 2;</code>
       *
       * @param value The bytes for rowRestriction to set.
       * @return This builder for chaining.
       */
      public Builder setRowRestrictionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        rowRestriction_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions,
              com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions.Builder,
              com.google.cloud.bigquery.storage.v1.ArrowSerializationOptionsOrBuilder>
          arrowSerializationOptionsBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Options specific to the Apache Arrow output format.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1.ArrowSerializationOptions arrow_serialization_options = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the arrowSerializationOptions field is set.
       */
      @java.lang.Override
      public boolean hasArrowSerializationOptions() {
        return outputFormatSerializationOptionsCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * Optional. Options specific to the Apache Arrow output format.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1.ArrowSerializationOptions arrow_serialization_options = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The arrowSerializationOptions.
       */
      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions
          getArrowSerializationOptions() {
        if (arrowSerializationOptionsBuilder_ == null) {
          if (outputFormatSerializationOptionsCase_ == 3) {
            return (com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions)
                outputFormatSerializationOptions_;
          }
          return com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions
              .getDefaultInstance();
        } else {
          if (outputFormatSerializationOptionsCase_ == 3) {
            return arrowSerializationOptionsBuilder_.getMessage();
          }
          return com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Options specific to the Apache Arrow output format.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1.ArrowSerializationOptions arrow_serialization_options = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setArrowSerializationOptions(
          com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions value) {
        if (arrowSerializationOptionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          outputFormatSerializationOptions_ = value;
          onChanged();
        } else {
          arrowSerializationOptionsBuilder_.setMessage(value);
        }
        outputFormatSerializationOptionsCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Options specific to the Apache Arrow output format.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1.ArrowSerializationOptions arrow_serialization_options = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setArrowSerializationOptions(
          com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions.Builder builderForValue) {
        if (arrowSerializationOptionsBuilder_ == null) {
          outputFormatSerializationOptions_ = builderForValue.build();
          onChanged();
        } else {
          arrowSerializationOptionsBuilder_.setMessage(builderForValue.build());
        }
        outputFormatSerializationOptionsCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Options specific to the Apache Arrow output format.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1.ArrowSerializationOptions arrow_serialization_options = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeArrowSerializationOptions(
          com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions value) {
        if (arrowSerializationOptionsBuilder_ == null) {
          if (outputFormatSerializationOptionsCase_ == 3
              && outputFormatSerializationOptions_
                  != com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions
                      .getDefaultInstance()) {
            outputFormatSerializationOptions_ =
                com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions.newBuilder(
                        (com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions)
                            outputFormatSerializationOptions_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            outputFormatSerializationOptions_ = value;
          }
          onChanged();
        } else {
          if (outputFormatSerializationOptionsCase_ == 3) {
            arrowSerializationOptionsBuilder_.mergeFrom(value);
          } else {
            arrowSerializationOptionsBuilder_.setMessage(value);
          }
        }
        outputFormatSerializationOptionsCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Options specific to the Apache Arrow output format.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1.ArrowSerializationOptions arrow_serialization_options = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearArrowSerializationOptions() {
        if (arrowSerializationOptionsBuilder_ == null) {
          if (outputFormatSerializationOptionsCase_ == 3) {
            outputFormatSerializationOptionsCase_ = 0;
            outputFormatSerializationOptions_ = null;
            onChanged();
          }
        } else {
          if (outputFormatSerializationOptionsCase_ == 3) {
            outputFormatSerializationOptionsCase_ = 0;
            outputFormatSerializationOptions_ = null;
          }
          arrowSerializationOptionsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Options specific to the Apache Arrow output format.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1.ArrowSerializationOptions arrow_serialization_options = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions.Builder
          getArrowSerializationOptionsBuilder() {
        return getArrowSerializationOptionsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Options specific to the Apache Arrow output format.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1.ArrowSerializationOptions arrow_serialization_options = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1.ArrowSerializationOptionsOrBuilder
          getArrowSerializationOptionsOrBuilder() {
        if ((outputFormatSerializationOptionsCase_ == 3)
            && (arrowSerializationOptionsBuilder_ != null)) {
          return arrowSerializationOptionsBuilder_.getMessageOrBuilder();
        } else {
          if (outputFormatSerializationOptionsCase_ == 3) {
            return (com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions)
                outputFormatSerializationOptions_;
          }
          return com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Options specific to the Apache Arrow output format.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1.ArrowSerializationOptions arrow_serialization_options = 3 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions,
              com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions.Builder,
              com.google.cloud.bigquery.storage.v1.ArrowSerializationOptionsOrBuilder>
          getArrowSerializationOptionsFieldBuilder() {
        if (arrowSerializationOptionsBuilder_ == null) {
          if (!(outputFormatSerializationOptionsCase_ == 3)) {
            outputFormatSerializationOptions_ =
                com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions.getDefaultInstance();
          }
          arrowSerializationOptionsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions,
                  com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions.Builder,
                  com.google.cloud.bigquery.storage.v1.ArrowSerializationOptionsOrBuilder>(
                  (com.google.cloud.bigquery.storage.v1.ArrowSerializationOptions)
                      outputFormatSerializationOptions_,
                  getParentForChildren(),
                  isClean());
          outputFormatSerializationOptions_ = null;
        }
        outputFormatSerializationOptionsCase_ = 3;
        onChanged();
        return arrowSerializationOptionsBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1.AvroSerializationOptions,
              com.google.cloud.bigquery.storage.v1.AvroSerializationOptions.Builder,
              com.google.cloud.bigquery.storage.v1.AvroSerializationOptionsOrBuilder>
          avroSerializationOptionsBuilder_;
      /**
       *
       *
       * <pre>
       * Optional. Options specific to the Apache Avro output format
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1.AvroSerializationOptions avro_serialization_options = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the avroSerializationOptions field is set.
       */
      @java.lang.Override
      public boolean hasAvroSerializationOptions() {
        return outputFormatSerializationOptionsCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * Optional. Options specific to the Apache Avro output format
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1.AvroSerializationOptions avro_serialization_options = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The avroSerializationOptions.
       */
      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1.AvroSerializationOptions
          getAvroSerializationOptions() {
        if (avroSerializationOptionsBuilder_ == null) {
          if (outputFormatSerializationOptionsCase_ == 4) {
            return (com.google.cloud.bigquery.storage.v1.AvroSerializationOptions)
                outputFormatSerializationOptions_;
          }
          return com.google.cloud.bigquery.storage.v1.AvroSerializationOptions.getDefaultInstance();
        } else {
          if (outputFormatSerializationOptionsCase_ == 4) {
            return avroSerializationOptionsBuilder_.getMessage();
          }
          return com.google.cloud.bigquery.storage.v1.AvroSerializationOptions.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Options specific to the Apache Avro output format
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1.AvroSerializationOptions avro_serialization_options = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setAvroSerializationOptions(
          com.google.cloud.bigquery.storage.v1.AvroSerializationOptions value) {
        if (avroSerializationOptionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          outputFormatSerializationOptions_ = value;
          onChanged();
        } else {
          avroSerializationOptionsBuilder_.setMessage(value);
        }
        outputFormatSerializationOptionsCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Options specific to the Apache Avro output format
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1.AvroSerializationOptions avro_serialization_options = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setAvroSerializationOptions(
          com.google.cloud.bigquery.storage.v1.AvroSerializationOptions.Builder builderForValue) {
        if (avroSerializationOptionsBuilder_ == null) {
          outputFormatSerializationOptions_ = builderForValue.build();
          onChanged();
        } else {
          avroSerializationOptionsBuilder_.setMessage(builderForValue.build());
        }
        outputFormatSerializationOptionsCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Options specific to the Apache Avro output format
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1.AvroSerializationOptions avro_serialization_options = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeAvroSerializationOptions(
          com.google.cloud.bigquery.storage.v1.AvroSerializationOptions value) {
        if (avroSerializationOptionsBuilder_ == null) {
          if (outputFormatSerializationOptionsCase_ == 4
              && outputFormatSerializationOptions_
                  != com.google.cloud.bigquery.storage.v1.AvroSerializationOptions
                      .getDefaultInstance()) {
            outputFormatSerializationOptions_ =
                com.google.cloud.bigquery.storage.v1.AvroSerializationOptions.newBuilder(
                        (com.google.cloud.bigquery.storage.v1.AvroSerializationOptions)
                            outputFormatSerializationOptions_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            outputFormatSerializationOptions_ = value;
          }
          onChanged();
        } else {
          if (outputFormatSerializationOptionsCase_ == 4) {
            avroSerializationOptionsBuilder_.mergeFrom(value);
          } else {
            avroSerializationOptionsBuilder_.setMessage(value);
          }
        }
        outputFormatSerializationOptionsCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Options specific to the Apache Avro output format
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1.AvroSerializationOptions avro_serialization_options = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearAvroSerializationOptions() {
        if (avroSerializationOptionsBuilder_ == null) {
          if (outputFormatSerializationOptionsCase_ == 4) {
            outputFormatSerializationOptionsCase_ = 0;
            outputFormatSerializationOptions_ = null;
            onChanged();
          }
        } else {
          if (outputFormatSerializationOptionsCase_ == 4) {
            outputFormatSerializationOptionsCase_ = 0;
            outputFormatSerializationOptions_ = null;
          }
          avroSerializationOptionsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Optional. Options specific to the Apache Avro output format
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1.AvroSerializationOptions avro_serialization_options = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.bigquery.storage.v1.AvroSerializationOptions.Builder
          getAvroSerializationOptionsBuilder() {
        return getAvroSerializationOptionsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Optional. Options specific to the Apache Avro output format
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1.AvroSerializationOptions avro_serialization_options = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1.AvroSerializationOptionsOrBuilder
          getAvroSerializationOptionsOrBuilder() {
        if ((outputFormatSerializationOptionsCase_ == 4)
            && (avroSerializationOptionsBuilder_ != null)) {
          return avroSerializationOptionsBuilder_.getMessageOrBuilder();
        } else {
          if (outputFormatSerializationOptionsCase_ == 4) {
            return (com.google.cloud.bigquery.storage.v1.AvroSerializationOptions)
                outputFormatSerializationOptions_;
          }
          return com.google.cloud.bigquery.storage.v1.AvroSerializationOptions.getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * Optional. Options specific to the Apache Avro output format
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1.AvroSerializationOptions avro_serialization_options = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.bigquery.storage.v1.AvroSerializationOptions,
              com.google.cloud.bigquery.storage.v1.AvroSerializationOptions.Builder,
              com.google.cloud.bigquery.storage.v1.AvroSerializationOptionsOrBuilder>
          getAvroSerializationOptionsFieldBuilder() {
        if (avroSerializationOptionsBuilder_ == null) {
          if (!(outputFormatSerializationOptionsCase_ == 4)) {
            outputFormatSerializationOptions_ =
                com.google.cloud.bigquery.storage.v1.AvroSerializationOptions.getDefaultInstance();
          }
          avroSerializationOptionsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.bigquery.storage.v1.AvroSerializationOptions,
                  com.google.cloud.bigquery.storage.v1.AvroSerializationOptions.Builder,
                  com.google.cloud.bigquery.storage.v1.AvroSerializationOptionsOrBuilder>(
                  (com.google.cloud.bigquery.storage.v1.AvroSerializationOptions)
                      outputFormatSerializationOptions_,
                  getParentForChildren(),
                  isClean());
          outputFormatSerializationOptions_ = null;
        }
        outputFormatSerializationOptionsCase_ = 4;
        onChanged();
        return avroSerializationOptionsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions)
    private static final com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions();
    }

    public static com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TableReadOptions> PARSER =
        new com.google.protobuf.AbstractParser<TableReadOptions>() {
          @java.lang.Override
          public TableReadOptions parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TableReadOptions> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TableReadOptions> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int schemaCase_ = 0;
  private java.lang.Object schema_;

  public enum SchemaCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    AVRO_SCHEMA(4),
    ARROW_SCHEMA(5),
    SCHEMA_NOT_SET(0);
    private final int value;

    private SchemaCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SchemaCase valueOf(int value) {
      return forNumber(value);
    }

    public static SchemaCase forNumber(int value) {
      switch (value) {
        case 4:
          return AVRO_SCHEMA;
        case 5:
          return ARROW_SCHEMA;
        case 0:
          return SCHEMA_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SchemaCase getSchemaCase() {
    return SchemaCase.forNumber(schemaCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier for the session, in the form
   * `projects/{project_id}/locations/{location}/sessions/{session_id}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Unique identifier for the session, in the form
   * `projects/{project_id}/locations/{location}/sessions/{session_id}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXPIRE_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp expireTime_;
  /**
   *
   *
   * <pre>
   * Output only. Time at which the session becomes invalid. After this time,
   * subsequent requests to read this Session will return errors. The
   * expire_time is automatically assigned and currently cannot be specified or
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the expireTime field is set.
   */
  @java.lang.Override
  public boolean hasExpireTime() {
    return expireTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the session becomes invalid. After this time,
   * subsequent requests to read this Session will return errors. The
   * expire_time is automatically assigned and currently cannot be specified or
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The expireTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getExpireTime() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Time at which the session becomes invalid. After this time,
   * subsequent requests to read this Session will return errors. The
   * expire_time is automatically assigned and currently cannot be specified or
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }

  public static final int DATA_FORMAT_FIELD_NUMBER = 3;
  private int dataFormat_ = 0;
  /**
   *
   *
   * <pre>
   * Immutable. Data format of the output data. DATA_FORMAT_UNSPECIFIED not
   * supported.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.DataFormat data_format = 3 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for dataFormat.
   */
  @java.lang.Override
  public int getDataFormatValue() {
    return dataFormat_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. Data format of the output data. DATA_FORMAT_UNSPECIFIED not
   * supported.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.DataFormat data_format = 3 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The dataFormat.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.DataFormat getDataFormat() {
    com.google.cloud.bigquery.storage.v1.DataFormat result =
        com.google.cloud.bigquery.storage.v1.DataFormat.forNumber(dataFormat_);
    return result == null ? com.google.cloud.bigquery.storage.v1.DataFormat.UNRECOGNIZED : result;
  }

  public static final int AVRO_SCHEMA_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Output only. Avro schema.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the avroSchema field is set.
   */
  @java.lang.Override
  public boolean hasAvroSchema() {
    return schemaCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Output only. Avro schema.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The avroSchema.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.AvroSchema getAvroSchema() {
    if (schemaCase_ == 4) {
      return (com.google.cloud.bigquery.storage.v1.AvroSchema) schema_;
    }
    return com.google.cloud.bigquery.storage.v1.AvroSchema.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Avro schema.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.AvroSchemaOrBuilder getAvroSchemaOrBuilder() {
    if (schemaCase_ == 4) {
      return (com.google.cloud.bigquery.storage.v1.AvroSchema) schema_;
    }
    return com.google.cloud.bigquery.storage.v1.AvroSchema.getDefaultInstance();
  }

  public static final int ARROW_SCHEMA_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Output only. Arrow schema.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the arrowSchema field is set.
   */
  @java.lang.Override
  public boolean hasArrowSchema() {
    return schemaCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Output only. Arrow schema.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The arrowSchema.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.ArrowSchema getArrowSchema() {
    if (schemaCase_ == 5) {
      return (com.google.cloud.bigquery.storage.v1.ArrowSchema) schema_;
    }
    return com.google.cloud.bigquery.storage.v1.ArrowSchema.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Output only. Arrow schema.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.ArrowSchemaOrBuilder getArrowSchemaOrBuilder() {
    if (schemaCase_ == 5) {
      return (com.google.cloud.bigquery.storage.v1.ArrowSchema) schema_;
    }
    return com.google.cloud.bigquery.storage.v1.ArrowSchema.getDefaultInstance();
  }

  public static final int TABLE_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object table_ = "";
  /**
   *
   *
   * <pre>
   * Immutable. Table that this ReadSession is reading from, in the form
   * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}`
   * </pre>
   *
   * <code>
   * string table = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The table.
   */
  @java.lang.Override
  public java.lang.String getTable() {
    java.lang.Object ref = table_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      table_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Immutable. Table that this ReadSession is reading from, in the form
   * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}`
   * </pre>
   *
   * <code>
   * string table = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for table.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTableBytes() {
    java.lang.Object ref = table_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      table_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TABLE_MODIFIERS_FIELD_NUMBER = 7;
  private com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers tableModifiers_;
  /**
   *
   *
   * <pre>
   * Optional. Any modifiers which are applied when reading from the specified
   * table.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.ReadSession.TableModifiers table_modifiers = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the tableModifiers field is set.
   */
  @java.lang.Override
  public boolean hasTableModifiers() {
    return tableModifiers_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Any modifiers which are applied when reading from the specified
   * table.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.ReadSession.TableModifiers table_modifiers = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The tableModifiers.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers getTableModifiers() {
    return tableModifiers_ == null
        ? com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.getDefaultInstance()
        : tableModifiers_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Any modifiers which are applied when reading from the specified
   * table.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.ReadSession.TableModifiers table_modifiers = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiersOrBuilder
      getTableModifiersOrBuilder() {
    return tableModifiers_ == null
        ? com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.getDefaultInstance()
        : tableModifiers_;
  }

  public static final int READ_OPTIONS_FIELD_NUMBER = 8;
  private com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions readOptions_;
  /**
   *
   *
   * <pre>
   * Optional. Read options for this session (e.g. column selection, filters).
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions read_options = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the readOptions field is set.
   */
  @java.lang.Override
  public boolean hasReadOptions() {
    return readOptions_ != null;
  }
  /**
   *
   *
   * <pre>
   * Optional. Read options for this session (e.g. column selection, filters).
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions read_options = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The readOptions.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions getReadOptions() {
    return readOptions_ == null
        ? com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.getDefaultInstance()
        : readOptions_;
  }
  /**
   *
   *
   * <pre>
   * Optional. Read options for this session (e.g. column selection, filters).
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions read_options = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptionsOrBuilder
      getReadOptionsOrBuilder() {
    return readOptions_ == null
        ? com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.getDefaultInstance()
        : readOptions_;
  }

  public static final int STREAMS_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.bigquery.storage.v1.ReadStream> streams_;
  /**
   *
   *
   * <pre>
   * Output only. A list of streams created with the session.
   * At least one stream is created with the session. In the future, larger
   * request_stream_count values *may* result in this list being unpopulated,
   * in that case, the user will need to use a List method to get the streams
   * instead, which is not yet available.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.bigquery.storage.v1.ReadStream> getStreamsList() {
    return streams_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of streams created with the session.
   * At least one stream is created with the session. In the future, larger
   * request_stream_count values *may* result in this list being unpopulated,
   * in that case, the user will need to use a List method to get the streams
   * instead, which is not yet available.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.bigquery.storage.v1.ReadStreamOrBuilder>
      getStreamsOrBuilderList() {
    return streams_;
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of streams created with the session.
   * At least one stream is created with the session. In the future, larger
   * request_stream_count values *may* result in this list being unpopulated,
   * in that case, the user will need to use a List method to get the streams
   * instead, which is not yet available.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getStreamsCount() {
    return streams_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of streams created with the session.
   * At least one stream is created with the session. In the future, larger
   * request_stream_count values *may* result in this list being unpopulated,
   * in that case, the user will need to use a List method to get the streams
   * instead, which is not yet available.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.ReadStream getStreams(int index) {
    return streams_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. A list of streams created with the session.
   * At least one stream is created with the session. In the future, larger
   * request_stream_count values *may* result in this list being unpopulated,
   * in that case, the user will need to use a List method to get the streams
   * instead, which is not yet available.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.ReadStreamOrBuilder getStreamsOrBuilder(int index) {
    return streams_.get(index);
  }

  public static final int ESTIMATED_TOTAL_BYTES_SCANNED_FIELD_NUMBER = 12;
  private long estimatedTotalBytesScanned_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. An estimate on the number of bytes this session will scan when
   * all streams are completely consumed. This estimate is based on
   * metadata from the table which might be incomplete or stale.
   * </pre>
   *
   * <code>int64 estimated_total_bytes_scanned = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The estimatedTotalBytesScanned.
   */
  @java.lang.Override
  public long getEstimatedTotalBytesScanned() {
    return estimatedTotalBytesScanned_;
  }

  public static final int ESTIMATED_ROW_COUNT_FIELD_NUMBER = 14;
  private long estimatedRowCount_ = 0L;
  /**
   *
   *
   * <pre>
   * Output only. An estimate on the number of rows present in this session's
   * streams. This estimate is based on metadata from the table which might be
   * incomplete or stale.
   * </pre>
   *
   * <code>int64 estimated_row_count = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The estimatedRowCount.
   */
  @java.lang.Override
  public long getEstimatedRowCount() {
    return estimatedRowCount_;
  }

  public static final int TRACE_ID_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object traceId_ = "";
  /**
   *
   *
   * <pre>
   * Optional. ID set by client to annotate a session identity.  This does not
   * need to be strictly unique, but instead the same ID should be used to group
   * logically connected sessions (e.g. All using the same ID for all sessions
   * needed to complete a Spark SQL query is reasonable).
   * Maximum length is 256 bytes.
   * </pre>
   *
   * <code>string trace_id = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The traceId.
   */
  @java.lang.Override
  public java.lang.String getTraceId() {
    java.lang.Object ref = traceId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      traceId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. ID set by client to annotate a session identity.  This does not
   * need to be strictly unique, but instead the same ID should be used to group
   * logically connected sessions (e.g. All using the same ID for all sessions
   * needed to complete a Spark SQL query is reasonable).
   * Maximum length is 256 bytes.
   * </pre>
   *
   * <code>string trace_id = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for traceId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTraceIdBytes() {
    java.lang.Object ref = traceId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      traceId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (expireTime_ != null) {
      output.writeMessage(2, getExpireTime());
    }
    if (dataFormat_
        != com.google.cloud.bigquery.storage.v1.DataFormat.DATA_FORMAT_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, dataFormat_);
    }
    if (schemaCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.bigquery.storage.v1.AvroSchema) schema_);
    }
    if (schemaCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.bigquery.storage.v1.ArrowSchema) schema_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(table_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, table_);
    }
    if (tableModifiers_ != null) {
      output.writeMessage(7, getTableModifiers());
    }
    if (readOptions_ != null) {
      output.writeMessage(8, getReadOptions());
    }
    for (int i = 0; i < streams_.size(); i++) {
      output.writeMessage(10, streams_.get(i));
    }
    if (estimatedTotalBytesScanned_ != 0L) {
      output.writeInt64(12, estimatedTotalBytesScanned_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(traceId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, traceId_);
    }
    if (estimatedRowCount_ != 0L) {
      output.writeInt64(14, estimatedRowCount_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (expireTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getExpireTime());
    }
    if (dataFormat_
        != com.google.cloud.bigquery.storage.v1.DataFormat.DATA_FORMAT_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, dataFormat_);
    }
    if (schemaCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.bigquery.storage.v1.AvroSchema) schema_);
    }
    if (schemaCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.bigquery.storage.v1.ArrowSchema) schema_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(table_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, table_);
    }
    if (tableModifiers_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getTableModifiers());
    }
    if (readOptions_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getReadOptions());
    }
    for (int i = 0; i < streams_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, streams_.get(i));
    }
    if (estimatedTotalBytesScanned_ != 0L) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(12, estimatedTotalBytesScanned_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(traceId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, traceId_);
    }
    if (estimatedRowCount_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(14, estimatedRowCount_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.storage.v1.ReadSession)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.storage.v1.ReadSession other =
        (com.google.cloud.bigquery.storage.v1.ReadSession) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasExpireTime() != other.hasExpireTime()) return false;
    if (hasExpireTime()) {
      if (!getExpireTime().equals(other.getExpireTime())) return false;
    }
    if (dataFormat_ != other.dataFormat_) return false;
    if (!getTable().equals(other.getTable())) return false;
    if (hasTableModifiers() != other.hasTableModifiers()) return false;
    if (hasTableModifiers()) {
      if (!getTableModifiers().equals(other.getTableModifiers())) return false;
    }
    if (hasReadOptions() != other.hasReadOptions()) return false;
    if (hasReadOptions()) {
      if (!getReadOptions().equals(other.getReadOptions())) return false;
    }
    if (!getStreamsList().equals(other.getStreamsList())) return false;
    if (getEstimatedTotalBytesScanned() != other.getEstimatedTotalBytesScanned()) return false;
    if (getEstimatedRowCount() != other.getEstimatedRowCount()) return false;
    if (!getTraceId().equals(other.getTraceId())) return false;
    if (!getSchemaCase().equals(other.getSchemaCase())) return false;
    switch (schemaCase_) {
      case 4:
        if (!getAvroSchema().equals(other.getAvroSchema())) return false;
        break;
      case 5:
        if (!getArrowSchema().equals(other.getArrowSchema())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasExpireTime()) {
      hash = (37 * hash) + EXPIRE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getExpireTime().hashCode();
    }
    hash = (37 * hash) + DATA_FORMAT_FIELD_NUMBER;
    hash = (53 * hash) + dataFormat_;
    hash = (37 * hash) + TABLE_FIELD_NUMBER;
    hash = (53 * hash) + getTable().hashCode();
    if (hasTableModifiers()) {
      hash = (37 * hash) + TABLE_MODIFIERS_FIELD_NUMBER;
      hash = (53 * hash) + getTableModifiers().hashCode();
    }
    if (hasReadOptions()) {
      hash = (37 * hash) + READ_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getReadOptions().hashCode();
    }
    if (getStreamsCount() > 0) {
      hash = (37 * hash) + STREAMS_FIELD_NUMBER;
      hash = (53 * hash) + getStreamsList().hashCode();
    }
    hash = (37 * hash) + ESTIMATED_TOTAL_BYTES_SCANNED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getEstimatedTotalBytesScanned());
    hash = (37 * hash) + ESTIMATED_ROW_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getEstimatedRowCount());
    hash = (37 * hash) + TRACE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getTraceId().hashCode();
    switch (schemaCase_) {
      case 4:
        hash = (37 * hash) + AVRO_SCHEMA_FIELD_NUMBER;
        hash = (53 * hash) + getAvroSchema().hashCode();
        break;
      case 5:
        hash = (37 * hash) + ARROW_SCHEMA_FIELD_NUMBER;
        hash = (53 * hash) + getArrowSchema().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.storage.v1.ReadSession parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadSession parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadSession parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadSession parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadSession parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadSession parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadSession parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadSession parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadSession parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadSession parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadSession parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1.ReadSession parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.bigquery.storage.v1.ReadSession prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Information about the ReadSession.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1.ReadSession}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1.ReadSession)
      com.google.cloud.bigquery.storage.v1.ReadSessionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1.StreamProto
          .internal_static_google_cloud_bigquery_storage_v1_ReadSession_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1.StreamProto
          .internal_static_google_cloud_bigquery_storage_v1_ReadSession_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1.ReadSession.class,
              com.google.cloud.bigquery.storage.v1.ReadSession.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.storage.v1.ReadSession.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      expireTime_ = null;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.dispose();
        expireTimeBuilder_ = null;
      }
      dataFormat_ = 0;
      if (avroSchemaBuilder_ != null) {
        avroSchemaBuilder_.clear();
      }
      if (arrowSchemaBuilder_ != null) {
        arrowSchemaBuilder_.clear();
      }
      table_ = "";
      tableModifiers_ = null;
      if (tableModifiersBuilder_ != null) {
        tableModifiersBuilder_.dispose();
        tableModifiersBuilder_ = null;
      }
      readOptions_ = null;
      if (readOptionsBuilder_ != null) {
        readOptionsBuilder_.dispose();
        readOptionsBuilder_ = null;
      }
      if (streamsBuilder_ == null) {
        streams_ = java.util.Collections.emptyList();
      } else {
        streams_ = null;
        streamsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000100);
      estimatedTotalBytesScanned_ = 0L;
      estimatedRowCount_ = 0L;
      traceId_ = "";
      schemaCase_ = 0;
      schema_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.storage.v1.StreamProto
          .internal_static_google_cloud_bigquery_storage_v1_ReadSession_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ReadSession getDefaultInstanceForType() {
      return com.google.cloud.bigquery.storage.v1.ReadSession.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ReadSession build() {
      com.google.cloud.bigquery.storage.v1.ReadSession result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ReadSession buildPartial() {
      com.google.cloud.bigquery.storage.v1.ReadSession result =
          new com.google.cloud.bigquery.storage.v1.ReadSession(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.bigquery.storage.v1.ReadSession result) {
      if (streamsBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)) {
          streams_ = java.util.Collections.unmodifiableList(streams_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.streams_ = streams_;
      } else {
        result.streams_ = streamsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.bigquery.storage.v1.ReadSession result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.expireTime_ = expireTimeBuilder_ == null ? expireTime_ : expireTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.dataFormat_ = dataFormat_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.table_ = table_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.tableModifiers_ =
            tableModifiersBuilder_ == null ? tableModifiers_ : tableModifiersBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.readOptions_ =
            readOptionsBuilder_ == null ? readOptions_ : readOptionsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.estimatedTotalBytesScanned_ = estimatedTotalBytesScanned_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.estimatedRowCount_ = estimatedRowCount_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.traceId_ = traceId_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.bigquery.storage.v1.ReadSession result) {
      result.schemaCase_ = schemaCase_;
      result.schema_ = this.schema_;
      if (schemaCase_ == 4 && avroSchemaBuilder_ != null) {
        result.schema_ = avroSchemaBuilder_.build();
      }
      if (schemaCase_ == 5 && arrowSchemaBuilder_ != null) {
        result.schema_ = arrowSchemaBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.storage.v1.ReadSession) {
        return mergeFrom((com.google.cloud.bigquery.storage.v1.ReadSession) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.storage.v1.ReadSession other) {
      if (other == com.google.cloud.bigquery.storage.v1.ReadSession.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasExpireTime()) {
        mergeExpireTime(other.getExpireTime());
      }
      if (other.dataFormat_ != 0) {
        setDataFormatValue(other.getDataFormatValue());
      }
      if (!other.getTable().isEmpty()) {
        table_ = other.table_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (other.hasTableModifiers()) {
        mergeTableModifiers(other.getTableModifiers());
      }
      if (other.hasReadOptions()) {
        mergeReadOptions(other.getReadOptions());
      }
      if (streamsBuilder_ == null) {
        if (!other.streams_.isEmpty()) {
          if (streams_.isEmpty()) {
            streams_ = other.streams_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensureStreamsIsMutable();
            streams_.addAll(other.streams_);
          }
          onChanged();
        }
      } else {
        if (!other.streams_.isEmpty()) {
          if (streamsBuilder_.isEmpty()) {
            streamsBuilder_.dispose();
            streamsBuilder_ = null;
            streams_ = other.streams_;
            bitField0_ = (bitField0_ & ~0x00000100);
            streamsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getStreamsFieldBuilder()
                    : null;
          } else {
            streamsBuilder_.addAllMessages(other.streams_);
          }
        }
      }
      if (other.getEstimatedTotalBytesScanned() != 0L) {
        setEstimatedTotalBytesScanned(other.getEstimatedTotalBytesScanned());
      }
      if (other.getEstimatedRowCount() != 0L) {
        setEstimatedRowCount(other.getEstimatedRowCount());
      }
      if (!other.getTraceId().isEmpty()) {
        traceId_ = other.traceId_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      switch (other.getSchemaCase()) {
        case AVRO_SCHEMA:
          {
            mergeAvroSchema(other.getAvroSchema());
            break;
          }
        case ARROW_SCHEMA:
          {
            mergeArrowSchema(other.getArrowSchema());
            break;
          }
        case SCHEMA_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getExpireTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                dataFormat_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(getAvroSchemaFieldBuilder().getBuilder(), extensionRegistry);
                schemaCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getArrowSchemaFieldBuilder().getBuilder(), extensionRegistry);
                schemaCase_ = 5;
                break;
              } // case 42
            case 50:
              {
                table_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getTableModifiersFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getReadOptionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 82:
              {
                com.google.cloud.bigquery.storage.v1.ReadStream m =
                    input.readMessage(
                        com.google.cloud.bigquery.storage.v1.ReadStream.parser(),
                        extensionRegistry);
                if (streamsBuilder_ == null) {
                  ensureStreamsIsMutable();
                  streams_.add(m);
                } else {
                  streamsBuilder_.addMessage(m);
                }
                break;
              } // case 82
            case 96:
              {
                estimatedTotalBytesScanned_ = input.readInt64();
                bitField0_ |= 0x00000200;
                break;
              } // case 96
            case 106:
              {
                traceId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 106
            case 112:
              {
                estimatedRowCount_ = input.readInt64();
                bitField0_ |= 0x00000400;
                break;
              } // case 112
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int schemaCase_ = 0;
    private java.lang.Object schema_;

    public SchemaCase getSchemaCase() {
      return SchemaCase.forNumber(schemaCase_);
    }

    public Builder clearSchema() {
      schemaCase_ = 0;
      schema_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier for the session, in the form
     * `projects/{project_id}/locations/{location}/sessions/{session_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier for the session, in the form
     * `projects/{project_id}/locations/{location}/sessions/{session_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier for the session, in the form
     * `projects/{project_id}/locations/{location}/sessions/{session_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier for the session, in the form
     * `projects/{project_id}/locations/{location}/sessions/{session_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Unique identifier for the session, in the form
     * `projects/{project_id}/locations/{location}/sessions/{session_id}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp expireTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        expireTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Time at which the session becomes invalid. After this time,
     * subsequent requests to read this Session will return errors. The
     * expire_time is automatically assigned and currently cannot be specified or
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the expireTime field is set.
     */
    public boolean hasExpireTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the session becomes invalid. After this time,
     * subsequent requests to read this Session will return errors. The
     * expire_time is automatically assigned and currently cannot be specified or
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The expireTime.
     */
    public com.google.protobuf.Timestamp getExpireTime() {
      if (expireTimeBuilder_ == null) {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      } else {
        return expireTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the session becomes invalid. After this time,
     * subsequent requests to read this Session will return errors. The
     * expire_time is automatically assigned and currently cannot be specified or
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expireTime_ = value;
      } else {
        expireTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the session becomes invalid. After this time,
     * subsequent requests to read this Session will return errors. The
     * expire_time is automatically assigned and currently cannot be specified or
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (expireTimeBuilder_ == null) {
        expireTime_ = builderForValue.build();
      } else {
        expireTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the session becomes invalid. After this time,
     * subsequent requests to read this Session will return errors. The
     * expire_time is automatically assigned and currently cannot be specified or
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && expireTime_ != null
            && expireTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getExpireTimeBuilder().mergeFrom(value);
        } else {
          expireTime_ = value;
        }
      } else {
        expireTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the session becomes invalid. After this time,
     * subsequent requests to read this Session will return errors. The
     * expire_time is automatically assigned and currently cannot be specified or
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearExpireTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      expireTime_ = null;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.dispose();
        expireTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the session becomes invalid. After this time,
     * subsequent requests to read this Session will return errors. The
     * expire_time is automatically assigned and currently cannot be specified or
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getExpireTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getExpireTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the session becomes invalid. After this time,
     * subsequent requests to read this Session will return errors. The
     * expire_time is automatically assigned and currently cannot be specified or
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
      if (expireTimeBuilder_ != null) {
        return expireTimeBuilder_.getMessageOrBuilder();
      } else {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Time at which the session becomes invalid. After this time,
     * subsequent requests to read this Session will return errors. The
     * expire_time is automatically assigned and currently cannot be specified or
     * updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp expire_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getExpireTimeFieldBuilder() {
      if (expireTimeBuilder_ == null) {
        expireTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getExpireTime(), getParentForChildren(), isClean());
        expireTime_ = null;
      }
      return expireTimeBuilder_;
    }

    private int dataFormat_ = 0;
    /**
     *
     *
     * <pre>
     * Immutable. Data format of the output data. DATA_FORMAT_UNSPECIFIED not
     * supported.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.DataFormat data_format = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for dataFormat.
     */
    @java.lang.Override
    public int getDataFormatValue() {
      return dataFormat_;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Data format of the output data. DATA_FORMAT_UNSPECIFIED not
     * supported.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.DataFormat data_format = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for dataFormat to set.
     * @return This builder for chaining.
     */
    public Builder setDataFormatValue(int value) {
      dataFormat_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Data format of the output data. DATA_FORMAT_UNSPECIFIED not
     * supported.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.DataFormat data_format = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The dataFormat.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.DataFormat getDataFormat() {
      com.google.cloud.bigquery.storage.v1.DataFormat result =
          com.google.cloud.bigquery.storage.v1.DataFormat.forNumber(dataFormat_);
      return result == null ? com.google.cloud.bigquery.storage.v1.DataFormat.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Data format of the output data. DATA_FORMAT_UNSPECIFIED not
     * supported.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.DataFormat data_format = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The dataFormat to set.
     * @return This builder for chaining.
     */
    public Builder setDataFormat(com.google.cloud.bigquery.storage.v1.DataFormat value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      dataFormat_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Data format of the output data. DATA_FORMAT_UNSPECIFIED not
     * supported.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.DataFormat data_format = 3 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataFormat() {
      bitField0_ = (bitField0_ & ~0x00000004);
      dataFormat_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.AvroSchema,
            com.google.cloud.bigquery.storage.v1.AvroSchema.Builder,
            com.google.cloud.bigquery.storage.v1.AvroSchemaOrBuilder>
        avroSchemaBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the avroSchema field is set.
     */
    @java.lang.Override
    public boolean hasAvroSchema() {
      return schemaCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The avroSchema.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.AvroSchema getAvroSchema() {
      if (avroSchemaBuilder_ == null) {
        if (schemaCase_ == 4) {
          return (com.google.cloud.bigquery.storage.v1.AvroSchema) schema_;
        }
        return com.google.cloud.bigquery.storage.v1.AvroSchema.getDefaultInstance();
      } else {
        if (schemaCase_ == 4) {
          return avroSchemaBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.storage.v1.AvroSchema.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAvroSchema(com.google.cloud.bigquery.storage.v1.AvroSchema value) {
      if (avroSchemaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        schema_ = value;
        onChanged();
      } else {
        avroSchemaBuilder_.setMessage(value);
      }
      schemaCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAvroSchema(
        com.google.cloud.bigquery.storage.v1.AvroSchema.Builder builderForValue) {
      if (avroSchemaBuilder_ == null) {
        schema_ = builderForValue.build();
        onChanged();
      } else {
        avroSchemaBuilder_.setMessage(builderForValue.build());
      }
      schemaCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeAvroSchema(com.google.cloud.bigquery.storage.v1.AvroSchema value) {
      if (avroSchemaBuilder_ == null) {
        if (schemaCase_ == 4
            && schema_ != com.google.cloud.bigquery.storage.v1.AvroSchema.getDefaultInstance()) {
          schema_ =
              com.google.cloud.bigquery.storage.v1.AvroSchema.newBuilder(
                      (com.google.cloud.bigquery.storage.v1.AvroSchema) schema_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          schema_ = value;
        }
        onChanged();
      } else {
        if (schemaCase_ == 4) {
          avroSchemaBuilder_.mergeFrom(value);
        } else {
          avroSchemaBuilder_.setMessage(value);
        }
      }
      schemaCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearAvroSchema() {
      if (avroSchemaBuilder_ == null) {
        if (schemaCase_ == 4) {
          schemaCase_ = 0;
          schema_ = null;
          onChanged();
        }
      } else {
        if (schemaCase_ == 4) {
          schemaCase_ = 0;
          schema_ = null;
        }
        avroSchemaBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.AvroSchema.Builder getAvroSchemaBuilder() {
      return getAvroSchemaFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.AvroSchemaOrBuilder getAvroSchemaOrBuilder() {
      if ((schemaCase_ == 4) && (avroSchemaBuilder_ != null)) {
        return avroSchemaBuilder_.getMessageOrBuilder();
      } else {
        if (schemaCase_ == 4) {
          return (com.google.cloud.bigquery.storage.v1.AvroSchema) schema_;
        }
        return com.google.cloud.bigquery.storage.v1.AvroSchema.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Avro schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.AvroSchema avro_schema = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.AvroSchema,
            com.google.cloud.bigquery.storage.v1.AvroSchema.Builder,
            com.google.cloud.bigquery.storage.v1.AvroSchemaOrBuilder>
        getAvroSchemaFieldBuilder() {
      if (avroSchemaBuilder_ == null) {
        if (!(schemaCase_ == 4)) {
          schema_ = com.google.cloud.bigquery.storage.v1.AvroSchema.getDefaultInstance();
        }
        avroSchemaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1.AvroSchema,
                com.google.cloud.bigquery.storage.v1.AvroSchema.Builder,
                com.google.cloud.bigquery.storage.v1.AvroSchemaOrBuilder>(
                (com.google.cloud.bigquery.storage.v1.AvroSchema) schema_,
                getParentForChildren(),
                isClean());
        schema_ = null;
      }
      schemaCase_ = 4;
      onChanged();
      return avroSchemaBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.ArrowSchema,
            com.google.cloud.bigquery.storage.v1.ArrowSchema.Builder,
            com.google.cloud.bigquery.storage.v1.ArrowSchemaOrBuilder>
        arrowSchemaBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the arrowSchema field is set.
     */
    @java.lang.Override
    public boolean hasArrowSchema() {
      return schemaCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The arrowSchema.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ArrowSchema getArrowSchema() {
      if (arrowSchemaBuilder_ == null) {
        if (schemaCase_ == 5) {
          return (com.google.cloud.bigquery.storage.v1.ArrowSchema) schema_;
        }
        return com.google.cloud.bigquery.storage.v1.ArrowSchema.getDefaultInstance();
      } else {
        if (schemaCase_ == 5) {
          return arrowSchemaBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.storage.v1.ArrowSchema.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setArrowSchema(com.google.cloud.bigquery.storage.v1.ArrowSchema value) {
      if (arrowSchemaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        schema_ = value;
        onChanged();
      } else {
        arrowSchemaBuilder_.setMessage(value);
      }
      schemaCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setArrowSchema(
        com.google.cloud.bigquery.storage.v1.ArrowSchema.Builder builderForValue) {
      if (arrowSchemaBuilder_ == null) {
        schema_ = builderForValue.build();
        onChanged();
      } else {
        arrowSchemaBuilder_.setMessage(builderForValue.build());
      }
      schemaCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeArrowSchema(com.google.cloud.bigquery.storage.v1.ArrowSchema value) {
      if (arrowSchemaBuilder_ == null) {
        if (schemaCase_ == 5
            && schema_ != com.google.cloud.bigquery.storage.v1.ArrowSchema.getDefaultInstance()) {
          schema_ =
              com.google.cloud.bigquery.storage.v1.ArrowSchema.newBuilder(
                      (com.google.cloud.bigquery.storage.v1.ArrowSchema) schema_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          schema_ = value;
        }
        onChanged();
      } else {
        if (schemaCase_ == 5) {
          arrowSchemaBuilder_.mergeFrom(value);
        } else {
          arrowSchemaBuilder_.setMessage(value);
        }
      }
      schemaCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearArrowSchema() {
      if (arrowSchemaBuilder_ == null) {
        if (schemaCase_ == 5) {
          schemaCase_ = 0;
          schema_ = null;
          onChanged();
        }
      } else {
        if (schemaCase_ == 5) {
          schemaCase_ = 0;
          schema_ = null;
        }
        arrowSchemaBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.ArrowSchema.Builder getArrowSchemaBuilder() {
      return getArrowSchemaFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.ArrowSchemaOrBuilder getArrowSchemaOrBuilder() {
      if ((schemaCase_ == 5) && (arrowSchemaBuilder_ != null)) {
        return arrowSchemaBuilder_.getMessageOrBuilder();
      } else {
        if (schemaCase_ == 5) {
          return (com.google.cloud.bigquery.storage.v1.ArrowSchema) schema_;
        }
        return com.google.cloud.bigquery.storage.v1.ArrowSchema.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Arrow schema.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ArrowSchema arrow_schema = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.ArrowSchema,
            com.google.cloud.bigquery.storage.v1.ArrowSchema.Builder,
            com.google.cloud.bigquery.storage.v1.ArrowSchemaOrBuilder>
        getArrowSchemaFieldBuilder() {
      if (arrowSchemaBuilder_ == null) {
        if (!(schemaCase_ == 5)) {
          schema_ = com.google.cloud.bigquery.storage.v1.ArrowSchema.getDefaultInstance();
        }
        arrowSchemaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1.ArrowSchema,
                com.google.cloud.bigquery.storage.v1.ArrowSchema.Builder,
                com.google.cloud.bigquery.storage.v1.ArrowSchemaOrBuilder>(
                (com.google.cloud.bigquery.storage.v1.ArrowSchema) schema_,
                getParentForChildren(),
                isClean());
        schema_ = null;
      }
      schemaCase_ = 5;
      onChanged();
      return arrowSchemaBuilder_;
    }

    private java.lang.Object table_ = "";
    /**
     *
     *
     * <pre>
     * Immutable. Table that this ReadSession is reading from, in the form
     * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}`
     * </pre>
     *
     * <code>
     * string table = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The table.
     */
    public java.lang.String getTable() {
      java.lang.Object ref = table_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        table_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Table that this ReadSession is reading from, in the form
     * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}`
     * </pre>
     *
     * <code>
     * string table = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for table.
     */
    public com.google.protobuf.ByteString getTableBytes() {
      java.lang.Object ref = table_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        table_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Immutable. Table that this ReadSession is reading from, in the form
     * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}`
     * </pre>
     *
     * <code>
     * string table = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The table to set.
     * @return This builder for chaining.
     */
    public Builder setTable(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      table_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Table that this ReadSession is reading from, in the form
     * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}`
     * </pre>
     *
     * <code>
     * string table = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTable() {
      table_ = getDefaultInstance().getTable();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. Table that this ReadSession is reading from, in the form
     * `projects/{project_id}/datasets/{dataset_id}/tables/{table_id}`
     * </pre>
     *
     * <code>
     * string table = 6 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for table to set.
     * @return This builder for chaining.
     */
    public Builder setTableBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      table_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers tableModifiers_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers,
            com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.Builder,
            com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiersOrBuilder>
        tableModifiersBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Any modifiers which are applied when reading from the specified
     * table.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableModifiers table_modifiers = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the tableModifiers field is set.
     */
    public boolean hasTableModifiers() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Any modifiers which are applied when reading from the specified
     * table.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableModifiers table_modifiers = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The tableModifiers.
     */
    public com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers getTableModifiers() {
      if (tableModifiersBuilder_ == null) {
        return tableModifiers_ == null
            ? com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.getDefaultInstance()
            : tableModifiers_;
      } else {
        return tableModifiersBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Any modifiers which are applied when reading from the specified
     * table.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableModifiers table_modifiers = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTableModifiers(
        com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers value) {
      if (tableModifiersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tableModifiers_ = value;
      } else {
        tableModifiersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Any modifiers which are applied when reading from the specified
     * table.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableModifiers table_modifiers = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTableModifiers(
        com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.Builder builderForValue) {
      if (tableModifiersBuilder_ == null) {
        tableModifiers_ = builderForValue.build();
      } else {
        tableModifiersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Any modifiers which are applied when reading from the specified
     * table.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableModifiers table_modifiers = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeTableModifiers(
        com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers value) {
      if (tableModifiersBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && tableModifiers_ != null
            && tableModifiers_
                != com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers
                    .getDefaultInstance()) {
          getTableModifiersBuilder().mergeFrom(value);
        } else {
          tableModifiers_ = value;
        }
      } else {
        tableModifiersBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Any modifiers which are applied when reading from the specified
     * table.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableModifiers table_modifiers = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearTableModifiers() {
      bitField0_ = (bitField0_ & ~0x00000040);
      tableModifiers_ = null;
      if (tableModifiersBuilder_ != null) {
        tableModifiersBuilder_.dispose();
        tableModifiersBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Any modifiers which are applied when reading from the specified
     * table.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableModifiers table_modifiers = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.Builder
        getTableModifiersBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getTableModifiersFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Any modifiers which are applied when reading from the specified
     * table.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableModifiers table_modifiers = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiersOrBuilder
        getTableModifiersOrBuilder() {
      if (tableModifiersBuilder_ != null) {
        return tableModifiersBuilder_.getMessageOrBuilder();
      } else {
        return tableModifiers_ == null
            ? com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.getDefaultInstance()
            : tableModifiers_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Any modifiers which are applied when reading from the specified
     * table.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableModifiers table_modifiers = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers,
            com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.Builder,
            com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiersOrBuilder>
        getTableModifiersFieldBuilder() {
      if (tableModifiersBuilder_ == null) {
        tableModifiersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers,
                com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiers.Builder,
                com.google.cloud.bigquery.storage.v1.ReadSession.TableModifiersOrBuilder>(
                getTableModifiers(), getParentForChildren(), isClean());
        tableModifiers_ = null;
      }
      return tableModifiersBuilder_;
    }

    private com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions readOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions,
            com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.Builder,
            com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptionsOrBuilder>
        readOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. Read options for this session (e.g. column selection, filters).
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions read_options = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the readOptions field is set.
     */
    public boolean hasReadOptions() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. Read options for this session (e.g. column selection, filters).
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions read_options = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The readOptions.
     */
    public com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions getReadOptions() {
      if (readOptionsBuilder_ == null) {
        return readOptions_ == null
            ? com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.getDefaultInstance()
            : readOptions_;
      } else {
        return readOptionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Read options for this session (e.g. column selection, filters).
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions read_options = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setReadOptions(
        com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions value) {
      if (readOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        readOptions_ = value;
      } else {
        readOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Read options for this session (e.g. column selection, filters).
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions read_options = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setReadOptions(
        com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.Builder builderForValue) {
      if (readOptionsBuilder_ == null) {
        readOptions_ = builderForValue.build();
      } else {
        readOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Read options for this session (e.g. column selection, filters).
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions read_options = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeReadOptions(
        com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions value) {
      if (readOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && readOptions_ != null
            && readOptions_
                != com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions
                    .getDefaultInstance()) {
          getReadOptionsBuilder().mergeFrom(value);
        } else {
          readOptions_ = value;
        }
      } else {
        readOptionsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Read options for this session (e.g. column selection, filters).
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions read_options = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearReadOptions() {
      bitField0_ = (bitField0_ & ~0x00000080);
      readOptions_ = null;
      if (readOptionsBuilder_ != null) {
        readOptionsBuilder_.dispose();
        readOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Read options for this session (e.g. column selection, filters).
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions read_options = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.Builder
        getReadOptionsBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getReadOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. Read options for this session (e.g. column selection, filters).
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions read_options = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptionsOrBuilder
        getReadOptionsOrBuilder() {
      if (readOptionsBuilder_ != null) {
        return readOptionsBuilder_.getMessageOrBuilder();
      } else {
        return readOptions_ == null
            ? com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.getDefaultInstance()
            : readOptions_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. Read options for this session (e.g. column selection, filters).
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions read_options = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions,
            com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.Builder,
            com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptionsOrBuilder>
        getReadOptionsFieldBuilder() {
      if (readOptionsBuilder_ == null) {
        readOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions,
                com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptions.Builder,
                com.google.cloud.bigquery.storage.v1.ReadSession.TableReadOptionsOrBuilder>(
                getReadOptions(), getParentForChildren(), isClean());
        readOptions_ = null;
      }
      return readOptionsBuilder_;
    }

    private java.util.List<com.google.cloud.bigquery.storage.v1.ReadStream> streams_ =
        java.util.Collections.emptyList();

    private void ensureStreamsIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        streams_ =
            new java.util.ArrayList<com.google.cloud.bigquery.storage.v1.ReadStream>(streams_);
        bitField0_ |= 0x00000100;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.ReadStream,
            com.google.cloud.bigquery.storage.v1.ReadStream.Builder,
            com.google.cloud.bigquery.storage.v1.ReadStreamOrBuilder>
        streamsBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.storage.v1.ReadStream> getStreamsList() {
      if (streamsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(streams_);
      } else {
        return streamsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getStreamsCount() {
      if (streamsBuilder_ == null) {
        return streams_.size();
      } else {
        return streamsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.ReadStream getStreams(int index) {
      if (streamsBuilder_ == null) {
        return streams_.get(index);
      } else {
        return streamsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStreams(int index, com.google.cloud.bigquery.storage.v1.ReadStream value) {
      if (streamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStreamsIsMutable();
        streams_.set(index, value);
        onChanged();
      } else {
        streamsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStreams(
        int index, com.google.cloud.bigquery.storage.v1.ReadStream.Builder builderForValue) {
      if (streamsBuilder_ == null) {
        ensureStreamsIsMutable();
        streams_.set(index, builderForValue.build());
        onChanged();
      } else {
        streamsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStreams(com.google.cloud.bigquery.storage.v1.ReadStream value) {
      if (streamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStreamsIsMutable();
        streams_.add(value);
        onChanged();
      } else {
        streamsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStreams(int index, com.google.cloud.bigquery.storage.v1.ReadStream value) {
      if (streamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStreamsIsMutable();
        streams_.add(index, value);
        onChanged();
      } else {
        streamsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStreams(
        com.google.cloud.bigquery.storage.v1.ReadStream.Builder builderForValue) {
      if (streamsBuilder_ == null) {
        ensureStreamsIsMutable();
        streams_.add(builderForValue.build());
        onChanged();
      } else {
        streamsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addStreams(
        int index, com.google.cloud.bigquery.storage.v1.ReadStream.Builder builderForValue) {
      if (streamsBuilder_ == null) {
        ensureStreamsIsMutable();
        streams_.add(index, builderForValue.build());
        onChanged();
      } else {
        streamsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllStreams(
        java.lang.Iterable<? extends com.google.cloud.bigquery.storage.v1.ReadStream> values) {
      if (streamsBuilder_ == null) {
        ensureStreamsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, streams_);
        onChanged();
      } else {
        streamsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStreams() {
      if (streamsBuilder_ == null) {
        streams_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
      } else {
        streamsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeStreams(int index) {
      if (streamsBuilder_ == null) {
        ensureStreamsIsMutable();
        streams_.remove(index);
        onChanged();
      } else {
        streamsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.ReadStream.Builder getStreamsBuilder(int index) {
      return getStreamsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.ReadStreamOrBuilder getStreamsOrBuilder(int index) {
      if (streamsBuilder_ == null) {
        return streams_.get(index);
      } else {
        return streamsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.bigquery.storage.v1.ReadStreamOrBuilder>
        getStreamsOrBuilderList() {
      if (streamsBuilder_ != null) {
        return streamsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(streams_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.ReadStream.Builder addStreamsBuilder() {
      return getStreamsFieldBuilder()
          .addBuilder(com.google.cloud.bigquery.storage.v1.ReadStream.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.ReadStream.Builder addStreamsBuilder(int index) {
      return getStreamsFieldBuilder()
          .addBuilder(index, com.google.cloud.bigquery.storage.v1.ReadStream.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. A list of streams created with the session.
     * At least one stream is created with the session. In the future, larger
     * request_stream_count values *may* result in this list being unpopulated,
     * in that case, the user will need to use a List method to get the streams
     * instead, which is not yet available.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.ReadStream streams = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.storage.v1.ReadStream.Builder>
        getStreamsBuilderList() {
      return getStreamsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.ReadStream,
            com.google.cloud.bigquery.storage.v1.ReadStream.Builder,
            com.google.cloud.bigquery.storage.v1.ReadStreamOrBuilder>
        getStreamsFieldBuilder() {
      if (streamsBuilder_ == null) {
        streamsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1.ReadStream,
                com.google.cloud.bigquery.storage.v1.ReadStream.Builder,
                com.google.cloud.bigquery.storage.v1.ReadStreamOrBuilder>(
                streams_, ((bitField0_ & 0x00000100) != 0), getParentForChildren(), isClean());
        streams_ = null;
      }
      return streamsBuilder_;
    }

    private long estimatedTotalBytesScanned_;
    /**
     *
     *
     * <pre>
     * Output only. An estimate on the number of bytes this session will scan when
     * all streams are completely consumed. This estimate is based on
     * metadata from the table which might be incomplete or stale.
     * </pre>
     *
     * <code>int64 estimated_total_bytes_scanned = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The estimatedTotalBytesScanned.
     */
    @java.lang.Override
    public long getEstimatedTotalBytesScanned() {
      return estimatedTotalBytesScanned_;
    }
    /**
     *
     *
     * <pre>
     * Output only. An estimate on the number of bytes this session will scan when
     * all streams are completely consumed. This estimate is based on
     * metadata from the table which might be incomplete or stale.
     * </pre>
     *
     * <code>int64 estimated_total_bytes_scanned = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The estimatedTotalBytesScanned to set.
     * @return This builder for chaining.
     */
    public Builder setEstimatedTotalBytesScanned(long value) {

      estimatedTotalBytesScanned_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An estimate on the number of bytes this session will scan when
     * all streams are completely consumed. This estimate is based on
     * metadata from the table which might be incomplete or stale.
     * </pre>
     *
     * <code>int64 estimated_total_bytes_scanned = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEstimatedTotalBytesScanned() {
      bitField0_ = (bitField0_ & ~0x00000200);
      estimatedTotalBytesScanned_ = 0L;
      onChanged();
      return this;
    }

    private long estimatedRowCount_;
    /**
     *
     *
     * <pre>
     * Output only. An estimate on the number of rows present in this session's
     * streams. This estimate is based on metadata from the table which might be
     * incomplete or stale.
     * </pre>
     *
     * <code>int64 estimated_row_count = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The estimatedRowCount.
     */
    @java.lang.Override
    public long getEstimatedRowCount() {
      return estimatedRowCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. An estimate on the number of rows present in this session's
     * streams. This estimate is based on metadata from the table which might be
     * incomplete or stale.
     * </pre>
     *
     * <code>int64 estimated_row_count = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The estimatedRowCount to set.
     * @return This builder for chaining.
     */
    public Builder setEstimatedRowCount(long value) {

      estimatedRowCount_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. An estimate on the number of rows present in this session's
     * streams. This estimate is based on metadata from the table which might be
     * incomplete or stale.
     * </pre>
     *
     * <code>int64 estimated_row_count = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEstimatedRowCount() {
      bitField0_ = (bitField0_ & ~0x00000400);
      estimatedRowCount_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object traceId_ = "";
    /**
     *
     *
     * <pre>
     * Optional. ID set by client to annotate a session identity.  This does not
     * need to be strictly unique, but instead the same ID should be used to group
     * logically connected sessions (e.g. All using the same ID for all sessions
     * needed to complete a Spark SQL query is reasonable).
     * Maximum length is 256 bytes.
     * </pre>
     *
     * <code>string trace_id = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The traceId.
     */
    public java.lang.String getTraceId() {
      java.lang.Object ref = traceId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        traceId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. ID set by client to annotate a session identity.  This does not
     * need to be strictly unique, but instead the same ID should be used to group
     * logically connected sessions (e.g. All using the same ID for all sessions
     * needed to complete a Spark SQL query is reasonable).
     * Maximum length is 256 bytes.
     * </pre>
     *
     * <code>string trace_id = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for traceId.
     */
    public com.google.protobuf.ByteString getTraceIdBytes() {
      java.lang.Object ref = traceId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        traceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. ID set by client to annotate a session identity.  This does not
     * need to be strictly unique, but instead the same ID should be used to group
     * logically connected sessions (e.g. All using the same ID for all sessions
     * needed to complete a Spark SQL query is reasonable).
     * Maximum length is 256 bytes.
     * </pre>
     *
     * <code>string trace_id = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The traceId to set.
     * @return This builder for chaining.
     */
    public Builder setTraceId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      traceId_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. ID set by client to annotate a session identity.  This does not
     * need to be strictly unique, but instead the same ID should be used to group
     * logically connected sessions (e.g. All using the same ID for all sessions
     * needed to complete a Spark SQL query is reasonable).
     * Maximum length is 256 bytes.
     * </pre>
     *
     * <code>string trace_id = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTraceId() {
      traceId_ = getDefaultInstance().getTraceId();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. ID set by client to annotate a session identity.  This does not
     * need to be strictly unique, but instead the same ID should be used to group
     * logically connected sessions (e.g. All using the same ID for all sessions
     * needed to complete a Spark SQL query is reasonable).
     * Maximum length is 256 bytes.
     * </pre>
     *
     * <code>string trace_id = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for traceId to set.
     * @return This builder for chaining.
     */
    public Builder setTraceIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      traceId_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1.ReadSession)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1.ReadSession)
  private static final com.google.cloud.bigquery.storage.v1.ReadSession DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1.ReadSession();
  }

  public static com.google.cloud.bigquery.storage.v1.ReadSession getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReadSession> PARSER =
      new com.google.protobuf.AbstractParser<ReadSession>() {
        @java.lang.Override
        public ReadSession parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReadSession> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReadSession> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.ReadSession getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
