/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ReadStreamName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/sessions/{session}/streams/{stream}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String session;
    private final String stream;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSession() {
        return this.session;
    }

    public String getStream() {
        return this.stream;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ReadStreamName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
        this.stream = (String)Preconditions.checkNotNull((Object)builder.getStream());
    }

    public static ReadStreamName of(String project, String location, String session, String stream) {
        return ReadStreamName.newBuilder().setProject(project).setLocation(location).setSession(session).setStream(stream).build();
    }

    public static String format(String project, String location, String session, String stream) {
        return ReadStreamName.newBuilder().setProject(project).setLocation(location).setSession(session).setStream(stream).build().toString();
    }

    public static ReadStreamName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ReadStreamName.parse: formattedString not in valid format");
        return ReadStreamName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("session"), (String)matchMap.get("stream"));
    }

    public static List<ReadStreamName> parseList(List<String> formattedStrings) {
        ArrayList<ReadStreamName> list = new ArrayList<ReadStreamName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ReadStreamName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ReadStreamName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ReadStreamName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ReadStreamName readStreamName = this;
            synchronized (readStreamName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"session", (Object)this.session);
                    fieldMapBuilder.put((Object)"stream", (Object)this.stream);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "session", this.session, "stream", this.stream});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ReadStreamName) {
            ReadStreamName that = (ReadStreamName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.session.equals(that.session) && this.stream.equals(that.stream);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.session.hashCode();
        h *= 1000003;
        return h ^= this.stream.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String session;
        private String stream;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSession() {
            return this.session;
        }

        public String getStream() {
            return this.stream;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSession(String session) {
            this.session = session;
            return this;
        }

        public Builder setStream(String stream) {
            this.stream = stream;
            return this;
        }

        private Builder() {
        }

        private Builder(ReadStreamName readStreamName) {
            this.project = readStreamName.project;
            this.location = readStreamName.location;
            this.session = readStreamName.session;
            this.stream = readStreamName.stream;
        }

        public ReadStreamName build() {
            return new ReadStreamName(this);
        }
    }
}

