/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.reservation.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CapacityCommitmentName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/capacityCommitments/{capacity_commitment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String capacityCommitment;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCapacityCommitment() {
        return this.capacityCommitment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CapacityCommitmentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.capacityCommitment = (String)Preconditions.checkNotNull((Object)builder.getCapacityCommitment());
    }

    public static CapacityCommitmentName of(String project, String location, String capacityCommitment) {
        return CapacityCommitmentName.newBuilder().setProject(project).setLocation(location).setCapacityCommitment(capacityCommitment).build();
    }

    public static String format(String project, String location, String capacityCommitment) {
        return CapacityCommitmentName.newBuilder().setProject(project).setLocation(location).setCapacityCommitment(capacityCommitment).build().toString();
    }

    public static CapacityCommitmentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CapacityCommitmentName.parse: formattedString not in valid format");
        return CapacityCommitmentName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("capacity_commitment"));
    }

    public static List<CapacityCommitmentName> parseList(List<String> formattedStrings) {
        ArrayList<CapacityCommitmentName> list = new ArrayList<CapacityCommitmentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CapacityCommitmentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CapacityCommitmentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CapacityCommitmentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CapacityCommitmentName capacityCommitmentName = this;
            synchronized (capacityCommitmentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"capacityCommitment", (Object)this.capacityCommitment);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "capacity_commitment", this.capacityCommitment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CapacityCommitmentName) {
            CapacityCommitmentName that = (CapacityCommitmentName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.capacityCommitment.equals(that.capacityCommitment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.capacityCommitment.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String capacityCommitment;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCapacityCommitment() {
            return this.capacityCommitment;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCapacityCommitment(String capacityCommitment) {
            this.capacityCommitment = capacityCommitment;
            return this;
        }

        private Builder() {
        }

        private Builder(CapacityCommitmentName capacityCommitmentName) {
            this.project = capacityCommitmentName.project;
            this.location = capacityCommitmentName.location;
            this.capacityCommitment = capacityCommitmentName.capacityCommitment;
        }

        public CapacityCommitmentName build() {
            return new CapacityCommitmentName(this);
        }
    }
}

