/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.migration.v2alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MigrationSubtaskName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_WORKFLOW_SUBTASK = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/workflows/{workflow}/subtasks/{subtask}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String workflow;
    private final String subtask;

    @Deprecated
    protected MigrationSubtaskName() {
        this.project = null;
        this.location = null;
        this.workflow = null;
        this.subtask = null;
    }

    private MigrationSubtaskName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.workflow = (String)Preconditions.checkNotNull((Object)builder.getWorkflow());
        this.subtask = (String)Preconditions.checkNotNull((Object)builder.getSubtask());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getWorkflow() {
        return this.workflow;
    }

    public String getSubtask() {
        return this.subtask;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MigrationSubtaskName of(String project, String location, String workflow, String subtask) {
        return MigrationSubtaskName.newBuilder().setProject(project).setLocation(location).setWorkflow(workflow).setSubtask(subtask).build();
    }

    public static String format(String project, String location, String workflow, String subtask) {
        return MigrationSubtaskName.newBuilder().setProject(project).setLocation(location).setWorkflow(workflow).setSubtask(subtask).build().toString();
    }

    public static MigrationSubtaskName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_WORKFLOW_SUBTASK.validatedMatch(formattedString, "MigrationSubtaskName.parse: formattedString not in valid format");
        return MigrationSubtaskName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("workflow"), (String)matchMap.get("subtask"));
    }

    public static List<MigrationSubtaskName> parseList(List<String> formattedStrings) {
        ArrayList<MigrationSubtaskName> list = new ArrayList<MigrationSubtaskName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MigrationSubtaskName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MigrationSubtaskName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MigrationSubtaskName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_WORKFLOW_SUBTASK.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MigrationSubtaskName migrationSubtaskName = this;
            synchronized (migrationSubtaskName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.workflow != null) {
                        fieldMapBuilder.put((Object)"workflow", (Object)this.workflow);
                    }
                    if (this.subtask != null) {
                        fieldMapBuilder.put((Object)"subtask", (Object)this.subtask);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_WORKFLOW_SUBTASK.instantiate(new String[]{"project", this.project, "location", this.location, "workflow", this.workflow, "subtask", this.subtask});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            MigrationSubtaskName that = (MigrationSubtaskName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.workflow, that.workflow) && Objects.equals(this.subtask, that.subtask);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.workflow);
        h *= 1000003;
        return h ^= Objects.hashCode(this.subtask);
    }

    public static class Builder {
        private String project;
        private String location;
        private String workflow;
        private String subtask;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getWorkflow() {
            return this.workflow;
        }

        public String getSubtask() {
            return this.subtask;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setWorkflow(String workflow) {
            this.workflow = workflow;
            return this;
        }

        public Builder setSubtask(String subtask) {
            this.subtask = subtask;
            return this;
        }

        private Builder(MigrationSubtaskName migrationSubtaskName) {
            this.project = migrationSubtaskName.project;
            this.location = migrationSubtaskName.location;
            this.workflow = migrationSubtaskName.workflow;
            this.subtask = migrationSubtaskName.subtask;
        }

        public MigrationSubtaskName build() {
            return new MigrationSubtaskName(this);
        }
    }
}

