/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.datatransfer.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

public class DataSourceName
implements ResourceName {
    private static final PathTemplate PROJECT_DATA_SOURCE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/dataSources/{data_source}");
    private static final PathTemplate PROJECT_LOCATION_DATA_SOURCE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataSources/{data_source}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String dataSource;
    private final String location;

    @Deprecated
    protected DataSourceName() {
        this.project = null;
        this.dataSource = null;
        this.location = null;
    }

    private DataSourceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.dataSource = (String)Preconditions.checkNotNull((Object)builder.getDataSource());
        this.location = null;
        this.pathTemplate = PROJECT_DATA_SOURCE;
    }

    private DataSourceName(ProjectLocationDataSourceBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataSource = (String)Preconditions.checkNotNull((Object)builder.getDataSource());
        this.pathTemplate = PROJECT_LOCATION_DATA_SOURCE;
    }

    public String getProject() {
        return this.project;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectDataSourceBuilder() {
        return new Builder();
    }

    public static ProjectLocationDataSourceBuilder newProjectLocationDataSourceBuilder() {
        return new ProjectLocationDataSourceBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DataSourceName of(String project, String dataSource) {
        return DataSourceName.newBuilder().setProject(project).setDataSource(dataSource).build();
    }

    public static DataSourceName ofProjectDataSourceName(String project, String dataSource) {
        return DataSourceName.newBuilder().setProject(project).setDataSource(dataSource).build();
    }

    public static DataSourceName ofProjectLocationDataSourceName(String project, String location, String dataSource) {
        return DataSourceName.newProjectLocationDataSourceBuilder().setProject(project).setLocation(location).setDataSource(dataSource).build();
    }

    public static String format(String project, String dataSource) {
        return DataSourceName.newBuilder().setProject(project).setDataSource(dataSource).build().toString();
    }

    public static String formatProjectDataSourceName(String project, String dataSource) {
        return DataSourceName.newBuilder().setProject(project).setDataSource(dataSource).build().toString();
    }

    public static String formatProjectLocationDataSourceName(String project, String location, String dataSource) {
        return DataSourceName.newProjectLocationDataSourceBuilder().setProject(project).setLocation(location).setDataSource(dataSource).build().toString();
    }

    public static DataSourceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_DATA_SOURCE.matches(formattedString)) {
            Map matchMap = PROJECT_DATA_SOURCE.match(formattedString);
            return DataSourceName.ofProjectDataSourceName((String)matchMap.get("project"), (String)matchMap.get("data_source"));
        }
        if (PROJECT_LOCATION_DATA_SOURCE.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_DATA_SOURCE.match(formattedString);
            return DataSourceName.ofProjectLocationDataSourceName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("data_source"));
        }
        throw new ValidationException("DataSourceName.parse: formattedString not in valid format", new Object[0]);
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_DATA_SOURCE.matches(formattedString) || PROJECT_LOCATION_DATA_SOURCE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DataSourceName dataSourceName = this;
            synchronized (dataSourceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.dataSource != null) {
                        fieldMapBuilder.put((Object)"data_source", (Object)this.dataSource);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            DataSourceName that = (DataSourceName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.dataSource, that.dataSource) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataSource);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    public static class ProjectLocationDataSourceBuilder {
        private String project;
        private String location;
        private String dataSource;

        protected ProjectLocationDataSourceBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataSource() {
            return this.dataSource;
        }

        public ProjectLocationDataSourceBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationDataSourceBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationDataSourceBuilder setDataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public DataSourceName build() {
            return new DataSourceName(this);
        }
    }

    public static class Builder {
        private String project;
        private String dataSource;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getDataSource() {
            return this.dataSource;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        private Builder(DataSourceName dataSourceName) {
            Preconditions.checkArgument((boolean)Objects.equals(dataSourceName.pathTemplate, PROJECT_DATA_SOURCE), (Object)"toBuilder is only supported when DataSourceName has the pattern of projects/{project}/dataSources/{data_source}");
            this.project = dataSourceName.project;
            this.dataSource = dataSourceName.dataSource;
        }

        public DataSourceName build() {
            return new DataSourceName(this);
        }
    }
}

