/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/datatransfer/v1/datatransfer.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.bigquery.datatransfer.v1;

/**
 *
 *
 * <pre>
 * A request to get user facing log messages associated with data transfer run.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest}
 */
public final class ListTransferLogsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest)
    ListTransferLogsRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ListTransferLogsRequest.newBuilder() to construct.
  private ListTransferLogsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListTransferLogsRequest() {
    parent_ = "";
    pageToken_ = "";
    messageTypes_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListTransferLogsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
        .internal_static_google_cloud_bigquery_datatransfer_v1_ListTransferLogsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
        .internal_static_google_cloud_bigquery_datatransfer_v1_ListTransferLogsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest.class,
            com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";

  /**
   *
   *
   * <pre>
   * Required. Transfer run name in the form:
   * `projects/{project_id}/transferConfigs/{config_id}/runs/{run_id}` or
   * `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}/runs/{run_id}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Transfer run name in the form:
   * `projects/{project_id}/transferConfigs/{config_id}/runs/{run_id}` or
   * `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}/runs/{run_id}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pageToken_ = "";

  /**
   *
   *
   * <pre>
   * Pagination token, which can be used to request a specific page
   * of `ListTransferLogsRequest` list results. For multiple-page
   * results, `ListTransferLogsResponse` outputs
   * a `next_page` token, which can be used as the
   * `page_token` value to request the next page of list results.
   * </pre>
   *
   * <code>string page_token = 4;</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Pagination token, which can be used to request a specific page
   * of `ListTransferLogsRequest` list results. For multiple-page
   * results, `ListTransferLogsResponse` outputs
   * a `next_page` token, which can be used as the
   * `page_token` value to request the next page of list results.
   * </pre>
   *
   * <code>string page_token = 4;</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAGE_SIZE_FIELD_NUMBER = 5;
  private int pageSize_ = 0;

  /**
   *
   *
   * <pre>
   * Page size. The default page size is the maximum value of 1000 results.
   * </pre>
   *
   * <code>int32 page_size = 5;</code>
   *
   * @return The pageSize.
   */
  @java.lang.Override
  public int getPageSize() {
    return pageSize_;
  }

  public static final int MESSAGE_TYPES_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> messageTypes_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer,
          com.google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity>
      messageTypes_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer,
              com.google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity>() {
            public com.google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity
                convert(java.lang.Integer from) {
              com.google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity result =
                  com.google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity
                      .forNumber(from);
              return result == null
                  ? com.google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity
                      .UNRECOGNIZED
                  : result;
            }
          };

  /**
   *
   *
   * <pre>
   * Message types to return. If not populated - INFO, WARNING and ERROR
   * messages are returned.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity message_types = 6;
   * </code>
   *
   * @return A list containing the messageTypes.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity>
      getMessageTypesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer,
        com.google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity>(
        messageTypes_, messageTypes_converter_);
  }

  /**
   *
   *
   * <pre>
   * Message types to return. If not populated - INFO, WARNING and ERROR
   * messages are returned.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity message_types = 6;
   * </code>
   *
   * @return The count of messageTypes.
   */
  @java.lang.Override
  public int getMessageTypesCount() {
    return messageTypes_.size();
  }

  /**
   *
   *
   * <pre>
   * Message types to return. If not populated - INFO, WARNING and ERROR
   * messages are returned.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity message_types = 6;
   * </code>
   *
   * @param index The index of the element to return.
   * @return The messageTypes at the given index.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity getMessageTypes(
      int index) {
    return messageTypes_converter_.convert(messageTypes_.get(index));
  }

  /**
   *
   *
   * <pre>
   * Message types to return. If not populated - INFO, WARNING and ERROR
   * messages are returned.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity message_types = 6;
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for messageTypes.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getMessageTypesValueList() {
    return messageTypes_;
  }

  /**
   *
   *
   * <pre>
   * Message types to return. If not populated - INFO, WARNING and ERROR
   * messages are returned.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity message_types = 6;
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of messageTypes at the given index.
   */
  @java.lang.Override
  public int getMessageTypesValue(int index) {
    return messageTypes_.get(index);
  }

  private int messageTypesMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, pageToken_);
    }
    if (pageSize_ != 0) {
      output.writeInt32(5, pageSize_);
    }
    if (getMessageTypesList().size() > 0) {
      output.writeUInt32NoTag(50);
      output.writeUInt32NoTag(messageTypesMemoizedSerializedSize);
    }
    for (int i = 0; i < messageTypes_.size(); i++) {
      output.writeEnumNoTag(messageTypes_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, pageToken_);
    }
    if (pageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, pageSize_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < messageTypes_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(messageTypes_.get(i));
      }
      size += dataSize;
      if (!getMessageTypesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      messageTypesMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest other =
        (com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (getPageSize() != other.getPageSize()) return false;
    if (!messageTypes_.equals(other.messageTypes_)) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getPageSize();
    if (getMessageTypesCount() > 0) {
      hash = (37 * hash) + MESSAGE_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + messageTypes_.hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A request to get user facing log messages associated with data transfer run.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest)
      com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_ListTransferLogsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_ListTransferLogsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest.class,
              com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest.Builder.class);
    }

    // Construct using
    // com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      pageToken_ = "";
      pageSize_ = 0;
      messageTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_ListTransferLogsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest
        getDefaultInstanceForType() {
      return com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest build() {
      com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest buildPartial() {
      com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest result =
          new com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest result) {
      if (((bitField0_ & 0x00000008) != 0)) {
        messageTypes_ = java.util.Collections.unmodifiableList(messageTypes_);
        bitField0_ = (bitField0_ & ~0x00000008);
      }
      result.messageTypes_ = messageTypes_;
    }

    private void buildPartial0(
        com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.pageToken_ = pageToken_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.pageSize_ = pageSize_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest) {
        return mergeFrom((com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest other) {
      if (other
          == com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getPageSize() != 0) {
        setPageSize(other.getPageSize());
      }
      if (!other.messageTypes_.isEmpty()) {
        if (messageTypes_.isEmpty()) {
          messageTypes_ = other.messageTypes_;
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          ensureMessageTypesIsMutable();
          messageTypes_.addAll(other.messageTypes_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 34:
              {
                pageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 34
            case 40:
              {
                pageSize_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 40
            case 48:
              {
                int tmpRaw = input.readEnum();
                ensureMessageTypesIsMutable();
                messageTypes_.add(tmpRaw);
                break;
              } // case 48
            case 50:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureMessageTypesIsMutable();
                  messageTypes_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";

    /**
     *
     *
     * <pre>
     * Required. Transfer run name in the form:
     * `projects/{project_id}/transferConfigs/{config_id}/runs/{run_id}` or
     * `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}/runs/{run_id}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Transfer run name in the form:
     * `projects/{project_id}/transferConfigs/{config_id}/runs/{run_id}` or
     * `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}/runs/{run_id}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Transfer run name in the form:
     * `projects/{project_id}/transferConfigs/{config_id}/runs/{run_id}` or
     * `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}/runs/{run_id}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Transfer run name in the form:
     * `projects/{project_id}/transferConfigs/{config_id}/runs/{run_id}` or
     * `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}/runs/{run_id}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Transfer run name in the form:
     * `projects/{project_id}/transferConfigs/{config_id}/runs/{run_id}` or
     * `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}/runs/{run_id}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";

    /**
     *
     *
     * <pre>
     * Pagination token, which can be used to request a specific page
     * of `ListTransferLogsRequest` list results. For multiple-page
     * results, `ListTransferLogsResponse` outputs
     * a `next_page` token, which can be used as the
     * `page_token` value to request the next page of list results.
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Pagination token, which can be used to request a specific page
     * of `ListTransferLogsRequest` list results. For multiple-page
     * results, `ListTransferLogsResponse` outputs
     * a `next_page` token, which can be used as the
     * `page_token` value to request the next page of list results.
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Pagination token, which can be used to request a specific page
     * of `ListTransferLogsRequest` list results. For multiple-page
     * results, `ListTransferLogsResponse` outputs
     * a `next_page` token, which can be used as the
     * `page_token` value to request the next page of list results.
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Pagination token, which can be used to request a specific page
     * of `ListTransferLogsRequest` list results. For multiple-page
     * results, `ListTransferLogsResponse` outputs
     * a `next_page` token, which can be used as the
     * `page_token` value to request the next page of list results.
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {
      pageToken_ = getDefaultInstance().getPageToken();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Pagination token, which can be used to request a specific page
     * of `ListTransferLogsRequest` list results. For multiple-page
     * results, `ListTransferLogsResponse` outputs
     * a `next_page` token, which can be used as the
     * `page_token` value to request the next page of list results.
     * </pre>
     *
     * <code>string page_token = 4;</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int pageSize_;

    /**
     *
     *
     * <pre>
     * Page size. The default page size is the maximum value of 1000 results.
     * </pre>
     *
     * <code>int32 page_size = 5;</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }

    /**
     *
     *
     * <pre>
     * Page size. The default page size is the maximum value of 1000 results.
     * </pre>
     *
     * <code>int32 page_size = 5;</code>
     *
     * @param value The pageSize to set.
     * @return This builder for chaining.
     */
    public Builder setPageSize(int value) {

      pageSize_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Page size. The default page size is the maximum value of 1000 results.
     * </pre>
     *
     * <code>int32 page_size = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageSize() {
      bitField0_ = (bitField0_ & ~0x00000004);
      pageSize_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> messageTypes_ = java.util.Collections.emptyList();

    private void ensureMessageTypesIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        messageTypes_ = new java.util.ArrayList<java.lang.Integer>(messageTypes_);
        bitField0_ |= 0x00000008;
      }
    }

    /**
     *
     *
     * <pre>
     * Message types to return. If not populated - INFO, WARNING and ERROR
     * messages are returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity message_types = 6;
     * </code>
     *
     * @return A list containing the messageTypes.
     */
    public java.util.List<com.google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity>
        getMessageTypesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer,
          com.google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity>(
          messageTypes_, messageTypes_converter_);
    }

    /**
     *
     *
     * <pre>
     * Message types to return. If not populated - INFO, WARNING and ERROR
     * messages are returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity message_types = 6;
     * </code>
     *
     * @return The count of messageTypes.
     */
    public int getMessageTypesCount() {
      return messageTypes_.size();
    }

    /**
     *
     *
     * <pre>
     * Message types to return. If not populated - INFO, WARNING and ERROR
     * messages are returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity message_types = 6;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The messageTypes at the given index.
     */
    public com.google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity
        getMessageTypes(int index) {
      return messageTypes_converter_.convert(messageTypes_.get(index));
    }

    /**
     *
     *
     * <pre>
     * Message types to return. If not populated - INFO, WARNING and ERROR
     * messages are returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity message_types = 6;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The messageTypes to set.
     * @return This builder for chaining.
     */
    public Builder setMessageTypes(
        int index,
        com.google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMessageTypesIsMutable();
      messageTypes_.set(index, value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Message types to return. If not populated - INFO, WARNING and ERROR
     * messages are returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity message_types = 6;
     * </code>
     *
     * @param value The messageTypes to add.
     * @return This builder for chaining.
     */
    public Builder addMessageTypes(
        com.google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureMessageTypesIsMutable();
      messageTypes_.add(value.getNumber());
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Message types to return. If not populated - INFO, WARNING and ERROR
     * messages are returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity message_types = 6;
     * </code>
     *
     * @param values The messageTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllMessageTypes(
        java.lang.Iterable<
                ? extends com.google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity>
            values) {
      ensureMessageTypesIsMutable();
      for (com.google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity value :
          values) {
        messageTypes_.add(value.getNumber());
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Message types to return. If not populated - INFO, WARNING and ERROR
     * messages are returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity message_types = 6;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMessageTypes() {
      messageTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Message types to return. If not populated - INFO, WARNING and ERROR
     * messages are returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity message_types = 6;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for messageTypes.
     */
    public java.util.List<java.lang.Integer> getMessageTypesValueList() {
      return java.util.Collections.unmodifiableList(messageTypes_);
    }

    /**
     *
     *
     * <pre>
     * Message types to return. If not populated - INFO, WARNING and ERROR
     * messages are returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity message_types = 6;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of messageTypes at the given index.
     */
    public int getMessageTypesValue(int index) {
      return messageTypes_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Message types to return. If not populated - INFO, WARNING and ERROR
     * messages are returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity message_types = 6;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for messageTypes to set.
     * @return This builder for chaining.
     */
    public Builder setMessageTypesValue(int index, int value) {
      ensureMessageTypesIsMutable();
      messageTypes_.set(index, value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Message types to return. If not populated - INFO, WARNING and ERROR
     * messages are returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity message_types = 6;
     * </code>
     *
     * @param value The enum numeric value on the wire for messageTypes to add.
     * @return This builder for chaining.
     */
    public Builder addMessageTypesValue(int value) {
      ensureMessageTypesIsMutable();
      messageTypes_.add(value);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Message types to return. If not populated - INFO, WARNING and ERROR
     * messages are returned.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity message_types = 6;
     * </code>
     *
     * @param values The enum numeric values on the wire for messageTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllMessageTypesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureMessageTypesIsMutable();
      for (int value : values) {
        messageTypes_.add(value);
      }
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest)
  private static final com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest();
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListTransferLogsRequest> PARSER =
      new com.google.protobuf.AbstractParser<ListTransferLogsRequest>() {
        @java.lang.Override
        public ListTransferLogsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListTransferLogsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListTransferLogsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
