/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.datatransfer.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceNameType;
import com.google.cloud.bigquery.datatransfer.v1.DataSourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LocationDataSourceName
extends DataSourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataSources/{data_source}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String dataSource;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private LocationDataSourceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataSource = (String)Preconditions.checkNotNull((Object)builder.getDataSource());
    }

    public static LocationDataSourceName of(String project, String location, String dataSource) {
        return LocationDataSourceName.newBuilder().setProject(project).setLocation(location).setDataSource(dataSource).build();
    }

    public static String format(String project, String location, String dataSource) {
        return LocationDataSourceName.newBuilder().setProject(project).setLocation(location).setDataSource(dataSource).build().toString();
    }

    public static LocationDataSourceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "LocationDataSourceName.parse: formattedString not in valid format");
        return LocationDataSourceName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("data_source"));
    }

    public static List<LocationDataSourceName> parseList(List<String> formattedStrings) {
        ArrayList<LocationDataSourceName> list = new ArrayList<LocationDataSourceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LocationDataSourceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LocationDataSourceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LocationDataSourceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LocationDataSourceName locationDataSourceName = this;
            synchronized (locationDataSourceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"dataSource", (Object)this.dataSource);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    @Deprecated
    public ResourceNameType getType() {
        throw new UnsupportedOperationException("LocationDataSourceName.getType() not supported");
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "data_source", this.dataSource});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LocationDataSourceName) {
            LocationDataSourceName that = (LocationDataSourceName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.dataSource.equals(that.dataSource);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.dataSource.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataSource;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataSource() {
            return this.dataSource;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        private Builder() {
        }

        private Builder(LocationDataSourceName locationDataSourceName) {
            this.project = locationDataSourceName.project;
            this.location = locationDataSourceName.location;
            this.dataSource = locationDataSourceName.dataSource;
        }

        public LocationDataSourceName build() {
            return new LocationDataSourceName(this);
        }
    }
}

