/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.datatransfer.v1;

import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.cloud.bigquery.datatransfer.v1.TransferConfigName;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;

public class UntypedTransferConfigName
extends TransferConfigName {
    private final String rawValue;

    private UntypedTransferConfigName(String rawValue) {
        this.rawValue = (String)Preconditions.checkNotNull((Object)rawValue);
    }

    public static UntypedTransferConfigName from(ResourceName resourceName) {
        return new UntypedTransferConfigName(resourceName.toString());
    }

    public static UntypedTransferConfigName parse(String formattedString) {
        return new UntypedTransferConfigName(formattedString);
    }

    public static List<UntypedTransferConfigName> parseList(List<String> formattedStrings) {
        ArrayList<UntypedTransferConfigName> list = new ArrayList<UntypedTransferConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(UntypedTransferConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<UntypedTransferConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (UntypedTransferConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return true;
    }

    @Deprecated
    public ResourceNameType getType() {
        throw new UnsupportedOperationException("UntypedTransferConfigName.getType() not supported");
    }

    public String toString() {
        return this.rawValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof UntypedTransferConfigName) {
            UntypedTransferConfigName that = (UntypedTransferConfigName)o;
            return this.rawValue.equals(that.rawValue);
        }
        return false;
    }

    public int hashCode() {
        return this.rawValue.hashCode();
    }
}

