/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.datapolicies.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataPolicyName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATA_POLICY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/dataPolicies/{data_policy}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String dataPolicy;

    @Deprecated
    protected DataPolicyName() {
        this.project = null;
        this.location = null;
        this.dataPolicy = null;
    }

    private DataPolicyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataPolicy = (String)Preconditions.checkNotNull((Object)builder.getDataPolicy());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataPolicy() {
        return this.dataPolicy;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DataPolicyName of(String project, String location, String dataPolicy) {
        return DataPolicyName.newBuilder().setProject(project).setLocation(location).setDataPolicy(dataPolicy).build();
    }

    public static String format(String project, String location, String dataPolicy) {
        return DataPolicyName.newBuilder().setProject(project).setLocation(location).setDataPolicy(dataPolicy).build().toString();
    }

    public static DataPolicyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DATA_POLICY.validatedMatch(formattedString, "DataPolicyName.parse: formattedString not in valid format");
        return DataPolicyName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("data_policy"));
    }

    public static List<DataPolicyName> parseList(List<String> formattedStrings) {
        ArrayList<DataPolicyName> list = new ArrayList<DataPolicyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DataPolicyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DataPolicyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DataPolicyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATA_POLICY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DataPolicyName dataPolicyName = this;
            synchronized (dataPolicyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataPolicy != null) {
                        fieldMapBuilder.put((Object)"data_policy", (Object)this.dataPolicy);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DATA_POLICY.instantiate(new String[]{"project", this.project, "location", this.location, "data_policy", this.dataPolicy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            DataPolicyName that = (DataPolicyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataPolicy, that.dataPolicy);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.dataPolicy);
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataPolicy;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataPolicy() {
            return this.dataPolicy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataPolicy(String dataPolicy) {
            this.dataPolicy = dataPolicy;
            return this;
        }

        private Builder(DataPolicyName dataPolicyName) {
            this.project = dataPolicyName.project;
            this.location = dataPolicyName.location;
            this.dataPolicy = dataPolicyName.dataPolicy;
        }

        public DataPolicyName build() {
            return new DataPolicyName(this);
        }
    }
}

