/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.biglake.v1alpha1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DatabaseName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_CATALOG_DATABASE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/catalogs/{catalog}/databases/{database}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String catalog;
    private final String database;

    @Deprecated
    protected DatabaseName() {
        this.project = null;
        this.location = null;
        this.catalog = null;
        this.database = null;
    }

    private DatabaseName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.catalog = (String)Preconditions.checkNotNull((Object)builder.getCatalog());
        this.database = (String)Preconditions.checkNotNull((Object)builder.getDatabase());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getDatabase() {
        return this.database;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DatabaseName of(String project, String location, String catalog, String database) {
        return DatabaseName.newBuilder().setProject(project).setLocation(location).setCatalog(catalog).setDatabase(database).build();
    }

    public static String format(String project, String location, String catalog, String database) {
        return DatabaseName.newBuilder().setProject(project).setLocation(location).setCatalog(catalog).setDatabase(database).build().toString();
    }

    public static DatabaseName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_CATALOG_DATABASE.validatedMatch(formattedString, "DatabaseName.parse: formattedString not in valid format");
        return DatabaseName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("catalog"), (String)matchMap.get("database"));
    }

    public static List<DatabaseName> parseList(List<String> formattedStrings) {
        ArrayList<DatabaseName> list = new ArrayList<DatabaseName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DatabaseName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DatabaseName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DatabaseName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_CATALOG_DATABASE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DatabaseName databaseName = this;
            synchronized (databaseName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.catalog != null) {
                        fieldMapBuilder.put((Object)"catalog", (Object)this.catalog);
                    }
                    if (this.database != null) {
                        fieldMapBuilder.put((Object)"database", (Object)this.database);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_CATALOG_DATABASE.instantiate(new String[]{"project", this.project, "location", this.location, "catalog", this.catalog, "database", this.database});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            DatabaseName that = (DatabaseName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.catalog, that.catalog) && Objects.equals(this.database, that.database);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.catalog);
        h *= 1000003;
        return h ^= Objects.hashCode(this.database);
    }

    public static class Builder {
        private String project;
        private String location;
        private String catalog;
        private String database;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public String getDatabase() {
            return this.database;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCatalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public Builder setDatabase(String database) {
            this.database = database;
            return this;
        }

        private Builder(DatabaseName databaseName) {
            this.project = databaseName.project;
            this.location = databaseName.location;
            this.catalog = databaseName.catalog;
            this.database = databaseName.database;
        }

        public DatabaseName build() {
            return new DatabaseName(this);
        }
    }
}

