/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.biglake.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CatalogName
implements ResourceName {
    private static final PathTemplate PROJECT_CATALOG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/catalogs/{catalog}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String catalog;

    @Deprecated
    protected CatalogName() {
        this.project = null;
        this.catalog = null;
    }

    private CatalogName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.catalog = (String)Preconditions.checkNotNull((Object)builder.getCatalog());
    }

    public String getProject() {
        return this.project;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CatalogName of(String project, String catalog) {
        return CatalogName.newBuilder().setProject(project).setCatalog(catalog).build();
    }

    public static String format(String project, String catalog) {
        return CatalogName.newBuilder().setProject(project).setCatalog(catalog).build().toString();
    }

    public static CatalogName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_CATALOG.validatedMatch(formattedString, "CatalogName.parse: formattedString not in valid format");
        return CatalogName.of((String)matchMap.get("project"), (String)matchMap.get("catalog"));
    }

    public static List<CatalogName> parseList(List<String> formattedStrings) {
        ArrayList<CatalogName> list = new ArrayList<CatalogName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CatalogName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CatalogName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CatalogName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_CATALOG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CatalogName catalogName = this;
            synchronized (catalogName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.catalog != null) {
                        fieldMapBuilder.put((Object)"catalog", (Object)this.catalog);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_CATALOG.instantiate(new String[]{"project", this.project, "catalog", this.catalog});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CatalogName that = (CatalogName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.catalog, that.catalog);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        return h ^= Objects.hashCode(this.catalog);
    }

    public static class Builder {
        private String project;
        private String catalog;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getCatalog() {
            return this.catalog;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setCatalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        private Builder(CatalogName catalogName) {
            this.project = catalogName.project;
            this.catalog = catalogName.catalog;
        }

        public CatalogName build() {
            return new CatalogName(this);
        }
    }
}

