/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.batch.v1alpha;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TaskName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_JOB_TASK_GROUP_TASK = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/jobs/{job}/taskGroups/{task_group}/tasks/{task}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String job;
    private final String taskGroup;
    private final String task;

    @Deprecated
    protected TaskName() {
        this.project = null;
        this.location = null;
        this.job = null;
        this.taskGroup = null;
        this.task = null;
    }

    private TaskName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.job = (String)Preconditions.checkNotNull((Object)builder.getJob());
        this.taskGroup = (String)Preconditions.checkNotNull((Object)builder.getTaskGroup());
        this.task = (String)Preconditions.checkNotNull((Object)builder.getTask());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getJob() {
        return this.job;
    }

    public String getTaskGroup() {
        return this.taskGroup;
    }

    public String getTask() {
        return this.task;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TaskName of(String project, String location, String job, String taskGroup, String task) {
        return TaskName.newBuilder().setProject(project).setLocation(location).setJob(job).setTaskGroup(taskGroup).setTask(task).build();
    }

    public static String format(String project, String location, String job, String taskGroup, String task) {
        return TaskName.newBuilder().setProject(project).setLocation(location).setJob(job).setTaskGroup(taskGroup).setTask(task).build().toString();
    }

    public static TaskName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_JOB_TASK_GROUP_TASK.validatedMatch(formattedString, "TaskName.parse: formattedString not in valid format");
        return TaskName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("job"), (String)matchMap.get("task_group"), (String)matchMap.get("task"));
    }

    public static List<TaskName> parseList(List<String> formattedStrings) {
        ArrayList<TaskName> list = new ArrayList<TaskName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TaskName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TaskName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TaskName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_JOB_TASK_GROUP_TASK.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TaskName taskName = this;
            synchronized (taskName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.job != null) {
                        fieldMapBuilder.put((Object)"job", (Object)this.job);
                    }
                    if (this.taskGroup != null) {
                        fieldMapBuilder.put((Object)"task_group", (Object)this.taskGroup);
                    }
                    if (this.task != null) {
                        fieldMapBuilder.put((Object)"task", (Object)this.task);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_JOB_TASK_GROUP_TASK.instantiate(new String[]{"project", this.project, "location", this.location, "job", this.job, "task_group", this.taskGroup, "task", this.task});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            TaskName that = (TaskName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.job, that.job) && Objects.equals(this.taskGroup, that.taskGroup) && Objects.equals(this.task, that.task);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.job);
        h *= 1000003;
        h ^= Objects.hashCode(this.taskGroup);
        h *= 1000003;
        return h ^= Objects.hashCode(this.task);
    }

    public static class Builder {
        private String project;
        private String location;
        private String job;
        private String taskGroup;
        private String task;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getJob() {
            return this.job;
        }

        public String getTaskGroup() {
            return this.taskGroup;
        }

        public String getTask() {
            return this.task;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setJob(String job) {
            this.job = job;
            return this;
        }

        public Builder setTaskGroup(String taskGroup) {
            this.taskGroup = taskGroup;
            return this;
        }

        public Builder setTask(String task) {
            this.task = task;
            return this;
        }

        private Builder(TaskName taskName) {
            this.project = taskName.project;
            this.location = taskName.location;
            this.job = taskName.job;
            this.taskGroup = taskName.taskGroup;
            this.task = taskName.task;
        }

        public TaskName build() {
            return new TaskName(this);
        }
    }
}

