/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.baremetalsolution.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SnapshotSchedulePolicyName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SNAPSHOT_SCHEDULE_POLICY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/snapshotSchedulePolicies/{snapshot_schedule_policy}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String snapshotSchedulePolicy;

    @Deprecated
    protected SnapshotSchedulePolicyName() {
        this.project = null;
        this.location = null;
        this.snapshotSchedulePolicy = null;
    }

    private SnapshotSchedulePolicyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.snapshotSchedulePolicy = (String)Preconditions.checkNotNull((Object)builder.getSnapshotSchedulePolicy());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSnapshotSchedulePolicy() {
        return this.snapshotSchedulePolicy;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SnapshotSchedulePolicyName of(String project, String location, String snapshotSchedulePolicy) {
        return SnapshotSchedulePolicyName.newBuilder().setProject(project).setLocation(location).setSnapshotSchedulePolicy(snapshotSchedulePolicy).build();
    }

    public static String format(String project, String location, String snapshotSchedulePolicy) {
        return SnapshotSchedulePolicyName.newBuilder().setProject(project).setLocation(location).setSnapshotSchedulePolicy(snapshotSchedulePolicy).build().toString();
    }

    public static SnapshotSchedulePolicyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SNAPSHOT_SCHEDULE_POLICY.validatedMatch(formattedString, "SnapshotSchedulePolicyName.parse: formattedString not in valid format");
        return SnapshotSchedulePolicyName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("snapshot_schedule_policy"));
    }

    public static List<SnapshotSchedulePolicyName> parseList(List<String> formattedStrings) {
        ArrayList<SnapshotSchedulePolicyName> list = new ArrayList<SnapshotSchedulePolicyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SnapshotSchedulePolicyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SnapshotSchedulePolicyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SnapshotSchedulePolicyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SNAPSHOT_SCHEDULE_POLICY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SnapshotSchedulePolicyName snapshotSchedulePolicyName = this;
            synchronized (snapshotSchedulePolicyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.snapshotSchedulePolicy != null) {
                        fieldMapBuilder.put((Object)"snapshot_schedule_policy", (Object)this.snapshotSchedulePolicy);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SNAPSHOT_SCHEDULE_POLICY.instantiate(new String[]{"project", this.project, "location", this.location, "snapshot_schedule_policy", this.snapshotSchedulePolicy});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            SnapshotSchedulePolicyName that = (SnapshotSchedulePolicyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.snapshotSchedulePolicy, that.snapshotSchedulePolicy);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.snapshotSchedulePolicy);
    }

    public static class Builder {
        private String project;
        private String location;
        private String snapshotSchedulePolicy;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSnapshotSchedulePolicy() {
            return this.snapshotSchedulePolicy;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSnapshotSchedulePolicy(String snapshotSchedulePolicy) {
            this.snapshotSchedulePolicy = snapshotSchedulePolicy;
            return this;
        }

        private Builder(SnapshotSchedulePolicyName snapshotSchedulePolicyName) {
            this.project = snapshotSchedulePolicyName.project;
            this.location = snapshotSchedulePolicyName.location;
            this.snapshotSchedulePolicy = snapshotSchedulePolicyName.snapshotSchedulePolicy;
        }

        public SnapshotSchedulePolicyName build() {
            return new SnapshotSchedulePolicyName(this);
        }
    }
}

