/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.backupdr.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ManagementServerName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_MANAGEMENTSERVER = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/managementServers/{managementserver}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String managementserver;

    @Deprecated
    protected ManagementServerName() {
        this.project = null;
        this.location = null;
        this.managementserver = null;
    }

    private ManagementServerName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.managementserver = (String)Preconditions.checkNotNull((Object)builder.getManagementserver());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getManagementserver() {
        return this.managementserver;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ManagementServerName of(String project, String location, String managementserver) {
        return ManagementServerName.newBuilder().setProject(project).setLocation(location).setManagementserver(managementserver).build();
    }

    public static String format(String project, String location, String managementserver) {
        return ManagementServerName.newBuilder().setProject(project).setLocation(location).setManagementserver(managementserver).build().toString();
    }

    public static ManagementServerName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_MANAGEMENTSERVER.validatedMatch(formattedString, "ManagementServerName.parse: formattedString not in valid format");
        return ManagementServerName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("managementserver"));
    }

    public static List<ManagementServerName> parseList(List<String> formattedStrings) {
        ArrayList<ManagementServerName> list = new ArrayList<ManagementServerName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ManagementServerName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ManagementServerName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ManagementServerName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_MANAGEMENTSERVER.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ManagementServerName managementServerName = this;
            synchronized (managementServerName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.managementserver != null) {
                        fieldMapBuilder.put((Object)"managementserver", (Object)this.managementserver);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_MANAGEMENTSERVER.instantiate(new String[]{"project", this.project, "location", this.location, "managementserver", this.managementserver});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ManagementServerName that = (ManagementServerName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.managementserver, that.managementserver);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.managementserver);
    }

    public static class Builder {
        private String project;
        private String location;
        private String managementserver;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getManagementserver() {
            return this.managementserver;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setManagementserver(String managementserver) {
            this.managementserver = managementserver;
            return this;
        }

        private Builder(ManagementServerName managementServerName) {
            this.project = managementServerName.project;
            this.location = managementServerName.location;
            this.managementserver = managementServerName.managementserver;
        }

        public ManagementServerName build() {
            return new ManagementServerName(this);
        }
    }
}

