/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.automl.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ModelEvaluationName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_MODEL_MODEL_EVALUATION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/models/{model}/modelEvaluations/{model_evaluation}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String model;
    private final String modelEvaluation;

    @Deprecated
    protected ModelEvaluationName() {
        this.project = null;
        this.location = null;
        this.model = null;
        this.modelEvaluation = null;
    }

    private ModelEvaluationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.model = (String)Preconditions.checkNotNull((Object)builder.getModel());
        this.modelEvaluation = (String)Preconditions.checkNotNull((Object)builder.getModelEvaluation());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getModel() {
        return this.model;
    }

    public String getModelEvaluation() {
        return this.modelEvaluation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ModelEvaluationName of(String project, String location, String model, String modelEvaluation) {
        return ModelEvaluationName.newBuilder().setProject(project).setLocation(location).setModel(model).setModelEvaluation(modelEvaluation).build();
    }

    public static String format(String project, String location, String model, String modelEvaluation) {
        return ModelEvaluationName.newBuilder().setProject(project).setLocation(location).setModel(model).setModelEvaluation(modelEvaluation).build().toString();
    }

    public static ModelEvaluationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_MODEL_MODEL_EVALUATION.validatedMatch(formattedString, "ModelEvaluationName.parse: formattedString not in valid format");
        return ModelEvaluationName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("model"), (String)matchMap.get("model_evaluation"));
    }

    public static List<ModelEvaluationName> parseList(List<String> formattedStrings) {
        ArrayList<ModelEvaluationName> list = new ArrayList<ModelEvaluationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ModelEvaluationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ModelEvaluationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ModelEvaluationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_MODEL_MODEL_EVALUATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ModelEvaluationName modelEvaluationName = this;
            synchronized (modelEvaluationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.model != null) {
                        fieldMapBuilder.put((Object)"model", (Object)this.model);
                    }
                    if (this.modelEvaluation != null) {
                        fieldMapBuilder.put((Object)"model_evaluation", (Object)this.modelEvaluation);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_MODEL_MODEL_EVALUATION.instantiate(new String[]{"project", this.project, "location", this.location, "model", this.model, "model_evaluation", this.modelEvaluation});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ModelEvaluationName that = (ModelEvaluationName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.model, that.model) && Objects.equals(this.modelEvaluation, that.modelEvaluation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.model);
        h *= 1000003;
        return h ^= Objects.hashCode(this.modelEvaluation);
    }

    public static class Builder {
        private String project;
        private String location;
        private String model;
        private String modelEvaluation;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getModel() {
            return this.model;
        }

        public String getModelEvaluation() {
            return this.modelEvaluation;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setModel(String model) {
            this.model = model;
            return this;
        }

        public Builder setModelEvaluation(String modelEvaluation) {
            this.modelEvaluation = modelEvaluation;
            return this;
        }

        private Builder(ModelEvaluationName modelEvaluationName) {
            this.project = modelEvaluationName.project;
            this.location = modelEvaluationName.location;
            this.model = modelEvaluationName.model;
            this.modelEvaluation = modelEvaluationName.modelEvaluation;
        }

        public ModelEvaluationName build() {
            return new ModelEvaluationName(this);
        }
    }
}

